/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.temporal;

import java.util.ArrayList;
import java.util.List;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeAmount;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeConstraint;
import org.drools.model.DSL;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeVariable;
import org.drools.model.view.ViewItem;

public class TimeWindowDefinition
implements TimeConstraint {
    private final TimeAmount timeAmount;
    private final List<PrototypeVariable> formerVariables = new ArrayList<PrototypeVariable>();

    private TimeWindowDefinition(TimeAmount timeAmount) {
        this.timeAmount = timeAmount;
    }

    @Override
    public boolean requiresAsyncExecution() {
        return false;
    }

    public static TimeWindowDefinition parseTimeWindow(String timeWindow) {
        return new TimeWindowDefinition(TimeAmount.parseTimeAmount(timeWindow));
    }

    @Override
    public ViewItem processTimeConstraint(String ruleName, ViewItem pattern) {
        PrototypeDSL.PrototypePatternDef protoPattern = (PrototypeDSL.PrototypePatternDef)pattern;
        this.formerVariables.forEach(v -> protoPattern.expr(DSL.after(-this.timeAmount.getAmount(), this.timeAmount.getTimeUnit(), this.timeAmount.getAmount(), this.timeAmount.getTimeUnit()), (PrototypeVariable)v));
        this.formerVariables.add((PrototypeVariable)protoPattern.getFirstVariable());
        return protoPattern;
    }
}

