/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.temporal;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.temporal.OnceAbstractTimeConstraint;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeAmount;
import org.drools.ansible.rulebook.integration.api.rulesmodel.PrototypeFactory;
import org.drools.core.facttemplates.Event;
import org.drools.core.facttemplates.Fact;
import org.drools.model.Condition;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.DroolsEntryPoint;
import org.drools.model.PatternDSL;
import org.drools.model.PrototypeDSL;
import org.drools.model.Rule;
import org.drools.model.Variable;
import org.drools.model.view.CombinedExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.drools.modelcompiler.facttemplate.FactFactory;

public class OnceWithinDefinition
extends OnceAbstractTimeConstraint {
    public static final String KEYWORD = "once_within";

    public OnceWithinDefinition(TimeAmount timeAmount, List<String> groupByAttributes) {
        super(timeAmount, groupByAttributes);
    }

    @Override
    public boolean requiresAsyncExecution() {
        return false;
    }

    @Override
    public Variable<?>[] getTimeConstraintConsequenceVariables() {
        return new Variable[]{this.getPatternVariable()};
    }

    @Override
    public void executeTimeConstraintConsequence(Drools drools, Object ... facts) {
        Event controlEvent = FactFactory.createMapBasedEvent(PrototypeFactory.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE")).withExpiration(this.timeAmount.getAmount(), this.timeAmount.getTimeUnit());
        Fact fact = (Fact)facts[0];
        for (String unique : this.groupByAttributes) {
            controlEvent.set(unique, fact.get(unique));
        }
        controlEvent.set("drools_rule_name", this.ruleName);
        drools.insert(controlEvent);
        drools.delete(fact);
    }

    @Override
    public ViewItem processTimeConstraint(String ruleName, ViewItem pattern) {
        this.ruleName = ruleName;
        if (this.guardedPattern != null) {
            throw new IllegalStateException("Cannot process this TimeConstraint twice");
        }
        this.guardedPattern = (PrototypeDSL.PrototypePatternDef)pattern;
        return new CombinedExprViewItem(Condition.Type.AND, new ViewItem[]{this.guardedPattern, DSL.not(this.createControlPattern(), new ViewItemBuilder[0])});
    }

    @Override
    public List<Rule> getControlRules(RuleGenerationContext ruleContext) {
        return Collections.singletonList(PatternDSL.rule("cleanup_" + this.ruleName).metadata("SYNTHETIC_RULE", true).build(this.guardedPattern, this.createControlPattern(), DSL.on(this.getPatternVariable()).execute(DroolsEntryPoint::delete)));
    }

    public String toString() {
        return "OnceWithinDefinition{ " + this.timeAmount + ", groupByAttributes=" + this.groupByAttributes + " }";
    }

    public static OnceWithinDefinition parseOnceWithin(String onceWithin, List<String> groupByAttributes) {
        List<String> sanitizedAttributes = groupByAttributes.stream().map(OnceAbstractTimeConstraint::sanitizeAttributeName).collect(Collectors.toList());
        return new OnceWithinDefinition(TimeAmount.parseTimeAmount(onceWithin), sanitizedAttributes);
    }
}

