/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.temporal;

import java.util.List;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeAmount;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeConstraint;
import org.drools.ansible.rulebook.integration.api.rulesmodel.PrototypeFactory;
import org.drools.model.ConstraintOperator;
import org.drools.model.Index;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeExpression;
import org.drools.model.PrototypeVariable;

public abstract class OnceAbstractTimeConstraint
implements TimeConstraint {
    protected String ruleName;
    protected final TimeAmount timeAmount;
    protected final List<String> groupByAttributes;
    protected PrototypeDSL.PrototypePatternDef guardedPattern;

    public OnceAbstractTimeConstraint(TimeAmount timeAmount, List<String> groupByAttributes) {
        this.timeAmount = timeAmount;
        this.groupByAttributes = groupByAttributes;
    }

    protected PrototypeVariable getPatternVariable() {
        return (PrototypeVariable)this.guardedPattern.getFirstVariable();
    }

    protected PrototypeDSL.PrototypePatternDef createControlPattern() {
        PrototypeDSL.PrototypePatternDef controlPattern = PrototypeDSL.protoPattern(PrototypeDSL.variable(PrototypeFactory.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE")));
        for (String unique : this.groupByAttributes) {
            controlPattern.expr(PrototypeExpression.prototypeField(unique), (ConstraintOperator)Index.ConstraintType.EQUAL, this.getPatternVariable(), PrototypeExpression.prototypeField(unique));
        }
        controlPattern.expr(PrototypeExpression.prototypeField("drools_rule_name"), (ConstraintOperator)Index.ConstraintType.EQUAL, PrototypeExpression.fixedValue(this.ruleName));
        return controlPattern;
    }

    static String sanitizeAttributeName(String name) {
        if (name.startsWith("event.")) {
            return name.substring("event.".length());
        }
        if (name.startsWith("events.")) {
            return name.substring("events.".length());
        }
        if (name.startsWith("fact.")) {
            return name.substring("fact.".length());
        }
        if (name.startsWith("facts.")) {
            return name.substring("facts.".length());
        }
        return name;
    }
}

