/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.constraints;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionExpression;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionParseUtil;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ConditionFactory;
import org.drools.ansible.rulebook.integration.api.domain.constraints.Operators;
import org.drools.ansible.rulebook.integration.api.rulesmodel.ParsedCondition;
import org.drools.core.facttemplates.Fact;
import org.drools.model.ConstraintOperator;
import org.drools.model.Prototype;
import org.drools.model.PrototypeExpression;

public enum SelectAttrConstraint implements ConstraintOperator,
ConditionFactory
{
    INSTANCE;

    public static final String EXPRESSION_NAME = "SelectAttrExpression";
    public static final String NEGATED_EXPRESSION_NAME = "SelectAttrNotExpression";

    @Override
    public <T, V> BiPredicate<T, V> asPredicate() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SELECT_ATTR";
    }

    @Override
    public ParsedCondition createParsedCondition(RuleGenerationContext ruleContext, String expressionName, Map<?, ?> expression) {
        return SelectAttrConstraint.createSelectCondition(ruleContext, expression, expressionName.equals(EXPRESSION_NAME), true);
    }

    static ParsedCondition createSelectCondition(RuleGenerationContext ruleContext, Map<?, ?> expression, boolean positive, boolean withKey) {
        Object rhsValue;
        Map rhs = (Map)expression.get("rhs");
        BiPredicate<?, ?> opPred = Operators.toOperatorPredicate(SelectAttrConstraint.mapToStringValue(rhs.get("operator")));
        if (!withKey && (rhsValue = rhs.get("value")) instanceof Map && ConditionParseUtil.isEventOrFact(((Map)rhsValue).keySet().iterator().next().toString())) {
            return SelectAttrConstraint.createSelectConditionWithLeftAndRightFields(expression, opPred, rhsValue, positive);
        }
        ConditionExpression left = ConditionExpression.map2Expr(ruleContext, expression.get("lhs"));
        return withKey ? SelectAttrConstraint.createSelectAttrCondition(left, opPred, rhs, positive) : SelectAttrConstraint.createSelectConditionWithFixedRight(left, opPred, rhs.get("value"), positive);
    }

    private static ParsedCondition createSelectConditionWithLeftAndRightFields(Map<?, ?> expression, BiPredicate opPred, Object rhsValue, boolean positive) {
        String leftField = SelectAttrConstraint.mapToStringValue(expression.get("lhs"));
        String rightField = SelectAttrConstraint.mapToStringValue(rhsValue);
        SelectFieldOperator operator = new SelectFieldOperator(f -> ((Fact)f).get(leftField), opPred, f -> ((Fact)f).get(rightField));
        return new ParsedCondition(PrototypeExpression.thisPrototype(), (ConstraintOperator)operator, PrototypeExpression.fixedValue(positive));
    }

    private static ParsedCondition createSelectConditionWithFixedRight(ConditionExpression left, BiPredicate opPred, Object rhsValue, boolean positive) {
        SelectAttrOperator operator = new SelectAttrOperator(opPred, ConditionParseUtil.toJsonValue(rhsValue));
        return new ParsedCondition(left.getPrototypeExpression(), (ConstraintOperator)operator, PrototypeExpression.fixedValue(positive));
    }

    private static ParsedCondition createSelectAttrCondition(ConditionExpression left, BiPredicate opPred, Map<?, ?> rhs, boolean positive) {
        String key = SelectAttrConstraint.mapToStringValue(rhs.get("key"));
        Object value = ConditionParseUtil.toJsonValue(rhs.get("value"));
        SelectAttrOperator operator = new SelectAttrOperator(m -> ConditionParseUtil.extractMapAttribute((Map)m, key), opPred, value);
        return new ParsedCondition(left.getPrototypeExpression(), (ConstraintOperator)operator, PrototypeExpression.fixedValue(positive));
    }

    private static String mapToStringValue(Object rhsValue) {
        Map rhsMap = (Map)rhsValue;
        if (rhsMap.size() != 1) {
            throw new UnsupportedOperationException("The map " + rhsMap + " must have exactly 1 entry");
        }
        return rhsMap.entrySet().iterator().next().getValue().toString().trim();
    }

    public static class SelectFieldOperator
    implements ConstraintOperator {
        private final Function leftExtractor;
        private final BiPredicate opPred;
        private final Function rightExtractor;

        public SelectFieldOperator(Function leftExtractor, BiPredicate opPred, Function rightExtractor) {
            this.leftExtractor = leftExtractor;
            this.opPred = opPred;
            this.rightExtractor = rightExtractor;
        }

        @Override
        public <T, V> BiPredicate<T, V> asPredicate() {
            return (t, v) -> {
                Object leftValue = this.leftExtractor.apply(t);
                Object rightValue = this.rightExtractor.apply(t);
                if (leftValue instanceof Collection) {
                    return (Boolean)v != false ? ((Collection)leftValue).stream().anyMatch(x -> this.opPred.test(x, rightValue)) : !((Collection)leftValue).stream().allMatch(x -> this.opPred.test(x, rightValue));
                }
                return leftValue != Prototype.UNDEFINED_VALUE && this.opPred.test(leftValue, rightValue) == ((Boolean)v).booleanValue();
            };
        }
    }

    public static class SelectAttrOperator
    implements ConstraintOperator {
        private final Function leftExtractor;
        private final BiPredicate opPred;
        private final Object rightValue;

        public SelectAttrOperator(BiPredicate opPred, Object rightValue) {
            this(Function.identity(), opPred, rightValue);
        }

        public SelectAttrOperator(Function leftExtractor, BiPredicate opPred, Object rightValue) {
            this.leftExtractor = leftExtractor;
            this.opPred = opPred;
            this.rightValue = rightValue;
        }

        @Override
        public <T, V> BiPredicate<T, V> asPredicate() {
            return (t, v) -> {
                if (t instanceof Collection) {
                    return (Boolean)v != false ? ((Collection)t).stream().anyMatch(left -> this.opPred.test(this.leftExtractor.apply(left), this.rightValue)) : !((Collection)t).stream().allMatch(left -> this.opPred.test(this.leftExtractor.apply(left), this.rightValue));
                }
                Object leftValue = this.leftExtractor.apply(t);
                return leftValue != Prototype.UNDEFINED_VALUE && this.opPred.test(leftValue, this.rightValue) == ((Boolean)v).booleanValue();
            };
        }
    }
}

