/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.constraints;

import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionExpression;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionParseUtil;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ConditionFactory;
import org.drools.ansible.rulebook.integration.api.rulesmodel.ParsedCondition;
import org.drools.model.ConstraintOperator;
import org.drools.model.PrototypeExpression;

public enum SearchMatchesConstraint implements ConstraintOperator,
ConditionFactory
{
    INSTANCE;

    public static final String EXPRESSION_NAME = "SearchMatchesExpression";
    public static final String NEGATED_EXPRESSION_NAME = "SearchNotMatchesExpression";

    @Override
    public <T, V> BiPredicate<T, V> asPredicate() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SEARCH_MATCHES";
    }

    @Override
    public ParsedCondition createParsedCondition(RuleGenerationContext ruleContext, String expressionName, Map<?, ?> expression) {
        ConditionExpression lhs = ConditionExpression.map2Expr(ruleContext, expression.get("lhs"));
        Map searchType = (Map)((Map)expression.get("rhs")).get("SearchType");
        boolean positive = expressionName.equals(EXPRESSION_NAME);
        return lhs.isFixedValue() ? this.createConditionWithFixedLeft(ruleContext, lhs.getFixedValue().toString(), searchType, positive) : this.createConditionWithFixedRight(lhs, searchType, positive);
    }

    private ParsedCondition createConditionWithFixedRight(ConditionExpression lhs, Map searchType, boolean positive) {
        int options = SearchMatchesConstraint.parseOptions(searchType);
        String pattern = ((Map)searchType.get("pattern")).get("String").toString();
        RegexConstraint operator = new RegexConstraint((String)SearchMatchesConstraint.getPatternTransformerForKind(searchType, options).apply(pattern), options);
        return new ParsedCondition(lhs.getPrototypeExpression(), (ConstraintOperator)operator, PrototypeExpression.fixedValue(positive));
    }

    private ParsedCondition createConditionWithFixedLeft(RuleGenerationContext ruleContext, String pattern, Map searchType, boolean positive) {
        int options = SearchMatchesConstraint.parseOptions(searchType);
        InvertedRegexConstraint operator = new InvertedRegexConstraint(pattern, options, SearchMatchesConstraint.getPatternTransformerForKind(searchType, options));
        return new ParsedCondition(ConditionExpression.map2Expr(ruleContext, searchType.get("pattern")).getPrototypeExpression(), (ConstraintOperator)operator, PrototypeExpression.fixedValue(positive));
    }

    private static UnaryOperator<String> getPatternTransformerForKind(Map searchType, int options) {
        String kind = ((Map)searchType.get("kind")).get("String").toString();
        if (!ConditionParseUtil.isRegexOperator(kind)) {
            throw new UnsupportedOperationException("Unknown kind: " + kind);
        }
        if (kind.equals("match")) {
            return pattern -> ((options | 8) != 0 ? "^" : "\\A") + pattern;
        }
        return UnaryOperator.identity();
    }

    private static int parseOptions(Map searchType) {
        int flags = 0;
        List options = (List)searchType.get("options");
        if (options != null) {
            block8: for (Map option : options) {
                String optionName = ((Map)option.get("name")).get("String").toString();
                String optionValue = ((Map)option.get("value")).get("Boolean").toString();
                if (!optionValue.equalsIgnoreCase("true")) continue;
                switch (optionName) {
                    case "ignorecase": {
                        flags += 2;
                        continue block8;
                    }
                    case "multiline": {
                        flags += 8;
                        continue block8;
                    }
                }
                throw new UnsupportedOperationException("Unknown option: " + optionName);
            }
        }
        return flags;
    }

    public static class InvertedRegexConstraint
    implements ConstraintOperator {
        private final String pattern;
        private final int flags;
        private final UnaryOperator<String> patternTransformer;

        public InvertedRegexConstraint(String pattern, int flags, UnaryOperator<String> patternTransformer) {
            this.pattern = pattern;
            this.flags = flags;
            this.patternTransformer = patternTransformer;
        }

        @Override
        public <T, V> BiPredicate<T, V> asPredicate() {
            return (t, v) -> t != null && Pattern.compile((String)this.patternTransformer.apply(t.toString()), this.flags).matcher(this.pattern).find() == ((Boolean)v).booleanValue();
        }
    }

    public static class RegexConstraint
    implements ConstraintOperator {
        private final Pattern regexPattern;

        public RegexConstraint(String pattern, int flags) {
            this.regexPattern = Pattern.compile(pattern, flags);
        }

        @Override
        public <T, V> BiPredicate<T, V> asPredicate() {
            return (t, v) -> t != null && this.regexPattern.matcher(t.toString()).find() == ((Boolean)v).booleanValue();
        }
    }
}

