/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.conditions;

import java.util.ArrayList;
import java.util.List;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.conditions.Condition;
import org.drools.ansible.rulebook.integration.api.domain.temporal.OnceWithinDefinition;
import org.drools.ansible.rulebook.integration.api.rulesmodel.ParsedCondition;
import org.drools.model.Condition;
import org.drools.model.ConstraintOperator;
import org.drools.model.Index;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeExpression;
import org.drools.model.view.CombinedExprViewItem;
import org.drools.model.view.ViewItem;

public class AstCondition
implements Condition {
    private final RuleGenerationContext ruleContext;
    private Condition rootCondition;

    public AstCondition(RuleGenerationContext ruleContext) {
        this.ruleContext = ruleContext;
    }

    public AllCondition all() {
        AllCondition allCondition = new AllCondition(this.ruleContext);
        this.rootCondition = allCondition;
        return allCondition;
    }

    public AnyCondition any() {
        AnyCondition anyCondition = new AnyCondition(this.ruleContext);
        this.rootCondition = anyCondition;
        return anyCondition;
    }

    @Override
    public ViewItem toPattern(RuleGenerationContext ruleContext) {
        return this.rootCondition.toPattern(ruleContext);
    }

    public static class SingleCondition<P extends MultipleConditions>
    extends PatternCondition {
        private final P parent;
        private final ParsedCondition parsedCondition;
        private RuleGenerationContext ruleContext;

        public SingleCondition(P parent, PrototypeExpression left, Index.ConstraintType operator, PrototypeExpression right) {
            this(parent, new ParsedCondition(left, (ConstraintOperator)operator, right));
        }

        public SingleCondition(P parent, ParsedCondition parsedCondition) {
            this.parent = parent;
            this.parsedCondition = parsedCondition;
        }

        void setRuleContext(RuleGenerationContext ruleContext) {
            this.ruleContext = ruleContext;
        }

        public SingleCondition withPatternBinding(String patternBinding) {
            return this.withPatternBinding(this.ruleContext, patternBinding);
        }

        SingleCondition withPatternBinding(RuleGenerationContext ruleContext, String patternBinding) {
            if (this.parent != null) {
                ((MultipleConditions)this.parent).beforeBinding();
            }
            this.pattern = ruleContext.getOrCreatePattern(patternBinding, "DROOLS_PROTOTYPE");
            if (this.parent != null) {
                ((MultipleConditions)this.parent).afterBinding();
            }
            return this;
        }

        @Override
        public ViewItem toPattern(RuleGenerationContext ruleContext) {
            ViewItem pattern = this.addConditionToPattern(ruleContext, this.getPattern(ruleContext));
            return this.processTimeConstraint(ruleContext, pattern);
        }

        @Override
        public ViewItem addConditionToPattern(RuleGenerationContext ruleContext, PrototypeDSL.PrototypePatternDef pattern) {
            return this.parsedCondition.addConditionToPattern(ruleContext, pattern);
        }

        @Override
        public PatternCondition negate(RuleGenerationContext ruleContext) {
            this.parsedCondition.negate();
            return this;
        }

        public SingleCondition<P> addSingleCondition(PrototypeExpression left, Index.ConstraintType operator, PrototypeExpression right) {
            return ((MultipleConditions)this.parent).addSingleCondition(left, operator, right);
        }
    }

    public static class OrCondition
    extends CombinedPatternCondition {
        public OrCondition(String binding) {
            super(binding);
        }

        @Override
        public ViewItem toPattern(RuleGenerationContext ruleContext) {
            PrototypeDSL.PrototypePatternDef pattern = this.getPattern(ruleContext, this.binding);
            this.addConditionToPattern(ruleContext, pattern);
            return this.processTimeConstraint(ruleContext, pattern);
        }

        @Override
        public ViewItem addConditionToPattern(RuleGenerationContext ruleContext, PrototypeDSL.PrototypePatternDef pattern) {
            pattern = pattern.or();
            PrototypeDSL.PrototypePatternDef p1 = pattern.and();
            this.lhs.addConditionToPattern(ruleContext, p1);
            p1.endAnd();
            PrototypeDSL.PrototypePatternDef p2 = pattern.and();
            this.rhs.addConditionToPattern(ruleContext, p2);
            p2.endAnd();
            pattern = (PrototypeDSL.PrototypePatternDef)pattern.endOr();
            return pattern;
        }

        @Override
        public PatternCondition negate(RuleGenerationContext ruleContext) {
            return new AndCondition(this.binding).withLhs(this.lhs.negate(ruleContext)).withRhs(this.rhs.negate(ruleContext));
        }
    }

    public static class AndCondition
    extends CombinedPatternCondition {
        public AndCondition(String binding) {
            super(binding);
        }

        @Override
        public ViewItem toPattern(RuleGenerationContext ruleContext) {
            PrototypeDSL.PrototypePatternDef pattern = this.getPattern(ruleContext, this.binding);
            this.addConditionToPattern(ruleContext, pattern);
            return this.processTimeConstraint(ruleContext, pattern);
        }

        @Override
        public ViewItem addConditionToPattern(RuleGenerationContext ruleContext, PrototypeDSL.PrototypePatternDef pattern) {
            this.lhs.addConditionToPattern(ruleContext, pattern);
            return this.rhs.addConditionToPattern(ruleContext, pattern);
        }

        @Override
        public PatternCondition negate(RuleGenerationContext ruleContext) {
            return new OrCondition(this.binding).withLhs(this.lhs.negate(ruleContext)).withRhs(this.rhs.negate(ruleContext));
        }
    }

    public static abstract class CombinedPatternCondition
    extends PatternCondition {
        protected final String binding;
        protected PatternCondition lhs;
        protected PatternCondition rhs;

        protected CombinedPatternCondition(String binding) {
            this.binding = binding;
        }

        public CombinedPatternCondition withLhs(PatternCondition condition) {
            this.lhs = condition;
            return this;
        }

        public CombinedPatternCondition withRhs(PatternCondition condition) {
            this.rhs = condition;
            return this;
        }
    }

    public static abstract class PatternCondition
    implements Condition {
        protected PrototypeDSL.PrototypePatternDef pattern;

        abstract ViewItem addConditionToPattern(RuleGenerationContext var1, PrototypeDSL.PrototypePatternDef var2);

        abstract PatternCondition negate(RuleGenerationContext var1);

        protected ViewItem processTimeConstraint(RuleGenerationContext ruleContext, ViewItem pattern) {
            return ruleContext.getTimeConstraint().map(tc -> tc.processTimeConstraint(ruleContext.getRuleName(), pattern)).orElse(pattern);
        }

        protected PrototypeDSL.PrototypePatternDef getPattern(RuleGenerationContext ruleContext) {
            return this.pattern != null ? this.pattern : this.getPattern(ruleContext, ruleContext.generateBinding());
        }

        protected PrototypeDSL.PrototypePatternDef getPattern(RuleGenerationContext ruleContext, String binding) {
            if (this.pattern == null) {
                this.pattern = ruleContext.getOrCreatePattern(binding, "DROOLS_PROTOTYPE");
            }
            return this.pattern;
        }
    }

    public static class AnyCondition
    extends MultipleConditions<AnyCondition> {
        public AnyCondition(RuleGenerationContext ruleContext) {
            super(ruleContext);
        }

        @Override
        protected Condition.Type getConditionType() {
            return Condition.Type.OR;
        }

        @Override
        protected void beforeBinding() {
            this.ruleContext.pushContext();
        }

        @Override
        protected void afterBinding() {
            this.ruleContext.popContext();
        }
    }

    public static class AllCondition
    extends MultipleConditions<AllCondition> {
        public AllCondition(RuleGenerationContext ruleContext) {
            super(ruleContext);
        }

        @Override
        protected Condition.Type getConditionType() {
            return Condition.Type.AND;
        }
    }

    public static abstract class MultipleConditions<T extends MultipleConditions>
    implements Condition {
        protected final RuleGenerationContext ruleContext;
        protected final List<Condition> conditions = new ArrayList<Condition>();

        public MultipleConditions(RuleGenerationContext ruleContext) {
            this.ruleContext = ruleContext;
        }

        protected abstract Condition.Type getConditionType();

        @Override
        public ViewItem toPattern(RuleGenerationContext ruleContext) {
            if (this.conditions.size() == 1) {
                return this.conditions.get(0).toPattern(ruleContext);
            }
            if (ruleContext.getTimeConstraint().map(tc -> tc instanceof OnceWithinDefinition).orElse(false).booleanValue()) {
                throw new IllegalArgumentException("once_within is only allowed with a single event");
            }
            return new CombinedExprViewItem(this.getConditionType(), (ViewItem[])this.conditions.stream().map(subC -> subC.toPattern(ruleContext)).toArray(ViewItem[]::new));
        }

        public MultipleConditions addCondition(Condition condition) {
            this.conditions.add(condition);
            return this;
        }

        public SingleCondition<T> addSingleCondition(PrototypeExpression left, Index.ConstraintType operator, PrototypeExpression right) {
            SingleCondition<MultipleConditions> singleCondition = new SingleCondition<MultipleConditions>(this, left, operator, right);
            singleCondition.setRuleContext(this.ruleContext);
            this.conditions.add(singleCondition);
            return singleCondition;
        }

        protected void beforeBinding() {
        }

        protected void afterBinding() {
        }
    }
}

