/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.ansible.rulebook.integration.api.domain.actions.Action;
import org.drools.ansible.rulebook.integration.api.domain.actions.AssertFact;
import org.drools.ansible.rulebook.integration.api.domain.actions.FactAction;
import org.drools.ansible.rulebook.integration.api.domain.actions.PostEvent;
import org.drools.ansible.rulebook.integration.api.domain.actions.RetractFact;
import org.drools.ansible.rulebook.integration.api.domain.actions.RunPlaybook;
import org.drools.model.Drools;

public class MapAction
extends HashMap
implements Action {
    private final List<Action> knownActions = new ArrayList<Action>();

    @Override
    public Object put(Object key, Object value) {
        switch (key.toString()) {
            case "assert_fact": 
            case "retract_fact": 
            case "post_event": {
                String ruleset = (String)((Map)value).get("ruleset");
                Map fact = (Map)((Map)value).get("fact");
                if (ruleset == null || fact == null) break;
                FactAction factAction = this.createFactAction(key);
                factAction.setRuleset(ruleset);
                factAction.setFact(fact);
                this.knownActions.add(factAction);
                break;
            }
            case "run_playbook": {
                for (Map playbook : (Collection)value) {
                    String name = (String)playbook.get("name");
                    if (name == null) continue;
                    RunPlaybook runPlaybook = new RunPlaybook();
                    runPlaybook.setName(name);
                    this.knownActions.add(runPlaybook);
                }
                break;
            }
        }
        return super.put(key, value);
    }

    private FactAction createFactAction(Object key) {
        if (key.toString().equals("retract_fact")) {
            return new RetractFact();
        }
        if (key.toString().equals("post_event")) {
            return new PostEvent();
        }
        return new AssertFact();
    }

    @Override
    public void execute(Drools drools) {
        this.knownActions.forEach((? super T a) -> a.execute(drools));
    }
}

