/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOption;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOptions;
import org.drools.ansible.rulebook.integration.api.domain.Rule;
import org.drools.ansible.rulebook.integration.api.domain.RuleContainer;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeAmount;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutionController;
import org.drools.model.Model;
import org.drools.model.impl.ModelImpl;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RulesSet {
    private String name;
    private List<String> hosts;
    private List<RuleContainer> rules;
    private TimeAmount clockPeriod;
    private final RuleConfigurationOptions options = new RuleConfigurationOptions();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public Model toExecModel(RulesExecutionController rulesExecutionController) {
        AtomicInteger ruleCounter = new AtomicInteger(0);
        ModelImpl model = new ModelImpl();
        this.rules.stream().map(RuleContainer::getRule).map(r -> r.withOptions(this.options)).flatMap(rule -> rule.toExecModelRules(this, rulesExecutionController, ruleCounter).stream()).forEach(model::addRule);
        return model;
    }

    public void setRules(List<RuleContainer> rules) {
        this.rules = rules;
    }

    public Rule addRule() {
        return this.addRule(null);
    }

    public Rule addRule(String name) {
        Rule rule = new Rule().withOptions(this.options);
        rule.setName(name);
        RuleContainer ruleContainer = new RuleContainer();
        ruleContainer.setRule(rule);
        if (this.rules == null) {
            this.rules = new ArrayList<RuleContainer>();
        }
        this.rules.add(ruleContainer);
        return rule;
    }

    public boolean hasOption(RuleConfigurationOption option) {
        return this.options != null && this.options.hasOption(option);
    }

    public RulesSet withOptions(RuleConfigurationOption ... options) {
        this.options.addOptions(options);
        return this;
    }

    public void setClock_period(String clockPeriod) {
        this.clockPeriod = TimeAmount.parseTimeAmount(clockPeriod);
        this.options.addOptions(RuleConfigurationOption.USE_PSEUDO_CLOCK);
    }

    public void setClockPeriod(int amount, TimeUnit timeUnit) {
        this.clockPeriod = new TimeAmount(amount, timeUnit);
        this.options.addOptions(RuleConfigurationOption.USE_PSEUDO_CLOCK);
    }

    public TimeAmount getClockPeriod() {
        return this.clockPeriod;
    }

    public boolean hasTemporalConstraint() {
        return this.rules.stream().map(RuleContainer::getRule).anyMatch(Rule::hasTemporalConstraint);
    }

    public boolean requiresAsyncExecution() {
        return this.rules.stream().map(RuleContainer::getRule).anyMatch(Rule::requiresAsyncExecution);
    }

    public boolean hasAsyncExecution() {
        return this.clockPeriod != null || this.requiresAsyncExecution();
    }

    public String toString() {
        return "RulesSet{name='" + this.name + "', hosts='" + this.hosts + "', rules=" + this.rules + "}";
    }
}

