/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOptions;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.RulesSet;
import org.drools.ansible.rulebook.integration.api.domain.actions.Action;
import org.drools.ansible.rulebook.integration.api.domain.actions.MapAction;
import org.drools.ansible.rulebook.integration.api.domain.conditions.AstCondition;
import org.drools.ansible.rulebook.integration.api.domain.conditions.Condition;
import org.drools.ansible.rulebook.integration.api.domain.temporal.Throttle;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeWindowDefinition;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutionController;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Rule {
    private boolean enabled;
    private final RuleGenerationContext ruleGenerationContext = new RuleGenerationContext();
    private String name;
    private Action action;
    private RuleConfigurationOptions options;
    private Condition condition;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Rule withOptions(RuleConfigurationOptions options) {
        this.options = options;
        return this;
    }

    public RuleConfigurationOptions getOptions() {
        return this.options;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public AstCondition withCondition() {
        AstCondition condition = new AstCondition(this.ruleGenerationContext);
        this.condition = condition;
        return condition;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(MapAction action) {
        this.action = action;
    }

    public void setGenericAction(Action action) {
        this.action = action;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setThrottle(Throttle throttle) {
        this.ruleGenerationContext.setTimeConstraint(throttle.asTimeConstraint());
    }

    public void setTimeout(String timeWindow) {
        this.ruleGenerationContext.setTimeConstraint(TimeWindowDefinition.parseTimeWindow(timeWindow));
    }

    public boolean hasTemporalConstraint() {
        return this.ruleGenerationContext.hasTemporalConstraint(this);
    }

    public boolean requiresAsyncExecution() {
        return this.ruleGenerationContext.requiresAsyncExecution(this);
    }

    public List<org.drools.model.Rule> toExecModelRules(RulesSet rulesSet, RulesExecutionController rulesExecutionController, AtomicInteger ruleCounter) {
        return this.ruleGenerationContext.toExecModelRules(rulesSet, this, rulesExecutionController, ruleCounter);
    }

    public String toString() {
        return "Rule{name='" + this.ruleGenerationContext.getRuleName() + "', condition='" + this.ruleGenerationContext.getCondition() + "', action='" + this.ruleGenerationContext.getAction() + "'}";
    }
}

