/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.ansible.rulebook.integration.api.RulesExecutor;
import org.drools.ansible.rulebook.integration.api.io.RuleExecutorChannel;
import org.drools.ansible.rulebook.integration.api.rulesengine.AsyncExecutor;
import org.drools.ansible.rulebook.integration.api.rulesengine.SessionStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesExecutorContainer {
    protected static final Logger log = LoggerFactory.getLogger(RulesExecutorContainer.class);
    private Map<Long, RulesExecutor> rulesExecutors = new ConcurrentHashMap<Long, RulesExecutor>();
    private AsyncExecutor asyncExecutor;
    private RuleExecutorChannel channel;

    public RulesExecutorContainer allowAsync() {
        if (this.asyncExecutor == null) {
            this.asyncExecutor = new AsyncExecutor();
            this.channel = new RuleExecutorChannel().accept(this.asyncExecutor);
        }
        return this;
    }

    public RulesExecutor register(RulesExecutor rulesExecutor) {
        this.rulesExecutors.put(rulesExecutor.getId(), rulesExecutor);
        rulesExecutor.setRulesExecutorContainer(this);
        return rulesExecutor;
    }

    public SessionStats dispose(long rulesExecutorId) {
        return this.removeExecutor(rulesExecutorId).dispose();
    }

    public RulesExecutor removeExecutor(long rulesExecutorId) {
        return this.rulesExecutors.remove(rulesExecutorId);
    }

    public SessionStats disposeAll() {
        SessionStats aggregatedStats = this.rulesExecutors.values().stream().map(RulesExecutor::dispose).reduce(SessionStats::aggregate).orElse(null);
        this.rulesExecutors.clear();
        if (this.channel != null) {
            this.asyncExecutor.shutdown();
            this.channel.shutdown();
        }
        return aggregatedStats;
    }

    public RulesExecutor get(Long id) {
        RulesExecutor rulesExecutor = this.rulesExecutors.get(id);
        if (rulesExecutor == null) {
            log.error("Cannot find any rulesExecutor with id: " + id);
        }
        return rulesExecutor;
    }

    public AsyncExecutor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public RuleExecutorChannel getChannel() {
        return this.channel;
    }

    public int port() {
        if (this.channel == null) {
            this.allowAsync();
        }
        return this.channel.port();
    }
}

