/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.drools.ansible.rulebook.integration.api.RulesExecutorContainer;
import org.drools.ansible.rulebook.integration.api.io.JsonMapper;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesEvaluator;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutorSession;
import org.drools.ansible.rulebook.integration.api.rulesengine.SessionStats;
import org.drools.core.facttemplates.Fact;
import org.json.JSONObject;
import org.kie.api.runtime.rule.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesExecutor {
    protected static final Logger log = LoggerFactory.getLogger(RulesExecutor.class);
    private final RulesEvaluator rulesEvaluator;

    RulesExecutor(RulesExecutorSession rulesExecutorSession, boolean async) {
        this.rulesEvaluator = RulesEvaluator.createRulesEvaluator(rulesExecutorSession, async);
    }

    void startAutomaticPseudoClock(long period, TimeUnit unit) {
        this.rulesEvaluator.startAutomaticPseudoClock(period, unit);
    }

    public long getAutomaticPseudoClockPeriod() {
        return this.rulesEvaluator.getAutomaticPseudoClockPeriod();
    }

    public void setRulesExecutorContainer(RulesExecutorContainer rulesExecutorContainer) {
        this.rulesEvaluator.setRulesExecutorContainer(rulesExecutorContainer);
    }

    public long getId() {
        return this.rulesEvaluator.getSessionId();
    }

    public SessionStats dispose() {
        if (log.isInfoEnabled()) {
            log.info("Disposing session with id: " + this.getId());
        }
        return this.rulesEvaluator.dispose();
    }

    public long rulesCount() {
        return this.rulesEvaluator.rulesCount();
    }

    public CompletableFuture<Integer> executeFacts(String json) {
        return this.executeFacts(new JSONObject(json).toMap());
    }

    public CompletableFuture<Integer> executeFacts(Map<String, Object> factMap) {
        return this.rulesEvaluator.executeFacts(factMap);
    }

    public CompletableFuture<List<Match>> processFacts(String json) {
        return this.processFacts(new JSONObject(json).toMap());
    }

    public CompletableFuture<List<Match>> processFacts(Map<String, Object> factMap) {
        return this.rulesEvaluator.processFacts(factMap);
    }

    public CompletableFuture<List<Match>> processEvents(String json) {
        return this.processEvents(new JSONObject(json).toMap());
    }

    public CompletableFuture<List<Match>> processEvents(Map<String, Object> factMap) {
        return this.rulesEvaluator.processEvents(factMap);
    }

    public CompletableFuture<List<Match>> fire() {
        return this.rulesEvaluator.fire();
    }

    public CompletableFuture<List<Match>> processRetract(String json) {
        return this.processRetract(new JSONObject(json).toMap());
    }

    public CompletableFuture<List<Match>> processRetract(Map<String, Object> json) {
        return this.rulesEvaluator.processRetract(json);
    }

    public boolean retractFact(Map<String, Object> factMap) {
        return this.rulesEvaluator.retractFact(factMap);
    }

    public Collection<?> getAllFacts() {
        return this.rulesEvaluator.getAllFacts();
    }

    public List<Map<String, Object>> getAllFactsAsMap() {
        return this.getAllFacts().stream().map(Fact.class::cast).map(Fact::asMap).collect(Collectors.toList());
    }

    public String getAllFactsAsJson() {
        return JsonMapper.toJson(this.getAllFactsAsMap());
    }

    public CompletableFuture<List<Match>> advanceTime(long amount, TimeUnit unit) {
        return this.rulesEvaluator.advanceTime(amount, unit);
    }
}

