/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.drools.ansible.rulebook.integration.api.ObjectMapperFactory;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOption;
import org.drools.ansible.rulebook.integration.api.RuleFormat;
import org.drools.ansible.rulebook.integration.api.domain.RulesSet;

public interface RuleNotation {
    public RulesSet jsonToRuleSet(ObjectMapper var1, String var2);

    default public RulesSet toRulesSet(RuleFormat format, String text) {
        return this.jsonToRuleSet(ObjectMapperFactory.createMapper(format.getJsonFactory()), text);
    }

    default public RuleNotation withOptions(RuleConfigurationOption ... options) {
        throw new UnsupportedOperationException();
    }

    public static class CoreNotationWithOptions
    implements RuleNotation {
        private final RuleConfigurationOption[] options;

        public CoreNotationWithOptions(RuleConfigurationOption[] options) {
            this.options = options;
        }

        @Override
        public RulesSet jsonToRuleSet(ObjectMapper mapper, String json) {
            return CoreNotation.INSTANCE.jsonToRuleSet(mapper, json).withOptions(this.options);
        }
    }

    public static enum CoreNotation implements RuleNotation
    {
        INSTANCE;


        @Override
        public RulesSet jsonToRuleSet(ObjectMapper mapper, String json) {
            try {
                return mapper.readValue(json, RulesSet.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public RuleNotation withOptions(RuleConfigurationOption ... options) {
            return new CoreNotationWithOptions(options);
        }
    }
}

