import { defineComponent, inject, onMounted, onUnmounted, openBlock, createElementBlock, unref, normalizeClass } from "../vue.esm-browser.prod.js";
import { c as commonjsGlobal, g as getDefaultExportFromCjs, v as v4 } from "./index.6a15f04e.es.js";
const version$1 = "2.4.3", { PI } = Math;
function angle_norm(t) {
  if (t == 0)
    return 0;
  for (; t <= 0; )
    t += 2 * PI;
  for (; t > 2 * PI; )
    t -= 2 * PI;
  return t;
}
function angle_dist(t, e) {
  return angle_norm(t - e);
}
function angle_between(t, e, r, o = !1) {
  const s = angle_dist(e, r);
  if (s == 0)
    return !1;
  if (s == 2 * PI)
    return !0;
  const l = angle_norm(t), c = angle_dist(e, l) <= s && angle_dist(l, r) <= s;
  return o ? !c : c;
}
function random$1() {
  return Math.random();
}
function atan2(t, e) {
  return Math.atan2(e[1] - t[1], e[0] - t[0]);
}
function resolve_angle(t, e) {
  return -to_radians_coeff(e) * t;
}
function to_radians_coeff(t) {
  switch (t) {
    case "deg":
      return PI / 180;
    case "rad":
      return 1;
    case "grad":
      return PI / 200;
    case "turn":
      return 2 * PI;
  }
}
function rnorm(t, e) {
  let r, o;
  for (; r = random$1(), o = random$1(), o = (2 * o - 1) * Math.sqrt(2 * (1 / Math.E)), !(-4 * r * r * Math.log(r) >= o * o); )
    ;
  let s = o / r;
  return s = t + e * s, s;
}
function clamp(t, e, r) {
  return t < e ? e : t > r ? r : t;
}
function log$1(t, e = Math.E) {
  return Math.log(t) / Math.log(e);
}
const float32_epsilon = 11920928955078125e-23;
class AssertionError extends Error {
}
AssertionError.__name__ = "AssertionError";
function assert(t, e) {
  if (!(t === !0 || t !== !1 && t()))
    throw new AssertionError(e != null ? e : "Assertion failed");
}
function unreachable() {
  throw new Error("unreachable code");
}
function is_empty$1(t) {
  return t.length == 0;
}
function splice(t, e, r, ...o) {
  const s = t.length;
  e < 0 && (e += s), e < 0 ? e = 0 : e > s && (e = s), r == null || r > s - e ? r = s - e : r < 0 && (r = 0);
  const l = s - r + o.length, c = new t.constructor(l);
  let u = 0;
  for (; u < e; u++)
    c[u] = t[u];
  for (const d of o)
    c[u++] = d;
  for (let d = e + r; d < s; d++)
    c[u++] = t[d];
  return c;
}
function head(t, e) {
  return splice(t, e, t.length - e);
}
function indexOf(t, e) {
  for (let r = 0, o = t.length; r < o; r++)
    if (t[r] === e)
      return r;
  return -1;
}
function mul(t, e, r) {
  const o = t.length, s = r != null ? r : new t.constructor(o);
  for (let l = 0; l < o; l++)
    s[l] = t[l] * e;
  return s;
}
function map(t, e) {
  const r = t.length, o = new t.constructor(r);
  for (let s = 0; s < r; s++)
    o[s] = e(t[s], s, t);
  return o;
}
function inplace_map(t, e, r) {
  const o = t.length, s = r != null ? r : t;
  for (let l = 0; l < o; l++)
    s[l] = e(t[l], l);
}
function filter(t, e) {
  const r = t.length, o = new t.constructor(r);
  let s = 0;
  for (let l = 0; l < r; l++) {
    const c = t[l];
    e(c, l, t) && (o[s++] = c);
  }
  return head(o, s);
}
function reduce(t, e, r) {
  const o = t.length;
  if (r === void 0 && o == 0)
    throw new Error("can't reduce an empty array without an initial value");
  let s, l;
  for (r === void 0 ? (s = t[0], l = 1) : (s = r, l = 0); l < o; l++)
    s = e(s, t[l], l, t);
  return s;
}
function min$6(t) {
  let e, r = 1 / 0;
  for (let o = 0, s = t.length; o < s; o++)
    e = t[o], !isNaN(e) && e < r && (r = e);
  return r;
}
function max$8(t) {
  let e, r = -1 / 0;
  for (let o = 0, s = t.length; o < s; o++)
    e = t[o], !isNaN(e) && e > r && (r = e);
  return r;
}
function minmax(t) {
  let e, r = 1 / 0, o = -1 / 0;
  for (let s = 0, l = t.length; s < l; s++)
    e = t[s], isNaN(e) || (e < r && (r = e), e > o && (o = e));
  return [r, o];
}
function minmax2(t, e) {
  let r, o, s = 1 / 0, l = -1 / 0, c = 1 / 0, u = -1 / 0;
  const d = Math.min(t.length, e.length);
  for (let f = 0; f < d; f++)
    r = t[f], o = e[f], !isNaN(r) && !isNaN(o) && (r < s && (s = r), r > l && (l = r), o < c && (c = o), o > u && (u = o));
  return [s, l, c, u];
}
function min_by(t, e) {
  if (t.length == 0)
    throw new Error("min_by() called with an empty array");
  let r = t[0], o = e(r);
  for (let s = 1, l = t.length; s < l; s++) {
    const c = t[s], u = e(c);
    u < o && (r = c, o = u);
  }
  return r;
}
function max_by(t, e) {
  if (t.length == 0)
    throw new Error("max_by() called with an empty array");
  let r = t[0], o = e(r);
  for (let s = 1, l = t.length; s < l; s++) {
    const c = t[s], u = e(c);
    u > o && (r = c, o = u);
  }
  return r;
}
function sum$2(t) {
  let e = 0;
  for (let r = 0, o = t.length; r < o; r++)
    e += t[r];
  return e;
}
function cumsum(t) {
  const e = new t.constructor(t.length);
  return reduce(t, (r, o, s) => e[s] = r + o, 0), e;
}
function every(t, e) {
  for (let r = 0, o = t.length; r < o; r++)
    if (!e(t[r]))
      return !1;
  return !0;
}
function some(t, e) {
  for (let r = 0, o = t.length; r < o; r++)
    if (e(t[r]))
      return !0;
  return !1;
}
function index_of(t, e) {
  for (let r = 0, o = t.length; r < o; r++)
    if (t[r] === e)
      return r;
  return -1;
}
function _find_index(t) {
  return function(e, r) {
    const o = e.length;
    let s = t > 0 ? 0 : o - 1;
    for (; s >= 0 && s < o; s += t)
      if (r(e[s]))
        return s;
    return -1;
  };
}
const find_index = _find_index(1), find_last_index = _find_index(-1);
function find(t, e) {
  const r = find_index(t, e);
  return r == -1 ? void 0 : t[r];
}
function sorted_index(t, e) {
  let r = 0, o = t.length;
  for (; r < o; ) {
    const s = Math.floor((r + o) / 2);
    t[s] < e ? r = s + 1 : o = s;
  }
  return r;
}
function bin_counts(t, e) {
  const r = e.length - 1, o = Array(r).fill(0);
  for (let s = 0; s < t.length; s++) {
    const l = t[s], c = sorted_index(e, l), u = clamp(c - 1, 0, r - 1);
    o[u] += 1;
  }
  return o;
}
function interpolate(t, e, r) {
  const o = t.length, s = new Array(o);
  for (let l = 0; l < o; l++) {
    const c = t[l];
    if (isNaN(c)) {
      s[l] = c;
      continue;
    }
    const u = left_edge_index(c, e);
    if (u == -1)
      s[l] = r[0];
    else if (u == e.length)
      s[l] = r[r.length - 1];
    else if (u == e.length - 1 || e[u] == c)
      s[l] = r[u];
    else {
      const d = e[u], f = r[u], T = e[u + 1], Q = r[u + 1];
      s[l] = lerp(c, d, f, T, Q);
    }
  }
  return s;
}
function lerp(t, e, r, o, s) {
  const l = (s - r) / (o - e);
  let c = l * (t - e) + r;
  return isFinite(c) || (c = l * (t - o) + s, !isFinite(c) && r == s && (c = r)), c;
}
function left_edge_index(t, e) {
  if (t < e[0])
    return -1;
  if (t > e[e.length - 1])
    return e.length;
  let r = 0, o = e.length - 1;
  for (; o - r != 1; ) {
    const s = r + Math.floor((o - r) / 2);
    t >= e[s] ? r = s : o = s;
  }
  return r;
}
const slice$2 = Array.prototype.slice;
function copy(t) {
  return slice$2.call(t);
}
function concat$1(t) {
  return [].concat(...t);
}
function includes(t, e) {
  return t.indexOf(e) !== -1;
}
const contains = includes;
function nth(t, e) {
  return t[e >= 0 ? e : t.length + e];
}
function zip(...t) {
  if (t.length == 0)
    return [];
  const e = min$6(t.map((s) => s.length)), r = t.length, o = new Array(e);
  for (let s = 0; s < e; s++) {
    o[s] = new Array(r);
    for (let l = 0; l < r; l++)
      o[s][l] = t[l][s];
  }
  return o;
}
function unzip(t) {
  const e = t.length, r = min$6(t.map((s) => s.length)), o = Array(r);
  for (let s = 0; s < r; s++)
    o[s] = new Array(e);
  for (let s = 0; s < e; s++)
    for (let l = 0; l < r; l++)
      o[l][s] = t[s][l];
  return o;
}
function range(t, e, r = 1) {
  assert(r > 0, "'step' must be a positive number"), e == null && (e = t, t = 0);
  const { max: o, ceil: s, abs: l } = Math, c = t <= e ? r : -r, u = o(s(l(e - t) / r), 0), d = new Array(u);
  for (let f = 0; f < u; f++, t += c)
    d[f] = t;
  return d;
}
function linspace(t, e, r = 100) {
  const o = (e - t) / (r - 1), s = new Array(r);
  for (let l = 0; l < r; l++)
    s[l] = t + o * l;
  return s;
}
function argmin(t) {
  return min_by(range(t.length), (e) => t[e]);
}
function sort_by(t, e) {
  const r = t.map((o, s) => ({ value: o, index: s, key: e(o) }));
  return r.sort((o, s) => {
    const l = o.key, c = s.key;
    if (l !== c) {
      if (l > c || l === void 0)
        return 1;
      if (l < c || c === void 0)
        return -1;
    }
    return o.index - s.index;
  }), r.map((o) => o.value);
}
function uniq(t) {
  const e = /* @__PURE__ */ new Set();
  for (const r of t)
    e.add(r);
  return [...e];
}
function union$2(...t) {
  const e = /* @__PURE__ */ new Set();
  for (const r of t)
    for (const o of r)
      e.add(o);
  return [...e];
}
function intersection(t, ...e) {
  const r = [];
  e:
    for (const o of t)
      if (!includes(r, o)) {
        for (const s of e)
          if (!includes(s, o))
            continue e;
        r.push(o);
      }
  return r;
}
function difference$1(t, ...e) {
  const r = concat$1(e);
  return t.filter((o) => !includes(r, o));
}
function remove_at(t, e) {
  const r = copy(t);
  return r.splice(e, 1), r;
}
function remove_by(t, e) {
  for (let r = 0; r < t.length; )
    e(t[r]) ? t.splice(r, 1) : r++;
}
function reversed(t) {
  const e = t.length, r = new Array(e);
  for (let o = 0; o < e; o++)
    r[e - o - 1] = t[o];
  return r;
}
function repeat(t, e) {
  const r = new Array(e);
  for (let o = 0; o < e; o++)
    r[o] = t;
  return r;
}
const toString$2 = Object.prototype.toString;
function isBoolean(t) {
  return t === !0 || t === !1 || toString$2.call(t) === "[object Boolean]";
}
function isNumber(t) {
  return toString$2.call(t) === "[object Number]";
}
function isInteger(t) {
  return isNumber(t) && Number.isInteger(t);
}
function isString(t) {
  return toString$2.call(t) === "[object String]";
}
function isSymbol(t) {
  return typeof t == "symbol";
}
function isPrimitive(t) {
  return t === null || isBoolean(t) || isNumber(t) || isString(t) || isSymbol(t);
}
function isFunction(t) {
  return toString$2.call(t) === "[object Function]";
}
function isArray(t) {
  return Array.isArray(t);
}
function isArrayOf(t, e) {
  return every(t, e);
}
function isArrayableOf(t, e) {
  for (let r = 0, o = t.length; r < o; r++)
    if (!e(t[r]))
      return !1;
  return !0;
}
function isTypedArray(t) {
  return ArrayBuffer.isView(t) && !(t instanceof DataView);
}
function isObject(t) {
  const e = typeof t;
  return e === "function" || e === "object" && !!t;
}
function isPlainObject(t) {
  return isObject(t) && (t.constructor == null || t.constructor === Object);
}
function isIterable(t) {
  return isObject(t) && t[Symbol.iterator] !== void 0;
}
const { hasOwnProperty: hasOwnProperty$5 } = Object.prototype, { keys, values, entries, assign: extend$1 } = Object;
function clone$1(t) {
  return { ...t };
}
function merge(t, e) {
  const r = Object.create(Object.prototype), o = concat$1([Object.keys(t), Object.keys(e)]);
  for (const s of o) {
    const l = hasOwnProperty$5.call(t, s) ? t[s] : [], c = hasOwnProperty$5.call(e, s) ? e[s] : [];
    r[s] = union$2(l, c);
  }
  return r;
}
function size$1(t) {
  return Object.keys(t).length;
}
function is_empty(t) {
  return size$1(t) == 0;
}
const isEmpty = is_empty;
function to_object(t) {
  const e = {};
  for (const [r, o] of t)
    e[r] = o;
  return e;
}
const channel = new MessageChannel(), tasks = /* @__PURE__ */ new Map();
channel.port1.onmessage = (t) => {
  const e = t.data, r = tasks.get(e);
  if (r != null)
    try {
      r();
    } finally {
      tasks.delete(e);
    }
};
let counter$1 = 1;
function defer() {
  return new Promise((t) => {
    const e = counter$1++;
    tasks.set(e, t), channel.port2.postMessage(e);
  });
}
class Signal {
  constructor(e, r) {
    this.sender = e, this.name = r;
  }
  connect(e, r = null) {
    receiversForSender.has(this.sender) || receiversForSender.set(this.sender, []);
    const o = receiversForSender.get(this.sender);
    if (find_connection(o, this, e, r) != null)
      return !1;
    const s = r != null ? r : e;
    sendersForReceiver.has(s) || sendersForReceiver.set(s, []);
    const l = sendersForReceiver.get(s), c = { signal: this, slot: e, context: r };
    return o.push(c), l.push(c), !0;
  }
  disconnect(e, r = null) {
    const o = receiversForSender.get(this.sender);
    if (o == null || o.length === 0)
      return !1;
    const s = find_connection(o, this, e, r);
    if (s == null)
      return !1;
    const l = r != null ? r : e, c = sendersForReceiver.get(l);
    return s.signal = null, schedule_cleanup(o), schedule_cleanup(c), !0;
  }
  emit(e) {
    var o;
    const r = (o = receiversForSender.get(this.sender)) != null ? o : [];
    for (const { signal: s, slot: l, context: c } of r)
      s === this && l.call(c, e, this.sender);
  }
}
Signal.__name__ = "Signal";
class Signal0 extends Signal {
  emit() {
    super.emit(void 0);
  }
}
Signal0.__name__ = "Signal0";
(function(t) {
  function e(l, c) {
    const u = receiversForSender.get(l);
    if (u == null || u.length === 0)
      return;
    const d = sendersForReceiver.get(c);
    if (!(d == null || d.length === 0)) {
      for (const f of d) {
        if (f.signal == null)
          return;
        f.signal.sender === l && (f.signal = null);
      }
      schedule_cleanup(u), schedule_cleanup(d);
    }
  }
  t.disconnect_between = e;
  function r(l) {
    var u;
    const c = receiversForSender.get(l);
    if (!(c == null || c.length === 0)) {
      for (const d of c) {
        if (d.signal == null)
          return;
        const f = (u = d.context) != null ? u : d.slot;
        d.signal = null, schedule_cleanup(sendersForReceiver.get(f));
      }
      schedule_cleanup(c);
    }
  }
  t.disconnect_sender = r;
  function o(l, c, u) {
    const d = sendersForReceiver.get(l);
    if (!(d == null || d.length === 0)) {
      for (const f of d) {
        if (f.signal == null)
          return;
        if (c != null && f.slot != c)
          continue;
        const T = f.signal.sender;
        u != null && u.has(T) || (f.signal = null, schedule_cleanup(receiversForSender.get(T)));
      }
      schedule_cleanup(d);
    }
  }
  t.disconnect_receiver = o;
  function s(l) {
    const c = receiversForSender.get(l);
    if (c != null && c.length !== 0) {
      for (const d of c)
        d.signal = null;
      schedule_cleanup(c);
    }
    const u = sendersForReceiver.get(l);
    if (u != null && u.length !== 0) {
      for (const d of u)
        d.signal = null;
      schedule_cleanup(u);
    }
  }
  t.disconnect_all = s, t.disconnectBetween = e, t.disconnectSender = r, t.disconnectReceiver = o, t.disconnectAll = s;
})(Signal || (Signal = {}));
function Signalable() {
  return class {
    connect(t, e) {
      return t.connect(e, this);
    }
    disconnect(t, e) {
      return t.disconnect(e, this);
    }
  };
}
const receiversForSender = /* @__PURE__ */ new WeakMap(), sendersForReceiver = /* @__PURE__ */ new WeakMap();
function find_connection(t, e, r, o) {
  return find(t, (s) => s.signal === e && s.slot === r && s.context === o);
}
const dirty_set = /* @__PURE__ */ new Set();
function schedule_cleanup(t) {
  dirty_set.size === 0 && (async () => (await defer(), cleanup_dirty_set()))(), dirty_set.add(t);
}
function cleanup_dirty_set() {
  for (const t of dirty_set)
    remove_by(t, (e) => e.signal == null);
  dirty_set.clear();
}
function is_ref(t) {
  if (isPlainObject(t)) {
    const e = keys(t);
    return e.length == 1 && e[0] == "id";
  }
  return !1;
}
const _loggers = {};
class LogLevel {
  constructor(e, r) {
    this.name = e, this.level = r;
  }
}
LogLevel.__name__ = "LogLevel";
class Logger {
  constructor(e, r = Logger.INFO) {
    this._name = e, this.set_level(r);
  }
  static get levels() {
    return Object.keys(Logger.log_levels);
  }
  static get(e, r = Logger.INFO) {
    if (e.length > 0) {
      let o = _loggers[e];
      return o == null && (_loggers[e] = o = new Logger(e, r)), o;
    } else
      throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
  }
  get level() {
    return this.get_level();
  }
  get_level() {
    return this._log_level;
  }
  set_level(e) {
    if (e instanceof LogLevel)
      this._log_level = e;
    else if (isString(e) && Logger.log_levels[e] != null)
      this._log_level = Logger.log_levels[e];
    else
      throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
    const r = `[${this._name}]`;
    for (const [o, s] of entries(Logger.log_levels))
      s.level < this._log_level.level || this._log_level.level === Logger.OFF.level ? this[o] = function() {
      } : this[o] = _method_factory(o, r);
  }
  trace(...e) {
  }
  debug(...e) {
  }
  info(...e) {
  }
  warn(...e) {
  }
  error(...e) {
  }
}
Logger.__name__ = "Logger";
Logger.TRACE = new LogLevel("trace", 0);
Logger.DEBUG = new LogLevel("debug", 1);
Logger.INFO = new LogLevel("info", 2);
Logger.WARN = new LogLevel("warn", 6);
Logger.ERROR = new LogLevel("error", 7);
Logger.FATAL = new LogLevel("fatal", 8);
Logger.OFF = new LogLevel("off", 9);
Logger.log_levels = {
  trace: Logger.TRACE,
  debug: Logger.DEBUG,
  info: Logger.INFO,
  warn: Logger.WARN,
  error: Logger.ERROR,
  fatal: Logger.FATAL,
  off: Logger.OFF
};
function _method_factory(t, e) {
  return console[t] != null ? console[t].bind(console, e) : console.log != null ? console.log.bind(console, e) : function() {
  };
}
const logger = Logger.get("bokeh"), _named_colors = {
  aliceblue: 4042850303,
  antiquewhite: 4209760255,
  aqua: 16777215,
  aquamarine: 2147472639,
  azure: 4043309055,
  beige: 4126530815,
  bisque: 4293182719,
  black: 255,
  blanchedalmond: 4293643775,
  blue: 65535,
  blueviolet: 2318131967,
  brown: 2771004159,
  burlywood: 3736635391,
  cadetblue: 1604231423,
  chartreuse: 2147418367,
  chocolate: 3530104575,
  coral: 4286533887,
  cornflowerblue: 1687547391,
  cornsilk: 4294499583,
  crimson: 3692313855,
  cyan: 16777215,
  darkblue: 35839,
  darkcyan: 9145343,
  darkgoldenrod: 3095792639,
  darkgray: 2846468607,
  darkgreen: 6553855,
  darkgrey: 2846468607,
  darkkhaki: 3182914559,
  darkmagenta: 2332068863,
  darkolivegreen: 1433087999,
  darkorange: 4287365375,
  darkorchid: 2570243327,
  darkred: 2332033279,
  darksalmon: 3918953215,
  darkseagreen: 2411499519,
  darkslateblue: 1211993087,
  darkslategray: 793726975,
  darkslategrey: 793726975,
  darkturquoise: 13554175,
  darkviolet: 2483082239,
  deeppink: 4279538687,
  deepskyblue: 12582911,
  dimgray: 1768516095,
  dimgrey: 1768516095,
  dodgerblue: 512819199,
  firebrick: 2988581631,
  floralwhite: 4294635775,
  forestgreen: 579543807,
  fuchsia: 4278255615,
  gainsboro: 3705462015,
  ghostwhite: 4177068031,
  gold: 4292280575,
  goldenrod: 3668254975,
  gray: 2155905279,
  green: 8388863,
  greenyellow: 2919182335,
  grey: 2155905279,
  honeydew: 4043305215,
  hotpink: 4285117695,
  indianred: 3445382399,
  indigo: 1258324735,
  ivory: 4294963455,
  khaki: 4041641215,
  lavender: 3873897215,
  lavenderblush: 4293981695,
  lawngreen: 2096890111,
  lemonchiffon: 4294626815,
  lightblue: 2916673279,
  lightcoral: 4034953471,
  lightcyan: 3774873599,
  lightgoldenrodyellow: 4210742015,
  lightgray: 3553874943,
  lightgreen: 2431553791,
  lightgrey: 3553874943,
  lightpink: 4290167295,
  lightsalmon: 4288707327,
  lightseagreen: 548580095,
  lightskyblue: 2278488831,
  lightslategray: 2005441023,
  lightslategrey: 2005441023,
  lightsteelblue: 2965692159,
  lightyellow: 4294959359,
  lime: 16711935,
  limegreen: 852308735,
  linen: 4210091775,
  magenta: 4278255615,
  maroon: 2147483903,
  mediumaquamarine: 1724754687,
  mediumblue: 52735,
  mediumorchid: 3126187007,
  mediumpurple: 2473647103,
  mediumseagreen: 1018393087,
  mediumslateblue: 2070474495,
  mediumspringgreen: 16423679,
  mediumturquoise: 1221709055,
  mediumvioletred: 3340076543,
  midnightblue: 421097727,
  mintcream: 4127193855,
  mistyrose: 4293190143,
  moccasin: 4293178879,
  navajowhite: 4292783615,
  navy: 33023,
  oldlace: 4260751103,
  olive: 2155872511,
  olivedrab: 1804477439,
  orange: 4289003775,
  orangered: 4282712319,
  orchid: 3664828159,
  palegoldenrod: 4008225535,
  palegreen: 2566625535,
  paleturquoise: 2951671551,
  palevioletred: 3681588223,
  papayawhip: 4293907967,
  peachpuff: 4292524543,
  peru: 3448061951,
  pink: 4290825215,
  plum: 3718307327,
  powderblue: 2967529215,
  purple: 2147516671,
  rebeccapurple: 1714657791,
  red: 4278190335,
  rosybrown: 3163525119,
  royalblue: 1097458175,
  saddlebrown: 2336560127,
  salmon: 4202722047,
  sandybrown: 4104413439,
  seagreen: 780883967,
  seashell: 4294307583,
  sienna: 2689740287,
  silver: 3233857791,
  skyblue: 2278484991,
  slateblue: 1784335871,
  slategray: 1887473919,
  slategrey: 1887473919,
  snow: 4294638335,
  springgreen: 16744447,
  steelblue: 1182971135,
  tan: 3535047935,
  teal: 8421631,
  thistle: 3636451583,
  tomato: 4284696575,
  turquoise: 1088475391,
  violet: 4001558271,
  wheat: 4125012991,
  white: 4294967295,
  whitesmoke: 4126537215,
  yellow: 4294902015,
  yellowgreen: 2597139199
}, named_colors = _named_colors;
function is_named_color(t) {
  return t in named_colors;
}
const { round: round$3 } = Math;
function byte(t) {
  return clamp(round$3(t), 0, 255);
}
function transparent() {
  return [0, 0, 0, 0];
}
function encode_rgba([t, e, r, o]) {
  return t << 24 | e << 16 | r << 8 | o;
}
function decode_rgba(t) {
  const e = t >> 24 & 255, r = t >> 16 & 255, o = t >> 8 & 255, s = t & 255;
  return [e, r, o, s];
}
function color2rgba(t, e) {
  var c;
  let r, o, s, l;
  return t == null ? [r, o, s, l] = transparent() : isInteger(t) ? [r, o, s, l] = decode_rgba(t) : isString(t) ? [r, o, s, l] = (c = css4_parse(t)) != null ? c : transparent() : ([r, o, s, l = 1] = t, l = byte(l * 255)), l == 255 && e != null && (l = byte(e * 255)), [r, o, s, l];
}
const _hex_table = {
  0: "0",
  1: "1",
  2: "2",
  3: "3",
  4: "4",
  5: "5",
  6: "6",
  7: "7",
  8: "8",
  9: "9",
  10: "a",
  11: "b",
  12: "c",
  13: "d",
  14: "e",
  15: "f"
};
function hex$1(t) {
  return _hex_table[t >> 4] + _hex_table[t & 15];
}
function color2css(t, e) {
  const [r, o, s, l] = color2rgba(t, e);
  return `rgba(${r}, ${o}, ${s}, ${l / 255})`;
}
function color2hex(t, e) {
  const [r, o, s, l] = color2rgba(t, e), c = `#${hex$1(r)}${hex$1(o)}${hex$1(s)}`;
  return l == 255 ? c : `${c}${hex$1(l)}`;
}
function color2hexrgb(t) {
  const [e, r, o] = color2rgba(t);
  return `#${hex$1(e)}${hex$1(r)}${hex$1(o)}`;
}
const rgb_modern = /^rgba?\(\s*([^\s,]+?)\s+([^\s,]+?)\s+([^\s,]+?)(?:\s*\/\s*([^\s,]+?))?\s*\)$/, rgb_legacy = /^rgba?\(\s*([^\s,]+?)\s*,\s*([^\s,]+?)\s*,\s*([^\s,]+?)(?:\s*,\s*([^\s,]+?))?\s*\)$/, css4_normalize = (() => {
  const t = document.createElement("canvas");
  t.width = 1, t.height = 1;
  const e = t.getContext("2d"), r = e.createLinearGradient(0, 0, 1, 1);
  return (o) => {
    e.fillStyle = r, e.fillStyle = o;
    const s = e.fillStyle;
    return s != r ? s : null;
  };
})();
function css4_parse(t) {
  var e;
  if (t = t.trim().toLowerCase(), t) {
    if (t == "transparent")
      return transparent();
    if (is_named_color(t))
      return decode_rgba(named_colors[t]);
    if (t[0] == "#") {
      const r = Number(`0x${t.substr(1)}`);
      if (isNaN(r))
        return null;
      switch (t.length - 1) {
        case 3: {
          const o = r >> 8 & 15, s = r >> 4 & 15, l = r >> 0 & 15, c = o << 4 | o, u = s << 4 | s, d = l << 4 | l;
          return [c, u, d, 255];
        }
        case 4: {
          const o = r >> 12 & 15, s = r >> 8 & 15, l = r >> 4 & 15, c = r >> 0 & 15, u = o << 4 | o, d = s << 4 | s, f = l << 4 | l, T = c << 4 | c;
          return [u, d, f, T];
        }
        case 6: {
          const o = r >> 16 & 255, s = r >> 8 & 255, l = r >> 0 & 255;
          return [o, s, l, 255];
        }
        case 8: {
          const o = r >> 24 & 255, s = r >> 16 & 255, l = r >> 8 & 255, c = r >> 0 & 255;
          return [o, s, l, c];
        }
      }
    } else if (t.startsWith("rgb")) {
      const r = (e = t.match(rgb_modern)) != null ? e : t.match(rgb_legacy);
      if (r != null) {
        let [, o, s, l, c = "1"] = r;
        const u = o.endsWith("%"), d = s.endsWith("%"), f = l.endsWith("%"), T = c.endsWith("%");
        if (!(u && d && f || !u && !d && !f))
          return null;
        u && (o = o.slice(0, -1)), d && (s = s.slice(0, -1)), f && (l = l.slice(0, -1)), T && (c = c.slice(0, -1));
        let Q = Number(o), m = Number(s), g = Number(l), v = Number(c);
        return isNaN(Q + m + g + v) ? null : (u && (Q = 255 * (Q / 100)), d && (m = 255 * (m / 100)), f && (g = 255 * (g / 100)), v = 255 * (T ? v / 100 : v), Q = byte(Q), m = byte(m), g = byte(g), v = byte(v), [Q, m, g, v]);
      }
    } else {
      const r = css4_normalize(t);
      if (r != null)
        return css4_parse(r);
    }
  } else
    return null;
  return null;
}
function is_Color(t) {
  return !!(isInteger(t) || isString(t) && css4_parse(t) != null || isArray(t) && (t.length == 3 || t.length == 4));
}
const ESMap = window.Map, { hasOwnProperty: hasOwnProperty$4 } = Object.prototype;
class Kind {
}
Kind.__name__ = "Kind";
var Kinds;
(function(t) {
  class e extends Kind {
    valid(D) {
      return !0;
    }
  }
  e.__name__ = "Any", t.Any = e;
  class r extends Kind {
    valid(D) {
      return !0;
    }
  }
  r.__name__ = "Unknown", t.Unknown = r;
  class o extends Kind {
    valid(D) {
      return isBoolean(D);
    }
  }
  o.__name__ = "Boolean", t.Boolean = o;
  class s extends Kind {
    constructor(D) {
      super(), this.obj_type = D;
    }
    valid(D) {
      return !0;
    }
  }
  s.__name__ = "Ref", t.Ref = s;
  class l extends Kind {
    valid(D) {
      return !0;
    }
  }
  l.__name__ = "AnyRef", t.AnyRef = l;
  class c extends Kind {
    valid(D) {
      return isNumber(D);
    }
  }
  c.__name__ = "Number", t.Number = c;
  class u extends c {
    valid(D) {
      return super.valid(D) && isInteger(D);
    }
  }
  u.__name__ = "Int", t.Int = u;
  class d extends c {
    valid(D) {
      return super.valid(D) && 0 <= D && D <= 1;
    }
  }
  d.__name__ = "Percent", t.Percent = d;
  class f extends Kind {
    constructor(D) {
      super(), this.types = D, this.types = D;
    }
    valid(D) {
      return this.types.some((R) => R.valid(D));
    }
  }
  f.__name__ = "Or", t.Or = f;
  class T extends Kind {
    constructor(D) {
      super(), this.types = D, this.types = D;
    }
    valid(D) {
      if (!isArray(D))
        return !1;
      for (let R = 0; R < this.types.length; R++) {
        const B = this.types[R], F = D[R];
        if (!B.valid(F))
          return !1;
      }
      return !0;
    }
  }
  T.__name__ = "Tuple", t.Tuple = T;
  class Q extends Kind {
    constructor(D) {
      super(), this.struct_type = D;
    }
    valid(D) {
      if (!isPlainObject(D))
        return !1;
      const { struct_type: R } = this;
      if (size$1(R) != size$1(D))
        return !1;
      for (const B in R)
        if (hasOwnProperty$4.call(R, B)) {
          if (!hasOwnProperty$4.call(D, B))
            return !1;
          const F = R[B], j = D[B];
          if (!F.valid(j))
            return !1;
        }
      return !0;
    }
  }
  Q.__name__ = "Struct", t.Struct = Q;
  class m extends Kind {
    valid(D) {
      return isArray(D) || isTypedArray(D);
    }
  }
  m.__name__ = "Arrayable", t.Arrayable = m;
  class g extends Kind {
    constructor(D) {
      super(), this.item_type = D;
    }
    valid(D) {
      return isArray(D) && D.every((R) => this.item_type.valid(R));
    }
  }
  g.__name__ = "Array", t.Array = g;
  class v extends Kind {
    valid(D) {
      return D === null;
    }
  }
  v.__name__ = "Null", t.Null = v;
  class b extends Kind {
    constructor(D) {
      super(), this.base_type = D;
    }
    valid(D) {
      return D === null || this.base_type.valid(D);
    }
  }
  b.__name__ = "Nullable", t.Nullable = b;
  class L extends Kind {
    constructor(D) {
      super(), this.base_type = D;
    }
    valid(D) {
      return D === void 0 || this.base_type.valid(D);
    }
  }
  L.__name__ = "Opt", t.Opt = L;
  class A extends Kind {
    valid(D) {
      return isString(D);
    }
  }
  A.__name__ = "String", t.String = A;
  class M extends Kind {
    constructor(D) {
      super(), this.values = new Set(D);
    }
    valid(D) {
      return this.values.has(D);
    }
    *[Symbol.iterator]() {
      yield* this.values;
    }
  }
  M.__name__ = "Enum", t.Enum = M;
  class S extends Kind {
    constructor(D) {
      super(), this.item_type = D;
    }
    valid(D) {
      if (!isPlainObject(D))
        return !1;
      for (const R in D)
        if (hasOwnProperty$4.call(D, R)) {
          const B = D[R];
          if (!this.item_type.valid(B))
            return !1;
        }
      return !0;
    }
  }
  S.__name__ = "Dict", t.Dict = S;
  class E extends Kind {
    constructor(D, R) {
      super(), this.key_type = D, this.item_type = R;
    }
    valid(D) {
      if (!(D instanceof ESMap))
        return !1;
      for (const [R, B] of D.entries())
        if (!(this.key_type.valid(R) && this.item_type.valid(B)))
          return !1;
      return !0;
    }
  }
  E.__name__ = "Map", t.Map = E;
  class k extends Kind {
    valid(D) {
      return is_Color(D);
    }
  }
  k.__name__ = "Color", t.Color = k;
  class w extends Kind {
    valid(D) {
      return isFunction(D);
    }
  }
  w.__name__ = "Function", t.Function = w;
})(Kinds || (Kinds = {}));
const Any$1 = new Kinds.Any(), Unknown = new Kinds.Unknown(), Boolean$2 = new Kinds.Boolean(), Number$2 = new Kinds.Number(), Int$1 = new Kinds.Int(), String$2 = new Kinds.String(), Null = new Kinds.Null(), Nullable = (t) => new Kinds.Nullable(t), Opt = (t) => new Kinds.Opt(t), Or = (...t) => new Kinds.Or(t), Tuple = (...t) => new Kinds.Tuple(t), Struct = (t) => new Kinds.Struct(t), Arrayable = new Kinds.Arrayable(), Array$2 = (t) => new Kinds.Array(t), Dict = (t) => new Kinds.Dict(t), Map$2 = (t, e) => new Kinds.Map(t, e), Enum = (...t) => new Kinds.Enum(t), Ref = (t) => new Kinds.Ref(t), AnyRef = () => new Kinds.AnyRef(), Function$1 = () => new Kinds.Function(), Percent$1 = new Kinds.Percent(), Alpha = Percent$1, Color$1 = new Kinds.Color(), Auto = Enum("auto"), FontSize$1 = String$2, Font$1 = String$2, Angle$1 = Number$2, kinds = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Kind,
  get Kinds() {
    return Kinds;
  },
  Any: Any$1,
  Unknown,
  Boolean: Boolean$2,
  Number: Number$2,
  Int: Int$1,
  String: String$2,
  Null,
  Nullable,
  Opt,
  Or,
  Tuple,
  Struct,
  Arrayable,
  Array: Array$2,
  Dict,
  Map: Map$2,
  Enum,
  Ref,
  AnyRef,
  Function: Function$1,
  Percent: Percent$1,
  Alpha,
  Color: Color$1,
  Auto,
  FontSize: FontSize$1,
  Font: Font$1,
  Angle: Angle$1
}, Symbol.toStringTag, { value: "Module" })), Align = Enum("start", "center", "end"), Anchor = Enum("top_left", "top_center", "top_right", "center_left", "center_center", "center_right", "bottom_left", "bottom_center", "bottom_right", "top", "left", "center", "right", "bottom"), AngleUnits = Enum("deg", "rad", "grad", "turn"), BoxOrigin = Enum("corner", "center"), ButtonType = Enum("default", "primary", "success", "warning", "danger", "light"), CalendarPosition = Enum("auto", "above", "below"), Dimension = Enum("width", "height"), Dimensions = Enum("width", "height", "both"), Direction$1 = Enum("clock", "anticlock"), Distribution = Enum("uniform", "normal"), FontStyle = Enum("normal", "italic", "bold", "bold italic"), HatchPatternType = Enum("blank", "dot", "ring", "horizontal_line", "vertical_line", "cross", "horizontal_dash", "vertical_dash", "spiral", "right_diagonal_line", "left_diagonal_line", "diagonal_cross", "right_diagonal_dash", "left_diagonal_dash", "horizontal_wave", "vertical_wave", "criss_cross", " ", ".", "o", "-", "|", "+", '"', ":", "@", "/", "\\", "x", ",", "`", "v", ">", "*"), HTTPMethod = Enum("POST", "GET"), HexTileOrientation = Enum("pointytop", "flattop"), HoverMode = Enum("mouse", "hline", "vline"), LatLon = Enum("lat", "lon"), LegendClickPolicy = Enum("none", "hide", "mute"), LegendLocation = Anchor, LineCap = Enum("butt", "round", "square"), LineJoin = Enum("miter", "round", "bevel"), LineDash = Enum("solid", "dashed", "dotted", "dotdash", "dashdot"), LinePolicy = Enum("prev", "next", "nearest", "interp", "none"), Location = Enum("above", "below", "left", "right"), Logo = Enum("normal", "grey"), MarkerType = Enum("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "star", "star_dot", "triangle", "triangle_dot", "triangle_pin", "x", "y"), MutedPolicy = Enum("show", "ignore"), Orientation = Enum("vertical", "horizontal"), OutputBackend = Enum("canvas", "svg", "webgl"), PaddingUnits = Enum("percent", "absolute");
Enum("above", "below", "left", "right", "center");
const PointPolicy = Enum("snap_to_data", "follow_mouse", "none"), RadiusDimension = Enum("x", "y", "max", "min"), RenderLevel = Enum("image", "underlay", "glyph", "guide", "annotation", "overlay"), RenderMode = Enum("canvas", "css"), ResetPolicy = Enum("standard", "event_only"), RoundingFunction = Enum("round", "nearest", "floor", "rounddown", "ceil", "roundup"), SelectionMode = Enum("replace", "append", "intersect", "subtract");
Enum("above", "below", "left", "right");
const SizingMode = Enum("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed"), Sort = Enum("ascending", "descending"), SpatialUnits = Enum("screen", "data"), StartEnd = Enum("start", "end"), StepMode = Enum("after", "before", "center"), TapBehavior = Enum("select", "inspect"), TextAlign = Enum("left", "right", "center"), TextBaseline = Enum("top", "middle", "bottom", "alphabetic", "hanging", "ideographic"), TextureRepetition = Enum("repeat", "repeat_x", "repeat_y", "no_repeat"), TickLabelOrientation = Enum("vertical", "horizontal", "parallel", "normal"), TooltipAttachment = Enum("horizontal", "vertical", "left", "right", "above", "below"), UpdateMode = Enum("replace", "append"), VerticalAlign = Enum("top", "middle", "bottom"), { hasOwnProperty: hasOwnProperty$3 } = Object.prototype, equals = Symbol("equals");
function is_Equatable(t) {
  return isObject(t) && t[equals] !== void 0;
}
const wildcard = Symbol("wildcard"), toString$1 = Object.prototype.toString;
class Comparator {
  constructor() {
    this.a_stack = [], this.b_stack = [];
  }
  eq(e, r) {
    if (Object.is(e, r) || e === wildcard || r === wildcard)
      return !0;
    if (e == null || r == null)
      return e === r;
    const o = toString$1.call(e);
    if (o != toString$1.call(r))
      return !1;
    switch (o) {
      case "[object Number]":
        return this.numbers(e, r);
      case "[object RegExp]":
      case "[object String]":
        return `${e}` == `${r}`;
      case "[object Date]":
      case "[object Boolean]":
        return +e == +r;
    }
    const { a_stack: s, b_stack: l } = this;
    let c = s.length;
    for (; c--; )
      if (s[c] === e)
        return l[c] === r;
    s.push(e), l.push(r);
    const u = (() => {
      if (is_Equatable(e) && is_Equatable(r))
        return e[equals](r, this);
      switch (o) {
        case "[object Array]":
        case "[object Uint8Array]":
        case "[object Int8Array]":
        case "[object Uint16Array]":
        case "[object Int16Array]":
        case "[object Uint32Array]":
        case "[object Int32Array]":
        case "[object Float32Array]":
        case "[object Float64Array]":
          return this.arrays(e, r);
        case "[object Map]":
          return this.maps(e, r);
        case "[object Set]":
          return this.sets(e, r);
        case "[object Object]":
          if (e.constructor == r.constructor && (e.constructor == null || e.constructor === Object))
            return this.objects(e, r);
        case "[object Function]":
          if (e.constructor == r.constructor && e.constructor === Function)
            return this.eq(`${e}`, `${r}`);
      }
      if (e instanceof Node)
        return this.nodes(e, r);
      throw Error(`can't compare objects of type ${o}`);
    })();
    return s.pop(), l.pop(), u;
  }
  numbers(e, r) {
    return Object.is(e, r);
  }
  arrays(e, r) {
    const { length: o } = e;
    if (o != r.length)
      return !1;
    for (let s = 0; s < o; s++)
      if (!this.eq(e[s], r[s]))
        return !1;
    return !0;
  }
  iterables(e, r) {
    const o = e[Symbol.iterator](), s = r[Symbol.iterator]();
    for (; ; ) {
      const l = o.next(), c = s.next();
      if (l.done && c.done)
        return !0;
      if (l.done || c.done || !this.eq(l.value, c.value))
        return !1;
    }
  }
  maps(e, r) {
    if (e.size != r.size)
      return !1;
    for (const [o, s] of e)
      if (!r.has(o) || !this.eq(s, r.get(o)))
        return !1;
    return !0;
  }
  sets(e, r) {
    if (e.size != r.size)
      return !1;
    for (const o of e)
      if (!r.has(o))
        return !1;
    return !0;
  }
  objects(e, r) {
    const o = Object.keys(e);
    if (o.length != Object.keys(r).length)
      return !1;
    for (const s of o)
      if (!hasOwnProperty$3.call(r, s) || !this.eq(e[s], r[s]))
        return !1;
    return !0;
  }
  nodes(e, r) {
    return !(e.nodeType != r.nodeType || e.textContent != r.textContent || !this.iterables(e.childNodes, r.childNodes));
  }
}
Comparator.__name__ = "Comparator";
const { abs: abs$4 } = Math;
class SimilarComparator extends Comparator {
  constructor(e = 1e-4) {
    super(), this.tolerance = e;
  }
  numbers(e, r) {
    return super.numbers(e, r) || abs$4(e - r) < this.tolerance;
  }
}
SimilarComparator.__name__ = "SimilarComparator";
function is_equal(t, e) {
  return new Comparator().eq(t, e);
}
var _a$3V;
class BitSet {
  constructor(e, r = 0) {
    this.size = e, this[_a$3V] = "BitSet", this._count = null, this._nwords = Math.ceil(e / 32), r == 0 || r == 1 ? (this._array = new Uint32Array(this._nwords), r == 1 && this._array.fill(4294967295)) : (assert(r.length == this._nwords, "Initializer size mismatch"), this._array = r);
  }
  clone() {
    return new BitSet(this.size, new Uint32Array(this._array));
  }
  [(_a$3V = Symbol.toStringTag, equals)](e, r) {
    if (!r.eq(this.size, e.size))
      return !1;
    const { _nwords: o } = this, s = this.size % o, l = s == 0 ? o : o - 1;
    for (let c = 0; c < l; c++)
      if (this._array[c] != e._array[c])
        return !1;
    if (s == 0)
      return !0;
    {
      const c = 1 << s - 1, u = c - 1 ^ c;
      return (this._array[l] & u) == (e._array[l] & u);
    }
  }
  static all_set(e) {
    return new BitSet(e, 1);
  }
  static all_unset(e) {
    return new BitSet(e, 0);
  }
  static from_indices(e, r) {
    const o = new BitSet(e);
    for (const s of r)
      o.set(s);
    return o;
  }
  static from_booleans(e, r) {
    const o = new BitSet(e), s = Math.min(e, r.length);
    for (let l = 0; l < s; l++)
      r[l] && o.set(l);
    return o;
  }
  _check_bounds(e) {
    assert(0 <= e && e < this.size, `Out of bounds: 0 <= ${e} < ${this.size}`);
  }
  get(e) {
    this._check_bounds(e);
    const r = e >>> 5, o = e & 31;
    return !!(this._array[r] >> o & 1);
  }
  set(e, r = !0) {
    this._check_bounds(e), this._count = null;
    const o = e >>> 5, s = e & 31;
    r ? this._array[o] |= 1 << s : this._array[o] &= ~(1 << s);
  }
  unset(e) {
    this.set(e, !1);
  }
  *[Symbol.iterator]() {
    yield* this.ones();
  }
  get count() {
    let e = this._count;
    return e == null && (this._count = e = this._get_count()), e;
  }
  _get_count() {
    const { _array: e, _nwords: r, size: o } = this;
    let s = 0;
    for (let l = 0, c = 0; c < r; c++) {
      const u = e[c];
      if (u == 0)
        l += 32;
      else
        for (let d = 0; d < 32 && l < o; d++, l++)
          u >>> d & 1 && (s += 1);
    }
    return s;
  }
  *ones() {
    const { _array: e, _nwords: r, size: o } = this;
    for (let s = 0, l = 0; l < r; l++) {
      const c = e[l];
      if (c == 0) {
        s += 32;
        continue;
      }
      for (let u = 0; u < 32 && s < o; u++, s++)
        c >>> u & 1 && (yield s);
    }
  }
  *zeros() {
    const { _array: e, _nwords: r, size: o } = this;
    for (let s = 0, l = 0; l < r; l++) {
      const c = e[l];
      if (c == 4294967295) {
        s += 32;
        continue;
      }
      for (let u = 0; u < 32 && s < o; u++, s++)
        c >>> u & 1 || (yield s);
    }
  }
  _check_size(e) {
    assert(this.size == e.size, "Size mismatch");
  }
  add(e) {
    this._check_size(e);
    for (let r = 0; r < this._nwords; r++)
      this._array[r] |= e._array[r];
  }
  intersect(e) {
    this._check_size(e);
    for (let r = 0; r < this._nwords; r++)
      this._array[r] &= e._array[r];
  }
  subtract(e) {
    this._check_size(e);
    for (let r = 0; r < this._nwords; r++) {
      const o = this._array[r], s = e._array[r];
      this._array[r] = (o ^ s) & o;
    }
  }
  union(e) {
    this._check_size(e);
    const r = this.clone();
    for (let o = 0; o < this._nwords; o++)
      r._array[o] |= e._array[o];
    return r;
  }
  intersection(e) {
    this._check_size(e);
    const r = this.clone();
    for (let o = 0; o < this._nwords; o++)
      r._array[o] &= e._array[o];
    return r;
  }
  difference(e) {
    this._check_size(e);
    const r = this.clone();
    for (let o = 0; o < this._nwords; o++) {
      const s = this._array[o], l = e._array[o];
      r._array[o] = (s ^ l) & s;
    }
    return r;
  }
  select(e) {
    assert(this.size <= e.length, "Size mismatch");
    const r = this.count, o = new e.constructor(r);
    let s = 0;
    for (const l of this)
      o[s++] = e[l];
    return o;
  }
}
BitSet.__name__ = "BitSet";
const GeneratorFunction = Object.getPrototypeOf(function* () {
}).constructor, ColorArray = Uint32Array, RGBAArray = Uint8ClampedArray;
function infer_type(t, e) {
  return t instanceof Float64Array || t instanceof Array || e instanceof Float64Array || e instanceof Array ? Float64Array : Float32Array;
}
const ScreenArray = Float32Array;
function to_screen(t) {
  return t instanceof Float32Array ? t : Float32Array.from(t);
}
navigator.appVersion.includes("Windows");
const is_ie = (() => {
  const t = navigator.userAgent;
  return t.includes("MSIE") || t.includes("Trident") || t.includes("Edge");
})(), is_mobile = (() => typeof window < "u" && ("ontouchstart" in window || navigator.maxTouchPoints > 0))(), is_little_endian = (() => {
  const t = new ArrayBuffer(4), e = new Uint8Array(t), r = new Uint32Array(t);
  r[1] = 168496141;
  let o = !0;
  return e[4] == 10 && e[5] == 11 && e[6] == 12 && e[7] == 13 && (o = !1), o;
})(), BYTE_ORDER = is_little_endian ? "little" : "big";
function to_big_endian(t) {
  if (is_little_endian) {
    const e = new Uint32Array(t.length), r = new DataView(e.buffer);
    let o = 0;
    for (const s of t)
      r.setUint32(o, s), o += 4;
    return e;
  } else
    return t;
}
class Settings {
  constructor() {
    this._dev = !1, this._wireframe = !1, this._force_webgl = !1;
  }
  set dev(e) {
    this._dev = e;
  }
  get dev() {
    return this._dev;
  }
  set wireframe(e) {
    this._wireframe = e;
  }
  get wireframe() {
    return this._wireframe;
  }
  set force_webgl(e) {
    this._force_webgl = e;
  }
  get force_webgl() {
    return this._force_webgl;
  }
}
Settings.__name__ = "Settings";
const settings = new Settings(), serialize = Symbol("serialize");
function is_Serializable(t) {
  return isObject(t) && t[serialize] !== void 0;
}
class SerializationError extends Error {
}
SerializationError.__name__ = "SerializationError";
class Serializer {
  constructor(e) {
    var r;
    this._references = /* @__PURE__ */ new Map(), this._definitions = /* @__PURE__ */ new Map(), this._refmap = /* @__PURE__ */ new Map(), this.include_defaults = (r = e == null ? void 0 : e.include_defaults) != null ? r : !0;
  }
  get_ref(e) {
    return this._references.get(e);
  }
  add_ref(e, r) {
    assert(!this._references.has(e)), this._references.set(e, r);
  }
  add_def(e, r) {
    const o = this.get_ref(e);
    assert(o != null), this._definitions.set(e, r), this._refmap.set(o, r);
  }
  get objects() {
    return new Set(this._references.keys());
  }
  get references() {
    return new Set(this._references.values());
  }
  get definitions() {
    return new Set(this._definitions.values());
  }
  resolve_ref(e) {
    return this._refmap.get(e);
  }
  remove_ref(e) {
    return this._references.delete(e);
  }
  remove_def(e) {
    return this._definitions.delete(e);
  }
  to_serializable(e) {
    const r = this.get_ref(e);
    if (r != null)
      return r;
    if (is_Serializable(e))
      return e[serialize](this);
    if (isArray(e) || isTypedArray(e)) {
      const o = e.length, s = new Array(o);
      for (let l = 0; l < o; l++) {
        const c = e[l];
        s[l] = this.to_serializable(c);
      }
      return s;
    } else if (isPlainObject(e)) {
      const o = {};
      for (const [s, l] of entries(e))
        o[s] = this.to_serializable(l);
      return o;
    } else {
      if (e === null || isBoolean(e) || isNumber(e) || isString(e))
        return e;
      throw new SerializationError(`${Object.prototype.toString.call(e)} is not serializable`);
    }
  }
}
Serializer.__name__ = "Serializer";
function buffer_to_base64(t) {
  const e = new Uint8Array(t), r = Array.from(e).map((o) => String.fromCharCode(o));
  return btoa(r.join(""));
}
function base64_to_buffer(t) {
  const e = atob(t), r = e.length, o = new Uint8Array(r);
  for (let s = 0, l = r; s < l; s++)
    o[s] = e.charCodeAt(s);
  return o.buffer;
}
function swap16(t) {
  const e = new Uint8Array(t);
  for (let r = 0, o = e.length; r < o; r += 2) {
    const s = e[r];
    e[r] = e[r + 1], e[r + 1] = s;
  }
}
function swap32(t) {
  const e = new Uint8Array(t);
  for (let r = 0, o = e.length; r < o; r += 4) {
    let s = e[r];
    e[r] = e[r + 3], e[r + 3] = s, s = e[r + 1], e[r + 1] = e[r + 2], e[r + 2] = s;
  }
}
function swap64(t) {
  const e = new Uint8Array(t);
  for (let r = 0, o = e.length; r < o; r += 8) {
    let s = e[r];
    e[r] = e[r + 7], e[r + 7] = s, s = e[r + 1], e[r + 1] = e[r + 6], e[r + 6] = s, s = e[r + 2], e[r + 2] = e[r + 5], e[r + 5] = s, s = e[r + 3], e[r + 3] = e[r + 4], e[r + 4] = s;
  }
}
function swap$1(t, e) {
  switch (e) {
    case "uint16":
    case "int16":
      swap16(t);
      break;
    case "uint32":
    case "int32":
    case "float32":
      swap32(t);
      break;
    case "float64":
      swap64(t);
      break;
  }
}
function is_NDArray_ref(t) {
  return isPlainObject(t) && ("__buffer__" in t || "__ndarray__" in t);
}
function decode_NDArray(t, e) {
  const { shape: r, dtype: o, order: s } = t;
  let l;
  if ("__buffer__" in t) {
    const c = e.get(t.__buffer__);
    if (c != null)
      l = c;
    else
      throw new Error(`buffer for ${t.__buffer__} not found`);
  } else
    l = base64_to_buffer(t.__ndarray__);
  return s !== BYTE_ORDER && swap$1(l, o), { buffer: l, dtype: o, shape: r };
}
function encode_NDArray(t, e) {
  const r = {
    order: BYTE_ORDER,
    dtype: t.dtype,
    shape: t.shape
  };
  if (e != null) {
    const o = `${e.size}`;
    return e.set(o, t.buffer), { __buffer__: o, ...r };
  } else
    return { __ndarray__: {
      toJSON() {
        return buffer_to_base64(t.buffer);
      }
    }, ...r };
}
var _a$3U, _b$c, _c$6, _d$4, _e$4, _f$3, _g$2, _h$2;
const __ndarray__ = Symbol("__ndarray__");
class Uint8NDArray extends Uint8Array {
  constructor(e, r) {
    super(e), this[_a$3U] = !0, this.dtype = "uint8", this.shape = r != null ? r : is_NDArray(e) ? e.shape : [this.length], this.dimension = this.shape.length, this[equals] == null && (this[equals] = (o, s) => Uint8NDArray.prototype[equals].call(this, o, s)), this[serialize] == null && (this[serialize] = (o) => Uint8NDArray.prototype[serialize].call(this, o));
  }
  [(_a$3U = __ndarray__, equals)](e, r) {
    return r.eq(this.shape, e.shape) && r.arrays(this, e);
  }
  [serialize](e) {
    return encode_NDArray(this);
  }
}
Uint8NDArray.__name__ = "Uint8NDArray";
class Int8NDArray extends Int8Array {
  constructor(e, r) {
    super(e), this[_b$c] = !0, this.dtype = "int8", this.shape = r != null ? r : is_NDArray(e) ? e.shape : [this.length], this.dimension = this.shape.length, this[equals] == null && (this[equals] = (o, s) => Int8NDArray.prototype[equals].call(this, o, s)), this[serialize] == null && (this[serialize] = (o) => Int8NDArray.prototype[serialize].call(this, o));
  }
  [(_b$c = __ndarray__, equals)](e, r) {
    return r.eq(this.shape, e.shape) && r.arrays(this, e);
  }
  [serialize](e) {
    return encode_NDArray(this);
  }
}
Int8NDArray.__name__ = "Int8NDArray";
class Uint16NDArray extends Uint16Array {
  constructor(e, r) {
    super(e), this[_c$6] = !0, this.dtype = "uint16", this.shape = r != null ? r : is_NDArray(e) ? e.shape : [this.length], this.dimension = this.shape.length, this[equals] == null && (this[equals] = (o, s) => Uint16NDArray.prototype[equals].call(this, o, s)), this[serialize] == null && (this[serialize] = (o) => Uint16NDArray.prototype[serialize].call(this, o));
  }
  [(_c$6 = __ndarray__, equals)](e, r) {
    return r.eq(this.shape, e.shape) && r.arrays(this, e);
  }
  [serialize](e) {
    return encode_NDArray(this);
  }
}
Uint16NDArray.__name__ = "Uint16NDArray";
class Int16NDArray extends Int16Array {
  constructor(e, r) {
    super(e), this[_d$4] = !0, this.dtype = "int16", this.shape = r != null ? r : is_NDArray(e) ? e.shape : [this.length], this.dimension = this.shape.length, this[equals] == null && (this[equals] = (o, s) => Int16NDArray.prototype[equals].call(this, o, s)), this[serialize] == null && (this[serialize] = (o) => Int16NDArray.prototype[serialize].call(this, o));
  }
  [(_d$4 = __ndarray__, equals)](e, r) {
    return r.eq(this.shape, e.shape) && r.arrays(this, e);
  }
  [serialize](e) {
    return encode_NDArray(this);
  }
}
Int16NDArray.__name__ = "Int16NDArray";
class Uint32NDArray extends Uint32Array {
  constructor(e, r) {
    super(e), this[_e$4] = !0, this.dtype = "uint32", this.shape = r != null ? r : is_NDArray(e) ? e.shape : [this.length], this.dimension = this.shape.length, this[equals] == null && (this[equals] = (o, s) => Uint32NDArray.prototype[equals].call(this, o, s)), this[serialize] == null && (this[serialize] = (o) => Uint32NDArray.prototype[serialize].call(this, o));
  }
  [(_e$4 = __ndarray__, equals)](e, r) {
    return r.eq(this.shape, e.shape) && r.arrays(this, e);
  }
  [serialize](e) {
    return encode_NDArray(this);
  }
}
Uint32NDArray.__name__ = "Uint32NDArray";
class Int32NDArray extends Int32Array {
  constructor(e, r) {
    super(e), this[_f$3] = !0, this.dtype = "int32", this.shape = r != null ? r : is_NDArray(e) ? e.shape : [this.length], this.dimension = this.shape.length, this[equals] == null && (this[equals] = (o, s) => Int32NDArray.prototype[equals].call(this, o, s)), this[serialize] == null && (this[serialize] = (o) => Int32NDArray.prototype[serialize].call(this, o));
  }
  [(_f$3 = __ndarray__, equals)](e, r) {
    return r.eq(this.shape, e.shape) && r.arrays(this, e);
  }
  [serialize](e) {
    return encode_NDArray(this);
  }
}
Int32NDArray.__name__ = "Int32NDArray";
class Float32NDArray extends Float32Array {
  constructor(e, r) {
    super(e), this[_g$2] = !0, this.dtype = "float32", this.shape = r != null ? r : is_NDArray(e) ? e.shape : [this.length], this.dimension = this.shape.length, this[equals] == null && (this[equals] = (o, s) => Float32NDArray.prototype[equals].call(this, o, s)), this[serialize] == null && (this[serialize] = (o) => Float32NDArray.prototype[serialize].call(this, o));
  }
  [(_g$2 = __ndarray__, equals)](e, r) {
    return r.eq(this.shape, e.shape) && r.arrays(this, e);
  }
  [serialize](e) {
    return encode_NDArray(this);
  }
}
Float32NDArray.__name__ = "Float32NDArray";
class Float64NDArray extends Float64Array {
  constructor(e, r) {
    super(e), this[_h$2] = !0, this.dtype = "float64", this.shape = r != null ? r : is_NDArray(e) ? e.shape : [this.length], this.dimension = this.shape.length, this[equals] == null && (this[equals] = (o, s) => Float64NDArray.prototype[equals].call(this, o, s)), this[serialize] == null && (this[serialize] = (o) => Float64NDArray.prototype[serialize].call(this, o));
  }
  [(_h$2 = __ndarray__, equals)](e, r) {
    return r.eq(this.shape, e.shape) && r.arrays(this, e);
  }
  [serialize](e) {
    return encode_NDArray(this);
  }
}
Float64NDArray.__name__ = "Float64NDArray";
function is_NDArray(t) {
  return isObject(t) && t[__ndarray__] !== void 0;
}
function ndarray(t, e = {}) {
  let { dtype: r } = e;
  r == null && (t instanceof ArrayBuffer || isArray(t) ? r = "float64" : r = (() => {
    switch (!0) {
      case t instanceof Uint8Array:
        return "uint8";
      case t instanceof Int8Array:
        return "int8";
      case t instanceof Uint16Array:
        return "uint16";
      case t instanceof Int16Array:
        return "int16";
      case t instanceof Uint32Array:
        return "uint32";
      case t instanceof Int32Array:
        return "int32";
      case t instanceof Float32Array:
        return "float32";
      case t instanceof Float64Array:
        return "float64";
      default:
        unreachable();
    }
  })());
  const { shape: o } = e;
  switch (r) {
    case "uint8":
      return new Uint8NDArray(t, o);
    case "int8":
      return new Int8NDArray(t, o);
    case "uint16":
      return new Uint16NDArray(t, o);
    case "int16":
      return new Int16NDArray(t, o);
    case "uint32":
      return new Uint32NDArray(t, o);
    case "int32":
      return new Int32NDArray(t, o);
    case "float32":
      return new Float32NDArray(t, o);
    case "float64":
      return new Float64NDArray(t, o);
  }
}
class Uniform {
  is_Scalar() {
    return this.is_scalar;
  }
  is_Vector() {
    return !this.is_scalar;
  }
}
Uniform.__name__ = "Uniform";
class UniformScalar extends Uniform {
  constructor(e, r) {
    super(), this.value = e, this.length = r, this.is_scalar = !0;
  }
  get(e) {
    return this.value;
  }
  *[Symbol.iterator]() {
    const { length: e, value: r } = this;
    for (let o = 0; o < e; o++)
      yield r;
  }
  select(e) {
    return new UniformScalar(this.value, e.count);
  }
  [equals](e, r) {
    return r.eq(this.length, e.length) && r.eq(this.value, e.value);
  }
}
UniformScalar.__name__ = "UniformScalar";
class UniformVector extends Uniform {
  constructor(e) {
    super(), this.array = e, this.is_scalar = !1, this.length = this.array.length;
  }
  get(e) {
    return this.array[e];
  }
  *[Symbol.iterator]() {
    yield* this.array;
  }
  select(e) {
    const r = e.select(this.array);
    return new this.constructor(r);
  }
  [equals](e, r) {
    return r.eq(this.length, e.length) && r.eq(this.array, e.array);
  }
}
UniformVector.__name__ = "UniformVector";
class ColorUniformVector extends UniformVector {
  constructor(e) {
    super(e), this.array = e, this._view = new DataView(e.buffer);
  }
  get(e) {
    return this._view.getUint32(4 * e);
  }
  *[Symbol.iterator]() {
    const e = this.length;
    for (let r = 0; r < e; r++)
      yield this.get(r);
  }
}
ColorUniformVector.__name__ = "ColorUniformVector";
function valueToString(t) {
  try {
    return JSON.stringify(t);
  } catch {
    return t.toString();
  }
}
function isSpec(t) {
  return isPlainObject(t) && (t.value === void 0 ? 0 : 1) + (t.field === void 0 ? 0 : 1) + (t.expr === void 0 ? 0 : 1) == 1;
}
class Property {
  constructor(e, r, o, s, l, c = {}) {
    var d;
    this.obj = e, this.attr = r, this.kind = o, this.default_value = s, this._dirty = !1, this.change = new Signal0(this.obj, "change"), this.internal = (d = c.internal) != null ? d : !1, this.convert = c.convert, this.on_update = c.on_update;
    let u;
    if (l !== void 0)
      u = l, this._dirty = !0;
    else {
      const f = this._default_override();
      if (f !== void 0)
        u = f;
      else if (s !== void 0)
        u = s(e);
      else {
        this.spec = { value: null };
        return;
      }
    }
    this._update(u);
  }
  get is_value() {
    return this.spec.value !== void 0;
  }
  get syncable() {
    return !this.internal;
  }
  get_value() {
    return this.spec.value;
  }
  set_value(e) {
    this._update(e), this._dirty = !0;
  }
  _default_override() {
  }
  get dirty() {
    return this._dirty;
  }
  _update(e) {
    var r;
    if (this.validate(e), this.convert != null) {
      const o = this.convert(e);
      o !== void 0 && (e = o);
    }
    this.spec = { value: e }, (r = this.on_update) == null || r.call(this, e, this.obj);
  }
  toString() {
    return `Prop(${this.obj}.${this.attr}, spec: ${valueToString(this.spec)})`;
  }
  normalize(e) {
    return e;
  }
  validate(e) {
    if (!this.valid(e))
      throw new Error(`${this.obj}.${this.attr} given invalid value: ${valueToString(e)}`);
  }
  valid(e) {
    return this.kind.valid(e);
  }
  _value(e = !0) {
    if (!this.is_value)
      throw new Error("attempted to retrieve property value for property without value specification");
    let r = this.normalize([this.spec.value])[0];
    return this.spec.transform != null && e && (r = this.spec.transform.compute(r)), r;
  }
}
Property.__name__ = "Property";
class PropertyAlias {
  constructor(e) {
    this.attr = e;
  }
}
PropertyAlias.__name__ = "PropertyAlias";
function Alias(t) {
  return new PropertyAlias(t);
}
class PrimitiveProperty extends Property {
}
PrimitiveProperty.__name__ = "PrimitiveProperty";
class Any extends Property {
}
Any.__name__ = "Any";
class Array$1 extends Property {
  valid(e) {
    return isArray(e) || isTypedArray(e);
  }
}
Array$1.__name__ = "Array";
class Boolean$1 extends Property {
  valid(e) {
    return isBoolean(e);
  }
}
Boolean$1.__name__ = "Boolean";
class Color extends Property {
  valid(e) {
    return is_Color(e);
  }
}
Color.__name__ = "Color";
class Instance extends Property {
}
Instance.__name__ = "Instance";
class Number$1 extends Property {
  valid(e) {
    return isNumber(e);
  }
}
Number$1.__name__ = "Number";
class Int extends Number$1 {
  valid(e) {
    return isNumber(e) && (e | 0) == e;
  }
}
Int.__name__ = "Int";
class Angle extends Number$1 {
}
Angle.__name__ = "Angle";
class Percent extends Number$1 {
  valid(e) {
    return isNumber(e) && 0 <= e && e <= 1;
  }
}
Percent.__name__ = "Percent";
class String$1 extends Property {
  valid(e) {
    return isString(e);
  }
}
String$1.__name__ = "String";
class NullString extends Property {
  valid(e) {
    return e === null || isString(e);
  }
}
NullString.__name__ = "NullString";
class FontSize extends String$1 {
}
FontSize.__name__ = "FontSize";
class Font extends String$1 {
  _default_override() {
    return settings.dev ? "Bokeh" : void 0;
  }
}
Font.__name__ = "Font";
class EnumProperty extends Property {
  valid(e) {
    return isString(e) && includes(this.enum_values, e);
  }
}
EnumProperty.__name__ = "EnumProperty";
class Direction extends EnumProperty {
  get enum_values() {
    return [...Direction$1];
  }
  normalize(e) {
    const r = new Uint8Array(e.length);
    for (let o = 0; o < e.length; o++)
      switch (e[o]) {
        case "clock":
          r[o] = 0;
          break;
        case "anticlock":
          r[o] = 1;
          break;
      }
    return r;
  }
}
Direction.__name__ = "Direction";
class ScalarSpec extends Property {
  get_value() {
    const { value: e, expr: r, transform: o } = this.spec;
    return r != null || o != null ? this.spec : e;
  }
  _update(e) {
    isSpec(e) ? this.spec = e : this.spec = { value: e }, this.spec.value != null && this.validate(this.spec.value);
  }
  materialize(e) {
    return e;
  }
  scalar(e, r) {
    return new UniformScalar(e, r);
  }
  uniform(e) {
    var c;
    const { expr: r, value: o, transform: s } = this.spec, l = (c = e.get_length()) != null ? c : 1;
    if (r != null) {
      let u = r.compute(e);
      return s != null && (u = s.compute(u)), u = this.materialize(u), this.scalar(u, l);
    } else {
      let u = o;
      return s != null && (u = s.compute(u)), u = this.materialize(u), this.scalar(u, l);
    }
  }
}
ScalarSpec.__name__ = "ScalarSpec";
class AnyScalar extends ScalarSpec {
}
AnyScalar.__name__ = "AnyScalar";
class ColorScalar extends ScalarSpec {
}
ColorScalar.__name__ = "ColorScalar";
class NumberScalar extends ScalarSpec {
}
NumberScalar.__name__ = "NumberScalar";
class StringScalar extends ScalarSpec {
}
StringScalar.__name__ = "StringScalar";
class NullStringScalar extends ScalarSpec {
}
NullStringScalar.__name__ = "NullStringScalar";
class ArrayScalar extends ScalarSpec {
}
ArrayScalar.__name__ = "ArrayScalar";
class LineJoinScalar extends ScalarSpec {
}
LineJoinScalar.__name__ = "LineJoinScalar";
class LineCapScalar extends ScalarSpec {
}
LineCapScalar.__name__ = "LineCapScalar";
class LineDashScalar extends ScalarSpec {
}
LineDashScalar.__name__ = "LineDashScalar";
class FontScalar extends ScalarSpec {
  _default_override() {
    return settings.dev ? "Bokeh" : void 0;
  }
}
FontScalar.__name__ = "FontScalar";
class FontSizeScalar extends ScalarSpec {
}
FontSizeScalar.__name__ = "FontSizeScalar";
class FontStyleScalar extends ScalarSpec {
}
FontStyleScalar.__name__ = "FontStyleScalar";
class TextAlignScalar extends ScalarSpec {
}
TextAlignScalar.__name__ = "TextAlignScalar";
class TextBaselineScalar extends ScalarSpec {
}
TextBaselineScalar.__name__ = "TextBaselineScalar";
class VectorSpec extends Property {
  get_value() {
    return this.spec.value === null ? null : this.spec;
  }
  _update(e) {
    isSpec(e) ? this.spec = e : this.spec = { value: e }, this.spec.value != null && this.validate(this.spec.value);
  }
  materialize(e) {
    return e;
  }
  v_materialize(e) {
    return e;
  }
  scalar(e, r) {
    return new UniformScalar(e, r);
  }
  vector(e) {
    return new UniformVector(e);
  }
  uniform(e) {
    var u;
    const { field: r, expr: o, value: s, transform: l } = this.spec, c = (u = e.get_length()) != null ? u : 1;
    if (r != null) {
      let d = e.get_column(r);
      return d != null ? (l != null && (d = l.v_compute(d)), d = this.v_materialize(d), this.vector(d)) : (logger.warn(`attempted to retrieve property array for nonexistent field '${r}'`), this.scalar(null, c));
    } else if (o != null) {
      let d = o.v_compute(e);
      return l != null && (d = l.v_compute(d)), d = this.v_materialize(d), this.vector(d);
    } else {
      let d = s;
      return l != null && (d = l.compute(d)), d = this.materialize(d), this.scalar(d, c);
    }
  }
  array(e) {
    var s;
    let r;
    const o = (s = e.get_length()) != null ? s : 1;
    if (this.spec.field != null) {
      const l = e.get_column(this.spec.field);
      if (l != null)
        r = this.normalize(l);
      else {
        logger.warn(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`);
        const c = new Float64Array(o);
        c.fill(NaN), r = c;
      }
    } else if (this.spec.expr != null)
      r = this.normalize(this.spec.expr.v_compute(e));
    else {
      const l = this._value(!1);
      if (isNumber(l)) {
        const c = new Float64Array(o);
        c.fill(l), r = c;
      } else
        r = repeat(l, o);
    }
    return this.spec.transform != null && (r = this.spec.transform.v_compute(r)), r;
  }
}
VectorSpec.__name__ = "VectorSpec";
class DataSpec extends VectorSpec {
}
DataSpec.__name__ = "DataSpec";
class UnitsSpec extends VectorSpec {
  _update(e) {
    super._update(e);
    const { units: r } = this.spec;
    if (r != null && !includes(this.valid_units, r))
      throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${r}`);
  }
  get units() {
    var e;
    return (e = this.spec.units) != null ? e : this.default_units;
  }
  set units(e) {
    e != this.default_units ? this.spec.units = e : delete this.spec.units;
  }
}
UnitsSpec.__name__ = "UnitsSpec";
class NumberUnitsSpec extends UnitsSpec {
  array(e) {
    return new Float64Array(super.array(e));
  }
}
NumberUnitsSpec.__name__ = "NumberUnitsSpec";
class BaseCoordinateSpec extends DataSpec {
}
BaseCoordinateSpec.__name__ = "BaseCoordinateSpec";
class CoordinateSpec extends BaseCoordinateSpec {
}
CoordinateSpec.__name__ = "CoordinateSpec";
class CoordinateSeqSpec extends BaseCoordinateSpec {
}
CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
class CoordinateSeqSeqSeqSpec extends BaseCoordinateSpec {
}
CoordinateSeqSeqSeqSpec.__name__ = "CoordinateSeqSeqSeqSpec";
class XCoordinateSpec extends CoordinateSpec {
  constructor() {
    super(...arguments), this.dimension = "x";
  }
}
XCoordinateSpec.__name__ = "XCoordinateSpec";
class YCoordinateSpec extends CoordinateSpec {
  constructor() {
    super(...arguments), this.dimension = "y";
  }
}
YCoordinateSpec.__name__ = "YCoordinateSpec";
class XCoordinateSeqSpec extends CoordinateSeqSpec {
  constructor() {
    super(...arguments), this.dimension = "x";
  }
}
XCoordinateSeqSpec.__name__ = "XCoordinateSeqSpec";
class YCoordinateSeqSpec extends CoordinateSeqSpec {
  constructor() {
    super(...arguments), this.dimension = "y";
  }
}
YCoordinateSeqSpec.__name__ = "YCoordinateSeqSpec";
class XCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
  constructor() {
    super(...arguments), this.dimension = "x";
  }
}
XCoordinateSeqSeqSeqSpec.__name__ = "XCoordinateSeqSeqSeqSpec";
class YCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
  constructor() {
    super(...arguments), this.dimension = "y";
  }
}
YCoordinateSeqSeqSeqSpec.__name__ = "YCoordinateSeqSeqSeqSpec";
class AngleSpec extends NumberUnitsSpec {
  get default_units() {
    return "rad";
  }
  get valid_units() {
    return [...AngleUnits];
  }
  materialize(e) {
    const r = -to_radians_coeff(this.units);
    return e * r;
  }
  v_materialize(e) {
    const r = -to_radians_coeff(this.units), o = new Float32Array(e.length);
    return mul(e, r, o), o;
  }
  array(e) {
    throw new Error("not supported");
  }
}
AngleSpec.__name__ = "AngleSpec";
class DistanceSpec extends NumberUnitsSpec {
  get default_units() {
    return "data";
  }
  get valid_units() {
    return [...SpatialUnits];
  }
}
DistanceSpec.__name__ = "DistanceSpec";
class NullDistanceSpec extends DistanceSpec {
  materialize(e) {
    return e != null ? e : NaN;
  }
}
NullDistanceSpec.__name__ = "NullDistanceSpec";
class BooleanSpec extends DataSpec {
  v_materialize(e) {
    return new Uint8Array(e);
  }
  array(e) {
    return new Uint8Array(super.array(e));
  }
}
BooleanSpec.__name__ = "BooleanSpec";
class IntSpec extends DataSpec {
  v_materialize(e) {
    return isTypedArray(e) ? e : new Int32Array(e);
  }
  array(e) {
    return new Int32Array(super.array(e));
  }
}
IntSpec.__name__ = "IntSpec";
class NumberSpec extends DataSpec {
  v_materialize(e) {
    return isTypedArray(e) ? e : new Float64Array(e);
  }
  array(e) {
    return new Float64Array(super.array(e));
  }
}
NumberSpec.__name__ = "NumberSpec";
class ScreenSizeSpec extends NumberSpec {
  valid(e) {
    return isNumber(e) && e >= 0;
  }
}
ScreenSizeSpec.__name__ = "ScreenSizeSpec";
class ColorSpec extends DataSpec {
  materialize(e) {
    return encode_rgba(color2rgba(e));
  }
  v_materialize(e) {
    if (is_NDArray(e)) {
      if (e.dtype == "uint32" && e.dimension == 1)
        return to_big_endian(e);
      if (e.dtype == "uint8" && e.dimension == 1) {
        const [r] = e.shape, o = new RGBAArray(4 * r);
        let s = 0;
        for (const l of e)
          o[s++] = l, o[s++] = l, o[s++] = l, o[s++] = 255;
        return new ColorArray(o.buffer);
      } else if (e.dtype == "uint8" && e.dimension == 2) {
        const [r, o] = e.shape;
        if (o == 4)
          return new ColorArray(e.buffer);
        if (o == 3) {
          const s = new RGBAArray(4 * r);
          for (let l = 0, c = 0; l < o * r; )
            s[c++] = e[l++], s[c++] = e[l++], s[c++] = e[l++], s[c++] = 255;
          return new ColorArray(s.buffer);
        }
      } else if ((e.dtype == "float32" || e.dtype == "float64") && e.dimension == 2) {
        const [r, o] = e.shape;
        if (o == 3 || o == 4) {
          const s = new RGBAArray(4 * r);
          for (let l = 0, c = 0; l < o * r; )
            s[c++] = e[l++] * 255, s[c++] = e[l++] * 255, s[c++] = e[l++] * 255, s[c++] = (o == 3 ? 1 : e[l++]) * 255;
          return new ColorArray(s.buffer);
        }
      }
    } else {
      const r = e.length, o = new RGBAArray(4 * r);
      let s = 0;
      for (const l of e) {
        const [c, u, d, f] = color2rgba(l);
        o[s++] = c, o[s++] = u, o[s++] = d, o[s++] = f;
      }
      return new ColorArray(o.buffer);
    }
    throw new Error("invalid color array");
  }
  vector(e) {
    return new ColorUniformVector(e);
  }
}
ColorSpec.__name__ = "ColorSpec";
class NDArraySpec extends DataSpec {
}
NDArraySpec.__name__ = "NDArraySpec";
class AnySpec extends DataSpec {
}
AnySpec.__name__ = "AnySpec";
class StringSpec extends DataSpec {
}
StringSpec.__name__ = "StringSpec";
class NullStringSpec extends DataSpec {
}
NullStringSpec.__name__ = "NullStringSpec";
class ArraySpec extends DataSpec {
}
ArraySpec.__name__ = "ArraySpec";
class MarkerSpec extends DataSpec {
}
MarkerSpec.__name__ = "MarkerSpec";
class LineJoinSpec extends DataSpec {
}
LineJoinSpec.__name__ = "LineJoinSpec";
class LineCapSpec extends DataSpec {
}
LineCapSpec.__name__ = "LineCapSpec";
class LineDashSpec extends DataSpec {
}
LineDashSpec.__name__ = "LineDashSpec";
class FontSpec extends DataSpec {
  _default_override() {
    return settings.dev ? "Bokeh" : void 0;
  }
}
FontSpec.__name__ = "FontSpec";
class FontSizeSpec extends DataSpec {
}
FontSizeSpec.__name__ = "FontSizeSpec";
class FontStyleSpec extends DataSpec {
}
FontStyleSpec.__name__ = "FontStyleSpec";
class TextAlignSpec extends DataSpec {
}
TextAlignSpec.__name__ = "TextAlignSpec";
class TextBaselineSpec extends DataSpec {
}
TextBaselineSpec.__name__ = "TextBaselineSpec";
function startsWith(t, e, r = 0) {
  return t.substr(r, e.length) == e;
}
function uuid4() {
  const t = new Array(32), e = "0123456789ABCDEF";
  for (let r = 0; r < 32; r++)
    t[r] = e.substr(Math.floor(Math.random() * 16), 1);
  return t[12] = "4", t[16] = e.substr(t[16].charCodeAt(0) & 3 | 8, 1), t.join("");
}
let counter = 1e3;
function uniqueId(t) {
  const e = settings.dev ? `j${counter++}` : uuid4();
  return t != null ? `${t}-${e}` : e;
}
function unescape(t) {
  return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, (e, r) => {
    switch (r) {
      case "amp":
        return "&";
      case "lt":
        return "<";
      case "gt":
        return ">";
      case "quot":
        return '"';
      case "#x27":
        return "'";
      case "#x60":
        return "`";
      default:
        return r;
    }
  });
}
function use_strict(t) {
  return `'use strict';
${t}`;
}
function to_fixed(t, e) {
  return t.toFixed(e).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
}
class DocumentEvent {
  constructor(e) {
    this.document = e;
  }
}
DocumentEvent.__name__ = "DocumentEvent";
class DocumentEventBatch extends DocumentEvent {
  constructor(e, r, o) {
    super(e), this.events = r, this.setter_id = o;
  }
}
DocumentEventBatch.__name__ = "DocumentEventBatch";
class DocumentChangedEvent extends DocumentEvent {
}
DocumentChangedEvent.__name__ = "DocumentChangedEvent";
class MessageSentEvent extends DocumentChangedEvent {
  constructor(e, r, o) {
    super(e), this.msg_type = r, this.msg_data = o;
  }
  [serialize](e) {
    const r = this.msg_data, o = e.to_serializable(r);
    return {
      kind: "MessageSent",
      msg_type: this.msg_type,
      msg_data: o
    };
  }
}
MessageSentEvent.__name__ = "MessageSentEvent";
class ModelChangedEvent extends DocumentChangedEvent {
  constructor(e, r, o, s, l, c, u) {
    super(e), this.model = r, this.attr = o, this.old = s, this.new_ = l, this.setter_id = c, this.hint = u;
  }
  [serialize](e) {
    if (this.hint != null)
      return e.to_serializable(this.hint);
    const r = this.new_, o = e.to_serializable(r);
    return this.model != r && e.remove_def(this.model), {
      kind: "ModelChanged",
      model: this.model.ref(),
      attr: this.attr,
      new: o
    };
  }
}
ModelChangedEvent.__name__ = "ModelChangedEvent";
class ColumnsPatchedEvent extends DocumentChangedEvent {
  constructor(e, r, o) {
    super(e), this.column_source = r, this.patches = o;
  }
  [serialize](e) {
    return {
      kind: "ColumnsPatched",
      column_source: this.column_source,
      patches: this.patches
    };
  }
}
ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
class ColumnsStreamedEvent extends DocumentChangedEvent {
  constructor(e, r, o, s) {
    super(e), this.column_source = r, this.data = o, this.rollover = s;
  }
  [serialize](e) {
    return {
      kind: "ColumnsStreamed",
      column_source: this.column_source,
      data: this.data,
      rollover: this.rollover
    };
  }
}
ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
class TitleChangedEvent extends DocumentChangedEvent {
  constructor(e, r, o) {
    super(e), this.title = r, this.setter_id = o;
  }
  [serialize](e) {
    return {
      kind: "TitleChanged",
      title: this.title
    };
  }
}
TitleChangedEvent.__name__ = "TitleChangedEvent";
class RootAddedEvent extends DocumentChangedEvent {
  constructor(e, r, o) {
    super(e), this.model = r, this.setter_id = o;
  }
  [serialize](e) {
    return {
      kind: "RootAdded",
      model: e.to_serializable(this.model)
    };
  }
}
RootAddedEvent.__name__ = "RootAddedEvent";
class RootRemovedEvent extends DocumentChangedEvent {
  constructor(e, r, o) {
    super(e), this.model = r, this.setter_id = o;
  }
  [serialize](e) {
    return {
      kind: "RootRemoved",
      model: this.model.ref()
    };
  }
}
RootRemovedEvent.__name__ = "RootRemovedEvent";
const pretty = Symbol("pretty"), clone = Symbol("clone");
function is_Cloneable(t) {
  return isObject(t) && t[clone] !== void 0;
}
class CloningError extends Error {
}
CloningError.__name__ = "CloningError";
class Cloner {
  constructor() {
  }
  clone(e) {
    if (is_Cloneable(e))
      return e[clone](this);
    if (isArray(e)) {
      const r = e.length, o = new Array(r);
      for (let s = 0; s < r; s++) {
        const l = e[s];
        o[s] = this.clone(l);
      }
      return o;
    } else if (isPlainObject(e)) {
      const r = {};
      for (const [o, s] of entries(e))
        r[o] = this.clone(s);
      return r;
    } else {
      if (e === null || isBoolean(e) || isNumber(e) || isString(e))
        return e;
      throw new CloningError(`${Object.prototype.toString.call(e)} is not cloneable`);
    }
  }
}
Cloner.__name__ = "Cloner";
var _a$3T;
class HasProps extends Signalable() {
  constructor(e = {}) {
    var o, s;
    super(), this._subtype = void 0, this.document = null, this.destroyed = new Signal0(this, "destroyed"), this.change = new Signal0(this, "change"), this.transformchange = new Signal0(this, "transformchange"), this.exprchange = new Signal0(this, "exprchange"), this.properties = {}, this._watchers = /* @__PURE__ */ new WeakMap(), this._pending = !1, this._changing = !1;
    const r = e instanceof Map ? e.get.bind(e) : (l) => e[l];
    this.id = (o = r("id")) != null ? o : uniqueId();
    for (const [l, { type: c, default_value: u, options: d }] of entries(this._props)) {
      let f;
      c instanceof PropertyAlias ? Object.defineProperty(this.properties, l, {
        get: () => this.properties[c.attr],
        configurable: !1,
        enumerable: !1
      }) : (c instanceof Kind ? f = new PrimitiveProperty(this, l, c, u, r(l), d) : f = new c(this, l, Any$1, u, r(l), d), this.properties[l] = f);
    }
    (s = r("__deferred__")) != null && s || (this.finalize(), this.connect_signals());
  }
  get is_syncable() {
    return !0;
  }
  set type(e) {
    console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"), this.constructor.__name__ = e;
  }
  get type() {
    return this.constructor.__qualified__;
  }
  static get __qualified__() {
    const { __module__: e, __name__: r } = this;
    return e != null ? `${e}.${r}` : r;
  }
  static get [Symbol.toStringTag]() {
    return this.__name__;
  }
  static _fix_default(e, r) {
    if (e === void 0 || isFunction(e))
      return e;
    if (isPrimitive(e))
      return () => e;
    {
      const o = new Cloner();
      return () => o.clone(e);
    }
  }
  static define(e) {
    for (const [r, o] of entries(isFunction(e) ? e(kinds) : e)) {
      if (this.prototype._props[r] != null)
        throw new Error(`attempted to redefine property '${this.prototype.type}.${r}'`);
      if (this.prototype[r] != null)
        throw new Error(`attempted to redefine attribute '${this.prototype.type}.${r}'`);
      Object.defineProperty(this.prototype, r, {
        get() {
          return this.properties[r].get_value();
        },
        set(f) {
          return this.setv({ [r]: f }), this;
        },
        configurable: !1,
        enumerable: !0
      });
      const [s, l, c = {}] = o, u = {
        type: s,
        default_value: this._fix_default(l, r),
        options: c
      }, d = { ...this.prototype._props };
      d[r] = u, this.prototype._props = d;
    }
  }
  static internal(e) {
    const r = {};
    for (const [o, s] of entries(isFunction(e) ? e(kinds) : e)) {
      const [l, c, u = {}] = s;
      r[o] = [l, c, { ...u, internal: !0 }];
    }
    this.define(r);
  }
  static mixins(e) {
    function r(l, c) {
      const u = {};
      for (const [d, f] of entries(c))
        u[l + d] = f;
      return u;
    }
    const o = {}, s = [];
    for (const l of isArray(e) ? e : [e])
      if (isArray(l)) {
        const [c, u] = l;
        extend$1(o, r(c, u)), s.push([c, u]);
      } else {
        const c = l;
        extend$1(o, c), s.push(["", c]);
      }
    this.define(o), this.prototype._mixins = [...this.prototype._mixins, ...s];
  }
  static override(e) {
    for (const [r, o] of entries(e)) {
      const s = this._fix_default(o, r), l = this.prototype._props[r];
      if (l == null)
        throw new Error(`attempted to override nonexistent '${this.prototype.type}.${r}'`);
      const c = { ...this.prototype._props };
      c[r] = { ...l, default_value: s }, this.prototype._props = c;
    }
  }
  toString() {
    return `${this.type}(${this.id})`;
  }
  property(e) {
    const r = this.properties[e];
    if (r != null)
      return r;
    throw new Error(`unknown property ${this.type}.${e}`);
  }
  get attributes() {
    const e = {};
    for (const r of this)
      e[r.attr] = r.get_value();
    return e;
  }
  [clone](e) {
    const r = /* @__PURE__ */ new Map();
    for (const o of this)
      o.dirty && r.set(o.attr, e.clone(o.get_value()));
    return new this.constructor(r);
  }
  [equals](e, r) {
    for (const o of this) {
      const s = e.property(o.attr);
      if (!r.eq(o.get_value(), s.get_value()))
        return !1;
    }
    return !0;
  }
  [pretty](e) {
    const r = e.token, o = [];
    for (const l of this)
      if (l.dirty) {
        const c = l.get_value();
        o.push(`${l.attr}${r(":")} ${e.to_string(c)}`);
      }
    return `${this.constructor.__qualified__}${r("(")}${r("{")}${o.join(`${r(",")} `)}${r("}")}${r(")")}`;
  }
  [serialize](e) {
    const r = this.ref();
    e.add_ref(this, r);
    const o = this.struct();
    for (const s of this)
      s.syncable && (e.include_defaults || s.dirty) && (o.attributes[s.attr] = e.to_serializable(s.get_value()));
    return e.add_def(this, o), r;
  }
  finalize() {
    for (const e of this) {
      if (!(e instanceof VectorSpec || e instanceof ScalarSpec))
        continue;
      const r = e.get_value();
      if (r != null) {
        const { transform: o, expr: s } = r;
        o != null && this.connect(o.change, () => this.transformchange.emit()), s != null && this.connect(s.change, () => this.exprchange.emit());
      }
    }
    this.initialize();
  }
  initialize() {
  }
  connect_signals() {
  }
  disconnect_signals() {
    Signal.disconnectReceiver(this);
  }
  destroy() {
    this.disconnect_signals(), this.destroyed.emit();
  }
  clone() {
    return new Cloner().clone(this);
  }
  changed_for(e) {
    const r = this._watchers.get(e);
    return this._watchers.set(e, !1), r != null ? r : !0;
  }
  _setv(e, r) {
    const o = r.check_eq, s = [], l = this._changing;
    this._changing = !0;
    for (const [c, u] of e)
      (o === !1 || !is_equal(c.get_value(), u)) && (c.set_value(u), s.push(c));
    s.length > 0 && (this._watchers = /* @__PURE__ */ new WeakMap(), this._pending = !0);
    for (const c of s)
      c.change.emit();
    if (!l) {
      if (!r.no_change)
        for (; this._pending; )
          this._pending = !1, this.change.emit();
      this._pending = !1, this._changing = !1;
    }
  }
  setv(e, r = {}) {
    const o = entries(e);
    if (o.length == 0)
      return;
    if (r.silent === !0) {
      this._watchers = /* @__PURE__ */ new WeakMap();
      for (const [u, d] of o)
        this.properties[u].set_value(d);
      return;
    }
    const s = /* @__PURE__ */ new Map(), l = /* @__PURE__ */ new Map();
    for (const [u, d] of o) {
      const f = this.properties[u];
      s.set(f, d), l.set(f, f.get_value());
    }
    this._setv(s, r);
    const { document: c } = this;
    if (c != null) {
      const u = [];
      for (const [d, f] of l)
        u.push([d, f, d.get_value()]);
      for (const [, d, f] of u)
        if (this._needs_invalidate(d, f)) {
          c._invalidate_all_models();
          break;
        }
      this._push_changes(u, r);
    }
  }
  getv(e) {
    return this.property(e).get_value();
  }
  ref() {
    return { id: this.id };
  }
  struct() {
    const e = {
      type: this.type,
      id: this.id,
      attributes: {}
    };
    return this._subtype != null && (e.subtype = this._subtype), e;
  }
  set_subtype(e) {
    this._subtype = e;
  }
  *[Symbol.iterator]() {
    yield* values(this.properties);
  }
  *syncable_properties() {
    for (const e of this)
      e.syncable && (yield e);
  }
  serializable_attributes() {
    const e = {};
    for (const r of this.syncable_properties())
      e[r.attr] = r.get_value();
    return e;
  }
  static _json_record_references(e, r, o, s) {
    const { recursive: l } = s;
    if (is_ref(r)) {
      const c = e.get_model_by_id(r.id);
      c != null && !o.has(c) && HasProps._value_record_references(c, o, { recursive: l });
    } else if (isArray(r))
      for (const c of r)
        HasProps._json_record_references(e, c, o, { recursive: l });
    else if (isPlainObject(r))
      for (const c of values(r))
        HasProps._json_record_references(e, c, o, { recursive: l });
  }
  static _value_record_references(e, r, o) {
    const { recursive: s } = o;
    if (e instanceof HasProps) {
      if (!r.has(e) && (r.add(e), s))
        for (const l of e.syncable_properties()) {
          const c = l.get_value();
          HasProps._value_record_references(c, r, { recursive: s });
        }
    } else if (isArray(e))
      for (const l of e)
        HasProps._value_record_references(l, r, { recursive: s });
    else if (isPlainObject(e))
      for (const l of values(e))
        HasProps._value_record_references(l, r, { recursive: s });
  }
  references() {
    const e = /* @__PURE__ */ new Set();
    return HasProps._value_record_references(this, e, { recursive: !0 }), e;
  }
  _doc_attached() {
  }
  _doc_detached() {
  }
  attach_document(e) {
    if (this.document != null && this.document != e)
      throw new Error("models must be owned by only a single document");
    this.document = e, this._doc_attached();
  }
  detach_document() {
    this._doc_detached(), this.document = null;
  }
  _needs_invalidate(e, r) {
    const o = /* @__PURE__ */ new Set();
    HasProps._value_record_references(r, o, { recursive: !1 });
    const s = /* @__PURE__ */ new Set();
    HasProps._value_record_references(e, s, { recursive: !1 });
    for (const l of o)
      if (!s.has(l))
        return !0;
    for (const l of s)
      if (!o.has(l))
        return !0;
    return !1;
  }
  _push_changes(e, r = {}) {
    if (!this.is_syncable)
      return;
    const { document: o } = this;
    if (o == null)
      return;
    const { setter_id: s } = r, l = [];
    for (const [c, u, d] of e)
      c.syncable && l.push(new ModelChangedEvent(o, this, c.attr, u, d, s));
    if (l.length != 0) {
      let c;
      l.length == 1 ? [c] = l : c = new DocumentEventBatch(o, l, s), o._trigger_on_change(c);
    }
  }
  on_change(e, r) {
    for (const o of isArray(e) ? e : [e])
      this.connect(o.change, r);
  }
}
_a$3T = HasProps;
_a$3T.prototype._props = {}, _a$3T.prototype._mixins = [];
const _createElement = (t) => (e = {}, ...r) => {
  const o = document.createElement(t);
  o.classList.add("bk"), isPlainObject(e) || (r = [e, ...r], e = {});
  for (let [l, c] of entries(e))
    if (!(c == null || isBoolean(c) && !c)) {
      if (l === "class" && (isString(c) && (c = c.split(/\s+/)), isArray(c))) {
        for (const u of c)
          u != null && o.classList.add(u);
        continue;
      }
      if (l === "style" && isPlainObject(c)) {
        for (const [u, d] of entries(c))
          o.style[u] = d;
        continue;
      }
      if (l === "data" && isPlainObject(c)) {
        for (const [u, d] of entries(c))
          o.dataset[u] = d;
        continue;
      }
      o.setAttribute(l, c);
    }
  function s(l) {
    if (isString(l))
      o.appendChild(document.createTextNode(l));
    else if (l instanceof Node)
      o.appendChild(l);
    else if (l instanceof NodeList || l instanceof HTMLCollection)
      for (const c of l)
        o.appendChild(c);
    else if (l != null && l !== !1)
      throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(l)}`);
  }
  for (const l of r)
    if (isArray(l))
      for (const c of l)
        s(c);
    else
      s(l);
  return o;
};
function createElement(t, e, ...r) {
  return _createElement(t)(e, ...r);
}
const div = _createElement("div"), span = _createElement("span"), canvas = _createElement("canvas"), style$2 = _createElement("style"), a = _createElement("a"), p = _createElement("p"), i = _createElement("i"), pre = _createElement("pre"), button = _createElement("button"), label = _createElement("label"), input$1 = _createElement("input"), select = _createElement("select"), option = _createElement("option"), optgroup = _createElement("optgroup"), textarea = _createElement("textarea");
function nbsp() {
  return document.createTextNode("\xA0");
}
function append(t, ...e) {
  for (const r of e)
    t.appendChild(r);
}
function remove(t) {
  const e = t.parentNode;
  e != null && e.removeChild(t);
}
const removeElement = remove;
function replaceWith(t, e) {
  const r = t.parentNode;
  r != null && r.replaceChild(e, t);
}
function prepend(t, ...e) {
  const r = t.firstChild;
  for (const o of e)
    t.insertBefore(o, r);
}
function empty$1(t, e = !1) {
  let r;
  for (; r = t.firstChild; )
    t.removeChild(r);
  if (e && t instanceof Element)
    for (const o of t.attributes)
      t.removeAttributeNode(o);
}
function display(t) {
  t.style.display = "";
}
function undisplay(t) {
  t.style.display = "none";
}
function show(t) {
  t.style.visibility = "";
}
function hide(t) {
  t.style.visibility = "hidden";
}
function offset(t) {
  const e = t.getBoundingClientRect();
  return {
    top: e.top + window.pageYOffset - document.documentElement.clientTop,
    left: e.left + window.pageXOffset - document.documentElement.clientLeft
  };
}
function num(t) {
  return parseFloat(t) || 0;
}
function extents(t) {
  const e = getComputedStyle(t);
  return {
    border: {
      top: num(e.borderTopWidth),
      bottom: num(e.borderBottomWidth),
      left: num(e.borderLeftWidth),
      right: num(e.borderRightWidth)
    },
    margin: {
      top: num(e.marginTop),
      bottom: num(e.marginBottom),
      left: num(e.marginLeft),
      right: num(e.marginRight)
    },
    padding: {
      top: num(e.paddingTop),
      bottom: num(e.paddingBottom),
      left: num(e.paddingLeft),
      right: num(e.paddingRight)
    }
  };
}
function size(t) {
  const e = t.getBoundingClientRect();
  return {
    width: Math.ceil(e.width),
    height: Math.ceil(e.height)
  };
}
function scroll_size(t) {
  return {
    width: Math.ceil(t.scrollWidth),
    height: Math.ceil(t.scrollHeight)
  };
}
function content_size(t) {
  const { left: e, top: r } = t.getBoundingClientRect(), { padding: o } = extents(t);
  let s = 0, l = 0;
  for (const c of t.children) {
    const u = c.getBoundingClientRect();
    s = Math.max(s, Math.ceil(u.left - e - o.left + u.width)), l = Math.max(l, Math.ceil(u.top - r - o.top + u.height));
  }
  return { width: s, height: l };
}
function position(t, e, r) {
  const { style: o } = t;
  if (o.left = `${e.x}px`, o.top = `${e.y}px`, o.width = `${e.width}px`, o.height = `${e.height}px`, r == null)
    o.margin = "";
  else {
    const { top: s, right: l, bottom: c, left: u } = r;
    o.margin = `${s}px ${l}px ${c}px ${u}px`;
  }
}
function children(t) {
  return Array.from(t.children);
}
class ClassList {
  constructor(e) {
    this.el = e, this.classList = e.classList;
  }
  get values() {
    const e = [];
    for (let r = 0; r < this.classList.length; r++) {
      const o = this.classList.item(r);
      o != null && e.push(o);
    }
    return e;
  }
  has(e) {
    return this.classList.contains(e);
  }
  add(...e) {
    for (const r of e)
      this.classList.add(r);
    return this;
  }
  remove(...e) {
    for (const r of e)
      this.classList.remove(r);
    return this;
  }
  clear() {
    for (const e of this.values)
      e != "bk" && this.classList.remove(e);
    return this;
  }
  toggle(e, r) {
    return (r != null ? r : !this.has(e)) ? this.add(e) : this.remove(e), this;
  }
}
ClassList.__name__ = "ClassList";
function classes(t) {
  return new ClassList(t);
}
function toggle_attribute(t, e, r) {
  r == null && (r = !t.hasAttribute(e)), r ? t.setAttribute(e, "true") : t.removeAttribute(e);
}
var Keys;
(function(t) {
  t[t.Backspace = 8] = "Backspace", t[t.Tab = 9] = "Tab", t[t.Enter = 13] = "Enter", t[t.Esc = 27] = "Esc", t[t.PageUp = 33] = "PageUp", t[t.PageDown = 34] = "PageDown", t[t.Left = 37] = "Left", t[t.Up = 38] = "Up", t[t.Right = 39] = "Right", t[t.Down = 40] = "Down", t[t.Delete = 46] = "Delete";
})(Keys || (Keys = {}));
function undisplayed(t, e) {
  const { display: r } = t.style;
  t.style.display = "none";
  try {
    return e();
  } finally {
    t.style.display = r;
  }
}
function unsized(t, e) {
  return sized(t, {}, e);
}
function sized(t, e, r) {
  const { width: o, height: s, position: l, display: c } = t.style;
  t.style.position = "absolute", t.style.display = "", t.style.width = e.width != null && e.width != 1 / 0 ? `${e.width}px` : "auto", t.style.height = e.height != null && e.height != 1 / 0 ? `${e.height}px` : "auto";
  try {
    return r();
  } finally {
    t.style.position = l, t.style.display = c, t.style.width = o, t.style.height = s;
  }
}
class StyleSheet {
  constructor(e) {
    this.root = e, this.known = /* @__PURE__ */ new Set(), this.style = style$2({ type: "text/css" }), prepend(e, this.style);
  }
  append(e) {
    this.known.has(e) || (this.style.appendChild(document.createTextNode(e)), this.known.add(e));
  }
}
StyleSheet.__name__ = "StyleSheet";
const stylesheet = new StyleSheet(document.head), root$3 = "bk-root", root_css = ".bk-root{position:relative;width:auto;height:auto;box-sizing:border-box;font-family:Helvetica, Arial, sans-serif;font-size:13px;}.bk-root .bk,.bk-root .bk:before,.bk-root .bk:after{box-sizing:inherit;margin:0;border:0;padding:0;background-image:none;font-family:inherit;font-size:100%;line-height:1.42857143;}.bk-root pre.bk{font-family:Courier, monospace;}";
class View {
  constructor(e) {
    this.removed = new Signal0(this, "removed"), this._ready = Promise.resolve(void 0), this._slots = /* @__PURE__ */ new WeakMap(), this._idle_notified = !1;
    const { model: r, parent: o } = e;
    this.model = r, this.parent = o, this.root = o == null ? this : o.root, this.removed.emit();
  }
  get ready() {
    return this._ready;
  }
  connect(e, r) {
    let o = this._slots.get(r);
    return o == null && (o = (s, l) => {
      const c = Promise.resolve(r.call(this, s, l));
      this._ready = this._ready.then(() => c);
    }, this._slots.set(r, o)), e.connect(o, this);
  }
  disconnect(e, r) {
    return e.disconnect(r, this);
  }
  initialize() {
    this._has_finished = !1, this.is_root && (this._stylesheet = stylesheet);
    for (const e of this.styles())
      this.stylesheet.append(e);
  }
  async lazy_initialize() {
  }
  remove() {
    this.disconnect_signals(), this.removed.emit();
  }
  toString() {
    return `${this.model.type}View(${this.model.id})`;
  }
  serializable_state() {
    return { type: this.model.type };
  }
  get is_root() {
    return this.parent == null;
  }
  has_finished() {
    return this._has_finished;
  }
  get is_idle() {
    return this.has_finished();
  }
  connect_signals() {
  }
  disconnect_signals() {
    Signal.disconnect_receiver(this);
  }
  on_change(e, r) {
    for (const o of isArray(e) ? e : [e])
      this.connect(o.change, r);
  }
  cursor(e, r) {
    return null;
  }
  get stylesheet() {
    return this.is_root ? this._stylesheet : this.root.stylesheet;
  }
  styles() {
    return [root_css];
  }
  notify_finished() {
    this.is_root ? !this._idle_notified && this.has_finished() && this.model.document != null && (this._idle_notified = !0, this.model.document.notify_idle(this.model)) : this.root.notify_finished();
  }
}
View.__name__ = "View";
class VisualProperties {
  constructor(e, r = "") {
    this.obj = e, this.prefix = r;
    const o = this;
    this._props = [];
    for (const s of this.attrs) {
      const l = e.model.properties[r + s];
      l.change.connect(() => this.update()), o[s] = l, this._props.push(l);
    }
  }
  *[Symbol.iterator]() {
    yield* this._props;
  }
  update() {
  }
}
VisualProperties.__name__ = "VisualProperties";
class VisualUniforms {
  constructor(e, r = "") {
    this.obj = e, this.prefix = r;
    for (const o of this.attrs)
      Object.defineProperty(this, o, {
        get() {
          return e[r + o];
        }
      });
  }
  *[Symbol.iterator]() {
    for (const e of this.attrs)
      yield this.obj.model.properties[this.prefix + e];
  }
  update() {
  }
}
VisualUniforms.__name__ = "VisualUniforms";
const Line$2 = {
  line_color: [Nullable(Color$1), "black"],
  line_alpha: [Alpha, 1],
  line_width: [Number$2, 1],
  line_join: [LineJoin, "bevel"],
  line_cap: [LineCap, "butt"],
  line_dash: [Or(LineDash, Array$2(Number$2)), []],
  line_dash_offset: [Number$2, 0]
}, Fill$1 = {
  fill_color: [Nullable(Color$1), "gray"],
  fill_alpha: [Alpha, 1]
}, Hatch$1 = {
  hatch_color: [Nullable(Color$1), "black"],
  hatch_alpha: [Alpha, 1],
  hatch_scale: [Number$2, 12],
  hatch_pattern: [Nullable(Or(HatchPatternType, String$2)), null],
  hatch_weight: [Number$2, 1],
  hatch_extra: [Dict(AnyRef()), {}]
}, Text$3 = {
  text_color: [Nullable(Color$1), "#444444"],
  text_alpha: [Alpha, 1],
  text_font: [Font, "helvetica"],
  text_font_size: [FontSize$1, "16px"],
  text_font_style: [FontStyle, "normal"],
  text_align: [TextAlign, "left"],
  text_baseline: [TextBaseline, "bottom"],
  text_line_height: [Number$2, 1.2]
}, LineScalar$1 = {
  line_color: [ColorScalar, "black"],
  line_alpha: [NumberScalar, 1],
  line_width: [NumberScalar, 1],
  line_join: [LineJoinScalar, "bevel"],
  line_cap: [LineCapScalar, "butt"],
  line_dash: [LineDashScalar, []],
  line_dash_offset: [NumberScalar, 0]
}, FillScalar$1 = {
  fill_color: [ColorScalar, "gray"],
  fill_alpha: [NumberScalar, 1]
}, HatchScalar$1 = {
  hatch_color: [ColorScalar, "black"],
  hatch_alpha: [NumberScalar, 1],
  hatch_scale: [NumberScalar, 12],
  hatch_pattern: [NullStringScalar, null],
  hatch_weight: [NumberScalar, 1],
  hatch_extra: [AnyScalar, {}]
}, TextScalar$1 = {
  text_color: [ColorScalar, "#444444"],
  text_alpha: [NumberScalar, 1],
  text_font: [FontScalar, "helvetica"],
  text_font_size: [FontSizeScalar, "16px"],
  text_font_style: [FontStyleScalar, "normal"],
  text_align: [TextAlignScalar, "left"],
  text_baseline: [TextBaselineScalar, "bottom"],
  text_line_height: [NumberScalar, 1.2]
}, LineVector$1 = {
  line_color: [ColorSpec, "black"],
  line_alpha: [NumberSpec, 1],
  line_width: [NumberSpec, 1],
  line_join: [LineJoinSpec, "bevel"],
  line_cap: [LineCapSpec, "butt"],
  line_dash: [LineDashSpec, []],
  line_dash_offset: [NumberSpec, 0]
}, FillVector$1 = {
  fill_color: [ColorSpec, "gray"],
  fill_alpha: [NumberSpec, 1]
}, HatchVector$1 = {
  hatch_color: [ColorSpec, "black"],
  hatch_alpha: [NumberSpec, 1],
  hatch_scale: [NumberSpec, 12],
  hatch_pattern: [NullStringSpec, null],
  hatch_weight: [NumberSpec, 1],
  hatch_extra: [AnyScalar, {}]
}, TextVector$1 = {
  text_color: [ColorSpec, "#444444"],
  text_alpha: [NumberSpec, 1],
  text_font: [FontSpec, "helvetica"],
  text_font_size: [FontSizeSpec, "16px"],
  text_font_style: [FontStyleSpec, "normal"],
  text_align: [TextAlignSpec, "left"],
  text_baseline: [TextBaselineSpec, "bottom"],
  text_line_height: [NumberSpec, 1.2]
};
function attrs_of(t, e, r, o = !1) {
  const s = {};
  for (const l of keys(r)) {
    const c = `${e}${l}`, u = t[c];
    s[o ? c : l] = u;
  }
  return s;
}
function resolve_line_dash(t) {
  if (isArray(t))
    return t;
  switch (t) {
    case "solid":
      return [];
    case "dashed":
      return [6];
    case "dotted":
      return [2, 4];
    case "dotdash":
      return [2, 4, 6, 4];
    case "dashdot":
      return [6, 4, 2, 4];
    default:
      return t.split(" ").map(Number).filter(isInteger);
  }
}
class Line$1 extends VisualProperties {
  get doit() {
    const e = this.line_color.get_value(), r = this.line_alpha.get_value(), o = this.line_width.get_value();
    return !(e == null || r == 0 || o == 0);
  }
  apply(e) {
    const { doit: r } = this;
    return r && (this.set_value(e), e.stroke()), r;
  }
  values() {
    return {
      color: this.line_color.get_value(),
      alpha: this.line_alpha.get_value(),
      width: this.line_width.get_value(),
      join: this.line_join.get_value(),
      cap: this.line_cap.get_value(),
      dash: this.line_dash.get_value(),
      offset: this.line_dash_offset.get_value()
    };
  }
  set_value(e) {
    const r = this.line_color.get_value(), o = this.line_alpha.get_value();
    e.strokeStyle = color2css(r, o), e.lineWidth = this.line_width.get_value(), e.lineJoin = this.line_join.get_value(), e.lineCap = this.line_cap.get_value(), e.lineDash = resolve_line_dash(this.line_dash.get_value()), e.lineDashOffset = this.line_dash_offset.get_value();
  }
}
Line$1.__name__ = "Line";
class LineScalar extends VisualUniforms {
  get doit() {
    const e = this.line_color.value, r = this.line_alpha.value, o = this.line_width.value;
    return !(e == 0 || r == 0 || o == 0);
  }
  apply(e) {
    const { doit: r } = this;
    return r && (this.set_value(e), e.stroke()), r;
  }
  values() {
    return {
      color: this.line_color.value,
      alpha: this.line_alpha.value,
      width: this.line_width.value,
      join: this.line_join.value,
      cap: this.line_cap.value,
      dash: this.line_dash.value,
      offset: this.line_dash_offset.value
    };
  }
  set_value(e) {
    const r = this.line_color.value, o = this.line_alpha.value;
    e.strokeStyle = color2css(r, o), e.lineWidth = this.line_width.value, e.lineJoin = this.line_join.value, e.lineCap = this.line_cap.value, e.lineDash = resolve_line_dash(this.line_dash.value), e.lineDashOffset = this.line_dash_offset.value;
  }
}
LineScalar.__name__ = "LineScalar";
class LineVector extends VisualUniforms {
  get doit() {
    const { line_color: e } = this;
    if (e.is_Scalar() && e.value == 0)
      return !1;
    const { line_alpha: r } = this;
    if (r.is_Scalar() && r.value == 0)
      return !1;
    const { line_width: o } = this;
    return !(o.is_Scalar() && o.value == 0);
  }
  apply(e, r) {
    const { doit: o } = this;
    return o && (this.set_vectorize(e, r), e.stroke()), o;
  }
  values(e) {
    return {
      color: this.line_color.get(e),
      alpha: this.line_alpha.get(e),
      width: this.line_width.get(e),
      join: this.line_join.get(e),
      cap: this.line_cap.get(e),
      dash: this.line_dash.get(e),
      offset: this.line_dash_offset.get(e)
    };
  }
  set_vectorize(e, r) {
    const o = this.line_color.get(r), s = this.line_alpha.get(r), l = this.line_width.get(r), c = this.line_join.get(r), u = this.line_cap.get(r), d = this.line_dash.get(r), f = this.line_dash_offset.get(r);
    e.strokeStyle = color2css(o, s), e.lineWidth = l, e.lineJoin = c, e.lineCap = u, e.lineDash = resolve_line_dash(d), e.lineDashOffset = f;
  }
}
LineVector.__name__ = "LineVector";
Line$1.prototype.type = "line";
Line$1.prototype.attrs = Object.keys(Line$2);
LineScalar.prototype.type = "line";
LineScalar.prototype.attrs = Object.keys(LineScalar$1);
LineVector.prototype.type = "line";
LineVector.prototype.attrs = Object.keys(LineVector$1);
class Fill extends VisualProperties {
  get doit() {
    const e = this.fill_color.get_value(), r = this.fill_alpha.get_value();
    return !(e == null || r == 0);
  }
  apply(e, r) {
    const { doit: o } = this;
    return o && (this.set_value(e), e.fill(r)), o;
  }
  values() {
    return {
      color: this.fill_color.get_value(),
      alpha: this.fill_alpha.get_value()
    };
  }
  set_value(e) {
    const r = this.fill_color.get_value(), o = this.fill_alpha.get_value();
    e.fillStyle = color2css(r, o);
  }
}
Fill.__name__ = "Fill";
class FillScalar extends VisualUniforms {
  get doit() {
    const e = this.fill_color.value, r = this.fill_alpha.value;
    return !(e == 0 || r == 0);
  }
  apply(e, r) {
    const { doit: o } = this;
    return o && (this.set_value(e), e.fill(r)), o;
  }
  values() {
    return {
      color: this.fill_color.value,
      alpha: this.fill_alpha.value
    };
  }
  set_value(e) {
    const r = this.fill_color.value, o = this.fill_alpha.value;
    e.fillStyle = color2css(r, o);
  }
}
FillScalar.__name__ = "FillScalar";
class FillVector extends VisualUniforms {
  get doit() {
    const { fill_color: e } = this;
    if (e.is_Scalar() && e.value == 0)
      return !1;
    const { fill_alpha: r } = this;
    return !(r.is_Scalar() && r.value == 0);
  }
  apply(e, r, o) {
    const { doit: s } = this;
    return s && (this.set_vectorize(e, r), e.fill(o)), s;
  }
  values(e) {
    return {
      color: this.fill_color.get(e),
      alpha: this.fill_alpha.get(e)
    };
  }
  set_vectorize(e, r) {
    const o = this.fill_color.get(r), s = this.fill_alpha.get(r);
    e.fillStyle = color2css(o, s);
  }
}
FillVector.__name__ = "FillVector";
Fill.prototype.type = "fill";
Fill.prototype.attrs = Object.keys(Fill$1);
FillScalar.prototype.type = "fill";
FillScalar.prototype.attrs = Object.keys(FillScalar$1);
FillVector.prototype.type = "fill";
FillVector.prototype.attrs = Object.keys(FillVector$1);
class Text$2 extends VisualProperties {
  get doit() {
    const e = this.text_color.get_value(), r = this.text_alpha.get_value();
    return !(e == null || r == 0);
  }
  values() {
    return {
      color: this.text_color.get_value(),
      alpha: this.text_alpha.get_value(),
      font: this.text_font.get_value(),
      font_size: this.text_font_size.get_value(),
      font_style: this.text_font_style.get_value(),
      align: this.text_align.get_value(),
      baseline: this.text_baseline.get_value(),
      line_height: this.text_line_height.get_value()
    };
  }
  set_value(e) {
    const r = this.text_color.get_value(), o = this.text_alpha.get_value();
    e.fillStyle = color2css(r, o), e.font = this.font_value(), e.textAlign = this.text_align.get_value(), e.textBaseline = this.text_baseline.get_value();
  }
  font_value() {
    const e = this.text_font_style.get_value(), r = this.text_font_size.get_value(), o = this.text_font.get_value();
    return `${e} ${r} ${o}`;
  }
}
Text$2.__name__ = "Text";
class TextScalar extends VisualUniforms {
  get doit() {
    const e = this.text_color.value, r = this.text_alpha.value;
    return !(e == 0 || r == 0);
  }
  values() {
    return {
      color: this.text_color.value,
      alpha: this.text_alpha.value,
      font: this.text_font.value,
      font_size: this.text_font_size.value,
      font_style: this.text_font_style.value,
      align: this.text_align.value,
      baseline: this.text_baseline.value,
      line_height: this.text_line_height.value
    };
  }
  set_value(e) {
    const r = this.text_color.value, o = this.text_alpha.value, s = this.font_value(), l = this.text_align.value, c = this.text_baseline.value;
    e.fillStyle = color2css(r, o), e.font = s, e.textAlign = l, e.textBaseline = c;
  }
  font_value() {
    const e = this.text_font_style.value, r = this.text_font_size.value, o = this.text_font.value;
    return `${e} ${r} ${o}`;
  }
}
TextScalar.__name__ = "TextScalar";
class TextVector extends VisualUniforms {
  values(e) {
    return {
      color: this.text_color.get(e),
      alpha: this.text_alpha.get(e),
      font: this.text_font.get(e),
      font_size: this.text_font_size.get(e),
      font_style: this.text_font_style.get(e),
      align: this.text_align.get(e),
      baseline: this.text_baseline.get(e),
      line_height: this.text_line_height.get(e)
    };
  }
  get doit() {
    const { text_color: e } = this;
    if (e.is_Scalar() && e.value == 0)
      return !1;
    const { text_alpha: r } = this;
    return !(r.is_Scalar() && r.value == 0);
  }
  set_vectorize(e, r) {
    const o = this.text_color.get(r), s = this.text_alpha.get(r), l = this.font_value(r), c = this.text_align.get(r), u = this.text_baseline.get(r);
    e.fillStyle = color2css(o, s), e.font = l, e.textAlign = c, e.textBaseline = u;
  }
  font_value(e) {
    const r = this.text_font_style.get(e), o = this.text_font_size.get(e), s = this.text_font.get(e);
    return `${r} ${o} ${s}`;
  }
}
TextVector.__name__ = "TextVector";
Text$2.prototype.type = "text";
Text$2.prototype.attrs = Object.keys(Text$3);
TextScalar.prototype.type = "text";
TextScalar.prototype.attrs = Object.keys(TextScalar$1);
TextVector.prototype.type = "text";
TextVector.prototype.attrs = Object.keys(TextVector$1);
function _horz(t, e, r) {
  t.moveTo(0, r + 0.5), t.lineTo(e, r + 0.5), t.stroke();
}
function _vert(t, e, r) {
  t.moveTo(r + 0.5, 0), t.lineTo(r + 0.5, e), t.stroke();
}
function _x(t, e) {
  t.moveTo(0, e), t.lineTo(e, 0), t.stroke(), t.moveTo(0, 0), t.lineTo(e, e), t.stroke();
}
const hatch_aliases = {
  " ": "blank",
  ".": "dot",
  o: "ring",
  "-": "horizontal_line",
  "|": "vertical_line",
  "+": "cross",
  '"': "horizontal_dash",
  ":": "vertical_dash",
  "@": "spiral",
  "/": "right_diagonal_line",
  "\\": "left_diagonal_line",
  x: "diagonal_cross",
  ",": "right_diagonal_dash",
  "`": "left_diagonal_dash",
  v: "horizontal_wave",
  ">": "vertical_wave",
  "*": "criss_cross"
};
function get_pattern(t, e, r, o, s, l) {
  return t.resize(s, s), t.prepare(), create_hatch_canvas(t.ctx, e, r, o, s, l), t.canvas;
}
function create_hatch_canvas(t, e, r, o, s, l) {
  var T;
  const c = s, u = c / 2, d = u / 2, f = color2css(r, o);
  switch (t.strokeStyle = f, t.fillStyle = f, t.lineCap = "square", t.lineWidth = l, (T = hatch_aliases[e]) != null ? T : e) {
    case "blank":
      break;
    case "dot":
      t.arc(u, u, u / 2, 0, 2 * Math.PI, !0), t.fill();
      break;
    case "ring":
      t.arc(u, u, u / 2, 0, 2 * Math.PI, !0), t.stroke();
      break;
    case "horizontal_line":
      _horz(t, c, u);
      break;
    case "vertical_line":
      _vert(t, c, u);
      break;
    case "cross":
      _horz(t, c, u), _vert(t, c, u);
      break;
    case "horizontal_dash":
      _horz(t, u, u);
      break;
    case "vertical_dash":
      _vert(t, u, u);
      break;
    case "spiral": {
      const Q = c / 30;
      t.moveTo(u, u);
      for (let m = 0; m < 360; m++) {
        const g = 0.1 * m, v = u + Q * g * Math.cos(g), b = u + Q * g * Math.sin(g);
        t.lineTo(v, b);
      }
      t.stroke();
      break;
    }
    case "right_diagonal_line":
      t.moveTo(-d + 0.5, c), t.lineTo(d + 0.5, 0), t.stroke(), t.moveTo(d + 0.5, c), t.lineTo(3 * d + 0.5, 0), t.stroke(), t.moveTo(3 * d + 0.5, c), t.lineTo(5 * d + 0.5, 0), t.stroke(), t.stroke();
      break;
    case "left_diagonal_line":
      t.moveTo(d + 0.5, c), t.lineTo(-d + 0.5, 0), t.stroke(), t.moveTo(3 * d + 0.5, c), t.lineTo(d + 0.5, 0), t.stroke(), t.moveTo(5 * d + 0.5, c), t.lineTo(3 * d + 0.5, 0), t.stroke(), t.stroke();
      break;
    case "diagonal_cross":
      _x(t, c);
      break;
    case "right_diagonal_dash":
      t.moveTo(d + 0.5, 3 * d + 0.5), t.lineTo(3 * d + 0.5, d + 0.5), t.stroke();
      break;
    case "left_diagonal_dash":
      t.moveTo(d + 0.5, d + 0.5), t.lineTo(3 * d + 0.5, 3 * d + 0.5), t.stroke();
      break;
    case "horizontal_wave":
      t.moveTo(0, d), t.lineTo(u, 3 * d), t.lineTo(c, d), t.stroke();
      break;
    case "vertical_wave":
      t.moveTo(d, 0), t.lineTo(3 * d, u), t.lineTo(d, c), t.stroke();
      break;
    case "criss_cross":
      _x(t, c), _horz(t, c, u), _vert(t, c, u);
      break;
  }
}
class Hatch extends VisualProperties {
  constructor() {
    super(...arguments), this._update_iteration = 0;
  }
  update() {
    if (this._update_iteration++, this._hatch_image = null, !this.doit)
      return;
    const e = this.hatch_color.get_value(), r = this.hatch_alpha.get_value(), o = this.hatch_scale.get_value(), s = this.hatch_pattern.get_value(), l = this.hatch_weight.get_value(), c = (f) => {
      this._hatch_image = f;
    }, d = this.hatch_extra.get_value()[s];
    if (d != null) {
      const f = d.get_pattern(e, r, o, l);
      if (f instanceof Promise) {
        const { _update_iteration: T } = this;
        f.then((Q) => {
          this._update_iteration == T && (c(Q), this.obj.request_render());
        });
      } else
        c(f);
    } else {
      const f = this.obj.canvas.create_layer(), T = get_pattern(f, s, e, r, o, l);
      c(T);
    }
  }
  get doit() {
    const e = this.hatch_color.get_value(), r = this.hatch_alpha.get_value(), o = this.hatch_pattern.get_value();
    return !(e == null || r == 0 || o == " " || o == "blank" || o == null);
  }
  apply(e, r) {
    const { doit: o } = this;
    return o && (this.set_value(e), e.layer.undo_transform(() => e.fill(r))), o;
  }
  set_value(e) {
    const r = this.pattern(e);
    e.fillStyle = r != null ? r : "transparent";
  }
  pattern(e) {
    const r = this._hatch_image;
    return r == null ? null : e.createPattern(r, this.repetition());
  }
  repetition() {
    const e = this.hatch_pattern.get_value(), r = this.hatch_extra.get_value()[e];
    if (r == null)
      return "repeat";
    switch (r.repetition) {
      case "repeat":
        return "repeat";
      case "repeat_x":
        return "repeat-x";
      case "repeat_y":
        return "repeat-y";
      case "no_repeat":
        return "no-repeat";
    }
  }
}
Hatch.__name__ = "Hatch";
class HatchScalar extends VisualUniforms {
  constructor() {
    super(...arguments), this._static_doit = !1, this._update_iteration = 0;
  }
  _compute_static_doit() {
    const e = this.hatch_color.value, r = this.hatch_alpha.value, o = this.hatch_pattern.value;
    return !(e == null || r == 0 || o == " " || o == "blank" || o == null);
  }
  update() {
    this._update_iteration++;
    const e = this.hatch_color.length;
    if (this._hatch_image = new UniformScalar(null, e), this._static_doit = this._compute_static_doit(), !this._static_doit)
      return;
    const r = this.hatch_color.value, o = this.hatch_alpha.value, s = this.hatch_scale.value, l = this.hatch_pattern.value, c = this.hatch_weight.value, u = (T) => {
      this._hatch_image = new UniformScalar(T, e);
    }, f = this.hatch_extra.value[l];
    if (f != null) {
      const T = f.get_pattern(r, o, s, c);
      if (T instanceof Promise) {
        const { _update_iteration: Q } = this;
        T.then((m) => {
          this._update_iteration == Q && (u(m), this.obj.request_render());
        });
      } else
        u(T);
    } else {
      const T = this.obj.canvas.create_layer(), Q = get_pattern(T, l, r, o, s, c);
      u(Q);
    }
  }
  get doit() {
    return this._static_doit;
  }
  apply(e, r) {
    const { doit: o } = this;
    return o && (this.set_value(e), e.layer.undo_transform(() => e.fill(r))), o;
  }
  set_value(e) {
    var r;
    e.fillStyle = (r = this.pattern(e)) != null ? r : "transparent";
  }
  pattern(e) {
    const r = this._hatch_image.value;
    return r == null ? null : e.createPattern(r, this.repetition());
  }
  repetition() {
    const e = this.hatch_pattern.value, r = this.hatch_extra.value[e];
    if (r == null)
      return "repeat";
    switch (r.repetition) {
      case "repeat":
        return "repeat";
      case "repeat_x":
        return "repeat-x";
      case "repeat_y":
        return "repeat-y";
      case "no_repeat":
        return "no-repeat";
    }
  }
}
HatchScalar.__name__ = "HatchScalar";
class HatchVector extends VisualUniforms {
  constructor() {
    super(...arguments), this._static_doit = !1, this._update_iteration = 0;
  }
  _compute_static_doit() {
    const { hatch_color: e } = this;
    if (e.is_Scalar() && e.value == 0)
      return !1;
    const { hatch_alpha: r } = this;
    if (r.is_Scalar() && r.value == 0)
      return !1;
    const { hatch_pattern: o } = this;
    if (o.is_Scalar()) {
      const s = o.value;
      if (s == " " || s == "blank" || s == null)
        return !1;
    }
    return !0;
  }
  update() {
    this._update_iteration++;
    const e = this.hatch_color.length;
    if (this._hatch_image = new UniformScalar(null, e), this._static_doit = this._compute_static_doit(), !this._static_doit)
      return;
    const r = (o, s, l, c, u, d) => {
      const T = this.hatch_extra.value[o];
      if (T != null) {
        const Q = T.get_pattern(s, l, c, u);
        if (Q instanceof Promise) {
          const { _update_iteration: m } = this;
          Q.then((g) => {
            this._update_iteration == m && (d(g), this.obj.request_render());
          });
        } else
          d(Q);
      } else {
        const Q = this.obj.canvas.create_layer(), m = get_pattern(Q, o, s, l, c, u);
        d(m);
      }
    };
    if (this.hatch_color.is_Scalar() && this.hatch_alpha.is_Scalar() && this.hatch_scale.is_Scalar() && this.hatch_pattern.is_Scalar() && this.hatch_weight.is_Scalar()) {
      const o = this.hatch_color.value, s = this.hatch_alpha.value, l = this.hatch_scale.value, c = this.hatch_pattern.value, u = this.hatch_weight.value;
      r(c, o, s, l, u, (d) => {
        this._hatch_image = new UniformScalar(d, e);
      });
    } else {
      const o = new Array(e);
      o.fill(null), this._hatch_image = new UniformVector(o);
      for (let s = 0; s < e; s++) {
        const l = this.hatch_color.get(s), c = this.hatch_alpha.get(s), u = this.hatch_scale.get(s), d = this.hatch_pattern.get(s), f = this.hatch_weight.get(s);
        r(d, l, c, u, f, (T) => {
          o[s] = T;
        });
      }
    }
  }
  get doit() {
    return this._static_doit;
  }
  apply(e, r, o) {
    const { doit: s } = this;
    return s && (this.set_vectorize(e, r), e.layer.undo_transform(() => e.fill(o))), s;
  }
  set_vectorize(e, r) {
    var o;
    e.fillStyle = (o = this.pattern(e, r)) != null ? o : "transparent";
  }
  pattern(e, r) {
    const o = this._hatch_image.get(r);
    return o == null ? null : e.createPattern(o, this.repetition(r));
  }
  repetition(e) {
    const r = this.hatch_pattern.get(e), o = this.hatch_extra.value[r];
    if (o == null)
      return "repeat";
    switch (o.repetition) {
      case "repeat":
        return "repeat";
      case "repeat_x":
        return "repeat-x";
      case "repeat_y":
        return "repeat-y";
      case "no_repeat":
        return "no-repeat";
    }
  }
}
HatchVector.__name__ = "HatchVector";
Hatch.prototype.type = "hatch";
Hatch.prototype.attrs = Object.keys(Hatch$1);
HatchScalar.prototype.type = "hatch";
HatchScalar.prototype.attrs = Object.keys(HatchScalar$1);
HatchVector.prototype.type = "hatch";
HatchVector.prototype.attrs = Object.keys(HatchVector$1);
class Visuals {
  constructor(e) {
    this._visuals = [];
    for (const [r, o] of e.model._mixins) {
      const s = (() => {
        switch (o) {
          case Line$2:
            return new Line$1(e, r);
          case LineScalar$1:
            return new LineScalar(e, r);
          case LineVector$1:
            return new LineVector(e, r);
          case Fill$1:
            return new Fill(e, r);
          case FillScalar$1:
            return new FillScalar(e, r);
          case FillVector$1:
            return new FillVector(e, r);
          case Text$3:
            return new Text$2(e, r);
          case TextScalar$1:
            return new TextScalar(e, r);
          case TextVector$1:
            return new TextVector(e, r);
          case Hatch$1:
            return new Hatch(e, r);
          case HatchScalar$1:
            return new HatchScalar(e, r);
          case HatchVector$1:
            return new HatchVector(e, r);
          default:
            throw new Error("unknown visual");
        }
      })();
      s instanceof VisualProperties && s.update(), this._visuals.push(s), Object.defineProperty(this, r + s.type, {
        get() {
          return s;
        },
        configurable: !1,
        enumerable: !0
      });
    }
  }
  *[Symbol.iterator]() {
    yield* this._visuals;
  }
}
Visuals.__name__ = "Visuals";
var _a$3S;
class Model extends HasProps {
  constructor(e) {
    super(e);
  }
  get is_syncable() {
    return this.syncable;
  }
  [equals](e, r) {
    return r.eq(this.id, e.id) && super[equals](e, r);
  }
  initialize() {
    super.initialize(), this._js_callbacks = /* @__PURE__ */ new Map();
  }
  connect_signals() {
    super.connect_signals(), this._update_property_callbacks(), this.connect(this.properties.js_property_callbacks.change, () => this._update_property_callbacks()), this.connect(this.properties.js_event_callbacks.change, () => this._update_event_callbacks()), this.connect(this.properties.subscribed_events.change, () => this._update_event_callbacks());
  }
  _process_event(e) {
    var r;
    for (const o of (r = this.js_event_callbacks[e.event_name]) != null ? r : [])
      o.execute(e);
    this.document != null && this.subscribed_events.some((o) => o == e.event_name) && this.document.event_manager.send_event(e);
  }
  trigger_event(e) {
    this.document != null && (e.origin = this, this.document.event_manager.trigger(e));
  }
  _update_event_callbacks() {
    if (this.document == null) {
      logger.warn("WARNING: Document not defined for updating event callbacks");
      return;
    }
    this.document.event_manager.subscribed_models.add(this);
  }
  _update_property_callbacks() {
    const e = (r) => {
      const [o, s = null] = r.split(":");
      return s != null ? this.properties[s][o] : this[o];
    };
    for (const [r, o] of this._js_callbacks) {
      const s = e(r);
      for (const l of o)
        this.disconnect(s, l);
    }
    this._js_callbacks.clear();
    for (const [r, o] of entries(this.js_property_callbacks)) {
      const s = o.map((c) => () => c.execute(this));
      this._js_callbacks.set(r, s);
      const l = e(r);
      for (const c of s)
        this.connect(l, c);
    }
  }
  _doc_attached() {
    (!isEmpty(this.js_event_callbacks) || this.subscribed_events.length != 0) && this._update_event_callbacks();
  }
  _doc_detached() {
    this.document.event_manager.subscribed_models.delete(this);
  }
  select(e) {
    if (isString(e))
      return [...this.references()].filter((r) => r instanceof Model && r.name === e);
    if (e.prototype instanceof HasProps)
      return [...this.references()].filter((r) => r instanceof e);
    throw new Error("invalid selector");
  }
  select_one(e) {
    const r = this.select(e);
    switch (r.length) {
      case 0:
        return null;
      case 1:
        return r[0];
      default:
        throw new Error("found more than one object matching given selector");
    }
  }
}
_a$3S = Model;
Model.__name__ = "Model";
_a$3S.define(({ Any: t, Unknown: e, Boolean: r, String: o, Array: s, Dict: l, Nullable: c }) => ({
  tags: [s(e), []],
  name: [c(o), null],
  js_property_callbacks: [l(s(t)), {}],
  js_event_callbacks: [l(s(t)), {}],
  subscribed_events: [s(o), []],
  syncable: [r, !0]
}));
class Transform extends Model {
  constructor(e) {
    super(e);
  }
}
Transform.__name__ = "Transform";
var _a$3R;
class Range$1 extends Model {
  constructor(e) {
    super(e), this.have_updated_interactively = !1;
  }
  get is_reversed() {
    return this.start > this.end;
  }
  get is_valid() {
    return isFinite(this.min) && isFinite(this.max);
  }
  get span() {
    return Math.abs(this.end - this.start);
  }
}
_a$3R = Range$1;
Range$1.__name__ = "Range";
_a$3R.define(({ Number: t, Tuple: e, Or: r, Auto: o, Nullable: s }) => ({
  bounds: [s(r(e(s(t), s(t)), o)), null],
  min_interval: [s(t), null],
  max_interval: [s(t), null]
})), _a$3R.internal(({ Array: t, AnyRef: e }) => ({
  plots: [t(e()), []]
}));
var _a$3Q;
class Range1d extends Range$1 {
  constructor(e) {
    super(e);
  }
  _set_auto_bounds() {
    if (this.bounds == "auto") {
      const e = Math.min(this._reset_start, this._reset_end), r = Math.max(this._reset_start, this._reset_end);
      this.setv({ bounds: [e, r] }, { silent: !0 });
    }
  }
  initialize() {
    super.initialize(), this._set_auto_bounds();
  }
  get min() {
    return Math.min(this.start, this.end);
  }
  get max() {
    return Math.max(this.start, this.end);
  }
  reset() {
    this._set_auto_bounds();
    const { _reset_start: e, _reset_end: r } = this;
    this.start != e || this.end != r ? this.setv({ start: e, end: r }) : this.change.emit();
  }
  map(e) {
    return new Range1d({ start: e(this.start), end: e(this.end) });
  }
  widen(e) {
    let { start: r, end: o } = this;
    return this.is_reversed ? (r += e, o -= e) : (r -= e, o += e), new Range1d({ start: r, end: o });
  }
}
_a$3Q = Range1d;
Range1d.__name__ = "Range1d";
_a$3Q.define(({ Number: t, Nullable: e }) => ({
  start: [t, 0],
  end: [t, 1],
  reset_start: [e(t), null, {
    on_update(r, o) {
      o._reset_start = r != null ? r : o.start;
    }
  }],
  reset_end: [e(t), null, {
    on_update(r, o) {
      o._reset_end = r != null ? r : o.end;
    }
  }]
}));
var _a$3P;
class Scale extends Transform {
  constructor(e) {
    super(e);
  }
  compute(e) {
    return this.s_compute(e);
  }
  v_compute(e) {
    const r = new ScreenArray(e.length), { s_compute: o } = this;
    for (let s = 0; s < e.length; s++)
      r[s] = o(e[s]);
    return r;
  }
  invert(e) {
    return this.s_invert(e);
  }
  v_invert(e) {
    const r = new Float64Array(e.length), { s_invert: o } = this;
    for (let s = 0; s < e.length; s++)
      r[s] = o(e[s]);
    return r;
  }
  r_compute(e, r) {
    const { s_compute: o } = this;
    return this.target_range.is_reversed ? [o(r), o(e)] : [o(e), o(r)];
  }
  r_invert(e, r) {
    const { s_invert: o } = this;
    return this.target_range.is_reversed ? [o(r), o(e)] : [o(e), o(r)];
  }
}
_a$3P = Scale;
Scale.__name__ = "Scale";
_a$3P.internal(({ Ref: t }) => ({
  source_range: [t(Range$1)],
  target_range: [t(Range1d)]
}));
class ContinuousScale extends Scale {
  constructor(e) {
    super(e);
  }
}
ContinuousScale.__name__ = "ContinuousScale";
class LinearScale extends ContinuousScale {
  constructor(e) {
    super(e);
  }
  get s_compute() {
    const [e, r] = this._linear_compute_state();
    return (o) => e * o + r;
  }
  get s_invert() {
    const [e, r] = this._linear_compute_state();
    return (o) => (o - r) / e;
  }
  _linear_compute_state() {
    const e = this.source_range.start, r = this.source_range.end, o = this.target_range.start, l = (this.target_range.end - o) / (r - e), c = -(l * e) + o;
    return [l, c];
  }
}
LinearScale.__name__ = "LinearScale";
class LogScale extends ContinuousScale {
  constructor(e) {
    super(e);
  }
  get s_compute() {
    const [e, r, o, s] = this._compute_state();
    return (l) => {
      if (o == 0)
        return 0;
      {
        const c = (Math.log(l) - s) / o;
        return isFinite(c) ? c * e + r : NaN;
      }
    };
  }
  get s_invert() {
    const [e, r, o, s] = this._compute_state();
    return (l) => {
      const c = (l - r) / e;
      return Math.exp(o * c + s);
    };
  }
  _get_safe_factor(e, r) {
    let o = e < 0 ? 0 : e, s = r < 0 ? 0 : r;
    if (o == s)
      if (o == 0)
        [o, s] = [1, 10];
      else {
        const l = Math.log(o) / Math.log(10);
        o = 10 ** Math.floor(l), Math.ceil(l) != Math.floor(l) ? s = 10 ** Math.ceil(l) : s = 10 ** (Math.ceil(l) + 1);
      }
    return [o, s];
  }
  _compute_state() {
    const e = this.source_range.start, r = this.source_range.end, o = this.target_range.start, l = this.target_range.end - o, [c, u] = this._get_safe_factor(e, r);
    let d, f;
    return c == 0 ? (d = Math.log(u), f = 0) : (d = Math.log(u) - Math.log(c), f = Math.log(c)), [l, o, d, f];
  }
}
LogScale.__name__ = "LogScale";
const { _linear_compute_state } = LinearScale.prototype;
class CategoricalScale extends Scale {
  constructor(e) {
    super(e);
  }
  get s_compute() {
    const [e, r] = _linear_compute_state.call(this), o = this.source_range;
    return (s) => e * o.synthetic(s) + r;
  }
  get s_invert() {
    const [e, r] = _linear_compute_state.call(this);
    return (o) => (o - r) / e;
  }
}
CategoricalScale.__name__ = "CategoricalScale";
var _a$3O;
class DataRange extends Range$1 {
  constructor(e) {
    super(e);
  }
}
_a$3O = DataRange;
DataRange.__name__ = "DataRange";
_a$3O.define(({ String: t, Array: e, AnyRef: r }) => ({
  names: [e(t), []],
  renderers: [e(r()), []]
}));
const { min: min$5, max: max$7 } = Math;
function empty() {
  return {
    x0: 1 / 0,
    y0: 1 / 0,
    x1: -1 / 0,
    y1: -1 / 0
  };
}
function positive_x() {
  return {
    x0: Number.MIN_VALUE,
    y0: -1 / 0,
    x1: 1 / 0,
    y1: 1 / 0
  };
}
function positive_y() {
  return {
    x0: -1 / 0,
    y0: Number.MIN_VALUE,
    x1: 1 / 0,
    y1: 1 / 0
  };
}
function union$1(t, e) {
  return {
    x0: min$5(t.x0, e.x0),
    x1: max$7(t.x1, e.x1),
    y0: min$5(t.y0, e.y0),
    y1: max$7(t.y1, e.y1)
  };
}
class BBox$2 {
  constructor(e) {
    if (e == null)
      this.x0 = 0, this.y0 = 0, this.x1 = 0, this.y1 = 0;
    else if ("x0" in e) {
      const { x0: r, y0: o, x1: s, y1: l } = e;
      if (!(r <= s && o <= l))
        throw new Error(`invalid bbox {x0: ${r}, y0: ${o}, x1: ${s}, y1: ${l}}`);
      this.x0 = r, this.y0 = o, this.x1 = s, this.y1 = l;
    } else if ("x" in e) {
      const { x: r, y: o, width: s, height: l } = e;
      if (!(s >= 0 && l >= 0))
        throw new Error(`invalid bbox {x: ${r}, y: ${o}, width: ${s}, height: ${l}}`);
      this.x0 = r, this.y0 = o, this.x1 = r + s, this.y1 = o + l;
    } else {
      let r, o, s, l;
      if ("width" in e)
        if ("left" in e)
          r = e.left, o = r + e.width;
        else if ("right" in e)
          o = e.right, r = o - e.width;
        else {
          const c = e.width / 2;
          r = e.hcenter - c, o = e.hcenter + c;
        }
      else
        r = e.left, o = e.right;
      if ("height" in e)
        if ("top" in e)
          s = e.top, l = s + e.height;
        else if ("bottom" in e)
          l = e.bottom, s = l - e.height;
        else {
          const c = e.height / 2;
          s = e.vcenter - c, l = e.vcenter + c;
        }
      else
        s = e.top, l = e.bottom;
      if (!(r <= o && s <= l))
        throw new Error(`invalid bbox {left: ${r}, top: ${s}, right: ${o}, bottom: ${l}}`);
      this.x0 = r, this.y0 = s, this.x1 = o, this.y1 = l;
    }
  }
  static from_rect({ left: e, right: r, top: o, bottom: s }) {
    return new BBox$2({
      x0: Math.min(e, r),
      y0: Math.min(o, s),
      x1: Math.max(e, r),
      y1: Math.max(o, s)
    });
  }
  equals(e) {
    return this.x0 == e.x0 && this.y0 == e.y0 && this.x1 == e.x1 && this.y1 == e.y1;
  }
  [equals](e, r) {
    return r.eq(this.x0, e.x0) && r.eq(this.y0, e.y0) && r.eq(this.x1, e.x1) && r.eq(this.y1, e.y1);
  }
  toString() {
    return `BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`;
  }
  get left() {
    return this.x0;
  }
  get top() {
    return this.y0;
  }
  get right() {
    return this.x1;
  }
  get bottom() {
    return this.y1;
  }
  get p0() {
    return [this.x0, this.y0];
  }
  get p1() {
    return [this.x1, this.y1];
  }
  get x() {
    return this.x0;
  }
  get y() {
    return this.y0;
  }
  get width() {
    return this.x1 - this.x0;
  }
  get height() {
    return this.y1 - this.y0;
  }
  get size() {
    return { width: this.width, height: this.height };
  }
  get rect() {
    const { x0: e, y0: r, x1: o, y1: s } = this;
    return {
      p0: { x: e, y: r },
      p1: { x: o, y: r },
      p2: { x: o, y: s },
      p3: { x: e, y: s }
    };
  }
  get box() {
    const { x: e, y: r, width: o, height: s } = this;
    return { x: e, y: r, width: o, height: s };
  }
  get h_range() {
    return { start: this.x0, end: this.x1 };
  }
  get v_range() {
    return { start: this.y0, end: this.y1 };
  }
  get ranges() {
    return [this.h_range, this.v_range];
  }
  get aspect() {
    return this.width / this.height;
  }
  get hcenter() {
    return (this.left + this.right) / 2;
  }
  get vcenter() {
    return (this.top + this.bottom) / 2;
  }
  get area() {
    return this.width * this.height;
  }
  relative() {
    const { width: e, height: r } = this;
    return new BBox$2({ x: 0, y: 0, width: e, height: r });
  }
  translate(e, r) {
    const { x: o, y: s, width: l, height: c } = this;
    return new BBox$2({ x: e + o, y: r + s, width: l, height: c });
  }
  relativize(e, r) {
    return [e - this.x, r - this.y];
  }
  contains(e, r) {
    return this.x0 <= e && e <= this.x1 && this.y0 <= r && r <= this.y1;
  }
  clip(e, r) {
    return e < this.x0 ? e = this.x0 : e > this.x1 && (e = this.x1), r < this.y0 ? r = this.y0 : r > this.y1 && (r = this.y1), [e, r];
  }
  grow_by(e) {
    return new BBox$2({
      left: this.left - e,
      right: this.right + e,
      top: this.top - e,
      bottom: this.bottom + e
    });
  }
  shrink_by(e) {
    return new BBox$2({
      left: this.left + e,
      right: this.right - e,
      top: this.top + e,
      bottom: this.bottom - e
    });
  }
  union(e) {
    return new BBox$2({
      x0: min$5(this.x0, e.x0),
      y0: min$5(this.y0, e.y0),
      x1: max$7(this.x1, e.x1),
      y1: max$7(this.y1, e.y1)
    });
  }
  intersection(e) {
    return this.intersects(e) ? new BBox$2({
      x0: max$7(this.x0, e.x0),
      y0: max$7(this.y0, e.y0),
      x1: min$5(this.x1, e.x1),
      y1: min$5(this.y1, e.y1)
    }) : null;
  }
  intersects(e) {
    return !(e.x1 < this.x0 || e.x0 > this.x1 || e.y1 < this.y0 || e.y0 > this.y1);
  }
  get xview() {
    return {
      compute: (e) => this.left + e,
      v_compute: (e) => {
        const r = new ScreenArray(e.length), o = this.left;
        for (let s = 0; s < e.length; s++)
          r[s] = o + e[s];
        return r;
      }
    };
  }
  get yview() {
    return {
      compute: (e) => this.bottom - e,
      v_compute: (e) => {
        const r = new ScreenArray(e.length), o = this.bottom;
        for (let s = 0; s < e.length; s++)
          r[s] = o - e[s];
        return r;
      }
    };
  }
}
BBox$2.__name__ = "BBox";
function compute_renderers(t, e, r) {
  if (t == null)
    return [];
  let o = t == "auto" ? e : t;
  return r.length > 0 && (o = o.filter((s) => includes(r, s.name))), o;
}
var _a$3N;
class DataRange1d extends DataRange {
  constructor(e) {
    super(e), this.have_updated_interactively = !1;
  }
  initialize() {
    super.initialize(), this._initial_start = this.start, this._initial_end = this.end, this._initial_range_padding = this.range_padding, this._initial_range_padding_units = this.range_padding_units, this._initial_follow = this.follow, this._initial_follow_interval = this.follow_interval, this._initial_default_span = this.default_span, this._plot_bounds = /* @__PURE__ */ new Map();
  }
  get min() {
    return Math.min(this.start, this.end);
  }
  get max() {
    return Math.max(this.start, this.end);
  }
  computed_renderers() {
    const { renderers: e, names: r } = this, o = concat$1(this.plots.map((s) => s.data_renderers));
    return compute_renderers(e.length == 0 ? "auto" : e, o, r);
  }
  _compute_plot_bounds(e, r) {
    let o = empty();
    for (const s of e) {
      const l = r.get(s);
      l != null && (s.visible || !this.only_visible) && (o = union$1(o, l));
    }
    return o;
  }
  adjust_bounds_for_aspect(e, r) {
    const o = empty();
    let s = e.x1 - e.x0;
    s <= 0 && (s = 1);
    let l = e.y1 - e.y0;
    l <= 0 && (l = 1);
    const c = 0.5 * (e.x1 + e.x0), u = 0.5 * (e.y1 + e.y0);
    return s < r * l ? s = r * l : l = s / r, o.x1 = c + 0.5 * s, o.x0 = c - 0.5 * s, o.y1 = u + 0.5 * l, o.y0 = u - 0.5 * l, o;
  }
  _compute_min_max(e, r) {
    let o = empty();
    for (const [c, u] of e)
      c.visible && (o = union$1(o, u));
    let s, l;
    return r == 0 ? [s, l] = [o.x0, o.x1] : [s, l] = [o.y0, o.y1], [s, l];
  }
  _compute_range(e, r) {
    const o = this.range_padding;
    let s, l;
    if (this._initial_start != null && (e = this._initial_start), this._initial_end != null && (r = this._initial_end), this.scale_hint == "log") {
      (isNaN(e) || !isFinite(e) || e <= 0) && (isNaN(r) || !isFinite(r) || r <= 0 ? e = 0.1 : e = r / 100, logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${e}`)), (isNaN(r) || !isFinite(r) || r <= 0) && (isNaN(e) || !isFinite(e) || e <= 0 ? r = 10 : r = e * 100, logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${r}`));
      let d, f;
      if (r == e)
        f = this.default_span + 1e-3, d = Math.log(e) / Math.log(10);
      else {
        let T, Q;
        this.range_padding_units == "percent" ? (T = Math.log(e) / Math.log(10), Q = Math.log(r) / Math.log(10), f = (Q - T) * (1 + o)) : (T = Math.log(e - o) / Math.log(10), Q = Math.log(r + o) / Math.log(10), f = Q - T), d = (T + Q) / 2;
      }
      s = 10 ** (d - f / 2), l = 10 ** (d + f / 2);
    } else {
      let d;
      r == e ? d = this.default_span : this.range_padding_units == "percent" ? d = (r - e) * (1 + o) : d = r - e + 2 * o;
      const f = (r + e) / 2;
      s = f - d / 2, l = f + d / 2;
    }
    let c = 1;
    this.flipped && ([s, l] = [l, s], c = -1);
    const u = this.follow_interval;
    return u != null && Math.abs(s - l) > u && (this.follow == "start" ? l = s + c * u : this.follow == "end" && (s = l - c * u)), [s, l];
  }
  update(e, r, o, s) {
    if (this.have_updated_interactively)
      return;
    const l = this.computed_renderers();
    let c = this._compute_plot_bounds(l, e);
    s != null && (c = this.adjust_bounds_for_aspect(c, s)), this._plot_bounds.set(o, c);
    const [u, d] = this._compute_min_max(this._plot_bounds.entries(), r);
    let [f, T] = this._compute_range(u, d);
    this._initial_start != null && (this.scale_hint == "log" ? this._initial_start > 0 && (f = this._initial_start) : f = this._initial_start), this._initial_end != null && (this.scale_hint == "log" ? this._initial_end > 0 && (T = this._initial_end) : T = this._initial_end);
    let Q = !1;
    this.bounds == "auto" && (this.setv({ bounds: [f, T] }, { silent: !0 }), Q = !0);
    const [m, g] = [this.start, this.end];
    if (f != m || T != g) {
      const v = {};
      f != m && (v.start = f), T != g && (v.end = T), this.setv(v), Q = !1;
    }
    Q && this.change.emit();
  }
  reset() {
    this.have_updated_interactively = !1, this.setv({
      range_padding: this._initial_range_padding,
      range_padding_units: this._initial_range_padding_units,
      follow: this._initial_follow,
      follow_interval: this._initial_follow_interval,
      default_span: this._initial_default_span
    }, { silent: !0 }), this.change.emit();
  }
}
_a$3N = DataRange1d;
DataRange1d.__name__ = "DataRange1d";
_a$3N.define(({ Boolean: t, Number: e, Nullable: r }) => ({
  start: [e],
  end: [e],
  range_padding: [e, 0.1],
  range_padding_units: [PaddingUnits, "percent"],
  flipped: [t, !1],
  follow: [r(StartEnd), null],
  follow_interval: [r(e), null],
  default_span: [e, 2],
  only_visible: [t, !1]
})), _a$3N.internal(({ Enum: t }) => ({
  scale_hint: [t("log", "auto"), "auto"]
}));
var _a$3M;
Or(String$2, Tuple(String$2, String$2), Tuple(String$2, String$2, String$2));
const FactorSeq = Or(Array$2(String$2), Array$2(Tuple(String$2, String$2)), Array$2(Tuple(String$2, String$2, String$2)));
function map_one_level(t, e, r = 0) {
  const o = /* @__PURE__ */ new Map();
  for (let s = 0; s < t.length; s++) {
    const l = t[s];
    if (!o.has(l))
      o.set(l, { value: 0.5 + s * (1 + e) + r });
    else
      throw new Error(`duplicate factor or subfactor: ${l}`);
  }
  return [o, (t.length - 1) * e];
}
function map_two_levels(t, e, r, o = 0) {
  var d;
  const s = /* @__PURE__ */ new Map(), l = /* @__PURE__ */ new Map();
  for (const [f, T] of t) {
    const Q = (d = l.get(f)) != null ? d : [];
    l.set(f, [...Q, T]);
  }
  let c = o, u = 0;
  for (const [f, T] of l) {
    const Q = T.length, [m, g] = map_one_level(T, r, c);
    u += g;
    const v = sum$2(T.map((b) => m.get(b).value));
    s.set(f, { value: v / Q, mapping: m }), c += Q + e + g;
  }
  return [s, (l.size - 1) * e + u];
}
function map_three_levels(t, e, r, o, s = 0) {
  var f;
  const l = /* @__PURE__ */ new Map(), c = /* @__PURE__ */ new Map();
  for (const [T, Q, m] of t) {
    const g = (f = c.get(T)) != null ? f : [];
    c.set(T, [...g, [Q, m]]);
  }
  let u = s, d = 0;
  for (const [T, Q] of c) {
    const m = Q.length, [g, v] = map_two_levels(Q, r, o, u);
    d += v;
    const b = sum$2(Q.map(([L]) => g.get(L).value));
    l.set(T, { value: b / m, mapping: g }), u += m + e + v;
  }
  return [l, (c.size - 1) * e + d];
}
class FactorRange extends Range$1 {
  constructor(e) {
    super(e);
  }
  get min() {
    return this.start;
  }
  get max() {
    return this.end;
  }
  initialize() {
    super.initialize(), this._init(!0);
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.properties.factors.change, () => this.reset()), this.connect(this.properties.factor_padding.change, () => this.reset()), this.connect(this.properties.group_padding.change, () => this.reset()), this.connect(this.properties.subgroup_padding.change, () => this.reset()), this.connect(this.properties.range_padding.change, () => this.reset()), this.connect(this.properties.range_padding_units.change, () => this.reset());
  }
  reset() {
    this._init(!1), this.change.emit();
  }
  _lookup(e) {
    switch (e.length) {
      case 1: {
        const [r] = e, s = this._mapping.get(r);
        return s != null ? s.value : NaN;
      }
      case 2: {
        const [r, o] = e, l = this._mapping.get(r);
        if (l != null) {
          const c = l.mapping.get(o);
          if (c != null)
            return c.value;
        }
        return NaN;
      }
      case 3: {
        const [r, o, s] = e, c = this._mapping.get(r);
        if (c != null) {
          const u = c.mapping.get(o);
          if (u != null) {
            const d = u.mapping.get(s);
            if (d != null)
              return d.value;
          }
        }
        return NaN;
      }
      default:
        unreachable();
    }
  }
  synthetic(e) {
    if (isNumber(e))
      return e;
    if (isString(e))
      return this._lookup([e]);
    let r = 0;
    const o = e[e.length - 1];
    return isNumber(o) && (r = o, e = e.slice(0, -1)), this._lookup(e) + r;
  }
  v_synthetic(e) {
    const r = e.length, o = new ScreenArray(r);
    for (let s = 0; s < r; s++)
      o[s] = this.synthetic(e[s]);
    return o;
  }
  _init(e) {
    const { levels: r, mapping: o, tops: s, mids: l, inside_padding: c } = (() => {
      if (every(this.factors, isString)) {
        const f = this.factors, [T, Q] = map_one_level(f, this.factor_padding);
        return { levels: 1, mapping: T, tops: null, mids: null, inside_padding: Q };
      } else if (every(this.factors, (f) => isArray(f) && f.length == 2 && isString(f[0]) && isString(f[1]))) {
        const f = this.factors, [T, Q] = map_two_levels(f, this.group_padding, this.factor_padding), m = [...T.keys()];
        return { levels: 2, mapping: T, tops: m, mids: null, inside_padding: Q };
      } else if (every(this.factors, (f) => isArray(f) && f.length == 3 && isString(f[0]) && isString(f[1]) && isString(f[2]))) {
        const f = this.factors, [T, Q] = map_three_levels(f, this.group_padding, this.subgroup_padding, this.factor_padding), m = [...T.keys()], g = [];
        for (const [v, b] of T)
          for (const L of b.mapping.keys())
            g.push([v, L]);
        return { levels: 3, mapping: T, tops: m, mids: g, inside_padding: Q };
      } else
        unreachable();
    })();
    this._mapping = o, this.tops = s, this.mids = l;
    let u = 0, d = this.factors.length + c;
    if (this.range_padding_units == "percent") {
      const f = (d - u) * this.range_padding / 2;
      u -= f, d += f;
    } else
      u -= this.range_padding, d += this.range_padding;
    this.setv({ start: u, end: d, levels: r }, { silent: e }), this.bounds == "auto" && this.setv({ bounds: [u, d] }, { silent: !0 });
  }
}
_a$3M = FactorRange;
FactorRange.__name__ = "FactorRange";
_a$3M.define(({ Number: t }) => ({
  factors: [FactorSeq, []],
  factor_padding: [t, 0],
  subgroup_padding: [t, 0.8],
  group_padding: [t, 1.4],
  range_padding: [t, 0],
  range_padding_units: [PaddingUnits, "percent"],
  start: [t],
  end: [t]
})), _a$3M.internal(({ Number: t, String: e, Array: r, Tuple: o, Nullable: s }) => ({
  levels: [t],
  mids: [s(r(o(e, e))), null],
  tops: [s(r(e)), null]
}));
var _a$3L, _b$b;
class CoordinateTransform$1 {
  constructor(e, r) {
    this.x_scale = e, this.y_scale = r, this.x_source = this.x_scale.source_range, this.y_source = this.y_scale.source_range, this.ranges = [this.x_source, this.y_source], this.scales = [this.x_scale, this.y_scale];
  }
  map_to_screen(e, r) {
    const o = this.x_scale.v_compute(e), s = this.y_scale.v_compute(r);
    return [o, s];
  }
  map_from_screen(e, r) {
    const o = this.x_scale.v_invert(e), s = this.y_scale.v_invert(r);
    return [o, s];
  }
}
CoordinateTransform$1.__name__ = "CoordinateTransform";
class CoordinateMapping extends Model {
  constructor(e) {
    super(e);
  }
  get x_ranges() {
    return /* @__PURE__ */ new Map([["default", this.x_source]]);
  }
  get y_ranges() {
    return /* @__PURE__ */ new Map([["default", this.y_source]]);
  }
  _get_scale(e, r, o) {
    const s = e instanceof FactorRange, l = r instanceof CategoricalScale;
    if (s != l)
      throw new Error(`Range ${e.type} is incompatible is Scale ${r.type}`);
    r instanceof LogScale && e instanceof DataRange1d && (e.scale_hint = "log");
    const c = r.clone();
    return c.setv({ source_range: e, target_range: o }), c;
  }
  get_transform(e) {
    const { x_source: r, x_scale: o, x_target: s } = this, l = this._get_scale(r, o, s), { y_source: c, y_scale: u, y_target: d } = this, f = this._get_scale(c, u, d), T = new CompositeScale({
      source_scale: l,
      source_range: l.source_range,
      target_scale: e.x_scale,
      target_range: e.x_target
    }), Q = new CompositeScale({
      source_scale: f,
      source_range: f.source_range,
      target_scale: e.y_scale,
      target_range: e.y_target
    });
    return new CoordinateTransform$1(T, Q);
  }
}
_a$3L = CoordinateMapping;
CoordinateMapping.__name__ = "CoordinateMapping";
_a$3L.define(({ Ref: t }) => ({
  x_source: [t(Range$1), () => new DataRange1d()],
  y_source: [t(Range$1), () => new DataRange1d()],
  x_scale: [t(Scale), () => new LinearScale()],
  y_scale: [t(Scale), () => new LinearScale()],
  x_target: [t(Range$1)],
  y_target: [t(Range$1)]
}));
class CompositeScale extends Scale {
  constructor(e) {
    super(e);
  }
  get s_compute() {
    const e = this.source_scale.s_compute, r = this.target_scale.s_compute;
    return (o) => r(e(o));
  }
  get s_invert() {
    const e = this.source_scale.s_invert, r = this.target_scale.s_invert;
    return (o) => e(r(o));
  }
  compute(e) {
    return this.s_compute(e);
  }
  v_compute(e) {
    const { s_compute: r } = this;
    return map(e, r);
  }
  invert(e) {
    return this.s_invert(e);
  }
  v_invert(e) {
    const { s_invert: r } = this;
    return map(e, r);
  }
}
_b$b = CompositeScale;
CompositeScale.__name__ = "CompositeScale";
_b$b.internal(({ Ref: t }) => ({
  source_scale: [t(Scale)],
  target_scale: [t(Scale)]
}));
var _a$3K, _b$a;
class RendererGroup extends Model {
  constructor(e) {
    super(e);
  }
}
_a$3K = RendererGroup;
RendererGroup.__name__ = "RendererGroup";
_a$3K.define(({ Boolean: t }) => ({
  visible: [t, !0]
}));
class RendererView extends View {
  get coordinates() {
    const { _coordinates: e } = this;
    return e != null ? e : this._coordinates = this._initialize_coordinates();
  }
  initialize() {
    super.initialize(), this.visuals = new Visuals(this), this.needs_webgl_blit = !1;
  }
  connect_signals() {
    super.connect_signals();
    const { x_range_name: e, y_range_name: r } = this.model.properties;
    this.on_change([e, r], () => this._initialize_coordinates());
    const { group: o } = this.model;
    o != null && this.on_change(o.properties.visible, () => {
      this.model.visible = o.visible;
    });
  }
  _initialize_coordinates() {
    const { coordinates: e } = this.model, { frame: r } = this.plot_view;
    if (e != null)
      return e.get_transform(r);
    {
      const { x_range_name: o, y_range_name: s } = this.model, l = r.x_scales.get(o), c = r.y_scales.get(s);
      return new CoordinateTransform$1(l, c);
    }
  }
  get plot_view() {
    return this.parent;
  }
  get plot_model() {
    return this.parent.model;
  }
  get layer() {
    const { overlays: e, primary: r } = this.canvas;
    return this.model.level == "overlay" ? e : r;
  }
  get canvas() {
    return this.plot_view.canvas_view;
  }
  request_render() {
    this.request_paint();
  }
  request_paint() {
    this.plot_view.request_paint(this);
  }
  request_layout() {
    this.plot_view.request_layout();
  }
  notify_finished() {
    this.plot_view.notify_finished();
  }
  notify_finished_after_paint() {
    this.plot_view.notify_finished_after_paint();
  }
  get needs_clip() {
    return !1;
  }
  get has_webgl() {
    return !1;
  }
  render() {
    this.model.visible && this._render(), this._has_finished = !0;
  }
  renderer_view(e) {
  }
}
RendererView.__name__ = "RendererView";
class Renderer extends Model {
  constructor(e) {
    super(e);
  }
}
_b$a = Renderer;
Renderer.__name__ = "Renderer";
_b$a.define(({ Boolean: t, String: e, Ref: r, Nullable: o }) => ({
  group: [o(r(RendererGroup)), null],
  level: [RenderLevel, "image"],
  visible: [t, !0],
  x_range_name: [e, "default"],
  y_range_name: [e, "default"],
  coordinates: [o(r(CoordinateMapping)), null]
}));
var _a$3J;
class AnnotationView extends RendererView {
  get_size() {
    if (this.model.visible) {
      const { width: e, height: r } = this._get_size();
      return { width: Math.round(e), height: Math.round(r) };
    } else
      return { width: 0, height: 0 };
  }
  _get_size() {
    throw new Error("not implemented");
  }
  connect_signals() {
    super.connect_signals();
    const e = this.model.properties;
    this.on_change(e.visible, () => {
      this.layout != null && (this.layout.visible = this.model.visible, this.plot_view.request_layout());
    });
  }
  get needs_clip() {
    return this.layout == null;
  }
  serializable_state() {
    const e = super.serializable_state();
    return this.layout == null ? e : { ...e, bbox: this.layout.bbox.box };
  }
}
AnnotationView.__name__ = "AnnotationView";
class Annotation extends Renderer {
  constructor(e) {
    super(e);
  }
}
_a$3J = Annotation;
Annotation.__name__ = "Annotation";
_a$3J.override({
  level: "annotation"
});
var _a$3I;
class Selection extends Model {
  constructor(e) {
    super(e);
  }
  get_view() {
    return this.view;
  }
  get selected_glyph() {
    return this.selected_glyphs.length > 0 ? this.selected_glyphs[0] : null;
  }
  add_to_selected_glyphs(e) {
    this.selected_glyphs.push(e);
  }
  update(e, r = !0, o = "replace") {
    switch (o) {
      case "replace": {
        this.indices = e.indices, this.line_indices = e.line_indices, this.multiline_indices = e.multiline_indices, this.image_indices = e.image_indices, this.view = e.view, this.selected_glyphs = e.selected_glyphs;
        break;
      }
      case "append": {
        this.update_through_union(e);
        break;
      }
      case "intersect": {
        this.update_through_intersection(e);
        break;
      }
      case "subtract": {
        this.update_through_subtraction(e);
        break;
      }
    }
  }
  clear() {
    this.indices = [], this.line_indices = [], this.multiline_indices = {}, this.image_indices = [], this.view = null, this.selected_glyphs = [];
  }
  map(e) {
    return new Selection({
      ...this.attributes,
      indices: this.indices.map(e),
      multiline_indices: to_object(entries(this.multiline_indices).map(([r, o]) => [e(Number(r)), o])),
      image_indices: this.image_indices.map((r) => ({ ...r, index: e(r.index) }))
    });
  }
  is_empty() {
    return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
  }
  update_through_union(e) {
    this.indices = union$2(this.indices, e.indices), this.selected_glyphs = union$2(e.selected_glyphs, this.selected_glyphs), this.line_indices = union$2(e.line_indices, this.line_indices), this.view = e.view, this.multiline_indices = merge(e.multiline_indices, this.multiline_indices);
  }
  update_through_intersection(e) {
    this.indices = intersection(this.indices, e.indices), this.selected_glyphs = union$2(e.selected_glyphs, this.selected_glyphs), this.line_indices = union$2(e.line_indices, this.line_indices), this.view = e.view, this.multiline_indices = merge(e.multiline_indices, this.multiline_indices);
  }
  update_through_subtraction(e) {
    this.indices = difference$1(this.indices, e.indices), this.selected_glyphs = union$2(e.selected_glyphs, this.selected_glyphs), this.line_indices = union$2(e.line_indices, this.line_indices), this.view = e.view, this.multiline_indices = merge(e.multiline_indices, this.multiline_indices);
  }
}
_a$3I = Selection;
Selection.__name__ = "Selection";
_a$3I.define(({ Int: t, Array: e, Dict: r }) => ({
  indices: [e(t), []],
  line_indices: [e(t), []],
  multiline_indices: [r(e(t)), {}]
})), _a$3I.internal(({ Int: t, Array: e, AnyRef: r, Struct: o, Nullable: s }) => ({
  selected_glyphs: [e(r()), []],
  view: [s(r()), null],
  image_indices: [e(o({ index: t, dim1: t, dim2: t, flat_index: t })), []]
}));
var _a$3H;
class DataSource extends Model {
  constructor(e) {
    super(e);
  }
}
_a$3H = DataSource;
DataSource.__name__ = "DataSource";
_a$3H.define(({ Ref: t }) => ({
  selected: [t(Selection), () => new Selection()]
}));
function is_GlyphRendererView(t) {
  return t.model.type == "GlyphRenderer";
}
function is_GraphRendererView(t) {
  return t.model.type == "GraphRenderer";
}
class SelectionManager {
  constructor(e) {
    this.source = e, this.inspectors = /* @__PURE__ */ new Map();
  }
  select(e, r, o, s = "replace") {
    const l = [], c = [];
    for (const d of e)
      is_GlyphRendererView(d) ? l.push(d) : is_GraphRendererView(d) && c.push(d);
    let u = !1;
    for (const d of c) {
      const f = d.model.selection_policy.hit_test(r, d);
      u = u || d.model.selection_policy.do_selection(f, d.model, o, s);
    }
    if (l.length > 0) {
      const d = this.source.selection_policy.hit_test(r, l);
      u = u || this.source.selection_policy.do_selection(d, this.source, o, s);
    }
    return u;
  }
  inspect(e, r) {
    let o = !1;
    if (is_GlyphRendererView(e)) {
      const s = e.hit_test(r);
      if (s != null) {
        o = !s.is_empty();
        const l = this.get_or_create_inspector(e.model);
        l.update(s, !0, "replace"), this.source.setv({ inspected: l }, { silent: !0 }), this.source.inspect.emit([e.model, { geometry: r }]);
      }
    } else if (is_GraphRendererView(e)) {
      const s = e.model.inspection_policy.hit_test(r, e);
      o = o || e.model.inspection_policy.do_inspection(s, r, e, !1, "replace");
    }
    return o;
  }
  clear(e) {
    this.source.selected.clear(), e != null && this.get_or_create_inspector(e.model).clear();
  }
  get_or_create_inspector(e) {
    let r = this.inspectors.get(e);
    return r == null && (r = new Selection(), this.inspectors.set(e, r)), r;
  }
}
SelectionManager.__name__ = "SelectionManager";
class SelectionPolicy extends Model {
  do_selection(e, r, o, s) {
    return e == null ? !1 : (r.selected.update(e, o, s), r._select.emit(), !r.selected.is_empty());
  }
}
SelectionPolicy.__name__ = "SelectionPolicy";
class IntersectRenderers extends SelectionPolicy {
  hit_test(e, r) {
    const o = [];
    for (const s of r) {
      const l = s.hit_test(e);
      l != null && o.push(l);
    }
    if (o.length > 0) {
      const s = o[0];
      for (const l of o)
        s.update_through_intersection(l);
      return s;
    } else
      return null;
  }
}
IntersectRenderers.__name__ = "IntersectRenderers";
class UnionRenderers extends SelectionPolicy {
  hit_test(e, r) {
    const o = [];
    for (const s of r) {
      const l = s.hit_test(e);
      l != null && o.push(l);
    }
    if (o.length > 0) {
      const s = o[0];
      for (const l of o)
        s.update_through_union(l);
      return s;
    } else
      return null;
  }
}
UnionRenderers.__name__ = "UnionRenderers";
var _a$3G;
class ColumnarDataSource extends DataSource {
  constructor(e) {
    super(e), this.selection_manager = new SelectionManager(this);
  }
  get_array(e) {
    let r = this.data[e];
    return r == null ? this.data[e] = r = [] : isArray(r) || (this.data[e] = r = Array.from(r)), r;
  }
  initialize() {
    super.initialize(), this._select = new Signal0(this, "select"), this.inspect = new Signal(this, "inspect"), this.streaming = new Signal0(this, "streaming"), this.patching = new Signal(this, "patching");
  }
  get_column(e) {
    const r = this.data[e];
    return r != null ? r : null;
  }
  columns() {
    return keys(this.data);
  }
  get_length(e = !0) {
    const r = uniq(values(this.data).map((o) => is_NDArray(o) ? o.shape[0] : o.length));
    switch (r.length) {
      case 0:
        return null;
      case 1:
        return r[0];
      default: {
        const o = "data source has columns of inconsistent lengths";
        if (e)
          return logger.warn(o), r.sort()[0];
        throw new Error(o);
      }
    }
  }
  get length() {
    var e;
    return (e = this.get_length()) != null ? e : 0;
  }
  clear() {
    const e = {};
    for (const r of this.columns())
      e[r] = new this.data[r].constructor(0);
    this.data = e;
  }
}
_a$3G = ColumnarDataSource;
ColumnarDataSource.__name__ = "ColumnarDataSource";
_a$3G.define(({ Ref: t }) => ({
  selection_policy: [t(SelectionPolicy), () => new UnionRenderers()]
})), _a$3G.internal(({ AnyRef: t }) => ({
  inspected: [t(), () => new Selection()]
}));
function concat(t, ...e) {
  let r = t.length;
  for (const l of e)
    r += l.length;
  const o = new t.constructor(r);
  o.set(t, 0);
  let s = t.length;
  for (const l of e)
    o.set(l, s), s += l.length;
  return o;
}
function union(...t) {
  const e = /* @__PURE__ */ new Set();
  for (const r of t)
    for (const o of r)
      e.add(o);
  return e;
}
function difference(t, ...e) {
  const r = new Set(t);
  for (const o of union(...e))
    r.delete(o);
  return r;
}
var _a$3F;
function stream_to_column(t, e, r) {
  if (isArray(t)) {
    const o = t.concat(e);
    return r != null && o.length > r ? o.slice(-r) : o;
  } else if (isTypedArray(t)) {
    const o = t.length + e.length;
    if (r != null && o > r) {
      const s = o - r, l = t.length;
      let c;
      t.length < r ? (c = new t.constructor(r), c.set(t, 0)) : c = t;
      for (let u = s, d = l; u < d; u++)
        c[u - s] = c[u];
      for (let u = 0, d = e.length; u < d; u++)
        c[u + (l - s)] = e[u];
      return c;
    } else {
      const s = new t.constructor(e);
      return concat(t, s);
    }
  } else
    throw new Error("unsupported array types");
}
function slice$1(t, e) {
  let r, o, s;
  return isNumber(t) ? (r = t, s = t + 1, o = 1) : (r = t.start != null ? t.start : 0, s = t.stop != null ? t.stop : e, o = t.step != null ? t.step : 1), [r, s, o];
}
function patch_to_column(t, e) {
  const r = /* @__PURE__ */ new Set();
  let o = !1;
  for (const [s, l] of e) {
    let c, u, d, f;
    if (isArray(s)) {
      const [A] = s;
      r.add(A), c = t[A].shape, u = t[A], f = l, s.length === 2 ? (c = [1, c[0]], d = [s[0], 0, s[1]]) : d = s;
    } else
      isNumber(s) ? (f = [l], r.add(s)) : (f = l, o = !0), d = [0, 0, s], c = [1, t.length], u = t;
    let T = 0;
    const [Q, m, g] = slice$1(d[1], c[0]), [v, b, L] = slice$1(d[2], c[1]);
    for (let A = Q; A < m; A += g)
      for (let M = v; M < b; M += L)
        o && r.add(M), u[A * c[1] + M] = f[T], T++;
  }
  return r;
}
class ColumnDataSource extends ColumnarDataSource {
  constructor(e) {
    super(e);
  }
  stream(e, r, o) {
    const { data: s } = this;
    for (const [l, c] of entries(e))
      s[l] = stream_to_column(s[l], c, r);
    if (this.setv({ data: s }, { silent: !0 }), this.streaming.emit(), this.document != null) {
      const l = new ColumnsStreamedEvent(this.document, this.ref(), e, r);
      this.document._notify_change(this, "data", null, null, { setter_id: o, hint: l });
    }
  }
  patch(e, r) {
    const { data: o } = this;
    let s = /* @__PURE__ */ new Set();
    for (const [l, c] of entries(e))
      s = union(s, patch_to_column(o[l], c));
    if (this.setv({ data: o }, { silent: !0 }), this.patching.emit([...s]), this.document != null) {
      const l = new ColumnsPatchedEvent(this.document, this.ref(), e);
      this.document._notify_change(this, "data", null, null, { setter_id: r, hint: l });
    }
  }
}
_a$3F = ColumnDataSource;
ColumnDataSource.__name__ = "ColumnDataSource";
_a$3F.define(({ Dict: t, Any: e }) => ({
  data: [t(e), {}]
}));
function globals(t) {
  t("EPSG:4326", "+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"), t("EPSG:4269", "+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"), t("EPSG:3857", "+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"), t.WGS84 = t["EPSG:4326"], t["EPSG:3785"] = t["EPSG:3857"], t.GOOGLE = t["EPSG:3857"], t["EPSG:900913"] = t["EPSG:3857"], t["EPSG:102113"] = t["EPSG:3857"];
}
var PJD_3PARAM = 1, PJD_7PARAM = 2, PJD_GRIDSHIFT = 3, PJD_WGS84 = 4, PJD_NODATUM = 5, SRS_WGS84_SEMIMAJOR = 6378137, SRS_WGS84_SEMIMINOR = 6356752314e-3, SRS_WGS84_ESQUARED = 0.0066943799901413165, SEC_TO_RAD = 484813681109536e-20, HALF_PI = Math.PI / 2, SIXTH = 0.16666666666666666, RA4 = 0.04722222222222222, RA6 = 0.022156084656084655, EPSLN = 1e-10, D2R$1 = 0.017453292519943295, R2D = 57.29577951308232, FORTPI = Math.PI / 4, TWO_PI = Math.PI * 2, SPI = 3.14159265359, exports$2 = {};
exports$2.greenwich = 0;
exports$2.lisbon = -9.131906111111;
exports$2.paris = 2.337229166667;
exports$2.bogota = -74.080916666667;
exports$2.madrid = -3.687938888889;
exports$2.rome = 12.452333333333;
exports$2.bern = 7.439583333333;
exports$2.jakarta = 106.807719444444;
exports$2.ferro = -17.666666666667;
exports$2.brussels = 4.367975;
exports$2.stockholm = 18.058277777778;
exports$2.athens = 23.7163375;
exports$2.oslo = 10.722916666667;
const units = {
  ft: { to_meter: 0.3048 },
  "us-ft": { to_meter: 1200 / 3937 }
};
var ignoredChar = /[\s_\-\/\(\)]/g;
function match(t, e) {
  if (t[e])
    return t[e];
  for (var r = Object.keys(t), o = e.toLowerCase().replace(ignoredChar, ""), s = -1, l, c; ++s < r.length; )
    if (l = r[s], c = l.toLowerCase().replace(ignoredChar, ""), c === o)
      return t[l];
}
function projStr(t) {
  var e = {}, r = t.split("+").map(function(u) {
    return u.trim();
  }).filter(function(u) {
    return u;
  }).reduce(function(u, d) {
    var f = d.split("=");
    return f.push(!0), u[f[0].toLowerCase()] = f[1], u;
  }, {}), o, s, l, c = {
    proj: "projName",
    datum: "datumCode",
    rf: function(u) {
      e.rf = parseFloat(u);
    },
    lat_0: function(u) {
      e.lat0 = u * D2R$1;
    },
    lat_1: function(u) {
      e.lat1 = u * D2R$1;
    },
    lat_2: function(u) {
      e.lat2 = u * D2R$1;
    },
    lat_ts: function(u) {
      e.lat_ts = u * D2R$1;
    },
    lon_0: function(u) {
      e.long0 = u * D2R$1;
    },
    lon_1: function(u) {
      e.long1 = u * D2R$1;
    },
    lon_2: function(u) {
      e.long2 = u * D2R$1;
    },
    alpha: function(u) {
      e.alpha = parseFloat(u) * D2R$1;
    },
    gamma: function(u) {
      e.rectified_grid_angle = parseFloat(u);
    },
    lonc: function(u) {
      e.longc = u * D2R$1;
    },
    x_0: function(u) {
      e.x0 = parseFloat(u);
    },
    y_0: function(u) {
      e.y0 = parseFloat(u);
    },
    k_0: function(u) {
      e.k0 = parseFloat(u);
    },
    k: function(u) {
      e.k0 = parseFloat(u);
    },
    a: function(u) {
      e.a = parseFloat(u);
    },
    b: function(u) {
      e.b = parseFloat(u);
    },
    r_a: function() {
      e.R_A = !0;
    },
    zone: function(u) {
      e.zone = parseInt(u, 10);
    },
    south: function() {
      e.utmSouth = !0;
    },
    towgs84: function(u) {
      e.datum_params = u.split(",").map(function(d) {
        return parseFloat(d);
      });
    },
    to_meter: function(u) {
      e.to_meter = parseFloat(u);
    },
    units: function(u) {
      e.units = u;
      var d = match(units, u);
      d && (e.to_meter = d.to_meter);
    },
    from_greenwich: function(u) {
      e.from_greenwich = u * D2R$1;
    },
    pm: function(u) {
      var d = match(exports$2, u);
      e.from_greenwich = (d || parseFloat(u)) * D2R$1;
    },
    nadgrids: function(u) {
      u === "@null" ? e.datumCode = "none" : e.nadgrids = u;
    },
    axis: function(u) {
      var d = "ewnsud";
      u.length === 3 && d.indexOf(u.substr(0, 1)) !== -1 && d.indexOf(u.substr(1, 1)) !== -1 && d.indexOf(u.substr(2, 1)) !== -1 && (e.axis = u);
    },
    approx: function() {
      e.approx = !0;
    }
  };
  for (o in r)
    s = r[o], o in c ? (l = c[o], typeof l == "function" ? l(s) : e[l] = s) : e[o] = s;
  return typeof e.datumCode == "string" && e.datumCode !== "WGS84" && (e.datumCode = e.datumCode.toLowerCase()), e;
}
var NEUTRAL = 1, KEYWORD = 2, NUMBER = 3, QUOTED = 4, AFTERQUOTE = 5, ENDED = -1, whitespace = /\s/, latin = /[A-Za-z]/, keyword = /[A-Za-z84_]/, endThings = /[,\]]/, digets = /[\d\.E\-\+]/;
function Parser(t) {
  if (typeof t != "string")
    throw new Error("not a string");
  this.text = t.trim(), this.level = 0, this.place = 0, this.root = null, this.stack = [], this.currentObject = null, this.state = NEUTRAL;
}
Parser.prototype.readCharicter = function() {
  var t = this.text[this.place++];
  if (this.state !== QUOTED)
    for (; whitespace.test(t); ) {
      if (this.place >= this.text.length)
        return;
      t = this.text[this.place++];
    }
  switch (this.state) {
    case NEUTRAL:
      return this.neutral(t);
    case KEYWORD:
      return this.keyword(t);
    case QUOTED:
      return this.quoted(t);
    case AFTERQUOTE:
      return this.afterquote(t);
    case NUMBER:
      return this.number(t);
    case ENDED:
      return;
  }
};
Parser.prototype.afterquote = function(t) {
  if (t === '"') {
    this.word += '"', this.state = QUOTED;
    return;
  }
  if (endThings.test(t)) {
    this.word = this.word.trim(), this.afterItem(t);
    return;
  }
  throw new Error(`havn't handled "` + t + '" in afterquote yet, index ' + this.place);
};
Parser.prototype.afterItem = function(t) {
  if (t === ",") {
    this.word !== null && this.currentObject.push(this.word), this.word = null, this.state = NEUTRAL;
    return;
  }
  if (t === "]") {
    this.level--, this.word !== null && (this.currentObject.push(this.word), this.word = null), this.state = NEUTRAL, this.currentObject = this.stack.pop(), this.currentObject || (this.state = ENDED);
    return;
  }
};
Parser.prototype.number = function(t) {
  if (digets.test(t)) {
    this.word += t;
    return;
  }
  if (endThings.test(t)) {
    this.word = parseFloat(this.word), this.afterItem(t);
    return;
  }
  throw new Error(`havn't handled "` + t + '" in number yet, index ' + this.place);
};
Parser.prototype.quoted = function(t) {
  if (t === '"') {
    this.state = AFTERQUOTE;
    return;
  }
  this.word += t;
};
Parser.prototype.keyword = function(t) {
  if (keyword.test(t)) {
    this.word += t;
    return;
  }
  if (t === "[") {
    var e = [];
    e.push(this.word), this.level++, this.root === null ? this.root = e : this.currentObject.push(e), this.stack.push(this.currentObject), this.currentObject = e, this.state = NEUTRAL;
    return;
  }
  if (endThings.test(t)) {
    this.afterItem(t);
    return;
  }
  throw new Error(`havn't handled "` + t + '" in keyword yet, index ' + this.place);
};
Parser.prototype.neutral = function(t) {
  if (latin.test(t)) {
    this.word = t, this.state = KEYWORD;
    return;
  }
  if (t === '"') {
    this.word = "", this.state = QUOTED;
    return;
  }
  if (digets.test(t)) {
    this.word = t, this.state = NUMBER;
    return;
  }
  if (endThings.test(t)) {
    this.afterItem(t);
    return;
  }
  throw new Error(`havn't handled "` + t + '" in neutral yet, index ' + this.place);
};
Parser.prototype.output = function() {
  for (; this.place < this.text.length; )
    this.readCharicter();
  if (this.state === ENDED)
    return this.root;
  throw new Error('unable to parse string "' + this.text + '". State is ' + this.state);
};
function parseString(t) {
  var e = new Parser(t);
  return e.output();
}
function mapit(t, e, r) {
  Array.isArray(e) && (r.unshift(e), e = null);
  var o = e ? {} : t, s = r.reduce(function(l, c) {
    return sExpr(c, l), l;
  }, o);
  e && (t[e] = s);
}
function sExpr(t, e) {
  if (!Array.isArray(t)) {
    e[t] = !0;
    return;
  }
  var r = t.shift();
  if (r === "PARAMETER" && (r = t.shift()), t.length === 1) {
    if (Array.isArray(t[0])) {
      e[r] = {}, sExpr(t[0], e[r]);
      return;
    }
    e[r] = t[0];
    return;
  }
  if (!t.length) {
    e[r] = !0;
    return;
  }
  if (r === "TOWGS84") {
    e[r] = t;
    return;
  }
  if (r === "AXIS") {
    r in e || (e[r] = []), e[r].push(t);
    return;
  }
  Array.isArray(r) || (e[r] = {});
  var o;
  switch (r) {
    case "UNIT":
    case "PRIMEM":
    case "VERT_DATUM":
      e[r] = {
        name: t[0].toLowerCase(),
        convert: t[1]
      }, t.length === 3 && sExpr(t[2], e[r]);
      return;
    case "SPHEROID":
    case "ELLIPSOID":
      e[r] = {
        name: t[0],
        a: t[1],
        rf: t[2]
      }, t.length === 4 && sExpr(t[3], e[r]);
      return;
    case "PROJECTEDCRS":
    case "PROJCRS":
    case "GEOGCS":
    case "GEOCCS":
    case "PROJCS":
    case "LOCAL_CS":
    case "GEODCRS":
    case "GEODETICCRS":
    case "GEODETICDATUM":
    case "EDATUM":
    case "ENGINEERINGDATUM":
    case "VERT_CS":
    case "VERTCRS":
    case "VERTICALCRS":
    case "COMPD_CS":
    case "COMPOUNDCRS":
    case "ENGINEERINGCRS":
    case "ENGCRS":
    case "FITTED_CS":
    case "LOCAL_DATUM":
    case "DATUM":
      t[0] = ["name", t[0]], mapit(e, r, t);
      return;
    default:
      for (o = -1; ++o < t.length; )
        if (!Array.isArray(t[o]))
          return sExpr(t, e[r]);
      return mapit(e, r, t);
  }
}
var D2R = 0.017453292519943295;
function rename(t, e) {
  var r = e[0], o = e[1];
  !(r in t) && o in t && (t[r] = t[o], e.length === 3 && (t[r] = e[2](t[r])));
}
function d2r(t) {
  return t * D2R;
}
function cleanWKT(t) {
  if (t.type === "GEOGCS" ? t.projName = "longlat" : t.type === "LOCAL_CS" ? (t.projName = "identity", t.local = !0) : typeof t.PROJECTION == "object" ? t.projName = Object.keys(t.PROJECTION)[0] : t.projName = t.PROJECTION, t.AXIS) {
    for (var e = "", r = 0, o = t.AXIS.length; r < o; ++r) {
      var s = [t.AXIS[r][0].toLowerCase(), t.AXIS[r][1].toLowerCase()];
      s[0].indexOf("north") !== -1 || (s[0] === "y" || s[0] === "lat") && s[1] === "north" ? e += "n" : s[0].indexOf("south") !== -1 || (s[0] === "y" || s[0] === "lat") && s[1] === "south" ? e += "s" : s[0].indexOf("east") !== -1 || (s[0] === "x" || s[0] === "lon") && s[1] === "east" ? e += "e" : (s[0].indexOf("west") !== -1 || (s[0] === "x" || s[0] === "lon") && s[1] === "west") && (e += "w");
    }
    e.length === 2 && (e += "u"), e.length === 3 && (t.axis = e);
  }
  t.UNIT && (t.units = t.UNIT.name.toLowerCase(), t.units === "metre" && (t.units = "meter"), t.UNIT.convert && (t.type === "GEOGCS" ? t.DATUM && t.DATUM.SPHEROID && (t.to_meter = t.UNIT.convert * t.DATUM.SPHEROID.a) : t.to_meter = t.UNIT.convert));
  var l = t.GEOGCS;
  t.type === "GEOGCS" && (l = t), l && (l.DATUM ? t.datumCode = l.DATUM.name.toLowerCase() : t.datumCode = l.name.toLowerCase(), t.datumCode.slice(0, 2) === "d_" && (t.datumCode = t.datumCode.slice(2)), (t.datumCode === "new_zealand_geodetic_datum_1949" || t.datumCode === "new_zealand_1949") && (t.datumCode = "nzgd49"), (t.datumCode === "wgs_1984" || t.datumCode === "world_geodetic_system_1984") && (t.PROJECTION === "Mercator_Auxiliary_Sphere" && (t.sphere = !0), t.datumCode = "wgs84"), t.datumCode.slice(-6) === "_ferro" && (t.datumCode = t.datumCode.slice(0, -6)), t.datumCode.slice(-8) === "_jakarta" && (t.datumCode = t.datumCode.slice(0, -8)), ~t.datumCode.indexOf("belge") && (t.datumCode = "rnb72"), l.DATUM && l.DATUM.SPHEROID && (t.ellps = l.DATUM.SPHEROID.name.replace("_19", "").replace(/[Cc]larke\_18/, "clrk"), t.ellps.toLowerCase().slice(0, 13) === "international" && (t.ellps = "intl"), t.a = l.DATUM.SPHEROID.a, t.rf = parseFloat(l.DATUM.SPHEROID.rf, 10)), l.DATUM && l.DATUM.TOWGS84 && (t.datum_params = l.DATUM.TOWGS84), ~t.datumCode.indexOf("osgb_1936") && (t.datumCode = "osgb36"), ~t.datumCode.indexOf("osni_1952") && (t.datumCode = "osni52"), (~t.datumCode.indexOf("tm65") || ~t.datumCode.indexOf("geodetic_datum_of_1965")) && (t.datumCode = "ire65"), t.datumCode === "ch1903+" && (t.datumCode = "ch1903"), ~t.datumCode.indexOf("israel") && (t.datumCode = "isr93")), t.b && !isFinite(t.b) && (t.b = t.a);
  function c(f) {
    var T = t.to_meter || 1;
    return f * T;
  }
  var u = function(f) {
    return rename(t, f);
  }, d = [
    ["standard_parallel_1", "Standard_Parallel_1"],
    ["standard_parallel_1", "Latitude of 1st standard parallel"],
    ["standard_parallel_2", "Standard_Parallel_2"],
    ["standard_parallel_2", "Latitude of 2nd standard parallel"],
    ["false_easting", "False_Easting"],
    ["false_easting", "False easting"],
    ["false-easting", "Easting at false origin"],
    ["false_northing", "False_Northing"],
    ["false_northing", "False northing"],
    ["false_northing", "Northing at false origin"],
    ["central_meridian", "Central_Meridian"],
    ["central_meridian", "Longitude of natural origin"],
    ["central_meridian", "Longitude of false origin"],
    ["latitude_of_origin", "Latitude_Of_Origin"],
    ["latitude_of_origin", "Central_Parallel"],
    ["latitude_of_origin", "Latitude of natural origin"],
    ["latitude_of_origin", "Latitude of false origin"],
    ["scale_factor", "Scale_Factor"],
    ["k0", "scale_factor"],
    ["latitude_of_center", "Latitude_Of_Center"],
    ["latitude_of_center", "Latitude_of_center"],
    ["lat0", "latitude_of_center", d2r],
    ["longitude_of_center", "Longitude_Of_Center"],
    ["longitude_of_center", "Longitude_of_center"],
    ["longc", "longitude_of_center", d2r],
    ["x0", "false_easting", c],
    ["y0", "false_northing", c],
    ["long0", "central_meridian", d2r],
    ["lat0", "latitude_of_origin", d2r],
    ["lat0", "standard_parallel_1", d2r],
    ["lat1", "standard_parallel_1", d2r],
    ["lat2", "standard_parallel_2", d2r],
    ["azimuth", "Azimuth"],
    ["alpha", "azimuth", d2r],
    ["srsCode", "name"]
  ];
  d.forEach(u), !t.long0 && t.longc && (t.projName === "Albers_Conic_Equal_Area" || t.projName === "Lambert_Azimuthal_Equal_Area") && (t.long0 = t.longc), !t.lat_ts && t.lat1 && (t.projName === "Stereographic_South_Pole" || t.projName === "Polar Stereographic (variant B)") && (t.lat0 = d2r(t.lat1 > 0 ? 90 : -90), t.lat_ts = t.lat1);
}
function wkt(t) {
  var e = parseString(t), r = e.shift(), o = e.shift();
  e.unshift(["name", o]), e.unshift(["type", r]);
  var s = {};
  return sExpr(e, s), cleanWKT(s), s;
}
function defs(t) {
  var e = this;
  if (arguments.length === 2) {
    var r = arguments[1];
    typeof r == "string" ? r.charAt(0) === "+" ? defs[t] = projStr(arguments[1]) : defs[t] = wkt(arguments[1]) : defs[t] = r;
  } else if (arguments.length === 1) {
    if (Array.isArray(t))
      return t.map(function(o) {
        Array.isArray(o) ? defs.apply(e, o) : defs(o);
      });
    if (typeof t == "string") {
      if (t in defs)
        return defs[t];
    } else
      "EPSG" in t ? defs["EPSG:" + t.EPSG] = t : "ESRI" in t ? defs["ESRI:" + t.ESRI] = t : "IAU2000" in t ? defs["IAU2000:" + t.IAU2000] = t : console.log(t);
    return;
  }
}
globals(defs);
function testObj(t) {
  return typeof t == "string";
}
function testDef(t) {
  return t in defs;
}
var codeWords = ["PROJECTEDCRS", "PROJCRS", "GEOGCS", "GEOCCS", "PROJCS", "LOCAL_CS", "GEODCRS", "GEODETICCRS", "GEODETICDATUM", "ENGCRS", "ENGINEERINGCRS"];
function testWKT(t) {
  return codeWords.some(function(e) {
    return t.indexOf(e) > -1;
  });
}
var codes = ["3857", "900913", "3785", "102113"];
function checkMercator(t) {
  var e = match(t, "authority");
  if (!!e) {
    var r = match(e, "epsg");
    return r && codes.indexOf(r) > -1;
  }
}
function checkProjStr(t) {
  var e = match(t, "extension");
  if (!!e)
    return match(e, "proj4");
}
function testProj(t) {
  return t[0] === "+";
}
function parse(t) {
  if (testObj(t)) {
    if (testDef(t))
      return defs[t];
    if (testWKT(t)) {
      var e = wkt(t);
      if (checkMercator(e))
        return defs["EPSG:3857"];
      var r = checkProjStr(e);
      return r ? projStr(r) : e;
    }
    if (testProj(t))
      return projStr(t);
  } else
    return t;
}
function extend(t, e) {
  t = t || {};
  var r, o;
  if (!e)
    return t;
  for (o in e)
    r = e[o], r !== void 0 && (t[o] = r);
  return t;
}
function msfnz(t, e, r) {
  var o = t * e;
  return r / Math.sqrt(1 - o * o);
}
function sign(t) {
  return t < 0 ? -1 : 1;
}
function adjust_lon(t) {
  return Math.abs(t) <= SPI ? t : t - sign(t) * TWO_PI;
}
function tsfnz(t, e, r) {
  var o = t * r, s = 0.5 * t;
  return o = Math.pow((1 - o) / (1 + o), s), Math.tan(0.5 * (HALF_PI - e)) / o;
}
function phi2z(t, e) {
  for (var r = 0.5 * t, o, s, l = HALF_PI - 2 * Math.atan(e), c = 0; c <= 15; c++)
    if (o = t * Math.sin(l), s = HALF_PI - 2 * Math.atan(e * Math.pow((1 - o) / (1 + o), r)) - l, l += s, Math.abs(s) <= 1e-10)
      return l;
  return -9999;
}
function init$3() {
  var t = this.b / this.a;
  this.es = 1 - t * t, "x0" in this || (this.x0 = 0), "y0" in this || (this.y0 = 0), this.e = Math.sqrt(this.es), this.lat_ts ? this.sphere ? this.k0 = Math.cos(this.lat_ts) : this.k0 = msfnz(this.e, Math.sin(this.lat_ts), Math.cos(this.lat_ts)) : this.k0 || (this.k ? this.k0 = this.k : this.k0 = 1);
}
function forward(t) {
  var e = t.x, r = t.y;
  if (r * R2D > 90 && r * R2D < -90 && e * R2D > 180 && e * R2D < -180)
    return null;
  var o, s;
  if (Math.abs(Math.abs(r) - HALF_PI) <= EPSLN)
    return null;
  if (this.sphere)
    o = this.x0 + this.a * this.k0 * adjust_lon(e - this.long0), s = this.y0 + this.a * this.k0 * Math.log(Math.tan(FORTPI + 0.5 * r));
  else {
    var l = Math.sin(r), c = tsfnz(this.e, r, l);
    o = this.x0 + this.a * this.k0 * adjust_lon(e - this.long0), s = this.y0 - this.a * this.k0 * Math.log(c);
  }
  return t.x = o, t.y = s, t;
}
function inverse(t) {
  var e = t.x - this.x0, r = t.y - this.y0, o, s;
  if (this.sphere)
    s = HALF_PI - 2 * Math.atan(Math.exp(-r / (this.a * this.k0)));
  else {
    var l = Math.exp(-r / (this.a * this.k0));
    if (s = phi2z(this.e, l), s === -9999)
      return null;
  }
  return o = adjust_lon(this.long0 + e / (this.a * this.k0)), t.x = o, t.y = s, t;
}
var names$2 = ["Mercator", "Popular Visualisation Pseudo Mercator", "Mercator_1SP", "Mercator_Auxiliary_Sphere", "merc"];
const merc = {
  init: init$3,
  forward,
  inverse,
  names: names$2
};
function init$2() {
}
function identity(t) {
  return t;
}
var names$1 = ["longlat", "identity"];
const longlat = {
  init: init$2,
  forward: identity,
  inverse: identity,
  names: names$1
};
var projs = [merc, longlat], names = {}, projStore = [];
function add(t, e) {
  var r = projStore.length;
  return t.names ? (projStore[r] = t, t.names.forEach(function(o) {
    names[o.toLowerCase()] = r;
  }), this) : (console.log(e), !0);
}
function get(t) {
  if (!t)
    return !1;
  var e = t.toLowerCase();
  if (typeof names[e] < "u" && projStore[names[e]])
    return projStore[names[e]];
}
function start() {
  projs.forEach(add);
}
const projections = {
  start,
  add,
  get
};
var exports$1 = {};
exports$1.MERIT = {
  a: 6378137,
  rf: 298.257,
  ellipseName: "MERIT 1983"
};
exports$1.SGS85 = {
  a: 6378136,
  rf: 298.257,
  ellipseName: "Soviet Geodetic System 85"
};
exports$1.GRS80 = {
  a: 6378137,
  rf: 298.257222101,
  ellipseName: "GRS 1980(IUGG, 1980)"
};
exports$1.IAU76 = {
  a: 6378140,
  rf: 298.257,
  ellipseName: "IAU 1976"
};
exports$1.airy = {
  a: 6377563396e-3,
  b: 635625691e-2,
  ellipseName: "Airy 1830"
};
exports$1.APL4 = {
  a: 6378137,
  rf: 298.25,
  ellipseName: "Appl. Physics. 1965"
};
exports$1.NWL9D = {
  a: 6378145,
  rf: 298.25,
  ellipseName: "Naval Weapons Lab., 1965"
};
exports$1.mod_airy = {
  a: 6377340189e-3,
  b: 6356034446e-3,
  ellipseName: "Modified Airy"
};
exports$1.andrae = {
  a: 637710443e-2,
  rf: 300,
  ellipseName: "Andrae 1876 (Den., Iclnd.)"
};
exports$1.aust_SA = {
  a: 6378160,
  rf: 298.25,
  ellipseName: "Australian Natl & S. Amer. 1969"
};
exports$1.GRS67 = {
  a: 6378160,
  rf: 298.247167427,
  ellipseName: "GRS 67(IUGG 1967)"
};
exports$1.bessel = {
  a: 6377397155e-3,
  rf: 299.1528128,
  ellipseName: "Bessel 1841"
};
exports$1.bess_nam = {
  a: 6377483865e-3,
  rf: 299.1528128,
  ellipseName: "Bessel 1841 (Namibia)"
};
exports$1.clrk66 = {
  a: 63782064e-1,
  b: 63565838e-1,
  ellipseName: "Clarke 1866"
};
exports$1.clrk80 = {
  a: 6378249145e-3,
  rf: 293.4663,
  ellipseName: "Clarke 1880 mod."
};
exports$1.clrk58 = {
  a: 6378293645208759e-9,
  rf: 294.2606763692654,
  ellipseName: "Clarke 1858"
};
exports$1.CPM = {
  a: 63757387e-1,
  rf: 334.29,
  ellipseName: "Comm. des Poids et Mesures 1799"
};
exports$1.delmbr = {
  a: 6376428,
  rf: 311.5,
  ellipseName: "Delambre 1810 (Belgium)"
};
exports$1.engelis = {
  a: 637813605e-2,
  rf: 298.2566,
  ellipseName: "Engelis 1985"
};
exports$1.evrst30 = {
  a: 6377276345e-3,
  rf: 300.8017,
  ellipseName: "Everest 1830"
};
exports$1.evrst48 = {
  a: 6377304063e-3,
  rf: 300.8017,
  ellipseName: "Everest 1948"
};
exports$1.evrst56 = {
  a: 6377301243e-3,
  rf: 300.8017,
  ellipseName: "Everest 1956"
};
exports$1.evrst69 = {
  a: 6377295664e-3,
  rf: 300.8017,
  ellipseName: "Everest 1969"
};
exports$1.evrstSS = {
  a: 6377298556e-3,
  rf: 300.8017,
  ellipseName: "Everest (Sabah & Sarawak)"
};
exports$1.fschr60 = {
  a: 6378166,
  rf: 298.3,
  ellipseName: "Fischer (Mercury Datum) 1960"
};
exports$1.fschr60m = {
  a: 6378155,
  rf: 298.3,
  ellipseName: "Fischer 1960"
};
exports$1.fschr68 = {
  a: 6378150,
  rf: 298.3,
  ellipseName: "Fischer 1968"
};
exports$1.helmert = {
  a: 6378200,
  rf: 298.3,
  ellipseName: "Helmert 1906"
};
exports$1.hough = {
  a: 6378270,
  rf: 297,
  ellipseName: "Hough"
};
exports$1.intl = {
  a: 6378388,
  rf: 297,
  ellipseName: "International 1909 (Hayford)"
};
exports$1.kaula = {
  a: 6378163,
  rf: 298.24,
  ellipseName: "Kaula 1961"
};
exports$1.lerch = {
  a: 6378139,
  rf: 298.257,
  ellipseName: "Lerch 1979"
};
exports$1.mprts = {
  a: 6397300,
  rf: 191,
  ellipseName: "Maupertius 1738"
};
exports$1.new_intl = {
  a: 63781575e-1,
  b: 63567722e-1,
  ellipseName: "New International 1967"
};
exports$1.plessis = {
  a: 6376523,
  rf: 6355863,
  ellipseName: "Plessis 1817 (France)"
};
exports$1.krass = {
  a: 6378245,
  rf: 298.3,
  ellipseName: "Krassovsky, 1942"
};
exports$1.SEasia = {
  a: 6378155,
  b: 63567733205e-4,
  ellipseName: "Southeast Asia"
};
exports$1.walbeck = {
  a: 6376896,
  b: 63558348467e-4,
  ellipseName: "Walbeck"
};
exports$1.WGS60 = {
  a: 6378165,
  rf: 298.3,
  ellipseName: "WGS 60"
};
exports$1.WGS66 = {
  a: 6378145,
  rf: 298.25,
  ellipseName: "WGS 66"
};
exports$1.WGS7 = {
  a: 6378135,
  rf: 298.26,
  ellipseName: "WGS 72"
};
var WGS84 = exports$1.WGS84 = {
  a: 6378137,
  rf: 298.257223563,
  ellipseName: "WGS 84"
};
exports$1.sphere = {
  a: 6370997,
  b: 6370997,
  ellipseName: "Normal Sphere (r=6370997)"
};
function eccentricity(t, e, r, o) {
  var s = t * t, l = e * e, c = (s - l) / s, u = 0;
  o ? (t *= 1 - c * (SIXTH + c * (RA4 + c * RA6)), s = t * t, c = 0) : u = Math.sqrt(c);
  var d = (s - l) / l;
  return {
    es: c,
    e: u,
    ep2: d
  };
}
function sphere(t, e, r, o, s) {
  if (!t) {
    var l = match(exports$1, o);
    l || (l = WGS84), t = l.a, e = l.b, r = l.rf;
  }
  return r && !e && (e = (1 - 1 / r) * t), (r === 0 || Math.abs(t - e) < EPSLN) && (s = !0, e = t), {
    a: t,
    b: e,
    rf: r,
    sphere: s
  };
}
var exports = {};
exports.wgs84 = {
  towgs84: "0,0,0",
  ellipse: "WGS84",
  datumName: "WGS84"
};
exports.ch1903 = {
  towgs84: "674.374,15.056,405.346",
  ellipse: "bessel",
  datumName: "swiss"
};
exports.ggrs87 = {
  towgs84: "-199.87,74.79,246.62",
  ellipse: "GRS80",
  datumName: "Greek_Geodetic_Reference_System_1987"
};
exports.nad83 = {
  towgs84: "0,0,0",
  ellipse: "GRS80",
  datumName: "North_American_Datum_1983"
};
exports.nad27 = {
  nadgrids: "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",
  ellipse: "clrk66",
  datumName: "North_American_Datum_1927"
};
exports.potsdam = {
  towgs84: "598.1,73.7,418.2,0.202,0.045,-2.455,6.7",
  ellipse: "bessel",
  datumName: "Potsdam Rauenberg 1950 DHDN"
};
exports.carthage = {
  towgs84: "-263.0,6.0,431.0",
  ellipse: "clark80",
  datumName: "Carthage 1934 Tunisia"
};
exports.hermannskogel = {
  towgs84: "577.326,90.129,463.919,5.137,1.474,5.297,2.4232",
  ellipse: "bessel",
  datumName: "Hermannskogel"
};
exports.osni52 = {
  towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
  ellipse: "airy",
  datumName: "Irish National"
};
exports.ire65 = {
  towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
  ellipse: "mod_airy",
  datumName: "Ireland 1965"
};
exports.rassadiran = {
  towgs84: "-133.63,-157.5,-158.62",
  ellipse: "intl",
  datumName: "Rassadiran"
};
exports.nzgd49 = {
  towgs84: "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",
  ellipse: "intl",
  datumName: "New Zealand Geodetic Datum 1949"
};
exports.osgb36 = {
  towgs84: "446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",
  ellipse: "airy",
  datumName: "Airy 1830"
};
exports.s_jtsk = {
  towgs84: "589,76,480",
  ellipse: "bessel",
  datumName: "S-JTSK (Ferro)"
};
exports.beduaram = {
  towgs84: "-106,-87,188",
  ellipse: "clrk80",
  datumName: "Beduaram"
};
exports.gunung_segara = {
  towgs84: "-403,684,41",
  ellipse: "bessel",
  datumName: "Gunung Segara Jakarta"
};
exports.rnb72 = {
  towgs84: "106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",
  ellipse: "intl",
  datumName: "Reseau National Belge 1972"
};
function datum(t, e, r, o, s, l, c) {
  var u = {};
  return t === void 0 || t === "none" ? u.datum_type = PJD_NODATUM : u.datum_type = PJD_WGS84, e && (u.datum_params = e.map(parseFloat), (u.datum_params[0] !== 0 || u.datum_params[1] !== 0 || u.datum_params[2] !== 0) && (u.datum_type = PJD_3PARAM), u.datum_params.length > 3 && (u.datum_params[3] !== 0 || u.datum_params[4] !== 0 || u.datum_params[5] !== 0 || u.datum_params[6] !== 0) && (u.datum_type = PJD_7PARAM, u.datum_params[3] *= SEC_TO_RAD, u.datum_params[4] *= SEC_TO_RAD, u.datum_params[5] *= SEC_TO_RAD, u.datum_params[6] = u.datum_params[6] / 1e6 + 1)), c && (u.datum_type = PJD_GRIDSHIFT, u.grids = c), u.a = r, u.b = o, u.es = s, u.ep2 = l, u;
}
var loadedNadgrids = {};
function getNadgrids(t) {
  if (t === void 0)
    return null;
  var e = t.split(",");
  return e.map(parseNadgridString);
}
function parseNadgridString(t) {
  if (t.length === 0)
    return null;
  var e = t[0] === "@";
  return e && (t = t.slice(1)), t === "null" ? { name: "null", mandatory: !e, grid: null, isNull: !0 } : {
    name: t,
    mandatory: !e,
    grid: loadedNadgrids[t] || null,
    isNull: !1
  };
}
function Projection(t, e) {
  if (!(this instanceof Projection))
    return new Projection(t);
  e = e || function(f) {
    if (f)
      throw f;
  };
  var r = parse(t);
  if (typeof r != "object") {
    e(t);
    return;
  }
  var o = Projection.projections.get(r.projName);
  if (!o) {
    e(t);
    return;
  }
  if (r.datumCode && r.datumCode !== "none") {
    var s = match(exports, r.datumCode);
    s && (r.datum_params = r.datum_params || (s.towgs84 ? s.towgs84.split(",") : null), r.ellps = s.ellipse, r.datumName = s.datumName ? s.datumName : r.datumCode);
  }
  r.k0 = r.k0 || 1, r.axis = r.axis || "enu", r.ellps = r.ellps || "wgs84", r.lat1 = r.lat1 || r.lat0;
  var l = sphere(r.a, r.b, r.rf, r.ellps, r.sphere), c = eccentricity(l.a, l.b, l.rf, r.R_A), u = getNadgrids(r.nadgrids), d = r.datum || datum(
    r.datumCode,
    r.datum_params,
    l.a,
    l.b,
    c.es,
    c.ep2,
    u
  );
  extend(this, r), extend(this, o), this.a = l.a, this.b = l.b, this.rf = l.rf, this.sphere = l.sphere, this.es = c.es, this.e = c.e, this.ep2 = c.ep2, this.datum = d, this.init(), e(null, this);
}
Projection.projections = projections;
Projection.projections.start();
function compareDatums(t, e) {
  return t.datum_type !== e.datum_type || t.a !== e.a || Math.abs(t.es - e.es) > 5e-11 ? !1 : t.datum_type === PJD_3PARAM ? t.datum_params[0] === e.datum_params[0] && t.datum_params[1] === e.datum_params[1] && t.datum_params[2] === e.datum_params[2] : t.datum_type === PJD_7PARAM ? t.datum_params[0] === e.datum_params[0] && t.datum_params[1] === e.datum_params[1] && t.datum_params[2] === e.datum_params[2] && t.datum_params[3] === e.datum_params[3] && t.datum_params[4] === e.datum_params[4] && t.datum_params[5] === e.datum_params[5] && t.datum_params[6] === e.datum_params[6] : !0;
}
function geodeticToGeocentric(t, e, r) {
  var o = t.x, s = t.y, l = t.z ? t.z : 0, c, u, d, f;
  if (s < -HALF_PI && s > -1.001 * HALF_PI)
    s = -HALF_PI;
  else if (s > HALF_PI && s < 1.001 * HALF_PI)
    s = HALF_PI;
  else {
    if (s < -HALF_PI)
      return { x: -1 / 0, y: -1 / 0, z: t.z };
    if (s > HALF_PI)
      return { x: 1 / 0, y: 1 / 0, z: t.z };
  }
  return o > Math.PI && (o -= 2 * Math.PI), u = Math.sin(s), f = Math.cos(s), d = u * u, c = r / Math.sqrt(1 - e * d), {
    x: (c + l) * f * Math.cos(o),
    y: (c + l) * f * Math.sin(o),
    z: (c * (1 - e) + l) * u
  };
}
function geocentricToGeodetic(t, e, r, o) {
  var s = 1e-12, l = s * s, c = 30, u, d, f, T, Q, m, g, v, b, L, A, M, S, E = t.x, k = t.y, w = t.z ? t.z : 0, O, D, R;
  if (u = Math.sqrt(E * E + k * k), d = Math.sqrt(E * E + k * k + w * w), u / r < s) {
    if (O = 0, d / r < s)
      return D = HALF_PI, R = -o, {
        x: t.x,
        y: t.y,
        z: t.z
      };
  } else
    O = Math.atan2(k, E);
  f = w / d, T = u / d, Q = 1 / Math.sqrt(1 - e * (2 - e) * T * T), v = T * (1 - e) * Q, b = f * Q, S = 0;
  do
    S++, g = r / Math.sqrt(1 - e * b * b), R = u * v + w * b - g * (1 - e * b * b), m = e * g / (g + R), Q = 1 / Math.sqrt(1 - m * (2 - m) * T * T), L = T * (1 - m) * Q, A = f * Q, M = A * v - L * b, v = L, b = A;
  while (M * M > l && S < c);
  return D = Math.atan(A / Math.abs(L)), {
    x: O,
    y: D,
    z: R
  };
}
function geocentricToWgs84(t, e, r) {
  if (e === PJD_3PARAM)
    return {
      x: t.x + r[0],
      y: t.y + r[1],
      z: t.z + r[2]
    };
  if (e === PJD_7PARAM) {
    var o = r[0], s = r[1], l = r[2], c = r[3], u = r[4], d = r[5], f = r[6];
    return {
      x: f * (t.x - d * t.y + u * t.z) + o,
      y: f * (d * t.x + t.y - c * t.z) + s,
      z: f * (-u * t.x + c * t.y + t.z) + l
    };
  }
}
function geocentricFromWgs84(t, e, r) {
  if (e === PJD_3PARAM)
    return {
      x: t.x - r[0],
      y: t.y - r[1],
      z: t.z - r[2]
    };
  if (e === PJD_7PARAM) {
    var o = r[0], s = r[1], l = r[2], c = r[3], u = r[4], d = r[5], f = r[6], T = (t.x - o) / f, Q = (t.y - s) / f, m = (t.z - l) / f;
    return {
      x: T + d * Q - u * m,
      y: -d * T + Q + c * m,
      z: u * T - c * Q + m
    };
  }
}
function checkParams(t) {
  return t === PJD_3PARAM || t === PJD_7PARAM;
}
function datum_transform(t, e, r) {
  if (compareDatums(t, e) || t.datum_type === PJD_NODATUM || e.datum_type === PJD_NODATUM)
    return r;
  var o = t.a, s = t.es;
  if (t.datum_type === PJD_GRIDSHIFT) {
    var l = applyGridShift(t, !1, r);
    if (l !== 0)
      return;
    o = SRS_WGS84_SEMIMAJOR, s = SRS_WGS84_ESQUARED;
  }
  var c = e.a, u = e.b, d = e.es;
  if (e.datum_type === PJD_GRIDSHIFT && (c = SRS_WGS84_SEMIMAJOR, u = SRS_WGS84_SEMIMINOR, d = SRS_WGS84_ESQUARED), s === d && o === c && !checkParams(t.datum_type) && !checkParams(e.datum_type))
    return r;
  if (r = geodeticToGeocentric(r, s, o), checkParams(t.datum_type) && (r = geocentricToWgs84(r, t.datum_type, t.datum_params)), checkParams(e.datum_type) && (r = geocentricFromWgs84(r, e.datum_type, e.datum_params)), r = geocentricToGeodetic(r, d, c, u), e.datum_type === PJD_GRIDSHIFT) {
    var f = applyGridShift(e, !0, r);
    if (f !== 0)
      return;
  }
  return r;
}
function applyGridShift(t, e, r) {
  if (t.grids === null || t.grids.length === 0)
    return console.log("Grid shift grids not found"), -1;
  for (var o = { x: -r.x, y: r.y }, s = { x: Number.NaN, y: Number.NaN }, l = [], c = 0; c < t.grids.length; c++) {
    var u = t.grids[c];
    if (l.push(u.name), u.isNull) {
      s = o;
      break;
    }
    if (u.mandatory, u.grid === null) {
      if (u.mandatory)
        return console.log("Unable to find mandatory grid '" + u.name + "'"), -1;
      continue;
    }
    var d = u.grid.subgrids[0], f = (Math.abs(d.del[1]) + Math.abs(d.del[0])) / 1e4, T = d.ll[0] - f, Q = d.ll[1] - f, m = d.ll[0] + (d.lim[0] - 1) * d.del[0] + f, g = d.ll[1] + (d.lim[1] - 1) * d.del[1] + f;
    if (!(Q > o.y || T > o.x || g < o.y || m < o.x) && (s = applySubgridShift(o, e, d), !isNaN(s.x)))
      break;
  }
  return isNaN(s.x) ? (console.log("Failed to find a grid shift table for location '" + -o.x * R2D + " " + o.y * R2D + " tried: '" + l + "'"), -1) : (r.x = -s.x, r.y = s.y, 0);
}
function applySubgridShift(t, e, r) {
  var o = { x: Number.NaN, y: Number.NaN };
  if (isNaN(t.x))
    return o;
  var s = { x: t.x, y: t.y };
  s.x -= r.ll[0], s.y -= r.ll[1], s.x = adjust_lon(s.x - Math.PI) + Math.PI;
  var l = nadInterpolate(s, r);
  if (e) {
    if (isNaN(l.x))
      return o;
    l.x = s.x - l.x, l.y = s.y - l.y;
    var c = 9, u = 1e-12, d, f;
    do {
      if (f = nadInterpolate(l, r), isNaN(f.x)) {
        console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");
        break;
      }
      d = { x: s.x - (f.x + l.x), y: s.y - (f.y + l.y) }, l.x += d.x, l.y += d.y;
    } while (c-- && Math.abs(d.x) > u && Math.abs(d.y) > u);
    if (c < 0)
      return console.log("Inverse grid shift iterator failed to converge."), o;
    o.x = adjust_lon(l.x + r.ll[0]), o.y = l.y + r.ll[1];
  } else
    isNaN(l.x) || (o.x = t.x + l.x, o.y = t.y + l.y);
  return o;
}
function nadInterpolate(t, e) {
  var r = { x: t.x / e.del[0], y: t.y / e.del[1] }, o = { x: Math.floor(r.x), y: Math.floor(r.y) }, s = { x: r.x - 1 * o.x, y: r.y - 1 * o.y }, l = { x: Number.NaN, y: Number.NaN }, c;
  if (o.x < 0 || o.x >= e.lim[0] || o.y < 0 || o.y >= e.lim[1])
    return l;
  c = o.y * e.lim[0] + o.x;
  var u = { x: e.cvs[c][0], y: e.cvs[c][1] };
  c++;
  var d = { x: e.cvs[c][0], y: e.cvs[c][1] };
  c += e.lim[0];
  var f = { x: e.cvs[c][0], y: e.cvs[c][1] };
  c--;
  var T = { x: e.cvs[c][0], y: e.cvs[c][1] }, Q = s.x * s.y, m = s.x * (1 - s.y), g = (1 - s.x) * (1 - s.y), v = (1 - s.x) * s.y;
  return l.x = g * u.x + m * d.x + v * T.x + Q * f.x, l.y = g * u.y + m * d.y + v * T.y + Q * f.y, l;
}
function adjust_axis(t, e, r) {
  var o = r.x, s = r.y, l = r.z || 0, c, u, d, f = {};
  for (d = 0; d < 3; d++)
    if (!(e && d === 2 && r.z === void 0))
      switch (d === 0 ? (c = o, "ew".indexOf(t.axis[d]) !== -1 ? u = "x" : u = "y") : d === 1 ? (c = s, "ns".indexOf(t.axis[d]) !== -1 ? u = "y" : u = "x") : (c = l, u = "z"), t.axis[d]) {
        case "e":
          f[u] = c;
          break;
        case "w":
          f[u] = -c;
          break;
        case "n":
          f[u] = c;
          break;
        case "s":
          f[u] = -c;
          break;
        case "u":
          r[u] !== void 0 && (f.z = c);
          break;
        case "d":
          r[u] !== void 0 && (f.z = -c);
          break;
        default:
          return null;
      }
  return f;
}
function toPoint(t) {
  var e = {
    x: t[0],
    y: t[1]
  };
  return t.length > 2 && (e.z = t[2]), t.length > 3 && (e.m = t[3]), e;
}
function checkSanity(t) {
  checkCoord(t.x), checkCoord(t.y);
}
function checkCoord(t) {
  if (typeof Number.isFinite == "function") {
    if (Number.isFinite(t))
      return;
    throw new TypeError("coordinates must be finite numbers");
  }
  if (typeof t != "number" || t !== t || !isFinite(t))
    throw new TypeError("coordinates must be finite numbers");
}
function checkNotWGS(t, e) {
  return (t.datum.datum_type === PJD_3PARAM || t.datum.datum_type === PJD_7PARAM) && e.datumCode !== "WGS84" || (e.datum.datum_type === PJD_3PARAM || e.datum.datum_type === PJD_7PARAM) && t.datumCode !== "WGS84";
}
function transform(t, e, r, o) {
  var s;
  if (Array.isArray(r) && (r = toPoint(r)), checkSanity(r), t.datum && e.datum && checkNotWGS(t, e) && (s = new Projection("WGS84"), r = transform(t, s, r, o), t = s), o && t.axis !== "enu" && (r = adjust_axis(t, !1, r)), t.projName === "longlat")
    r = {
      x: r.x * D2R$1,
      y: r.y * D2R$1,
      z: r.z || 0
    };
  else if (t.to_meter && (r = {
    x: r.x * t.to_meter,
    y: r.y * t.to_meter,
    z: r.z || 0
  }), r = t.inverse(r), !r)
    return;
  if (t.from_greenwich && (r.x += t.from_greenwich), r = datum_transform(t.datum, e.datum, r), !!r)
    return e.from_greenwich && (r = {
      x: r.x - e.from_greenwich,
      y: r.y,
      z: r.z || 0
    }), e.projName === "longlat" ? r = {
      x: r.x * R2D,
      y: r.y * R2D,
      z: r.z || 0
    } : (r = e.forward(r), e.to_meter && (r = {
      x: r.x / e.to_meter,
      y: r.y / e.to_meter,
      z: r.z || 0
    })), o && e.axis !== "enu" ? adjust_axis(e, !0, r) : r;
}
var wgs84$1 = Projection("WGS84");
function transformer(t, e, r, o) {
  var s, l, c;
  return Array.isArray(r) ? (s = transform(t, e, r, o) || { x: NaN, y: NaN }, r.length > 2 ? typeof t.name < "u" && t.name === "geocent" || typeof e.name < "u" && e.name === "geocent" ? typeof s.z == "number" ? [s.x, s.y, s.z].concat(r.splice(3)) : [s.x, s.y, r[2]].concat(r.splice(3)) : [s.x, s.y].concat(r.splice(2)) : [s.x, s.y]) : (l = transform(t, e, r, o), c = Object.keys(r), c.length === 2 || c.forEach(function(u) {
    if (typeof t.name < "u" && t.name === "geocent" || typeof e.name < "u" && e.name === "geocent") {
      if (u === "x" || u === "y" || u === "z")
        return;
    } else if (u === "x" || u === "y")
      return;
    l[u] = r[u];
  }), l);
}
function checkProj(t) {
  return t instanceof Projection ? t : t.oProj ? t.oProj : Projection(t);
}
function proj4(t, e, r) {
  t = checkProj(t);
  var o = !1, s;
  return typeof e > "u" ? (e = t, t = wgs84$1, o = !0) : (typeof e.x < "u" || Array.isArray(e)) && (r = e, e = t, t = wgs84$1, o = !0), e = checkProj(e), r ? transformer(t, e, r) : (s = {
    forward: function(l, c) {
      return transformer(t, e, l, c);
    },
    inverse: function(l, c) {
      return transformer(e, t, l, c);
    }
  }, o && (s.oProj = e), s);
}
const mercator = new Projection("GOOGLE"), wgs84 = new Projection("WGS84"), _wgs84_mercator = proj4(wgs84, mercator), wgs84_mercator = {
  compute(t, e) {
    return isFinite(t) && isFinite(e) ? _wgs84_mercator.forward([t, e]) : [NaN, NaN];
  },
  invert(t, e) {
    return isFinite(t) && isFinite(e) ? _wgs84_mercator.inverse([t, e]) : [NaN, NaN];
  }
}, mercator_bounds = {
  lon: [-2002637639e-2, 2002637639e-2],
  lat: [-200489661e-1, 200489661e-1]
}, latlon_bounds = {
  lon: [-180, 180],
  lat: [-85.06, 85.06]
}, { min: min$4, max: max$6 } = Math;
function clip_mercator(t, e, r) {
  const [o, s] = mercator_bounds[r];
  return [max$6(t, o), min$4(e, s)];
}
function in_bounds(t, e) {
  const [r, o] = latlon_bounds[e];
  return r < t && t < o;
}
var inplace;
(function(t) {
  function e(o, s, l, c) {
    const u = min$4(o.length, s.length);
    l = l != null ? l : o, c = c != null ? c : s;
    for (let d = 0; d < u; d++) {
      const f = o[d], T = s[d], [Q, m] = wgs84_mercator.compute(f, T);
      l[d] = Q, c[d] = m;
    }
  }
  t.project_xy = e;
  function r(o, s, l, c) {
    const u = min$4(o.length, s.length);
    l = l != null ? l : o, c = c != null ? c : s;
    for (let d = 0; d < u; d++)
      e(o[d], s[d], l[d], c[d]);
  }
  t.project_xsys = r;
})(inplace || (inplace = {}));
var _a$3E;
class DataAnnotationView extends AnnotationView {
  constructor() {
    super(...arguments), this._initial_set_data = !1;
  }
  connect_signals() {
    super.connect_signals();
    const e = () => {
      this.set_data(this.model.source), this._rerender();
    };
    this.connect(this.model.change, e), this.connect(this.model.source.streaming, e), this.connect(this.model.source.patching, e), this.connect(this.model.source.change, e);
  }
  _rerender() {
    this.request_render();
  }
  set_data(e) {
    const r = this;
    for (const o of this.model)
      if (o instanceof VectorSpec || o instanceof ScalarSpec)
        if (o instanceof BaseCoordinateSpec) {
          const s = o.array(e);
          r[`_${o.attr}`] = s;
        } else {
          const s = o.uniform(e);
          r[`${o.attr}`] = s;
        }
    this.plot_model.use_map && (r._x != null && inplace.project_xy(r._x, r._y), r._xs != null && inplace.project_xsys(r._xs, r._ys));
    for (const o of this.visuals)
      o.update();
  }
  _render() {
    this._initial_set_data || (this.set_data(this.model.source), this._initial_set_data = !0), this.map_data(), this.paint(this.layer.ctx);
  }
}
DataAnnotationView.__name__ = "DataAnnotationView";
class DataAnnotation extends Annotation {
  constructor(e) {
    super(e);
  }
}
_a$3E = DataAnnotation;
DataAnnotation.__name__ = "DataAnnotation";
_a$3E.define(({ Ref: t }) => ({
  source: [t(ColumnarDataSource), () => new ColumnDataSource()]
}));
var _a$3D, _b$9, _c$5, _d$3, _e$3;
class ArrowHeadView extends View {
  initialize() {
    super.initialize(), this.visuals = new Visuals(this);
  }
  request_render() {
    this.parent.request_render();
  }
  get canvas() {
    return this.parent.canvas;
  }
  set_data(e) {
    const r = this;
    for (const o of this.model) {
      if (!(o instanceof VectorSpec || o instanceof ScalarSpec))
        continue;
      const s = o.uniform(e);
      r[`${o.attr}`] = s;
    }
  }
}
ArrowHeadView.__name__ = "ArrowHeadView";
class ArrowHead extends Model {
  constructor(e) {
    super(e);
  }
}
_a$3D = ArrowHead;
ArrowHead.__name__ = "ArrowHead";
_a$3D.define(() => ({
  size: [NumberSpec, 25]
}));
class OpenHeadView extends ArrowHeadView {
  clip(e, r) {
    this.visuals.line.set_vectorize(e, r);
    const o = this.size.get(r);
    e.moveTo(0.5 * o, o), e.lineTo(0.5 * o, -2), e.lineTo(-0.5 * o, -2), e.lineTo(-0.5 * o, o), e.lineTo(0, 0), e.lineTo(0.5 * o, o);
  }
  render(e, r) {
    if (this.visuals.line.doit) {
      this.visuals.line.set_vectorize(e, r);
      const o = this.size.get(r);
      e.beginPath(), e.moveTo(0.5 * o, o), e.lineTo(0, 0), e.lineTo(-0.5 * o, o), e.stroke();
    }
  }
}
OpenHeadView.__name__ = "OpenHeadView";
class OpenHead extends ArrowHead {
  constructor(e) {
    super(e);
  }
}
_b$9 = OpenHead;
OpenHead.__name__ = "OpenHead";
_b$9.prototype.default_view = OpenHeadView, _b$9.mixins(LineVector$1);
class NormalHeadView extends ArrowHeadView {
  clip(e, r) {
    this.visuals.line.set_vectorize(e, r);
    const o = this.size.get(r);
    e.moveTo(0.5 * o, o), e.lineTo(0.5 * o, -2), e.lineTo(-0.5 * o, -2), e.lineTo(-0.5 * o, o), e.lineTo(0.5 * o, o);
  }
  render(e, r) {
    this.visuals.fill.doit && (this.visuals.fill.set_vectorize(e, r), this._normal(e, r), e.fill()), this.visuals.line.doit && (this.visuals.line.set_vectorize(e, r), this._normal(e, r), e.stroke());
  }
  _normal(e, r) {
    const o = this.size.get(r);
    e.beginPath(), e.moveTo(0.5 * o, o), e.lineTo(0, 0), e.lineTo(-0.5 * o, o), e.closePath();
  }
}
NormalHeadView.__name__ = "NormalHeadView";
class NormalHead extends ArrowHead {
  constructor(e) {
    super(e);
  }
}
_c$5 = NormalHead;
NormalHead.__name__ = "NormalHead";
_c$5.prototype.default_view = NormalHeadView, _c$5.mixins([LineVector$1, FillVector$1]), _c$5.override({
  fill_color: "black"
});
class VeeHeadView extends ArrowHeadView {
  clip(e, r) {
    this.visuals.line.set_vectorize(e, r);
    const o = this.size.get(r);
    e.moveTo(0.5 * o, o), e.lineTo(0.5 * o, -2), e.lineTo(-0.5 * o, -2), e.lineTo(-0.5 * o, o), e.lineTo(0, 0.5 * o), e.lineTo(0.5 * o, o);
  }
  render(e, r) {
    this.visuals.fill.doit && (this.visuals.fill.set_vectorize(e, r), this._vee(e, r), e.fill()), this.visuals.line.doit && (this.visuals.line.set_vectorize(e, r), this._vee(e, r), e.stroke());
  }
  _vee(e, r) {
    const o = this.size.get(r);
    e.beginPath(), e.moveTo(0.5 * o, o), e.lineTo(0, 0), e.lineTo(-0.5 * o, o), e.lineTo(0, 0.5 * o), e.closePath();
  }
}
VeeHeadView.__name__ = "VeeHeadView";
class VeeHead extends ArrowHead {
  constructor(e) {
    super(e);
  }
}
_d$3 = VeeHead;
VeeHead.__name__ = "VeeHead";
_d$3.prototype.default_view = VeeHeadView, _d$3.mixins([LineVector$1, FillVector$1]), _d$3.override({
  fill_color: "black"
});
class TeeHeadView extends ArrowHeadView {
  render(e, r) {
    if (this.visuals.line.doit) {
      this.visuals.line.set_vectorize(e, r);
      const o = this.size.get(r);
      e.beginPath(), e.moveTo(0.5 * o, 0), e.lineTo(-0.5 * o, 0), e.stroke();
    }
  }
  clip(e, r) {
  }
}
TeeHeadView.__name__ = "TeeHeadView";
class TeeHead extends ArrowHead {
  constructor(e) {
    super(e);
  }
}
_e$3 = TeeHead;
TeeHead.__name__ = "TeeHead";
_e$3.prototype.default_view = TeeHeadView, _e$3.mixins(LineVector$1);
async function _build_view(t, e, r) {
  const o = new t({ ...r, model: e });
  return o.initialize(), await o.lazy_initialize(), o;
}
async function build_view(t, e = { parent: null }, r = (o) => o.default_view) {
  const o = await _build_view(r(t), t, e);
  return o.connect_signals(), o;
}
async function build_views(t, e, r = { parent: null }, o = (s) => s.default_view) {
  const s = difference$1([...t.keys()], e);
  for (const u of s)
    t.get(u).remove(), t.delete(u);
  const l = [], c = e.filter((u) => !t.has(u));
  for (const u of c) {
    const d = await _build_view(o(u), u, r);
    t.set(u, d), l.push(d);
  }
  for (const u of l)
    u.connect_signals();
  return l;
}
function remove_views(t) {
  for (const [e, r] of t)
    r.remove(), t.delete(e);
}
var _a$3C;
class ArrowView extends DataAnnotationView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { start: e, end: r } = this.model;
    e != null && (this.start = await build_view(e, { parent: this })), r != null && (this.end = await build_view(r, { parent: this }));
  }
  set_data(e) {
    var r, o;
    super.set_data(e), (r = this.start) == null || r.set_data(e), (o = this.end) == null || o.set_data(e);
  }
  remove() {
    var e, r;
    (e = this.start) == null || e.remove(), (r = this.end) == null || r.remove(), super.remove();
  }
  map_data() {
    const { frame: e } = this.plot_view;
    this.model.start_units == "data" ? (this._sx_start = this.coordinates.x_scale.v_compute(this._x_start), this._sy_start = this.coordinates.y_scale.v_compute(this._y_start)) : (this._sx_start = e.bbox.xview.v_compute(this._x_start), this._sy_start = e.bbox.yview.v_compute(this._y_start)), this.model.end_units == "data" ? (this._sx_end = this.coordinates.x_scale.v_compute(this._x_end), this._sy_end = this.coordinates.y_scale.v_compute(this._y_end)) : (this._sx_end = e.bbox.xview.v_compute(this._x_end), this._sy_end = e.bbox.yview.v_compute(this._y_end));
    const { _sx_start: r, _sy_start: o, _sx_end: s, _sy_end: l } = this, c = r.length, u = this._angles = new ScreenArray(c);
    for (let d = 0; d < c; d++)
      u[d] = Math.PI / 2 + atan2([r[d], o[d]], [s[d], l[d]]);
  }
  paint(e) {
    const { start: r, end: o } = this, { _sx_start: s, _sy_start: l, _sx_end: c, _sy_end: u, _angles: d } = this, { x: f, y: T, width: Q, height: m } = this.plot_view.frame.bbox;
    for (let g = 0, v = s.length; g < v; g++)
      o != null && (e.save(), e.translate(c[g], u[g]), e.rotate(d[g]), o.render(e, g), e.restore()), r != null && (e.save(), e.translate(s[g], l[g]), e.rotate(d[g] + Math.PI), r.render(e, g), e.restore()), this.visuals.line.doit && (e.save(), (r != null || o != null) && (e.beginPath(), e.rect(f, T, Q, m), o != null && (e.save(), e.translate(c[g], u[g]), e.rotate(d[g]), o.clip(e, g), e.restore()), r != null && (e.save(), e.translate(s[g], l[g]), e.rotate(d[g] + Math.PI), r.clip(e, g), e.restore()), e.closePath(), e.clip()), this.visuals.line.set_vectorize(e, g), e.beginPath(), e.moveTo(s[g], l[g]), e.lineTo(c[g], u[g]), e.stroke(), e.restore());
  }
}
ArrowView.__name__ = "ArrowView";
class Arrow extends DataAnnotation {
  constructor(e) {
    super(e);
  }
}
_a$3C = Arrow;
Arrow.__name__ = "Arrow";
_a$3C.prototype.default_view = ArrowView, _a$3C.mixins(LineVector$1), _a$3C.define(({ Ref: t, Nullable: e }) => ({
  x_start: [XCoordinateSpec, { field: "x_start" }],
  y_start: [YCoordinateSpec, { field: "y_start" }],
  start_units: [SpatialUnits, "data"],
  start: [e(t(ArrowHead)), null],
  x_end: [XCoordinateSpec, { field: "x_end" }],
  y_end: [YCoordinateSpec, { field: "y_end" }],
  end_units: [SpatialUnits, "data"],
  end: [e(t(ArrowHead)), () => new OpenHead()]
}));
var _a$3B;
class UpperLowerView extends DataAnnotationView {
  map_data() {
    const { frame: e } = this.plot_view, r = this.model.dimension, o = this.coordinates.x_scale, s = this.coordinates.y_scale, l = r == "height" ? s : o, c = r == "height" ? o : s, u = r == "height" ? e.bbox.yview : e.bbox.xview, d = r == "height" ? e.bbox.xview : e.bbox.yview;
    let f;
    this.model.properties.lower.units == "data" ? f = l.v_compute(this._lower) : f = u.v_compute(this._lower);
    let T;
    this.model.properties.upper.units == "data" ? T = l.v_compute(this._upper) : T = u.v_compute(this._upper);
    let Q;
    this.model.properties.base.units == "data" ? Q = c.v_compute(this._base) : Q = d.v_compute(this._base);
    const [m, g] = r == "height" ? [1, 0] : [0, 1], v = [f, Q], b = [T, Q];
    this._lower_sx = v[m], this._lower_sy = v[g], this._upper_sx = b[m], this._upper_sy = b[g];
  }
}
UpperLowerView.__name__ = "UpperLowerView";
class XOrYCoordinateSpec extends CoordinateSpec {
  get dimension() {
    return this.obj.dimension == "width" ? "x" : "y";
  }
  get units() {
    var e;
    return (e = this.spec.units) != null ? e : "data";
  }
}
XOrYCoordinateSpec.__name__ = "XOrYCoordinateSpec";
class UpperLower extends DataAnnotation {
  constructor(e) {
    super(e);
  }
}
_a$3B = UpperLower;
UpperLower.__name__ = "UpperLower";
_a$3B.define(() => ({
  dimension: [Dimension, "height"],
  lower: [XOrYCoordinateSpec, { field: "lower" }],
  upper: [XOrYCoordinateSpec, { field: "upper" }],
  base: [XOrYCoordinateSpec, { field: "base" }]
}));
var _a$3A;
class BandView extends UpperLowerView {
  paint(e) {
    e.beginPath(), e.moveTo(this._lower_sx[0], this._lower_sy[0]);
    for (let r = 0, o = this._lower_sx.length; r < o; r++)
      e.lineTo(this._lower_sx[r], this._lower_sy[r]);
    for (let r = this._upper_sx.length - 1; r >= 0; r--)
      e.lineTo(this._upper_sx[r], this._upper_sy[r]);
    e.closePath(), this.visuals.fill.apply(e), e.beginPath(), e.moveTo(this._lower_sx[0], this._lower_sy[0]);
    for (let r = 0, o = this._lower_sx.length; r < o; r++)
      e.lineTo(this._lower_sx[r], this._lower_sy[r]);
    this.visuals.line.apply(e), e.beginPath(), e.moveTo(this._upper_sx[0], this._upper_sy[0]);
    for (let r = 0, o = this._upper_sx.length; r < o; r++)
      e.lineTo(this._upper_sx[r], this._upper_sy[r]);
    this.visuals.line.apply(e);
  }
}
BandView.__name__ = "BandView";
class Band extends UpperLower {
  constructor(e) {
    super(e);
  }
}
_a$3A = Band;
Band.__name__ = "Band";
_a$3A.prototype.default_view = BandView, _a$3A.mixins([Line$2, Fill$1]), _a$3A.override({
  fill_color: "#fff9ba",
  fill_alpha: 0.4,
  line_color: "#cccccc",
  line_alpha: 0.3
});
var _a$3z;
const EDGE_TOLERANCE = 2.5;
class BoxAnnotationView extends AnnotationView {
  constructor() {
    super(...arguments), this.bbox = new BBox$2();
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.change, () => this.request_render());
  }
  _render() {
    const { left: e, right: r, top: o, bottom: s } = this.model;
    if (e == null && r == null && o == null && s == null)
      return;
    const { frame: l } = this.plot_view, c = this.coordinates.x_scale, u = this.coordinates.y_scale, d = (f, T, Q, m, g) => {
      let v;
      return f != null ? this.model.screen ? v = f : T == "data" ? v = Q.compute(f) : v = m.compute(f) : v = g, v;
    };
    this.bbox = BBox$2.from_rect({
      left: d(e, this.model.left_units, c, l.bbox.xview, l.bbox.left),
      right: d(r, this.model.right_units, c, l.bbox.xview, l.bbox.right),
      top: d(o, this.model.top_units, u, l.bbox.yview, l.bbox.top),
      bottom: d(s, this.model.bottom_units, u, l.bbox.yview, l.bbox.bottom)
    }), this._paint_box();
  }
  _paint_box() {
    const { ctx: e } = this.layer;
    e.save();
    const { left: r, top: o, width: s, height: l } = this.bbox;
    e.beginPath(), e.rect(r, o, s, l), this.visuals.fill.apply(e), this.visuals.hatch.apply(e), this.visuals.line.apply(e), e.restore();
  }
  interactive_bbox() {
    const e = this.model.line_width + EDGE_TOLERANCE;
    return this.bbox.grow_by(e);
  }
  interactive_hit(e, r) {
    return this.model.in_cursor == null ? !1 : this.interactive_bbox().contains(e, r);
  }
  cursor(e, r) {
    const { left: s, right: l, bottom: c, top: u } = this.bbox;
    return Math.abs(e - s) < 3 || Math.abs(e - l) < 3 ? this.model.ew_cursor : Math.abs(r - c) < 3 || Math.abs(r - u) < 3 ? this.model.ns_cursor : this.bbox.contains(e, r) ? this.model.in_cursor : null;
  }
}
BoxAnnotationView.__name__ = "BoxAnnotationView";
class BoxAnnotation extends Annotation {
  constructor(e) {
    super(e);
  }
  update({ left: e, right: r, top: o, bottom: s }) {
    this.setv({ left: e, right: r, top: o, bottom: s, screen: !0 });
  }
}
_a$3z = BoxAnnotation;
BoxAnnotation.__name__ = "BoxAnnotation";
_a$3z.prototype.default_view = BoxAnnotationView, _a$3z.mixins([Line$2, Fill$1, Hatch$1]), _a$3z.define(({ Number: t, Nullable: e }) => ({
  top: [e(t), null],
  top_units: [SpatialUnits, "data"],
  bottom: [e(t), null],
  bottom_units: [SpatialUnits, "data"],
  left: [e(t), null],
  left_units: [SpatialUnits, "data"],
  right: [e(t), null],
  right_units: [SpatialUnits, "data"],
  render_mode: [RenderMode, "canvas"]
})), _a$3z.internal(({ Boolean: t, String: e, Nullable: r }) => ({
  screen: [t, !1],
  ew_cursor: [r(e), null],
  ns_cursor: [r(e), null],
  in_cursor: [r(e), null]
})), _a$3z.override({
  fill_color: "#fff9ba",
  fill_alpha: 0.4,
  line_color: "#cccccc",
  line_alpha: 0.3
});
const has_OffscreenCanvas = (() => {
  try {
    return typeof OffscreenCanvas < "u" && new OffscreenCanvas(0, 0).getContext("2d") != null;
  } catch {
    return !1;
  }
})(), _offscreen_canvas = (() => has_OffscreenCanvas ? (t, e) => new OffscreenCanvas(t, e) : (t, e) => {
  const r = document.createElement("canvas");
  return r.width = t, r.height = e, r;
})(), _native_font_metrics = (() => {
  const e = _offscreen_canvas(0, 0).getContext("2d");
  return (r) => {
    e.font = r;
    const o = e.measureText("M"), s = e.measureText("x"), l = e.measureText("\xC5\u015Ag|"), c = l.fontBoundingBoxAscent, u = l.fontBoundingBoxDescent;
    if (c != null && u != null)
      return {
        height: c + u,
        ascent: c,
        descent: u,
        cap_height: o.actualBoundingBoxAscent,
        x_height: s.actualBoundingBoxAscent
      };
    const d = l.actualBoundingBoxAscent, f = l.actualBoundingBoxDescent;
    if (d != null && f != null)
      return {
        height: d + f,
        ascent: d,
        descent: f,
        cap_height: o.actualBoundingBoxAscent,
        x_height: s.actualBoundingBoxAscent
      };
    unreachable();
  };
})(), _native_glyph_metrics = (() => {
  const e = _offscreen_canvas(0, 0).getContext("2d");
  return (r, o) => {
    e.font = o;
    const s = e.measureText(r), l = s.actualBoundingBoxAscent, c = s.actualBoundingBoxDescent;
    if (l != null && c != null)
      return {
        width: s.width,
        height: l + c,
        ascent: l,
        descent: c
      };
    unreachable();
  };
})(), _internal_font_metrics = (() => {
  const t = document.createElement("canvas"), e = t.getContext("2d");
  let r = -1, o = -1;
  return (s, l = 1) => {
    e.font = s;
    const { width: c } = e.measureText("M"), u = c * l, d = Math.ceil(u), f = Math.ceil(2 * u), T = Math.ceil(1.5 * u);
    r < d && (r = d, t.width = d), o < f && (o = f, t.height = f), e.save(), e.scale(l, l), e.fillStyle = "#f00", e.fillRect(0, 0, d, f);
    const Q = (E) => {
      let k = 0;
      for (let w = 0; w <= T; w++)
        for (let O = 0; O < d; O++, k += 4)
          if (E[k] != 255)
            return T - w;
      return 0;
    }, m = (E) => {
      let k = E.length - 4;
      for (let w = f; w >= T; w--)
        for (let O = 0; O < d; O++, k -= 4)
          if (E[k] != 255)
            return w - T;
      return 0;
    };
    e.font = s, e.fillStyle = "#000";
    for (const E of "xa")
      e.fillText(E, 0, T / l);
    const { data: g } = e.getImageData(0, 0, d, f), v = Q(g) / l;
    for (const E of "ASQ")
      e.fillText(E, 0, T / l);
    const { data: b } = e.getImageData(0, 0, d, f), L = Q(b) / l;
    for (const E of "\xC5\u015Agy")
      e.fillText(E, 0, T / l);
    const { data: A } = e.getImageData(0, 0, d, f), M = Q(A) / l, S = m(A) / l;
    return e.restore(), { height: M + S, ascent: M, cap_height: L, x_height: v, descent: S };
  };
})(), _internal_glyph_metrics = (() => {
  const t = document.createElement("canvas"), e = t.getContext("2d");
  let r = -1, o = -1;
  return (s, l, c = 1) => {
    e.font = l;
    const { width: u } = e.measureText("M"), d = u * c, f = Math.ceil(d), T = Math.ceil(2 * d), Q = Math.ceil(1.5 * d);
    (r < f || o < T) && (r = f, t.width = f, o = T, t.height = T), e.save(), e.scale(c, c), e.fillStyle = "#f00", e.fillRect(0, 0, f, T);
    const m = (M) => {
      let S = 0;
      for (let E = 0; E <= Q; E++)
        for (let k = 0; k < f; k++, S += 4)
          if (M[S] != 255)
            return Q - E;
      return 0;
    }, g = (M) => {
      let S = M.length - 4;
      for (let E = T; E >= Q; E--)
        for (let k = 0; k < f; k++, S -= 4)
          if (M[S] != 255)
            return E - Q;
      return 0;
    };
    e.font = l, e.fillStyle = "#000", e.fillText(s, 0, Q / c);
    const v = e.measureText(s), { data: b } = e.getImageData(0, 0, f, T), L = m(b) / c, A = g(b) / c;
    return e.restore(), { width: v.width, height: L + A, ascent: L, descent: A };
  };
})(), _font_metrics = (() => {
  try {
    return _native_font_metrics("normal 10px sans-serif"), _native_font_metrics;
  } catch {
    return _internal_font_metrics;
  }
})();
(() => {
  try {
    return _native_glyph_metrics("A", "normal 10px sans-serif"), _native_glyph_metrics;
  } catch {
    return _internal_glyph_metrics;
  }
})();
const _metrics_cache = /* @__PURE__ */ new Map();
function font_metrics(t) {
  let e = _metrics_cache.get(t);
  return e == null && (e = { font: _font_metrics(t), glyphs: /* @__PURE__ */ new Map() }, _metrics_cache.set(t, e)), e.font;
}
function parse_css_font_size(t) {
  const e = t.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);
  if (e != null) {
    const [, r, , o] = e, s = Number(r);
    if (isFinite(s))
      return { value: s, unit: o };
  }
  return null;
}
const { sin, cos } = Math;
class AffineTransform {
  constructor(e = 1, r = 0, o = 0, s = 1, l = 0, c = 0) {
    this.a = e, this.b = r, this.c = o, this.d = s, this.e = l, this.f = c;
  }
  toString() {
    const { a: e, b: r, c: o, d: s, e: l, f: c } = this;
    return `matrix(${e}, ${r}, ${o}, ${s}, ${l}, ${c})`;
  }
  static from_DOMMatrix(e) {
    const { a: r, b: o, c: s, d: l, e: c, f: u } = e;
    return new AffineTransform(r, o, s, l, c, u);
  }
  to_DOMMatrix() {
    const { a: e, b: r, c: o, d: s, e: l, f: c } = this;
    return new DOMMatrix([e, r, o, s, l, c]);
  }
  clone() {
    const { a: e, b: r, c: o, d: s, e: l, f: c } = this;
    return new AffineTransform(e, r, o, s, l, c);
  }
  get is_identity() {
    const { a: e, b: r, c: o, d: s, e: l, f: c } = this;
    return e == 1 && r == 0 && o == 0 && s == 1 && l == 0 && c == 0;
  }
  apply_point(e) {
    const [r, o] = this.apply(e.x, e.y);
    return { x: r, y: o };
  }
  apply_rect(e) {
    const r = this.apply_point(e.p0), o = this.apply_point(e.p1), s = this.apply_point(e.p2), l = this.apply_point(e.p3);
    return { p0: r, p1: o, p2: s, p3: l };
  }
  apply(e, r) {
    const { a: o, b: s, c: l, d: c, e: u, f: d } = this;
    return [
      o * e + l * r + u,
      s * e + c * r + d
    ];
  }
  iv_apply(e, r) {
    const { a: o, b: s, c: l, d: c, e: u, f: d } = this, f = e.length;
    for (let T = 0; T < f; T++) {
      const Q = e[T], m = r[T];
      e[T] = o * Q + l * m + u, r[T] = s * Q + c * m + d;
    }
  }
  transform(e, r, o, s, l, c) {
    const { a: u, b: d, c: f, d: T, e: Q, f: m } = this;
    return this.a = u * e + f * r, this.c = u * o + f * s, this.e = u * l + f * c + Q, this.b = d * e + T * r, this.d = d * o + T * s, this.f = d * l + T * c + m, this;
  }
  translate(e, r) {
    return this.transform(1, 0, 0, 1, e, r);
  }
  scale(e, r) {
    return this.transform(e, 0, 0, r, 0, 0);
  }
  skew(e, r) {
    return this.transform(1, r, e, 1, 0, 0);
  }
  rotate(e) {
    const r = sin(e), o = cos(e);
    return this.transform(o, r, -r, o, 0, 0);
  }
  rotate_ccw(e) {
    return this.rotate(-e);
  }
  translate_x(e) {
    return this.translate(e, 0);
  }
  translate_y(e) {
    return this.translate(0, e);
  }
  flip() {
    return this.scale(-1, -1);
  }
  flip_x() {
    return this.scale(1, -1);
  }
  flip_y() {
    return this.scale(-1, 1);
  }
}
AffineTransform.__name__ = "AffineTransform";
const text_width = (() => {
  const e = document.createElement("canvas").getContext("2d");
  let r = "";
  return (o, s) => (s != r && (r = s, e.font = s), e.measureText(o).width);
})();
class GraphicsBox {
  constructor() {
    this._position = { sx: 0, sy: 0 }, this.font_size_scale = 1, this.align = "left", this._base_font_size = 13, this._x_anchor = "left", this._y_anchor = "center";
  }
  set base_font_size(e) {
    e != null && (this._base_font_size = e);
  }
  get base_font_size() {
    return this._base_font_size;
  }
  set position(e) {
    this._position = e;
  }
  get position() {
    return this._position;
  }
  infer_text_height() {
    return "ascent_descent";
  }
  bbox() {
    const { p0: e, p1: r, p2: o, p3: s } = this.rect(), l = Math.min(e.x, r.x, o.x, s.x), c = Math.min(e.y, r.y, o.y, s.y), u = Math.max(e.x, r.x, o.x, s.x), d = Math.max(e.y, r.y, o.y, s.y);
    return new BBox$2({ left: l, right: u, top: c, bottom: d });
  }
  size() {
    const { width: e, height: r } = this._size(), { angle: o } = this;
    if (o) {
      const s = Math.cos(Math.abs(o)), l = Math.sin(Math.abs(o));
      return {
        width: Math.abs(e * s + r * l),
        height: Math.abs(e * l + r * s)
      };
    } else
      return { width: e, height: r };
  }
  rect() {
    const e = this._rect(), { angle: r } = this;
    if (r) {
      const { sx: o, sy: s } = this.position, l = new AffineTransform();
      return l.translate(o, s), l.rotate(r), l.translate(-o, -s), l.apply_rect(e);
    } else
      return e;
  }
  paint_rect(e) {
    const { p0: r, p1: o, p2: s, p3: l } = this.rect();
    e.save(), e.strokeStyle = "red", e.lineWidth = 1, e.beginPath();
    const { round: c } = Math;
    e.moveTo(c(r.x), c(r.y)), e.lineTo(c(o.x), c(o.y)), e.lineTo(c(s.x), c(s.y)), e.lineTo(c(l.x), c(l.y)), e.closePath(), e.stroke(), e.restore();
  }
  paint_bbox(e) {
    const { x: r, y: o, width: s, height: l } = this.bbox();
    e.save(), e.strokeStyle = "blue", e.lineWidth = 1, e.beginPath();
    const { round: c } = Math;
    e.moveTo(c(r), c(o)), e.lineTo(c(r), c(o + l)), e.lineTo(c(r + s), c(o + l)), e.lineTo(c(r + s), c(o)), e.closePath(), e.stroke(), e.restore();
  }
}
GraphicsBox.__name__ = "GraphicsBox";
class TextBox extends GraphicsBox {
  constructor({ text: e }) {
    super(), this.text = e;
  }
  set visuals(e) {
    const r = e.color, o = e.alpha, s = e.font_style;
    let l = e.font_size;
    const c = e.font, { font_size_scale: u, base_font_size: d } = this, f = parse_css_font_size(l);
    if (f != null) {
      let { value: g, unit: v } = f;
      g *= u, v == "em" && d && (g *= d, v = "px"), l = `${g}${v}`;
    }
    const T = `${s} ${l} ${c}`;
    this.font = T, this.color = color2css(r, o), this.line_height = e.line_height;
    const Q = e.align;
    this._x_anchor = Q;
    const m = e.baseline;
    this._y_anchor = (() => {
      switch (m) {
        case "top":
          return "top";
        case "middle":
          return "center";
        case "bottom":
          return "bottom";
        default:
          return "baseline";
      }
    })();
  }
  infer_text_height() {
    return this.text.includes(`
`) ? "ascent_descent" : function(r) {
      for (const o of new Set(r))
        if (!("0" <= o && o <= "9"))
          switch (o) {
            case ",":
            case ".":
            case "+":
            case "-":
            case "\u2212":
            case "e":
              continue;
            default:
              return !1;
          }
      return !0;
    }(this.text) ? "cap" : "ascent_descent";
  }
  _text_line(e) {
    var l;
    const r = (l = this.text_height_metric) != null ? l : this.infer_text_height(), o = (() => {
      switch (r) {
        case "x":
        case "x_descent":
          return e.x_height;
        case "cap":
        case "cap_descent":
          return e.cap_height;
        case "ascent":
        case "ascent_descent":
          return e.ascent;
      }
    })(), s = (() => {
      switch (r) {
        case "x":
        case "cap":
        case "ascent":
          return 0;
        case "x_descent":
        case "cap_descent":
        case "ascent_descent":
          return e.descent;
      }
    })();
    return { height: o + s, ascent: o, descent: s };
  }
  get nlines() {
    return this.text.split(`
`).length;
  }
  _size() {
    var v, b;
    const { font: e } = this, r = font_metrics(e), o = (this.line_height - 1) * r.height, s = this.text == "", l = this.text.split(`
`), c = l.length, u = l.map((L) => text_width(L, e)), f = this._text_line(r).height * c, T = ((v = this.width) == null ? void 0 : v.unit) == "%" ? this.width.value : 1, Q = ((b = this.height) == null ? void 0 : b.unit) == "%" ? this.height.value : 1, m = max$8(u) * T, g = s ? 0 : (f + o * (c - 1)) * Q;
    return { width: m, height: g, metrics: r };
  }
  _computed_position(e, r, o) {
    const { width: s, height: l } = e, { sx: c, sy: u, x_anchor: d = this._x_anchor, y_anchor: f = this._y_anchor } = this.position, T = c - (() => {
      if (isNumber(d))
        return d * s;
      switch (d) {
        case "left":
          return 0;
        case "center":
          return 0.5 * s;
        case "right":
          return s;
      }
    })(), Q = u - (() => {
      var m;
      if (isNumber(f))
        return f * l;
      switch (f) {
        case "top":
          return 0;
        case "center":
          return 0.5 * l;
        case "bottom":
          return l;
        case "baseline":
          if (o == 1)
            switch ((m = this.text_height_metric) != null ? m : this.infer_text_height()) {
              case "x":
              case "x_descent":
                return r.x_height;
              case "cap":
              case "cap_descent":
                return r.cap_height;
              case "ascent":
              case "ascent_descent":
                return r.ascent;
            }
          else
            return 0.5 * l;
      }
    })();
    return { x: T, y: Q };
  }
  _rect() {
    const { width: e, height: r, metrics: o } = this._size(), s = this.text.split(`
`).length, { x: l, y: c } = this._computed_position({ width: e, height: r }, o, s);
    return new BBox$2({ x: l, y: c, width: e, height: r }).rect;
  }
  paint(e) {
    var E, k;
    const { font: r } = this, o = font_metrics(r), s = (this.line_height - 1) * o.height, l = this.text.split(`
`), c = l.length, u = l.map((w) => text_width(w, r)), d = this._text_line(o), f = d.height * c, T = ((E = this.width) == null ? void 0 : E.unit) == "%" ? this.width.value : 1, Q = ((k = this.height) == null ? void 0 : k.unit) == "%" ? this.height.value : 1, m = max$8(u) * T, g = (f + s * (c - 1)) * Q;
    e.save(), e.fillStyle = this.color, e.font = this.font, e.textAlign = "left", e.textBaseline = "alphabetic";
    const { sx: v, sy: b } = this.position, { align: L } = this, { angle: A } = this;
    A && (e.translate(v, b), e.rotate(A), e.translate(-v, -b));
    let { x: M, y: S } = this._computed_position({ width: m, height: g }, o, c);
    if (L == "justify")
      for (let w = 0; w < c; w++) {
        let O = M;
        const R = l[w].split(" "), B = R.length, F = R.map((z) => text_width(z, r)), j = (m - sum$2(F)) / (B - 1);
        for (let z = 0; z < B; z++)
          e.fillText(R[z], O, S), O += F[z] + j;
        S += d.height + s;
      }
    else
      for (let w = 0; w < c; w++) {
        const O = M + (() => {
          switch (L) {
            case "left":
              return 0;
            case "center":
              return 0.5 * (m - u[w]);
            case "right":
              return m - u[w];
          }
        })();
        e.fillStyle = this.color, e.fillText(l[w], O, S + d.ascent), S += d.height + s;
      }
    e.restore();
  }
}
TextBox.__name__ = "TextBox";
class BaseExpo extends GraphicsBox {
  constructor(e, r) {
    super(), this.base = e, this.expo = r;
  }
  get children() {
    return [this.base, this.expo];
  }
  set base_font_size(e) {
    super.base_font_size = e, this.base.base_font_size = e, this.expo.base_font_size = e;
  }
  set position(e) {
    this._position = e;
    const r = this.base.size(), o = this.expo.size(), s = this._shift_scale() * r.height, l = Math.max(r.height, s + o.height);
    this.base.position = {
      sx: 0,
      x_anchor: "left",
      sy: l,
      y_anchor: "bottom"
    }, this.expo.position = {
      sx: r.width,
      x_anchor: "left",
      sy: s,
      y_anchor: "bottom"
    };
  }
  get position() {
    return this._position;
  }
  set visuals(e) {
    this.expo.font_size_scale = 0.7, this.base.visuals = e, this.expo.visuals = e;
  }
  _shift_scale() {
    if (this.base instanceof TextBox && this.base.nlines == 1) {
      const { x_height: e, cap_height: r } = font_metrics(this.base.font);
      return e / r;
    } else
      return 2 / 3;
  }
  infer_text_height() {
    return this.base.infer_text_height();
  }
  _rect() {
    const e = this.base.bbox(), r = this.expo.bbox(), o = e.union(r), { x: s, y: l } = this._computed_position();
    return o.translate(s, l).rect;
  }
  _size() {
    const e = this.base.size(), r = this.expo.size();
    return {
      width: e.width + r.width,
      height: Math.max(e.height, this._shift_scale() * e.height + r.height)
    };
  }
  paint(e) {
    e.save();
    const { angle: r } = this;
    if (r) {
      const { sx: l, sy: c } = this.position;
      e.translate(l, c), e.rotate(r), e.translate(-l, -c);
    }
    const { x: o, y: s } = this._computed_position();
    e.translate(o, s), this.base.paint(e), this.expo.paint(e), e.restore();
  }
  paint_bbox(e) {
    super.paint_bbox(e);
    const { x: r, y: o } = this._computed_position();
    e.save(), e.translate(r, o);
    for (const s of this.children)
      s.paint_bbox(e);
    e.restore();
  }
  _computed_position() {
    const { width: e, height: r } = this._size(), { sx: o, sy: s, x_anchor: l = this._x_anchor, y_anchor: c = this._y_anchor } = this.position, u = o - (() => {
      if (isNumber(l))
        return l * e;
      switch (l) {
        case "left":
          return 0;
        case "center":
          return 0.5 * e;
        case "right":
          return e;
      }
    })(), d = s - (() => {
      if (isNumber(c))
        return c * r;
      switch (c) {
        case "top":
          return 0;
        case "center":
          return 0.5 * r;
        case "bottom":
          return r;
        case "baseline":
          return 0.5 * r;
      }
    })();
    return { x: u, y: d };
  }
}
BaseExpo.__name__ = "BaseExpo";
class GraphicsBoxes {
  constructor(e) {
    this.items = e;
  }
  set base_font_size(e) {
    for (const r of this.items)
      r.base_font_size = e;
  }
  get length() {
    return this.items.length;
  }
  set visuals(e) {
    for (const s of this.items)
      s.visuals = e;
    const r = { x: 0, cap: 1, ascent: 2, x_descent: 3, cap_descent: 4, ascent_descent: 5 }, o = max_by(this.items.map((s) => s.infer_text_height()), (s) => r[s]);
    for (const s of this.items)
      s.text_height_metric = o;
  }
  set angle(e) {
    for (const r of this.items)
      r.angle = e;
  }
  max_size() {
    let e = 0, r = 0;
    for (const o of this.items) {
      const s = o.size();
      e = Math.max(e, s.width), r = Math.max(r, s.height);
    }
    return { width: e, height: r };
  }
}
GraphicsBoxes.__name__ = "GraphicsBoxes";
const { min: min$3, max: max$5 } = Math;
class Sizeable {
  constructor(e = {}) {
    this.width = e.width != null ? e.width : 0, this.height = e.height != null ? e.height : 0;
  }
  bounded_to({ width: e, height: r }) {
    return new Sizeable({
      width: this.width == 1 / 0 && e != null ? e : this.width,
      height: this.height == 1 / 0 && r != null ? r : this.height
    });
  }
  expanded_to({ width: e, height: r }) {
    return new Sizeable({
      width: e != 1 / 0 ? max$5(this.width, e) : this.width,
      height: r != 1 / 0 ? max$5(this.height, r) : this.height
    });
  }
  expand_to({ width: e, height: r }) {
    this.width = max$5(this.width, e), this.height = max$5(this.height, r);
  }
  narrowed_to({ width: e, height: r }) {
    return new Sizeable({
      width: min$3(this.width, e),
      height: min$3(this.height, r)
    });
  }
  narrow_to({ width: e, height: r }) {
    this.width = min$3(this.width, e), this.height = min$3(this.height, r);
  }
  grow_by({ left: e, right: r, top: o, bottom: s }) {
    const l = this.width + e + r, c = this.height + o + s;
    return new Sizeable({ width: l, height: c });
  }
  shrink_by({ left: e, right: r, top: o, bottom: s }) {
    const l = max$5(this.width - e - r, 0), c = max$5(this.height - o - s, 0);
    return new Sizeable({ width: l, height: c });
  }
  map(e, r) {
    return new Sizeable({
      width: e(this.width),
      height: (r != null ? r : e)(this.height)
    });
  }
}
Sizeable.__name__ = "Sizeable";
const SizingPolicy = Enum("fixed", "fit", "min", "max"), { min: min$2, max: max$4, round: round$2 } = Math;
class Layoutable {
  constructor() {
    this.absolute = !1, this._bbox = new BBox$2(), this._inner_bbox = new BBox$2(), this._dirty = !1, this._handlers = [];
  }
  *[Symbol.iterator]() {
  }
  get bbox() {
    return this._bbox;
  }
  get inner_bbox() {
    return this._inner_bbox;
  }
  get sizing() {
    return this._sizing;
  }
  set visible(e) {
    this._sizing.visible = e, this._dirty = !0;
  }
  set_sizing(e) {
    var b, L, A, M, S;
    const r = (b = e.width_policy) != null ? b : "fit", o = e.width, s = e.min_width, l = e.max_width, c = (L = e.height_policy) != null ? L : "fit", u = e.height, d = e.min_height, f = e.max_height, T = e.aspect, Q = (A = e.margin) != null ? A : { top: 0, right: 0, bottom: 0, left: 0 }, m = e.visible !== !1, g = (M = e.halign) != null ? M : "start", v = (S = e.valign) != null ? S : "start";
    this._sizing = {
      width_policy: r,
      min_width: s,
      width: o,
      max_width: l,
      height_policy: c,
      min_height: d,
      height: u,
      max_height: f,
      aspect: T,
      margin: Q,
      visible: m,
      halign: g,
      valign: v,
      size: { width: o, height: u }
    }, this._init();
  }
  _init() {
  }
  _set_geometry(e, r) {
    this._bbox = e, this._inner_bbox = r;
  }
  set_geometry(e, r) {
    const { fixup_geometry: o } = this;
    o != null && ([e, r] = o(e, r)), this._set_geometry(e, r != null ? r : e);
    for (const s of this._handlers)
      s(this._bbox, this._inner_bbox);
  }
  on_resize(e) {
    this._handlers.push(e);
  }
  is_width_expanding() {
    return this.sizing.width_policy == "max";
  }
  is_height_expanding() {
    return this.sizing.height_policy == "max";
  }
  apply_aspect(e, { width: r, height: o }) {
    const { aspect: s } = this.sizing;
    if (s != null) {
      const { width_policy: l, height_policy: c } = this.sizing, u = (d, f) => {
        const T = { max: 4, fit: 3, min: 2, fixed: 1 };
        return T[d] > T[f];
      };
      if (l != "fixed" && c != "fixed")
        if (l == c) {
          const d = r, f = round$2(r / s), T = round$2(o * s), Q = o, m = Math.abs(e.width - d) + Math.abs(e.height - f), g = Math.abs(e.width - T) + Math.abs(e.height - Q);
          m <= g ? (r = d, o = f) : (r = T, o = Q);
        } else
          u(l, c) ? o = round$2(r / s) : r = round$2(o * s);
      else
        l == "fixed" ? o = round$2(r / s) : c == "fixed" && (r = round$2(o * s));
    }
    return { width: r, height: o };
  }
  measure(e) {
    if (!this.sizing.visible)
      return { width: 0, height: 0 };
    const r = (T) => this.sizing.width_policy == "fixed" && this.sizing.width != null ? this.sizing.width : T, o = (T) => this.sizing.height_policy == "fixed" && this.sizing.height != null ? this.sizing.height : T, s = new Sizeable(e).shrink_by(this.sizing.margin).map(r, o), l = this._measure(s), c = this.clip_size(l, s), u = r(c.width), d = o(c.height), f = this.apply_aspect(s, { width: u, height: d });
    return { ...l, ...f };
  }
  compute(e = {}) {
    const r = this.measure({
      width: e.width != null && this.is_width_expanding() ? e.width : 1 / 0,
      height: e.height != null && this.is_height_expanding() ? e.height : 1 / 0
    }), { width: o, height: s } = r, l = new BBox$2({ left: 0, top: 0, width: o, height: s });
    let c;
    if (r.inner != null) {
      const { left: u, top: d, right: f, bottom: T } = r.inner;
      c = new BBox$2({ left: u, top: d, right: o - f, bottom: s - T });
    }
    this.set_geometry(l, c);
  }
  get xview() {
    return this.bbox.xview;
  }
  get yview() {
    return this.bbox.yview;
  }
  clip_size(e, r) {
    function o(s, l, c, u) {
      return c == null ? c = 0 : isNumber(c) || (c = Math.round(c.percent * l)), u == null ? u = 1 / 0 : isNumber(u) || (u = Math.round(u.percent * l)), max$4(c, min$2(s, u));
    }
    return {
      width: o(e.width, r.width, this.sizing.min_width, this.sizing.max_width),
      height: o(e.height, r.height, this.sizing.min_height, this.sizing.max_height)
    };
  }
  has_size_changed() {
    const { _dirty: e } = this;
    return this._dirty = !1, e;
  }
}
Layoutable.__name__ = "Layoutable";
class LayoutItem extends Layoutable {
  _measure(e) {
    const { width_policy: r, height_policy: o } = this.sizing, s = (() => {
      const { width: c } = this.sizing;
      if (e.width == 1 / 0)
        return c != null ? c : 0;
      switch (r) {
        case "fixed":
          return c != null ? c : 0;
        case "min":
          return c != null ? min$2(e.width, c) : 0;
        case "fit":
          return c != null ? min$2(e.width, c) : e.width;
        case "max":
          return c != null ? max$4(e.width, c) : e.width;
      }
    })(), l = (() => {
      const { height: c } = this.sizing;
      if (e.height == 1 / 0)
        return c != null ? c : 0;
      switch (o) {
        case "fixed":
          return c != null ? c : 0;
        case "min":
          return c != null ? min$2(e.height, c) : 0;
        case "fit":
          return c != null ? min$2(e.height, c) : e.height;
        case "max":
          return c != null ? max$4(e.height, c) : e.height;
      }
    })();
    return { width: s, height: l };
  }
}
LayoutItem.__name__ = "LayoutItem";
class ContentLayoutable extends Layoutable {
  _measure(e) {
    const r = this._content_size(), o = e.bounded_to(this.sizing.size).bounded_to(r), s = (() => {
      switch (this.sizing.width_policy) {
        case "fixed":
          return this.sizing.width != null ? this.sizing.width : r.width;
        case "min":
          return r.width;
        case "fit":
          return o.width;
        case "max":
          return Math.max(r.width, o.width);
      }
    })(), l = (() => {
      switch (this.sizing.height_policy) {
        case "fixed":
          return this.sizing.height != null ? this.sizing.height : r.height;
        case "min":
          return r.height;
        case "fit":
          return o.height;
        case "max":
          return Math.max(r.height, o.height);
      }
    })();
    return { width: s, height: l };
  }
}
ContentLayoutable.__name__ = "ContentLayoutable";
const pi2 = Math.PI / 2, _angle_lookup = {
  above: {
    parallel: 0,
    normal: -pi2,
    horizontal: 0,
    vertical: -pi2
  },
  below: {
    parallel: 0,
    normal: pi2,
    horizontal: 0,
    vertical: pi2
  },
  left: {
    parallel: -pi2,
    normal: 0,
    horizontal: 0,
    vertical: -pi2
  },
  right: {
    parallel: pi2,
    normal: 0,
    horizontal: 0,
    vertical: pi2
  }
}, _vertical_align_lookup = {
  above: {
    parallel: "bottom",
    normal: "center",
    horizontal: "bottom",
    vertical: "center"
  },
  below: {
    parallel: "top",
    normal: "center",
    horizontal: "top",
    vertical: "center"
  },
  left: {
    parallel: "bottom",
    normal: "center",
    horizontal: "center",
    vertical: "bottom"
  },
  right: {
    parallel: "bottom",
    normal: "center",
    horizontal: "center",
    vertical: "bottom"
  }
}, _align_lookup = {
  above: {
    parallel: "center",
    normal: "left",
    horizontal: "center",
    vertical: "left"
  },
  below: {
    parallel: "center",
    normal: "left",
    horizontal: "center",
    vertical: "left"
  },
  left: {
    parallel: "center",
    normal: "right",
    horizontal: "right",
    vertical: "center"
  },
  right: {
    parallel: "center",
    normal: "left",
    horizontal: "left",
    vertical: "center"
  }
}, _align_lookup_negative = {
  above: "right",
  below: "left",
  left: "right",
  right: "left"
}, _align_lookup_positive = {
  above: "left",
  below: "right",
  left: "right",
  right: "left"
};
class Panel$1 {
  constructor(e) {
    this.side = e;
  }
  get dimension() {
    return this.side == "above" || this.side == "below" ? 0 : 1;
  }
  get normals() {
    switch (this.side) {
      case "above":
        return [0, -1];
      case "below":
        return [0, 1];
      case "left":
        return [-1, 0];
      case "right":
        return [1, 0];
    }
  }
  get orientation() {
    return this.is_horizontal ? "horizontal" : "vertical";
  }
  get is_horizontal() {
    return this.dimension == 0;
  }
  get is_vertical() {
    return this.dimension == 1;
  }
  get_label_text_heuristics(e) {
    const { side: r } = this;
    return isString(e) ? {
      vertical_align: _vertical_align_lookup[r][e],
      align: _align_lookup[r][e]
    } : {
      vertical_align: "center",
      align: (e < 0 ? _align_lookup_negative : _align_lookup_positive)[r]
    };
  }
  get_label_angle_heuristic(e) {
    return isString(e) ? _angle_lookup[this.side][e] : -e;
  }
}
Panel$1.__name__ = "Panel";
class SideLayout extends ContentLayoutable {
  constructor(e, r, o = !1) {
    super(), this.panel = e, this.get_size = r, this.rotate = o, this.panel.is_horizontal ? this.set_sizing({ width_policy: "max", height_policy: "fixed" }) : this.set_sizing({ width_policy: "fixed", height_policy: "max" });
  }
  _content_size() {
    const { width: e, height: r } = this.get_size();
    return !this.rotate || this.panel.is_horizontal ? new Sizeable({ width: e, height: r }) : new Sizeable({ width: r, height: e });
  }
  has_size_changed() {
    const { width: e, height: r } = this._content_size();
    return this.panel.is_horizontal ? this.bbox.height != r : this.bbox.width != e;
  }
}
SideLayout.__name__ = "SideLayout";
var _a$3y;
class TextAnnotationView extends AnnotationView {
  update_layout() {
    const { panel: e } = this;
    e != null ? this.layout = new SideLayout(e, () => this.get_size(), !0) : this.layout = void 0;
  }
  initialize() {
    super.initialize(), this.model.render_mode == "css" && (this.el = div(), this.plot_view.canvas_view.add_overlay(this.el));
  }
  remove() {
    this.el != null && remove(this.el), super.remove();
  }
  connect_signals() {
    super.connect_signals(), this.model.render_mode == "css" ? this.connect(this.model.change, () => this.render()) : this.connect(this.model.change, () => this.request_render());
  }
  render() {
    !this.model.visible && this.model.render_mode == "css" && undisplay(this.el), super.render();
  }
  _canvas_text(e, r, o, s, l) {
    const c = new TextBox({ text: r });
    c.angle = l, c.position = { sx: o, sy: s }, c.visuals = this.visuals.text.values();
    const { background_fill: u, border_line: d } = this.visuals;
    if (u.doit || d.doit) {
      const { p0: f, p1: T, p2: Q, p3: m } = c.rect();
      e.beginPath(), e.moveTo(f.x, f.y), e.lineTo(T.x, T.y), e.lineTo(Q.x, Q.y), e.lineTo(m.x, m.y), e.closePath(), this.visuals.background_fill.apply(e), this.visuals.border_line.apply(e);
    }
    this.visuals.text.doit && c.paint(e);
  }
  _css_text(e, r, o, s, l) {
    const { el: c } = this;
    assert(c != null), undisplay(c), c.textContent = r, this.visuals.text.set_value(e), c.style.position = "absolute", c.style.left = `${o}px`, c.style.top = `${s}px`, c.style.color = e.fillStyle, c.style.font = e.font, c.style.lineHeight = "normal", c.style.whiteSpace = "pre";
    const [u, d] = (() => {
      switch (this.visuals.text.text_align.get_value()) {
        case "left":
          return ["left", "0%"];
        case "center":
          return ["center", "-50%"];
        case "right":
          return ["right", "-100%"];
      }
    })(), [f, T] = (() => {
      switch (this.visuals.text.text_baseline.get_value()) {
        case "top":
          return ["top", "0%"];
        case "middle":
          return ["center", "-50%"];
        case "bottom":
          return ["bottom", "-100%"];
        default:
          return ["center", "-50%"];
      }
    })();
    let Q = `translate(${d}, ${T})`;
    l && (Q += `rotate(${l}rad)`), c.style.transformOrigin = `${u} ${f}`, c.style.transform = Q, this.layout == null, this.visuals.background_fill.doit && (this.visuals.background_fill.set_value(e), c.style.backgroundColor = e.fillStyle), this.visuals.border_line.doit && (this.visuals.border_line.set_value(e), c.style.borderStyle = e.lineDash.length < 2 ? "solid" : "dashed", c.style.borderWidth = `${e.lineWidth}px`, c.style.borderColor = e.strokeStyle), display(c);
  }
}
TextAnnotationView.__name__ = "TextAnnotationView";
class TextAnnotation extends Annotation {
  constructor(e) {
    super(e);
  }
}
_a$3y = TextAnnotation;
TextAnnotation.__name__ = "TextAnnotation";
_a$3y.define(() => ({
  render_mode: [RenderMode, "canvas"]
}));
var _a$3x;
class TitleView extends TextAnnotationView {
  _get_location() {
    const e = this.model.offset, r = this.model.standoff / 2;
    let o, s;
    const { bbox: l } = this.layout;
    switch (this.panel.side) {
      case "above":
      case "below": {
        switch (this.model.vertical_align) {
          case "top":
            s = l.top + r;
            break;
          case "middle":
            s = l.vcenter;
            break;
          case "bottom":
            s = l.bottom - r;
            break;
        }
        switch (this.model.align) {
          case "left":
            o = l.left + e;
            break;
          case "center":
            o = l.hcenter;
            break;
          case "right":
            o = l.right - e;
            break;
        }
        break;
      }
      case "left": {
        switch (this.model.vertical_align) {
          case "top":
            o = l.left + r;
            break;
          case "middle":
            o = l.hcenter;
            break;
          case "bottom":
            o = l.right - r;
            break;
        }
        switch (this.model.align) {
          case "left":
            s = l.bottom - e;
            break;
          case "center":
            s = l.vcenter;
            break;
          case "right":
            s = l.top + e;
            break;
        }
        break;
      }
      case "right": {
        switch (this.model.vertical_align) {
          case "top":
            o = l.right - r;
            break;
          case "middle":
            o = l.hcenter;
            break;
          case "bottom":
            o = l.left + r;
            break;
        }
        switch (this.model.align) {
          case "left":
            s = l.top + e;
            break;
          case "center":
            s = l.vcenter;
            break;
          case "right":
            s = l.bottom - e;
            break;
        }
        break;
      }
    }
    return [o, s];
  }
  _render() {
    const { text: e } = this.model;
    if (e == null || e.length == 0)
      return;
    this.model.text_baseline = this.model.vertical_align, this.model.text_align = this.model.align;
    const [r, o] = this._get_location(), s = this.panel.get_label_angle_heuristic("parallel");
    (this.model.render_mode == "canvas" ? this._canvas_text.bind(this) : this._css_text.bind(this))(this.layer.ctx, e, r, o, s);
  }
  _get_size() {
    const { text: e } = this.model, r = new TextBox({ text: e });
    r.visuals = this.visuals.text.values();
    const { width: o, height: s } = r.size();
    return { width: o, height: s == 0 ? 0 : 2 + s + this.model.standoff };
  }
}
TitleView.__name__ = "TitleView";
class Title extends TextAnnotation {
  constructor(e) {
    super(e);
  }
}
_a$3x = Title;
Title.__name__ = "Title";
_a$3x.prototype.default_view = TitleView, _a$3x.mixins([
  Text$3,
  ["border_", Line$2],
  ["background_", Fill$1]
]), _a$3x.define(({ Number: t, String: e }) => ({
  text: [e, ""],
  vertical_align: [VerticalAlign, "bottom"],
  align: [TextAlign, "left"],
  offset: [t, 0],
  standoff: [t, 10]
})), _a$3x.prototype._props.text_align.options.internal = !0, _a$3x.prototype._props.text_baseline.options.internal = !0, _a$3x.override({
  text_font_size: "13px",
  text_font_style: "bold",
  text_line_height: 1,
  background_fill_color: null,
  border_line_color: null
});
class CartesianFrame {
  constructor(e, r, o, s, l = {}, c = {}, u = {}, d = {}) {
    this.in_x_scale = e, this.in_y_scale = r, this.x_range = o, this.y_range = s, this.extra_x_ranges = l, this.extra_y_ranges = c, this.extra_x_scales = u, this.extra_y_scales = d, this._bbox = new BBox$2(), assert(e.source_range == null && e.target_range == null), assert(r.source_range == null && r.target_range == null), this._configure_scales();
  }
  get bbox() {
    return this._bbox;
  }
  _get_ranges(e, r) {
    return new Map(entries({ ...r, default: e }));
  }
  _get_scales(e, r, o, s) {
    var u;
    const l = new Map(entries({ ...r, default: e })), c = /* @__PURE__ */ new Map();
    for (const [d, f] of o) {
      const T = f instanceof FactorRange, Q = e instanceof CategoricalScale;
      if (T != Q)
        throw new Error(`Range ${f.type} is incompatible is Scale ${e.type}`);
      e instanceof LogScale && f instanceof DataRange1d && (f.scale_hint = "log");
      const m = ((u = l.get(d)) != null ? u : e).clone();
      m.setv({ source_range: f, target_range: s }), c.set(d, m);
    }
    return c;
  }
  _configure_frame_ranges() {
    const { bbox: e } = this;
    this._x_target = new Range1d({ start: e.left, end: e.right }), this._y_target = new Range1d({ start: e.bottom, end: e.top });
  }
  _configure_scales() {
    this._configure_frame_ranges(), this._x_ranges = this._get_ranges(this.x_range, this.extra_x_ranges), this._y_ranges = this._get_ranges(this.y_range, this.extra_y_ranges), this._x_scales = this._get_scales(this.in_x_scale, this.extra_x_scales, this._x_ranges, this._x_target), this._y_scales = this._get_scales(this.in_y_scale, this.extra_y_scales, this._y_ranges, this._y_target);
  }
  _update_scales() {
    this._configure_frame_ranges();
    for (const [, e] of this._x_scales)
      e.target_range = this._x_target;
    for (const [, e] of this._y_scales)
      e.target_range = this._y_target;
  }
  set_geometry(e) {
    this._bbox = e, this._update_scales();
  }
  get x_target() {
    return this._x_target;
  }
  get y_target() {
    return this._y_target;
  }
  get x_ranges() {
    return this._x_ranges;
  }
  get y_ranges() {
    return this._y_ranges;
  }
  get x_scales() {
    return this._x_scales;
  }
  get y_scales() {
    return this._y_scales;
  }
  get x_scale() {
    return this._x_scales.get("default");
  }
  get y_scale() {
    return this._y_scales.get("default");
  }
  get xscales() {
    return to_object(this.x_scales);
  }
  get yscales() {
    return to_object(this.y_scales);
  }
}
CartesianFrame.__name__ = "CartesianFrame";
var _a$3w;
class GuideRendererView extends RendererView {
}
GuideRendererView.__name__ = "GuideRendererView";
class GuideRenderer extends Renderer {
  constructor(e) {
    super(e);
  }
}
_a$3w = GuideRenderer;
GuideRenderer.__name__ = "GuideRenderer";
_a$3w.override({
  level: "guide"
});
class Ticker extends Model {
  constructor(e) {
    super(e);
  }
}
Ticker.__name__ = "Ticker";
class TickFormatter extends Model {
  constructor(e) {
    super(e);
  }
  format_graphics(e, r) {
    return this.doFormat(e, r).map((o) => new TextBox({ text: o }));
  }
  compute(e, r) {
    return this.doFormat([e], r != null ? r : { loc: 0 })[0];
  }
  v_compute(e, r) {
    return this.doFormat(e, r != null ? r : { loc: 0 });
  }
}
TickFormatter.__name__ = "TickFormatter";
var _a$3v, _b$8;
class LabelingPolicy extends Model {
  constructor(e) {
    super(e);
  }
}
LabelingPolicy.__name__ = "LabelingPolicy";
class AllLabels extends LabelingPolicy {
  constructor(e) {
    super(e);
  }
  filter(e, r, o) {
    return e;
  }
}
AllLabels.__name__ = "AllLabels";
class NoOverlap extends LabelingPolicy {
  constructor(e) {
    super(e);
  }
  filter(e, r, o) {
    const { min_distance: s } = this;
    let l = null;
    for (const c of e)
      l != null && o(l, c) < s ? e.unset(c) : l = c;
    return e;
  }
}
_a$3v = NoOverlap;
NoOverlap.__name__ = "NoOverlap";
_a$3v.define(({ Number: t }) => ({
  min_distance: [t, 5]
}));
class CustomLabelingPolicy extends LabelingPolicy {
  constructor(e) {
    super(e);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  get func() {
    const e = use_strict(this.code);
    return new GeneratorFunction("indices", "bboxes", "distance", ...this.names, e);
  }
  filter(e, r, o) {
    const s = /* @__PURE__ */ Object.create(null), l = this.func.call(s, e, r, o, ...this.values);
    let c = l.next();
    if (c.done && c.value !== void 0) {
      const { value: u } = c;
      return u instanceof BitSet ? u : u === void 0 ? e : isIterable(u) ? BitSet.from_indices(e.size, u) : BitSet.all_unset(e.size);
    } else {
      const u = [];
      do
        u.push(c.value), c = l.next();
      while (!c.done);
      return BitSet.from_indices(e.size, u);
    }
  }
}
_b$8 = CustomLabelingPolicy;
CustomLabelingPolicy.__name__ = "CustomLabelingPolicy";
_b$8.define(({ Unknown: t, String: e, Dict: r }) => ({
  args: [r(t), {}],
  code: [e, ""]
}));
var _a$3u;
class BaseTextView extends View {
}
BaseTextView.__name__ = "BaseTextView";
class BaseText extends Model {
  constructor(e) {
    super(e);
  }
}
_a$3u = BaseText;
BaseText.__name__ = "BaseText";
_a$3u.define(({ String: t }) => ({
  text: [t]
}));
async function load_image(t, e) {
  return new ImageLoader(t, e).promise;
}
class ImageLoader {
  constructor(e, r = {}) {
    this._image = new Image(), this._finished = !1;
    const { attempts: o = 1, timeout: s = 1 } = r;
    this.promise = new Promise((l, c) => {
      this._image.crossOrigin = "anonymous";
      let u = 0;
      this._image.onerror = () => {
        if (++u == o) {
          const d = `unable to load ${e} image after ${o} attempts`;
          if (logger.warn(d), this._image.crossOrigin != null)
            logger.warn(`attempting to load ${e} without a cross origin policy`), this._image.crossOrigin = null, u = 0;
          else {
            r.failed != null && r.failed();
            return;
          }
        }
        setTimeout(() => this._image.src = e, s);
      }, this._image.onload = () => {
        this._finished = !0, r.loaded != null && r.loaded(this._image), l(this._image);
      }, this._image.src = e;
    });
  }
  get finished() {
    return this._finished;
  }
  get image() {
    if (this._finished)
      return this._image;
    throw new Error("not loaded yet");
  }
}
ImageLoader.__name__ = "ImageLoader";
function is_ModuleError(t) {
  return t instanceof Error && "code" in t;
}
async function load_module(t) {
  try {
    return await t;
  } catch (e) {
    if (is_ModuleError(e) && e.code === "MODULE_NOT_FOUND")
      return null;
    throw e;
  }
}
class MathJaxProvider {
  constructor() {
    this.ready = new Signal0(this, "ready"), this.status = "not_started";
  }
}
MathJaxProvider.__name__ = "MathJaxProvider";
class NoProvider extends MathJaxProvider {
  get MathJax() {
    return null;
  }
  async fetch() {
    this.status = "failed";
  }
}
NoProvider.__name__ = "NoProvider";
class CDNProvider extends MathJaxProvider {
  get MathJax() {
    return typeof MathJax < "u" ? MathJax : null;
  }
  async fetch() {
    const e = document.createElement("script");
    e.src = "https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js", e.onload = () => {
      this.status = "loaded", this.ready.emit();
    }, e.onerror = () => {
      this.status = "failed";
    }, this.status = "loading", document.head.appendChild(e);
  }
}
CDNProvider.__name__ = "CDNProvider";
class BundleProvider extends MathJaxProvider {
  get MathJax() {
    return this._mathjax;
  }
  async fetch() {
    this.status = "loading";
    try {
      const e = await load_module(Promise.resolve().then(() => index));
      this._mathjax = e, this.status = "loaded", this.ready.emit();
    } catch {
      this.status = "failed";
    }
  }
}
BundleProvider.__name__ = "BundleProvider";
const default_provider = new BundleProvider();
var _a$3t, _b$7, _c$4;
class MathTextView extends BaseTextView {
  constructor() {
    super(...arguments), this._position = { sx: 0, sy: 0 }, this.align = "left", this._x_anchor = "left", this._y_anchor = "center", this._base_font_size = 13, this.font_size_scale = 1, this.svg_image = null;
  }
  graphics() {
    return this;
  }
  infer_text_height() {
    return "ascent_descent";
  }
  set base_font_size(e) {
    e != null && (this._base_font_size = e);
  }
  get base_font_size() {
    return this._base_font_size;
  }
  get has_image_loaded() {
    return this.svg_image != null;
  }
  _rect() {
    const { width: e, height: r } = this._size(), { x: o, y: s } = this._computed_position();
    return new BBox$2({ x: o, y: s, width: e, height: r }).rect;
  }
  set position(e) {
    this._position = e;
  }
  get position() {
    return this._position;
  }
  get text() {
    return this.model.text;
  }
  get provider() {
    return default_provider;
  }
  async lazy_initialize() {
    await super.lazy_initialize(), this.provider.status == "not_started" && await this.provider.fetch(), (this.provider.status == "not_started" || this.provider.status == "loading") && this.provider.ready.connect(() => this.load_image()), this.provider.status == "loaded" && await this.load_image();
  }
  connect_signals() {
    super.connect_signals(), this.on_change(this.model.properties.text, () => this.load_image());
  }
  set visuals(e) {
    const r = e.color, o = e.alpha, s = e.font_style;
    let l = e.font_size;
    const c = e.font, { font_size_scale: u, _base_font_size: d } = this, f = parse_css_font_size(l);
    if (f != null) {
      let { value: Q, unit: m } = f;
      Q *= u, m == "em" && d && (Q *= d, m = "px"), l = `${Q}${m}`;
    }
    const T = `${s} ${l} ${c}`;
    this.font = T, this.color = color2css(r, o);
  }
  _computed_position() {
    const { width: e, height: r } = this._size(), { sx: o, sy: s, x_anchor: l = this._x_anchor, y_anchor: c = this._y_anchor } = this.position, u = o - (() => {
      if (isNumber(l))
        return l * e;
      switch (l) {
        case "left":
          return 0;
        case "center":
          return 0.5 * e;
        case "right":
          return e;
      }
    })(), d = s - (() => {
      if (isNumber(c))
        return c * r;
      switch (c) {
        case "top":
          return 0;
        case "center":
          return 0.5 * r;
        case "bottom":
          return r;
        case "baseline":
          return 0.5 * r;
      }
    })();
    return { x: u, y: d };
  }
  size() {
    const { width: e, height: r } = this._size(), { angle: o } = this;
    if (o) {
      const s = Math.cos(Math.abs(o)), l = Math.sin(Math.abs(o));
      return {
        width: Math.abs(e * s + r * l),
        height: Math.abs(e * l + r * s)
      };
    } else
      return { width: e, height: r };
  }
  get_text_dimensions() {
    return {
      width: text_width(this.model.text, this.font),
      height: font_metrics(this.font).height
    };
  }
  get_image_dimensions() {
    var o, s, l, c;
    const e = parseFloat((s = (o = this.svg_element.getAttribute("height")) == null ? void 0 : o.replace(/([A-z])/g, "")) != null ? s : "0"), r = parseFloat((c = (l = this.svg_element.getAttribute("width")) == null ? void 0 : l.replace(/([A-z])/g, "")) != null ? c : "0");
    return {
      width: font_metrics(this.font).x_height * r,
      height: font_metrics(this.font).x_height * e
    };
  }
  _size() {
    return this.has_image_loaded ? this.get_image_dimensions() : this.get_text_dimensions();
  }
  bbox() {
    const { p0: e, p1: r, p2: o, p3: s } = this.rect(), l = Math.min(e.x, r.x, o.x, s.x), c = Math.min(e.y, r.y, o.y, s.y), u = Math.max(e.x, r.x, o.x, s.x), d = Math.max(e.y, r.y, o.y, s.y);
    return new BBox$2({ left: l, right: u, top: c, bottom: d });
  }
  rect() {
    const e = this._rect(), { angle: r } = this;
    if (r) {
      const { sx: o, sy: s } = this.position, l = new AffineTransform();
      return l.translate(o, s), l.rotate(r), l.translate(-o, -s), l.apply_rect(e);
    } else
      return e;
  }
  paint_rect(e) {
    const { p0: r, p1: o, p2: s, p3: l } = this.rect();
    e.save(), e.strokeStyle = "red", e.lineWidth = 1, e.beginPath();
    const { round: c } = Math;
    e.moveTo(c(r.x), c(r.y)), e.lineTo(c(o.x), c(o.y)), e.lineTo(c(s.x), c(s.y)), e.lineTo(c(l.x), c(l.y)), e.closePath(), e.stroke(), e.restore();
  }
  paint_bbox(e) {
    const { x: r, y: o, width: s, height: l } = this.bbox();
    e.save(), e.strokeStyle = "blue", e.lineWidth = 1, e.beginPath();
    const { round: c } = Math;
    e.moveTo(c(r), c(o)), e.lineTo(c(r), c(o + l)), e.lineTo(c(r + s), c(o + l)), e.lineTo(c(r + s), c(o)), e.closePath(), e.stroke(), e.restore();
  }
  async load_image() {
    if (this.provider.MathJax == null)
      return null;
    const e = this._process_text(this.model.text);
    if (e == null)
      return this._has_finished = !0, null;
    const r = e.children[0];
    this.svg_element = r, r.setAttribute("font", this.font), r.setAttribute("stroke", this.color);
    const o = r.outerHTML, s = new Blob([o], { type: "image/svg+xml" }), l = URL.createObjectURL(s);
    try {
      this.svg_image = await load_image(l);
    } finally {
      URL.revokeObjectURL(l);
    }
    return this.parent.request_layout(), this.svg_image;
  }
  paint(e) {
    e.save();
    const { sx: r, sy: o } = this.position;
    this.angle && (e.translate(r, o), e.rotate(this.angle), e.translate(-r, -o));
    const { x: s, y: l } = this._computed_position();
    if (this.svg_image != null) {
      const { width: c, height: u } = this.get_image_dimensions();
      e.drawImage(this.svg_image, s, l, c, u);
    } else
      e.fillStyle = this.color, e.font = this.font, e.textAlign = "left", e.textBaseline = "alphabetic", e.fillText(this.model.text, s, l + font_metrics(this.font).ascent);
    e.restore(), !this._has_finished && (this.provider.status == "failed" || this.has_image_loaded) && (this._has_finished = !0, this.parent.notify_finished_after_paint());
  }
}
MathTextView.__name__ = "MathTextView";
class MathText extends BaseText {
  constructor(e) {
    super(e);
  }
}
MathText.__name__ = "MathText";
class AsciiView extends MathTextView {
  _process_text(e) {
  }
}
AsciiView.__name__ = "AsciiView";
class Ascii extends MathText {
  constructor(e) {
    super(e);
  }
}
_a$3t = Ascii;
Ascii.__name__ = "Ascii";
_a$3t.prototype.default_view = AsciiView;
class MathMLView extends MathTextView {
  _process_text(e) {
    var r;
    return (r = this.provider.MathJax) == null ? void 0 : r.mathml2svg(e.trim());
  }
}
MathMLView.__name__ = "MathMLView";
class MathML$1 extends MathText {
  constructor(e) {
    super(e);
  }
}
_b$7 = MathML$1;
MathML$1.__name__ = "MathML";
_b$7.prototype.default_view = MathMLView;
class TeXView extends MathTextView {
  _process_text(e) {
    var r;
    return (r = this.provider.MathJax) == null ? void 0 : r.tex2svg(e, void 0, this.model.macros);
  }
}
TeXView.__name__ = "TeXView";
class TeX$1 extends MathText {
  constructor(e) {
    super(e);
  }
}
_c$4 = TeX$1;
TeX$1.__name__ = "TeX";
_c$4.prototype.default_view = TeXView, _c$4.define(({ Boolean: t, Number: e, String: r, Dict: o, Tuple: s, Or: l }) => ({
  macros: [o(l(r, s(r, e))), {}],
  inline: [t, !1]
}));
var _a$3s;
class PlainTextView extends BaseTextView {
  initialize() {
    super.initialize(), this._has_finished = !0;
  }
  graphics() {
    return new TextBox({ text: this.model.text });
  }
}
PlainTextView.__name__ = "PlainTextView";
class PlainText extends BaseText {
  constructor(e) {
    super(e);
  }
}
_a$3s = PlainText;
PlainText.__name__ = "PlainText";
_a$3s.prototype.default_view = PlainTextView;
const delimiters$1 = [
  { start: "$$", end: "$$", inline: !1 },
  { start: "\\[", end: "\\]", inline: !1 },
  { start: "\\(", end: "\\)", inline: !0 }
];
function parse_delimited_string(t) {
  for (const e of delimiters$1) {
    const r = t.indexOf(e.start), o = r + e.start.length;
    if (r == 0) {
      const s = t.indexOf(e.end, o), l = s;
      if (s == t.length - e.end.length)
        return new TeX$1({ text: t.slice(o, l), inline: e.inline });
      break;
    }
  }
  return new PlainText({ text: t });
}
var _a$3r;
const { abs: abs$3 } = Math;
class AxisView extends GuideRendererView {
  constructor() {
    super(...arguments), this._axis_label_view = null, this._major_label_views = /* @__PURE__ */ new Map();
  }
  async lazy_initialize() {
    await super.lazy_initialize(), await this._init_axis_label(), await this._init_major_labels();
  }
  async _init_axis_label() {
    const { axis_label: e } = this.model;
    if (e != null) {
      const r = isString(e) ? parse_delimited_string(e) : e;
      this._axis_label_view = await build_view(r, { parent: this });
    } else
      this._axis_label_view = null;
  }
  async _init_major_labels() {
    const { major_label_overrides: e } = this.model;
    for (const [r, o] of entries(e)) {
      const s = isString(o) ? parse_delimited_string(o) : o;
      this._major_label_views.set(r, await build_view(s, { parent: this }));
    }
  }
  update_layout() {
    this.layout = new SideLayout(this.panel, () => this.get_size(), !0), this.layout.on_resize(() => this._coordinates = void 0);
  }
  get_size() {
    const { visible: e, fixed_location: r } = this.model;
    if (e && r == null && this.is_renderable) {
      const { extents: o } = this;
      return { width: 0, height: Math.round(o.tick + o.tick_label + o.axis_label) };
    } else
      return { width: 0, height: 0 };
  }
  get is_renderable() {
    const [e, r] = this.ranges;
    return e.is_valid && r.is_valid;
  }
  _render() {
    var s;
    if (!this.is_renderable)
      return;
    const { tick_coords: e, extents: r } = this, o = this.layer.ctx;
    o.save(), this._draw_rule(o, r), this._draw_major_ticks(o, r, e), this._draw_minor_ticks(o, r, e), this._draw_major_labels(o, r, e), this._draw_axis_label(o, r, e), (s = this._paint) == null || s.call(this, o, r, e), o.restore();
  }
  connect_signals() {
    super.connect_signals();
    const { axis_label: e, major_label_overrides: r } = this.model.properties;
    this.on_change(e, async () => {
      var o;
      (o = this._axis_label_view) == null || o.remove(), await this._init_axis_label();
    }), this.on_change(r, async () => {
      for (const o of this._major_label_views.values())
        o.remove();
      await this._init_major_labels();
    }), this.connect(this.model.change, () => this.plot_view.request_layout());
  }
  get needs_clip() {
    return this.model.fixed_location != null;
  }
  _draw_rule(e, r) {
    if (!this.visuals.axis_line.doit)
      return;
    const [o, s] = this.rule_coords, [l, c] = this.coordinates.map_to_screen(o, s), [u, d] = this.normals, [f, T] = this.offsets;
    this.visuals.axis_line.set_value(e), e.beginPath();
    for (let Q = 0; Q < l.length; Q++) {
      const m = Math.round(l[Q] + u * f), g = Math.round(c[Q] + d * T);
      e.lineTo(m, g);
    }
    e.stroke();
  }
  _draw_major_ticks(e, r, o) {
    const s = this.model.major_tick_in, l = this.model.major_tick_out, c = this.visuals.major_tick_line;
    this._draw_ticks(e, o.major, s, l, c);
  }
  _draw_minor_ticks(e, r, o) {
    const s = this.model.minor_tick_in, l = this.model.minor_tick_out, c = this.visuals.minor_tick_line;
    this._draw_ticks(e, o.minor, s, l, c);
  }
  _draw_major_labels(e, r, o) {
    const s = o.major, l = this.compute_labels(s[this.dimension]), c = this.model.major_label_orientation, u = r.tick + this.model.major_label_standoff, d = this.visuals.major_label_text;
    this._draw_oriented_labels(e, l, s, c, this.panel.side, u, d);
  }
  _axis_label_extent() {
    if (this._axis_label_view == null)
      return 0;
    const e = this._axis_label_view.graphics(), r = 3;
    e.visuals = this.visuals.axis_label_text.values(), e.angle = this.panel.get_label_angle_heuristic("parallel"), isNumber(this.plot_view.base_font_size) && (e.base_font_size = this.plot_view.base_font_size);
    const o = e.size(), s = this.dimension == 0 ? o.height : o.width, l = this.model.axis_label_standoff;
    return s > 0 ? l + s + r : 0;
  }
  _draw_axis_label(e, r, o) {
    if (this._axis_label_view == null || this.model.fixed_location != null)
      return;
    const [s, l] = (() => {
      const { bbox: g } = this.layout;
      switch (this.panel.side) {
        case "above":
          return [g.hcenter, g.bottom];
        case "below":
          return [g.hcenter, g.top];
        case "left":
          return [g.right, g.vcenter];
        case "right":
          return [g.left, g.vcenter];
      }
    })(), [c, u] = this.normals, d = r.tick + r.tick_label + this.model.axis_label_standoff, { vertical_align: f, align: T } = this.panel.get_label_text_heuristics("parallel"), Q = {
      sx: s + c * d,
      sy: l + u * d,
      x_anchor: T,
      y_anchor: f
    }, m = this._axis_label_view.graphics();
    m.visuals = this.visuals.axis_label_text.values(), m.angle = this.panel.get_label_angle_heuristic("parallel"), this.plot_view.base_font_size && (m.base_font_size = this.plot_view.base_font_size), m.position = Q, m.align = T, m.paint(e);
  }
  _draw_ticks(e, r, o, s, l) {
    if (!l.doit)
      return;
    const [c, u] = r, [d, f] = this.coordinates.map_to_screen(c, u), [T, Q] = this.normals, [m, g] = this.offsets, [v, b] = [T * (m - o), Q * (g - o)], [L, A] = [T * (m + s), Q * (g + s)];
    l.set_value(e), e.beginPath();
    for (let M = 0; M < d.length; M++) {
      const S = Math.round(d[M] + L), E = Math.round(f[M] + A), k = Math.round(d[M] + v), w = Math.round(f[M] + b);
      e.moveTo(S, E), e.lineTo(k, w);
    }
    e.stroke();
  }
  _draw_oriented_labels(e, r, o, s, l, c, u) {
    if (!u.doit || r.length == 0)
      return;
    const [d, f] = o, [T, Q] = this.coordinates.map_to_screen(d, f), [m, g] = this.offsets, [v, b] = this.normals, L = v * (m + c), A = b * (g + c), { vertical_align: M, align: S } = this.panel.get_label_text_heuristics(s), E = this.panel.get_label_angle_heuristic(s);
    r.visuals = u.values(), r.angle = E, r.base_font_size = this.plot_view.base_font_size;
    for (let z = 0; z < r.length; z++) {
      const q = r.items[z];
      q.position = {
        sx: T[z] + L,
        sy: Q[z] + A,
        x_anchor: S,
        y_anchor: M
      }, q instanceof TextBox && (q.align = S);
    }
    const k = r.length, w = BitSet.all_set(k), { items: O } = r, D = O.map((z) => z.bbox()), R = (() => {
      const [z] = this.ranges;
      return z.is_reversed ? this.dimension == 0 ? (q, I) => D[q].left - D[I].right : (q, I) => D[I].top - D[q].bottom : this.dimension == 0 ? (q, I) => D[I].left - D[q].right : (q, I) => D[q].top - D[I].bottom;
    })(), { major_label_policy: B } = this.model, F = B.filter(w, D, R), j = [...F.ones()];
    if (j.length != 0) {
      const z = this.parent.canvas_view.bbox, q = (ce) => {
        const Ae = D[ce];
        if (Ae.left < 0) {
          const ae = -Ae.left, { position: pe } = O[ce];
          O[ce].position = { ...pe, sx: pe.sx + ae };
        } else if (Ae.right > z.width) {
          const ae = Ae.right - z.width, { position: pe } = O[ce];
          O[ce].position = { ...pe, sx: pe.sx - ae };
        }
      }, I = (ce) => {
        const Ae = D[ce];
        if (Ae.top < 0) {
          const ae = -Ae.top, { position: pe } = O[ce];
          O[ce].position = { ...pe, sy: pe.sy + ae };
        } else if (Ae.bottom > z.height) {
          const ae = Ae.bottom - z.height, { position: pe } = O[ce];
          O[ce].position = { ...pe, sy: pe.sy - ae };
        }
      }, U = j[0], H = j[j.length - 1];
      this.dimension == 0 ? (q(U), q(H)) : (I(U), I(H));
    }
    for (const z of F)
      O[z].paint(e);
  }
  _tick_extent() {
    return this.model.major_tick_out;
  }
  _tick_label_extents() {
    const e = this.tick_coords.major, r = this.compute_labels(e[this.dimension]), o = this.model.major_label_orientation, s = this.model.major_label_standoff, l = this.visuals.major_label_text;
    return [this._oriented_labels_extent(r, o, s, l)];
  }
  get extents() {
    const e = this._tick_label_extents();
    return {
      tick: this._tick_extent(),
      tick_labels: e,
      tick_label: sum$2(e),
      axis_label: this._axis_label_extent()
    };
  }
  _oriented_labels_extent(e, r, o, s) {
    if (e.length == 0 || !s.doit)
      return 0;
    const l = this.panel.get_label_angle_heuristic(r);
    e.visuals = s.values(), e.angle = l, e.base_font_size = this.plot_view.base_font_size;
    const c = e.max_size(), u = this.dimension == 0 ? c.height : c.width, d = 3;
    return u > 0 ? o + u + d : 0;
  }
  get normals() {
    return this.panel.normals;
  }
  get dimension() {
    return this.panel.dimension;
  }
  compute_labels(e) {
    const r = this.model.formatter.format_graphics(e, this), { _major_label_views: o } = this, s = /* @__PURE__ */ new Set();
    for (let l = 0; l < e.length; l++) {
      const c = o.get(e[l].toString());
      c != null && (s.add(c), r[l] = c.graphics());
    }
    for (const l of this._major_label_views.values())
      s.has(l) || (l._has_finished = !0);
    return new GraphicsBoxes(r);
  }
  get offsets() {
    if (this.model.fixed_location != null)
      return [0, 0];
    const { frame: e } = this.plot_view;
    let [r, o] = [0, 0];
    switch (this.panel.side) {
      case "below":
        o = abs$3(this.layout.bbox.top - e.bbox.bottom);
        break;
      case "above":
        o = abs$3(this.layout.bbox.bottom - e.bbox.top);
        break;
      case "right":
        r = abs$3(this.layout.bbox.left - e.bbox.right);
        break;
      case "left":
        r = abs$3(this.layout.bbox.right - e.bbox.left);
        break;
    }
    return [r, o];
  }
  get ranges() {
    const e = this.dimension, r = (e + 1) % 2, { ranges: o } = this.coordinates;
    return [o[e], o[r]];
  }
  get computed_bounds() {
    const [e] = this.ranges, r = this.model.bounds, o = [e.min, e.max];
    if (r == "auto")
      return [e.min, e.max];
    {
      let s, l;
      const [c, u] = r, [d, f] = o, { min: T, max: Q } = Math;
      return abs$3(c - u) > abs$3(d - f) ? (s = Q(T(c, u), d), l = T(Q(c, u), f)) : (s = T(c, u), l = Q(c, u)), [s, l];
    }
  }
  get rule_coords() {
    const e = this.dimension, r = (e + 1) % 2, [o] = this.ranges, [s, l] = this.computed_bounds, c = new Array(2), u = new Array(2), d = [c, u];
    return d[e][0] = Math.max(s, o.min), d[e][1] = Math.min(l, o.max), d[e][0] > d[e][1] && (d[e][0] = d[e][1] = NaN), d[r][0] = this.loc, d[r][1] = this.loc, d;
  }
  get tick_coords() {
    const e = this.dimension, r = (e + 1) % 2, [o] = this.ranges, [s, l] = this.computed_bounds, c = this.model.ticker.get_ticks(s, l, o, this.loc), u = c.major, d = c.minor, Q = [[], []], v = [[], []], [b, L] = [o.min, o.max];
    for (let A = 0; A < u.length; A++)
      u[A] < b || u[A] > L || (Q[e].push(u[A]), Q[r].push(this.loc));
    for (let A = 0; A < d.length; A++)
      d[A] < b || d[A] > L || (v[e].push(d[A]), v[r].push(this.loc));
    return {
      major: Q,
      minor: v
    };
  }
  get loc() {
    const { fixed_location: e } = this.model;
    if (e != null) {
      if (isNumber(e))
        return e;
      const [, o] = this.ranges;
      if (o instanceof FactorRange)
        return o.synthetic(e);
      unreachable();
    }
    const [, r] = this.ranges;
    switch (this.panel.side) {
      case "left":
      case "below":
        return r.start;
      case "right":
      case "above":
        return r.end;
    }
  }
  serializable_state() {
    return {
      ...super.serializable_state(),
      bbox: this.layout.bbox.box
    };
  }
  remove() {
    var e;
    (e = this._axis_label_view) == null || e.remove();
    for (const r of this._major_label_views.values())
      r.remove();
    super.remove();
  }
  has_finished() {
    if (!super.has_finished() || this._axis_label_view != null && !this._axis_label_view.has_finished())
      return !1;
    for (const e of this._major_label_views.values())
      if (!e.has_finished())
        return !1;
    return !0;
  }
}
AxisView.__name__ = "AxisView";
class Axis extends GuideRenderer {
  constructor(e) {
    super(e);
  }
}
_a$3r = Axis;
Axis.__name__ = "Axis";
_a$3r.prototype.default_view = AxisView, _a$3r.mixins([
  ["axis_", Line$2],
  ["major_tick_", Line$2],
  ["minor_tick_", Line$2],
  ["major_label_", Text$3],
  ["axis_label_", Text$3]
]), _a$3r.define(({ Any: t, Int: e, Number: r, String: o, Ref: s, Dict: l, Tuple: c, Or: u, Nullable: d, Auto: f }) => ({
  bounds: [u(c(r, r), f), "auto"],
  ticker: [s(Ticker)],
  formatter: [s(TickFormatter)],
  axis_label: [d(u(o, s(BaseText))), null],
  axis_label_standoff: [e, 5],
  major_label_standoff: [e, 5],
  major_label_orientation: [u(TickLabelOrientation, r), "horizontal"],
  major_label_overrides: [l(u(o, s(BaseText))), {}],
  major_label_policy: [s(LabelingPolicy), () => new AllLabels()],
  major_tick_in: [r, 2],
  major_tick_out: [r, 6],
  minor_tick_in: [r, 0],
  minor_tick_out: [r, 4],
  fixed_location: [d(u(r, t)), null]
})), _a$3r.override({
  axis_line_color: "black",
  major_tick_line_color: "black",
  minor_tick_line_color: "black",
  major_label_text_font_size: "11px",
  major_label_text_align: "center",
  major_label_text_baseline: "alphabetic",
  axis_label_text_font_size: "13px",
  axis_label_text_font_style: "italic"
});
class CategoricalTicker extends Ticker {
  constructor(e) {
    super(e);
  }
  get_ticks(e, r, o, s) {
    var d, f;
    const l = this._collect(o.factors, o, e, r), c = this._collect((d = o.tops) != null ? d : [], o, e, r), u = this._collect((f = o.mids) != null ? f : [], o, e, r);
    return {
      major: l,
      minor: [],
      tops: c,
      mids: u
    };
  }
  _collect(e, r, o, s) {
    const l = [];
    for (const c of e) {
      const u = r.synthetic(c);
      u > o && u < s && l.push(c);
    }
    return l;
  }
}
CategoricalTicker.__name__ = "CategoricalTicker";
class CategoricalTickFormatter extends TickFormatter {
  constructor(e) {
    super(e);
  }
  doFormat(e, r) {
    return copy(e);
  }
}
CategoricalTickFormatter.__name__ = "CategoricalTickFormatter";
var _a$3q;
class CategoricalAxisView extends AxisView {
  _paint(e, r, o) {
    this._draw_group_separators(e, r, o);
  }
  _draw_group_separators(e, r, o) {
    const [s] = this.ranges, [l, c] = this.computed_bounds;
    if (!s.tops || s.tops.length < 2 || !this.visuals.separator_line.doit)
      return;
    const u = this.dimension, d = (u + 1) % 2, f = [[], []];
    let T = 0;
    for (let m = 0; m < s.tops.length - 1; m++) {
      let g, v;
      for (let L = T; L < s.factors.length; L++)
        if (s.factors[L][0] == s.tops[m + 1]) {
          [g, v] = [s.factors[L - 1], s.factors[L]], T = L;
          break;
        }
      const b = (s.synthetic(g) + s.synthetic(v)) / 2;
      b > l && b < c && (f[u].push(b), f[d].push(this.loc));
    }
    const Q = this.extents.tick_label;
    this._draw_ticks(e, f, -3, Q - 6, this.visuals.separator_line);
  }
  _draw_major_labels(e, r, o) {
    const s = this._get_factor_info();
    let l = r.tick + this.model.major_label_standoff;
    for (let c = 0; c < s.length; c++) {
      const [u, d, f, T] = s[c];
      this._draw_oriented_labels(e, u, d, f, this.panel.side, l, T), l += r.tick_labels[c];
    }
  }
  _tick_label_extents() {
    const e = this._get_factor_info(), r = [];
    for (const [o, , s, l] of e) {
      const c = this._oriented_labels_extent(o, s, this.model.major_label_standoff, l);
      r.push(c);
    }
    return r;
  }
  _get_factor_info() {
    const [e] = this.ranges, [r, o] = this.computed_bounds, s = this.loc, l = this.model.ticker.get_ticks(r, o, e, s), c = this.tick_coords, u = [], d = (T) => new GraphicsBoxes(T.map((Q) => isString(Q) ? new TextBox({ text: Q }) : Q)), f = (T) => d(this.model.formatter.doFormat(T, this));
    if (e.levels == 1) {
      const T = l.major, Q = f(T);
      u.push([Q, c.major, this.model.major_label_orientation, this.visuals.major_label_text]);
    } else if (e.levels == 2) {
      const T = l.major.map((m) => m[1]), Q = f(T);
      u.push([Q, c.major, this.model.major_label_orientation, this.visuals.major_label_text]), u.push([d(l.tops), c.tops, this.model.group_label_orientation, this.visuals.group_text]);
    } else if (e.levels == 3) {
      const T = l.major.map((g) => g[2]), Q = f(T), m = l.mids.map((g) => g[1]);
      u.push([Q, c.major, this.model.major_label_orientation, this.visuals.major_label_text]), u.push([d(m), c.mids, this.model.subgroup_label_orientation, this.visuals.subgroup_text]), u.push([d(l.tops), c.tops, this.model.group_label_orientation, this.visuals.group_text]);
    }
    return u;
  }
  get tick_coords() {
    const e = this.dimension, r = (e + 1) % 2, [o] = this.ranges, [s, l] = this.computed_bounds, c = this.model.ticker.get_ticks(s, l, o, this.loc), u = {
      major: [[], []],
      mids: [[], []],
      tops: [[], []],
      minor: [[], []]
    };
    return u.major[e] = c.major, u.major[r] = c.major.map(() => this.loc), o.levels == 3 && (u.mids[e] = c.mids, u.mids[r] = c.mids.map(() => this.loc)), o.levels > 1 && (u.tops[e] = c.tops, u.tops[r] = c.tops.map(() => this.loc)), u;
  }
}
CategoricalAxisView.__name__ = "CategoricalAxisView";
class CategoricalAxis extends Axis {
  constructor(e) {
    super(e);
  }
}
_a$3q = CategoricalAxis;
CategoricalAxis.__name__ = "CategoricalAxis";
_a$3q.prototype.default_view = CategoricalAxisView, _a$3q.mixins([
  ["separator_", Line$2],
  ["group_", Text$3],
  ["subgroup_", Text$3]
]), _a$3q.define(({ Number: t, Or: e }) => ({
  group_label_orientation: [e(TickLabelOrientation, t), "parallel"],
  subgroup_label_orientation: [e(TickLabelOrientation, t), "parallel"]
})), _a$3q.override({
  ticker: () => new CategoricalTicker(),
  formatter: () => new CategoricalTickFormatter(),
  separator_line_color: "lightgrey",
  separator_line_width: 2,
  group_text_font_style: "bold",
  group_text_font_size: "11px",
  group_text_color: "grey",
  subgroup_text_font_style: "bold",
  subgroup_text_font_size: "11px"
});
class ContinuousAxisView extends AxisView {
}
ContinuousAxisView.__name__ = "ContinuousAxisView";
class ContinuousAxis extends Axis {
  constructor(e) {
    super(e);
  }
}
ContinuousAxis.__name__ = "ContinuousAxis";
var _a$3p;
function unicode_replace(t) {
  let e = "";
  for (const r of t)
    r == "-" ? e += "\u2212" : e += r;
  return e;
}
class BasicTickFormatter extends TickFormatter {
  constructor(e) {
    super(e), this.last_precision = 3;
  }
  get scientific_limit_low() {
    return 10 ** this.power_limit_low;
  }
  get scientific_limit_high() {
    return 10 ** this.power_limit_high;
  }
  _need_sci(e) {
    if (!this.use_scientific)
      return !1;
    const { scientific_limit_high: r } = this, { scientific_limit_low: o } = this, s = e.length < 2 ? 0 : Math.abs(e[1] - e[0]) / 1e4;
    for (const l of e) {
      const c = Math.abs(l);
      if (!(c <= s) && (c >= r || c <= o))
        return !0;
    }
    return !1;
  }
  _format_with_precision(e, r, o) {
    return r ? e.map((s) => unicode_replace(s.toExponential(o))) : e.map((s) => unicode_replace(to_fixed(s, o)));
  }
  _auto_precision(e, r) {
    const o = new Array(e.length), s = this.last_precision <= 15;
    e:
      for (let l = this.last_precision; s ? l <= 15 : l >= 1; s ? l++ : l--)
        if (r) {
          o[0] = e[0].toExponential(l);
          for (let c = 1; c < e.length; c++)
            if (o[c] == o[c - 1])
              continue e;
          this.last_precision = l;
          break;
        } else {
          o[0] = to_fixed(e[0], l);
          for (let c = 1; c < e.length; c++)
            if (o[c] = to_fixed(e[c], l), o[c] == o[c - 1])
              continue e;
          this.last_precision = l;
          break;
        }
    return this.last_precision;
  }
  doFormat(e, r) {
    if (e.length == 0)
      return [];
    const o = this._need_sci(e), s = this.precision == "auto" ? this._auto_precision(e, o) : this.precision;
    return this._format_with_precision(e, o, s);
  }
}
_a$3p = BasicTickFormatter;
BasicTickFormatter.__name__ = "BasicTickFormatter";
_a$3p.define(({ Boolean: t, Int: e, Auto: r, Or: o }) => ({
  precision: [o(e, r), "auto"],
  use_scientific: [t, !0],
  power_limit_high: [e, 5],
  power_limit_low: [e, -3]
}));
var _a$3o;
class ContinuousTicker extends Ticker {
  constructor(e) {
    super(e);
  }
  get_ticks(e, r, o, s) {
    return this.get_ticks_no_defaults(e, r, s, this.desired_num_ticks);
  }
  get_ticks_no_defaults(e, r, o, s) {
    const l = this.get_interval(e, r, s), c = Math.floor(e / l), u = Math.ceil(r / l);
    let d;
    !isFinite(c) || !isFinite(u) ? d = [] : d = range(c, u + 1);
    const f = d.map((m) => m * l).filter((m) => e <= m && m <= r), T = this.num_minor_ticks, Q = [];
    if (T > 0 && f.length > 0) {
      const m = l / T, g = range(0, T).map((v) => v * m);
      for (const v of g.slice(1)) {
        const b = f[0] - v;
        e <= b && b <= r && Q.push(b);
      }
      for (const v of f)
        for (const b of g) {
          const L = v + b;
          e <= L && L <= r && Q.push(L);
        }
    }
    return {
      major: f,
      minor: Q
    };
  }
  get_ideal_interval(e, r, o) {
    return (r - e) / o;
  }
}
_a$3o = ContinuousTicker;
ContinuousTicker.__name__ = "ContinuousTicker";
_a$3o.define(({ Int: t }) => ({
  num_minor_ticks: [t, 5],
  desired_num_ticks: [t, 6]
}));
var _a$3n;
class AdaptiveTicker extends ContinuousTicker {
  constructor(e) {
    super(e);
  }
  get_min_interval() {
    return this.min_interval;
  }
  get_max_interval() {
    var e;
    return (e = this.max_interval) != null ? e : 1 / 0;
  }
  initialize() {
    super.initialize();
    const e = nth(this.mantissas, -1) / this.base, r = nth(this.mantissas, 0) * this.base;
    this.extended_mantissas = [e, ...this.mantissas, r], this.base_factor = this.get_min_interval() === 0 ? 1 : this.get_min_interval();
  }
  get_interval(e, r, o) {
    const s = r - e, l = this.get_ideal_interval(e, r, o), c = Math.floor(log$1(l / this.base_factor, this.base)), u = this.base ** c * this.base_factor, d = this.extended_mantissas, f = d.map((m) => Math.abs(o - s / (m * u))), Q = d[argmin(f)] * u;
    return clamp(Q, this.get_min_interval(), this.get_max_interval());
  }
}
_a$3n = AdaptiveTicker;
AdaptiveTicker.__name__ = "AdaptiveTicker";
_a$3n.define(({ Number: t, Array: e, Nullable: r }) => ({
  base: [t, 10],
  mantissas: [e(t), [1, 2, 5]],
  min_interval: [t, 0],
  max_interval: [r(t), null]
}));
class BasicTicker extends AdaptiveTicker {
  constructor(e) {
    super(e);
  }
}
BasicTicker.__name__ = "BasicTicker";
var _a$3m;
class LinearAxisView extends ContinuousAxisView {
}
LinearAxisView.__name__ = "LinearAxisView";
class LinearAxis extends ContinuousAxis {
  constructor(e) {
    super(e);
  }
}
_a$3m = LinearAxis;
LinearAxis.__name__ = "LinearAxis";
_a$3m.prototype.default_view = LinearAxisView, _a$3m.override({
  ticker: () => new BasicTicker(),
  formatter: () => new BasicTickFormatter()
});
var timezone = { exports: {} };
(function(t) {
  (function(e) {
    t.exports ? t.exports = e() : this.tz = e();
  })(function() {
    function e(g, v, b) {
      var L, A = v.day[1];
      do
        L = new Date(Date.UTC(b, v.month, Math.abs(A++)));
      while (v.day[0] < 7 && L.getUTCDay() != v.day[0]);
      return L = {
        clock: v.clock,
        sort: L.getTime(),
        rule: v,
        save: v.save * 6e4,
        offset: g.offset
      }, L[L.clock] = L.sort + v.time * 6e4, L.posix ? L.wallclock = L[L.clock] + (g.offset + v.saved) : L.posix = L[L.clock] - (g.offset + v.saved), L;
    }
    function r(g, v, b) {
      var L, A, M, S, E = g[g.zone], k = [], w, O, D, R = new Date(b).getUTCFullYear(), B = 1;
      for (L = 1, A = E.length; L < A && !(E[L][v] <= b); L++)
        ;
      if (M = E[L], M.rules) {
        for (O = g[M.rules], D = R + 1; D >= R - B; --D)
          for (L = 0, A = O.length; L < A; L++)
            O[L].from <= D && D <= O[L].to ? k.push(e(M, O[L], D)) : O[L].to < D && B == 1 && (B = D - O[L].to);
        for (k.sort(function(F, j) {
          return F.sort - j.sort;
        }), L = 0, A = k.length; L < A; L++)
          b >= k[L][v] && k[L][k[L].clock] > M[k[L].clock] && (S = k[L]);
      }
      return S && ((w = /^(.*)\/(.*)$/.exec(M.format)) ? S.abbrev = w[S.save ? 2 : 1] : S.abbrev = M.format.replace(/%s/, S.rule.letter)), S || M;
    }
    function o(g, v) {
      return g.zone == "UTC" ? v : (g.entry = r(g, "posix", v), v + g.entry.offset + g.entry.save);
    }
    function s(g, v) {
      if (g.zone == "UTC")
        return v;
      var b, L;
      return g.entry = b = r(g, "wallclock", v), L = v - b.wallclock, 0 < L && L < b.save ? null : v - b.offset - b.save;
    }
    function l(g, v, b) {
      var L = +(b[1] + 1), A = b[2] * L, M = d.indexOf(b[3].toLowerCase()), S;
      if (M > 9)
        v += A * T[M - 10];
      else {
        if (S = new Date(o(g, v)), M < 7)
          for (; A; )
            S.setUTCDate(S.getUTCDate() + L), S.getUTCDay() == M && (A -= L);
        else
          M == 7 ? S.setUTCFullYear(S.getUTCFullYear() + A) : M == 8 ? S.setUTCMonth(S.getUTCMonth() + A) : S.setUTCDate(S.getUTCDate() + A);
        (v = s(g, S.getTime())) == null && (v = s(g, S.getTime() + 864e5 * L) - 864e5 * L);
      }
      return v;
    }
    function c(g) {
      if (!g.length)
        return "1.0.23";
      var v = Object.create(this), b = [], L, A, M, S, E;
      for (L = 0; L < g.length; L++)
        if (S = g[L], Array.isArray(S))
          !L && !isNaN(S[1]) ? E = S : S.splice.apply(g, [L--, 1].concat(S));
        else if (isNaN(S)) {
          if (M = typeof S, M == "string")
            ~S.indexOf("%") ? v.format = S : !L && S == "*" ? E = S : !L && (M = /^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(S)) ? (E = [], E.push.apply(E, M.slice(1, 8)), M[9] ? (E.push(M[10] + 1), E.push.apply(E, M[11].split(/:/))) : M[8] && E.push(1)) : /^\w{2,3}_\w{2}$/.test(S) ? v.locale = S : (M = f.exec(S)) ? b.push(M) : v.zone = S;
          else if (M == "function") {
            if (M = S.call(v))
              return M;
          } else if (/^\w{2,3}_\w{2}$/.test(S.name))
            v[S.name] = S;
          else if (S.zones) {
            for (M in S.zones)
              v[M] = S.zones[M];
            for (M in S.rules)
              v[M] = S.rules[M];
          }
        } else
          L || (E = S);
      if (v[v.locale] || delete v.locale, v[v.zone] || delete v.zone, E != null) {
        if (E == "*")
          E = v.clock();
        else if (Array.isArray(E)) {
          for (M = [], A = !E[7], L = 0; L < 11; L++)
            M[L] = +(E[L] || 0);
          --M[1], E = Date.UTC.apply(Date.UTC, M) + -M[7] * (M[8] * 36e5 + M[9] * 6e4 + M[10] * 1e3);
        } else
          E = Math.floor(E);
        if (!isNaN(E)) {
          if (A && (E = s(v, E)), E == null)
            return E;
          for (L = 0, A = b.length; L < A; L++)
            E = l(v, E, b[L]);
          return v.format ? (M = new Date(o(v, E)), v.format.replace(
            /%([-0_^]?)(:{0,3})(\d*)(.)/g,
            function(k, w, O, D, R) {
              var B, F = "0", j;
              if (B = v[R]) {
                for (k = String(B.call(v, M, E, w, O.length)), (w || B.style) == "_" && (F = " "), j = w == "-" ? 0 : B.pad || 0; k.length < j; )
                  k = F + k;
                for (j = w == "-" ? 0 : D || B.pad; k.length < j; )
                  k = F + k;
                R == "N" && j < k.length && (k = k.slice(0, j)), w == "^" && (k = k.toUpperCase());
              }
              return k;
            }
          )) : E;
        }
      }
      return function() {
        return v.convert(arguments);
      };
    }
    var u = {
      clock: function() {
        return +new Date();
      },
      zone: "UTC",
      entry: { abbrev: "UTC", offset: 0, save: 0 },
      UTC: 1,
      z: function(g, v, b, L) {
        var A = this.entry.offset + this.entry.save, M = Math.abs(A / 1e3), S = [], E = 3600, k, w;
        for (k = 0; k < 3; k++)
          S.push(("0" + Math.floor(M / E)).slice(-2)), M %= E, E /= 60;
        return b == "^" && !A ? "Z" : (b == "^" && (L = 3), L == 3 ? (w = S.join(":"), w = w.replace(/:00$/, ""), b != "^" && (w = w.replace(/:00$/, ""))) : L ? (w = S.slice(0, L + 1).join(":"), b == "^" && (w = w.replace(/:00$/, ""))) : w = S.slice(0, 2).join(""), w = (A < 0 ? "-" : "+") + w, w = w.replace(/([-+])(0)/, { _: " $1", "-": "$1" }[b] || "$1$2"), w);
      },
      "%": function(g) {
        return "%";
      },
      n: function(g) {
        return `
`;
      },
      t: function(g) {
        return "	";
      },
      U: function(g) {
        return Q(g, 0);
      },
      W: function(g) {
        return Q(g, 1);
      },
      V: function(g) {
        return m(g)[0];
      },
      G: function(g) {
        return m(g)[1];
      },
      g: function(g) {
        return m(g)[1] % 100;
      },
      j: function(g) {
        return Math.floor((g.getTime() - Date.UTC(g.getUTCFullYear(), 0)) / 864e5) + 1;
      },
      s: function(g) {
        return Math.floor(g.getTime() / 1e3);
      },
      C: function(g) {
        return Math.floor(g.getUTCFullYear() / 100);
      },
      N: function(g) {
        return g.getTime() % 1e3 * 1e6;
      },
      m: function(g) {
        return g.getUTCMonth() + 1;
      },
      Y: function(g) {
        return g.getUTCFullYear();
      },
      y: function(g) {
        return g.getUTCFullYear() % 100;
      },
      H: function(g) {
        return g.getUTCHours();
      },
      M: function(g) {
        return g.getUTCMinutes();
      },
      S: function(g) {
        return g.getUTCSeconds();
      },
      e: function(g) {
        return g.getUTCDate();
      },
      d: function(g) {
        return g.getUTCDate();
      },
      u: function(g) {
        return g.getUTCDay() || 7;
      },
      w: function(g) {
        return g.getUTCDay();
      },
      l: function(g) {
        return g.getUTCHours() % 12 || 12;
      },
      I: function(g) {
        return g.getUTCHours() % 12 || 12;
      },
      k: function(g) {
        return g.getUTCHours();
      },
      Z: function(g) {
        return this.entry.abbrev;
      },
      a: function(g) {
        return this[this.locale].day.abbrev[g.getUTCDay()];
      },
      A: function(g) {
        return this[this.locale].day.full[g.getUTCDay()];
      },
      h: function(g) {
        return this[this.locale].month.abbrev[g.getUTCMonth()];
      },
      b: function(g) {
        return this[this.locale].month.abbrev[g.getUTCMonth()];
      },
      B: function(g) {
        return this[this.locale].month.full[g.getUTCMonth()];
      },
      P: function(g) {
        return this[this.locale].meridiem[Math.floor(g.getUTCHours() / 12)].toLowerCase();
      },
      p: function(g) {
        return this[this.locale].meridiem[Math.floor(g.getUTCHours() / 12)];
      },
      R: function(g, v) {
        return this.convert([v, "%H:%M"]);
      },
      T: function(g, v) {
        return this.convert([v, "%H:%M:%S"]);
      },
      D: function(g, v) {
        return this.convert([v, "%m/%d/%y"]);
      },
      F: function(g, v) {
        return this.convert([v, "%Y-%m-%d"]);
      },
      x: function(g, v) {
        return this.convert([v, this[this.locale].date]);
      },
      r: function(g, v) {
        return this.convert([v, this[this.locale].time12 || "%I:%M:%S"]);
      },
      X: function(g, v) {
        return this.convert([v, this[this.locale].time24]);
      },
      c: function(g, v) {
        return this.convert([v, this[this.locale].dateTime]);
      },
      convert: c,
      locale: "en_US",
      en_US: {
        date: "%m/%d/%Y",
        time24: "%I:%M:%S %p",
        time12: "%I:%M:%S %p",
        dateTime: "%a %d %b %Y %I:%M:%S %p %Z",
        meridiem: ["AM", "PM"],
        month: {
          abbrev: "Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),
          full: "January|February|March|April|May|June|July|August|September|October|November|December".split("|")
        },
        day: {
          abbrev: "Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),
          full: "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")
        }
      }
    }, d = "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond", f = new RegExp("^\\s*([+-])(\\d+)\\s+(" + d + ")s?\\s*$", "i"), T = [36e5, 6e4, 1e3, 1];
    d = d.toLowerCase().split("|"), "delmHMSUWVgCIky".replace(/./g, function(g) {
      u[g].pad = 2;
    }), u.N.pad = 9, u.j.pad = 3, u.k.style = "_", u.l.style = "_", u.e.style = "_";
    function Q(g, v) {
      var b, L, A;
      return L = new Date(Date.UTC(g.getUTCFullYear(), 0)), b = Math.floor((g.getTime() - L.getTime()) / 864e5), L.getUTCDay() == v ? A = 0 : (A = 7 - L.getUTCDay() + v, A == 8 && (A = 1)), b >= A ? Math.floor((b - A) / 7) + 1 : 0;
    }
    function m(g) {
      var v, b, L;
      return b = g.getUTCFullYear(), v = new Date(Date.UTC(b, 0)).getUTCDay(), L = Q(g, 1) + (v > 1 && v <= 4 ? 1 : 0), L ? L == 53 && !(v == 4 || v == 3 && new Date(b, 1, 29).getDate() == 29) ? [1, g.getUTCFullYear() + 1] : [L, g.getUTCFullYear()] : (b = g.getUTCFullYear() - 1, v = new Date(Date.UTC(b, 0)).getUTCDay(), L = v == 4 || v == 3 && new Date(b, 1, 29).getDate() == 29 ? 53 : 52, [L, g.getUTCFullYear() - 1]);
    }
    return function() {
      return u.convert(arguments);
    };
  });
})(timezone);
const tz = timezone.exports;
var numbro = { exports: {} };
/*!
 * numbro.js
 * version : 1.6.2
 * author : Företagsplatsen AB
 * license : MIT
 * http://www.foretagsplatsen.se
 */
(function(t) {
  var e, r = "1.6.2", o = {}, s = o, l = "en-US", c = null, u = "0,0";
  t.exports;
  var d = {
    delimiters: {
      thousands: ",",
      decimal: "."
    },
    abbreviations: {
      thousand: "k",
      million: "m",
      billion: "b",
      trillion: "t"
    },
    ordinal: function(k) {
      var w = k % 10;
      return ~~(k % 100 / 10) === 1 ? "th" : w === 1 ? "st" : w === 2 ? "nd" : w === 3 ? "rd" : "th";
    },
    currency: {
      symbol: "$",
      position: "prefix"
    },
    defaults: {
      currencyFormat: ",0000 a"
    },
    formats: {
      fourDigits: "0000 a",
      fullWithTwoDecimals: "$ ,0.00",
      fullWithTwoDecimalsNoCurrency: ",0.00"
    }
  };
  function f(k) {
    this._value = k;
  }
  function T(k) {
    var w, O = "";
    for (w = 0; w < k; w++)
      O += "0";
    return O;
  }
  function Q(k, w) {
    var O, D, R, B, F;
    return F = k.toString(), O = F.split("e")[0], B = F.split("e")[1], D = O.split(".")[0], R = O.split(".")[1] || "", F = D + R + T(B - R.length), w > 0 && (F += "." + T(w)), F;
  }
  function m(k, w, O, D) {
    var R = Math.pow(10, w), B, F;
    return k.toFixed(0).search("e") > -1 ? F = Q(k, w) : F = (O(k * R) / R).toFixed(w), D && (B = new RegExp("0{1," + D + "}$"), F = F.replace(B, "")), F;
  }
  function g(k, w, O) {
    var D;
    return w.indexOf("$") > -1 ? D = v(k, w, O) : w.indexOf("%") > -1 ? D = b(k, w, O) : w.indexOf(":") > -1 ? D = L(k) : D = A(k, w, O), D;
  }
  function v(k, w, O) {
    var D = w, R = D.indexOf("$"), B = D.indexOf("("), F = D.indexOf("+"), j = D.indexOf("-"), z = "", q = "", I, U;
    if (D.indexOf("$") === -1 ? o[l].currency.position === "infix" ? (q = o[l].currency.symbol, o[l].currency.spaceSeparated && (q = " " + q + " ")) : o[l].currency.spaceSeparated && (z = " ") : D.indexOf(" $") > -1 ? (z = " ", D = D.replace(" $", "")) : D.indexOf("$ ") > -1 ? (z = " ", D = D.replace("$ ", "")) : D = D.replace("$", ""), U = A(k, D, O, q), w.indexOf("$") === -1)
      switch (o[l].currency.position) {
        case "postfix":
          U.indexOf(")") > -1 ? (U = U.split(""), U.splice(-1, 0, z + o[l].currency.symbol), U = U.join("")) : U = U + z + o[l].currency.symbol;
          break;
        case "infix":
          break;
        case "prefix":
          U.indexOf("(") > -1 || U.indexOf("-") > -1 ? (U = U.split(""), I = Math.max(B, j) + 1, U.splice(I, 0, o[l].currency.symbol + z), U = U.join("")) : U = o[l].currency.symbol + z + U;
          break;
        default:
          throw Error('Currency position should be among ["prefix", "infix", "postfix"]');
      }
    else
      R <= 1 ? U.indexOf("(") > -1 || U.indexOf("+") > -1 || U.indexOf("-") > -1 ? (U = U.split(""), I = 1, (R < B || R < F || R < j) && (I = 0), U.splice(I, 0, o[l].currency.symbol + z), U = U.join("")) : U = o[l].currency.symbol + z + U : U.indexOf(")") > -1 ? (U = U.split(""), U.splice(-1, 0, z + o[l].currency.symbol), U = U.join("")) : U = U + z + o[l].currency.symbol;
    return U;
  }
  function b(k, w, O) {
    var D = "", R;
    return k = k * 100, w.indexOf(" %") > -1 ? (D = " ", w = w.replace(" %", "")) : w = w.replace("%", ""), R = A(k, w, O), R.indexOf(")") > -1 ? (R = R.split(""), R.splice(-1, 0, D + "%"), R = R.join("")) : R = R + D + "%", R;
  }
  function L(k) {
    var w = Math.floor(k / 60 / 60), O = Math.floor((k - w * 60 * 60) / 60), D = Math.round(k - w * 60 * 60 - O * 60);
    return w + ":" + (O < 10 ? "0" + O : O) + ":" + (D < 10 ? "0" + D : D);
  }
  function A(k, w, O, D) {
    var R = !1, B = !1, F = !1, j = "", z, q = !1, I = !1, U = !1, H = !1, ce = !1, Ae = "", ae = "", pe = Math.abs(k), Ze = ["B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"], ze = ["B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"], et, lt, bt, He, $e, Ye, tt, dt, Wt, pt, Rt, Yt, Et, d1 = "", b1 = !1, Y1 = !1, nr, F1, qr, te = "", vr;
    if (k === 0 && c !== null)
      return c;
    if (!isFinite(k))
      return "" + k;
    if (w.indexOf("{") === 0) {
      var Ir = w.indexOf("}");
      if (Ir === -1)
        throw Error('Format should also contain a "}"');
      Rt = w.slice(1, Ir), w = w.slice(Ir + 1);
    } else
      Rt = "";
    if (w.indexOf("}") === w.length - 1) {
      var Hr = w.indexOf("{");
      if (Hr === -1)
        throw Error('Format should also contain a "{"');
      Yt = w.slice(Hr + 1, -1), w = w.slice(0, Hr + 1);
    } else
      Yt = "";
    var ge;
    if (w.indexOf(".") === -1 ? ge = w.match(/([0-9]+).*/) : ge = w.match(/([0-9]+)\..*/), vr = ge === null ? -1 : ge[1].length, w.indexOf("-") !== -1 && (b1 = !0), w.indexOf("(") > -1 ? (R = !0, w = w.slice(1, -1)) : w.indexOf("+") > -1 && (B = !0, w = w.replace(/\+/g, "")), w.indexOf("a") > -1) {
      if (Wt = w.split(".")[0].match(/[0-9]+/g) || ["0"], Wt = parseInt(Wt[0], 10), q = w.indexOf("aK") >= 0, I = w.indexOf("aM") >= 0, U = w.indexOf("aB") >= 0, H = w.indexOf("aT") >= 0, ce = q || I || U || H, w.indexOf(" a") > -1 ? (j = " ", w = w.replace(" a", "")) : w = w.replace("a", ""), He = Math.floor(Math.log(pe) / Math.LN10) + 1, Ye = He % 3, Ye = Ye === 0 ? 3 : Ye, Wt && pe !== 0 && ($e = Math.floor(Math.log(pe) / Math.LN10) + 1 - Wt, tt = 3 * ~~((Math.min(Wt, He) - Ye) / 3), pe = pe / Math.pow(10, tt), w.indexOf(".") === -1 && Wt > 3))
        for (w += "[.]", F1 = $e === 0 ? 0 : 3 * ~~($e / 3) - $e, F1 = F1 < 0 ? F1 + 3 : F1, z = 0; z < F1; z++)
          w += "0";
      Math.floor(Math.log(Math.abs(k)) / Math.LN10) + 1 !== Wt && (pe >= Math.pow(10, 12) && !ce || H ? (j = j + o[l].abbreviations.trillion, k = k / Math.pow(10, 12)) : pe < Math.pow(10, 12) && pe >= Math.pow(10, 9) && !ce || U ? (j = j + o[l].abbreviations.billion, k = k / Math.pow(10, 9)) : pe < Math.pow(10, 9) && pe >= Math.pow(10, 6) && !ce || I ? (j = j + o[l].abbreviations.million, k = k / Math.pow(10, 6)) : (pe < Math.pow(10, 6) && pe >= Math.pow(10, 3) && !ce || q) && (j = j + o[l].abbreviations.thousand, k = k / Math.pow(10, 3)));
    }
    if (w.indexOf("b") > -1) {
      for (w.indexOf(" b") > -1 ? (Ae = " ", w = w.replace(" b", "")) : w = w.replace("b", ""), bt = 0; bt <= Ze.length; bt++)
        if (et = Math.pow(1024, bt), lt = Math.pow(1024, bt + 1), k >= et && k < lt) {
          Ae = Ae + Ze[bt], et > 0 && (k = k / et);
          break;
        }
    }
    if (w.indexOf("d") > -1) {
      for (w.indexOf(" d") > -1 ? (Ae = " ", w = w.replace(" d", "")) : w = w.replace("d", ""), bt = 0; bt <= ze.length; bt++)
        if (et = Math.pow(1e3, bt), lt = Math.pow(1e3, bt + 1), k >= et && k < lt) {
          Ae = Ae + ze[bt], et > 0 && (k = k / et);
          break;
        }
    }
    if (w.indexOf("o") > -1 && (w.indexOf(" o") > -1 ? (ae = " ", w = w.replace(" o", "")) : w = w.replace("o", ""), o[l].ordinal && (ae = ae + o[l].ordinal(k))), w.indexOf("[.]") > -1 && (F = !0, w = w.replace("[.]", ".")), dt = k.toString().split(".")[0], pt = w.split(".")[1], Et = w.indexOf(","), pt) {
      if (pt.indexOf("*") !== -1 ? d1 = m(k, k.toString().split(".")[1].length, O) : pt.indexOf("[") > -1 ? (pt = pt.replace("]", ""), pt = pt.split("["), d1 = m(
        k,
        pt[0].length + pt[1].length,
        O,
        pt[1].length
      )) : d1 = m(k, pt.length, O), dt = d1.split(".")[0], d1.split(".")[1].length) {
        var Y = D ? j + D : o[l].delimiters.decimal;
        d1 = Y + d1.split(".")[1];
      } else
        d1 = "";
      F && Number(d1.slice(1)) === 0 && (d1 = "");
    } else
      dt = m(k, null, O);
    return dt.indexOf("-") > -1 && (dt = dt.slice(1), Y1 = !0), dt.length < vr && (dt = new Array(vr - dt.length + 1).join("0") + dt), Et > -1 && (dt = dt.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1" + o[l].delimiters.thousands)), w.indexOf(".") === 0 && (dt = ""), nr = w.indexOf("("), qr = w.indexOf("-"), nr < qr ? te = (R && Y1 ? "(" : "") + (b1 && Y1 || !R && Y1 ? "-" : "") : te = (b1 && Y1 || !R && Y1 ? "-" : "") + (R && Y1 ? "(" : ""), Rt + te + (!Y1 && B && k !== 0 ? "+" : "") + dt + d1 + (ae || "") + (j && !D ? j : "") + (Ae || "") + (R && Y1 ? ")" : "") + Yt;
  }
  e = function(k) {
    return e.isNumbro(k) ? k = k.value() : k === 0 || typeof k > "u" ? k = 0 : Number(k) || (k = e.fn.unformat(k)), new f(Number(k));
  }, e.version = r, e.isNumbro = function(k) {
    return k instanceof f;
  }, e.setLanguage = function(k, w) {
    console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");
    var O = k, D = k.split("-")[0], R = null;
    s[O] || (Object.keys(s).forEach(function(B) {
      !R && B.split("-")[0] === D && (R = B);
    }), O = R || w || "en-US"), S(O);
  }, e.setCulture = function(k, w) {
    var O = k, D = k.split("-")[1], R = null;
    o[O] || (D && Object.keys(o).forEach(function(B) {
      !R && B.split("-")[1] === D && (R = B);
    }), O = R || w || "en-US"), S(O);
  }, e.language = function(k, w) {
    if (console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"), !k)
      return l;
    if (k && !w) {
      if (!s[k])
        throw new Error("Unknown language : " + k);
      S(k);
    }
    return (w || !s[k]) && M(k, w), e;
  }, e.culture = function(k, w) {
    if (!k)
      return l;
    if (k && !w) {
      if (!o[k])
        throw new Error("Unknown culture : " + k);
      S(k);
    }
    return (w || !o[k]) && M(k, w), e;
  }, e.languageData = function(k) {
    if (console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"), !k)
      return s[l];
    if (!s[k])
      throw new Error("Unknown language : " + k);
    return s[k];
  }, e.cultureData = function(k) {
    if (!k)
      return o[l];
    if (!o[k])
      throw new Error("Unknown culture : " + k);
    return o[k];
  }, e.culture("en-US", d), e.languages = function() {
    return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"), s;
  }, e.cultures = function() {
    return o;
  }, e.zeroFormat = function(k) {
    c = typeof k == "string" ? k : null;
  }, e.defaultFormat = function(k) {
    u = typeof k == "string" ? k : "0.0";
  }, e.defaultCurrencyFormat = function(k) {
  }, e.validate = function(k, w) {
    var O, D, R, B, F, j, z, q;
    if (typeof k != "string" && (k += "", console.warn && console.warn("Numbro.js: Value is not string. It has been co-erced to: ", k)), k = k.trim(), k.match(/^\d+$/))
      return !0;
    if (k === "")
      return !1;
    try {
      z = e.cultureData(w);
    } catch {
      z = e.cultureData(e.culture());
    }
    return R = z.currency.symbol, F = z.abbreviations, O = z.delimiters.decimal, z.delimiters.thousands === "." ? D = "\\." : D = z.delimiters.thousands, q = k.match(/^[^\d]+/), q !== null && (k = k.substr(1), q[0] !== R) || (q = k.match(/[^\d]+$/), q !== null && (k = k.slice(0, -1), q[0] !== F.thousand && q[0] !== F.million && q[0] !== F.billion && q[0] !== F.trillion)) ? !1 : (j = new RegExp(D + "{2}"), k.match(/[^\d.,]/g) ? !1 : (B = k.split(O), B.length > 2 ? !1 : B.length < 2 ? !!B[0].match(/^\d+.*\d$/) && !B[0].match(j) : B[0].length === 1 ? !!B[0].match(/^\d+$/) && !B[0].match(j) && !!B[1].match(/^\d+$/) : !!B[0].match(/^\d+.*\d$/) && !B[0].match(j) && !!B[1].match(/^\d+$/)));
  };
  function M(k, w) {
    o[k] = w;
  }
  function S(k) {
    l = k;
    var w = o[k].defaults;
    w && w.format && e.defaultFormat(w.format), w && w.currencyFormat && e.defaultCurrencyFormat(w.currencyFormat);
  }
  function E(k, w, O, D) {
    return O != null && O !== e.culture() && e.setCulture(O), g(
      Number(k),
      w != null ? w : u,
      D == null ? Math.round : D
    );
  }
  t.exports = { format: E };
})(numbro);
var sprintf$1 = {};
(function(t) {
  (function() {
    var e = {
      not_string: /[^s]/,
      not_bool: /[^t]/,
      not_type: /[^T]/,
      not_primitive: /[^v]/,
      number: /[diefg]/,
      numeric_arg: /[bcdiefguxX]/,
      json: /[j]/,
      not_json: /[^j]/,
      text: /^[^\x25]+/,
      modulo: /^\x25{2}/,
      placeholder: /^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,
      key: /^([a-z_][a-z_\d]*)/i,
      key_access: /^\.([a-z_][a-z_\d]*)/i,
      index_access: /^\[(\d+)\]/,
      sign: /^[+-]/
    };
    function r(u) {
      return s(c(u), arguments);
    }
    function o(u, d) {
      return r.apply(null, [u].concat(d || []));
    }
    function s(u, d) {
      var f = 1, T = u.length, Q, m = "", g, v, b, L, A, M, S, E;
      for (g = 0; g < T; g++)
        if (typeof u[g] == "string")
          m += u[g];
        else if (typeof u[g] == "object") {
          if (b = u[g], b.keys)
            for (Q = d[f], v = 0; v < b.keys.length; v++) {
              if (Q == null)
                throw new Error(r('[sprintf] Cannot access property "%s" of undefined value "%s"', b.keys[v], b.keys[v - 1]));
              Q = Q[b.keys[v]];
            }
          else
            b.param_no ? Q = d[b.param_no] : Q = d[f++];
          if (e.not_type.test(b.type) && e.not_primitive.test(b.type) && Q instanceof Function && (Q = Q()), e.numeric_arg.test(b.type) && typeof Q != "number" && isNaN(Q))
            throw new TypeError(r("[sprintf] expecting number but found %T", Q));
          switch (e.number.test(b.type) && (S = Q >= 0), b.type) {
            case "b":
              Q = parseInt(Q, 10).toString(2);
              break;
            case "c":
              Q = String.fromCharCode(parseInt(Q, 10));
              break;
            case "d":
            case "i":
              Q = parseInt(Q, 10);
              break;
            case "j":
              Q = JSON.stringify(Q, null, b.width ? parseInt(b.width) : 0);
              break;
            case "e":
              Q = b.precision ? parseFloat(Q).toExponential(b.precision) : parseFloat(Q).toExponential();
              break;
            case "f":
              Q = b.precision ? parseFloat(Q).toFixed(b.precision) : parseFloat(Q);
              break;
            case "g":
              Q = b.precision ? String(Number(Q.toPrecision(b.precision))) : parseFloat(Q);
              break;
            case "o":
              Q = (parseInt(Q, 10) >>> 0).toString(8);
              break;
            case "s":
              Q = String(Q), Q = b.precision ? Q.substring(0, b.precision) : Q;
              break;
            case "t":
              Q = String(!!Q), Q = b.precision ? Q.substring(0, b.precision) : Q;
              break;
            case "T":
              Q = Object.prototype.toString.call(Q).slice(8, -1).toLowerCase(), Q = b.precision ? Q.substring(0, b.precision) : Q;
              break;
            case "u":
              Q = parseInt(Q, 10) >>> 0;
              break;
            case "v":
              Q = Q.valueOf(), Q = b.precision ? Q.substring(0, b.precision) : Q;
              break;
            case "x":
              Q = (parseInt(Q, 10) >>> 0).toString(16);
              break;
            case "X":
              Q = (parseInt(Q, 10) >>> 0).toString(16).toUpperCase();
              break;
          }
          e.json.test(b.type) ? m += Q : (e.number.test(b.type) && (!S || b.sign) ? (E = S ? "+" : "-", Q = Q.toString().replace(e.sign, "")) : E = "", A = b.pad_char ? b.pad_char === "0" ? "0" : b.pad_char.charAt(1) : " ", M = b.width - (E + Q).length, L = b.width && M > 0 ? A.repeat(M) : "", m += b.align ? E + Q + L : A === "0" ? E + L + Q : L + E + Q);
        }
      return m;
    }
    var l = /* @__PURE__ */ Object.create(null);
    function c(u) {
      if (l[u])
        return l[u];
      for (var d = u, f, T = [], Q = 0; d; ) {
        if ((f = e.text.exec(d)) !== null)
          T.push(f[0]);
        else if ((f = e.modulo.exec(d)) !== null)
          T.push("%");
        else if ((f = e.placeholder.exec(d)) !== null) {
          if (f[2]) {
            Q |= 1;
            var m = [], g = f[2], v = [];
            if ((v = e.key.exec(g)) !== null)
              for (m.push(v[1]); (g = g.substring(v[0].length)) !== ""; )
                if ((v = e.key_access.exec(g)) !== null)
                  m.push(v[1]);
                else if ((v = e.index_access.exec(g)) !== null)
                  m.push(v[1]);
                else
                  throw new SyntaxError("[sprintf] failed to parse named argument key");
            else
              throw new SyntaxError("[sprintf] failed to parse named argument key");
            f[2] = m;
          } else
            Q |= 2;
          if (Q === 3)
            throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");
          T.push(
            {
              placeholder: f[0],
              param_no: f[1],
              keys: f[2],
              sign: f[3],
              pad_char: f[4],
              align: f[5],
              width: f[6],
              precision: f[7],
              type: f[8]
            }
          );
        } else
          throw new SyntaxError("[sprintf] unexpected placeholder");
        d = d.substring(f[0].length);
      }
      return l[u] = T;
    }
    t.sprintf = r, t.vsprintf = o, typeof window < "u" && (window.sprintf = r, window.vsprintf = o);
  })();
})(sprintf$1);
const FormatterType = Enum("numeral", "printf", "datetime"), DEFAULT_FORMATTERS = {
  numeral: (t, e, r) => numbro.exports.format(t, e),
  datetime: (t, e, r) => tz(t, e),
  printf: (t, e, r) => sprintf(e, t)
};
function sprintf(t, ...e) {
  return sprintf$1.sprintf(t, ...e);
}
function basic_formatter(t, e, r) {
  if (isNumber(t)) {
    const o = (() => {
      switch (!1) {
        case Math.floor(t) != t:
          return "%d";
        case (!(Math.abs(t) > 0.1) || !(Math.abs(t) < 1e3)):
          return "%0.3f";
        default:
          return "%0.3e";
      }
    })();
    return sprintf(o, t);
  } else
    return `${t}`;
}
function get_formatter(t, e, r) {
  if (e == null)
    return basic_formatter;
  if (r != null && t in r) {
    const o = r[t];
    if (isString(o)) {
      if (o in DEFAULT_FORMATTERS)
        return DEFAULT_FORMATTERS[o];
      throw new Error(`Unknown tooltip field formatter type '${o}'`);
    }
    return function(s, l, c) {
      return o.format(s, l, c);
    };
  }
  return DEFAULT_FORMATTERS.numeral;
}
function _get_special_value(t, e) {
  if (t in e)
    return e[t];
  throw new Error(`Unknown special variable '$${t}'`);
}
function _get_column_value(t, e, r) {
  const o = e.get_column(t);
  if (o == null)
    return null;
  if (isNumber(r))
    return o[r];
  const s = o[r.index];
  return isTypedArray(s) || isArray(s) ? isArray(s[0]) ? s[r.dim2][r.dim1] : s[r.flat_index] : s;
}
function get_value(t, e, r, o) {
  if (t[0] == "$") {
    const s = t.substring(1);
    return _get_special_value(s, o);
  } else {
    const s = t.substring(1).replace(/[{}]/g, "");
    return _get_column_value(s, e, r);
  }
}
function replace_placeholders(t, e, r, o, s = {}, l) {
  let c, u;
  return isString(t) ? (c = t, u = !1) : (c = t.html, u = !0), c = c.replace(/@\$name/g, (d) => `@{${s.name}}`), c = c.replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g, (d, f, T) => {
    const Q = get_value(f, e, r, s);
    if (Q == null)
      return l ? l("???") : "???";
    if (T == "safe")
      return u = !0, `${Q}`;
    const g = `${get_formatter(f, T, o)(Q, T, s)}`;
    return l ? l(g) : g;
  }), u ? [...new DOMParser().parseFromString(c, "text/html").body.childNodes] : c;
}
var _a$3l;
function _us(t) {
  return Math.round(t / 1e3 % 1 * 1e6);
}
function _array(t) {
  return tz(t, "%Y %m %d %H %M %S").split(/\s+/).map((e) => parseInt(e, 10));
}
function _strftime(t, e) {
  if (isFunction(e))
    return e(t);
  {
    const r = sprintf("$1%06d", _us(t));
    return e = e.replace(/((^|[^%])(%%)*)%f/, r), e.indexOf("%") == -1 ? e : tz(t, e);
  }
}
const format_order = [
  "microseconds",
  "milliseconds",
  "seconds",
  "minsec",
  "minutes",
  "hourmin",
  "hours",
  "days",
  "months",
  "years"
];
class DatetimeTickFormatter extends TickFormatter {
  constructor(e) {
    super(e), this.strip_leading_zeros = !0;
  }
  initialize() {
    super.initialize(), this._update_width_formats();
  }
  _update_width_formats() {
    const e = +tz(new Date()), r = function(o) {
      const s = o.map((c) => _strftime(e, c).length), l = sort_by(zip(s, o), ([c]) => c);
      return unzip(l);
    };
    this._width_formats = {
      microseconds: r(this.microseconds),
      milliseconds: r(this.milliseconds),
      seconds: r(this.seconds),
      minsec: r(this.minsec),
      minutes: r(this.minutes),
      hourmin: r(this.hourmin),
      hours: r(this.hours),
      days: r(this.days),
      months: r(this.months),
      years: r(this.years)
    };
  }
  _get_resolution_str(e, r) {
    const o = e * 1.1;
    switch (!1) {
      case !(o < 1e-3):
        return "microseconds";
      case !(o < 1):
        return "milliseconds";
      case !(o < 60):
        return r >= 60 ? "minsec" : "seconds";
      case !(o < 3600):
        return r >= 3600 ? "hourmin" : "minutes";
      case !(o < 24 * 3600):
        return "hours";
      case !(o < 31 * 24 * 3600):
        return "days";
      case !(o < 365 * 24 * 3600):
        return "months";
      default:
        return "years";
    }
  }
  doFormat(e, r) {
    if (e.length == 0)
      return [];
    const o = Math.abs(e[e.length - 1] - e[0]) / 1e3, s = o / (e.length - 1), l = this._get_resolution_str(s, o), [, [c]] = this._width_formats[l], u = [], d = format_order.indexOf(l), f = {};
    for (const T of format_order)
      f[T] = 0;
    f.seconds = 5, f.minsec = 4, f.minutes = 4, f.hourmin = 3, f.hours = 3;
    for (const T of e) {
      let Q, m;
      try {
        m = _array(T), Q = _strftime(T, c);
      } catch (b) {
        logger.warn(`unable to format tick for timestamp value ${T}`), logger.warn(` - ${b}`), u.push("ERR");
        continue;
      }
      let g = !1, v = d;
      for (; m[f[format_order[v]]] == 0; ) {
        let b;
        if (v += 1, v == format_order.length)
          break;
        if ((l == "minsec" || l == "hourmin") && !g)
          if (l == "minsec" && m[4] == 0 && m[5] != 0 || l == "hourmin" && m[3] == 0 && m[4] != 0) {
            b = this._width_formats[format_order[d - 1]][1][0], Q = _strftime(T, b);
            break;
          } else
            g = !0;
        b = this._width_formats[format_order[v]][1][0], Q = _strftime(T, b);
      }
      if (this.strip_leading_zeros) {
        let b = Q.replace(/^0+/g, "");
        b != Q && isNaN(parseInt(b)) && (b = `0${b}`), u.push(b);
      } else
        u.push(Q);
    }
    return u;
  }
}
_a$3l = DatetimeTickFormatter;
DatetimeTickFormatter.__name__ = "DatetimeTickFormatter";
_a$3l.define(({ String: t, Array: e }) => ({
  microseconds: [e(t), ["%fus"]],
  milliseconds: [e(t), ["%3Nms", "%S.%3Ns"]],
  seconds: [e(t), ["%Ss"]],
  minsec: [e(t), [":%M:%S"]],
  minutes: [e(t), [":%M", "%Mm"]],
  hourmin: [e(t), ["%H:%M"]],
  hours: [e(t), ["%Hh", "%H:%M"]],
  days: [e(t), ["%m/%d", "%a%d"]],
  months: [e(t), ["%m/%Y", "%b %Y"]],
  years: [e(t), ["%Y"]]
}));
var _a$3k;
class CompositeTicker extends ContinuousTicker {
  constructor(e) {
    super(e);
  }
  get min_intervals() {
    return this.tickers.map((e) => e.get_min_interval());
  }
  get max_intervals() {
    return this.tickers.map((e) => e.get_max_interval());
  }
  get_min_interval() {
    return this.min_intervals[0];
  }
  get_max_interval() {
    return this.max_intervals[0];
  }
  get_best_ticker(e, r, o) {
    const s = r - e, l = this.get_ideal_interval(e, r, o), c = [
      sorted_index(this.min_intervals, l) - 1,
      sorted_index(this.max_intervals, l)
    ], d = [
      this.min_intervals[c[0]],
      this.max_intervals[c[1]]
    ].map((T) => Math.abs(o - s / T));
    let f;
    if (is_empty$1(d.filter((T) => !isNaN(T))))
      f = this.tickers[0];
    else {
      const T = argmin(d), Q = c[T];
      f = this.tickers[Q];
    }
    return f;
  }
  get_interval(e, r, o) {
    return this.get_best_ticker(e, r, o).get_interval(e, r, o);
  }
  get_ticks_no_defaults(e, r, o, s) {
    return this.get_best_ticker(e, r, s).get_ticks_no_defaults(e, r, o, s);
  }
}
_a$3k = CompositeTicker;
CompositeTicker.__name__ = "CompositeTicker";
_a$3k.define(({ Array: t, Ref: e }) => ({
  tickers: [t(e(ContinuousTicker)), []]
}));
var _a$3j;
class SingleIntervalTicker extends ContinuousTicker {
  constructor(e) {
    super(e);
  }
  get_interval(e, r, o) {
    return this.interval;
  }
  get_min_interval() {
    return this.interval;
  }
  get_max_interval() {
    return this.interval;
  }
}
_a$3j = SingleIntervalTicker;
SingleIntervalTicker.__name__ = "SingleIntervalTicker";
_a$3j.define(({ Number: t }) => ({
  interval: [t]
}));
const ONE_MILLI = 1, ONE_SECOND = 1e3, ONE_MINUTE = 60 * ONE_SECOND, ONE_HOUR = 60 * ONE_MINUTE, ONE_DAY = 24 * ONE_HOUR, ONE_MONTH = 30 * ONE_DAY, ONE_YEAR = 365 * ONE_DAY;
function copy_date(t) {
  return new Date(t.getTime());
}
function last_month_no_later_than(t) {
  const e = copy_date(t);
  return e.setUTCDate(1), e.setUTCHours(0), e.setUTCMinutes(0), e.setUTCSeconds(0), e.setUTCMilliseconds(0), e;
}
function last_year_no_later_than(t) {
  const e = last_month_no_later_than(t);
  return e.setUTCMonth(0), e;
}
var _a$3i;
function date_range_by_month(t, e) {
  const r = last_month_no_later_than(new Date(t)), o = last_month_no_later_than(new Date(e));
  o.setUTCMonth(o.getUTCMonth() + 1);
  const s = [], l = r;
  for (; s.push(copy_date(l)), l.setUTCMonth(l.getUTCMonth() + 1), !(l > o); )
    ;
  return s;
}
class DaysTicker extends SingleIntervalTicker {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize();
    const e = this.days;
    e.length > 1 ? this.interval = (e[1] - e[0]) * ONE_DAY : this.interval = 31 * ONE_DAY;
  }
  get_ticks_no_defaults(e, r, o, s) {
    const l = date_range_by_month(e, r), c = this.days, u = (m, g) => {
      const v = m.getUTCMonth(), b = [];
      for (const L of c) {
        const A = copy_date(m);
        A.setUTCDate(L), new Date(A.getTime() + g / 2).getUTCMonth() == v && b.push(A);
      }
      return b;
    }, d = this.interval;
    return {
      major: concat$1(l.map((m) => u(m, d))).map((m) => m.getTime()).filter((m) => e <= m && m <= r),
      minor: []
    };
  }
}
_a$3i = DaysTicker;
DaysTicker.__name__ = "DaysTicker";
_a$3i.define(({ Int: t, Array: e }) => ({
  days: [e(t), []]
})), _a$3i.override({
  num_minor_ticks: 0
});
var _a$3h;
function date_range_by_year(t, e) {
  const r = last_year_no_later_than(new Date(t)), o = last_year_no_later_than(new Date(e));
  o.setUTCFullYear(o.getUTCFullYear() + 1);
  const s = [], l = r;
  for (; s.push(copy_date(l)), l.setUTCFullYear(l.getUTCFullYear() + 1), !(l > o); )
    ;
  return s;
}
class MonthsTicker extends SingleIntervalTicker {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize();
    const e = this.months;
    e.length > 1 ? this.interval = (e[1] - e[0]) * ONE_MONTH : this.interval = 12 * ONE_MONTH;
  }
  get_ticks_no_defaults(e, r, o, s) {
    const l = date_range_by_year(e, r), c = this.months, u = (Q) => c.map((m) => {
      const g = copy_date(Q);
      return g.setUTCMonth(m), g;
    });
    return {
      major: concat$1(l.map(u)).map((Q) => Q.getTime()).filter((Q) => e <= Q && Q <= r),
      minor: []
    };
  }
}
_a$3h = MonthsTicker;
MonthsTicker.__name__ = "MonthsTicker";
_a$3h.define(({ Int: t, Array: e }) => ({
  months: [e(t), []]
}));
class YearsTicker extends SingleIntervalTicker {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this.interval = ONE_YEAR, this.basic_ticker = new BasicTicker({ num_minor_ticks: 0 });
  }
  get_ticks_no_defaults(e, r, o, s) {
    const l = last_year_no_later_than(new Date(e)).getUTCFullYear(), c = last_year_no_later_than(new Date(r)).getUTCFullYear();
    return {
      major: this.basic_ticker.get_ticks_no_defaults(l, c, o, s).major.map((T) => Date.UTC(T, 0, 1)).filter((T) => e <= T && T <= r),
      minor: []
    };
  }
}
YearsTicker.__name__ = "YearsTicker";
var _a$3g;
class DatetimeTicker extends CompositeTicker {
  constructor(e) {
    super(e);
  }
}
_a$3g = DatetimeTicker;
DatetimeTicker.__name__ = "DatetimeTicker";
_a$3g.override({
  num_minor_ticks: 0,
  tickers: () => [
    new AdaptiveTicker({
      mantissas: [1, 2, 5],
      base: 10,
      min_interval: 0,
      max_interval: 500 * ONE_MILLI,
      num_minor_ticks: 0
    }),
    new AdaptiveTicker({
      mantissas: [1, 2, 5, 10, 15, 20, 30],
      base: 60,
      min_interval: ONE_SECOND,
      max_interval: 30 * ONE_MINUTE,
      num_minor_ticks: 0
    }),
    new AdaptiveTicker({
      mantissas: [1, 2, 4, 6, 8, 12],
      base: 24,
      min_interval: ONE_HOUR,
      max_interval: 12 * ONE_HOUR,
      num_minor_ticks: 0
    }),
    new DaysTicker({ days: range(1, 32) }),
    new DaysTicker({ days: range(1, 31, 3) }),
    new DaysTicker({ days: [1, 8, 15, 22] }),
    new DaysTicker({ days: [1, 15] }),
    new MonthsTicker({ months: range(0, 12, 1) }),
    new MonthsTicker({ months: range(0, 12, 2) }),
    new MonthsTicker({ months: range(0, 12, 4) }),
    new MonthsTicker({ months: range(0, 12, 6) }),
    new YearsTicker({})
  ]
});
var _a$3f;
class DatetimeAxisView extends LinearAxisView {
}
DatetimeAxisView.__name__ = "DatetimeAxisView";
class DatetimeAxis extends LinearAxis {
  constructor(e) {
    super(e);
  }
}
_a$3f = DatetimeAxis;
DatetimeAxis.__name__ = "DatetimeAxis";
_a$3f.prototype.default_view = DatetimeAxisView, _a$3f.override({
  ticker: () => new DatetimeTicker(),
  formatter: () => new DatetimeTickFormatter()
});
var _a$3e;
class LogTicker extends AdaptiveTicker {
  constructor(e) {
    super(e);
  }
  get_ticks_no_defaults(e, r, o, s) {
    const l = this.num_minor_ticks, c = [], u = this.base, d = Math.log(e) / Math.log(u), f = Math.log(r) / Math.log(u), T = f - d;
    let Q;
    if (!isFinite(T))
      Q = [];
    else if (T < 2) {
      const m = this.get_interval(e, r, s), g = Math.floor(e / m), v = Math.ceil(r / m);
      if (Q = range(g, v + 1).filter((b) => b != 0).map((b) => b * m).filter((b) => e <= b && b <= r), l > 0 && Q.length > 0) {
        const b = m / l, L = range(0, l).map((A) => A * b);
        for (const A of L.slice(1))
          c.push(Q[0] - A);
        for (const A of Q)
          for (const M of L)
            c.push(A + M);
      }
    } else {
      const m = Math.ceil(d * 0.999999), g = Math.floor(f * 1.000001), v = Math.ceil((g - m) / 9);
      if (Q = range(m - 1, g + 1, v).map((b) => u ** b), l > 0 && Q.length > 0) {
        const b = u ** v / l, L = range(1, l + 1).map((A) => A * b);
        for (const A of L)
          c.push(Q[0] / A);
        c.push(Q[0]);
        for (const A of Q)
          for (const M of L)
            c.push(A * M);
      }
    }
    return {
      major: Q.filter((m) => e <= m && m <= r),
      minor: c.filter((m) => e <= m && m <= r)
    };
  }
}
_a$3e = LogTicker;
LogTicker.__name__ = "LogTicker";
_a$3e.override({
  mantissas: [1, 5]
});
var _a$3d;
const { abs: abs$2, log, round: round$1 } = Math;
class LogTickFormatter extends TickFormatter {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this.basic_formatter = new BasicTickFormatter();
  }
  format_graphics(e, r) {
    var l, c;
    if (e.length == 0)
      return [];
    const o = (c = (l = this.ticker) == null ? void 0 : l.base) != null ? c : 10, s = this._exponents(e, o);
    return s == null ? this.basic_formatter.format_graphics(e, r) : s.map((u) => {
      if (abs$2(u) < this.min_exponent) {
        const d = new TextBox({ text: unicode_replace(`${o ** u}`) }), f = new TextBox({ text: "" });
        return new BaseExpo(d, f);
      } else {
        const d = new TextBox({ text: unicode_replace(`${o}`) }), f = new TextBox({ text: unicode_replace(`${u}`) });
        return new BaseExpo(d, f);
      }
    });
  }
  _exponents(e, r) {
    let o = null;
    const s = [];
    for (const l of e) {
      const c = round$1(log(l) / log(r));
      if (o != c)
        o = c, s.push(c);
      else
        return null;
    }
    return s;
  }
  doFormat(e, r) {
    var l, c;
    if (e.length == 0)
      return [];
    const o = (c = (l = this.ticker) == null ? void 0 : l.base) != null ? c : 10, s = this._exponents(e, o);
    return s == null ? this.basic_formatter.doFormat(e, r) : s.map((u) => abs$2(u) < this.min_exponent ? unicode_replace(`${o ** u}`) : unicode_replace(`${o}^${u}`));
  }
}
_a$3d = LogTickFormatter;
LogTickFormatter.__name__ = "LogTickFormatter";
_a$3d.define(({ Int: t, Ref: e, Nullable: r }) => ({
  ticker: [r(e(LogTicker)), null],
  min_exponent: [t, 0]
}));
var _a$3c;
class LogAxisView extends ContinuousAxisView {
}
LogAxisView.__name__ = "LogAxisView";
class LogAxis extends ContinuousAxis {
  constructor(e) {
    super(e);
  }
}
_a$3c = LogAxis;
LogAxis.__name__ = "LogAxis";
_a$3c.prototype.default_view = LogAxisView, _a$3c.override({
  ticker: () => new LogTicker(),
  formatter: () => new LogTickFormatter()
});
var _a$3b;
class MercatorTickFormatter extends BasicTickFormatter {
  constructor(e) {
    super(e);
  }
  doFormat(e, r) {
    if (this.dimension == null)
      throw new Error("MercatorTickFormatter.dimension not configured");
    if (e.length == 0)
      return [];
    const o = e.length, s = new Array(o);
    if (this.dimension == "lon")
      for (let l = 0; l < o; l++) {
        const [c] = wgs84_mercator.invert(e[l], r.loc);
        s[l] = c;
      }
    else
      for (let l = 0; l < o; l++) {
        const [, c] = wgs84_mercator.invert(r.loc, e[l]);
        s[l] = c;
      }
    return super.doFormat(s, r);
  }
}
_a$3b = MercatorTickFormatter;
MercatorTickFormatter.__name__ = "MercatorTickFormatter";
_a$3b.define(({ Nullable: t }) => ({
  dimension: [t(LatLon), null]
}));
var _a$3a;
class MercatorTicker extends BasicTicker {
  constructor(e) {
    super(e);
  }
  get_ticks_no_defaults(e, r, o, s) {
    if (this.dimension == null)
      throw new Error(`${this}.dimension wasn't configured`);
    return [e, r] = clip_mercator(e, r, this.dimension), this.dimension == "lon" ? this._get_ticks_lon(e, r, o, s) : this._get_ticks_lat(e, r, o, s);
  }
  _get_ticks_lon(e, r, o, s) {
    const [l] = wgs84_mercator.invert(e, o), [c, u] = wgs84_mercator.invert(r, o), d = super.get_ticks_no_defaults(l, c, o, s), f = [];
    for (const Q of d.major)
      if (in_bounds(Q, "lon")) {
        const [m] = wgs84_mercator.compute(Q, u);
        f.push(m);
      }
    const T = [];
    for (const Q of d.minor)
      if (in_bounds(Q, "lon")) {
        const [m] = wgs84_mercator.compute(Q, u);
        T.push(m);
      }
    return { major: f, minor: T };
  }
  _get_ticks_lat(e, r, o, s) {
    const [, l] = wgs84_mercator.invert(o, e), [c, u] = wgs84_mercator.invert(o, r), d = super.get_ticks_no_defaults(l, u, o, s), f = [];
    for (const Q of d.major)
      if (in_bounds(Q, "lat")) {
        const [, m] = wgs84_mercator.compute(c, Q);
        f.push(m);
      }
    const T = [];
    for (const Q of d.minor)
      if (in_bounds(Q, "lat")) {
        const [, m] = wgs84_mercator.compute(c, Q);
        T.push(m);
      }
    return { major: f, minor: T };
  }
}
_a$3a = MercatorTicker;
MercatorTicker.__name__ = "MercatorTicker";
_a$3a.define(({ Nullable: t }) => ({
  dimension: [t(LatLon), null]
}));
var _a$39;
class MercatorAxisView extends AxisView {
}
MercatorAxisView.__name__ = "MercatorAxisView";
class MercatorAxis extends LinearAxis {
  constructor(e) {
    super(e);
  }
}
_a$39 = MercatorAxis;
MercatorAxis.__name__ = "MercatorAxis";
_a$39.prototype.default_view = MercatorAxisView, _a$39.override({
  ticker: () => new MercatorTicker({ dimension: "lat" }),
  formatter: () => new MercatorTickFormatter({ dimension: "lat" })
});
var _a$38;
class FixedTicker extends ContinuousTicker {
  constructor(e) {
    super(e);
  }
  get_ticks_no_defaults(e, r, o, s) {
    return {
      major: this.ticks,
      minor: this.minor_ticks
    };
  }
  get_interval(e, r, o) {
    return 0;
  }
  get_min_interval() {
    return 0;
  }
  get_max_interval() {
    return 0;
  }
}
_a$38 = FixedTicker;
FixedTicker.__name__ = "FixedTicker";
_a$38.define(({ Number: t, Array: e }) => ({
  ticks: [e(t), []],
  minor_ticks: [e(t), []]
}));
class Mapper extends Transform {
  constructor(e) {
    super(e);
  }
  compute(e) {
    throw new Error("mapping single values is not supported");
  }
}
Mapper.__name__ = "Mapper";
var _a$37;
function _convert_color(t) {
  return encode_rgba(color2rgba(t));
}
function _convert_palette(t) {
  const e = new Uint32Array(t.length);
  for (let r = 0, o = t.length; r < o; r++)
    e[r] = _convert_color(t[r]);
  return e;
}
class ColorMapper extends Mapper {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this.metrics_change = new Signal0(this, "metrics_change");
  }
  v_compute(e) {
    const r = new Array(e.length);
    return this._v_compute(e, r, this.palette, this._colors((o) => o)), r;
  }
  get rgba_mapper() {
    const e = this, r = _convert_palette(this.palette), o = this._colors(_convert_color);
    return {
      v_compute(s) {
        const l = new ColorArray(s.length);
        return e._v_compute(s, l, r, o), new Uint8ClampedArray(to_big_endian(l).buffer);
      }
    };
  }
  _colors(e) {
    return { nan_color: e(this.nan_color) };
  }
}
_a$37 = ColorMapper;
ColorMapper.__name__ = "ColorMapper";
_a$37.define(({ Color: t, Array: e }) => ({
  palette: [e(t)],
  nan_color: [t, "gray"]
}));
var _a$36;
class DataRendererView extends RendererView {
  get xscale() {
    return this.coordinates.x_scale;
  }
  get yscale() {
    return this.coordinates.y_scale;
  }
}
DataRendererView.__name__ = "DataRendererView";
class DataRenderer extends Renderer {
  constructor(e) {
    super(e);
  }
  get selection_manager() {
    return this.get_selection_manager();
  }
}
_a$36 = DataRenderer;
DataRenderer.__name__ = "DataRenderer";
_a$36.override({
  level: "glyph"
});
var _a$35;
class RaggedArray {
  constructor(e, r) {
    this.offsets = e, this.array = r;
  }
  [(_a$35 = Symbol.toStringTag, equals)](e, r) {
    return r.arrays(this.offsets, e.offsets) && r.arrays(this.array, e.array);
  }
  get length() {
    return this.offsets.length;
  }
  clone() {
    return new RaggedArray(this.offsets.slice(), this.array.slice());
  }
  static from(e, r) {
    const o = e.length;
    let s = 0;
    const l = (() => {
      const u = new Uint32Array(o);
      for (let d = 0; d < o; d++) {
        const f = e[d].length;
        u[d] = s, s += f;
      }
      return s < 256 ? new Uint8Array(u) : s < 65536 ? new Uint16Array(u) : u;
    })(), c = new r(s);
    for (let u = 0; u < o; u++)
      c.set(e[u], l[u]);
    return new RaggedArray(l, c);
  }
  *[Symbol.iterator]() {
    const { offsets: e, length: r } = this;
    for (let o = 0; o < r; o++)
      yield this.array.subarray(e[o], e[o + 1]);
  }
  _check_bounds(e) {
    assert(0 <= e && e < this.length, `Out of bounds: 0 <= ${e} < ${this.length}`);
  }
  get(e) {
    this._check_bounds(e);
    const { offsets: r } = this;
    return this.array.subarray(r[e], r[e + 1]);
  }
  set(e, r) {
    this._check_bounds(e), this.array.set(r, this.offsets[e]);
  }
}
RaggedArray.__name__ = "RaggedArray";
RaggedArray[_a$35] = "RaggedArray";
class FlatQueue {
  constructor() {
    this.ids = [], this.values = [], this.length = 0;
  }
  clear() {
    this.length = 0;
  }
  push(e, r) {
    let o = this.length++;
    for (this.ids[o] = e, this.values[o] = r; o > 0; ) {
      const s = o - 1 >> 1, l = this.values[s];
      if (r >= l)
        break;
      this.ids[o] = this.ids[s], this.values[o] = l, o = s;
    }
    this.ids[o] = e, this.values[o] = r;
  }
  pop() {
    if (this.length === 0)
      return;
    const e = this.ids[0];
    if (this.length--, this.length > 0) {
      const r = this.ids[0] = this.ids[this.length], o = this.values[0] = this.values[this.length], s = this.length >> 1;
      let l = 0;
      for (; l < s; ) {
        let c = (l << 1) + 1;
        const u = c + 1;
        let d = this.ids[c], f = this.values[c];
        const T = this.values[u];
        if (u < this.length && T < f && (c = u, d = this.ids[u], f = T), f >= o)
          break;
        this.ids[l] = d, this.values[l] = f, l = c;
      }
      this.ids[l] = r, this.values[l] = o;
    }
    return e;
  }
  peek() {
    if (this.length !== 0)
      return this.ids[0];
  }
  peekValue() {
    if (this.length !== 0)
      return this.values[0];
  }
}
const ARRAY_TYPES = [
  Int8Array,
  Uint8Array,
  Uint8ClampedArray,
  Int16Array,
  Uint16Array,
  Int32Array,
  Uint32Array,
  Float32Array,
  Float64Array
], VERSION = 3;
class Flatbush {
  static from(e) {
    if (!(e instanceof ArrayBuffer))
      throw new Error("Data must be an instance of ArrayBuffer.");
    const [r, o] = new Uint8Array(e, 0, 2);
    if (r !== 251)
      throw new Error("Data does not appear to be in a Flatbush format.");
    if (o >> 4 !== VERSION)
      throw new Error(`Got v${o >> 4} data when expected v${VERSION}.`);
    const [s] = new Uint16Array(e, 2, 1), [l] = new Uint32Array(e, 4, 1);
    return new Flatbush(l, s, ARRAY_TYPES[o & 15], e);
  }
  constructor(e, r = 16, o = Float64Array, s) {
    if (e === void 0)
      throw new Error("Missing required argument: numItems.");
    if (isNaN(e) || e <= 0)
      throw new Error(`Unpexpected numItems value: ${e}.`);
    this.numItems = +e, this.nodeSize = Math.min(Math.max(+r, 2), 65535);
    let l = e, c = l;
    this._levelBounds = [l * 4];
    do
      l = Math.ceil(l / this.nodeSize), c += l, this._levelBounds.push(c * 4);
    while (l !== 1);
    this.ArrayType = o || Float64Array, this.IndexArrayType = c < 16384 ? Uint16Array : Uint32Array;
    const u = ARRAY_TYPES.indexOf(this.ArrayType), d = c * 4 * this.ArrayType.BYTES_PER_ELEMENT;
    if (u < 0)
      throw new Error(`Unexpected typed array class: ${o}.`);
    s && s instanceof ArrayBuffer ? (this.data = s, this._boxes = new this.ArrayType(this.data, 8, c * 4), this._indices = new this.IndexArrayType(this.data, 8 + d, c), this._pos = c * 4, this.minX = this._boxes[this._pos - 4], this.minY = this._boxes[this._pos - 3], this.maxX = this._boxes[this._pos - 2], this.maxY = this._boxes[this._pos - 1]) : (this.data = new ArrayBuffer(8 + d + c * this.IndexArrayType.BYTES_PER_ELEMENT), this._boxes = new this.ArrayType(this.data, 8, c * 4), this._indices = new this.IndexArrayType(this.data, 8 + d, c), this._pos = 0, this.minX = 1 / 0, this.minY = 1 / 0, this.maxX = -1 / 0, this.maxY = -1 / 0, new Uint8Array(this.data, 0, 2).set([251, (VERSION << 4) + u]), new Uint16Array(this.data, 2, 1)[0] = r, new Uint32Array(this.data, 4, 1)[0] = e), this._queue = new FlatQueue();
  }
  add(e, r, o, s) {
    const l = this._pos >> 2;
    return this._indices[l] = l, this._boxes[this._pos++] = e, this._boxes[this._pos++] = r, this._boxes[this._pos++] = o, this._boxes[this._pos++] = s, e < this.minX && (this.minX = e), r < this.minY && (this.minY = r), o > this.maxX && (this.maxX = o), s > this.maxY && (this.maxY = s), l;
  }
  finish() {
    if (this._pos >> 2 !== this.numItems)
      throw new Error(`Added ${this._pos >> 2} items when expected ${this.numItems}.`);
    if (this.numItems <= this.nodeSize) {
      this._boxes[this._pos++] = this.minX, this._boxes[this._pos++] = this.minY, this._boxes[this._pos++] = this.maxX, this._boxes[this._pos++] = this.maxY;
      return;
    }
    const e = this.maxX - this.minX || 1, r = this.maxY - this.minY || 1, o = new Uint32Array(this.numItems), s = (1 << 16) - 1;
    for (let l = 0; l < this.numItems; l++) {
      let c = 4 * l;
      const u = this._boxes[c++], d = this._boxes[c++], f = this._boxes[c++], T = this._boxes[c++], Q = Math.floor(s * ((u + f) / 2 - this.minX) / e), m = Math.floor(s * ((d + T) / 2 - this.minY) / r);
      o[l] = hilbert(Q, m);
    }
    sort(o, this._boxes, this._indices, 0, this.numItems - 1, this.nodeSize);
    for (let l = 0, c = 0; l < this._levelBounds.length - 1; l++) {
      const u = this._levelBounds[l];
      for (; c < u; ) {
        const d = c;
        let f = 1 / 0, T = 1 / 0, Q = -1 / 0, m = -1 / 0;
        for (let g = 0; g < this.nodeSize && c < u; g++)
          f = Math.min(f, this._boxes[c++]), T = Math.min(T, this._boxes[c++]), Q = Math.max(Q, this._boxes[c++]), m = Math.max(m, this._boxes[c++]);
        this._indices[this._pos >> 2] = d, this._boxes[this._pos++] = f, this._boxes[this._pos++] = T, this._boxes[this._pos++] = Q, this._boxes[this._pos++] = m;
      }
    }
  }
  search(e, r, o, s, l) {
    if (this._pos !== this._boxes.length)
      throw new Error("Data not yet indexed - call index.finish().");
    let c = this._boxes.length - 4;
    const u = [], d = [];
    for (; c !== void 0; ) {
      const f = Math.min(c + this.nodeSize * 4, upperBound$1(c, this._levelBounds));
      for (let T = c; T < f; T += 4) {
        const Q = this._indices[T >> 2] | 0;
        o < this._boxes[T] || s < this._boxes[T + 1] || e > this._boxes[T + 2] || r > this._boxes[T + 3] || (c < this.numItems * 4 ? (l === void 0 || l(Q)) && d.push(Q) : u.push(Q));
      }
      c = u.pop();
    }
    return d;
  }
  neighbors(e, r, o = 1 / 0, s = 1 / 0, l) {
    if (this._pos !== this._boxes.length)
      throw new Error("Data not yet indexed - call index.finish().");
    let c = this._boxes.length - 4;
    const u = this._queue, d = [], f = s * s;
    for (; c !== void 0; ) {
      const T = Math.min(c + this.nodeSize * 4, upperBound$1(c, this._levelBounds));
      for (let Q = c; Q < T; Q += 4) {
        const m = this._indices[Q >> 2] | 0, g = axisDist(e, this._boxes[Q], this._boxes[Q + 2]), v = axisDist(r, this._boxes[Q + 1], this._boxes[Q + 3]), b = g * g + v * v;
        c < this.numItems * 4 ? (l === void 0 || l(m)) && u.push((m << 1) + 1, b) : u.push(m << 1, b);
      }
      for (; u.length && u.peek() & 1; )
        if (u.peekValue() > f || (d.push(u.pop() >> 1), d.length === o))
          return u.clear(), d;
      c = u.pop() >> 1;
    }
    return u.clear(), d;
  }
}
function axisDist(t, e, r) {
  return t < e ? e - t : t <= r ? 0 : t - r;
}
function upperBound$1(t, e) {
  let r = 0, o = e.length - 1;
  for (; r < o; ) {
    const s = r + o >> 1;
    e[s] > t ? o = s : r = s + 1;
  }
  return e[r];
}
function sort(t, e, r, o, s, l) {
  if (Math.floor(o / l) >= Math.floor(s / l))
    return;
  const c = t[o + s >> 1];
  let u = o - 1, d = s + 1;
  for (; ; ) {
    do
      u++;
    while (t[u] < c);
    do
      d--;
    while (t[d] > c);
    if (u >= d)
      break;
    swap(t, e, r, u, d);
  }
  sort(t, e, r, o, d, l), sort(t, e, r, d + 1, s, l);
}
function swap(t, e, r, o, s) {
  const l = t[o];
  t[o] = t[s], t[s] = l;
  const c = 4 * o, u = 4 * s, d = e[c], f = e[c + 1], T = e[c + 2], Q = e[c + 3];
  e[c] = e[u], e[c + 1] = e[u + 1], e[c + 2] = e[u + 2], e[c + 3] = e[u + 3], e[u] = d, e[u + 1] = f, e[u + 2] = T, e[u + 3] = Q;
  const m = r[o];
  r[o] = r[s], r[s] = m;
}
function hilbert(t, e) {
  let r = t ^ e, o = 65535 ^ r, s = 65535 ^ (t | e), l = t & (e ^ 65535), c = r | o >> 1, u = r >> 1 ^ r, d = s >> 1 ^ o & l >> 1 ^ s, f = r & s >> 1 ^ l >> 1 ^ l;
  r = c, o = u, s = d, l = f, c = r & r >> 2 ^ o & o >> 2, u = r & o >> 2 ^ o & (r ^ o) >> 2, d ^= r & s >> 2 ^ o & l >> 2, f ^= o & s >> 2 ^ (r ^ o) & l >> 2, r = c, o = u, s = d, l = f, c = r & r >> 4 ^ o & o >> 4, u = r & o >> 4 ^ o & (r ^ o) >> 4, d ^= r & s >> 4 ^ o & l >> 4, f ^= o & s >> 4 ^ (r ^ o) & l >> 4, r = c, o = u, s = d, l = f, d ^= r & s >> 8 ^ o & l >> 8, f ^= o & s >> 8 ^ (r ^ o) & l >> 8, r = d ^ d >> 1, o = f ^ f >> 1;
  let T = t ^ e, Q = o | 65535 ^ (T | r);
  return T = (T | T << 8) & 16711935, T = (T | T << 4) & 252645135, T = (T | T << 2) & 858993459, T = (T | T << 1) & 1431655765, Q = (Q | Q << 8) & 16711935, Q = (Q | Q << 4) & 252645135, Q = (Q | Q << 2) & 858993459, Q = (Q | Q << 1) & 1431655765, (Q << 1 | T) >>> 0;
}
function upperBound(t, e) {
  let r = 0, o = e.length - 1;
  for (; r < o; ) {
    const s = r + o >> 1;
    e[s] > t ? o = s : r = s + 1;
  }
  return e[r];
}
class _FlatBush extends Flatbush {
  get boxes() {
    return this._boxes;
  }
  search_indices(e, r, o, s) {
    if (this._pos !== this._boxes.length)
      throw new Error("Data not yet indexed - call index.finish().");
    let l = this._boxes.length - 4;
    const c = [], u = new BitSet(this.numItems);
    for (; l !== void 0; ) {
      const d = Math.min(l + this.nodeSize * 4, upperBound(l, this._levelBounds));
      for (let f = l; f < d; f += 4) {
        const T = this._indices[f >> 2] | 0, Q = this._boxes[f + 0], m = this._boxes[f + 1], g = this._boxes[f + 2], v = this._boxes[f + 3];
        o < Q || s < m || e > g || r > v || (l < this.numItems * 4 ? u.set(T) : c.push(T));
      }
      l = c.pop();
    }
    return u;
  }
}
_FlatBush.__name__ = "_FlatBush";
class SpatialIndex {
  constructor(e) {
    this.index = null, e > 0 && (this.index = new _FlatBush(e));
  }
  add_rect(e, r, o, s) {
    var l;
    isFinite(e + r + o + s) ? (l = this.index) == null || l.add(e, r, o, s) : this.add_empty();
  }
  add_point(e, r) {
    var o;
    isFinite(e + r) ? (o = this.index) == null || o.add(e, r, e, r) : this.add_empty();
  }
  add_empty() {
    var e;
    (e = this.index) == null || e.add(1 / 0, 1 / 0, -1 / 0, -1 / 0);
  }
  finish() {
    var e;
    (e = this.index) == null || e.finish();
  }
  _normalize(e) {
    let { x0: r, y0: o, x1: s, y1: l } = e;
    return r > s && ([r, s] = [s, r]), o > l && ([o, l] = [l, o]), { x0: r, y0: o, x1: s, y1: l };
  }
  get bbox() {
    if (this.index == null)
      return empty();
    {
      const { minX: e, minY: r, maxX: o, maxY: s } = this.index;
      return { x0: e, y0: r, x1: o, y1: s };
    }
  }
  indices(e) {
    if (this.index == null)
      return new BitSet(0);
    {
      const { x0: r, y0: o, x1: s, y1: l } = this._normalize(e);
      return this.index.search_indices(r, o, s, l);
    }
  }
  bounds(e) {
    const r = empty();
    if (this.index == null)
      return r;
    const { boxes: o } = this.index;
    for (const s of this.indices(e)) {
      const l = o[4 * s + 0], c = o[4 * s + 1], u = o[4 * s + 2], d = o[4 * s + 3];
      l >= e.x0 && l < r.x0 && (r.x0 = l), u <= e.x1 && u > r.x1 && (r.x1 = u), c >= e.y0 && c < r.y0 && (r.y0 = c), d <= e.y1 && d > r.y1 && (r.y1 = d);
    }
    return r;
  }
}
SpatialIndex.__name__ = "SpatialIndex";
const { abs: abs$1, ceil } = Math;
class GlyphView extends View {
  constructor() {
    super(...arguments), this._index = null, this._data_size = null, this._nohit_warned = /* @__PURE__ */ new Set();
  }
  get renderer() {
    return this.parent;
  }
  get has_webgl() {
    return this.glglyph != null;
  }
  get index() {
    const { _index: e } = this;
    if (e != null)
      return e;
    throw new Error(`${this}.index_data() wasn't called`);
  }
  get data_size() {
    const { _data_size: e } = this;
    if (e != null)
      return e;
    throw new Error(`${this}.set_data() wasn't called`);
  }
  initialize() {
    super.initialize(), this.visuals = new Visuals(this);
  }
  request_render() {
    this.parent.request_render();
  }
  get canvas() {
    return this.renderer.parent.canvas_view;
  }
  render(e, r, o) {
    var s;
    this.glglyph != null && (this.renderer.needs_webgl_blit = this.glglyph.render(e, r, (s = this.base) != null ? s : this), this.renderer.needs_webgl_blit) || this._render(e, r, o != null ? o : this.base);
  }
  has_finished() {
    return !0;
  }
  notify_finished() {
    this.renderer.notify_finished();
  }
  _bounds(e) {
    return e;
  }
  bounds() {
    return this._bounds(this.index.bbox);
  }
  log_bounds() {
    const { x0: e, x1: r } = this.index.bounds(positive_x()), { y0: o, y1: s } = this.index.bounds(positive_y());
    return this._bounds({ x0: e, y0: o, x1: r, y1: s });
  }
  get_anchor_point(e, r, [o, s]) {
    switch (e) {
      case "center":
      case "center_center": {
        const [l, c] = this.scenterxy(r, o, s);
        return { x: l, y: c };
      }
      default:
        return null;
    }
  }
  scenterx(e, r, o) {
    return this.scenterxy(e, r, o)[0];
  }
  scentery(e, r, o) {
    return this.scenterxy(e, r, o)[1];
  }
  sdist(e, r, o, s = "edge", l = !1) {
    const c = r.length, u = new ScreenArray(c), d = e.s_compute;
    if (s == "center")
      for (let f = 0; f < c; f++) {
        const T = r[f], Q = o.get(f) / 2, m = d(T - Q), g = d(T + Q);
        u[f] = abs$1(g - m);
      }
    else
      for (let f = 0; f < c; f++) {
        const T = r[f], Q = d(T), m = d(T + o.get(f));
        u[f] = abs$1(m - Q);
      }
    return l && inplace_map(u, (f) => ceil(f)), u;
  }
  draw_legend_for_index(e, r, o) {
  }
  hit_test(e) {
    switch (e.type) {
      case "point":
        if (this._hit_point != null)
          return this._hit_point(e);
        break;
      case "span":
        if (this._hit_span != null)
          return this._hit_span(e);
        break;
      case "rect":
        if (this._hit_rect != null)
          return this._hit_rect(e);
        break;
      case "poly":
        if (this._hit_poly != null)
          return this._hit_poly(e);
        break;
    }
    return this._nohit_warned.has(e.type) || (logger.debug(`'${e.type}' selection not available for ${this.model.type}`), this._nohit_warned.add(e.type)), null;
  }
  _hit_rect_against_index(e) {
    const { sx0: r, sx1: o, sy0: s, sy1: l } = e, [c, u] = this.renderer.coordinates.x_scale.r_invert(r, o), [d, f] = this.renderer.coordinates.y_scale.r_invert(s, l), T = [...this.index.indices({ x0: c, x1: u, y0: d, y1: f })];
    return new Selection({ indices: T });
  }
  _project_data() {
  }
  *_iter_visuals() {
    for (const e of this.visuals)
      for (const r of e)
        (r instanceof VectorSpec || r instanceof ScalarSpec) && (yield r);
  }
  set_base(e) {
    e != this && e instanceof this.constructor && (this.base = e);
  }
  _configure(e, r) {
    Object.defineProperty(this, isString(e) ? e : e.attr, {
      configurable: !0,
      enumerable: !0,
      ...r
    });
  }
  set_visuals(e, r) {
    var o;
    for (const s of this._iter_visuals()) {
      const { base: l } = this;
      if (l != null) {
        const u = l.model.properties[s.attr];
        if (u != null && is_equal(s.get_value(), u.get_value())) {
          this._configure(s, {
            get() {
              return l[`${s.attr}`];
            }
          });
          continue;
        }
      }
      const c = s.uniform(e).select(r);
      this._configure(s, { value: c });
    }
    for (const s of this.visuals)
      s.update();
    (o = this.glglyph) == null || o.set_visuals_changed();
  }
  set_data(e, r, o) {
    var u;
    const { x_source: s, y_source: l } = this.renderer.coordinates, c = new Set(this._iter_visuals());
    this._data_size = r.count;
    for (const d of this.model)
      if ((d instanceof VectorSpec || d instanceof ScalarSpec) && !c.has(d))
        if (d instanceof BaseCoordinateSpec) {
          const f = d.array(e);
          let T = r.select(f);
          const Q = d.dimension == "x" ? s : l;
          if (Q instanceof FactorRange) {
            if (d instanceof CoordinateSpec)
              T = Q.v_synthetic(T);
            else if (d instanceof CoordinateSeqSpec)
              for (let g = 0; g < T.length; g++)
                T[g] = Q.v_synthetic(T[g]);
          }
          let m;
          d instanceof CoordinateSeqSpec ? m = RaggedArray.from(T, Float64Array) : m = T, this._configure(`_${d.attr}`, { value: m });
        } else {
          const f = d.uniform(e).select(r);
          if (this._configure(d, { value: f }), d instanceof DistanceSpec) {
            const T = f.is_Scalar() ? f.value : max$8(f.array);
            this._configure(`max_${d.attr}`, { value: T });
          }
        }
    this.renderer.plot_view.model.use_map && this._project_data(), this._set_data(o != null ? o : null), (u = this.glglyph) == null || u.set_data_changed(), this.index_data();
  }
  _set_data(e) {
  }
  get _index_size() {
    return this.data_size;
  }
  index_data() {
    const e = new SpatialIndex(this._index_size);
    this._index_data(e), e.finish(), this._index = e;
  }
  mask_data() {
    return this._mask_data == null ? BitSet.all_set(this.data_size) : this._mask_data();
  }
  map_data() {
    var s;
    const e = this, { x_scale: r, y_scale: o } = this.renderer.coordinates;
    for (const l of this.model)
      if (l instanceof BaseCoordinateSpec) {
        const c = l.dimension == "x" ? r : o;
        let u = e[`_${l.attr}`];
        if (u instanceof RaggedArray) {
          const d = c.v_compute(u.array);
          u = new RaggedArray(u.offsets, d);
        } else
          u = c.v_compute(u);
        this[`s${l.attr}`] = u;
      }
    this._map_data(), (s = this.glglyph) == null || s.set_data_changed();
  }
  _map_data() {
  }
}
GlyphView.__name__ = "GlyphView";
class Glyph extends Model {
  constructor(e) {
    super(e);
  }
}
Glyph.__name__ = "Glyph";
var _a$34;
class XYGlyphView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._x, this._y);
  }
  _index_data(e) {
    const { _x: r, _y: o, data_size: s } = this;
    for (let l = 0; l < s; l++) {
      const c = r[l], u = o[l];
      e.add_point(c, u);
    }
  }
  scenterxy(e) {
    return [this.sx[e], this.sy[e]];
  }
}
XYGlyphView.__name__ = "XYGlyphView";
class XYGlyph extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$34 = XYGlyph;
XYGlyph.__name__ = "XYGlyph";
_a$34.define(({}) => ({
  x: [XCoordinateSpec, { field: "x" }],
  y: [YCoordinateSpec, { field: "y" }]
}));
function point_in_poly(t, e, r, o) {
  let s = !1, l = r[r.length - 1], c = o[o.length - 1];
  for (let u = 0; u < r.length; u++) {
    const d = r[u], f = o[u];
    c < e != f < e && l + (e - c) / (f - c) * (d - l) < t && (s = !s), l = d, c = f;
  }
  return s;
}
function point_in_ellipse(t, e, r, o, s, l, c) {
  const u = (Math.cos(r) / s) ** 2 + (Math.sin(r) / o) ** 2, d = 2 * Math.cos(r) * Math.sin(r) * ((1 / s) ** 2 - (1 / o) ** 2), f = (Math.cos(r) / o) ** 2 + (Math.sin(r) / s) ** 2;
  return u * (t - l) ** 2 + d * (t - l) * (e - c) + f * (e - c) ** 2 <= 1;
}
function dist_2_pts(t, e) {
  return (t.x - e.x) ** 2 + (t.y - e.y) ** 2;
}
function dist_to_segment_squared(t, e, r) {
  const o = dist_2_pts(e, r);
  if (o == 0)
    return dist_2_pts(t, e);
  const s = ((t.x - e.x) * (r.x - e.x) + (t.y - e.y) * (r.y - e.y)) / o;
  if (s < 0)
    return dist_2_pts(t, e);
  if (s > 1)
    return dist_2_pts(t, r);
  const l = { x: e.x + s * (r.x - e.x), y: e.y + s * (r.y - e.y) };
  return dist_2_pts(t, l);
}
function dist_to_segment(t, e, r) {
  return Math.sqrt(dist_to_segment_squared(t, e, r));
}
function check_2_segments_intersect(t, e, r, o, s, l, c, u) {
  const d = (u - l) * (r - t) - (c - s) * (o - e);
  if (d == 0)
    return { hit: !1, x: null, y: null };
  {
    let f = e - l, T = t - s;
    const Q = (c - s) * f - (u - l) * T, m = (r - t) * f - (o - e) * T;
    f = Q / d, T = m / d;
    const g = t + f * (r - t), v = e + f * (o - e);
    return { hit: f > 0 && f < 1 && T > 0 && T < 1, x: g, y: v };
  }
}
function generic_line_scalar_legend(t, e, { x0: r, x1: o, y0: s, y1: l }) {
  e.save(), e.beginPath(), e.moveTo(r, (s + l) / 2), e.lineTo(o, (s + l) / 2), t.line.apply(e), e.restore();
}
function generic_line_vector_legend(t, e, { x0: r, x1: o, y0: s, y1: l }, c) {
  e.save(), e.beginPath(), e.moveTo(r, (s + l) / 2), e.lineTo(o, (s + l) / 2), t.line.apply(e, c), e.restore();
}
function generic_area_scalar_legend(t, e, { x0: r, x1: o, y0: s, y1: l }) {
  var v, b;
  const u = Math.abs(o - r) * 0.1, f = Math.abs(l - s) * 0.1, T = r + u, Q = o - u, m = s + f, g = l - f;
  e.beginPath(), e.rect(T, m, Q - T, g - m), t.fill.apply(e), (v = t.hatch) == null || v.apply(e), (b = t.line) == null || b.apply(e);
}
function generic_area_vector_legend(t, e, { x0: r, x1: o, y0: s, y1: l }, c) {
  var b, L;
  const d = Math.abs(o - r) * 0.1, T = Math.abs(l - s) * 0.1, Q = r + d, m = o - d, g = s + T, v = l - T;
  e.beginPath(), e.rect(Q, g, m - Q, v - g), t.fill.apply(e, c), (b = t.hatch) == null || b.apply(e, c), (L = t.line) == null || L.apply(e, c);
}
function line_interpolation(t, e, r, o, s, l) {
  const { sx: c, sy: u } = e;
  let d, f, T, Q;
  e.type == "point" ? ([T, Q] = t.yscale.r_invert(u - 1, u + 1), [d, f] = t.xscale.r_invert(c - 1, c + 1)) : e.direction == "v" ? ([T, Q] = t.yscale.r_invert(u, u), [d, f] = [Math.min(r - 1, s - 1), Math.max(r + 1, s + 1)]) : ([d, f] = t.xscale.r_invert(c, c), [T, Q] = [Math.min(o - 1, l - 1), Math.max(o + 1, l + 1)]);
  const { x: m, y: g } = check_2_segments_intersect(d, T, f, Q, r, o, s, l);
  return [m, g];
}
var _a$33;
class LineView extends XYGlyphView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl: e } = this.renderer.plot_view.canvas_view;
    if (e != null && e.regl_wrapper.has_webgl) {
      const { LineGL: r } = await Promise.resolve().then(() => line_gl);
      this.glglyph = new r(e.regl_wrapper, this);
    }
  }
  _render(e, r, o) {
    const { sx: s, sy: l } = o != null ? o : this;
    let c = null;
    const u = (f) => c != null && f - c != 1;
    let d = !0;
    e.beginPath();
    for (const f of r) {
      const T = s[f], Q = l[f];
      isFinite(T + Q) ? d || u(f) ? (e.moveTo(T, Q), d = !1) : e.lineTo(T, Q) : d = !0, c = f;
    }
    this.visuals.line.set_value(e), e.stroke();
  }
  _hit_point(e) {
    const r = new Selection(), o = { x: e.sx, y: e.sy };
    let s = 9999;
    const l = Math.max(2, this.line_width.value / 2);
    for (let c = 0, u = this.sx.length - 1; c < u; c++) {
      const d = { x: this.sx[c], y: this.sy[c] }, f = { x: this.sx[c + 1], y: this.sy[c + 1] }, T = dist_to_segment(o, d, f);
      T < l && T < s && (s = T, r.add_to_selected_glyphs(this.model), r.view = this, r.line_indices = [c]);
    }
    return r;
  }
  _hit_span(e) {
    const { sx: r, sy: o } = e, s = new Selection();
    let l, c;
    e.direction == "v" ? (l = this.renderer.yscale.invert(o), c = this._y) : (l = this.renderer.xscale.invert(r), c = this._x);
    for (let u = 0, d = c.length - 1; u < d; u++)
      (c[u] <= l && l <= c[u + 1] || c[u + 1] <= l && l <= c[u]) && (s.add_to_selected_glyphs(this.model), s.view = this, s.line_indices.push(u));
    return s;
  }
  get_interpolation_hit(e, r) {
    const [o, s, l, c] = [this._x[e], this._y[e], this._x[e + 1], this._y[e + 1]];
    return line_interpolation(this.renderer, r, o, s, l, c);
  }
  draw_legend_for_index(e, r, o) {
    generic_line_scalar_legend(this.visuals, e, r);
  }
}
LineView.__name__ = "LineView";
class Line extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$33 = Line;
Line.__name__ = "Line";
_a$33.prototype.default_view = LineView, _a$33.mixins(LineScalar$1);
var _a$32;
class PatchView extends XYGlyphView {
  _render(e, r, o) {
    const { sx: s, sy: l } = o != null ? o : this;
    let c = !0;
    e.beginPath();
    for (const u of r) {
      const d = s[u], f = l[u];
      isFinite(d + f) ? c ? (e.moveTo(d, f), c = !1) : e.lineTo(d, f) : (e.closePath(), c = !0);
    }
    e.closePath(), this.visuals.fill.apply(e), this.visuals.hatch.apply(e), this.visuals.line.apply(e);
  }
  draw_legend_for_index(e, r, o) {
    generic_area_scalar_legend(this.visuals, e, r);
  }
  _hit_point(e) {
    const r = new Selection();
    return point_in_poly(e.sx, e.sy, this.sx, this.sy) && (r.add_to_selected_glyphs(this.model), r.view = this), r;
  }
}
PatchView.__name__ = "PatchView";
class Patch extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$32 = Patch;
Patch.__name__ = "Patch";
_a$32.prototype.default_view = PatchView, _a$32.mixins([LineScalar$1, FillScalar$1, HatchScalar$1]);
var _a$31;
class AreaView extends GlyphView {
  draw_legend_for_index(e, r, o) {
    generic_area_scalar_legend(this.visuals, e, r);
  }
}
AreaView.__name__ = "AreaView";
class Area extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$31 = Area;
Area.__name__ = "Area";
_a$31.mixins([FillScalar$1, HatchScalar$1]);
var _a$30;
class HAreaView extends AreaView {
  _index_data(e) {
    const { min: r, max: o } = Math, { data_size: s } = this;
    for (let l = 0; l < s; l++) {
      const c = this._x1[l], u = this._x2[l], d = this._y[l];
      e.add_rect(r(c, u), d, o(c, u), d);
    }
  }
  _render(e, r, o) {
    const { sx1: s, sx2: l, sy: c } = o != null ? o : this;
    e.beginPath();
    for (let u = 0, d = s.length; u < d; u++)
      e.lineTo(s[u], c[u]);
    for (let u = l.length - 1; u >= 0; u--)
      e.lineTo(l[u], c[u]);
    e.closePath(), this.visuals.fill.apply(e), this.visuals.hatch.apply(e);
  }
  _hit_point(e) {
    const r = this.sy.length, o = new Selection();
    for (let s = 0, l = r - 1; s < l; s++) {
      const c = [this.sx1[s], this.sx1[s + 1], this.sx2[s + 1], this.sx2[s]], u = [this.sy[s], this.sy[s + 1], this.sy[s + 1], this.sy[s]];
      if (point_in_poly(e.sx, e.sy, c, u)) {
        o.add_to_selected_glyphs(this.model), o.view = this, o.line_indices = [s];
        break;
      }
    }
    return o;
  }
  scenterxy(e) {
    const r = (this.sx1[e] + this.sx2[e]) / 2, o = this.sy[e];
    return [r, o];
  }
  _map_data() {
    this.sx1 = this.renderer.xscale.v_compute(this._x1), this.sx2 = this.renderer.xscale.v_compute(this._x2), this.sy = this.renderer.yscale.v_compute(this._y);
  }
}
HAreaView.__name__ = "HAreaView";
class HArea extends Area {
  constructor(e) {
    super(e);
  }
}
_a$30 = HArea;
HArea.__name__ = "HArea";
_a$30.prototype.default_view = HAreaView, _a$30.define(({}) => ({
  x1: [XCoordinateSpec, { field: "x1" }],
  x2: [XCoordinateSpec, { field: "x2" }],
  y: [YCoordinateSpec, { field: "y" }]
}));
var _a$2$;
class VAreaView extends AreaView {
  _index_data(e) {
    const { min: r, max: o } = Math, { data_size: s } = this;
    for (let l = 0; l < s; l++) {
      const c = this._x[l], u = this._y1[l], d = this._y2[l];
      e.add_rect(c, r(u, d), c, o(u, d));
    }
  }
  _render(e, r, o) {
    const { sx: s, sy1: l, sy2: c } = o != null ? o : this;
    e.beginPath();
    for (let u = 0, d = l.length; u < d; u++)
      e.lineTo(s[u], l[u]);
    for (let u = c.length - 1; u >= 0; u--)
      e.lineTo(s[u], c[u]);
    e.closePath(), this.visuals.fill.apply(e), this.visuals.hatch.apply(e);
  }
  scenterxy(e) {
    const r = this.sx[e], o = (this.sy1[e] + this.sy2[e]) / 2;
    return [r, o];
  }
  _hit_point(e) {
    const r = this.sx.length, o = new Selection();
    for (let s = 0, l = r - 1; s < l; s++) {
      const c = [this.sx[s], this.sx[s + 1], this.sx[s + 1], this.sx[s]], u = [this.sy1[s], this.sy1[s + 1], this.sy2[s + 1], this.sy2[s]];
      if (point_in_poly(e.sx, e.sy, c, u)) {
        o.add_to_selected_glyphs(this.model), o.view = this, o.line_indices = [s];
        break;
      }
    }
    return o;
  }
  _map_data() {
    this.sx = this.renderer.xscale.v_compute(this._x), this.sy1 = this.renderer.yscale.v_compute(this._y1), this.sy2 = this.renderer.yscale.v_compute(this._y2);
  }
}
VAreaView.__name__ = "VAreaView";
class VArea extends Area {
  constructor(e) {
    super(e);
  }
}
_a$2$ = VArea;
VArea.__name__ = "VArea";
_a$2$.prototype.default_view = VAreaView, _a$2$.define(({}) => ({
  x: [XCoordinateSpec, { field: "x" }],
  y1: [YCoordinateSpec, { field: "y1" }],
  y2: [YCoordinateSpec, { field: "y2" }]
}));
class Filter extends Model {
  constructor(e) {
    super(e);
  }
}
Filter.__name__ = "Filter";
var _a$2_;
class CDSView extends Model {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this.compute_indices();
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.properties.filters.change, () => this.compute_indices());
    const e = () => {
      const o = () => this.compute_indices();
      this.source != null && (this.connect(this.source.change, o), this.source instanceof ColumnarDataSource && (this.connect(this.source.streaming, o), this.connect(this.source.patching, o)));
    };
    let r = this.source != null;
    r ? e() : this.connect(this.properties.source.change, () => {
      r || (e(), r = !0);
    });
  }
  compute_indices() {
    var s;
    const { source: e } = this;
    if (e == null)
      return;
    const r = (s = e.get_length()) != null ? s : 1, o = BitSet.all_set(r);
    for (const l of this.filters)
      o.intersect(l.compute_indices(e));
    this.indices = o, this._indices = [...o], this.indices_map_to_subset();
  }
  indices_map_to_subset() {
    this.indices_map = {};
    for (let e = 0; e < this._indices.length; e++)
      this.indices_map[this._indices[e]] = e;
  }
  convert_selection_from_subset(e) {
    return e.map((r) => this._indices[r]);
  }
  convert_selection_to_subset(e) {
    return e.map((r) => this.indices_map[r]);
  }
  convert_indices_from_subset(e) {
    return e.map((r) => this._indices[r]);
  }
}
_a$2_ = CDSView;
CDSView.__name__ = "CDSView";
_a$2_.define(({ Array: t, Ref: e }) => ({
  filters: [t(e(Filter)), []],
  source: [e(ColumnarDataSource)]
})), _a$2_.internal(({ Int: t, Dict: e, Ref: r, Nullable: o }) => ({
  indices: [r(BitSet)],
  indices_map: [e(t), {}],
  masked: [o(r(BitSet)), null]
}));
var _a$2Z;
const selection_defaults = {
  fill: {},
  line: {}
}, decimated_defaults = {
  fill: { fill_alpha: 0.3, fill_color: "grey" },
  line: { line_alpha: 0.3, line_color: "grey" }
}, nonselection_defaults = {
  fill: { fill_alpha: 0.2 },
  line: {}
}, muted_defaults = {
  fill: { fill_alpha: 0.2 },
  line: {}
};
class GlyphRendererView extends DataRendererView {
  get glyph_view() {
    return this.glyph;
  }
  async lazy_initialize() {
    var m;
    await super.lazy_initialize();
    const e = this.model.glyph;
    this.glyph = await this.build_glyph_view(e);
    const r = "fill" in this.glyph.visuals, o = "line" in this.glyph.visuals, s = { ...e.attributes };
    delete s.id;
    function l(g) {
      const v = clone$1(s);
      return r && extend$1(v, g.fill), o && extend$1(v, g.line), new e.constructor(v);
    }
    function c(g, v) {
      return v instanceof Glyph ? v : v == "auto" ? l(g) : l({ fill: {}, line: {} });
    }
    let { selection_glyph: u, nonselection_glyph: d, hover_glyph: f, muted_glyph: T } = this.model;
    u = c(selection_defaults, u), this.selection_glyph = await this.build_glyph_view(u), d = c(nonselection_defaults, d), this.nonselection_glyph = await this.build_glyph_view(d), f != null && (this.hover_glyph = await this.build_glyph_view(f)), T = c(muted_defaults, T), this.muted_glyph = await this.build_glyph_view(T);
    const Q = c(decimated_defaults, "auto");
    this.decimated_glyph = await this.build_glyph_view(Q), this.selection_glyph.set_base(this.glyph), this.nonselection_glyph.set_base(this.glyph), (m = this.hover_glyph) == null || m.set_base(this.glyph), this.muted_glyph.set_base(this.glyph), this.decimated_glyph.set_base(this.glyph), this.set_data();
  }
  async build_glyph_view(e) {
    return build_view(e, { parent: this });
  }
  remove() {
    var e;
    this.glyph.remove(), this.selection_glyph.remove(), this.nonselection_glyph.remove(), (e = this.hover_glyph) == null || e.remove(), this.muted_glyph.remove(), this.decimated_glyph.remove(), super.remove();
  }
  connect_signals() {
    super.connect_signals();
    const e = () => this.request_render(), r = () => this.update_data();
    this.connect(this.model.change, e), this.connect(this.glyph.model.change, r), this.connect(this.selection_glyph.model.change, r), this.connect(this.nonselection_glyph.model.change, r), this.hover_glyph != null && this.connect(this.hover_glyph.model.change, r), this.connect(this.muted_glyph.model.change, r), this.connect(this.decimated_glyph.model.change, r), this.connect(this.model.data_source.change, r), this.connect(this.model.data_source.streaming, r), this.connect(this.model.data_source.patching, (u) => this.update_data(u)), this.connect(this.model.data_source.selected.change, e), this.connect(this.model.data_source._select, e), this.hover_glyph != null && this.connect(this.model.data_source.inspect, e), this.connect(this.model.properties.view.change, r), this.connect(this.model.view.properties.indices.change, r), this.connect(this.model.view.properties.masked.change, () => this.set_visuals()), this.connect(this.model.properties.visible.change, () => this.plot_view.invalidate_dataranges = !0);
    const { x_ranges: o, y_ranges: s } = this.plot_view.frame;
    for (const [, u] of o)
      u instanceof FactorRange && this.connect(u.change, r);
    for (const [, u] of s)
      u instanceof FactorRange && this.connect(u.change, r);
    const { transformchange: l, exprchange: c } = this.model.glyph;
    this.connect(l, r), this.connect(c, r);
  }
  _update_masked_indices() {
    const e = this.glyph.mask_data();
    return this.model.view.masked = e, e;
  }
  update_data(e) {
    this.set_data(e), this.request_render();
  }
  set_data(e) {
    const r = this.model.data_source;
    this.all_indices = this.model.view.indices;
    const { all_indices: o } = this;
    this.glyph.set_data(r, o, e), this.set_visuals(), this._update_masked_indices();
    const { lod_factor: s } = this.plot_model, l = this.all_indices.count;
    this.decimated = new BitSet(l);
    for (let c = 0; c < l; c += s)
      this.decimated.set(c);
    this.plot_view.invalidate_dataranges = !0;
  }
  set_visuals() {
    var o;
    const e = this.model.data_source, { all_indices: r } = this;
    this.glyph.set_visuals(e, r), this.decimated_glyph.set_visuals(e, r), this.selection_glyph.set_visuals(e, r), this.nonselection_glyph.set_visuals(e, r), (o = this.hover_glyph) == null || o.set_visuals(e, r), this.muted_glyph.set_visuals(e, r);
  }
  get has_webgl() {
    return this.glyph.has_webgl;
  }
  _render() {
    const e = this.has_webgl;
    this.glyph.map_data();
    const r = [...this.all_indices];
    let o = [...this._update_masked_indices()];
    const { ctx: s } = this.layer;
    s.save();
    const { selected: l } = this.model.data_source;
    let c;
    !l || l.is_empty() ? c = [] : this.glyph instanceof LineView && l.selected_glyph === this.glyph.model ? c = this.model.view.convert_indices_from_subset(o) : c = l.indices;
    const { inspected: u } = this.model.data_source, d = new Set((() => !u || u.is_empty() ? [] : u.selected_glyph ? this.model.view.convert_indices_from_subset(o) : u.indices.length > 0 ? u.indices : Object.keys(u.multiline_indices).map((v) => parseInt(v)))()), f = filter(o, (v) => d.has(r[v])), { lod_threshold: T } = this.plot_model;
    let Q, m, g;
    if ((this.model.document != null ? this.model.document.interactive_duration() > 0 : !1) && !e && T != null && r.length > T ? (o = [...this.decimated], Q = this.decimated_glyph, m = this.decimated_glyph, g = this.selection_glyph) : (Q = this.model.muted ? this.muted_glyph : this.glyph, m = this.nonselection_glyph, g = this.selection_glyph), this.hover_glyph != null && f.length) {
      const v = new Set(o);
      for (const b of f)
        v.delete(b);
      o = [...v];
    }
    if (c.length) {
      const v = {};
      for (const A of c)
        v[A] = !0;
      const b = new Array(), L = new Array();
      if (this.glyph instanceof LineView)
        for (const A of r)
          v[A] != null ? b.push(A) : L.push(A);
      else
        for (const A of o)
          v[r[A]] != null ? b.push(A) : L.push(A);
      m.render(s, L), g.render(s, b), this.hover_glyph != null && (this.glyph instanceof LineView ? this.hover_glyph.render(s, this.model.view.convert_indices_from_subset(f)) : this.hover_glyph.render(s, f));
    } else if (this.glyph instanceof LineView)
      this.hover_glyph && f.length ? this.hover_glyph.render(s, this.model.view.convert_indices_from_subset(f)) : Q.render(s, r);
    else if (this.glyph instanceof PatchView || this.glyph instanceof HAreaView || this.glyph instanceof VAreaView)
      if (u.selected_glyphs.length == 0 || this.hover_glyph == null)
        Q.render(s, r);
      else
        for (const v of u.selected_glyphs)
          v == this.glyph.model && this.hover_glyph.render(s, r);
    else
      Q.render(s, o), this.hover_glyph && f.length && this.hover_glyph.render(s, f);
    s.restore();
  }
  draw_legend(e, r, o, s, l, c, u, d) {
    this.glyph.data_size != 0 && (d == null && (d = this.model.get_reference_point(c, u)), this.glyph.draw_legend_for_index(e, { x0: r, x1: o, y0: s, y1: l }, d));
  }
  hit_test(e) {
    if (!this.model.visible)
      return null;
    const r = this.glyph.hit_test(e);
    return r == null ? null : this.model.view.convert_selection_from_subset(r);
  }
}
GlyphRendererView.__name__ = "GlyphRendererView";
class GlyphRenderer extends DataRenderer {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this.view.source != this.data_source && (this.view.source = this.data_source, this.view.compute_indices());
  }
  get_reference_point(e, r) {
    if (e != null) {
      const o = this.data_source.get_column(e);
      if (o != null) {
        for (const [s, l] of Object.entries(this.view.indices_map))
          if (o[parseInt(s)] == r)
            return l;
      }
    }
    return 0;
  }
  get_selection_manager() {
    return this.data_source.selection_manager;
  }
}
_a$2Z = GlyphRenderer;
GlyphRenderer.__name__ = "GlyphRenderer";
_a$2Z.prototype.default_view = GlyphRendererView, _a$2Z.define(({ Boolean: t, Auto: e, Or: r, Ref: o, Null: s, Nullable: l }) => ({
  data_source: [o(ColumnarDataSource)],
  view: [o(CDSView), (c) => new CDSView({ source: c.data_source })],
  glyph: [o(Glyph)],
  hover_glyph: [l(o(Glyph)), null],
  nonselection_glyph: [r(o(Glyph), e, s), "auto"],
  selection_glyph: [r(o(Glyph), e, s), "auto"],
  muted_glyph: [r(o(Glyph), e, s), "auto"],
  muted: [t, !1]
}));
var _a$2Y;
class ContinuousColorMapper extends ColorMapper {
  constructor(e) {
    super(e), this._scan_data = null;
  }
  connect_signals() {
    super.connect_signals();
    const e = () => {
      for (const [r] of this.domain)
        this.connect(r.view.change, () => this.update_data()), this.connect(r.data_source.selected.change, () => this.update_data());
    };
    this.connect(this.properties.domain.change, () => e()), e();
  }
  update_data() {
    const { domain: e, palette: r } = this, o = [...this._collect(e)];
    this._scan_data = this.scan(o, r.length), this.metrics_change.emit(), this.change.emit();
  }
  get metrics() {
    return this._scan_data == null && this.update_data(), this._scan_data;
  }
  *_collect(e) {
    for (const [r, o] of e)
      for (const s of isArray(o) ? o : [o]) {
        let l = r.data_source.get_column(s);
        l = r.view.indices.select(l);
        const c = r.view.masked, u = r.data_source.selected.indices;
        let d;
        if (c != null && u.length > 0 ? d = intersection([...c], u) : c != null ? d = [...c] : u.length > 0 && (d = u), d != null && (l = map(d, (f) => l[f])), l.length > 0 && !isNumber(l[0]))
          for (const f of l)
            yield* f;
        else
          yield* l;
      }
  }
  _v_compute(e, r, o, s) {
    const { nan_color: l } = s;
    let { low_color: c, high_color: u } = s;
    c == null && (c = o[0]), u == null && (u = o[o.length - 1]);
    const { domain: d } = this, f = is_empty$1(d) ? e : [...this._collect(d)];
    this._scan_data = this.scan(f, o.length), this.metrics_change.emit();
    for (let T = 0, Q = e.length; T < Q; T++) {
      const m = e[T];
      isNaN(m) ? r[T] = l : r[T] = this.cmap(m, o, c, u, this._scan_data);
    }
  }
  _colors(e) {
    return {
      ...super._colors(e),
      low_color: this.low_color != null ? e(this.low_color) : void 0,
      high_color: this.high_color != null ? e(this.high_color) : void 0
    };
  }
}
_a$2Y = ContinuousColorMapper;
ContinuousColorMapper.__name__ = "ContinuousColorMapper";
_a$2Y.define(({ Number: t, String: e, Ref: r, Color: o, Or: s, Tuple: l, Array: c, Nullable: u }) => ({
  high: [u(t), null],
  low: [u(t), null],
  high_color: [u(o), null],
  low_color: [u(o), null],
  domain: [c(l(r(GlyphRenderer), s(e, c(e)))), []]
}));
class ScanningColorMapper extends ContinuousColorMapper {
  constructor(e) {
    super(e);
  }
  cmap(e, r, o, s, l) {
    if (e < l.binning[0])
      return o;
    if (e > l.binning[l.binning.length - 1])
      return s;
    const c = left_edge_index(e, l.binning);
    return r[c];
  }
}
ScanningColorMapper.__name__ = "ScanningColorMapper";
var _a$2X;
class BinnedTicker extends Ticker {
  constructor(e) {
    super(e);
  }
  get_ticks(e, r, o, s) {
    const { binning: l } = this.mapper.metrics, c = Math.max(0, left_edge_index(e, l)), u = Math.min(left_edge_index(r, l) + 1, l.length - 1), d = [];
    for (let g = c; g <= u; g++)
      d.push(l[g]);
    const { num_major_ticks: f } = this, T = [], Q = f == "auto" ? d.length : f, m = Math.max(1, Math.floor(d.length / Q));
    for (let g = 0; g < d.length; g += m)
      T.push(d[g]);
    return {
      major: T,
      minor: []
    };
  }
}
_a$2X = BinnedTicker;
BinnedTicker.__name__ = "BinnedTicker";
_a$2X.define(({ Number: t, Ref: e, Or: r, Auto: o }) => ({
  mapper: [e(ScanningColorMapper)],
  num_major_ticks: [r(t, o), 8]
}));
var _a$2W;
class FuncTickFormatter extends TickFormatter {
  constructor(e) {
    super(e);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  _make_func() {
    const e = use_strict(this.code);
    return new Function("tick", "index", "ticks", ...this.names, e);
  }
  doFormat(e, r) {
    const o = {}, s = this._make_func().bind(o);
    return e.map((l, c, u) => `${s(l, c, u, ...this.values)}`);
  }
}
_a$2W = FuncTickFormatter;
FuncTickFormatter.__name__ = "FuncTickFormatter";
_a$2W.define(({ Unknown: t, String: e, Dict: r }) => ({
  args: [r(t), {}],
  code: [e, ""]
}));
var _a$2V;
class NumeralTickFormatter extends TickFormatter {
  constructor(e) {
    super(e);
  }
  get _rounding_fn() {
    switch (this.rounding) {
      case "round":
      case "nearest":
        return Math.round;
      case "floor":
      case "rounddown":
        return Math.floor;
      case "ceil":
      case "roundup":
        return Math.ceil;
    }
  }
  doFormat(e, r) {
    const { format: o, language: s, _rounding_fn: l } = this;
    return e.map((c) => numbro.exports.format(c, o, s, l));
  }
}
_a$2V = NumeralTickFormatter;
NumeralTickFormatter.__name__ = "NumeralTickFormatter";
_a$2V.define(({ String: t }) => ({
  format: [t, "0,0"],
  language: [t, "en"],
  rounding: [RoundingFunction, "round"]
}));
var _a$2U;
class PrintfTickFormatter extends TickFormatter {
  constructor(e) {
    super(e);
  }
  doFormat(e, r) {
    return e.map((o) => sprintf(this.format, o));
  }
}
_a$2U = PrintfTickFormatter;
PrintfTickFormatter.__name__ = "PrintfTickFormatter";
_a$2U.define(({ String: t }) => ({
  format: [t, "%s"]
}));
function _cat_equals(t, e) {
  if (t.length != e.length)
    return !1;
  for (let r = 0, o = t.length; r < o; r++)
    if (t[r] !== e[r])
      return !1;
  return !0;
}
function cat_v_compute(t, e, r, o, s, l, c) {
  const u = t.length;
  for (let d = 0; d < u; d++) {
    let f = t[d], T;
    isString(f) ? T = index_of(e, f) : (s != null ? l != null ? f = f.slice(s, l) : f = f.slice(s) : l != null && (f = f.slice(0, l)), f.length == 1 ? T = index_of(e, f[0]) : T = find_index(e, (m) => _cat_equals(m, f)));
    let Q;
    T < 0 || T >= r.length ? Q = c : Q = r[T], o[d] = Q;
  }
}
var _a$2T;
class CategoricalColorMapper extends ColorMapper {
  constructor(e) {
    super(e);
  }
  _v_compute(e, r, o, { nan_color: s }) {
    cat_v_compute(e, this.factors, o, r, this.start, this.end, s);
  }
}
_a$2T = CategoricalColorMapper;
CategoricalColorMapper.__name__ = "CategoricalColorMapper";
_a$2T.define(({ Number: t, Nullable: e }) => ({
  factors: [FactorSeq],
  start: [t, 0],
  end: [e(t), null]
}));
var _a$2S;
class CategoricalMarkerMapper extends Mapper {
  constructor(e) {
    super(e);
  }
  v_compute(e) {
    const r = new Array(e.length);
    return cat_v_compute(e, this.factors, this.markers, r, this.start, this.end, this.default_value), r;
  }
}
_a$2S = CategoricalMarkerMapper;
CategoricalMarkerMapper.__name__ = "CategoricalMarkerMapper";
_a$2S.define(({ Number: t, Array: e, Nullable: r }) => ({
  factors: [FactorSeq],
  markers: [e(MarkerType)],
  start: [t, 0],
  end: [r(t), null],
  default_value: [MarkerType, "circle"]
}));
var _a$2R;
class CategoricalPatternMapper extends Mapper {
  constructor(e) {
    super(e);
  }
  v_compute(e) {
    const r = new Array(e.length);
    return cat_v_compute(e, this.factors, this.patterns, r, this.start, this.end, this.default_value), r;
  }
}
_a$2R = CategoricalPatternMapper;
CategoricalPatternMapper.__name__ = "CategoricalPatternMapper";
_a$2R.define(({ Number: t, Array: e, Nullable: r }) => ({
  factors: [FactorSeq],
  patterns: [e(HatchPatternType)],
  start: [t, 0],
  end: [r(t), null],
  default_value: [HatchPatternType, " "]
}));
class LinearColorMapper extends ContinuousColorMapper {
  constructor(e) {
    super(e);
  }
  scan(e, r) {
    const o = this.low != null ? this.low : min$6(e), s = this.high != null ? this.high : max$8(e), l = 1 / (s - o), c = 1 / r;
    return { max: s, min: o, norm_factor: l, normed_interval: c };
  }
  cmap(e, r, o, s, l) {
    const c = r.length - 1;
    if (e == l.max)
      return r[c];
    const u = (e - l.min) * l.norm_factor, d = Math.floor(u / l.normed_interval);
    return d < 0 ? o : d > c ? s : r[d];
  }
}
LinearColorMapper.__name__ = "LinearColorMapper";
class LogColorMapper extends ContinuousColorMapper {
  constructor(e) {
    super(e);
  }
  scan(e, r) {
    const o = this.low != null ? this.low : min$6(e), s = this.high != null ? this.high : max$8(e), l = r / (Math.log(s) - Math.log(o));
    return { max: s, min: o, scale: l };
  }
  cmap(e, r, o, s, l) {
    const c = r.length - 1;
    if (e > l.max)
      return s;
    if (e == l.max)
      return r[c];
    if (e < l.min)
      return o;
    const u = Math.log(e) - Math.log(l.min);
    let d = Math.floor(u * l.scale);
    return d > c && (d = c), r[d];
  }
}
LogColorMapper.__name__ = "LogColorMapper";
var _a$2Q;
class EqHistColorMapper extends ScanningColorMapper {
  constructor(e) {
    super(e);
  }
  scan(e, r) {
    let o = this.low != null ? this.low : min$6(e);
    const s = this.high != null ? this.high : max$8(e), l = this.bins, c = linspace(o, s, l + 1), u = bin_counts(e, c);
    let d = 0;
    for (let A = 0; A < l; A++)
      u[A] != 0 && d++;
    const f = new Array(d + 1), T = new Array(d + 1);
    for (let A = 0, M = 1; A < l; A++)
      u[A] != 0 && (f[M] = u[A], T[M] = (c[A] + c[A + 1]) / 2, M++);
    f[0] = 0, T[0] = 2 * T[1] - T[d];
    const Q = cumsum(f), m = Q[1], g = Q[d] - m;
    for (let A = 1; A <= d; A++)
      Q[A] = (Q[A] - m) / g;
    Q[0] = -1;
    let v = 0;
    if (this.rescale_discrete_levels) {
      const A = d, M = -0.5 / 98, S = 1.5 - 2 * M, E = M * A + S;
      E > 1 && (v = 1 - E);
    }
    const b = linspace(v, 1, r + 1), L = interpolate(b, Q, T);
    return this.rescale_discrete_levels ? o = L[0] : L[0] = o, L[L.length - 1] = s, { min: o, max: s, binning: L };
  }
}
_a$2Q = EqHistColorMapper;
EqHistColorMapper.__name__ = "EqHistColorMapper";
_a$2Q.define(({ Boolean: t, Int: e }) => ({
  bins: [e, 256 * 256],
  rescale_discrete_levels: [t, !1]
}));
var _a$2P;
class LinearInterpolationScale extends Scale {
  constructor(e) {
    super(e);
  }
  connect_signals() {
    super.connect_signals();
    const { source_range: e, target_range: r } = this.properties;
    this.on_change([e, r], () => {
      this.linear_scale = new LinearScale({
        source_range: this.source_range,
        target_range: this.target_range
      });
    });
  }
  get s_compute() {
    throw new Error("not implemented");
  }
  get s_invert() {
    throw new Error("not implemented");
  }
  compute(e) {
    return e;
  }
  v_compute(e) {
    const { binning: r } = this, { start: o, end: s } = this.source_range, l = o, c = s, u = r.length, d = (s - o) / (u - 1), f = new Float64Array(u);
    for (let Q = 0; Q < u; Q++)
      f[Q] = o + Q * d;
    const T = map(e, (Q) => {
      if (Q < l)
        return l;
      if (Q > c)
        return c;
      const m = left_edge_index(Q, r);
      if (m == -1)
        return l;
      if (m >= u - 1)
        return c;
      const g = r[m], v = r[m + 1], b = (Q - g) / (v - g), L = f[m], A = f[m + 1];
      return L + b * (A - L);
    });
    return this.linear_scale.v_compute(T);
  }
  invert(e) {
    return e;
  }
  v_invert(e) {
    return new Float64Array(e);
  }
}
_a$2P = LinearInterpolationScale;
LinearInterpolationScale.__name__ = "LinearInterpolationScale";
_a$2P.internal(({ Arrayable: t, Ref: e }) => ({
  binning: [t],
  linear_scale: [
    e(LinearScale),
    (r) => new LinearScale({
      source_range: r.source_range,
      target_range: r.target_range
    })
  ]
}));
class Stack$3 extends Layoutable {
  constructor() {
    super(...arguments), this.children = [];
  }
  *[Symbol.iterator]() {
    yield* this.children;
  }
}
Stack$3.__name__ = "Stack";
class HStack extends Stack$3 {
  _measure(e) {
    let r = 0, o = 0;
    for (const s of this.children) {
      const l = s.measure({ width: 0, height: 0 });
      r += l.width, o = Math.max(o, l.height);
    }
    return { width: r, height: o };
  }
  _set_geometry(e, r) {
    super._set_geometry(e, r);
    const o = this.absolute ? e.top : 0;
    let s = this.absolute ? e.left : 0;
    const { height: l } = e;
    for (const c of this.children) {
      const { width: u } = c.measure({ width: 0, height: 0 });
      c.set_geometry(new BBox$2({ left: s, width: u, top: o, height: l })), s += u;
    }
  }
}
HStack.__name__ = "HStack";
class VStack extends Stack$3 {
  _measure(e) {
    let r = 0, o = 0;
    for (const s of this.children) {
      const l = s.measure({ width: 0, height: 0 });
      r = Math.max(r, l.width), o += l.height;
    }
    return { width: r, height: o };
  }
  _set_geometry(e, r) {
    super._set_geometry(e, r);
    const o = this.absolute ? e.left : 0;
    let s = this.absolute ? e.top : 0;
    const { width: l } = e;
    for (const c of this.children) {
      const { height: u } = c.measure({ width: 0, height: 0 });
      c.set_geometry(new BBox$2({ top: s, height: u, left: o, width: l })), s += u;
    }
  }
}
VStack.__name__ = "VStack";
class NodeLayout extends Layoutable {
  constructor() {
    super(...arguments), this.children = [];
  }
  *[Symbol.iterator]() {
    yield* this.children;
  }
  _measure(e) {
    const { width_policy: r, height_policy: o } = this.sizing, { min: s, max: l } = Math;
    let c = 0, u = 0;
    for (const T of this.children) {
      const { width: Q, height: m } = T.measure(e);
      c = l(c, Q), u = l(u, m);
    }
    const d = (() => {
      const { width: T } = this.sizing;
      if (e.width == 1 / 0)
        return r == "fixed" && T != null ? T : c;
      switch (r) {
        case "fixed":
          return T != null ? T : c;
        case "min":
          return c;
        case "fit":
          return T != null ? s(e.width, T) : e.width;
        case "max":
          return T != null ? l(e.width, T) : e.width;
      }
    })(), f = (() => {
      const { height: T } = this.sizing;
      if (e.height == 1 / 0)
        return o == "fixed" && T != null ? T : u;
      switch (o) {
        case "fixed":
          return T != null ? T : u;
        case "min":
          return u;
        case "fit":
          return T != null ? s(e.height, T) : e.height;
        case "max":
          return T != null ? l(e.height, T) : e.height;
      }
    })();
    return { width: d, height: f };
  }
  _set_geometry(e, r) {
    super._set_geometry(e, r);
    const o = this.absolute ? e : e.relative(), { left: s, right: l, top: c, bottom: u } = o, d = Math.round(o.vcenter), f = Math.round(o.hcenter);
    for (const T of this.children) {
      const { margin: Q, halign: m, valign: g } = T.sizing, { width: v, height: b, inner: L } = T.measure(e), A = (() => {
        switch (`${g}_${m}`) {
          case "start_start":
            return new BBox$2({ left: s + Q.left, top: c + Q.top, width: v, height: b });
          case "start_center":
            return new BBox$2({ hcenter: f, top: c + Q.top, width: v, height: b });
          case "start_end":
            return new BBox$2({ right: l - Q.right, top: c + Q.top, width: v, height: b });
          case "center_start":
            return new BBox$2({ left: s + Q.left, vcenter: d, width: v, height: b });
          case "center_center":
            return new BBox$2({ hcenter: f, vcenter: d, width: v, height: b });
          case "center_end":
            return new BBox$2({ right: l - Q.right, vcenter: d, width: v, height: b });
          case "end_start":
            return new BBox$2({ left: s + Q.left, bottom: u - Q.bottom, width: v, height: b });
          case "end_center":
            return new BBox$2({ hcenter: f, bottom: u - Q.bottom, width: v, height: b });
          case "end_end":
            return new BBox$2({ right: l - Q.right, bottom: u - Q.bottom, width: v, height: b });
        }
      })(), M = L == null ? A : new BBox$2({
        left: A.left + L.left,
        top: A.top + L.top,
        right: A.right - L.right,
        bottom: A.bottom - L.bottom
      });
      T.set_geometry(A, M);
    }
  }
}
NodeLayout.__name__ = "NodeLayout";
const { max: max$3, round } = Math;
class DefaultMap {
  constructor(e) {
    this.def = e, this._map = /* @__PURE__ */ new Map();
  }
  get(e) {
    let r = this._map.get(e);
    return r === void 0 && (r = this.def(), this._map.set(e, r)), r;
  }
  apply(e, r) {
    const o = this.get(e);
    this._map.set(e, r(o));
  }
}
DefaultMap.__name__ = "DefaultMap";
class Container {
  constructor() {
    this._items = [], this._nrows = 0, this._ncols = 0;
  }
  get nrows() {
    return this._nrows;
  }
  get ncols() {
    return this._ncols;
  }
  add(e, r) {
    const { r1: o, c1: s } = e;
    this._nrows = max$3(this._nrows, o + 1), this._ncols = max$3(this._ncols, s + 1), this._items.push({ span: e, data: r });
  }
  at(e, r) {
    return this._items.filter(({ span: s }) => s.r0 <= e && e <= s.r1 && s.c0 <= r && r <= s.c1).map(({ data: s }) => s);
  }
  row(e) {
    return this._items.filter(({ span: o }) => o.r0 <= e && e <= o.r1).map(({ data: o }) => o);
  }
  col(e) {
    return this._items.filter(({ span: o }) => o.c0 <= e && e <= o.c1).map(({ data: o }) => o);
  }
  foreach(e) {
    for (const { span: r, data: o } of this._items)
      e(r, o);
  }
  map(e) {
    const r = new Container();
    for (const { span: o, data: s } of this._items)
      r.add(o, e(o, s));
    return r;
  }
}
Container.__name__ = "Container";
class Grid$1 extends Layoutable {
  constructor(e = []) {
    super(), this.items = e, this.rows = "auto", this.cols = "auto", this.spacing = 0;
  }
  *[Symbol.iterator]() {
    for (const { layout: e } of this.items)
      yield e;
  }
  is_width_expanding() {
    if (super.is_width_expanding())
      return !0;
    if (this.sizing.width_policy == "fixed")
      return !1;
    const { cols: e } = this._state;
    return some(e, (r) => r.policy == "max");
  }
  is_height_expanding() {
    if (super.is_height_expanding())
      return !0;
    if (this.sizing.height_policy == "fixed")
      return !1;
    const { rows: e } = this._state;
    return some(e, (r) => r.policy == "max");
  }
  _init() {
    var d, f, T, Q;
    super._init();
    const e = new Container();
    for (const { layout: m, row: g, col: v, row_span: b, col_span: L } of this.items)
      if (m.sizing.visible) {
        const A = g, M = v, S = g + (b != null ? b : 1) - 1, E = v + (L != null ? L : 1) - 1;
        e.add({ r0: A, c0: M, r1: S, c1: E }, m);
      }
    const { nrows: r, ncols: o } = e, s = new Array(r);
    for (let m = 0; m < r; m++) {
      const g = (() => {
        var L;
        const b = isPlainObject(this.rows) ? (L = this.rows[m]) != null ? L : this.rows["*"] : this.rows;
        return b == null ? { policy: "auto" } : isNumber(b) ? { policy: "fixed", height: b } : isString(b) ? { policy: b } : b;
      })(), v = (d = g.align) != null ? d : "auto";
      if (g.policy == "fixed")
        s[m] = { policy: "fixed", height: g.height, align: v };
      else if (g.policy == "min")
        s[m] = { policy: "min", align: v };
      else if (g.policy == "fit" || g.policy == "max")
        s[m] = { policy: g.policy, flex: (f = g.flex) != null ? f : 1, align: v };
      else if (g.policy == "auto")
        some(e.row(m), (b) => b.is_height_expanding()) ? s[m] = { policy: "max", flex: 1, align: v } : s[m] = { policy: "min", align: v };
      else
        throw new Error("unrechable");
    }
    const l = new Array(o);
    for (let m = 0; m < o; m++) {
      const g = (() => {
        var L;
        const b = isPlainObject(this.cols) ? (L = this.cols[m]) != null ? L : this.cols["*"] : this.cols;
        return b == null ? { policy: "auto" } : isNumber(b) ? { policy: "fixed", width: b } : isString(b) ? { policy: b } : b;
      })(), v = (T = g.align) != null ? T : "auto";
      if (g.policy == "fixed")
        l[m] = { policy: "fixed", width: g.width, align: v };
      else if (g.policy == "min")
        l[m] = { policy: "min", align: v };
      else if (g.policy == "fit" || g.policy == "max")
        l[m] = { policy: g.policy, flex: (Q = g.flex) != null ? Q : 1, align: v };
      else if (g.policy == "auto")
        some(e.col(m), (b) => b.is_width_expanding()) ? l[m] = { policy: "max", flex: 1, align: v } : l[m] = { policy: "min", align: v };
      else
        throw new Error("unrechable");
    }
    const [c, u] = isNumber(this.spacing) ? [this.spacing, this.spacing] : this.spacing;
    this._state = { items: e, nrows: r, ncols: o, rows: s, cols: l, rspacing: c, cspacing: u };
  }
  _measure_totals(e, r) {
    const { nrows: o, ncols: s, rspacing: l, cspacing: c } = this._state;
    return {
      height: sum$2(e) + (o - 1) * l,
      width: sum$2(r) + (s - 1) * c
    };
  }
  _measure_cells(e) {
    const { items: r, nrows: o, ncols: s, rows: l, cols: c, rspacing: u, cspacing: d } = this._state, f = new Array(o);
    for (let g = 0; g < o; g++) {
      const v = l[g];
      f[g] = v.policy == "fixed" ? v.height : 0;
    }
    const T = new Array(s);
    for (let g = 0; g < s; g++) {
      const v = c[g];
      T[g] = v.policy == "fixed" ? v.width : 0;
    }
    const Q = new Container();
    return r.foreach((g, v) => {
      const { r0: b, c0: L, r1: A, c1: M } = g, S = (A - b) * u, E = (M - L) * d;
      let k = 0;
      for (let F = b; F <= A; F++)
        k += e(F, L).height;
      k += S;
      let w = 0;
      for (let F = L; F <= M; F++)
        w += e(b, F).width;
      w += E;
      const O = v.measure({ width: w, height: k });
      Q.add(g, { layout: v, size_hint: O });
      const D = new Sizeable(O).grow_by(v.sizing.margin);
      D.height -= S, D.width -= E;
      const R = [];
      for (let F = b; F <= A; F++) {
        const j = l[F];
        j.policy == "fixed" ? D.height -= j.height : R.push(F);
      }
      if (D.height > 0) {
        const F = round(D.height / R.length);
        for (const j of R)
          f[j] = max$3(f[j], F);
      }
      const B = [];
      for (let F = L; F <= M; F++) {
        const j = c[F];
        j.policy == "fixed" ? D.width -= j.width : B.push(F);
      }
      if (D.width > 0) {
        const F = round(D.width / B.length);
        for (const j of B)
          T[j] = max$3(T[j], F);
      }
    }), { size: this._measure_totals(f, T), row_heights: f, col_widths: T, size_hints: Q };
  }
  _measure_grid(e) {
    const { nrows: r, ncols: o, rows: s, cols: l, rspacing: c, cspacing: u } = this._state, d = this._measure_cells((A, M) => {
      const S = s[A], E = l[M];
      return {
        width: E.policy == "fixed" ? E.width : 1 / 0,
        height: S.policy == "fixed" ? S.height : 1 / 0
      };
    });
    let f;
    this.sizing.height_policy == "fixed" && this.sizing.height != null ? f = this.sizing.height : e.height != 1 / 0 && this.is_height_expanding() ? f = e.height : f = d.size.height;
    let T = 0;
    for (let A = 0; A < r; A++) {
      const M = s[A];
      M.policy == "fit" || M.policy == "max" ? T += M.flex : f -= d.row_heights[A];
    }
    if (f -= (r - 1) * c, T != 0 && f > 0)
      for (let A = 0; A < r; A++) {
        const M = s[A];
        if (M.policy == "fit" || M.policy == "max") {
          const S = round(f * (M.flex / T));
          f -= S, d.row_heights[A] = S, T -= M.flex;
        }
      }
    else if (f < 0) {
      let A = 0;
      for (let S = 0; S < r; S++)
        s[S].policy != "fixed" && A++;
      let M = -f;
      for (let S = 0; S < r; S++)
        if (s[S].policy != "fixed") {
          const k = d.row_heights[S], w = round(M / A);
          d.row_heights[S] = max$3(k - w, 0), M -= w > k ? k : w, A--;
        }
    }
    let Q;
    this.sizing.width_policy == "fixed" && this.sizing.width != null ? Q = this.sizing.width : e.width != 1 / 0 && this.is_width_expanding() ? Q = e.width : Q = d.size.width;
    let m = 0;
    for (let A = 0; A < o; A++) {
      const M = l[A];
      M.policy == "fit" || M.policy == "max" ? m += M.flex : Q -= d.col_widths[A];
    }
    if (Q -= (o - 1) * u, m != 0 && Q > 0)
      for (let A = 0; A < o; A++) {
        const M = l[A];
        if (M.policy == "fit" || M.policy == "max") {
          const S = round(Q * (M.flex / m));
          Q -= S, d.col_widths[A] = S, m -= M.flex;
        }
      }
    else if (Q < 0) {
      let A = 0;
      for (let S = 0; S < o; S++)
        l[S].policy != "fixed" && A++;
      let M = -Q;
      for (let S = 0; S < o; S++)
        if (l[S].policy != "fixed") {
          const k = d.col_widths[S], w = round(M / A);
          d.col_widths[S] = max$3(k - w, 0), M -= w > k ? k : w, A--;
        }
    }
    const { row_heights: g, col_widths: v, size_hints: b } = this._measure_cells((A, M) => ({
      width: d.col_widths[M],
      height: d.row_heights[A]
    }));
    return { size: this._measure_totals(g, v), row_heights: g, col_widths: v, size_hints: b };
  }
  _measure(e) {
    const { size: r } = this._measure_grid(e);
    return r;
  }
  _set_geometry(e, r) {
    super._set_geometry(e, r);
    const { nrows: o, ncols: s, rspacing: l, cspacing: c } = this._state, { row_heights: u, col_widths: d, size_hints: f } = this._measure_grid(e), T = this._state.rows.map((A, M) => ({ ...A, top: 0, height: u[M], get bottom() {
      return this.top + this.height;
    } })), Q = this._state.cols.map((A, M) => ({ ...A, left: 0, width: d[M], get right() {
      return this.left + this.width;
    } })), m = f.map((A, M) => ({ ...M, outer: new BBox$2(), inner: new BBox$2() }));
    for (let A = 0, M = this.absolute ? e.top : 0; A < o; A++) {
      const S = T[A];
      S.top = M, M += S.height + l;
    }
    for (let A = 0, M = this.absolute ? e.left : 0; A < s; A++) {
      const S = Q[A];
      S.left = M, M += S.width + c;
    }
    function g(A, M) {
      let S = (M - A) * c;
      for (let E = A; E <= M; E++)
        S += Q[E].width;
      return S;
    }
    function v(A, M) {
      let S = (M - A) * l;
      for (let E = A; E <= M; E++)
        S += T[E].height;
      return S;
    }
    m.foreach(({ r0: A, c0: M, r1: S, c1: E }, k) => {
      const { layout: w, size_hint: O } = k, { sizing: D } = w, { width: R, height: B } = O, F = {
        width: g(M, E),
        height: v(A, S)
      }, j = M == E && Q[M].align != "auto" ? Q[M].align : D.halign, z = A == S && T[A].align != "auto" ? T[A].align : D.valign;
      let q = Q[M].left;
      j == "start" ? q += D.margin.left : j == "center" ? q += round((F.width - R) / 2) : j == "end" && (q += F.width - D.margin.right - R);
      let I = T[A].top;
      z == "start" ? I += D.margin.top : z == "center" ? I += round((F.height - B) / 2) : z == "end" && (I += F.height - D.margin.bottom - B), k.outer = new BBox$2({ left: q, top: I, width: R, height: B });
    });
    const b = T.map(() => ({
      start: new DefaultMap(() => 0),
      end: new DefaultMap(() => 0)
    })), L = Q.map(() => ({
      start: new DefaultMap(() => 0),
      end: new DefaultMap(() => 0)
    }));
    m.foreach(({ r0: A, c0: M, r1: S, c1: E }, { size_hint: k, outer: w }) => {
      const { inner: O } = k;
      O != null && (b[A].start.apply(w.top, (D) => max$3(D, O.top)), b[S].end.apply(T[S].bottom - w.bottom, (D) => max$3(D, O.bottom)), L[M].start.apply(w.left, (D) => max$3(D, O.left)), L[E].end.apply(Q[E].right - w.right, (D) => max$3(D, O.right)));
    }), m.foreach(({ r0: A, c0: M, r1: S, c1: E }, k) => {
      const { size_hint: w, outer: O } = k, D = (R) => {
        const B = this.absolute ? O : O.relative(), F = B.left + R.left, j = B.top + R.top, z = B.right - R.right, q = B.bottom - R.bottom;
        return new BBox$2({ left: F, top: j, right: z, bottom: q });
      };
      if (w.inner != null) {
        let R = D(w.inner);
        if (w.align !== !1) {
          const B = b[A].start.get(O.top), F = b[S].end.get(T[S].bottom - O.bottom), j = L[M].start.get(O.left), z = L[E].end.get(Q[E].right - O.right);
          try {
            R = D({ top: B, bottom: F, left: j, right: z });
          } catch {
          }
        }
        k.inner = R;
      } else
        k.inner = O;
    }), m.foreach((A, { layout: M, outer: S, inner: E }) => {
      M.set_geometry(S, E);
    });
  }
}
Grid$1.__name__ = "Grid";
class Row$1 extends Grid$1 {
  constructor(e) {
    super(), this.items = e.map((r, o) => ({ layout: r, row: 0, col: o })), this.rows = "fit";
  }
}
Row$1.__name__ = "Row";
class Column$1 extends Grid$1 {
  constructor(e) {
    super(), this.items = e.map((r, o) => ({ layout: r, row: o, col: 0 })), this.cols = "fit";
  }
}
Column$1.__name__ = "Column";
class ContentBox extends ContentLayoutable {
  constructor(e) {
    super(), this.content_size = unsized(e, () => new Sizeable(size(e)));
  }
  _content_size() {
    return this.content_size;
  }
}
ContentBox.__name__ = "ContentBox";
class VariadicBox extends Layoutable {
  constructor(e) {
    super(), this.el = e;
  }
  _measure(e) {
    const r = new Sizeable(e).bounded_to(this.sizing.size);
    return sized(this.el, r, () => {
      const o = new Sizeable(content_size(this.el)), { border: s, padding: l } = extents(this.el);
      return o.grow_by(s).grow_by(l).map(Math.ceil);
    });
  }
}
VariadicBox.__name__ = "VariadicBox";
class CachedVariadicBox extends VariadicBox {
  constructor(e) {
    super(e), this._cache = /* @__PURE__ */ new Map();
  }
  _measure(e) {
    const { width: r, height: o } = e, s = `${r},${o}`;
    let l = this._cache.get(s);
    return l == null && (l = super._measure(e), this._cache.set(s, l)), l;
  }
  invalidate_cache() {
    this._cache.clear();
  }
}
CachedVariadicBox.__name__ = "CachedVariadicBox";
class BorderLayout extends Layoutable {
  constructor() {
    super(...arguments), this.min_border = { left: 0, top: 0, right: 0, bottom: 0 }, this.padding = { left: 0, top: 0, right: 0, bottom: 0 };
  }
  *[Symbol.iterator]() {
    yield this.top_panel, yield this.bottom_panel, yield this.left_panel, yield this.right_panel, yield this.center_panel;
  }
  _measure(e) {
    e = new Sizeable({
      width: this.sizing.width_policy == "fixed" || e.width == 1 / 0 ? this.sizing.width : e.width,
      height: this.sizing.height_policy == "fixed" || e.height == 1 / 0 ? this.sizing.height : e.height
    });
    const r = this.left_panel.measure({ width: 0, height: e.height }), o = Math.max(r.width, this.min_border.left) + this.padding.left, s = this.right_panel.measure({ width: 0, height: e.height }), l = Math.max(s.width, this.min_border.right) + this.padding.right, c = this.top_panel.measure({ width: e.width, height: 0 }), u = Math.max(c.height, this.min_border.top) + this.padding.top, d = this.bottom_panel.measure({ width: e.width, height: 0 }), f = Math.max(d.height, this.min_border.bottom) + this.padding.bottom, T = new Sizeable(e).shrink_by({ left: o, right: l, top: u, bottom: f }), Q = this.center_panel.measure(T), m = o + Q.width + l, g = u + Q.height + f, v = (() => {
      const { width_policy: b, height_policy: L } = this.center_panel.sizing;
      return b != "fixed" && L != "fixed";
    })();
    return { width: m, height: g, inner: { left: o, right: l, top: u, bottom: f }, align: v };
  }
  _set_geometry(e, r) {
    super._set_geometry(e, r), this.center_panel.set_geometry(r);
    const o = this.left_panel.measure({ width: 0, height: e.height }), s = this.right_panel.measure({ width: 0, height: e.height }), l = this.top_panel.measure({ width: e.width, height: 0 }), c = this.bottom_panel.measure({ width: e.width, height: 0 }), { left: u, top: d, right: f, bottom: T } = r;
    this.top_panel.set_geometry(new BBox$2({ left: u, right: f, bottom: d, height: l.height })), this.bottom_panel.set_geometry(new BBox$2({ left: u, right: f, top: T, height: c.height })), this.left_panel.set_geometry(new BBox$2({ top: d, bottom: T, right: u, width: o.width })), this.right_panel.set_geometry(new BBox$2({ top: d, bottom: T, left: f, width: s.width }));
  }
}
BorderLayout.__name__ = "BorderLayout";
var _a$2O;
const MINOR_DIM = 25, MAJOR_DIM_MIN_SCALAR = 0.3, MAJOR_DIM_MAX_SCALAR = 0.8;
class ColorBarView extends AnnotationView {
  get orientation() {
    return this._orientation;
  }
  initialize() {
    super.initialize();
    const { ticker: e, formatter: r, color_mapper: o } = this.model;
    this._ticker = e != "auto" ? e : (() => {
      switch (!0) {
        case o instanceof LogColorMapper:
          return new LogTicker();
        case o instanceof ScanningColorMapper:
          return new BinnedTicker({ mapper: o });
        case o instanceof CategoricalColorMapper:
          return new CategoricalTicker();
        default:
          return new BasicTicker();
      }
    })(), this._formatter = r != "auto" ? r : (() => {
      switch (!0) {
        case this._ticker instanceof LogTicker:
          return new LogTickFormatter();
        case o instanceof CategoricalColorMapper:
          return new CategoricalTickFormatter();
        default:
          return new BasicTickFormatter();
      }
    })(), this._major_range = (() => {
      if (o instanceof CategoricalColorMapper) {
        const { factors: T } = o;
        return new FactorRange({ factors: T });
      } else if (o instanceof ContinuousColorMapper) {
        const { min: T, max: Q } = o.metrics;
        return new Range1d({ start: T, end: Q });
      } else
        unreachable();
    })(), this._major_scale = (() => {
      if (o instanceof LinearColorMapper)
        return new LinearScale();
      if (o instanceof LogColorMapper)
        return new LogScale();
      if (o instanceof ScanningColorMapper) {
        const { binning: T } = o.metrics;
        return new LinearInterpolationScale({ binning: T });
      } else {
        if (o instanceof CategoricalColorMapper)
          return new CategoricalScale();
        unreachable();
      }
    })(), this._minor_range = new Range1d({ start: 0, end: 1 }), this._minor_scale = new LinearScale();
    const s = attrs_of(this.model, "major_label_", Text$3, !0), l = attrs_of(this.model, "major_tick_", Line$2, !0), c = attrs_of(this.model, "minor_tick_", Line$2, !0), u = attrs_of(this.model, "title_", Text$3), d = (() => o instanceof CategoricalColorMapper ? CategoricalAxis : o instanceof LogColorMapper ? LogAxis : LinearAxis)();
    this._axis = new d({
      ticker: this._ticker,
      formatter: this._formatter,
      major_tick_in: this.model.major_tick_in,
      major_tick_out: this.model.major_tick_out,
      minor_tick_in: this.model.minor_tick_in,
      minor_tick_out: this.model.minor_tick_out,
      major_label_standoff: this.model.label_standoff,
      major_label_overrides: this.model.major_label_overrides,
      major_label_policy: this.model.major_label_policy,
      axis_line_color: null,
      ...s,
      ...l,
      ...c
    });
    const { title: f } = this.model;
    f && (this._title = new Title({
      text: f,
      standoff: this.model.title_standoff,
      ...u
    }));
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    const e = this, r = {
      get parent() {
        return e.parent;
      },
      get root() {
        return e.root;
      },
      get frame() {
        return e._frame;
      },
      get canvas_view() {
        return e.parent.canvas_view;
      },
      request_layout() {
        e.parent.request_layout();
      }
    };
    this._axis_view = await build_view(this._axis, { parent: r }), this._title != null && (this._title_view = await build_view(this._title, { parent: r }));
  }
  remove() {
    var e;
    (e = this._title_view) == null || e.remove(), this._axis_view.remove(), super.remove();
  }
  connect_signals() {
    super.connect_signals(), this.connect(this._ticker.change, () => this.request_render()), this.connect(this._formatter.change, () => this.request_render()), this.connect(this.model.color_mapper.metrics_change, () => {
      const e = this._major_range, r = this._major_scale, { color_mapper: o } = this.model;
      if (o instanceof ContinuousColorMapper && e instanceof Range1d) {
        const { min: s, max: l } = o.metrics;
        e.setv({ start: s, end: l });
      }
      if (o instanceof ScanningColorMapper && r instanceof LinearInterpolationScale) {
        const { binning: s } = o.metrics;
        r.binning = s;
      }
      this._set_canvas_image(), this.plot_view.request_layout();
    });
  }
  _set_canvas_image() {
    const { orientation: e } = this, r = (() => {
      const { palette: T } = this.model.color_mapper;
      return e == "vertical" ? reversed(T) : T;
    })(), [o, s] = (() => e == "vertical" ? [1, r.length] : [r.length, 1])(), l = this._image = document.createElement("canvas");
    l.width = o, l.height = s;
    const c = l.getContext("2d"), u = c.getImageData(0, 0, o, s), f = new LinearColorMapper({ palette: r }).rgba_mapper.v_compute(range(0, r.length));
    u.data.set(f), c.putImageData(u, 0, 0);
  }
  update_layout() {
    const { location: e, width: r, height: o, padding: s, margin: l } = this.model, [c, u] = (() => {
      if (isString(e))
        switch (e) {
          case "top_left":
            return ["start", "start"];
          case "top":
          case "top_center":
            return ["start", "center"];
          case "top_right":
            return ["start", "end"];
          case "bottom_left":
            return ["end", "start"];
          case "bottom":
          case "bottom_center":
            return ["end", "center"];
          case "bottom_right":
            return ["end", "end"];
          case "left":
          case "center_left":
            return ["center", "start"];
          case "center":
          case "center_center":
            return ["center", "center"];
          case "right":
          case "center_right":
            return ["center", "end"];
        }
      else
        return ["end", "start"];
    })(), d = this._orientation = (() => {
      const { orientation: I } = this.model;
      return I == "auto" ? this.panel != null ? this.panel.is_horizontal ? "horizontal" : "vertical" : u == "start" || u == "end" || u == "center" && c == "center" ? "vertical" : "horizontal" : I;
    })(), f = new NodeLayout(), T = new VStack(), Q = new VStack(), m = new HStack(), g = new HStack();
    f.absolute = !0, T.absolute = !0, Q.absolute = !0, m.absolute = !0, g.absolute = !0;
    const [v, b, L, A] = (() => d == "horizontal" ? [this._major_scale, this._minor_scale, this._major_range, this._minor_range] : [this._minor_scale, this._major_scale, this._minor_range, this._major_range])();
    this._frame = new CartesianFrame(v, b, L, A), f.on_resize((I) => this._frame.set_geometry(I));
    const M = new BorderLayout();
    this._inner_layout = M, M.absolute = !0, M.center_panel = f, M.top_panel = T, M.bottom_panel = Q, M.left_panel = m, M.right_panel = g;
    const S = { left: s, right: s, top: s, bottom: s }, E = (() => {
      if (this.panel == null) {
        if (isString(e))
          return { left: l, right: l, top: l, bottom: l };
        {
          const [I, U] = e;
          return { left: I, right: l, top: l, bottom: U };
        }
      } else if (isString(e)) {
        M.fixup_geometry = (I, U) => {
          const H = I;
          if (d == "horizontal") {
            const { top: ce, width: Ae, height: ae } = I;
            if (u == "end") {
              const { right: pe } = this.layout.bbox;
              I = new BBox$2({ right: pe, top: ce, width: Ae, height: ae });
            } else if (u == "center") {
              const { hcenter: pe } = this.layout.bbox;
              I = new BBox$2({ hcenter: Math.round(pe), top: ce, width: Ae, height: ae });
            }
          } else {
            const { left: ce, width: Ae, height: ae } = I;
            if (c == "end") {
              const { bottom: pe } = this.layout.bbox;
              I = new BBox$2({ left: ce, bottom: pe, width: Ae, height: ae });
            } else if (c == "center") {
              const { vcenter: pe } = this.layout.bbox;
              I = new BBox$2({ left: ce, vcenter: Math.round(pe), width: Ae, height: ae });
            }
          }
          if (U != null) {
            const ce = I.left - H.left, Ae = I.top - H.top, { left: ae, top: pe, width: Ze, height: ze } = U;
            U = new BBox$2({ left: ae + ce, top: pe + Ae, width: Ze, height: ze });
          }
          return [I, U];
        };
        return;
      } else {
        const [I, U] = e;
        return M.fixup_geometry = (H, ce) => {
          const Ae = H, ae = this.layout.bbox, { width: pe, height: Ze } = H;
          if (H = new BBox$2({ left: ae.left + I, bottom: ae.bottom - U, width: pe, height: Ze }), ce != null) {
            const ze = H.left - Ae.left, et = H.top - Ae.top, { left: lt, top: bt, width: He, height: $e } = ce;
            ce = new BBox$2({ left: lt + ze, top: bt + et, width: He, height: $e });
          }
          return [H, ce];
        }, { left: I, right: 0, top: 0, bottom: U };
      }
    })();
    M.padding = S;
    let k, w, O, D;
    if (this.panel != null ? (k = "max", w = void 0, O = void 0, D = void 0) : (d == "horizontal" ? r : o) == "auto" ? (k = "fixed", w = this.model.color_mapper.palette.length * MINOR_DIM, O = { percent: MAJOR_DIM_MIN_SCALAR }, D = { percent: MAJOR_DIM_MAX_SCALAR }) : (k = "fit", w = void 0), d == "horizontal") {
      const I = r == "auto" ? void 0 : r, U = o == "auto" ? MINOR_DIM : o;
      M.set_sizing({
        width_policy: k,
        height_policy: "min",
        width: w,
        min_width: O,
        max_width: D,
        halign: u,
        valign: c,
        margin: E
      }), M.center_panel.set_sizing({ width_policy: r == "auto" ? "fit" : "fixed", height_policy: "fixed", width: I, height: U });
    } else {
      const I = r == "auto" ? MINOR_DIM : r, U = o == "auto" ? void 0 : o;
      M.set_sizing({
        width_policy: "min",
        height_policy: k,
        height: w,
        min_height: O,
        max_height: D,
        halign: u,
        valign: c,
        margin: E
      }), M.center_panel.set_sizing({ width_policy: "fixed", height_policy: o == "auto" ? "fit" : "fixed", width: I, height: U });
    }
    T.set_sizing({ width_policy: "fit", height_policy: "min" }), Q.set_sizing({ width_policy: "fit", height_policy: "min" }), m.set_sizing({ width_policy: "min", height_policy: "fit" }), g.set_sizing({ width_policy: "min", height_policy: "fit" });
    const { _title_view: R } = this;
    R != null && (d == "horizontal" ? (R.panel = new Panel$1("above"), R.update_layout(), T.children.push(R.layout)) : (R.panel = new Panel$1("left"), R.update_layout(), m.children.push(R.layout)));
    const { panel: B } = this, F = (() => B != null && d == B.orientation ? B.side : d == "horizontal" ? "below" : "right")(), j = (() => {
      switch (F) {
        case "above":
          return T;
        case "below":
          return Q;
        case "left":
          return m;
        case "right":
          return g;
      }
    })(), { _axis_view: z } = this;
    if (z.panel = new Panel$1(F), z.update_layout(), j.children.push(z.layout), this.panel != null) {
      const I = new Grid$1([{ layout: M, row: 0, col: 0 }]);
      I.absolute = !0, d == "horizontal" ? I.set_sizing({ width_policy: "max", height_policy: "min" }) : I.set_sizing({ width_policy: "min", height_policy: "max" }), this.layout = I;
    } else
      this.layout = this._inner_layout;
    const { visible: q } = this.model;
    this.layout.sizing.visible = q, this._set_canvas_image();
  }
  _render() {
    var r;
    const { ctx: e } = this.layer;
    e.save(), this._paint_bbox(e, this._inner_layout.bbox), this._paint_image(e, this._inner_layout.center_panel.bbox), (r = this._title_view) == null || r.render(), this._axis_view.render(), e.restore();
  }
  _paint_bbox(e, r) {
    const { x: o, y: s } = r;
    let { width: l, height: c } = r;
    o + l >= this.parent.canvas_view.bbox.width && (l -= 1), s + c >= this.parent.canvas_view.bbox.height && (c -= 1), e.save(), this.visuals.background_fill.doit && (this.visuals.background_fill.set_value(e), e.fillRect(o, s, l, c)), this.visuals.border_line.doit && (this.visuals.border_line.set_value(e), e.strokeRect(o, s, l, c)), e.restore();
  }
  _paint_image(e, r) {
    const { x: o, y: s, width: l, height: c } = r;
    e.save(), e.setImageSmoothingEnabled(!1), e.globalAlpha = this.model.scale_alpha, e.drawImage(this._image, o, s, l, c), this.visuals.bar_line.doit && (this.visuals.bar_line.set_value(e), e.strokeRect(o, s, l, c)), e.restore();
  }
  serializable_state() {
    const { children: e = [], ...r } = super.serializable_state();
    return this._title_view != null && e.push(this._title_view.serializable_state()), e.push(this._axis_view.serializable_state()), { ...r, children: e };
  }
}
ColorBarView.__name__ = "ColorBarView";
class ColorBar extends Annotation {
  constructor(e) {
    super(e);
  }
}
_a$2O = ColorBar;
ColorBar.__name__ = "ColorBar";
_a$2O.prototype.default_view = ColorBarView, _a$2O.mixins([
  ["major_label_", Text$3],
  ["title_", Text$3],
  ["major_tick_", Line$2],
  ["minor_tick_", Line$2],
  ["border_", Line$2],
  ["bar_", Line$2],
  ["background_", Fill$1]
]), _a$2O.define(({ Alpha: t, Number: e, String: r, Tuple: o, Dict: s, Or: l, Ref: c, Auto: u, Nullable: d }) => ({
  location: [l(Anchor, o(e, e)), "top_right"],
  orientation: [l(Orientation, u), "auto"],
  title: [d(r), null],
  title_standoff: [e, 2],
  width: [l(e, u), "auto"],
  height: [l(e, u), "auto"],
  scale_alpha: [t, 1],
  ticker: [l(c(Ticker), u), "auto"],
  formatter: [l(c(TickFormatter), u), "auto"],
  major_label_overrides: [s(l(r, c(BaseText))), {}],
  major_label_policy: [c(LabelingPolicy), () => new NoOverlap()],
  color_mapper: [c(ColorMapper)],
  label_standoff: [e, 5],
  margin: [e, 30],
  padding: [e, 10],
  major_tick_in: [e, 5],
  major_tick_out: [e, 0],
  minor_tick_in: [e, 0],
  minor_tick_out: [e, 0]
})), _a$2O.override({
  background_fill_color: "#ffffff",
  background_fill_alpha: 0.95,
  bar_line_color: null,
  border_line_color: null,
  major_label_text_font_size: "11px",
  major_tick_line_color: "#ffffff",
  minor_tick_line_color: null,
  title_text_font_size: "13px",
  title_text_font_style: "italic"
});
var _a$2N;
class LabelView extends TextAnnotationView {
  update_layout() {
    const { panel: e } = this;
    e != null ? this.layout = new SideLayout(e, () => this.get_size(), !1) : this.layout = void 0;
  }
  _get_size() {
    const { text: e } = this.model, r = new TextBox({ text: e }), { angle: o, angle_units: s } = this.model;
    r.angle = resolve_angle(o, s), r.visuals = this.visuals.text.values();
    const { width: l, height: c } = r.size();
    return { width: l, height: c };
  }
  _render() {
    const { angle: e, angle_units: r } = this.model, o = resolve_angle(e, r), s = this.layout != null ? this.layout : this.plot_view.frame, l = this.coordinates.x_scale, c = this.coordinates.y_scale;
    let u = this.model.x_units == "data" ? l.compute(this.model.x) : s.bbox.xview.compute(this.model.x), d = this.model.y_units == "data" ? c.compute(this.model.y) : s.bbox.yview.compute(this.model.y);
    u += this.model.x_offset, d -= this.model.y_offset, (this.model.render_mode == "canvas" ? this._canvas_text.bind(this) : this._css_text.bind(this))(this.layer.ctx, this.model.text, u, d, o);
  }
}
LabelView.__name__ = "LabelView";
class Label extends TextAnnotation {
  constructor(e) {
    super(e);
  }
}
_a$2N = Label;
Label.__name__ = "Label";
_a$2N.prototype.default_view = LabelView, _a$2N.mixins([
  Text$3,
  ["border_", Line$2],
  ["background_", Fill$1]
]), _a$2N.define(({ Number: t, String: e, Angle: r }) => ({
  x: [t],
  x_units: [SpatialUnits, "data"],
  y: [t],
  y_units: [SpatialUnits, "data"],
  text: [e, ""],
  angle: [r, 0],
  angle_units: [AngleUnits, "rad"],
  x_offset: [t, 0],
  y_offset: [t, 0]
})), _a$2N.override({
  background_fill_color: null,
  border_line_color: null
});
var _a$2M;
class LabelSetView extends DataAnnotationView {
  set_data(e) {
    var r;
    if (super.set_data(e), (r = this.els) == null || r.forEach((o) => remove(o)), this.model.render_mode == "css") {
      const o = this.els = [...this.text].map(() => div({ style: { display: "none" } }));
      for (const s of o)
        this.plot_view.canvas_view.add_overlay(s);
    } else
      delete this.els;
  }
  remove() {
    var e;
    (e = this.els) == null || e.forEach((r) => remove(r)), super.remove();
  }
  _rerender() {
    this.model.render_mode == "css" ? this.render() : this.request_render();
  }
  map_data() {
    const { x_scale: e, y_scale: r } = this.coordinates, o = this.layout != null ? this.layout : this.plot_view.frame;
    this.sx = this.model.x_units == "data" ? e.v_compute(this._x) : o.bbox.xview.v_compute(this._x), this.sy = this.model.y_units == "data" ? r.v_compute(this._y) : o.bbox.yview.v_compute(this._y);
  }
  paint() {
    const e = this.model.render_mode == "canvas" ? this._v_canvas_text.bind(this) : this._v_css_text.bind(this), { ctx: r } = this.layer;
    for (let o = 0, s = this.text.length; o < s; o++) {
      const l = this.x_offset.get(o), c = this.y_offset.get(o), u = this.sx[o] + l, d = this.sy[o] - c, f = this.angle.get(o), T = this.text.get(o);
      e(r, o, T, u, d, f);
    }
  }
  _v_canvas_text(e, r, o, s, l, c) {
    const u = new TextBox({ text: o });
    u.angle = c, u.position = { sx: s, sy: l }, u.visuals = this.visuals.text.values(r);
    const { background_fill: d, border_line: f } = this.visuals;
    if (d.doit || f.doit) {
      const { p0: T, p1: Q, p2: m, p3: g } = u.rect();
      e.beginPath(), e.moveTo(T.x, T.y), e.lineTo(Q.x, Q.y), e.lineTo(m.x, m.y), e.lineTo(g.x, g.y), e.closePath(), this.visuals.background_fill.apply(e, r), this.visuals.border_line.apply(e, r);
    }
    this.visuals.text.doit && u.paint(e);
  }
  _v_css_text(e, r, o, s, l, c) {
    assert(this.els != null);
    const u = this.els[r];
    u.textContent = o, this.visuals.text.set_vectorize(e, r), u.style.position = "absolute", u.style.left = `${s}px`, u.style.top = `${l}px`, u.style.color = e.fillStyle, u.style.font = e.font, u.style.lineHeight = "normal", u.style.whiteSpace = "pre";
    const [d, f] = (() => {
      switch (this.visuals.text.text_align.get(r)) {
        case "left":
          return ["left", "0%"];
        case "center":
          return ["center", "-50%"];
        case "right":
          return ["right", "-100%"];
      }
    })(), [T, Q] = (() => {
      switch (this.visuals.text.text_baseline.get(r)) {
        case "top":
          return ["top", "0%"];
        case "middle":
          return ["center", "-50%"];
        case "bottom":
          return ["bottom", "-100%"];
        default:
          return ["center", "-50%"];
      }
    })();
    let m = `translate(${f}, ${Q})`;
    c && (m += `rotate(${c}rad)`), u.style.transformOrigin = `${d} ${T}`, u.style.transform = m, this.layout == null, this.visuals.background_fill.doit && (this.visuals.background_fill.set_vectorize(e, r), u.style.backgroundColor = e.fillStyle), this.visuals.border_line.doit && (this.visuals.border_line.set_vectorize(e, r), u.style.borderStyle = e.lineDash.length < 2 ? "solid" : "dashed", u.style.borderWidth = `${e.lineWidth}px`, u.style.borderColor = e.strokeStyle), display(u);
  }
}
LabelSetView.__name__ = "LabelSetView";
class LabelSet extends DataAnnotation {
  constructor(e) {
    super(e);
  }
}
_a$2M = LabelSet;
LabelSet.__name__ = "LabelSet";
_a$2M.prototype.default_view = LabelSetView, _a$2M.mixins([
  TextVector$1,
  ["border_", LineVector$1],
  ["background_", FillVector$1]
]), _a$2M.define(() => ({
  x: [XCoordinateSpec, { field: "x" }],
  y: [YCoordinateSpec, { field: "y" }],
  x_units: [SpatialUnits, "data"],
  y_units: [SpatialUnits, "data"],
  text: [StringSpec, { field: "text" }],
  angle: [AngleSpec, 0],
  x_offset: [NumberSpec, { value: 0 }],
  y_offset: [NumberSpec, { value: 0 }],
  render_mode: [RenderMode, "canvas"]
})), _a$2M.override({
  background_fill_color: null,
  border_line_color: null
});
function isValue(t) {
  return isPlainObject(t) && "value" in t;
}
function isField(t) {
  return isPlainObject(t) && "field" in t;
}
var _a$2L;
class LegendItem extends Model {
  constructor(e) {
    super(e);
  }
  _check_data_sources_on_renderers() {
    if (this.get_field_from_label_prop() != null) {
      if (this.renderers.length < 1)
        return !1;
      const r = this.renderers[0].data_source;
      if (r != null) {
        for (const o of this.renderers)
          if (o.data_source != r)
            return !1;
      }
    }
    return !0;
  }
  _check_field_label_on_data_source() {
    const e = this.get_field_from_label_prop();
    if (e != null) {
      if (this.renderers.length < 1)
        return !1;
      const r = this.renderers[0].data_source;
      if (r != null && !includes(r.columns(), e))
        return !1;
    }
    return !0;
  }
  initialize() {
    super.initialize(), this.legend = null, this.connect(this.change, () => {
      var o;
      return (o = this.legend) == null ? void 0 : o.item_change.emit();
    }), this._check_data_sources_on_renderers() || logger.error("Non matching data sources on legend item renderers"), this._check_field_label_on_data_source() || logger.error(`Bad column name on label: ${this.label}`);
  }
  get_field_from_label_prop() {
    const { label: e } = this;
    return isField(e) ? e.field : null;
  }
  get_labels_list_from_label_prop() {
    if (!this.visible)
      return [];
    if (isValue(this.label)) {
      const { value: r } = this.label;
      return r != null ? [r] : [];
    }
    const e = this.get_field_from_label_prop();
    if (e != null) {
      let r;
      if (this.renderers[0] && this.renderers[0].data_source != null)
        r = this.renderers[0].data_source;
      else
        return ["No source found"];
      if (r instanceof ColumnarDataSource) {
        const o = r.get_column(e);
        return o != null ? uniq(Array.from(o)) : ["Invalid field"];
      }
    }
    return [];
  }
}
_a$2L = LegendItem;
LegendItem.__name__ = "LegendItem";
_a$2L.define(({ Boolean: t, Int: e, Array: r, Ref: o, Nullable: s }) => ({
  label: [NullStringSpec, null],
  renderers: [r(o(GlyphRenderer)), []],
  index: [s(e), null],
  visible: [t, !0]
}));
var _a$2K;
class LegendView extends AnnotationView {
  update_layout() {
    const { panel: e } = this;
    e != null ? this.layout = new SideLayout(e, () => this.get_size()) : this.layout = void 0;
  }
  cursor(e, r) {
    return this.model.click_policy == "none" ? null : "pointer";
  }
  get legend_padding() {
    return this.model.border_line_color != null ? this.model.padding : 0;
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.change, () => this.request_render()), this.connect(this.model.item_change, () => this.request_render());
  }
  compute_legend_bbox() {
    const e = this.model.get_legend_names(), { glyph_height: r, glyph_width: o } = this.model, { label_height: s, label_width: l } = this.model;
    this.max_label_height = max$8([font_metrics(this.visuals.label_text.font_value()).height, s, r]);
    const { ctx: c } = this.layer;
    c.save(), this.visuals.label_text.set_value(c), this.text_widths = /* @__PURE__ */ new Map();
    for (const E of e)
      this.text_widths.set(E, max$8([c.measureText(E).width, l]));
    this.visuals.title_text.set_value(c), this.title_height = this.model.title ? font_metrics(this.visuals.title_text.font_value()).height + this.model.title_standoff : 0, this.title_width = this.model.title ? c.measureText(this.model.title).width : 0, c.restore();
    const u = Math.max(max$8([...this.text_widths.values()]), 0), d = this.model.margin, { legend_padding: f } = this, T = this.model.spacing, { label_standoff: Q } = this.model;
    let m, g;
    if (this.model.orientation == "vertical")
      m = e.length * this.max_label_height + Math.max(e.length - 1, 0) * T + 2 * f + this.title_height, g = max$8([u + o + Q + 2 * f, this.title_width + 2 * f]);
    else {
      let E = 2 * f + Math.max(e.length - 1, 0) * T;
      for (const [, k] of this.text_widths)
        E += max$8([k, l]) + o + Q;
      g = max$8([this.title_width + 2 * f, E]), m = this.max_label_height + this.title_height + 2 * f;
    }
    const v = this.layout != null ? this.layout : this.plot_view.frame, [b, L] = v.bbox.ranges, { location: A } = this.model;
    let M, S;
    if (isString(A))
      switch (A) {
        case "top_left":
          M = b.start + d, S = L.start + d;
          break;
        case "top":
        case "top_center":
          M = (b.end + b.start) / 2 - g / 2, S = L.start + d;
          break;
        case "top_right":
          M = b.end - d - g, S = L.start + d;
          break;
        case "bottom_right":
          M = b.end - d - g, S = L.end - d - m;
          break;
        case "bottom":
        case "bottom_center":
          M = (b.end + b.start) / 2 - g / 2, S = L.end - d - m;
          break;
        case "bottom_left":
          M = b.start + d, S = L.end - d - m;
          break;
        case "left":
        case "center_left":
          M = b.start + d, S = (L.end + L.start) / 2 - m / 2;
          break;
        case "center":
        case "center_center":
          M = (b.end + b.start) / 2 - g / 2, S = (L.end + L.start) / 2 - m / 2;
          break;
        case "right":
        case "center_right":
          M = b.end - d - g, S = (L.end + L.start) / 2 - m / 2;
          break;
      }
    else if (isArray(A) && A.length == 2) {
      const [E, k] = A;
      M = v.bbox.xview.compute(E), S = v.bbox.yview.compute(k) - m;
    } else
      unreachable();
    return new BBox$2({ left: M, top: S, width: g, height: m });
  }
  interactive_bbox() {
    return this.compute_legend_bbox();
  }
  interactive_hit(e, r) {
    return this.interactive_bbox().contains(e, r);
  }
  on_hit(e, r) {
    let o;
    const { glyph_width: s } = this.model, { legend_padding: l } = this, c = this.model.spacing, { label_standoff: u } = this.model;
    let d = o = l;
    const f = this.compute_legend_bbox(), T = this.model.orientation == "vertical";
    for (const Q of this.model.items) {
      const m = Q.get_labels_list_from_label_prop();
      for (const g of m) {
        const v = f.x + d, b = f.y + o + this.title_height;
        let L, A;
        if (T ? [L, A] = [f.width - 2 * l, this.max_label_height] : [L, A] = [this.text_widths.get(g) + s + u, this.max_label_height], new BBox$2({ left: v, top: b, width: L, height: A }).contains(e, r)) {
          switch (this.model.click_policy) {
            case "hide": {
              for (const S of Q.renderers)
                S.visible = !S.visible;
              break;
            }
            case "mute": {
              for (const S of Q.renderers)
                S.muted = !S.muted;
              break;
            }
          }
          return !0;
        }
        T ? o += this.max_label_height + c : d += this.text_widths.get(g) + s + u + c;
      }
    }
    return !1;
  }
  _render() {
    if (this.model.items.length == 0 || !some(this.model.items, (o) => o.visible))
      return;
    for (const o of this.model.items)
      o.legend = this.model;
    const { ctx: e } = this.layer, r = this.compute_legend_bbox();
    e.save(), this._draw_legend_box(e, r), this._draw_legend_items(e, r), this._draw_title(e, r), e.restore();
  }
  _draw_legend_box(e, r) {
    e.beginPath(), e.rect(r.x, r.y, r.width, r.height), this.visuals.background_fill.apply(e), this.visuals.border_line.apply(e);
  }
  _draw_legend_items(e, r) {
    const { glyph_width: o, glyph_height: s } = this.model, { legend_padding: l } = this, c = this.model.spacing, { label_standoff: u } = this.model;
    let d = l, f = l;
    const T = this.model.orientation == "vertical";
    for (const Q of this.model.items) {
      if (!Q.visible)
        continue;
      const m = Q.get_labels_list_from_label_prop(), g = Q.get_field_from_label_prop();
      if (m.length == 0)
        continue;
      const v = (() => {
        switch (this.model.click_policy) {
          case "none":
            return !0;
          case "hide":
            return every(Q.renderers, (b) => b.visible);
          case "mute":
            return every(Q.renderers, (b) => !b.muted);
        }
      })();
      for (const b of m) {
        const L = r.x + d, A = r.y + f + this.title_height, M = L + o, S = A + s;
        T ? f += this.max_label_height + c : d += this.text_widths.get(b) + o + u + c, this.visuals.label_text.set_value(e), e.fillText(b, M + u, A + this.max_label_height / 2);
        for (const E of Q.renderers) {
          const k = this.plot_view.renderer_view(E);
          k == null || k.draw_legend(e, L, M, A, S, g, b, Q.index);
        }
        if (!v) {
          let E, k;
          T ? [E, k] = [r.width - 2 * l, this.max_label_height] : [E, k] = [this.text_widths.get(b) + o + u, this.max_label_height], e.beginPath(), e.rect(L, A, E, k), this.visuals.inactive_fill.set_value(e), e.fill();
        }
      }
    }
  }
  _draw_title(e, r) {
    const { title: o } = this.model;
    !o || !this.visuals.title_text.doit || (e.save(), e.translate(r.x0, r.y0 + this.title_height), this.visuals.title_text.set_value(e), e.fillText(o, this.legend_padding, this.legend_padding - this.model.title_standoff), e.restore());
  }
  _get_size() {
    const { width: e, height: r } = this.compute_legend_bbox();
    return {
      width: e + 2 * this.model.margin,
      height: r + 2 * this.model.margin
    };
  }
}
LegendView.__name__ = "LegendView";
class Legend extends Annotation {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this.item_change = new Signal0(this, "item_change");
  }
  get_legend_names() {
    const e = [];
    for (const r of this.items) {
      const o = r.get_labels_list_from_label_prop();
      e.push(...o);
    }
    return e;
  }
}
_a$2K = Legend;
Legend.__name__ = "Legend";
_a$2K.prototype.default_view = LegendView, _a$2K.mixins([
  ["label_", Text$3],
  ["title_", Text$3],
  ["inactive_", Fill$1],
  ["border_", Line$2],
  ["background_", Fill$1]
]), _a$2K.define(({ Number: t, String: e, Array: r, Tuple: o, Or: s, Ref: l, Nullable: c }) => ({
  orientation: [Orientation, "vertical"],
  location: [s(LegendLocation, o(t, t)), "top_right"],
  title: [c(e), null],
  title_standoff: [t, 5],
  label_standoff: [t, 5],
  glyph_height: [t, 20],
  glyph_width: [t, 20],
  label_height: [t, 20],
  label_width: [t, 20],
  margin: [t, 10],
  padding: [t, 10],
  spacing: [t, 3],
  items: [r(l(LegendItem)), []],
  click_policy: [LegendClickPolicy, "none"]
})), _a$2K.override({
  border_line_color: "#e5e5e5",
  border_line_alpha: 0.5,
  border_line_width: 1,
  background_fill_color: "#ffffff",
  background_fill_alpha: 0.95,
  inactive_fill_color: "white",
  inactive_fill_alpha: 0.7,
  label_text_font_size: "13px",
  label_text_baseline: "middle",
  title_text_font_size: "13px",
  title_text_font_style: "italic"
});
var _a$2J;
class PolyAnnotationView extends AnnotationView {
  connect_signals() {
    super.connect_signals(), this.connect(this.model.change, () => this.request_render());
  }
  _render() {
    const { xs: e, ys: r } = this.model;
    if (e.length != r.length)
      return;
    const o = e.length;
    if (o < 3)
      return;
    const { frame: s } = this.plot_view, { ctx: l } = this.layer, c = this.coordinates.x_scale, u = this.coordinates.y_scale, { screen: d } = this.model;
    function f(m, g, v, b) {
      return d ? m : g == "data" ? v.v_compute(m) : b.v_compute(m);
    }
    const T = f(e, this.model.xs_units, c, s.bbox.xview), Q = f(r, this.model.ys_units, u, s.bbox.yview);
    l.beginPath();
    for (let m = 0; m < o; m++)
      l.lineTo(T[m], Q[m]);
    l.closePath(), this.visuals.fill.apply(l), this.visuals.hatch.apply(l), this.visuals.line.apply(l);
  }
}
PolyAnnotationView.__name__ = "PolyAnnotationView";
class PolyAnnotation extends Annotation {
  constructor(e) {
    super(e);
  }
  update({ xs: e, ys: r }) {
    this.setv({ xs: e, ys: r, screen: !0 }, { check_eq: !1 });
  }
}
_a$2J = PolyAnnotation;
PolyAnnotation.__name__ = "PolyAnnotation";
_a$2J.prototype.default_view = PolyAnnotationView, _a$2J.mixins([Line$2, Fill$1, Hatch$1]), _a$2J.define(({ Number: t, Array: e }) => ({
  xs: [e(t), []],
  xs_units: [SpatialUnits, "data"],
  ys: [e(t), []],
  ys_units: [SpatialUnits, "data"]
})), _a$2J.internal(({ Boolean: t }) => ({
  screen: [t, !1]
})), _a$2J.override({
  fill_color: "#fff9ba",
  fill_alpha: 0.4,
  line_color: "#cccccc",
  line_alpha: 0.3
});
var _a$2I;
class SlopeView extends AnnotationView {
  connect_signals() {
    super.connect_signals(), this.connect(this.model.change, () => this.request_render());
  }
  _render() {
    const { gradient: e, y_intercept: r } = this.model;
    if (e == null || r == null)
      return;
    const { frame: o } = this.plot_view, s = this.coordinates.x_scale, l = this.coordinates.y_scale;
    let c, u, d, f;
    if (e == 0)
      c = l.compute(r), u = c, d = o.bbox.left, f = d + o.bbox.width;
    else {
      c = o.bbox.top, u = c + o.bbox.height;
      const Q = l.invert(c), m = l.invert(u), g = (Q - r) / e, v = (m - r) / e;
      d = s.compute(g), f = s.compute(v);
    }
    const { ctx: T } = this.layer;
    T.save(), T.beginPath(), this.visuals.line.set_value(T), T.moveTo(d, c), T.lineTo(f, u), T.stroke(), T.restore();
  }
}
SlopeView.__name__ = "SlopeView";
class Slope extends Annotation {
  constructor(e) {
    super(e);
  }
}
_a$2I = Slope;
Slope.__name__ = "Slope";
_a$2I.prototype.default_view = SlopeView, _a$2I.mixins(Line$2), _a$2I.define(({ Number: t, Nullable: e }) => ({
  gradient: [e(t), null],
  y_intercept: [e(t), null]
})), _a$2I.override({
  line_color: "black"
});
var _a$2H;
class SpanView$1 extends AnnotationView {
  connect_signals() {
    super.connect_signals(), this.connect(this.model.change, () => this.plot_view.request_paint(this));
  }
  _render() {
    const { location: e } = this.model;
    if (e == null)
      return;
    const { frame: r } = this.plot_view, o = this.coordinates.x_scale, s = this.coordinates.y_scale, l = (Q, m) => this.model.location_units == "data" ? Q.compute(e) : this.model.for_hover ? e : m.compute(e);
    let c, u, d, f;
    this.model.dimension == "width" ? (d = l(s, r.bbox.yview), u = r.bbox.left, f = r.bbox.width, c = this.model.line_width) : (d = r.bbox.top, u = l(o, r.bbox.xview), f = this.model.line_width, c = r.bbox.height);
    const { ctx: T } = this.layer;
    T.save(), T.beginPath(), this.visuals.line.set_value(T), T.moveTo(u, d), this.model.dimension == "width" ? T.lineTo(u + f, d) : T.lineTo(u, d + c), T.stroke(), T.restore();
  }
}
SpanView$1.__name__ = "SpanView";
class Span$1 extends Annotation {
  constructor(e) {
    super(e);
  }
}
_a$2H = Span$1;
Span$1.__name__ = "Span";
_a$2H.prototype.default_view = SpanView$1, _a$2H.mixins(Line$2), _a$2H.define(({ Number: t, Nullable: e }) => ({
  render_mode: [RenderMode, "canvas"],
  location: [e(t), null],
  location_units: [SpatialUnits, "data"],
  dimension: [Dimension, "width"]
})), _a$2H.internal(({ Boolean: t }) => ({
  for_hover: [t, !1]
})), _a$2H.override({
  line_color: "black"
});
var _a$2G;
class ToolView extends View {
  get plot_view() {
    return this.parent;
  }
  get plot_model() {
    return this.parent.model;
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.properties.active.change, () => {
      this.model.active ? this.activate() : this.deactivate();
    });
  }
  activate() {
  }
  deactivate() {
  }
}
ToolView.__name__ = "ToolView";
class Tool extends Model {
  constructor(e) {
    super(e);
  }
  get synthetic_renderers() {
    return [];
  }
  _get_dim_limits([e, r], [o, s], l, c) {
    const u = l.bbox.h_range;
    let d;
    c == "width" || c == "both" ? (d = [min$6([e, o]), max$8([e, o])], d = [max$8([d[0], u.start]), min$6([d[1], u.end])]) : d = [u.start, u.end];
    const f = l.bbox.v_range;
    let T;
    return c == "height" || c == "both" ? (T = [min$6([r, s]), max$8([r, s])], T = [max$8([T[0], f.start]), min$6([T[1], f.end])]) : T = [f.start, f.end], [d, T];
  }
  static register_alias(e, r) {
    this.prototype._known_aliases.set(e, r);
  }
  static from_string(e) {
    const r = this.prototype._known_aliases.get(e);
    if (r != null)
      return r();
    {
      const o = [...this.prototype._known_aliases.keys()];
      throw new Error(`unexpected tool name '${e}', possible tools are ${o.join(", ")}`);
    }
  }
}
_a$2G = Tool;
Tool.__name__ = "Tool";
_a$2G.prototype._known_aliases = /* @__PURE__ */ new Map(), _a$2G.define(({ String: t, Nullable: e }) => ({
  description: [e(t), null]
})), _a$2G.internal(({ Boolean: t }) => ({
  active: [t, !1]
}));
var hammer = { exports: {} };
/*! Hammer.JS - v2.0.7 - 2016-04-22
 * http://hammerjs.github.io/
 *
 * Copyright (c) 2016 Jorik Tangelder;
 * Licensed under the MIT license */
(function(t) {
  (function(e, r, o, s) {
    var l = ["", "webkit", "Moz", "MS", "ms", "o"], c = r.createElement("div"), u = "function", d = Math.round, f = Math.abs, T = Date.now;
    function Q(X, ee, fe) {
      return setTimeout(S(X, fe), ee);
    }
    function m(X, ee, fe) {
      return Array.isArray(X) ? (g(X, fe[ee], fe), !0) : !1;
    }
    function g(X, ee, fe) {
      var Pe;
      if (!!X)
        if (X.forEach)
          X.forEach(ee, fe);
        else if (X.length !== s)
          for (Pe = 0; Pe < X.length; )
            ee.call(fe, X[Pe], Pe, X), Pe++;
        else
          for (Pe in X)
            X.hasOwnProperty(Pe) && ee.call(fe, X[Pe], Pe, X);
    }
    function v(X, ee, fe) {
      var Pe = "DEPRECATED METHOD: " + ee + `
` + fe + ` AT 
`;
      return function() {
        var vt = new Error("get-stack-trace"), a1 = vt && vt.stack ? vt.stack.replace(/^[^\(]+?[\n$]/gm, "").replace(/^\s+at\s+/gm, "").replace(/^Object.<anonymous>\s*\(/gm, "{anonymous}()@") : "Unknown Stack Trace", Te = e.console && (e.console.warn || e.console.log);
        return Te && Te.call(e.console, Pe, a1), X.apply(this, arguments);
      };
    }
    var b;
    typeof Object.assign != "function" ? b = function(ee) {
      if (ee === s || ee === null)
        throw new TypeError("Cannot convert undefined or null to object");
      for (var fe = Object(ee), Pe = 1; Pe < arguments.length; Pe++) {
        var vt = arguments[Pe];
        if (vt !== s && vt !== null)
          for (var a1 in vt)
            vt.hasOwnProperty(a1) && (fe[a1] = vt[a1]);
      }
      return fe;
    } : b = Object.assign;
    var L = v(function(ee, fe, Pe) {
      for (var vt = Object.keys(fe), a1 = 0; a1 < vt.length; )
        (!Pe || Pe && ee[vt[a1]] === s) && (ee[vt[a1]] = fe[vt[a1]]), a1++;
      return ee;
    }, "extend", "Use `assign`."), A = v(function(ee, fe) {
      return L(ee, fe, !0);
    }, "merge", "Use `assign`.");
    function M(X, ee, fe) {
      var Pe = ee.prototype, vt;
      vt = X.prototype = Object.create(Pe), vt.constructor = X, vt._super = Pe, fe && b(vt, fe);
    }
    function S(X, ee) {
      return function() {
        return X.apply(ee, arguments);
      };
    }
    function E(X, ee) {
      return typeof X == u ? X.apply(ee && ee[0] || s, ee) : X;
    }
    function k(X, ee) {
      return X === s ? ee : X;
    }
    function w(X, ee, fe) {
      g(B(ee), function(Pe) {
        X.addEventListener(Pe, fe, !1);
      });
    }
    function O(X, ee, fe) {
      g(B(ee), function(Pe) {
        X.removeEventListener(Pe, fe, !1);
      });
    }
    function D(X, ee) {
      for (; X; ) {
        if (X == ee)
          return !0;
        X = X.parentNode;
      }
      return !1;
    }
    function R(X, ee) {
      return X.indexOf(ee) > -1;
    }
    function B(X) {
      return X.trim().split(/\s+/g);
    }
    function F(X, ee, fe) {
      if (X.indexOf && !fe)
        return X.indexOf(ee);
      for (var Pe = 0; Pe < X.length; ) {
        if (fe && X[Pe][fe] == ee || !fe && X[Pe] === ee)
          return Pe;
        Pe++;
      }
      return -1;
    }
    function j(X) {
      return Array.prototype.slice.call(X, 0);
    }
    function z(X, ee, fe) {
      for (var Pe = [], vt = [], a1 = 0; a1 < X.length; ) {
        var Te = ee ? X[a1][ee] : X[a1];
        F(vt, Te) < 0 && Pe.push(X[a1]), vt[a1] = Te, a1++;
      }
      return fe && (ee ? Pe = Pe.sort(function(Ge, _t) {
        return Ge[ee] > _t[ee];
      }) : Pe = Pe.sort()), Pe;
    }
    function q(X, ee) {
      for (var fe, Pe, vt = ee[0].toUpperCase() + ee.slice(1), a1 = 0; a1 < l.length; ) {
        if (fe = l[a1], Pe = fe ? fe + vt : ee, Pe in X)
          return Pe;
        a1++;
      }
      return s;
    }
    var I = 1;
    function U() {
      return I++;
    }
    function H(X) {
      var ee = X.ownerDocument || X;
      return ee.defaultView || ee.parentWindow || e;
    }
    var ce = /mobile|tablet|ip(ad|hone|od)|android/i, Ae = "ontouchstart" in e, ae = q(e, "PointerEvent") !== s, pe = Ae && ce.test(navigator.userAgent), Ze = "touch", ze = "pen", et = "mouse", lt = "kinect", bt = 25, He = 1, $e = 2, Ye = 4, tt = 8, dt = 1, Wt = 2, pt = 4, Rt = 8, Yt = 16, Et = Wt | pt, d1 = Rt | Yt, b1 = Et | d1, Y1 = ["x", "y"], nr = ["clientX", "clientY"];
    function F1(X, ee) {
      var fe = this;
      this.manager = X, this.callback = ee, this.element = X.element, this.target = X.options.inputTarget, this.domHandler = function(Pe) {
        E(X.options.enable, [X]) && fe.handler(Pe);
      }, this.init();
    }
    F1.prototype = {
      handler: function() {
      },
      init: function() {
        this.evEl && w(this.element, this.evEl, this.domHandler), this.evTarget && w(this.target, this.evTarget, this.domHandler), this.evWin && w(H(this.element), this.evWin, this.domHandler);
      },
      destroy: function() {
        this.evEl && O(this.element, this.evEl, this.domHandler), this.evTarget && O(this.target, this.evTarget, this.domHandler), this.evWin && O(H(this.element), this.evWin, this.domHandler);
      }
    };
    function qr(X) {
      var ee, fe = X.options.inputClass;
      return fe ? ee = fe : ae ? ee = Er : pe ? ee = pn : Ae ? ee = Ln : ee = tr, new ee(X, te);
    }
    function te(X, ee, fe) {
      var Pe = fe.pointers.length, vt = fe.changedPointers.length, a1 = ee & He && Pe - vt === 0, Te = ee & (Ye | tt) && Pe - vt === 0;
      fe.isFirst = !!a1, fe.isFinal = !!Te, a1 && (X.session = {}), fe.eventType = ee, vr(X, fe), X.emit("hammer.input", fe), X.recognize(fe), X.session.prevInput = fe;
    }
    function vr(X, ee) {
      var fe = X.session, Pe = ee.pointers, vt = Pe.length;
      fe.firstInput || (fe.firstInput = ge(ee)), vt > 1 && !fe.firstMultiple ? fe.firstMultiple = ge(ee) : vt === 1 && (fe.firstMultiple = !1);
      var a1 = fe.firstInput, Te = fe.firstMultiple, Ee = Te ? Te.center : a1.center, Ge = ee.center = Y(Pe);
      ee.timeStamp = T(), ee.deltaTime = ee.timeStamp - a1.timeStamp, ee.angle = S1(Ee, Ge), ee.distance = o1(Ee, Ge), Ir(fe, ee), ee.offsetDirection = r1(ee.deltaX, ee.deltaY);
      var _t = Ot(ee.deltaTime, ee.deltaX, ee.deltaY);
      ee.overallVelocityX = _t.x, ee.overallVelocityY = _t.y, ee.overallVelocity = f(_t.x) > f(_t.y) ? _t.x : _t.y, ee.scale = Te ? sr(Te.pointers, Pe) : 1, ee.rotation = Te ? O1(Te.pointers, Pe) : 0, ee.maxPointers = fe.prevInput ? ee.pointers.length > fe.prevInput.maxPointers ? ee.pointers.length : fe.prevInput.maxPointers : ee.pointers.length, Hr(fe, ee);
      var Ut = X.element;
      D(ee.srcEvent.target, Ut) && (Ut = ee.srcEvent.target), ee.target = Ut;
    }
    function Ir(X, ee) {
      var fe = ee.center, Pe = X.offsetDelta || {}, vt = X.prevDelta || {}, a1 = X.prevInput || {};
      (ee.eventType === He || a1.eventType === Ye) && (vt = X.prevDelta = {
        x: a1.deltaX || 0,
        y: a1.deltaY || 0
      }, Pe = X.offsetDelta = {
        x: fe.x,
        y: fe.y
      }), ee.deltaX = vt.x + (fe.x - Pe.x), ee.deltaY = vt.y + (fe.y - Pe.y);
    }
    function Hr(X, ee) {
      var fe = X.lastInterval || ee, Pe = ee.timeStamp - fe.timeStamp, vt, a1, Te, Ee;
      if (ee.eventType != tt && (Pe > bt || fe.velocity === s)) {
        var Ge = ee.deltaX - fe.deltaX, _t = ee.deltaY - fe.deltaY, Ut = Ot(Pe, Ge, _t);
        a1 = Ut.x, Te = Ut.y, vt = f(Ut.x) > f(Ut.y) ? Ut.x : Ut.y, Ee = r1(Ge, _t), X.lastInterval = ee;
      } else
        vt = fe.velocity, a1 = fe.velocityX, Te = fe.velocityY, Ee = fe.direction;
      ee.velocity = vt, ee.velocityX = a1, ee.velocityY = Te, ee.direction = Ee;
    }
    function ge(X) {
      for (var ee = [], fe = 0; fe < X.pointers.length; )
        ee[fe] = {
          clientX: d(X.pointers[fe].clientX),
          clientY: d(X.pointers[fe].clientY)
        }, fe++;
      return {
        timeStamp: T(),
        pointers: ee,
        center: Y(ee),
        deltaX: X.deltaX,
        deltaY: X.deltaY
      };
    }
    function Y(X) {
      var ee = X.length;
      if (ee === 1)
        return {
          x: d(X[0].clientX),
          y: d(X[0].clientY)
        };
      for (var fe = 0, Pe = 0, vt = 0; vt < ee; )
        fe += X[vt].clientX, Pe += X[vt].clientY, vt++;
      return {
        x: d(fe / ee),
        y: d(Pe / ee)
      };
    }
    function Ot(X, ee, fe) {
      return {
        x: ee / X || 0,
        y: fe / X || 0
      };
    }
    function r1(X, ee) {
      return X === ee ? dt : f(X) >= f(ee) ? X < 0 ? Wt : pt : ee < 0 ? Rt : Yt;
    }
    function o1(X, ee, fe) {
      fe || (fe = Y1);
      var Pe = ee[fe[0]] - X[fe[0]], vt = ee[fe[1]] - X[fe[1]];
      return Math.sqrt(Pe * Pe + vt * vt);
    }
    function S1(X, ee, fe) {
      fe || (fe = Y1);
      var Pe = ee[fe[0]] - X[fe[0]], vt = ee[fe[1]] - X[fe[1]];
      return Math.atan2(vt, Pe) * 180 / Math.PI;
    }
    function O1(X, ee) {
      return S1(ee[1], ee[0], nr) + S1(X[1], X[0], nr);
    }
    function sr(X, ee) {
      return o1(ee[0], ee[1], nr) / o1(X[0], X[1], nr);
    }
    var m1 = {
      mousedown: He,
      mousemove: $e,
      mouseup: Ye
    }, W1 = "mousedown", er = "mousemove mouseup";
    function tr() {
      this.evEl = W1, this.evWin = er, this.pressed = !1, F1.apply(this, arguments);
    }
    M(tr, F1, {
      handler: function(ee) {
        var fe = m1[ee.type];
        fe & He && ee.button === 0 && (this.pressed = !0), fe & $e && ee.which !== 1 && (fe = Ye), this.pressed && (fe & Ye && (this.pressed = !1), this.callback(this.manager, fe, {
          pointers: [ee],
          changedPointers: [ee],
          pointerType: et,
          srcEvent: ee
        }));
      }
    });
    var B1 = {
      pointerdown: He,
      pointermove: $e,
      pointerup: Ye,
      pointercancel: tt,
      pointerout: tt
    }, br = {
      2: Ze,
      3: ze,
      4: et,
      5: lt
    }, cr = "pointerdown", _r = "pointermove pointerup pointercancel";
    e.MSPointerEvent && !e.PointerEvent && (cr = "MSPointerDown", _r = "MSPointerMove MSPointerUp MSPointerCancel");
    function Er() {
      this.evEl = cr, this.evWin = _r, F1.apply(this, arguments), this.store = this.manager.session.pointerEvents = [];
    }
    M(Er, F1, {
      handler: function(ee) {
        var fe = this.store, Pe = !1, vt = ee.type.toLowerCase().replace("ms", ""), a1 = B1[vt], Te = br[ee.pointerType] || ee.pointerType, Ee = Te == Ze, Ge = F(fe, ee.pointerId, "pointerId");
        a1 & He && (ee.button === 0 || Ee) ? Ge < 0 && (fe.push(ee), Ge = fe.length - 1) : a1 & (Ye | tt) && (Pe = !0), !(Ge < 0) && (fe[Ge] = ee, this.callback(this.manager, a1, {
          pointers: fe,
          changedPointers: [ee],
          pointerType: Te,
          srcEvent: ee
        }), Pe && fe.splice(Ge, 1));
      }
    });
    var Jr = {
      touchstart: He,
      touchmove: $e,
      touchend: Ye,
      touchcancel: tt
    }, _n = "touchstart", Tn = "touchstart touchmove touchend touchcancel";
    function hr() {
      this.evTarget = _n, this.evWin = Tn, this.started = !1, F1.apply(this, arguments);
    }
    M(hr, F1, {
      handler: function(ee) {
        var fe = Jr[ee.type];
        if (fe === He && (this.started = !0), !!this.started) {
          var Pe = Dn.call(this, ee, fe);
          fe & (Ye | tt) && Pe[0].length - Pe[1].length === 0 && (this.started = !1), this.callback(this.manager, fe, {
            pointers: Pe[0],
            changedPointers: Pe[1],
            pointerType: Ze,
            srcEvent: ee
          });
        }
      }
    });
    function Dn(X, ee) {
      var fe = j(X.touches), Pe = j(X.changedTouches);
      return ee & (Ye | tt) && (fe = z(fe.concat(Pe), "identifier", !0)), [fe, Pe];
    }
    var en = {
      touchstart: He,
      touchmove: $e,
      touchend: Ye,
      touchcancel: tt
    }, An = "touchstart touchmove touchend touchcancel";
    function pn() {
      this.evTarget = An, this.targetIds = {}, F1.apply(this, arguments);
    }
    M(pn, F1, {
      handler: function(ee) {
        var fe = en[ee.type], Pe = qn.call(this, ee, fe);
        !Pe || this.callback(this.manager, fe, {
          pointers: Pe[0],
          changedPointers: Pe[1],
          pointerType: Ze,
          srcEvent: ee
        });
      }
    });
    function qn(X, ee) {
      var fe = j(X.touches), Pe = this.targetIds;
      if (ee & (He | $e) && fe.length === 1)
        return Pe[fe[0].identifier] = !0, [fe, fe];
      var vt, a1, Te = j(X.changedTouches), Ee = [], Ge = this.target;
      if (a1 = fe.filter(function(_t) {
        return D(_t.target, Ge);
      }), ee === He)
        for (vt = 0; vt < a1.length; )
          Pe[a1[vt].identifier] = !0, vt++;
      for (vt = 0; vt < Te.length; )
        Pe[Te[vt].identifier] && Ee.push(Te[vt]), ee & (Ye | tt) && delete Pe[Te[vt].identifier], vt++;
      if (!!Ee.length)
        return [
          z(a1.concat(Ee), "identifier", !0),
          Ee
        ];
    }
    var Rn = 2500, gn = 25;
    function Ln() {
      F1.apply(this, arguments);
      var X = S(this.handler, this);
      this.touch = new pn(this.manager, X), this.mouse = new tr(this.manager, X), this.primaryTouch = null, this.lastTouches = [];
    }
    M(Ln, F1, {
      handler: function(ee, fe, Pe) {
        var vt = Pe.pointerType == Ze, a1 = Pe.pointerType == et;
        if (!(a1 && Pe.sourceCapabilities && Pe.sourceCapabilities.firesTouchEvents)) {
          if (vt)
            Vr.call(this, fe, Pe);
          else if (a1 && ir.call(this, Pe))
            return;
          this.callback(ee, fe, Pe);
        }
      },
      destroy: function() {
        this.touch.destroy(), this.mouse.destroy();
      }
    });
    function Vr(X, ee) {
      X & He ? (this.primaryTouch = ee.changedPointers[0].identifier, vn.call(this, ee)) : X & (Ye | tt) && vn.call(this, ee);
    }
    function vn(X) {
      var ee = X.changedPointers[0];
      if (ee.identifier === this.primaryTouch) {
        var fe = { x: ee.clientX, y: ee.clientY };
        this.lastTouches.push(fe);
        var Pe = this.lastTouches, vt = function() {
          var a1 = Pe.indexOf(fe);
          a1 > -1 && Pe.splice(a1, 1);
        };
        setTimeout(vt, Rn);
      }
    }
    function ir(X) {
      for (var ee = X.srcEvent.clientX, fe = X.srcEvent.clientY, Pe = 0; Pe < this.lastTouches.length; Pe++) {
        var vt = this.lastTouches[Pe], a1 = Math.abs(ee - vt.x), Te = Math.abs(fe - vt.y);
        if (a1 <= gn && Te <= gn)
          return !0;
      }
      return !1;
    }
    var Hn = q(c.style, "touchAction"), yn = Hn !== s, Cn = "compute", In = "auto", wn = "manipulation", an = "none", Z1 = "pan-x", tn = "pan-y", Dr = $n();
    function Sn(X, ee) {
      this.manager = X, this.set(ee);
    }
    Sn.prototype = {
      set: function(X) {
        X == Cn && (X = this.compute()), yn && this.manager.element.style && Dr[X] && (this.manager.element.style[Hn] = X), this.actions = X.toLowerCase().trim();
      },
      update: function() {
        this.set(this.manager.options.touchAction);
      },
      compute: function() {
        var X = [];
        return g(this.manager.recognizers, function(ee) {
          E(ee.options.enable, [ee]) && (X = X.concat(ee.getTouchAction()));
        }), xn(X.join(" "));
      },
      preventDefaults: function(X) {
        var ee = X.srcEvent, fe = X.offsetDirection;
        if (this.manager.session.prevented) {
          ee.preventDefault();
          return;
        }
        var Pe = this.actions, vt = R(Pe, an) && !Dr[an], a1 = R(Pe, tn) && !Dr[tn], Te = R(Pe, Z1) && !Dr[Z1];
        if (vt) {
          var Ee = X.pointers.length === 1, Ge = X.distance < 2, _t = X.deltaTime < 250;
          if (Ee && Ge && _t)
            return;
        }
        if (!(Te && a1) && (vt || a1 && fe & Et || Te && fe & d1))
          return this.preventSrc(ee);
      },
      preventSrc: function(X) {
        this.manager.session.prevented = !0, X.preventDefault();
      }
    };
    function xn(X) {
      if (R(X, an))
        return an;
      var ee = R(X, Z1), fe = R(X, tn);
      return ee && fe ? an : ee || fe ? ee ? Z1 : tn : R(X, wn) ? wn : In;
    }
    function $n() {
      if (!yn)
        return !1;
      var X = {}, ee = e.CSS && e.CSS.supports;
      return ["auto", "manipulation", "pan-y", "pan-x", "pan-x pan-y", "none"].forEach(function(fe) {
        X[fe] = ee ? e.CSS.supports("touch-action", fe) : !0;
      }), X;
    }
    var wr = 1, Br = 2, sn = 4, ie = 8, ue = ie, Ce = 16, rt = 32;
    function Vt(X) {
      this.options = b({}, this.defaults, X || {}), this.id = U(), this.manager = null, this.options.enable = k(this.options.enable, !0), this.state = wr, this.simultaneous = {}, this.requireFail = [];
    }
    Vt.prototype = {
      defaults: {},
      set: function(X) {
        return b(this.options, X), this.manager && this.manager.touchAction.update(), this;
      },
      recognizeWith: function(X) {
        if (m(X, "recognizeWith", this))
          return this;
        var ee = this.simultaneous;
        return X = _1(X, this), ee[X.id] || (ee[X.id] = X, X.recognizeWith(this)), this;
      },
      dropRecognizeWith: function(X) {
        return m(X, "dropRecognizeWith", this) ? this : (X = _1(X, this), delete this.simultaneous[X.id], this);
      },
      requireFailure: function(X) {
        if (m(X, "requireFailure", this))
          return this;
        var ee = this.requireFail;
        return X = _1(X, this), F(ee, X) === -1 && (ee.push(X), X.requireFailure(this)), this;
      },
      dropRequireFailure: function(X) {
        if (m(X, "dropRequireFailure", this))
          return this;
        X = _1(X, this);
        var ee = F(this.requireFail, X);
        return ee > -1 && this.requireFail.splice(ee, 1), this;
      },
      hasRequireFailures: function() {
        return this.requireFail.length > 0;
      },
      canRecognizeWith: function(X) {
        return !!this.simultaneous[X.id];
      },
      emit: function(X) {
        var ee = this, fe = this.state;
        function Pe(vt) {
          ee.manager.emit(vt, X);
        }
        fe < ie && Pe(ee.options.event + jt(fe)), Pe(ee.options.event), X.additionalEvent && Pe(X.additionalEvent), fe >= ie && Pe(ee.options.event + jt(fe));
      },
      tryEmit: function(X) {
        if (this.canEmit())
          return this.emit(X);
        this.state = rt;
      },
      canEmit: function() {
        for (var X = 0; X < this.requireFail.length; ) {
          if (!(this.requireFail[X].state & (rt | wr)))
            return !1;
          X++;
        }
        return !0;
      },
      recognize: function(X) {
        var ee = b({}, X);
        if (!E(this.options.enable, [this, ee])) {
          this.reset(), this.state = rt;
          return;
        }
        this.state & (ue | Ce | rt) && (this.state = wr), this.state = this.process(ee), this.state & (Br | sn | ie | Ce) && this.tryEmit(ee);
      },
      process: function(X) {
      },
      getTouchAction: function() {
      },
      reset: function() {
      }
    };
    function jt(X) {
      return X & Ce ? "cancel" : X & ie ? "end" : X & sn ? "move" : X & Br ? "start" : "";
    }
    function l1(X) {
      return X == Yt ? "down" : X == Rt ? "up" : X == Wt ? "left" : X == pt ? "right" : "";
    }
    function _1(X, ee) {
      var fe = ee.manager;
      return fe ? fe.get(X) : X;
    }
    function c1() {
      Vt.apply(this, arguments);
    }
    M(c1, Vt, {
      defaults: {
        pointers: 1
      },
      attrTest: function(X) {
        var ee = this.options.pointers;
        return ee === 0 || X.pointers.length === ee;
      },
      process: function(X) {
        var ee = this.state, fe = X.eventType, Pe = ee & (Br | sn), vt = this.attrTest(X);
        return Pe && (fe & tt || !vt) ? ee | Ce : Pe || vt ? fe & Ye ? ee | ie : ee & Br ? ee | sn : Br : rt;
      }
    });
    function p1() {
      c1.apply(this, arguments), this.pX = null, this.pY = null;
    }
    M(p1, c1, {
      defaults: {
        event: "pan",
        threshold: 10,
        pointers: 1,
        direction: b1
      },
      getTouchAction: function() {
        var X = this.options.direction, ee = [];
        return X & Et && ee.push(tn), X & d1 && ee.push(Z1), ee;
      },
      directionTest: function(X) {
        var ee = this.options, fe = !0, Pe = X.distance, vt = X.direction, a1 = X.deltaX, Te = X.deltaY;
        return vt & ee.direction || (ee.direction & Et ? (vt = a1 === 0 ? dt : a1 < 0 ? Wt : pt, fe = a1 != this.pX, Pe = Math.abs(X.deltaX)) : (vt = Te === 0 ? dt : Te < 0 ? Rt : Yt, fe = Te != this.pY, Pe = Math.abs(X.deltaY))), X.direction = vt, fe && Pe > ee.threshold && vt & ee.direction;
      },
      attrTest: function(X) {
        return c1.prototype.attrTest.call(this, X) && (this.state & Br || !(this.state & Br) && this.directionTest(X));
      },
      emit: function(X) {
        this.pX = X.deltaX, this.pY = X.deltaY;
        var ee = l1(X.direction);
        ee && (X.additionalEvent = this.options.event + ee), this._super.emit.call(this, X);
      }
    });
    function H1() {
      c1.apply(this, arguments);
    }
    M(H1, c1, {
      defaults: {
        event: "pinch",
        threshold: 0,
        pointers: 2
      },
      getTouchAction: function() {
        return [an];
      },
      attrTest: function(X) {
        return this._super.attrTest.call(this, X) && (Math.abs(X.scale - 1) > this.options.threshold || this.state & Br);
      },
      emit: function(X) {
        if (X.scale !== 1) {
          var ee = X.scale < 1 ? "in" : "out";
          X.additionalEvent = this.options.event + ee;
        }
        this._super.emit.call(this, X);
      }
    });
    function D1() {
      Vt.apply(this, arguments), this._timer = null, this._input = null;
    }
    M(D1, Vt, {
      defaults: {
        event: "press",
        pointers: 1,
        time: 251,
        threshold: 9
      },
      getTouchAction: function() {
        return [In];
      },
      process: function(X) {
        var ee = this.options, fe = X.pointers.length === ee.pointers, Pe = X.distance < ee.threshold, vt = X.deltaTime > ee.time;
        if (this._input = X, !Pe || !fe || X.eventType & (Ye | tt) && !vt)
          this.reset();
        else if (X.eventType & He)
          this.reset(), this._timer = Q(function() {
            this.state = ue, this.tryEmit();
          }, ee.time, this);
        else if (X.eventType & Ye)
          return ue;
        return rt;
      },
      reset: function() {
        clearTimeout(this._timer);
      },
      emit: function(X) {
        this.state === ue && (X && X.eventType & Ye ? this.manager.emit(this.options.event + "up", X) : (this._input.timeStamp = T(), this.manager.emit(this.options.event, this._input)));
      }
    });
    function mr() {
      c1.apply(this, arguments);
    }
    M(mr, c1, {
      defaults: {
        event: "rotate",
        threshold: 0,
        pointers: 2
      },
      getTouchAction: function() {
        return [an];
      },
      attrTest: function(X) {
        return this._super.attrTest.call(this, X) && (Math.abs(X.rotation) > this.options.threshold || this.state & Br);
      }
    });
    function rn() {
      c1.apply(this, arguments);
    }
    M(rn, c1, {
      defaults: {
        event: "swipe",
        threshold: 10,
        velocity: 0.3,
        direction: Et | d1,
        pointers: 1
      },
      getTouchAction: function() {
        return p1.prototype.getTouchAction.call(this);
      },
      attrTest: function(X) {
        var ee = this.options.direction, fe;
        return ee & (Et | d1) ? fe = X.overallVelocity : ee & Et ? fe = X.overallVelocityX : ee & d1 && (fe = X.overallVelocityY), this._super.attrTest.call(this, X) && ee & X.offsetDirection && X.distance > this.options.threshold && X.maxPointers == this.options.pointers && f(fe) > this.options.velocity && X.eventType & Ye;
      },
      emit: function(X) {
        var ee = l1(X.offsetDirection);
        ee && this.manager.emit(this.options.event + ee, X), this.manager.emit(this.options.event, X);
      }
    });
    function ln() {
      Vt.apply(this, arguments), this.pTime = !1, this.pCenter = !1, this._timer = null, this._input = null, this.count = 0;
    }
    M(ln, Vt, {
      defaults: {
        event: "tap",
        pointers: 1,
        taps: 1,
        interval: 300,
        time: 250,
        threshold: 9,
        posThreshold: 10
      },
      getTouchAction: function() {
        return [wn];
      },
      process: function(X) {
        var ee = this.options, fe = X.pointers.length === ee.pointers, Pe = X.distance < ee.threshold, vt = X.deltaTime < ee.time;
        if (this.reset(), X.eventType & He && this.count === 0)
          return this.failTimeout();
        if (Pe && vt && fe) {
          if (X.eventType != Ye)
            return this.failTimeout();
          var a1 = this.pTime ? X.timeStamp - this.pTime < ee.interval : !0, Te = !this.pCenter || o1(this.pCenter, X.center) < ee.posThreshold;
          this.pTime = X.timeStamp, this.pCenter = X.center, !Te || !a1 ? this.count = 1 : this.count += 1, this._input = X;
          var Ee = this.count % ee.taps;
          if (Ee === 0)
            return this.hasRequireFailures() ? (this._timer = Q(function() {
              this.state = ue, this.tryEmit();
            }, ee.interval, this), Br) : ue;
        }
        return rt;
      },
      failTimeout: function() {
        return this._timer = Q(function() {
          this.state = rt;
        }, this.options.interval, this), rt;
      },
      reset: function() {
        clearTimeout(this._timer);
      },
      emit: function() {
        this.state == ue && (this._input.tapCount = this.count, this.manager.emit(this.options.event, this._input));
      }
    });
    function rr(X, ee) {
      return ee = ee || {}, ee.recognizers = k(ee.recognizers, rr.defaults.preset), new Oe(X, ee);
    }
    rr.VERSION = "2.0.7", rr.defaults = {
      domEvents: !1,
      touchAction: Cn,
      enable: !0,
      inputTarget: null,
      inputClass: null,
      preset: [
        [mr, { enable: !1 }],
        [H1, { enable: !1 }, ["rotate"]],
        [rn, { direction: Et }],
        [p1, { direction: Et }, ["swipe"]],
        [ln],
        [ln, { event: "doubletap", taps: 2 }, ["tap"]],
        [D1]
      ],
      cssProps: {
        userSelect: "none",
        touchSelect: "none",
        touchCallout: "none",
        contentZooming: "none",
        userDrag: "none",
        tapHighlightColor: "rgba(0,0,0,0)"
      }
    };
    var ve = 1, we = 2;
    function Oe(X, ee) {
      this.options = b({}, rr.defaults, ee || {}), this.options.inputTarget = this.options.inputTarget || X, this.handlers = {}, this.session = {}, this.recognizers = [], this.oldCssProps = {}, this.element = X, this.input = qr(this), this.touchAction = new Sn(this, this.options.touchAction), mt(this, !0), g(this.options.recognizers, function(fe) {
        var Pe = this.add(new fe[0](fe[1]));
        fe[2] && Pe.recognizeWith(fe[2]), fe[3] && Pe.requireFailure(fe[3]);
      }, this);
    }
    Oe.prototype = {
      set: function(X) {
        return b(this.options, X), X.touchAction && this.touchAction.update(), X.inputTarget && (this.input.destroy(), this.input.target = X.inputTarget, this.input.init()), this;
      },
      stop: function(X) {
        this.session.stopped = X ? we : ve;
      },
      recognize: function(X) {
        var ee = this.session;
        if (!ee.stopped) {
          this.touchAction.preventDefaults(X);
          var fe, Pe = this.recognizers, vt = ee.curRecognizer;
          (!vt || vt && vt.state & ue) && (vt = ee.curRecognizer = null);
          for (var a1 = 0; a1 < Pe.length; )
            fe = Pe[a1], ee.stopped !== we && (!vt || fe == vt || fe.canRecognizeWith(vt)) ? fe.recognize(X) : fe.reset(), !vt && fe.state & (Br | sn | ie) && (vt = ee.curRecognizer = fe), a1++;
        }
      },
      get: function(X) {
        if (X instanceof Vt)
          return X;
        for (var ee = this.recognizers, fe = 0; fe < ee.length; fe++)
          if (ee[fe].options.event == X)
            return ee[fe];
        return null;
      },
      add: function(X) {
        if (m(X, "add", this))
          return this;
        var ee = this.get(X.options.event);
        return ee && this.remove(ee), this.recognizers.push(X), X.manager = this, this.touchAction.update(), X;
      },
      remove: function(X) {
        if (m(X, "remove", this))
          return this;
        if (X = this.get(X), X) {
          var ee = this.recognizers, fe = F(ee, X);
          fe !== -1 && (ee.splice(fe, 1), this.touchAction.update());
        }
        return this;
      },
      on: function(X, ee) {
        if (X !== s && ee !== s) {
          var fe = this.handlers;
          return g(B(X), function(Pe) {
            fe[Pe] = fe[Pe] || [], fe[Pe].push(ee);
          }), this;
        }
      },
      off: function(X, ee) {
        if (X !== s) {
          var fe = this.handlers;
          return g(B(X), function(Pe) {
            ee ? fe[Pe] && fe[Pe].splice(F(fe[Pe], ee), 1) : delete fe[Pe];
          }), this;
        }
      },
      emit: function(X, ee) {
        this.options.domEvents && $t(X, ee);
        var fe = this.handlers[X] && this.handlers[X].slice();
        if (!(!fe || !fe.length)) {
          ee.type = X, ee.preventDefault = function() {
            ee.srcEvent.preventDefault();
          };
          for (var Pe = 0; Pe < fe.length; )
            fe[Pe](ee), Pe++;
        }
      },
      destroy: function() {
        this.element && mt(this, !1), this.handlers = {}, this.session = {}, this.input.destroy(), this.element = null;
      }
    };
    function mt(X, ee) {
      var fe = X.element;
      if (!!fe.style) {
        var Pe;
        g(X.options.cssProps, function(vt, a1) {
          Pe = q(fe.style, a1), ee ? (X.oldCssProps[Pe] = fe.style[Pe], fe.style[Pe] = vt) : fe.style[Pe] = X.oldCssProps[Pe] || "";
        }), ee || (X.oldCssProps = {});
      }
    }
    function $t(X, ee) {
      var fe = r.createEvent("Event");
      fe.initEvent(X, !0, !0), fe.gesture = ee, ee.target.dispatchEvent(fe);
    }
    b(rr, {
      INPUT_START: He,
      INPUT_MOVE: $e,
      INPUT_END: Ye,
      INPUT_CANCEL: tt,
      STATE_POSSIBLE: wr,
      STATE_BEGAN: Br,
      STATE_CHANGED: sn,
      STATE_ENDED: ie,
      STATE_RECOGNIZED: ue,
      STATE_CANCELLED: Ce,
      STATE_FAILED: rt,
      DIRECTION_NONE: dt,
      DIRECTION_LEFT: Wt,
      DIRECTION_RIGHT: pt,
      DIRECTION_UP: Rt,
      DIRECTION_DOWN: Yt,
      DIRECTION_HORIZONTAL: Et,
      DIRECTION_VERTICAL: d1,
      DIRECTION_ALL: b1,
      Manager: Oe,
      Input: F1,
      TouchAction: Sn,
      TouchInput: pn,
      MouseInput: tr,
      PointerEventInput: Er,
      TouchMouseInput: Ln,
      SingleTouchInput: hr,
      Recognizer: Vt,
      AttrRecognizer: c1,
      Tap: ln,
      Pan: p1,
      Swipe: rn,
      Pinch: H1,
      Rotate: mr,
      Press: D1,
      on: w,
      off: O,
      each: g,
      merge: A,
      extend: L,
      assign: b,
      inherit: M,
      bindFn: S,
      prefixed: q
    });
    var h1 = typeof e < "u" ? e : typeof self < "u" ? self : {};
    h1.Hammer = rr, typeof s == "function" && s.amd ? s(function() {
      return rr;
    }) : t.exports ? t.exports = rr : e[o] = rr;
  })(window, document, "Hammer");
})(hammer);
const Hammer = hammer.exports;
class DOMView extends View {
  initialize() {
    super.initialize(), this.el = this._createElement();
  }
  remove() {
    remove(this.el), super.remove();
  }
  css_classes() {
    return [];
  }
  render() {
  }
  renderTo(e) {
    e.appendChild(this.el), this.render(), this._has_finished = !0, this.notify_finished();
  }
  _createElement() {
    return createElement(this.constructor.tag_name, { class: this.css_classes() });
  }
}
DOMView.__name__ = "DOMView";
DOMView.tag_name = "div";
const root$2 = "bk-root", toolbar_hidden = "bk-toolbar-hidden", toolbar = "bk-toolbar", logo$1 = "bk-logo", above$2 = "bk-above", below$3 = "bk-below", left$2 = "bk-left", right$2 = "bk-right", toolbar_button = "bk-toolbar-button", tool_overflow = "bk-tool-overflow", active$3 = "bk-active", divider$1 = "bk-divider", horizontal$1 = "bk-horizontal", vertical$1 = "bk-vertical", toolbars_css = '.bk-root .bk-toolbar-hidden{visibility:hidden;opacity:0;transition:visibility 0.3s linear, opacity 0.3s linear;}.bk-root .bk-toolbar{display:flex;flex-wrap:nowrap;align-items:center;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-toolbar .bk-logo{flex-shrink:0;}.bk-root .bk-toolbar.bk-above,.bk-root .bk-toolbar.bk-below{flex-direction:row;justify-content:flex-end;}.bk-root .bk-toolbar.bk-above .bk-logo,.bk-root .bk-toolbar.bk-below .bk-logo{order:1;margin-left:5px;margin-right:0px;}.bk-root .bk-toolbar.bk-left,.bk-root .bk-toolbar.bk-right{flex-direction:column;justify-content:flex-start;}.bk-root .bk-toolbar.bk-left .bk-logo,.bk-root .bk-toolbar.bk-right .bk-logo{order:0;margin-bottom:5px;margin-top:0px;}.bk-root .bk-toolbar-button{width:30px;height:30px;cursor:pointer;background-size:60% 60%;background-origin:border-box;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-toolbar-button:hover,.bk-root .bk-tool-overflow:hover{background-color:rgba(192, 192, 192, 0.15);}.bk-root .bk-toolbar-button:focus,.bk-root .bk-tool-overflow:focus,.bk-root .bk-toolbar-button:focus-visible,.bk-root .bk-tool-overflow:focus-visible{outline:1px dotted #26aae1;outline-offset:-1px;}.bk-root .bk-toolbar-button::-moz-focus-inner,.bk-root .bk-tool-overflow::-moz-focus-inner{border:0;}.bk-root .bk-above .bk-toolbar-button{border-bottom:2px solid transparent;}.bk-root .bk-above .bk-toolbar-button.bk-active{border-bottom-color:#26aae1;}.bk-root .bk-below .bk-toolbar-button{border-top:2px solid transparent;}.bk-root .bk-below .bk-toolbar-button.bk-active{border-top-color:#26aae1;}.bk-root .bk-right .bk-toolbar-button{border-left:2px solid transparent;}.bk-root .bk-right .bk-toolbar-button.bk-active{border-left-color:#26aae1;}.bk-root .bk-left .bk-toolbar-button{border-right:2px solid transparent;}.bk-root .bk-left .bk-toolbar-button.bk-active{border-right-color:#26aae1;}.bk-root .bk-divider{content:" ";display:inline-block;background-color:lightgray;}.bk-root .bk-above .bk-divider,.bk-root .bk-below .bk-divider{height:10px;width:1px;}.bk-root .bk-left .bk-divider,.bk-root .bk-right .bk-divider{height:1px;width:10px;}.bk-root .bk-tool-overflow{color:gray;display:flex;align-items:center;}.bk-root .bk-above .bk-tool-overflow,.bk-root .bk-below .bk-tool-overflow,.bk-root .bk-horizontal .bk-tool-overflow{width:15px;height:30px;flex-direction:row;}.bk-root .bk-left .bk-tool-overflow,.bk-root .bk-right .bk-tool-overflow,.bk-root .bk-vertical .bk-tool-overflow{width:30px;height:15px;flex-direction:column;}', toolbars = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  root: root$2,
  toolbar_hidden,
  toolbar,
  logo: logo$1,
  above: above$2,
  below: below$3,
  left: left$2,
  right: right$2,
  toolbar_button,
  tool_overflow,
  active: active$3,
  divider: divider$1,
  horizontal: horizontal$1,
  vertical: vertical$1,
  default: toolbars_css
}, Symbol.toStringTag, { value: "Module" })), tool_icon_box_select = "bk-tool-icon-box-select", tool_icon_box_zoom = "bk-tool-icon-box-zoom", tool_icon_zoom_in = "bk-tool-icon-zoom-in", tool_icon_zoom_out = "bk-tool-icon-zoom-out", tool_icon_help = "bk-tool-icon-help", tool_icon_hover = "bk-tool-icon-hover", tool_icon_crosshair = "bk-tool-icon-crosshair", tool_icon_lasso_select = "bk-tool-icon-lasso-select", tool_icon_pan = "bk-tool-icon-pan", tool_icon_xpan = "bk-tool-icon-xpan", tool_icon_ypan = "bk-tool-icon-ypan", tool_icon_range = "bk-tool-icon-range", tool_icon_polygon_select = "bk-tool-icon-polygon-select", tool_icon_redo = "bk-tool-icon-redo", tool_icon_reset = "bk-tool-icon-reset", tool_icon_save = "bk-tool-icon-save", tool_icon_tap_select = "bk-tool-icon-tap-select", tool_icon_undo = "bk-tool-icon-undo", tool_icon_wheel_pan = "bk-tool-icon-wheel-pan", tool_icon_wheel_zoom = "bk-tool-icon-wheel-zoom", tool_icon_box_edit = "bk-tool-icon-box-edit", tool_icon_freehand_draw = "bk-tool-icon-freehand-draw", tool_icon_poly_draw = "bk-tool-icon-poly-draw", tool_icon_point_draw = "bk-tool-icon-point-draw", tool_icon_poly_edit = "bk-tool-icon-poly-edit", tool_icon_line_edit = "bk-tool-icon-line-edit", icons_css = '.bk-root .bk-tool-icon-copy-to-clipboard{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-replace-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-append-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-intersect-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-subtract-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-clear-selection{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-box-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-box-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-zoom-in{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-zoom-out{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-help{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-crosshair{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-lasso-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-pan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-xpan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-ypan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-range{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-polygon-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-redo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-reset{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-save{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-tap-select{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-undo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-wheel-pan{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-wheel-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-box-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-freehand-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-point-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-line-edit{background-image:url("data:image/png;base64,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");}', divider = "bk-divider", active$2 = "bk-active", menu = "bk-menu", below$2 = "bk-below", caret = "bk-caret", down = "bk-down", menus_css = ".bk-root .bk-menu-icon{width:28px;height:28px;background-size:60%;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-context-menu{position:absolute;display:inline-flex;flex-wrap:nowrap;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;width:auto;height:auto;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-context-menu.bk-horizontal{flex-direction:row;}.bk-root .bk-context-menu.bk-vertical{flex-direction:column;}.bk-root .bk-context-menu > .bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-context-menu.bk-horizontal > .bk-divider{width:1px;margin:5px 0;}.bk-root .bk-context-menu.bk-vertical > .bk-divider{height:1px;margin:0 5px;}.bk-root .bk-context-menu > :not(.bk-divider){border:1px solid transparent;}.bk-root .bk-context-menu > :not(.bk-divider).bk-active{border-color:#26aae1;}.bk-root .bk-context-menu > :not(.bk-divider):hover{background-color:#f9f9f9;}.bk-root .bk-context-menu > :not(.bk-divider):focus,.bk-root .bk-context-menu > :not(.bk-divider):focus-visible{outline:1px dotted #26aae1;outline-offset:-1px;}.bk-root .bk-context-menu > :not(.bk-divider)::-moz-focus-inner{border:0;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child{border-top-left-radius:4px;border-bottom-left-radius:4px;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child{border-top-right-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child{border-top-left-radius:4px;border-top-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child{border-bottom-left-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-menu{position:absolute;left:0;width:100%;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-menu.bk-above{bottom:100%;}.bk-root .bk-menu.bk-below{top:100%;}.bk-root .bk-menu > .bk-divider{height:1px;margin:7.5px 0;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-menu > :not(.bk-divider){padding:6px 12px;}.bk-root .bk-menu > :not(.bk-divider):hover,.bk-root .bk-menu > :not(.bk-divider).bk-active{background-color:#e6e6e6;}.bk-root .bk-caret{display:inline-block;vertical-align:middle;width:0;height:0;margin:0 5px;}.bk-root .bk-caret.bk-down{border-top:4px solid;}.bk-root .bk-caret.bk-up{border-bottom:4px solid;}.bk-root .bk-caret.bk-down,.bk-root .bk-caret.bk-up{border-right:4px solid transparent;border-left:4px solid transparent;}.bk-root .bk-caret.bk-left{border-right:4px solid;}.bk-root .bk-caret.bk-right{border-left:4px solid;}.bk-root .bk-caret.bk-left,.bk-root .bk-caret.bk-right{border-top:4px solid transparent;border-bottom:4px solid transparent;}";
class ContextMenu {
  constructor(e, r = {}) {
    var o, s;
    this.items = e, this.el = div(), this._open = !1, this._item_click = (l) => {
      var c;
      (c = l.handler) == null || c.call(l), this.hide();
    }, this._on_mousedown = (l) => {
      var u;
      const { target: c } = l;
      c instanceof Node && this.el.contains(c) || (u = this.prevent_hide) != null && u.call(this, l) || this.hide();
    }, this._on_keydown = (l) => {
      l.keyCode == Keys.Esc && this.hide();
    }, this._on_blur = () => {
      this.hide();
    }, this.orientation = (o = r.orientation) != null ? o : "vertical", this.reversed = (s = r.reversed) != null ? s : !1, this.prevent_hide = r.prevent_hide, undisplay(this.el);
  }
  get is_open() {
    return this._open;
  }
  get can_open() {
    return this.items.length != 0;
  }
  remove() {
    remove(this.el), this._unlisten();
  }
  _listen() {
    document.addEventListener("mousedown", this._on_mousedown), document.addEventListener("keydown", this._on_keydown), window.addEventListener("blur", this._on_blur);
  }
  _unlisten() {
    document.removeEventListener("mousedown", this._on_mousedown), document.removeEventListener("keydown", this._on_keydown), window.removeEventListener("blur", this._on_blur);
  }
  _position(e) {
    const r = this.el.parentElement;
    if (r != null) {
      const o = (() => {
        if ("left_of" in e) {
          const { left: l, top: c } = e.left_of.getBoundingClientRect();
          return { right: l, top: c };
        }
        if ("right_of" in e) {
          const { top: l, right: c } = e.right_of.getBoundingClientRect();
          return { left: c, top: l };
        }
        if ("below" in e) {
          const { left: l, bottom: c } = e.below.getBoundingClientRect();
          return { left: l, top: c };
        }
        if ("above" in e) {
          const { left: l, top: c } = e.above.getBoundingClientRect();
          return { left: l, bottom: c };
        }
        return e;
      })(), s = r.getBoundingClientRect();
      this.el.style.left = o.left != null ? `${o.left - s.left}px` : "", this.el.style.top = o.top != null ? `${o.top - s.top}px` : "", this.el.style.right = o.right != null ? `${s.right - o.right}px` : "", this.el.style.bottom = o.bottom != null ? `${s.bottom - o.bottom}px` : "";
    }
  }
  render() {
    var r;
    empty$1(this.el, !0), classes(this.el).add("bk-context-menu", `bk-${this.orientation}`);
    const e = this.reversed ? reversed(this.items) : this.items;
    for (const o of e) {
      let s;
      if (o == null)
        s = div({ class: divider });
      else {
        if (o.if != null && !o.if())
          continue;
        if (o.content != null)
          s = o.content;
        else {
          const l = o.icon != null ? div({ class: ["bk-menu-icon", o.icon] }) : null, c = [(r = o.active) != null && r.call(o) ? "bk-active" : null, o.class];
          s = div({ class: c, title: o.tooltip, tabIndex: 0 }, l, o.label, o.content), s.addEventListener("click", () => {
            this._item_click(o);
          }), s.addEventListener("keydown", (u) => {
            u.keyCode == Keys.Enter && this._item_click(o);
          });
        }
      }
      this.el.appendChild(s);
    }
  }
  show(e) {
    if (this.items.length != 0 && !this._open) {
      if (this.render(), this.el.children.length == 0)
        return;
      this._position(e != null ? e : { left: 0, top: 0 }), display(this.el), this._listen(), this._open = !0;
    }
  }
  hide() {
    this._open && (this._open = !1, this._unlisten(), undisplay(this.el));
  }
  toggle(e) {
    this._open ? this.hide() : this.show(e);
  }
}
ContextMenu.__name__ = "ContextMenu";
var _a$2F;
class ButtonToolButtonView extends DOMView {
  initialize() {
    super.initialize();
    const e = this.model.menu;
    if (e != null) {
      const r = this.parent.model.toolbar_location, o = r == "left" || r == "above", s = this.parent.model.horizontal ? "vertical" : "horizontal";
      this._menu = new ContextMenu(o ? reversed(e) : e, {
        orientation: s,
        prevent_hide: (l) => l.target == this.el
      });
    }
    this._hammer = new Hammer(this.el, {
      touchAction: "auto",
      inputClass: Hammer.TouchMouseInput
    }), this.connect(this.model.change, () => this.render()), this._hammer.on("tap", (r) => {
      var o;
      if ((o = this._menu) != null && o.is_open) {
        this._menu.hide();
        return;
      }
      r.target == this.el && this._clicked();
    }), this._hammer.on("press", () => this._pressed()), this.el.addEventListener("keydown", (r) => {
      r.keyCode == Keys.Enter && this._clicked();
    });
  }
  remove() {
    var e;
    this._hammer.destroy(), (e = this._menu) == null || e.remove(), super.remove();
  }
  styles() {
    return [...super.styles(), toolbars_css, icons_css, menus_css];
  }
  css_classes() {
    return super.css_classes().concat(toolbar_button);
  }
  render() {
    empty$1(this.el);
    const e = this.model.computed_icon;
    isString(e) && (startsWith(e, "data:image") ? this.el.style.backgroundImage = `url("${e}")` : this.el.classList.add(e)), this.el.title = this.model.tooltip, this.el.tabIndex = 0, this._menu != null && this.root.el.appendChild(this._menu.el);
  }
  _pressed() {
    var r;
    const e = (() => {
      switch (this.parent.model.toolbar_location) {
        case "right":
          return { left_of: this.el };
        case "left":
          return { right_of: this.el };
        case "above":
          return { below: this.el };
        case "below":
          return { above: this.el };
      }
    })();
    (r = this._menu) == null || r.toggle(e);
  }
}
ButtonToolButtonView.__name__ = "ButtonToolButtonView";
class ButtonToolView extends ToolView {
}
ButtonToolView.__name__ = "ButtonToolView";
class ButtonTool extends Tool {
  constructor(e) {
    super(e);
  }
  _get_dim_tooltip(e) {
    const { description: r, tool_name: o } = this;
    return r != null ? r : e == "both" ? o : `${o} (${e == "width" ? "x" : "y"}-axis)`;
  }
  get tooltip() {
    var e;
    return (e = this.description) != null ? e : this.tool_name;
  }
  get computed_icon() {
    return this.icon;
  }
  get menu() {
    return null;
  }
}
_a$2F = ButtonTool;
ButtonTool.__name__ = "ButtonTool";
_a$2F.internal(({ Boolean: t }) => ({
  disabled: [t, !1]
}));
class OnOffButtonView extends ButtonToolButtonView {
  render() {
    super.render(), classes(this.el).toggle(active$3, this.model.active);
  }
  _clicked() {
    const { active: e } = this.model;
    this.model.active = !e;
  }
}
OnOffButtonView.__name__ = "OnOffButtonView";
class GestureToolView extends ButtonToolView {
}
GestureToolView.__name__ = "GestureToolView";
class GestureTool extends ButtonTool {
  constructor(e) {
    super(e), this.button_view = OnOffButtonView;
  }
}
GestureTool.__name__ = "GestureTool";
var _a$2E;
class InspectToolView extends ButtonToolView {
}
InspectToolView.__name__ = "InspectToolView";
class InspectTool extends ButtonTool {
  constructor(e) {
    super(e), this.event_type = "move";
  }
}
_a$2E = InspectTool;
InspectTool.__name__ = "InspectTool";
_a$2E.prototype.button_view = OnOffButtonView, _a$2E.define(({ Boolean: t }) => ({
  toggleable: [t, !0]
})), _a$2E.override({
  active: !0
});
function* enumerate(t) {
  let e = 0;
  for (const r of t)
    yield [r, e++];
}
function* join(t, e) {
  let r = !0;
  for (const o of t)
    r ? r = !1 : e != null && (yield e()), yield* o;
}
const MAX_INT32 = 2147483647;
class Random {
  constructor(e) {
    this.seed = e % MAX_INT32, this.seed <= 0 && (this.seed += MAX_INT32 - 1);
  }
  integer() {
    return this.seed = 48271 * this.seed % MAX_INT32, this.seed;
  }
  float() {
    return (this.integer() - 1) / (MAX_INT32 - 1);
  }
  floats(e, r = 0, o = 1) {
    const s = new Array(e);
    for (let l = 0; l < e; l++)
      s[l] = r + this.float() * (o - r);
    return s;
  }
  choices(e, r) {
    const o = r.length, s = new Array(e);
    for (let l = 0; l < e; l++)
      s[l] = r[this.integer() % o];
    return s;
  }
}
Random.__name__ = "Random";
const random = new Random(Date.now());
function createNamedToNumberedLookup(t, e) {
  const r = /* @__PURE__ */ new Map(), o = t.split(",");
  e = e != null ? e : 10;
  for (let s = 0; s < o.length; s += 2) {
    const l = `&${o[s + 1]};`, c = parseInt(o[s], e);
    r.set(l, `&#${c};`);
  }
  return r.set("\\xa0", "&#160;"), r;
}
function getTextAnchor(t) {
  var r;
  const e = { left: "start", right: "end", center: "middle", start: "start", end: "end" };
  return (r = e[t]) != null ? r : e.start;
}
function getDominantBaseline(t) {
  var r;
  const e = { alphabetic: "alphabetic", hanging: "hanging", top: "text-before-edge", bottom: "text-after-edge", middle: "central" };
  return (r = e[t]) != null ? r : e.alphabetic;
}
const namedEntities = createNamedToNumberedLookup("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro", 32), STYLES = {
  strokeStyle: {
    svgAttr: "stroke",
    canvas: "#000000",
    svg: "none",
    apply: "stroke"
  },
  fillStyle: {
    svgAttr: "fill",
    canvas: "#000000",
    svg: null,
    apply: "fill"
  },
  lineCap: {
    svgAttr: "stroke-linecap",
    canvas: "butt",
    svg: "butt",
    apply: "stroke"
  },
  lineJoin: {
    svgAttr: "stroke-linejoin",
    canvas: "miter",
    svg: "miter",
    apply: "stroke"
  },
  miterLimit: {
    svgAttr: "stroke-miterlimit",
    canvas: 10,
    svg: 4,
    apply: "stroke"
  },
  lineWidth: {
    svgAttr: "stroke-width",
    canvas: 1,
    svg: 1,
    apply: "stroke"
  },
  globalAlpha: {
    svgAttr: "opacity",
    canvas: 1,
    svg: 1,
    apply: "fill stroke"
  },
  font: {
    canvas: "10px sans-serif"
  },
  shadowColor: {
    canvas: "#000000"
  },
  shadowOffsetX: {
    canvas: 0
  },
  shadowOffsetY: {
    canvas: 0
  },
  shadowBlur: {
    canvas: 0
  },
  textAlign: {
    canvas: "start"
  },
  textBaseline: {
    canvas: "alphabetic"
  },
  lineDash: {
    svgAttr: "stroke-dasharray",
    canvas: [],
    svg: null,
    apply: "stroke"
  },
  lineDashOffset: {
    svgAttr: "stroke-dashoffset",
    canvas: 0,
    svg: 0,
    apply: "stroke"
  }
};
class CanvasGradient {
  constructor(e, r) {
    this.__root = e, this.__ctx = r;
  }
  addColorStop(e, r) {
    if (this.__root.nodeName === "linearGradient" && this.__root.getAttribute("x1") === this.__root.getAttribute("x2") && this.__root.getAttribute("y1") === this.__root.getAttribute("y2") || this.__root.nodeName === "radialGradient" && this.__root.getAttribute("cx") === this.__root.getAttribute("fx") && this.__root.getAttribute("cy") === this.__root.getAttribute("fy") && this.__root.getAttribute("r") === this.__root.getAttribute("r0"))
      return;
    const o = this.__ctx.__createElement("stop");
    if (o.setAttribute("offset", `${e}`), r.indexOf("rgba") !== -1) {
      const l = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(r), [, c, u, d, f] = l;
      o.setAttribute("stop-color", `rgb(${c},${u},${d})`), o.setAttribute("stop-opacity", f);
    } else
      o.setAttribute("stop-color", r);
    this.__root.appendChild(o);
  }
}
CanvasGradient.__name__ = "CanvasGradient";
class CanvasPattern {
  constructor(e, r) {
    this.__root = e, this.__ctx = r;
  }
  setTransform(e) {
    throw new Error("not implemented");
  }
}
CanvasPattern.__name__ = "CanvasPattern";
class SVGRenderingContext2D {
  constructor(e) {
    var r, o, s;
    this.__currentPosition = null, this._transform = new AffineTransform(), this._clip_path = null, this.__document = (r = e == null ? void 0 : e.document) != null ? r : document, e != null && e.ctx ? this.__ctx = e.ctx : (this.__canvas = this.__document.createElement("canvas"), this.__ctx = this.__canvas.getContext("2d")), this.__setDefaultStyles(), this.__stack = [], this.__root = this.__document.createElementNS("http://www.w3.org/2000/svg", "svg"), this.__root.setAttribute("version", "1.1"), this.__root.setAttribute("xmlns", "http://www.w3.org/2000/svg"), this.width = (o = e == null ? void 0 : e.width) != null ? o : 500, this.height = (s = e == null ? void 0 : e.height) != null ? s : 500, this.__ids = /* @__PURE__ */ new Set(), this.__defs = this.__document.createElementNS("http://www.w3.org/2000/svg", "defs"), this.__root.appendChild(this.__defs);
  }
  get canvas() {
    return this;
  }
  get width() {
    return this._width;
  }
  set width(e) {
    this._width = e, this.__root.setAttribute("width", `${e}`);
  }
  get height() {
    return this._height;
  }
  set height(e) {
    this._height = e, this.__root.setAttribute("height", `${e}`);
  }
  _random_string() {
    const e = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
    let r;
    do
      r = SVGRenderingContext2D.__random.choices(12, e).join("");
    while (this.__ids.has(r));
    return r;
  }
  __createElement(e, r = {}, o = !1) {
    const s = this.__document.createElementNS("http://www.w3.org/2000/svg", e);
    o && (s.setAttribute("fill", "none"), s.setAttribute("stroke", "none"));
    const l = Object.keys(r);
    for (const c of l)
      s.setAttribute(c, `${r[c]}`);
    return s;
  }
  __setDefaultStyles() {
    const e = Object.keys(STYLES), r = this;
    for (let o = 0; o < e.length; o++) {
      const s = e[o];
      r[s] = STYLES[s].canvas;
    }
  }
  __applyStyleState(e) {
    const r = Object.keys(e), o = this;
    for (let s = 0; s < r.length; s++) {
      const l = r[s];
      o[l] = e[l];
    }
  }
  __getStyleState() {
    const e = Object.keys(STYLES), r = {};
    for (let o = 0; o < e.length; o++) {
      const s = e[o];
      r[s] = this[s];
    }
    return r;
  }
  __applyStyleToCurrentElement(e) {
    var s;
    const r = this.__currentElement, o = Object.keys(STYLES);
    for (let l = 0; l < o.length; l++) {
      const c = STYLES[o[l]], u = this[o[l]];
      if ((s = c.apply) != null && s.includes(e)) {
        if (u instanceof CanvasPattern) {
          for (const f of [...u.__ctx.__defs.childNodes])
            if (f instanceof Element) {
              const T = f.getAttribute("id");
              this.__ids.add(T), this.__defs.appendChild(f);
            }
          const d = u.__root.getAttribute("id");
          r.setAttribute(c.apply, `url(#${d})`);
        } else if (u instanceof CanvasGradient) {
          const d = u.__root.getAttribute("id");
          r.setAttribute(c.apply, `url(#${d})`);
        } else if (c.svg !== u)
          if ((c.svgAttr === "stroke" || c.svgAttr === "fill") && isString(u) && u.indexOf("rgba") !== -1) {
            const f = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(u), [, T, Q, m, g] = f;
            r.setAttribute(c.svgAttr, `rgb(${T},${Q},${m})`);
            let v = parseFloat(g);
            const b = this.globalAlpha;
            b != null && (v *= b), r.setAttribute(`${c.svgAttr}-opacity`, `${v}`);
          } else {
            let d = c.svgAttr;
            if (o[l] === "globalAlpha" && (d = `${e}-${c.svgAttr}`, r.getAttribute(d)))
              continue;
            r.setAttribute(d, `${u}`);
          }
      }
    }
  }
  get_serialized_svg(e = !1) {
    let r = new XMLSerializer().serializeToString(this.__root);
    if (e)
      for (const [o, s] of namedEntities) {
        const l = new RegExp(o, "gi");
        l.test(r) && (r = r.replace(l, s));
      }
    return r;
  }
  get_svg() {
    return this.__root;
  }
  save() {
    this.__stack.push({
      transform: this._transform,
      clip_path: this._clip_path,
      attributes: this.__getStyleState()
    }), this._transform = this._transform.clone();
  }
  restore() {
    if (this.__stack.length == 0)
      return;
    const { transform: e, clip_path: r, attributes: o } = this.__stack.pop();
    this._transform = e, this._clip_path = r, this.__applyStyleState(o);
  }
  _apply_transform(e, r = this._transform) {
    r.is_identity || e.setAttribute("transform", r.toString());
  }
  scale(e, r) {
    !isFinite(e) || r != null && !isFinite(r) || this._transform.scale(e, r != null ? r : e);
  }
  rotate(e) {
    !isFinite(e) || this._transform.rotate(e);
  }
  translate(e, r) {
    !isFinite(e + r) || this._transform.translate(e, r);
  }
  transform(e, r, o, s, l, c) {
    !isFinite(e + r + o + s + l + c) || this._transform.transform(e, r, o, s, l, c);
  }
  beginPath() {
    this.__currentDefaultPath = "", this.__currentPosition = null, this.__init_element();
  }
  __init_element() {
    const e = this.__createElement("path", {}, !0);
    this.__root.appendChild(e), this.__currentElement = e;
  }
  __applyCurrentDefaultPath() {
    const e = this.__currentElement;
    e.nodeName === "path" ? e.setAttribute("d", this.__currentDefaultPath) : console.error("Attempted to apply path command to node", e.nodeName);
  }
  __addPathCommand(e, r, o) {
    const s = this.__currentDefaultPath ? " " : "";
    this.__currentDefaultPath += s + o, this.__currentPosition = { x: e, y: r };
  }
  get _hasCurrentDefaultPath() {
    return !!this.__currentDefaultPath;
  }
  moveTo(e, r) {
    if (!isFinite(e + r))
      return;
    const o = this.__currentElement;
    (!o || o.nodeName !== "path") && this.beginPath();
    const [s, l] = this._transform.apply(e, r);
    this.__addPathCommand(s, l, `M ${s} ${l}`);
  }
  closePath() {
    this._hasCurrentDefaultPath && this.__addPathCommand(NaN, NaN, "Z");
  }
  lineTo(e, r) {
    if (!!isFinite(e + r))
      if (!this._hasCurrentDefaultPath)
        this.moveTo(e, r);
      else {
        const [o, s] = this._transform.apply(e, r);
        this.__addPathCommand(o, s, `L ${o} ${s}`);
      }
  }
  bezierCurveTo(e, r, o, s, l, c) {
    if (!isFinite(e + r + o + s + l + c))
      return;
    const [u, d] = this._transform.apply(l, c), [f, T] = this._transform.apply(e, r), [Q, m] = this._transform.apply(o, s);
    this.__addPathCommand(u, d, `C ${f} ${T} ${Q} ${m} ${u} ${d}`);
  }
  quadraticCurveTo(e, r, o, s) {
    if (!isFinite(e + r + o + s))
      return;
    const [l, c] = this._transform.apply(o, s), [u, d] = this._transform.apply(e, r);
    this.__addPathCommand(l, c, `Q ${u} ${d} ${l} ${c}`);
  }
  arcTo(e, r, o, s, l) {
    if (!isFinite(e + r + o + s + l) || this.__currentPosition == null)
      return;
    const c = this.__currentPosition.x, u = this.__currentPosition.y;
    if (l < 0)
      throw new Error(`IndexSizeError: The radius provided (${l}) is negative.`);
    if (c === e && u === r || e === o && r === s || l === 0) {
      this.lineTo(e, r);
      return;
    }
    function d([w, O]) {
      const D = Math.sqrt(w ** 2 + O ** 2);
      return [w / D, O / D];
    }
    const f = d([c - e, u - r]), T = d([o - e, s - r]);
    if (f[0] * T[1] === f[1] * T[0]) {
      this.lineTo(e, r);
      return;
    }
    const Q = f[0] * T[0] + f[1] * T[1], m = Math.acos(Math.abs(Q)), g = d([
      f[0] + T[0],
      f[1] + T[1]
    ]), v = l / Math.sin(m / 2), b = e + v * g[0], L = r + v * g[1], A = [
      -f[1],
      f[0]
    ], M = [
      T[1],
      -T[0]
    ];
    function S(w) {
      const O = w[0];
      return w[1] >= 0 ? Math.acos(O) : -Math.acos(O);
    }
    const E = S(A), k = S(M);
    this.lineTo(b + A[0] * l, L + A[1] * l), this.arc(b, L, l, E, k);
  }
  stroke() {
    this.__currentElement.nodeName === "path" && this.__currentElement.setAttribute("paint-order", "fill"), this.__applyCurrentDefaultPath(), this.__applyStyleToCurrentElement("stroke"), this._clip_path != null && this.__currentElement.setAttribute("clip-path", this._clip_path);
  }
  fill(e, r) {
    let o = null;
    if (e instanceof Path2D)
      o = e;
    else if ((e == "evenodd" || e == "nonzero" || e == null) && r == null)
      r = e;
    else
      throw new Error("invalid arguments");
    if (o != null)
      throw new Error("not implemented");
    this.__currentElement.getAttribute("fill") != "none" && this.__init_element(), this.__currentElement.nodeName === "path" && this.__currentElement.setAttribute("paint-order", "stroke"), this.__applyCurrentDefaultPath(), this.__applyStyleToCurrentElement("fill"), r != null && this.__currentElement.setAttribute("fill-rule", r), this._clip_path != null && this.__currentElement.setAttribute("clip-path", this._clip_path);
  }
  rect(e, r, o, s) {
    !isFinite(e + r + o + s) || (this.moveTo(e, r), this.lineTo(e + o, r), this.lineTo(e + o, r + s), this.lineTo(e, r + s), this.lineTo(e, r));
  }
  fillRect(e, r, o, s) {
    !isFinite(e + r + o + s) || (this.beginPath(), this.rect(e, r, o, s), this.fill());
  }
  strokeRect(e, r, o, s) {
    !isFinite(e + r + o + s) || (this.beginPath(), this.rect(e, r, o, s), this.stroke());
  }
  __clearCanvas() {
    empty$1(this.__defs), empty$1(this.__root), this.__root.appendChild(this.__defs), this.__currentElement = this.__root;
  }
  clearRect(e, r, o, s) {
    if (!isFinite(e + r + o + s))
      return;
    if (e === 0 && r === 0 && o === this.width && s === this.height) {
      this.__clearCanvas();
      return;
    }
    const l = this.__createElement("rect", { x: e, y: r, width: o, height: s, fill: "#FFFFFF" }, !0);
    this._apply_transform(l), this.__root.appendChild(l);
  }
  createLinearGradient(e, r, o, s) {
    if (!isFinite(e + r + o + s))
      throw new Error("The provided double value is non-finite");
    const [l, c] = this._transform.apply(e, r), [u, d] = this._transform.apply(o, s), f = this.__createElement("linearGradient", {
      id: this._random_string(),
      x1: `${l}px`,
      x2: `${u}px`,
      y1: `${c}px`,
      y2: `${d}px`,
      gradientUnits: "userSpaceOnUse"
    }, !1);
    return this.__defs.appendChild(f), new CanvasGradient(f, this);
  }
  createRadialGradient(e, r, o, s, l, c) {
    if (!isFinite(e + r + o + s + l + c))
      throw new Error("The provided double value is non-finite");
    const [u, d] = this._transform.apply(e, r), [f, T] = this._transform.apply(s, l), Q = this.__createElement("radialGradient", {
      id: this._random_string(),
      cx: `${f}px`,
      cy: `${T}px`,
      r: `${c}px`,
      r0: `${o}px`,
      fx: `${u}px`,
      fy: `${d}px`,
      gradientUnits: "userSpaceOnUse"
    }, !1);
    return this.__defs.appendChild(Q), new CanvasGradient(Q, this);
  }
  __parseFont() {
    var s, l, c, u, d;
    const r = /^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font);
    return {
      style: (s = r[1]) != null ? s : "normal",
      size: (l = r[4]) != null ? l : "10px",
      family: (c = r[6]) != null ? c : "sans-serif",
      weight: (u = r[3]) != null ? u : "normal",
      decoration: (d = r[2]) != null ? d : "normal"
    };
  }
  __applyText(e, r, o, s) {
    const l = this.__parseFont(), c = this.__createElement("text", {
      "font-family": l.family,
      "font-size": l.size,
      "font-style": l.style,
      "font-weight": l.weight,
      "text-decoration": l.decoration,
      x: r,
      y: o,
      "text-anchor": getTextAnchor(this.textAlign),
      "dominant-baseline": getDominantBaseline(this.textBaseline)
    }, !0);
    c.appendChild(this.__document.createTextNode(e)), this._apply_transform(c), this.__currentElement = c, this.__applyStyleToCurrentElement(s);
    const u = (() => {
      if (this._clip_path != null) {
        const d = this.__createElement("g");
        return d.setAttribute("clip-path", this._clip_path), d.appendChild(c), d;
      } else
        return c;
    })();
    this.__root.appendChild(u);
  }
  fillText(e, r, o) {
    e == null || !isFinite(r + o) || this.__applyText(e, r, o, "fill");
  }
  strokeText(e, r, o) {
    e == null || !isFinite(r + o) || this.__applyText(e, r, o, "stroke");
  }
  measureText(e) {
    return this.__ctx.font = this.font, this.__ctx.measureText(e);
  }
  arc(e, r, o, s, l, c = !1) {
    this.ellipse(e, r, o, o, 0, s, l, c);
  }
  ellipse(e, r, o, s, l, c, u, d = !1) {
    if (!isFinite(e + r + o + s + l + c + u))
      return;
    if (o < 0 || s < 0)
      throw new DOMException("IndexSizeError, radius can't be negative");
    const f = d ? u - c : c - u;
    c = c % (2 * Math.PI), u = u % (2 * Math.PI);
    const T = e + o * Math.cos(c), Q = r + s * Math.sin(c);
    this.lineTo(T, Q);
    const m = l * 180 / Math.PI, g = d ? 0 : 1;
    if (Math.abs(c - u) < 2 * float32_epsilon && !(Math.abs(f) < 2 * float32_epsilon && f < 0)) {
      const v = e + o * Math.cos(c + Math.PI), b = r + s * Math.sin(c + Math.PI), [L, A] = this._transform.apply(T, Q), [M, S] = this._transform.apply(v, b);
      this.__addPathCommand(L, A, `A ${o} ${s} ${m} 0 ${g} ${M} ${S} A ${o} ${s} ${m} 0 ${g} ${L} ${A}`);
    } else {
      const v = e + o * Math.cos(u), b = r + s * Math.sin(u);
      let L = u - c;
      L < 0 && (L += 2 * Math.PI);
      const A = d !== L > Math.PI ? 1 : 0, [M, S] = this._transform.apply(v, b);
      this.__addPathCommand(M, S, `A ${o} ${s} ${m} ${A} ${g} ${M} ${S}`);
    }
  }
  clip() {
    const e = this.__createElement("clipPath"), r = this._random_string();
    this.__applyCurrentDefaultPath(), e.setAttribute("id", r), e.appendChild(this.__currentElement), this.__defs.appendChild(e), this._clip_path = `url(#${r})`;
  }
  drawImage(e, ...r) {
    let o, s, l, c, u, d, f, T;
    if (r.length == 2) {
      if ([o, s] = r, !isFinite(o + s))
        return;
      u = 0, d = 0, f = e.width, T = e.height, l = f, c = T;
    } else if (r.length == 4) {
      if ([o, s, l, c] = r, !isFinite(o + s + l + c))
        return;
      u = 0, d = 0, f = e.width, T = e.height;
    } else if (r.length === 8) {
      if ([u, d, f, T, o, s, l, c] = r, !isFinite(u + d + f + T + o + s + l + c))
        return;
    } else
      throw new Error(`Inavlid number of arguments passed to drawImage: ${arguments.length}`);
    const Q = this.__root, m = this._transform.clone().translate(o, s);
    if (e instanceof SVGRenderingContext2D || e instanceof SVGSVGElement) {
      const v = (e instanceof SVGSVGElement ? e : e.get_svg()).cloneNode(!0);
      let b;
      m.is_identity && this.globalAlpha == 1 && this._clip_path == null ? b = Q : (b = this.__createElement("g"), m.is_identity || this._apply_transform(b, m), this.globalAlpha != 1 && b.setAttribute("opacity", `${this.globalAlpha}`), this._clip_path != null && b.setAttribute("clip-path", this._clip_path), Q.appendChild(b));
      for (const L of [...v.childNodes])
        if (L instanceof SVGDefsElement) {
          for (const A of [...L.childNodes])
            if (A instanceof Element) {
              const M = A.getAttribute("id");
              this.__ids.add(M), this.__defs.appendChild(A.cloneNode(!0));
            }
        } else
          b.appendChild(L.cloneNode(!0));
    } else if (e instanceof HTMLImageElement || e instanceof SVGImageElement) {
      const g = this.__createElement("image");
      if (g.setAttribute("width", `${l}`), g.setAttribute("height", `${c}`), g.setAttribute("preserveAspectRatio", "none"), this.globalAlpha != 1 && g.setAttribute("opacity", `${this.globalAlpha}`), u || d || f !== e.width || T !== e.height) {
        const b = this.__document.createElement("canvas");
        b.width = l, b.height = c, b.getContext("2d").drawImage(e, u, d, f, T, 0, 0, l, c), e = b;
      }
      this._apply_transform(g, m);
      const v = e instanceof HTMLCanvasElement ? e.toDataURL() : e.getAttribute("src");
      if (g.setAttribute("href", v), this._clip_path != null) {
        const b = this.__createElement("g");
        b.setAttribute("clip-path", this._clip_path), b.appendChild(g), Q.appendChild(b);
      } else
        Q.appendChild(g);
    } else if (e instanceof HTMLCanvasElement) {
      const g = this.__createElement("image");
      g.setAttribute("width", `${l}`), g.setAttribute("height", `${c}`), g.setAttribute("preserveAspectRatio", "none"), this.globalAlpha != 1 && g.setAttribute("opacity", `${this.globalAlpha}`);
      const v = this.__document.createElement("canvas");
      v.width = l, v.height = c;
      const b = v.getContext("2d");
      if (b.imageSmoothingEnabled = !1, b.drawImage(e, u, d, f, T, 0, 0, l, c), e = v, this._apply_transform(g, m), g.setAttribute("href", e.toDataURL()), this._clip_path != null) {
        const L = this.__createElement("g");
        L.setAttribute("clip-path", this._clip_path), L.appendChild(g), Q.appendChild(L);
      } else
        Q.appendChild(g);
    }
  }
  createPattern(e, r) {
    const o = this.__document.createElementNS("http://www.w3.org/2000/svg", "pattern"), s = this._random_string();
    if (o.setAttribute("id", s), o.setAttribute("width", `${this._to_number(e.width)}`), o.setAttribute("height", `${this._to_number(e.height)}`), o.setAttribute("patternUnits", "userSpaceOnUse"), e instanceof HTMLCanvasElement || e instanceof HTMLImageElement || e instanceof SVGImageElement) {
      const l = this.__document.createElementNS("http://www.w3.org/2000/svg", "image"), c = e instanceof HTMLCanvasElement ? e.toDataURL() : e.getAttribute("src");
      l.setAttribute("href", c), o.appendChild(l), this.__defs.appendChild(o);
    } else if (e instanceof SVGRenderingContext2D) {
      for (const l of [...e.__root.childNodes])
        l instanceof SVGDefsElement || o.appendChild(l.cloneNode(!0));
      this.__defs.appendChild(o);
    } else if (e instanceof SVGSVGElement) {
      for (const l of [...e.childNodes])
        l instanceof SVGDefsElement || o.appendChild(l.cloneNode(!0));
      this.__defs.appendChild(o);
    } else
      throw new Error("unsupported");
    return new CanvasPattern(o, this);
  }
  getLineDash() {
    const { lineDash: e } = this;
    return isString(e) ? e.split(",").map((r) => parseInt(r)) : e == null ? [] : e;
  }
  setLineDash(e) {
    e && e.length > 0 ? this.lineDash = e.join(",") : this.lineDash = null;
  }
  _to_number(e) {
    return isNumber(e) ? e : e.baseVal.value;
  }
  getTransform() {
    return this._transform.to_DOMMatrix();
  }
  setTransform(...e) {
    let r;
    isNumber(e[0]) ? r = new DOMMatrix(e) : e[0] instanceof DOMMatrix ? r = e[0] : r = new DOMMatrix(Object.values(!e[0])), this._transform = AffineTransform.from_DOMMatrix(r);
  }
  resetTransform() {
    this._transform = new AffineTransform();
  }
  isPointInPath(...e) {
    throw new Error("not implemented");
  }
  isPointInStroke(...e) {
    throw new Error("not implemented");
  }
  createImageData(...e) {
    throw new Error("not implemented");
  }
  getImageData(e, r, o, s) {
    throw new Error("not implemented");
  }
  putImageData(...e) {
    throw new Error("not implemented");
  }
  drawFocusIfNeeded(...e) {
    throw new Error("not implemented");
  }
  scrollPathIntoView(...e) {
    throw new Error("not implemented");
  }
}
SVGRenderingContext2D.__name__ = "SVGRenderingContext2D";
SVGRenderingContext2D.__random = random;
function fixup_line_dash(t) {
  typeof t.lineDash > "u" && Object.defineProperty(t, "lineDash", {
    get: () => t.getLineDash(),
    set: (e) => t.setLineDash(e)
  });
}
function fixup_image_smoothing(t) {
  t.setImageSmoothingEnabled = (e) => {
    t.imageSmoothingEnabled = e, t.mozImageSmoothingEnabled = e, t.oImageSmoothingEnabled = e, t.webkitImageSmoothingEnabled = e, t.msImageSmoothingEnabled = e;
  }, t.getImageSmoothingEnabled = () => {
    const e = t.imageSmoothingEnabled;
    return e != null ? e : !0;
  };
}
function fixup_ellipse(t) {
  function e(r, o, s, l, c, u, d, f = !1) {
    t.translate(r, o), t.rotate(c);
    let Q = s, m = l;
    f && (Q = -s, m = -l), t.moveTo(-Q, 0), t.bezierCurveTo(-Q, m * 0.551784, -Q * 0.551784, m, 0, m), t.bezierCurveTo(Q * 0.551784, m, Q, m * 0.551784, Q, 0), t.bezierCurveTo(Q, -m * 0.551784, Q * 0.551784, -m, 0, -m), t.bezierCurveTo(-Q * 0.551784, -m, -Q, -m * 0.551784, -Q, 0), t.rotate(-c), t.translate(-r, -o);
  }
  t.ellipse || (t.ellipse = e);
}
function fixup_ctx(t) {
  fixup_line_dash(t), fixup_image_smoothing(t), fixup_ellipse(t);
}
const style$1 = {
  position: "absolute",
  top: "0",
  left: "0",
  width: "100%",
  height: "100%"
};
class CanvasLayer {
  constructor(e, r) {
    switch (this.backend = e, this.hidpi = r, this.pixel_ratio = 1, this.bbox = new BBox$2(), e) {
      case "webgl":
      case "canvas": {
        this._el = this._canvas = canvas({ style: style$1 });
        const o = this.canvas.getContext("2d");
        if (o == null)
          throw new Error("unable to obtain 2D rendering context");
        this._ctx = o, r && (this.pixel_ratio = devicePixelRatio);
        break;
      }
      case "svg": {
        const o = new SVGRenderingContext2D();
        this._ctx = o, this._canvas = o.get_svg(), this._el = div({ style: style$1 }, this._canvas);
        break;
      }
    }
    this._ctx.layer = this, fixup_ctx(this._ctx);
  }
  get canvas() {
    return this._canvas;
  }
  get ctx() {
    return this._ctx;
  }
  get el() {
    return this._el;
  }
  resize(e, r) {
    this.bbox = new BBox$2({ left: 0, top: 0, width: e, height: r });
    const o = this._ctx instanceof SVGRenderingContext2D ? this._ctx : this.canvas;
    o.width = e * this.pixel_ratio, o.height = r * this.pixel_ratio;
  }
  undo_transform(e) {
    const { ctx: r } = this;
    if (typeof r.getTransform > "u")
      e(r);
    else {
      const o = r.getTransform();
      r.setTransform(this._base_transform);
      try {
        e(r);
      } finally {
        r.setTransform(o);
      }
    }
  }
  prepare() {
    const { ctx: e, hidpi: r, pixel_ratio: o } = this;
    e.save(), r && (e.scale(o, o), e.translate(0.5, 0.5)), typeof e.getTransform < "u" && (this._base_transform = e.getTransform()), this.clear();
  }
  clear() {
    const { x: e, y: r, width: o, height: s } = this.bbox;
    this.ctx.clearRect(e, r, o, s);
  }
  finish() {
    this.ctx.restore();
  }
  to_blob() {
    const { _canvas: e } = this;
    if (e instanceof HTMLCanvasElement)
      return e.msToBlob != null ? Promise.resolve(e.msToBlob()) : new Promise((r, o) => {
        e.toBlob((s) => s != null ? r(s) : o(), "image/png");
      });
    {
      const o = this._ctx.get_serialized_svg(!0), s = new Blob([o], { type: "image/svg+xml" });
      return Promise.resolve(s);
    }
  }
}
CanvasLayer.__name__ = "CanvasLayer";
class ActionToolButtonView extends ButtonToolButtonView {
  _clicked() {
    this.model.do.emit(void 0);
  }
}
ActionToolButtonView.__name__ = "ActionToolButtonView";
class ActionToolView extends ButtonToolView {
  connect_signals() {
    super.connect_signals(), this.connect(this.model.do, (e) => this.doit(e));
  }
}
ActionToolView.__name__ = "ActionToolView";
class ActionTool extends ButtonTool {
  constructor(e) {
    super(e), this.button_view = ActionToolButtonView, this.do = new Signal(this, "do");
  }
}
ActionTool.__name__ = "ActionTool";
var _a$2D;
class HelpToolView extends ActionToolView {
  doit() {
    window.open(this.model.redirect);
  }
}
HelpToolView.__name__ = "HelpToolView";
class HelpTool extends ActionTool {
  constructor(e) {
    super(e), this.tool_name = "Help", this.icon = tool_icon_help;
  }
}
_a$2D = HelpTool;
HelpTool.__name__ = "HelpTool";
_a$2D.prototype.default_view = HelpToolView, _a$2D.define(({ String: t }) => ({
  redirect: [t, "https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]
})), _a$2D.override({
  description: "Click the question mark to learn more about Bokeh plot tools."
}), _a$2D.register_alias("help", () => new HelpTool());
const logo = "bk-logo", grey = "bk-grey", logo_small = "bk-logo-small", logo_css = `.bk-root .bk-logo{margin:5px;position:relative;display:block;background-repeat:no-repeat;}.bk-root .bk-logo.bk-grey{filter:url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale");filter:gray;-webkit-filter:grayscale(100%);}.bk-root .bk-logo-small{width:20px;height:20px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);}.bk-root .bk-logo-notebook{display:inline-block;vertical-align:middle;margin-right:5px;}`;
var _a$2C, _b$6;
class ToolbarViewModel extends Model {
  constructor(e) {
    super(e);
  }
  get visible() {
    var e;
    return !this.autohide || ((e = this._visible) != null ? e : !1);
  }
}
_a$2C = ToolbarViewModel;
ToolbarViewModel.__name__ = "ToolbarViewModel";
_a$2C.define(({ Boolean: t }) => ({
  autohide: [t, !1]
})), _a$2C.internal(({ Boolean: t, Nullable: e }) => ({
  _visible: [e(t), null]
}));
class ToolbarBaseView extends DOMView {
  constructor() {
    super(...arguments), this.layout = { bbox: new BBox$2() };
  }
  initialize() {
    super.initialize(), this._tool_button_views = /* @__PURE__ */ new Map(), this._toolbar_view_model = new ToolbarViewModel({ autohide: this.model.autohide });
    const { toolbar_location: e } = this.model, r = e == "left" || e == "above", o = this.model.horizontal ? "vertical" : "horizontal";
    this._overflow_menu = new ContextMenu([], {
      orientation: o,
      reversed: r
    });
  }
  async lazy_initialize() {
    await super.lazy_initialize(), await this._build_tool_button_views();
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.properties.tools.change, async () => {
      await this._build_tool_button_views(), this.render();
    }), this.connect(this.model.properties.autohide.change, () => {
      this._toolbar_view_model.autohide = this.model.autohide, this._on_visible_change();
    }), this.connect(this._toolbar_view_model.properties._visible.change, () => this._on_visible_change());
  }
  styles() {
    return [...super.styles(), toolbars_css, logo_css];
  }
  remove() {
    remove_views(this._tool_button_views), super.remove();
  }
  async _build_tool_button_views() {
    const e = this.model._proxied_tools != null ? this.model._proxied_tools : this.model.tools;
    await build_views(this._tool_button_views, e, { parent: this }, (r) => r.button_view);
  }
  set_visibility(e) {
    e != this._toolbar_view_model._visible && (this._toolbar_view_model._visible = e);
  }
  _on_visible_change() {
    const { visible: e } = this._toolbar_view_model;
    classes(this.el).toggle(toolbar_hidden, !e);
  }
  render() {
    empty$1(this.el), this.el.classList.add(toolbar), this.el.classList.add(toolbars[this.model.toolbar_location]), this._toolbar_view_model.autohide = this.model.autohide, this._on_visible_change();
    const { horizontal: e } = this.model;
    let r = 0;
    if (this.model.logo != null) {
      const g = this.model.logo === "grey" ? grey : null, v = a({ href: "https://bokeh.org/", target: "_blank", class: [logo, logo_small, g] });
      this.el.appendChild(v);
      const { width: b, height: L } = v.getBoundingClientRect();
      r += e ? b : L;
    }
    for (const [, g] of this._tool_button_views)
      g.render();
    const o = [], s = (g) => this._tool_button_views.get(g).el, { gestures: l } = this.model;
    for (const g of values(l))
      o.push(g.tools.map(s));
    o.push(this.model.actions.map(s)), o.push(this.model.inspectors.filter((g) => g.toggleable).map(s));
    const c = o.filter((g) => g.length != 0), u = () => div({ class: divider$1 }), { bbox: d } = this.layout;
    let f = !1;
    const T = 15;
    this.root.el.appendChild(this._overflow_menu.el);
    const Q = div({ class: tool_overflow, tabIndex: 0 }, e ? "\u22EE" : "\u22EF"), m = () => {
      const g = (() => {
        switch (this.model.toolbar_location) {
          case "right":
            return { left_of: Q };
          case "left":
            return { right_of: Q };
          case "above":
            return { below: Q };
          case "below":
            return { above: Q };
        }
      })();
      this._overflow_menu.toggle(g);
    };
    Q.addEventListener("click", () => {
      m();
    }), Q.addEventListener("keydown", (g) => {
      g.keyCode == Keys.Enter && m();
    });
    for (const g of join(c, u))
      if (f)
        this._overflow_menu.items.push({ content: g, class: e ? right$2 : above$2 });
      else {
        this.el.appendChild(g);
        const { width: v, height: b } = g.getBoundingClientRect();
        if (r += e ? v : b, f = e ? r > d.width - T : r > d.height - T, f) {
          this.el.removeChild(g), this.el.appendChild(Q);
          const { items: L } = this._overflow_menu;
          L.splice(0, L.length), L.push({ content: g });
        }
      }
  }
  update_layout() {
  }
  update_position() {
  }
  after_layout() {
    this._has_finished = !0;
  }
  export(e, r = !0) {
    const o = e == "png" ? "canvas" : "svg", s = new CanvasLayer(o, r);
    return s.resize(0, 0), s;
  }
}
ToolbarBaseView.__name__ = "ToolbarBaseView";
function create_gesture_map() {
  return {
    pan: { tools: [], active: null },
    scroll: { tools: [], active: null },
    pinch: { tools: [], active: null },
    tap: { tools: [], active: null },
    doubletap: { tools: [], active: null },
    press: { tools: [], active: null },
    pressup: { tools: [], active: null },
    rotate: { tools: [], active: null },
    move: { tools: [], active: null },
    multi: { tools: [], active: null }
  };
}
class ToolbarBase extends Model {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this._init_tools();
  }
  _init_tools() {
    const e = function(u, d) {
      if (u.length != d.length)
        return !0;
      const f = new Set(d.map((T) => T.id));
      return some(u, (T) => !f.has(T.id));
    }, r = this.tools.filter((u) => u instanceof InspectTool);
    e(this.inspectors, r) && (this.inspectors = r);
    const o = this.tools.filter((u) => u instanceof HelpTool);
    e(this.help, o) && (this.help = o);
    const s = this.tools.filter((u) => u instanceof ActionTool);
    e(this.actions, s) && (this.actions = s);
    const l = (u, d) => {
      u in this.gestures || logger.warn(`Toolbar: unknown event type '${u}' for tool: ${d}`);
    }, c = create_gesture_map();
    for (const u of this.tools)
      if (u instanceof GestureTool && u.event_type)
        if (isString(u.event_type))
          c[u.event_type].tools.push(u), l(u.event_type, u);
        else {
          c.multi.tools.push(u);
          for (const d of u.event_type)
            l(d, u);
        }
    for (const u of Object.keys(c)) {
      const d = this.gestures[u];
      e(d.tools, c[u].tools) && (d.tools = c[u].tools), d.active && every(d.tools, (f) => f.id != d.active.id) && (d.active = null);
    }
  }
  get horizontal() {
    return this.toolbar_location === "above" || this.toolbar_location === "below";
  }
  get vertical() {
    return this.toolbar_location === "left" || this.toolbar_location === "right";
  }
  _active_change(e) {
    const { event_type: r } = e;
    if (r == null)
      return;
    const o = isString(r) ? [r] : r;
    for (const s of o)
      if (e.active) {
        const l = this.gestures[s].active;
        l != null && e != l && (logger.debug(`Toolbar: deactivating tool: ${l} for event type '${s}'`), l.active = !1), this.gestures[s].active = e, logger.debug(`Toolbar: activating tool: ${e} for event type '${s}'`);
      } else
        this.gestures[s].active = null;
  }
}
_b$6 = ToolbarBase;
ToolbarBase.__name__ = "ToolbarBase";
_b$6.prototype.default_view = ToolbarBaseView, _b$6.define(({ Boolean: t, Array: e, Ref: r, Nullable: o }) => ({
  tools: [e(r(Tool)), []],
  logo: [o(Logo), "normal"],
  autohide: [t, !1]
})), _b$6.internal(({ Array: t, Struct: e, Ref: r, Nullable: o }) => {
  const s = e({
    tools: t(r(GestureTool)),
    active: o(r(Tool))
  });
  return {
    gestures: [e({
      pan: s,
      scroll: s,
      pinch: s,
      tap: s,
      doubletap: s,
      press: s,
      pressup: s,
      rotate: s,
      move: s,
      multi: s
    }), create_gesture_map],
    actions: [t(r(ActionTool)), []],
    inspectors: [t(r(InspectTool)), []],
    help: [t(r(HelpTool)), []],
    toolbar_location: [Location, "right"]
  };
});
var _a$2B;
const Drag = Tool, Inspection = Tool, Scroll = Tool, Tap$1 = Tool;
function _get_active_attr(t) {
  switch (t) {
    case "tap":
      return "active_tap";
    case "pan":
      return "active_drag";
    case "pinch":
    case "scroll":
      return "active_scroll";
    case "multi":
      return "active_multi";
  }
  return null;
}
function _supports_auto(t) {
  return t == "tap" || t == "pan";
}
class Toolbar extends ToolbarBase {
  constructor(e) {
    super(e);
  }
  connect_signals() {
    super.connect_signals();
    const { tools: e, active_drag: r, active_inspect: o, active_scroll: s, active_tap: l, active_multi: c } = this.properties;
    this.on_change([e, r, o, s, l, c], () => this._init_tools());
  }
  _init_tools() {
    if (super._init_tools(), this.active_inspect != "auto") {
      if (this.active_inspect instanceof InspectTool) {
        let r = !1;
        for (const o of this.inspectors)
          o != this.active_inspect ? o.active = !1 : r = !0;
        r || (this.active_inspect = null);
      } else if (isArray(this.active_inspect)) {
        const r = intersection(this.active_inspect, this.inspectors);
        r.length != this.active_inspect.length && (this.active_inspect = r);
        for (const o of this.inspectors)
          includes(this.active_inspect, o) || (o.active = !1);
      } else if (this.active_inspect == null)
        for (const r of this.inspectors)
          r.active = !1;
    }
    const e = (r) => {
      r.active ? this._active_change(r) : r.active = !0;
    };
    for (const r of values(this.gestures)) {
      r.tools = sort_by(r.tools, (o) => o.default_order);
      for (const o of r.tools)
        this.connect(o.properties.active.change, () => this._active_change(o));
    }
    for (const [r, o] of entries(this.gestures)) {
      const s = _get_active_attr(r);
      if (s) {
        const l = this[s];
        l == "auto" ? o.tools.length != 0 && _supports_auto(r) && e(o.tools[0]) : l != null && (includes(this.tools, l) ? e(l) : this[s] = null);
      }
    }
  }
}
_a$2B = Toolbar;
Toolbar.__name__ = "Toolbar";
_a$2B.prototype.default_view = ToolbarBaseView, _a$2B.define(({ Or: t, Ref: e, Auto: r, Null: o }) => ({
  active_drag: [t(e(Drag), r, o), "auto"],
  active_inspect: [t(e(Inspection), r, o), "auto"],
  active_scroll: [t(e(Scroll), r, o), "auto"],
  active_tap: [t(e(Tap$1), r, o), "auto"],
  active_multi: [t(e(GestureTool), r, o), "auto"]
}));
var _a$2A;
class ToolbarPanelView extends AnnotationView {
  constructor() {
    super(...arguments), this._invalidate_toolbar = !0, this._previous_bbox = new BBox$2();
  }
  update_layout() {
    this.layout = new SideLayout(this.panel, () => this.get_size(), !0);
  }
  initialize() {
    super.initialize(), this.el = div(), this.plot_view.canvas_view.add_event(this.el);
  }
  async lazy_initialize() {
    await super.lazy_initialize(), this._toolbar_view = await build_view(this.model.toolbar, { parent: this }), this.plot_view.visibility_callbacks.push((e) => this._toolbar_view.set_visibility(e));
  }
  remove() {
    this._toolbar_view.remove(), remove(this.el), super.remove();
  }
  render() {
    this.model.visible || undisplay(this.el), super.render();
  }
  _render() {
    const { bbox: e } = this.layout;
    this._previous_bbox.equals(e) || (position(this.el, e), this._previous_bbox = e, this._invalidate_toolbar = !0), this._invalidate_toolbar && (this.el.style.position = "absolute", this.el.style.overflow = "hidden", empty$1(this.el), this.el.appendChild(this._toolbar_view.el), this._toolbar_view.layout.bbox = e, this._toolbar_view.render(), this._invalidate_toolbar = !1), display(this.el);
  }
  _get_size() {
    const { tools: e, logo: r } = this.model.toolbar;
    return {
      width: e.length * 30 + (r != null ? 25 : 0) + 15,
      height: 30
    };
  }
}
ToolbarPanelView.__name__ = "ToolbarPanelView";
class ToolbarPanel extends Annotation {
  constructor(e) {
    super(e);
  }
}
_a$2A = ToolbarPanel;
ToolbarPanel.__name__ = "ToolbarPanel";
_a$2A.prototype.default_view = ToolbarPanelView, _a$2A.define(({ Ref: t }) => ({
  toolbar: [t(Toolbar)]
}));
const tooltip = "bk-tooltip", left$1 = "bk-left", tooltip_arrow = "bk-tooltip-arrow", right$1 = "bk-right", above$1 = "bk-above", below$1 = "bk-below", tooltip_row_label = "bk-tooltip-row-label", tooltip_row_value = "bk-tooltip-row-value", tooltip_color_block = "bk-tooltip-color-block", tooltips_css = '.bk-root{}.bk-root .bk-tooltip{font-weight:300;font-size:12px;position:absolute;padding:5px;border:1px solid #e5e5e5;color:#2f2f2f;background-color:white;pointer-events:none;opacity:0.95;z-index:100;}.bk-root .bk-tooltip > div:not(:first-child){margin-top:5px;border-top:#e5e5e5 1px dashed;}.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-left::before{left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-right::after{right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-above::before{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;top:-10px;border-bottom-width:10px;border-bottom-color:#909599;}.bk-root .bk-tooltip.bk-below::after{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;bottom:-10px;border-top-width:10px;border-top-color:#909599;}.bk-root .bk-tooltip-row-label{text-align:right;color:#26aae1;}.bk-root .bk-tooltip-row-value{color:default;}.bk-root .bk-tooltip-color-block{width:12px;height:12px;margin-left:5px;margin-right:5px;outline:#dddddd solid 1px;display:inline-block;}';
var _a$2z;
const arrow_size = 10;
class TooltipView extends AnnotationView {
  initialize() {
    super.initialize(), this.el = div({ class: tooltip }), undisplay(this.el), this.plot_view.canvas_view.add_overlay(this.el);
  }
  remove() {
    remove(this.el), super.remove();
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.properties.content.change, () => this.render()), this.connect(this.model.properties.position.change, () => this._reposition());
  }
  styles() {
    return [...super.styles(), tooltips_css];
  }
  render() {
    this.model.visible || undisplay(this.el), super.render();
  }
  _render() {
    const { content: e } = this.model;
    if (e == null) {
      undisplay(this.el);
      return;
    }
    empty$1(this.el), classes(this.el).toggle("bk-tooltip-custom", this.model.custom), this.el.appendChild(e), this.model.show_arrow && this.el.classList.add(tooltip_arrow);
  }
  _reposition() {
    const { position: e } = this.model;
    if (e == null) {
      undisplay(this.el);
      return;
    }
    const [r, o] = e, s = (() => {
      const d = this.parent.layout.bbox.relative(), { attachment: f } = this.model;
      switch (f) {
        case "horizontal":
          return r < d.hcenter ? "right" : "left";
        case "vertical":
          return o < d.vcenter ? "below" : "above";
        default:
          return f;
      }
    })();
    this.el.classList.remove(right$1), this.el.classList.remove(left$1), this.el.classList.remove(above$1), this.el.classList.remove(below$1), display(this.el);
    let l, c = null, u = null;
    switch (s) {
      case "right":
        this.el.classList.add(left$1), c = r + (this.el.offsetWidth - this.el.clientWidth) + arrow_size, l = o - this.el.offsetHeight / 2;
        break;
      case "left":
        this.el.classList.add(right$1), u = this.plot_view.layout.bbox.width - r + arrow_size, l = o - this.el.offsetHeight / 2;
        break;
      case "below":
        this.el.classList.add(above$1), l = o + (this.el.offsetHeight - this.el.clientHeight) + arrow_size, c = Math.round(r - this.el.offsetWidth / 2);
        break;
      case "above":
        this.el.classList.add(below$1), l = o - this.el.offsetHeight - arrow_size, c = Math.round(r - this.el.offsetWidth / 2);
        break;
    }
    this.el.style.top = `${l}px`, this.el.style.left = c != null ? `${c}px` : "auto", this.el.style.right = u != null ? `${u}px` : "auto";
  }
}
TooltipView.__name__ = "TooltipView";
class Tooltip extends Annotation {
  constructor(e) {
    super(e);
  }
  clear() {
    this.position = null;
  }
}
_a$2z = Tooltip;
Tooltip.__name__ = "Tooltip";
_a$2z.prototype.default_view = TooltipView, _a$2z.define(({ Boolean: t }) => ({
  attachment: [TooltipAttachment, "horizontal"],
  inner_only: [t, !0],
  show_arrow: [t, !0]
})), _a$2z.internal(({ Boolean: t, Number: e, Tuple: r, Ref: o, Nullable: s }) => ({
  position: [s(r(e, e)), null],
  content: [o(HTMLElement), () => div()],
  custom: [t]
})), _a$2z.override({
  level: "overlay"
});
var _a$2y;
class WhiskerView extends UpperLowerView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { lower_head: e, upper_head: r } = this.model;
    e != null && (this.lower_head = await build_view(e, { parent: this })), r != null && (this.upper_head = await build_view(r, { parent: this }));
  }
  set_data(e) {
    var r, o;
    super.set_data(e), (r = this.lower_head) == null || r.set_data(e), (o = this.upper_head) == null || o.set_data(e);
  }
  paint(e) {
    if (this.visuals.line.doit)
      for (let o = 0, s = this._lower_sx.length; o < s; o++)
        this.visuals.line.set_vectorize(e, o), e.beginPath(), e.moveTo(this._lower_sx[o], this._lower_sy[o]), e.lineTo(this._upper_sx[o], this._upper_sy[o]), e.stroke();
    const r = this.model.dimension == "height" ? 0 : Math.PI / 2;
    if (this.lower_head != null)
      for (let o = 0, s = this._lower_sx.length; o < s; o++)
        e.save(), e.translate(this._lower_sx[o], this._lower_sy[o]), e.rotate(r + Math.PI), this.lower_head.render(e, o), e.restore();
    if (this.upper_head != null)
      for (let o = 0, s = this._upper_sx.length; o < s; o++)
        e.save(), e.translate(this._upper_sx[o], this._upper_sy[o]), e.rotate(r), this.upper_head.render(e, o), e.restore();
  }
}
WhiskerView.__name__ = "WhiskerView";
class Whisker extends UpperLower {
  constructor(e) {
    super(e);
  }
}
_a$2y = Whisker;
Whisker.__name__ = "Whisker";
_a$2y.prototype.default_view = WhiskerView, _a$2y.mixins(LineVector$1), _a$2y.define(({ Ref: t, Nullable: e }) => ({
  lower_head: [e(t(ArrowHead)), () => new TeeHead({ size: 10 })],
  upper_head: [e(t(ArrowHead)), () => new TeeHead({ size: 10 })]
})), _a$2y.override({
  level: "underlay"
});
class Callback extends Model {
  constructor(e) {
    super(e);
  }
}
Callback.__name__ = "Callback";
var _a$2x;
class CustomJS extends Callback {
  constructor(e) {
    super(e);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  get func() {
    const e = use_strict(this.code);
    return new Function(...this.names, "cb_obj", "cb_data", e);
  }
  execute(e, r = {}) {
    return this.func.apply(e, this.values.concat(e, r));
  }
}
_a$2x = CustomJS;
CustomJS.__name__ = "CustomJS";
_a$2x.define(({ Unknown: t, String: e, Dict: r }) => ({
  args: [r(t), {}],
  code: [e, ""]
}));
var _a$2w;
class OpenURL extends Callback {
  constructor(e) {
    super(e);
  }
  navigate(e) {
    this.same_tab ? window.location.href = e : window.open(e);
  }
  execute(e, { source: r }) {
    const o = (l) => {
      const c = replace_placeholders(this.url, r, l, void 0, void 0, encodeURI);
      if (!isString(c))
        throw new Error("HTML output is not supported in this context");
      this.navigate(c);
    }, { selected: s } = r;
    for (const l of s.indices)
      o(l);
    for (const l of s.line_indices)
      o(l);
  }
}
_a$2w = OpenURL;
OpenURL.__name__ = "OpenURL";
_a$2w.define(({ Boolean: t, String: e }) => ({
  url: [e, "http://"],
  same_tab: [t, !1]
}));
var __decorate = globalThis && globalThis.__decorate || function(t, e, r, o) {
  var s = arguments.length, l = s < 3 ? e : o === null ? o = Object.getOwnPropertyDescriptor(e, r) : o, c;
  if (typeof Reflect == "object" && typeof Reflect.decorate == "function")
    l = Reflect.decorate(t, e, r, o);
  else
    for (var u = t.length - 1; u >= 0; u--)
      (c = t[u]) && (l = (s < 3 ? c(l) : s > 3 ? c(e, r, l) : c(e, r)) || l);
  return s > 3 && l && Object.defineProperty(e, r, l), l;
};
function event(t) {
  return function(e) {
    e.prototype.event_name = t;
  };
}
class BokehEvent {
  to_json() {
    const { event_name: e } = this;
    return { event_name: e, event_values: this._to_json() };
  }
}
BokehEvent.__name__ = "BokehEvent";
class ModelEvent extends BokehEvent {
  constructor() {
    super(...arguments), this.origin = null;
  }
  _to_json() {
    return { model: this.origin };
  }
}
ModelEvent.__name__ = "ModelEvent";
let DocumentReady = class extends BokehEvent {
  _to_json() {
    return {};
  }
};
DocumentReady.__name__ = "DocumentReady";
DocumentReady = __decorate([
  event("document_ready")
], DocumentReady);
let ButtonClick = class extends ModelEvent {
};
ButtonClick.__name__ = "ButtonClick";
ButtonClick = __decorate([
  event("button_click")
], ButtonClick);
let MenuItemClick = class extends ModelEvent {
  constructor(e) {
    super(), this.item = e;
  }
  _to_json() {
    const { item: e } = this;
    return { ...super._to_json(), item: e };
  }
};
MenuItemClick.__name__ = "MenuItemClick";
MenuItemClick = __decorate([
  event("menu_item_click")
], MenuItemClick);
class UIEvent extends ModelEvent {
}
UIEvent.__name__ = "UIEvent";
let LODStart = class extends UIEvent {
};
LODStart.__name__ = "LODStart";
LODStart = __decorate([
  event("lodstart")
], LODStart);
let LODEnd = class extends UIEvent {
};
LODEnd.__name__ = "LODEnd";
LODEnd = __decorate([
  event("lodend")
], LODEnd);
let RangesUpdate = class extends UIEvent {
  constructor(e, r, o, s) {
    super(), this.x0 = e, this.x1 = r, this.y0 = o, this.y1 = s;
  }
  _to_json() {
    const { x0: e, x1: r, y0: o, y1: s } = this;
    return { ...super._to_json(), x0: e, x1: r, y0: o, y1: s };
  }
};
RangesUpdate.__name__ = "RangesUpdate";
RangesUpdate = __decorate([
  event("rangesupdate")
], RangesUpdate);
let SelectionGeometry = class extends UIEvent {
  constructor(e, r) {
    super(), this.geometry = e, this.final = r;
  }
  _to_json() {
    const { geometry: e, final: r } = this;
    return { ...super._to_json(), geometry: e, final: r };
  }
};
SelectionGeometry.__name__ = "SelectionGeometry";
SelectionGeometry = __decorate([
  event("selectiongeometry")
], SelectionGeometry);
let Reset = class extends UIEvent {
};
Reset.__name__ = "Reset";
Reset = __decorate([
  event("reset")
], Reset);
class PointEvent extends UIEvent {
  constructor(e, r, o, s) {
    super(), this.sx = e, this.sy = r, this.x = o, this.y = s;
  }
  _to_json() {
    const { sx: e, sy: r, x: o, y: s } = this;
    return { ...super._to_json(), sx: e, sy: r, x: o, y: s };
  }
}
PointEvent.__name__ = "PointEvent";
let Pan = class extends PointEvent {
  constructor(e, r, o, s, l, c) {
    super(e, r, o, s), this.delta_x = l, this.delta_y = c;
  }
  _to_json() {
    const { delta_x: e, delta_y: r } = this;
    return { ...super._to_json(), delta_x: e, delta_y: r };
  }
};
Pan.__name__ = "Pan";
Pan = __decorate([
  event("pan")
], Pan);
let Pinch = class extends PointEvent {
  constructor(e, r, o, s, l) {
    super(e, r, o, s), this.scale = l;
  }
  _to_json() {
    const { scale: e } = this;
    return { ...super._to_json(), scale: e };
  }
};
Pinch.__name__ = "Pinch";
Pinch = __decorate([
  event("pinch")
], Pinch);
let Rotate = class extends PointEvent {
  constructor(e, r, o, s, l) {
    super(e, r, o, s), this.rotation = l;
  }
  _to_json() {
    const { rotation: e } = this;
    return { ...super._to_json(), rotation: e };
  }
};
Rotate.__name__ = "Rotate";
Rotate = __decorate([
  event("rotate")
], Rotate);
let MouseWheel = class extends PointEvent {
  constructor(e, r, o, s, l) {
    super(e, r, o, s), this.delta = l;
  }
  _to_json() {
    const { delta: e } = this;
    return { ...super._to_json(), delta: e };
  }
};
MouseWheel.__name__ = "MouseWheel";
MouseWheel = __decorate([
  event("wheel")
], MouseWheel);
let MouseMove = class extends PointEvent {
};
MouseMove.__name__ = "MouseMove";
MouseMove = __decorate([
  event("mousemove")
], MouseMove);
let MouseEnter = class extends PointEvent {
};
MouseEnter.__name__ = "MouseEnter";
MouseEnter = __decorate([
  event("mouseenter")
], MouseEnter);
let MouseLeave = class extends PointEvent {
};
MouseLeave.__name__ = "MouseLeave";
MouseLeave = __decorate([
  event("mouseleave")
], MouseLeave);
let Tap = class extends PointEvent {
};
Tap.__name__ = "Tap";
Tap = __decorate([
  event("tap")
], Tap);
let DoubleTap = class extends PointEvent {
};
DoubleTap.__name__ = "DoubleTap";
DoubleTap = __decorate([
  event("doubletap")
], DoubleTap);
let Press = class extends PointEvent {
};
Press.__name__ = "Press";
Press = __decorate([
  event("press")
], Press);
let PressUp = class extends PointEvent {
};
PressUp.__name__ = "PressUp";
PressUp = __decorate([
  event("pressup")
], PressUp);
let PanStart = class extends PointEvent {
};
PanStart.__name__ = "PanStart";
PanStart = __decorate([
  event("panstart")
], PanStart);
let PanEnd = class extends PointEvent {
};
PanEnd.__name__ = "PanEnd";
PanEnd = __decorate([
  event("panend")
], PanEnd);
let PinchStart = class extends PointEvent {
};
PinchStart.__name__ = "PinchStart";
PinchStart = __decorate([
  event("pinchstart")
], PinchStart);
let PinchEnd = class extends PointEvent {
};
PinchEnd.__name__ = "PinchEnd";
PinchEnd = __decorate([
  event("pinchend")
], PinchEnd);
let RotateStart = class extends PointEvent {
};
RotateStart.__name__ = "RotateStart";
RotateStart = __decorate([
  event("rotatestart")
], RotateStart);
let RotateEnd = class extends PointEvent {
};
RotateEnd.__name__ = "RotateEnd";
RotateEnd = __decorate([
  event("rotateend")
], RotateEnd);
/*!
 * window.jQuery Mousewheel 3.1.13
 *
 * Copyright window.jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 */
function fontSize(t) {
  const e = getComputedStyle(t).fontSize;
  return e != null ? parseInt(e, 10) : null;
}
function lineHeight(t) {
  var r, o, s;
  const e = (r = t.offsetParent) != null ? r : document.body;
  return (s = (o = fontSize(e)) != null ? o : fontSize(t)) != null ? s : 16;
}
function pageHeight(t) {
  return t.clientHeight;
}
function getDeltaY(t) {
  let e = -t.deltaY;
  if (t.target instanceof HTMLElement)
    switch (t.deltaMode) {
      case t.DOM_DELTA_LINE:
        e *= lineHeight(t.target);
        break;
      case t.DOM_DELTA_PAGE:
        e *= pageHeight(t.target);
        break;
    }
  return e;
}
function is_touch(t) {
  return typeof TouchEvent < "u" && t instanceof TouchEvent;
}
class UIEventBus {
  constructor(e) {
    this.canvas_view = e, this.pan_start = new Signal(this, "pan:start"), this.pan = new Signal(this, "pan"), this.pan_end = new Signal(this, "pan:end"), this.pinch_start = new Signal(this, "pinch:start"), this.pinch = new Signal(this, "pinch"), this.pinch_end = new Signal(this, "pinch:end"), this.rotate_start = new Signal(this, "rotate:start"), this.rotate = new Signal(this, "rotate"), this.rotate_end = new Signal(this, "rotate:end"), this.tap = new Signal(this, "tap"), this.doubletap = new Signal(this, "doubletap"), this.press = new Signal(this, "press"), this.pressup = new Signal(this, "pressup"), this.move_enter = new Signal(this, "move:enter"), this.move = new Signal(this, "move"), this.move_exit = new Signal(this, "move:exit"), this.scroll = new Signal(this, "scroll"), this.keydown = new Signal(this, "keydown"), this.keyup = new Signal(this, "keyup"), this.hammer = new Hammer(this.hit_area, {
      touchAction: "auto",
      inputClass: Hammer.TouchMouseInput
    }), this._prev_move = null, this._curr_pan = null, this._curr_pinch = null, this._curr_rotate = null, this._configure_hammerjs(), this.hit_area.addEventListener("mousemove", (r) => this._mouse_move(r)), this.hit_area.addEventListener("mouseenter", (r) => this._mouse_enter(r)), this.hit_area.addEventListener("mouseleave", (r) => this._mouse_exit(r)), this.hit_area.addEventListener("contextmenu", (r) => this._context_menu(r)), this.hit_area.addEventListener("wheel", (r) => this._mouse_wheel(r)), document.addEventListener("keydown", this), document.addEventListener("keyup", this), this.menu = new ContextMenu([], {
      prevent_hide: (r) => r.button == 2 && r.target == this.hit_area
    }), this.hit_area.appendChild(this.menu.el);
  }
  get hit_area() {
    return this.canvas_view.events_el;
  }
  destroy() {
    this.menu.remove(), this.hammer.destroy(), document.removeEventListener("keydown", this), document.removeEventListener("keyup", this);
  }
  handleEvent(e) {
    e.type == "keydown" ? this._key_down(e) : e.type == "keyup" && this._key_up(e);
  }
  _configure_hammerjs() {
    this.hammer.get("doubletap").recognizeWith("tap"), this.hammer.get("tap").requireFailure("doubletap"), this.hammer.get("doubletap").dropRequireFailure("tap"), this.hammer.on("doubletap", (e) => this._doubletap(e)), this.hammer.on("tap", (e) => this._tap(e)), this.hammer.on("press", (e) => this._press(e)), this.hammer.on("pressup", (e) => this._pressup(e)), this.hammer.get("pan").set({ direction: Hammer.DIRECTION_ALL }), this.hammer.on("panstart", (e) => this._pan_start(e)), this.hammer.on("pan", (e) => this._pan(e)), this.hammer.on("panend", (e) => this._pan_end(e)), this.hammer.get("pinch").set({ enable: !0 }), this.hammer.on("pinchstart", (e) => this._pinch_start(e)), this.hammer.on("pinch", (e) => this._pinch(e)), this.hammer.on("pinchend", (e) => this._pinch_end(e)), this.hammer.get("rotate").set({ enable: !0 }), this.hammer.on("rotatestart", (e) => this._rotate_start(e)), this.hammer.on("rotate", (e) => this._rotate(e)), this.hammer.on("rotateend", (e) => this._rotate_end(e));
  }
  register_tool(e) {
    const r = e.model.event_type;
    r != null && (isString(r) ? this._register_tool(e, r) : r.forEach((o, s) => this._register_tool(e, o, s < 1)));
  }
  _register_tool(e, r, o = !0) {
    const s = e, { id: l } = s.model, c = (d) => (f) => {
      f.id == l && d(f.e);
    }, u = (d) => (f) => {
      d(f.e);
    };
    switch (r) {
      case "pan": {
        s._pan_start != null && s.connect(this.pan_start, c(s._pan_start.bind(s))), s._pan != null && s.connect(this.pan, c(s._pan.bind(s))), s._pan_end != null && s.connect(this.pan_end, c(s._pan_end.bind(s)));
        break;
      }
      case "pinch": {
        s._pinch_start != null && s.connect(this.pinch_start, c(s._pinch_start.bind(s))), s._pinch != null && s.connect(this.pinch, c(s._pinch.bind(s))), s._pinch_end != null && s.connect(this.pinch_end, c(s._pinch_end.bind(s)));
        break;
      }
      case "rotate": {
        s._rotate_start != null && s.connect(this.rotate_start, c(s._rotate_start.bind(s))), s._rotate != null && s.connect(this.rotate, c(s._rotate.bind(s))), s._rotate_end != null && s.connect(this.rotate_end, c(s._rotate_end.bind(s)));
        break;
      }
      case "move": {
        s._move_enter != null && s.connect(this.move_enter, c(s._move_enter.bind(s))), s._move != null && s.connect(this.move, c(s._move.bind(s))), s._move_exit != null && s.connect(this.move_exit, c(s._move_exit.bind(s)));
        break;
      }
      case "tap": {
        s._tap != null && s.connect(this.tap, c(s._tap.bind(s))), s._doubletap != null && s.connect(this.doubletap, c(s._doubletap.bind(s)));
        break;
      }
      case "press": {
        s._press != null && s.connect(this.press, c(s._press.bind(s))), s._pressup != null && s.connect(this.pressup, c(s._pressup.bind(s)));
        break;
      }
      case "scroll": {
        s._scroll != null && s.connect(this.scroll, c(s._scroll.bind(s)));
        break;
      }
      default:
        throw new Error(`unsupported event_type: ${r}`);
    }
    !o || (s._keydown != null && s.connect(this.keydown, u(s._keydown.bind(s))), s._keyup != null && s.connect(this.keyup, u(s._keyup.bind(s))), is_mobile && s._scroll != null && r == "pinch" && (logger.debug("Registering scroll on touch screen"), s.connect(this.scroll, c(s._scroll.bind(s)))));
  }
  _hit_test_renderers(e, r, o) {
    var l;
    const s = e.get_renderer_views();
    for (const c of reversed(s))
      if ((l = c.interactive_hit) != null && l.call(c, r, o))
        return c;
    return null;
  }
  set_cursor(e = "default") {
    this.hit_area.style.cursor = e;
  }
  _hit_test_frame(e, r, o) {
    return e.frame.bbox.contains(r, o);
  }
  _hit_test_canvas(e, r, o) {
    return e.layout.bbox.contains(r, o);
  }
  _hit_test_plot(e, r) {
    for (const o of this.canvas_view.plot_views)
      if (o.layout.bbox.relative().contains(e, r))
        return o;
    return null;
  }
  _trigger(e, r, o) {
    var f;
    const { sx: s, sy: l } = r, u = this._hit_test_plot(s, l), d = (T) => {
      const [Q, m] = [s, l];
      return { ...r, sx: Q, sy: m };
    };
    if (r.type == "panstart" || r.type == "pan" || r.type == "panend") {
      let T;
      if (r.type == "panstart" && u != null ? (this._curr_pan = { plot_view: u }, T = u) : r.type == "pan" && this._curr_pan != null ? T = this._curr_pan.plot_view : r.type == "panend" && this._curr_pan != null ? (T = this._curr_pan.plot_view, this._curr_pan = null) : T = null, T != null) {
        const Q = d();
        this.__trigger(T, e, Q, o);
      }
    } else if (r.type == "pinchstart" || r.type == "pinch" || r.type == "pinchend") {
      let T;
      if (r.type == "pinchstart" && u != null ? (this._curr_pinch = { plot_view: u }, T = u) : r.type == "pinch" && this._curr_pinch != null ? T = this._curr_pinch.plot_view : r.type == "pinchend" && this._curr_pinch != null ? (T = this._curr_pinch.plot_view, this._curr_pinch = null) : T = null, T != null) {
        const Q = d();
        this.__trigger(T, e, Q, o);
      }
    } else if (r.type == "rotatestart" || r.type == "rotate" || r.type == "rotateend") {
      let T;
      if (r.type == "rotatestart" && u != null ? (this._curr_rotate = { plot_view: u }, T = u) : r.type == "rotate" && this._curr_rotate != null ? T = this._curr_rotate.plot_view : r.type == "rotateend" && this._curr_rotate != null ? (T = this._curr_rotate.plot_view, this._curr_rotate = null) : T = null, T != null) {
        const Q = d();
        this.__trigger(T, e, Q, o);
      }
    } else if (r.type == "mouseenter" || r.type == "mousemove" || r.type == "mouseleave") {
      const T = (f = this._prev_move) == null ? void 0 : f.plot_view;
      if (T != null && (r.type == "mouseleave" || T != u)) {
        const { sx: Q, sy: m } = d();
        this.__trigger(T, this.move_exit, { type: "mouseleave", sx: Q, sy: m, shiftKey: !1, ctrlKey: !1 }, o);
      }
      if (u != null && (r.type == "mouseenter" || T != u)) {
        const { sx: Q, sy: m } = d();
        this.__trigger(u, this.move_enter, { type: "mouseenter", sx: Q, sy: m, shiftKey: !1, ctrlKey: !1 }, o);
      }
      if (u != null && r.type == "mousemove") {
        const Q = d();
        this.__trigger(u, e, Q, o);
      }
      this._prev_move = { sx: s, sy: l, plot_view: u };
    } else if (u != null) {
      const T = d();
      this.__trigger(u, e, T, o);
    }
  }
  __trigger(e, r, o, s) {
    var T, Q, m;
    const l = e.model.toolbar.gestures, u = r.name.split(":")[0], d = this._hit_test_renderers(e, o.sx, o.sy), f = this._hit_test_canvas(e, o.sx, o.sy);
    switch (u) {
      case "move": {
        const g = l.move.active;
        g != null && this.trigger(r, o, g.id);
        const v = e.model.toolbar.inspectors.filter((L) => L.active);
        let b = "default";
        d != null ? (b = (T = d.cursor(o.sx, o.sy)) != null ? T : b, is_empty$1(v) || (r = this.move_exit)) : this._hit_test_frame(e, o.sx, o.sy) && (is_empty$1(v) || (b = "crosshair")), this.set_cursor(b), e.set_toolbar_visibility(f), v.map((L) => this.trigger(r, o, L.id));
        break;
      }
      case "tap": {
        const { target: g } = s;
        if (g != null && g != this.hit_area)
          return;
        if ((Q = d == null ? void 0 : d.on_hit) == null || Q.call(d, o.sx, o.sy), this._hit_test_frame(e, o.sx, o.sy)) {
          const v = l.tap.active;
          v != null && this.trigger(r, o, v.id);
        }
        break;
      }
      case "doubletap": {
        if (this._hit_test_frame(e, o.sx, o.sy)) {
          const g = (m = l.doubletap.active) != null ? m : l.tap.active;
          g != null && this.trigger(r, o, g.id);
        }
        break;
      }
      case "scroll": {
        const v = l[is_mobile ? "pinch" : "scroll"].active;
        v != null && (s.preventDefault(), s.stopPropagation(), this.trigger(r, o, v.id));
        break;
      }
      case "pan": {
        const g = l.pan.active;
        g != null && (s.preventDefault(), this.trigger(r, o, g.id));
        break;
      }
      default: {
        const g = l[u].active;
        g != null && this.trigger(r, o, g.id);
      }
    }
    this._trigger_bokeh_event(e, o);
  }
  trigger(e, r, o = null) {
    e.emit({ id: o, e: r });
  }
  _trigger_bokeh_event(e, r) {
    const o = (() => {
      const { sx: s, sy: l } = r, c = e.frame.x_scale.invert(s), u = e.frame.y_scale.invert(l);
      switch (r.type) {
        case "wheel":
          return new MouseWheel(s, l, c, u, r.delta);
        case "mousemove":
          return new MouseMove(s, l, c, u);
        case "mouseenter":
          return new MouseEnter(s, l, c, u);
        case "mouseleave":
          return new MouseLeave(s, l, c, u);
        case "tap":
          return new Tap(s, l, c, u);
        case "doubletap":
          return new DoubleTap(s, l, c, u);
        case "press":
          return new Press(s, l, c, u);
        case "pressup":
          return new PressUp(s, l, c, u);
        case "pan":
          return new Pan(s, l, c, u, r.deltaX, r.deltaY);
        case "panstart":
          return new PanStart(s, l, c, u);
        case "panend":
          return new PanEnd(s, l, c, u);
        case "pinch":
          return new Pinch(s, l, c, u, r.scale);
        case "pinchstart":
          return new PinchStart(s, l, c, u);
        case "pinchend":
          return new PinchEnd(s, l, c, u);
        case "rotate":
          return new Rotate(s, l, c, u, r.rotation);
        case "rotatestart":
          return new RotateStart(s, l, c, u);
        case "rotateend":
          return new RotateEnd(s, l, c, u);
        default:
          return;
      }
    })();
    o != null && e.model.trigger_event(o);
  }
  _get_sxy(e) {
    const { pageX: r, pageY: o } = is_touch(e) ? (e.touches.length != 0 ? e.touches : e.changedTouches)[0] : e, { left: s, top: l } = offset(this.hit_area);
    return {
      sx: r - s,
      sy: o - l
    };
  }
  _pan_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e.srcEvent),
      deltaX: e.deltaX,
      deltaY: e.deltaY,
      shiftKey: e.srcEvent.shiftKey,
      ctrlKey: e.srcEvent.ctrlKey
    };
  }
  _pinch_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e.srcEvent),
      scale: e.scale,
      shiftKey: e.srcEvent.shiftKey,
      ctrlKey: e.srcEvent.ctrlKey
    };
  }
  _rotate_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e.srcEvent),
      rotation: e.rotation,
      shiftKey: e.srcEvent.shiftKey,
      ctrlKey: e.srcEvent.ctrlKey
    };
  }
  _tap_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e.srcEvent),
      shiftKey: e.srcEvent.shiftKey,
      ctrlKey: e.srcEvent.ctrlKey
    };
  }
  _move_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e),
      shiftKey: e.shiftKey,
      ctrlKey: e.ctrlKey
    };
  }
  _scroll_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e),
      delta: getDeltaY(e),
      shiftKey: e.shiftKey,
      ctrlKey: e.ctrlKey
    };
  }
  _key_event(e) {
    return {
      type: e.type,
      keyCode: e.keyCode
    };
  }
  _pan_start(e) {
    const r = this._pan_event(e);
    r.sx -= e.deltaX, r.sy -= e.deltaY, this._trigger(this.pan_start, r, e.srcEvent);
  }
  _pan(e) {
    this._trigger(this.pan, this._pan_event(e), e.srcEvent);
  }
  _pan_end(e) {
    this._trigger(this.pan_end, this._pan_event(e), e.srcEvent);
  }
  _pinch_start(e) {
    this._trigger(this.pinch_start, this._pinch_event(e), e.srcEvent);
  }
  _pinch(e) {
    this._trigger(this.pinch, this._pinch_event(e), e.srcEvent);
  }
  _pinch_end(e) {
    this._trigger(this.pinch_end, this._pinch_event(e), e.srcEvent);
  }
  _rotate_start(e) {
    this._trigger(this.rotate_start, this._rotate_event(e), e.srcEvent);
  }
  _rotate(e) {
    this._trigger(this.rotate, this._rotate_event(e), e.srcEvent);
  }
  _rotate_end(e) {
    this._trigger(this.rotate_end, this._rotate_event(e), e.srcEvent);
  }
  _tap(e) {
    this._trigger(this.tap, this._tap_event(e), e.srcEvent);
  }
  _doubletap(e) {
    this._trigger(this.doubletap, this._tap_event(e), e.srcEvent);
  }
  _press(e) {
    this._trigger(this.press, this._tap_event(e), e.srcEvent);
  }
  _pressup(e) {
    this._trigger(this.pressup, this._tap_event(e), e.srcEvent);
  }
  _mouse_enter(e) {
    this._trigger(this.move_enter, this._move_event(e), e);
  }
  _mouse_move(e) {
    this._trigger(this.move, this._move_event(e), e);
  }
  _mouse_exit(e) {
    this._trigger(this.move_exit, this._move_event(e), e);
  }
  _mouse_wheel(e) {
    this._trigger(this.scroll, this._scroll_event(e), e);
  }
  _context_menu(e) {
    !this.menu.is_open && this.menu.can_open && e.preventDefault();
    const { sx: r, sy: o } = this._get_sxy(e);
    this.menu.toggle({ left: r, top: o });
  }
  _key_down(e) {
    this.trigger(this.keydown, this._key_event(e));
  }
  _key_up(e) {
    this.trigger(this.keyup, this._key_event(e));
  }
}
UIEventBus.__name__ = "UIEventBus";
var _a$2v;
async function init_webgl() {
  const t = document.createElement("canvas"), e = t.getContext("webgl", { premultipliedAlpha: !0 });
  if (e != null) {
    const r = await load_module(import("./index.8cec7c0b.es.js"));
    if (r != null) {
      const o = r.get_regl(e);
      if (o.has_webgl)
        return { canvas: t, regl_wrapper: o };
      logger.trace("WebGL is supported, but not the required extensions");
    } else
      logger.trace("WebGL is supported, but bokehjs(.min).js bundle is not available");
  } else
    logger.trace("WebGL is not supported");
  return null;
}
const global_webgl = (() => {
  let t;
  return async () => t !== void 0 ? t : t = await init_webgl();
})(), style = {
  position: "absolute",
  top: "0",
  left: "0",
  width: "100%",
  height: "100%"
};
class CanvasView extends DOMView {
  constructor() {
    super(...arguments), this.bbox = new BBox$2(), this.webgl = null;
  }
  initialize() {
    super.initialize(), this.underlays_el = div({ style }), this.primary = this.create_layer(), this.overlays = this.create_layer(), this.overlays_el = div({ style }), this.events_el = div({ class: "bk-canvas-events", style });
    const e = [
      this.underlays_el,
      this.primary.el,
      this.overlays.el,
      this.overlays_el,
      this.events_el
    ];
    extend$1(this.el.style, style), append(this.el, ...e), this.ui_event_bus = new UIEventBus(this);
  }
  async lazy_initialize() {
    if (await super.lazy_initialize(), this.model.output_backend == "webgl" && (this.webgl = await global_webgl(), settings.force_webgl && this.webgl == null))
      throw new Error("webgl is not available");
  }
  remove() {
    this.ui_event_bus.destroy(), super.remove();
  }
  add_underlay(e) {
    this.underlays_el.appendChild(e);
  }
  add_overlay(e) {
    this.overlays_el.appendChild(e);
  }
  add_event(e) {
    this.events_el.appendChild(e);
  }
  get pixel_ratio() {
    return this.primary.pixel_ratio;
  }
  resize(e, r) {
    this.bbox = new BBox$2({ left: 0, top: 0, width: e, height: r }), this.primary.resize(e, r), this.overlays.resize(e, r);
  }
  prepare_webgl(e) {
    const { webgl: r } = this;
    if (r != null) {
      const { width: o, height: s } = this.bbox;
      r.canvas.width = this.pixel_ratio * o, r.canvas.height = this.pixel_ratio * s;
      const [l, c, u, d] = e, { xview: f, yview: T } = this.bbox, Q = f.compute(l), m = T.compute(c + d), g = this.pixel_ratio;
      r.regl_wrapper.set_scissor(g * Q, g * m, g * u, g * d), this._clear_webgl();
    }
  }
  blit_webgl(e) {
    const { webgl: r } = this;
    if (r != null) {
      if (logger.debug("Blitting WebGL canvas"), e.restore(), e.drawImage(r.canvas, 0, 0), e.save(), this.model.hidpi) {
        const o = this.pixel_ratio;
        e.scale(o, o), e.translate(0.5, 0.5);
      }
      this._clear_webgl();
    }
  }
  _clear_webgl() {
    const { webgl: e } = this;
    if (e != null) {
      const { regl_wrapper: r, canvas: o } = e;
      r.clear(o.width, o.height);
    }
  }
  compose() {
    const e = this.create_layer(), { width: r, height: o } = this.bbox;
    return e.resize(r, o), e.ctx.drawImage(this.primary.canvas, 0, 0), e.ctx.drawImage(this.overlays.canvas, 0, 0), e;
  }
  create_layer() {
    const { output_backend: e, hidpi: r } = this.model;
    return new CanvasLayer(e, r);
  }
  to_blob() {
    return this.compose().to_blob();
  }
}
CanvasView.__name__ = "CanvasView";
class Canvas extends HasProps {
  constructor(e) {
    super(e);
  }
}
_a$2v = Canvas;
Canvas.__name__ = "Canvas";
_a$2v.prototype.default_view = CanvasView, _a$2v.internal(({ Boolean: t }) => ({
  hidpi: [t, !0],
  output_backend: [OutputBackend, "canvas"]
}));
class Expression extends Model {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this._result = /* @__PURE__ */ new Map();
  }
  v_compute(e) {
    let r = this._result.get(e);
    return (r === void 0 || e.changed_for(this)) && (r = this._v_compute(e), this._result.set(e, r)), r;
  }
}
Expression.__name__ = "Expression";
class ScalarExpression extends Model {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this._result = /* @__PURE__ */ new Map();
  }
  compute(e) {
    let r = this._result.get(e);
    return (r === void 0 || e.changed_for(this)) && (r = this._compute(e), this._result.set(e, r)), r;
  }
}
ScalarExpression.__name__ = "ScalarExpression";
var _a$2u;
class CustomJSExpr extends Expression {
  constructor(e) {
    super(e);
  }
  connect_signals() {
    super.connect_signals();
    for (const e of values(this.args))
      e instanceof HasProps && e.change.connect(() => {
        this._result.clear(), this.change.emit();
      });
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  get func() {
    const e = use_strict(this.code);
    return new GeneratorFunction(...this.names, e);
  }
  _v_compute(e) {
    const r = this.func.apply(e, this.values);
    let o = r.next();
    if (o.done && o.value !== void 0) {
      const { value: s } = o;
      return isArray(s) || isTypedArray(s) ? s : isIterable(s) ? [...s] : repeat(s, e.length);
    } else {
      const s = [];
      do
        s.push(o.value), o = r.next();
      while (!o.done);
      return s;
    }
  }
}
_a$2u = CustomJSExpr;
CustomJSExpr.__name__ = "CustomJSExpr";
_a$2u.define(({ Unknown: t, String: e, Dict: r }) => ({
  args: [r(t), {}],
  code: [e, ""]
}));
var _a$2t;
class Stack$2 extends Expression {
  constructor(e) {
    super(e);
  }
  _v_compute(e) {
    var s;
    const r = (s = e.get_length()) != null ? s : 0, o = new Float64Array(r);
    for (const l of this.fields) {
      const c = e.data[l];
      if (c != null) {
        const u = Math.min(r, c.length);
        for (let d = 0; d < u; d++)
          o[d] += c[d];
      }
    }
    return o;
  }
}
_a$2t = Stack$2;
Stack$2.__name__ = "Stack";
_a$2t.define(({ String: t, Array: e }) => ({
  fields: [e(t), []]
}));
var _a$2s;
class CumSum extends Expression {
  constructor(e) {
    super(e);
  }
  _v_compute(e) {
    var l;
    const r = new Float64Array((l = e.get_length()) != null ? l : 0), o = e.data[this.field], s = this.include_zero ? 1 : 0;
    r[0] = this.include_zero ? 0 : o[0];
    for (let c = 1; c < r.length; c++)
      r[c] = r[c - 1] + o[c - s];
    return r;
  }
}
_a$2s = CumSum;
CumSum.__name__ = "CumSum";
_a$2s.define(({ Boolean: t, String: e }) => ({
  field: [e],
  include_zero: [t, !1]
}));
var _a$2r;
class Minimum extends ScalarExpression {
  constructor(e) {
    super(e);
  }
  _compute(e) {
    var o, s;
    const r = (o = e.data[this.field]) != null ? o : [];
    return Math.min((s = this.initial) != null ? s : 1 / 0, min$6(r));
  }
}
_a$2r = Minimum;
Minimum.__name__ = "Minimum";
_a$2r.define(({ Number: t, String: e, Nullable: r }) => ({
  field: [e],
  initial: [r(t), null]
}));
var _a$2q;
class Maximum extends ScalarExpression {
  constructor(e) {
    super(e);
  }
  _compute(e) {
    var o, s;
    const r = (o = e.data[this.field]) != null ? o : [];
    return Math.max((s = this.initial) != null ? s : -1 / 0, max$8(r));
  }
}
_a$2q = Maximum;
Maximum.__name__ = "Maximum";
_a$2q.define(({ Number: t, String: e, Nullable: r }) => ({
  field: [e],
  initial: [r(t), null]
}));
var _a$2p;
class CoordinateTransform extends Expression {
  constructor(e) {
    super(e);
  }
  get x() {
    return new XComponent({ transform: this });
  }
  get y() {
    return new YComponent({ transform: this });
  }
}
CoordinateTransform.__name__ = "CoordinateTransform";
class XYComponent extends Expression {
  constructor(e) {
    super(e);
  }
}
_a$2p = XYComponent;
XYComponent.__name__ = "XYComponent";
_a$2p.define(({ Ref: t }) => ({
  transform: [t(CoordinateTransform)]
}));
class XComponent extends XYComponent {
  constructor(e) {
    super(e);
  }
  _v_compute(e) {
    return this.transform.v_compute(e).x;
  }
}
XComponent.__name__ = "XComponent";
class YComponent extends XYComponent {
  constructor(e) {
    super(e);
  }
  _v_compute(e) {
    return this.transform.v_compute(e).y;
  }
}
YComponent.__name__ = "YComponent";
var _a$2o;
class PolarTransform extends CoordinateTransform {
  constructor(e) {
    super(e);
  }
  _v_compute(e) {
    const r = this.properties.radius.uniform(e), o = this.properties.angle.uniform(e), s = this.direction == "anticlock" ? -1 : 1, l = Math.min(r.length, o.length), c = new Float64Array(l), u = new Float64Array(l);
    for (let d = 0; d < l; d++) {
      const f = r.get(d), T = o.get(d) * s;
      c[d] = f * Math.cos(T), u[d] = f * Math.sin(T);
    }
    return { x: c, y: u };
  }
}
_a$2o = PolarTransform;
PolarTransform.__name__ = "PolarTransform";
_a$2o.define(({}) => ({
  radius: [DistanceSpec, { field: "radius" }],
  angle: [AngleSpec, { field: "angle" }],
  direction: [Direction$1, "anticlock"]
}));
var _a$2n;
class BooleanFilter extends Filter {
  constructor(e) {
    super(e);
  }
  compute_indices(e) {
    const r = e.length, { booleans: o } = this;
    return o == null ? BitSet.all_set(r) : BitSet.from_booleans(r, o);
  }
}
_a$2n = BooleanFilter;
BooleanFilter.__name__ = "BooleanFilter";
_a$2n.define(({ Boolean: t, Array: e, Nullable: r }) => ({
  booleans: [r(e(t)), null]
}));
var _a$2m;
class CustomJSFilter extends Filter {
  constructor(e) {
    super(e);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  get func() {
    const e = use_strict(this.code);
    return new Function(...this.names, "source", e);
  }
  compute_indices(e) {
    const r = e.length, o = this.func(...this.values, e);
    if (o == null)
      return BitSet.all_set(r);
    if (isArrayOf(o, isInteger))
      return BitSet.from_indices(r, o);
    if (isArrayOf(o, isBoolean))
      return BitSet.from_booleans(r, o);
    throw new Error(`expect an array of integers or booleans, or null, got ${o}`);
  }
}
_a$2m = CustomJSFilter;
CustomJSFilter.__name__ = "CustomJSFilter";
_a$2m.define(({ Unknown: t, String: e, Dict: r }) => ({
  args: [r(t), {}],
  code: [e, ""]
}));
var _a$2l;
class GroupFilter extends Filter {
  constructor(e) {
    super(e);
  }
  compute_indices(e) {
    const r = e.get_column(this.column_name);
    if (r == null)
      return logger.warn(`${this}: groupby column '${this.column_name}' not found in the data source`), new BitSet(e.length, 1);
    {
      const o = new BitSet(e.length);
      for (let s = 0; s < o.size; s++)
        r[s] === this.group && o.set(s);
      return o;
    }
  }
}
_a$2l = GroupFilter;
GroupFilter.__name__ = "GroupFilter";
_a$2l.define(({ String: t }) => ({
  column_name: [t],
  group: [t]
}));
var _a$2k;
class IndexFilter extends Filter {
  constructor(e) {
    super(e);
  }
  compute_indices(e) {
    const r = e.length, { indices: o } = this;
    return o == null ? BitSet.all_set(r) : BitSet.from_indices(r, o);
  }
}
_a$2k = IndexFilter;
IndexFilter.__name__ = "IndexFilter";
_a$2k.define(({ Int: t, Array: e, Nullable: r }) => ({
  indices: [r(e(t)), null]
}));
var _a$2j;
class AnnularWedgeView extends XYGlyphView {
  _map_data() {
    this.model.properties.inner_radius.units == "data" ? this.sinner_radius = this.sdist(this.renderer.xscale, this._x, this.inner_radius) : this.sinner_radius = to_screen(this.inner_radius), this.model.properties.outer_radius.units == "data" ? this.souter_radius = this.sdist(this.renderer.xscale, this._x, this.outer_radius) : this.souter_radius = to_screen(this.outer_radius), this.max_souter_radius = max$8(this.souter_radius);
  }
  _render(e, r, o) {
    const { sx: s, sy: l, start_angle: c, end_angle: u, sinner_radius: d, souter_radius: f } = o != null ? o : this, T = this.model.direction == "anticlock";
    for (const Q of r) {
      const m = s[Q], g = l[Q], v = d[Q], b = f[Q], L = c.get(Q), A = u.get(Q);
      if (!isFinite(m + g + v + b + L + A))
        continue;
      const M = A - L;
      e.translate(m, g), e.rotate(L), e.beginPath(), e.moveTo(b, 0), e.arc(0, 0, b, 0, M, T), e.rotate(M), e.lineTo(v, 0), e.arc(0, 0, v, 0, -M, !T), e.closePath(), e.rotate(-M - L), e.translate(-m, -g), this.visuals.fill.apply(e, Q), this.visuals.hatch.apply(e, Q), this.visuals.line.apply(e, Q);
    }
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = this.renderer.xscale.invert(r), l = this.renderer.yscale.invert(o), c = r - this.max_souter_radius, u = r + this.max_souter_radius, [d, f] = this.renderer.xscale.r_invert(c, u), T = o - this.max_souter_radius, Q = o + this.max_souter_radius, [m, g] = this.renderer.yscale.r_invert(T, Q), v = [];
    for (const A of this.index.indices({ x0: d, x1: f, y0: m, y1: g })) {
      const M = this.souter_radius[A] ** 2, S = this.sinner_radius[A] ** 2, [E, k] = this.renderer.xscale.r_compute(s, this._x[A]), [w, O] = this.renderer.yscale.r_compute(l, this._y[A]), D = (E - k) ** 2 + (w - O) ** 2;
      D <= M && D >= S && v.push(A);
    }
    const b = this.model.direction == "anticlock", L = [];
    for (const A of v) {
      const M = Math.atan2(o - this.sy[A], r - this.sx[A]);
      angle_between(-M, -this.start_angle.get(A), -this.end_angle.get(A), b) && L.push(A);
    }
    return new Selection({ indices: L });
  }
  draw_legend_for_index(e, r, o) {
    generic_area_vector_legend(this.visuals, e, r, o);
  }
  scenterxy(e) {
    const r = (this.sinner_radius[e] + this.souter_radius[e]) / 2, o = (this.start_angle.get(e) + this.end_angle.get(e)) / 2, s = this.sx[e] + r * Math.cos(o), l = this.sy[e] + r * Math.sin(o);
    return [s, l];
  }
}
AnnularWedgeView.__name__ = "AnnularWedgeView";
class AnnularWedge extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$2j = AnnularWedge;
AnnularWedge.__name__ = "AnnularWedge";
_a$2j.prototype.default_view = AnnularWedgeView, _a$2j.mixins([LineVector$1, FillVector$1, HatchVector$1]), _a$2j.define(({}) => ({
  direction: [Direction$1, "anticlock"],
  inner_radius: [DistanceSpec, { field: "inner_radius" }],
  outer_radius: [DistanceSpec, { field: "outer_radius" }],
  start_angle: [AngleSpec, { field: "start_angle" }],
  end_angle: [AngleSpec, { field: "end_angle" }]
}));
var _a$2i;
class AnnulusView extends XYGlyphView {
  _map_data() {
    this.model.properties.inner_radius.units == "data" ? this.sinner_radius = this.sdist(this.renderer.xscale, this._x, this.inner_radius) : this.sinner_radius = to_screen(this.inner_radius), this.model.properties.outer_radius.units == "data" ? this.souter_radius = this.sdist(this.renderer.xscale, this._x, this.outer_radius) : this.souter_radius = to_screen(this.outer_radius);
  }
  _render(e, r, o) {
    const { sx: s, sy: l, sinner_radius: c, souter_radius: u } = o != null ? o : this;
    for (const d of r) {
      const f = s[d], T = l[d], Q = c[d], m = u[d];
      if (!!isFinite(f + T + Q + m)) {
        if (e.beginPath(), is_ie)
          for (const g of [!1, !0])
            e.moveTo(f, T), e.arc(f, T, Q, 0, Math.PI, g), e.moveTo(f + m, T), e.arc(f, T, m, Math.PI, 0, !g);
        else
          e.arc(f, T, Q, 0, 2 * Math.PI, !0), e.moveTo(f + m, T), e.arc(f, T, m, 2 * Math.PI, 0, !1);
        this.visuals.fill.apply(e, d), this.visuals.hatch.apply(e, d), this.visuals.line.apply(e, d);
      }
    }
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = this.renderer.xscale.invert(r), l = this.renderer.yscale.invert(o);
    let c, u, d, f;
    if (this.model.properties.outer_radius.units == "data")
      c = s - this.max_outer_radius, d = s + this.max_outer_radius, u = l - this.max_outer_radius, f = l + this.max_outer_radius;
    else {
      const Q = r - this.max_outer_radius, m = r + this.max_outer_radius;
      [c, d] = this.renderer.xscale.r_invert(Q, m);
      const g = o - this.max_outer_radius, v = o + this.max_outer_radius;
      [u, f] = this.renderer.yscale.r_invert(g, v);
    }
    const T = [];
    for (const Q of this.index.indices({ x0: c, x1: d, y0: u, y1: f })) {
      const m = this.souter_radius[Q] ** 2, g = this.sinner_radius[Q] ** 2, [v, b] = this.renderer.xscale.r_compute(s, this._x[Q]), [L, A] = this.renderer.yscale.r_compute(l, this._y[Q]), M = (v - b) ** 2 + (L - A) ** 2;
      M <= m && M >= g && T.push(Q);
    }
    return new Selection({ indices: T });
  }
  draw_legend_for_index(e, { x0: r, y0: o, x1: s, y1: l }, c) {
    const u = c + 1, d = new Array(u);
    d[c] = (r + s) / 2;
    const f = new Array(u);
    f[c] = (o + l) / 2;
    const T = Math.min(Math.abs(s - r), Math.abs(l - o)) * 0.5, Q = new Array(u);
    Q[c] = T * 0.4;
    const m = new Array(u);
    m[c] = T * 0.8, this._render(e, [c], { sx: d, sy: f, sinner_radius: Q, souter_radius: m });
  }
}
AnnulusView.__name__ = "AnnulusView";
class Annulus extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$2i = Annulus;
Annulus.__name__ = "Annulus";
_a$2i.prototype.default_view = AnnulusView, _a$2i.mixins([LineVector$1, FillVector$1, HatchVector$1]), _a$2i.define(({}) => ({
  inner_radius: [DistanceSpec, { field: "inner_radius" }],
  outer_radius: [DistanceSpec, { field: "outer_radius" }]
}));
var _a$2h;
class ArcView extends XYGlyphView {
  _map_data() {
    this.model.properties.radius.units == "data" ? this.sradius = this.sdist(this.renderer.xscale, this._x, this.radius) : this.sradius = to_screen(this.radius);
  }
  _render(e, r, o) {
    if (this.visuals.line.doit) {
      const { sx: s, sy: l, sradius: c, start_angle: u, end_angle: d } = o != null ? o : this, f = this.model.direction == "anticlock";
      for (const T of r) {
        const Q = s[T], m = l[T], g = c[T], v = u.get(T), b = d.get(T);
        !isFinite(Q + m + g + v + b) || (e.beginPath(), e.arc(Q, m, g, v, b, f), this.visuals.line.set_vectorize(e, T), e.stroke());
      }
    }
  }
  draw_legend_for_index(e, r, o) {
    generic_line_vector_legend(this.visuals, e, r, o);
  }
}
ArcView.__name__ = "ArcView";
class Arc extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$2h = Arc;
Arc.__name__ = "Arc";
_a$2h.prototype.default_view = ArcView, _a$2h.mixins(LineVector$1), _a$2h.define(({}) => ({
  direction: [Direction$1, "anticlock"],
  radius: [DistanceSpec, { field: "radius" }],
  start_angle: [AngleSpec, { field: "start_angle" }],
  end_angle: [AngleSpec, { field: "end_angle" }]
}));
var _a$2g;
function _cbb(t, e, r, o, s, l, c, u) {
  const d = [], f = [[], []];
  for (let m = 0; m <= 2; m++) {
    let g, v, b;
    if (m === 0 ? (v = 6 * t - 12 * r + 6 * s, g = -3 * t + 9 * r - 9 * s + 3 * c, b = 3 * r - 3 * t) : (v = 6 * e - 12 * o + 6 * l, g = -3 * e + 9 * o - 9 * l + 3 * u, b = 3 * o - 3 * e), Math.abs(g) < 1e-12) {
      if (Math.abs(v) < 1e-12)
        continue;
      const E = -b / v;
      0 < E && E < 1 && d.push(E);
      continue;
    }
    const L = v * v - 4 * b * g, A = Math.sqrt(L);
    if (L < 0)
      continue;
    const M = (-v + A) / (2 * g);
    0 < M && M < 1 && d.push(M);
    const S = (-v - A) / (2 * g);
    0 < S && S < 1 && d.push(S);
  }
  let T = d.length;
  const Q = T;
  for (; T--; ) {
    const m = d[T], g = 1 - m, v = g * g * g * t + 3 * g * g * m * r + 3 * g * m * m * s + m * m * m * c;
    f[0][T] = v;
    const b = g * g * g * e + 3 * g * g * m * o + 3 * g * m * m * l + m * m * m * u;
    f[1][T] = b;
  }
  return f[0][Q] = t, f[1][Q] = e, f[0][Q + 1] = c, f[1][Q + 1] = u, [
    Math.min(...f[0]),
    Math.max(...f[1]),
    Math.max(...f[0]),
    Math.min(...f[1])
  ];
}
class BezierView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._x0, this._y0), inplace.project_xy(this._x1, this._y1);
  }
  _index_data(e) {
    const { data_size: r, _x0: o, _y0: s, _x1: l, _y1: c, _cx0: u, _cy0: d, _cx1: f, _cy1: T } = this;
    for (let Q = 0; Q < r; Q++) {
      const m = o[Q], g = s[Q], v = l[Q], b = c[Q], L = u[Q], A = d[Q], M = f[Q], S = T[Q];
      if (!isFinite(m + v + g + b + L + A + M + S))
        e.add_empty();
      else {
        const [E, k, w, O] = _cbb(m, g, v, b, L, A, M, S);
        e.add_rect(E, k, w, O);
      }
    }
  }
  _render(e, r, o) {
    if (this.visuals.line.doit) {
      const { sx0: s, sy0: l, sx1: c, sy1: u, scx0: d, scy0: f, scx1: T, scy1: Q } = o != null ? o : this;
      for (const m of r) {
        const g = s[m], v = l[m], b = c[m], L = u[m], A = d[m], M = f[m], S = T[m], E = Q[m];
        !isFinite(g + v + b + L + A + M + S + E) || (e.beginPath(), e.moveTo(g, v), e.bezierCurveTo(A, M, S, E, b, L), this.visuals.line.set_vectorize(e, m), e.stroke());
      }
    }
  }
  draw_legend_for_index(e, r, o) {
    generic_line_vector_legend(this.visuals, e, r, o);
  }
  scenterxy() {
    throw new Error(`${this}.scenterxy() is not implemented`);
  }
}
BezierView.__name__ = "BezierView";
class Bezier extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$2g = Bezier;
Bezier.__name__ = "Bezier";
_a$2g.prototype.default_view = BezierView, _a$2g.define(({}) => ({
  x0: [XCoordinateSpec, { field: "x0" }],
  y0: [YCoordinateSpec, { field: "y0" }],
  x1: [XCoordinateSpec, { field: "x1" }],
  y1: [YCoordinateSpec, { field: "y1" }],
  cx0: [XCoordinateSpec, { field: "cx0" }],
  cy0: [YCoordinateSpec, { field: "cy0" }],
  cx1: [XCoordinateSpec, { field: "cx1" }],
  cy1: [YCoordinateSpec, { field: "cy1" }]
})), _a$2g.mixins(LineVector$1);
var _a$2f;
class CircleView extends XYGlyphView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl: e } = this.renderer.plot_view.canvas_view;
    if (e != null && e.regl_wrapper.has_webgl) {
      const { CircleGL: r } = await Promise.resolve().then(() => circle);
      this.glglyph = new r(e.regl_wrapper, this);
    }
  }
  get use_radius() {
    return !(this.radius.is_Scalar() && isNaN(this.radius.value));
  }
  _set_data(e) {
    super._set_data(e);
    const r = (() => {
      if (this.use_radius)
        return 2 * this.max_radius;
      {
        const { size: o } = this;
        return o.is_Scalar() ? o.value : max$8(o.array);
      }
    })();
    this._configure("max_size", { value: r });
  }
  _map_data() {
    if (this.use_radius)
      if (this.model.properties.radius.units == "data")
        switch (this.model.radius_dimension) {
          case "x": {
            this.sradius = this.sdist(this.renderer.xscale, this._x, this.radius);
            break;
          }
          case "y": {
            this.sradius = this.sdist(this.renderer.yscale, this._y, this.radius);
            break;
          }
          case "max": {
            const e = this.sdist(this.renderer.xscale, this._x, this.radius), r = this.sdist(this.renderer.yscale, this._y, this.radius);
            this.sradius = map(e, (o, s) => Math.max(o, r[s]));
            break;
          }
          case "min": {
            const e = this.sdist(this.renderer.xscale, this._x, this.radius), r = this.sdist(this.renderer.yscale, this._y, this.radius);
            this.sradius = map(e, (o, s) => Math.min(o, r[s]));
            break;
          }
        }
      else
        this.sradius = to_screen(this.radius);
    else {
      const e = ScreenArray.from(this.size);
      this.sradius = map(e, (r) => r / 2);
    }
  }
  _mask_data() {
    const { frame: e } = this.renderer.plot_view, r = e.x_target, o = e.y_target;
    let s, l;
    return this.use_radius && this.model.properties.radius.units == "data" ? (s = r.map((c) => this.renderer.xscale.invert(c)).widen(this.max_radius), l = o.map((c) => this.renderer.yscale.invert(c)).widen(this.max_radius)) : (s = r.widen(this.max_size).map((c) => this.renderer.xscale.invert(c)), l = o.widen(this.max_size).map((c) => this.renderer.yscale.invert(c))), this.index.indices({
      x0: s.start,
      x1: s.end,
      y0: l.start,
      y1: l.end
    });
  }
  _render(e, r, o) {
    const { sx: s, sy: l, sradius: c } = o != null ? o : this;
    for (const u of r) {
      const d = s[u], f = l[u], T = c[u];
      !isFinite(d + f + T) || (e.beginPath(), e.arc(d, f, T, 0, 2 * Math.PI, !1), this.visuals.fill.apply(e, u), this.visuals.hatch.apply(e, u), this.visuals.line.apply(e, u));
    }
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = this.renderer.xscale.invert(r), l = this.renderer.yscale.invert(o), { hit_dilation: c } = this.model;
    let u, d, f, T;
    if (this.use_radius && this.model.properties.radius.units == "data")
      u = s - this.max_radius * c, d = s + this.max_radius * c, f = l - this.max_radius * c, T = l + this.max_radius * c;
    else {
      const g = r - this.max_size * c, v = r + this.max_size * c;
      [u, d] = this.renderer.xscale.r_invert(g, v);
      const b = o - this.max_size * c, L = o + this.max_size * c;
      [f, T] = this.renderer.yscale.r_invert(b, L);
    }
    const Q = this.index.indices({ x0: u, x1: d, y0: f, y1: T }), m = [];
    if (this.use_radius && this.model.properties.radius.units == "data")
      for (const g of Q) {
        const v = (this.sradius[g] * c) ** 2, [b, L] = this.renderer.xscale.r_compute(s, this._x[g]), [A, M] = this.renderer.yscale.r_compute(l, this._y[g]);
        (b - L) ** 2 + (A - M) ** 2 <= v && m.push(g);
      }
    else
      for (const g of Q) {
        const v = (this.sradius[g] * c) ** 2;
        (this.sx[g] - r) ** 2 + (this.sy[g] - o) ** 2 <= v && m.push(g);
      }
    return new Selection({ indices: m });
  }
  _hit_span(e) {
    const { sx: r, sy: o } = e, s = this.bounds();
    let l, c, u, d;
    if (e.direction == "h") {
      let T, Q;
      if (u = s.y0, d = s.y1, this.use_radius && this.model.properties.radius.units == "data")
        T = r - this.max_radius, Q = r + this.max_radius, [l, c] = this.renderer.xscale.r_invert(T, Q);
      else {
        const m = this.max_size / 2;
        T = r - m, Q = r + m, [l, c] = this.renderer.xscale.r_invert(T, Q);
      }
    } else {
      let T, Q;
      if (l = s.x0, c = s.x1, this.use_radius && this.model.properties.radius.units == "data")
        T = o - this.max_radius, Q = o + this.max_radius, [u, d] = this.renderer.yscale.r_invert(T, Q);
      else {
        const m = this.max_size / 2;
        T = o - m, Q = o + m, [u, d] = this.renderer.yscale.r_invert(T, Q);
      }
    }
    const f = [...this.index.indices({ x0: l, x1: c, y0: u, y1: d })];
    return new Selection({ indices: f });
  }
  _hit_rect(e) {
    const { sx0: r, sx1: o, sy0: s, sy1: l } = e, [c, u] = this.renderer.xscale.r_invert(r, o), [d, f] = this.renderer.yscale.r_invert(s, l), T = [...this.index.indices({ x0: c, x1: u, y0: d, y1: f })];
    return new Selection({ indices: T });
  }
  _hit_poly(e) {
    const { sx: r, sy: o } = e, s = range(0, this.sx.length), l = [];
    for (let c = 0, u = s.length; c < u; c++) {
      const d = s[c];
      point_in_poly(this.sx[c], this.sy[c], r, o) && l.push(d);
    }
    return new Selection({ indices: l });
  }
  draw_legend_for_index(e, { x0: r, y0: o, x1: s, y1: l }, c) {
    const u = c + 1, d = new Array(u);
    d[c] = (r + s) / 2;
    const f = new Array(u);
    f[c] = (o + l) / 2;
    const T = new Array(u);
    T[c] = Math.min(Math.abs(s - r), Math.abs(l - o)) * 0.2, this._render(e, [c], { sx: d, sy: f, sradius: T });
  }
}
CircleView.__name__ = "CircleView";
class Circle extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$2f = Circle;
Circle.__name__ = "Circle";
_a$2f.prototype.default_view = CircleView, _a$2f.mixins([LineVector$1, FillVector$1, HatchVector$1]), _a$2f.define(({ Number: t }) => ({
  angle: [AngleSpec, 0],
  size: [ScreenSizeSpec, { value: 4 }],
  radius: [NullDistanceSpec, null],
  radius_dimension: [RadiusDimension, "x"],
  hit_dilation: [t, 1]
}));
var _a$2e;
class CenterRotatableView extends XYGlyphView {
  get max_w2() {
    return this.model.properties.width.units == "data" ? this.max_width / 2 : 0;
  }
  get max_h2() {
    return this.model.properties.height.units == "data" ? this.max_height / 2 : 0;
  }
  _bounds({ x0: e, x1: r, y0: o, y1: s }) {
    const { max_w2: l, max_h2: c } = this;
    return {
      x0: e - l,
      x1: r + l,
      y0: o - c,
      y1: s + c
    };
  }
}
CenterRotatableView.__name__ = "CenterRotatableView";
class CenterRotatable extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$2e = CenterRotatable;
CenterRotatable.__name__ = "CenterRotatable";
_a$2e.mixins([LineVector$1, FillVector$1, HatchVector$1]), _a$2e.define(({}) => ({
  angle: [AngleSpec, 0],
  width: [DistanceSpec, { field: "width" }],
  height: [DistanceSpec, { field: "height" }]
}));
class EllipseOvalView extends CenterRotatableView {
  _map_data() {
    this.model.properties.width.units == "data" ? this.sw = this.sdist(this.renderer.xscale, this._x, this.width, "center") : this.sw = to_screen(this.width), this.model.properties.height.units == "data" ? this.sh = this.sdist(this.renderer.yscale, this._y, this.height, "center") : this.sh = to_screen(this.height);
  }
  _render(e, r, o) {
    const { sx: s, sy: l, sw: c, sh: u, angle: d } = o != null ? o : this;
    for (const f of r) {
      const T = s[f], Q = l[f], m = c[f], g = u[f], v = d.get(f);
      !isFinite(T + Q + m + g + v) || (e.beginPath(), e.ellipse(T, Q, m / 2, g / 2, v, 0, 2 * Math.PI), this.visuals.fill.apply(e, f), this.visuals.hatch.apply(e, f), this.visuals.line.apply(e, f));
    }
  }
  _hit_point(e) {
    let r, o, s, l, c, u, d, f, T;
    const { sx: Q, sy: m } = e, g = this.renderer.xscale.invert(Q), v = this.renderer.yscale.invert(m);
    this.model.properties.width.units == "data" ? (r = g - this.max_width, o = g + this.max_width) : (u = Q - this.max_width, d = Q + this.max_width, [r, o] = this.renderer.xscale.r_invert(u, d)), this.model.properties.height.units == "data" ? (s = v - this.max_height, l = v + this.max_height) : (f = m - this.max_height, T = m + this.max_height, [s, l] = this.renderer.yscale.r_invert(f, T));
    const b = this.index.indices({ x0: r, x1: o, y0: s, y1: l }), L = [];
    for (const A of b)
      c = point_in_ellipse(Q, m, this.angle.get(A), this.sh[A] / 2, this.sw[A] / 2, this.sx[A], this.sy[A]), c && L.push(A);
    return new Selection({ indices: L });
  }
  draw_legend_for_index(e, { x0: r, y0: o, x1: s, y1: l }, c) {
    const u = c + 1, d = new Array(u);
    d[c] = (r + s) / 2;
    const f = new Array(u);
    f[c] = (o + l) / 2;
    const T = this.sw[c] / this.sh[c], Q = Math.min(Math.abs(s - r), Math.abs(l - o)) * 0.8, m = new Array(u), g = new Array(u);
    T > 1 ? (m[c] = Q, g[c] = Q / T) : (m[c] = Q * T, g[c] = Q);
    const v = new UniformScalar(0, u);
    this._render(e, [c], { sx: d, sy: f, sw: m, sh: g, angle: v });
  }
}
EllipseOvalView.__name__ = "EllipseOvalView";
class EllipseOval extends CenterRotatable {
  constructor(e) {
    super(e);
  }
}
EllipseOval.__name__ = "EllipseOval";
var _a$2d;
class EllipseView extends EllipseOvalView {
}
EllipseView.__name__ = "EllipseView";
class Ellipse extends EllipseOval {
  constructor(e) {
    super(e);
  }
}
_a$2d = Ellipse;
Ellipse.__name__ = "Ellipse";
_a$2d.prototype.default_view = EllipseView;
var _a$2c;
class BoxView$1 extends GlyphView {
  get_anchor_point(e, r, o) {
    const s = Math.min(this.sleft[r], this.sright[r]), l = Math.max(this.sright[r], this.sleft[r]), c = Math.min(this.stop[r], this.sbottom[r]), u = Math.max(this.sbottom[r], this.stop[r]);
    switch (e) {
      case "top_left":
        return { x: s, y: c };
      case "top":
      case "top_center":
        return { x: (s + l) / 2, y: c };
      case "top_right":
        return { x: l, y: c };
      case "bottom_left":
        return { x: s, y: u };
      case "bottom":
      case "bottom_center":
        return { x: (s + l) / 2, y: u };
      case "bottom_right":
        return { x: l, y: u };
      case "left":
      case "center_left":
        return { x: s, y: (c + u) / 2 };
      case "center":
      case "center_center":
        return { x: (s + l) / 2, y: (c + u) / 2 };
      case "right":
      case "center_right":
        return { x: l, y: (c + u) / 2 };
    }
  }
  _index_data(e) {
    const { min: r, max: o } = Math, { data_size: s } = this;
    for (let l = 0; l < s; l++) {
      const [c, u, d, f] = this._lrtb(l);
      e.add_rect(r(c, u), r(d, f), o(u, c), o(d, f));
    }
  }
  _render(e, r, o) {
    const { sleft: s, sright: l, stop: c, sbottom: u } = o != null ? o : this;
    for (const d of r) {
      const f = s[d], T = c[d], Q = l[d], m = u[d];
      !isFinite(f + T + Q + m) || (e.beginPath(), e.rect(f, T, Q - f, m - T), this.visuals.fill.apply(e, d), this.visuals.hatch.apply(e, d), this.visuals.line.apply(e, d));
    }
  }
  _clamp_viewport() {
    const e = this.renderer.plot_view.frame.bbox.h_range, r = this.renderer.plot_view.frame.bbox.v_range, o = this.stop.length;
    for (let s = 0; s < o; s++)
      this.stop[s] = Math.max(this.stop[s], r.start), this.sbottom[s] = Math.min(this.sbottom[s], r.end), this.sleft[s] = Math.max(this.sleft[s], e.start), this.sright[s] = Math.min(this.sright[s], e.end);
  }
  _hit_rect(e) {
    return this._hit_rect_against_index(e);
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = this.renderer.xscale.invert(r), l = this.renderer.yscale.invert(o), c = [...this.index.indices({ x0: s, y0: l, x1: s, y1: l })];
    return new Selection({ indices: c });
  }
  _hit_span(e) {
    const { sx: r, sy: o } = e;
    let s;
    if (e.direction == "v") {
      const l = this.renderer.yscale.invert(o), c = this.renderer.plot_view.frame.bbox.h_range, [u, d] = this.renderer.xscale.r_invert(c.start, c.end);
      s = [...this.index.indices({ x0: u, y0: l, x1: d, y1: l })];
    } else {
      const l = this.renderer.xscale.invert(r), c = this.renderer.plot_view.frame.bbox.v_range, [u, d] = this.renderer.yscale.r_invert(c.start, c.end);
      s = [...this.index.indices({ x0: l, y0: u, x1: l, y1: d })];
    }
    return new Selection({ indices: s });
  }
  draw_legend_for_index(e, r, o) {
    generic_area_vector_legend(this.visuals, e, r, o);
  }
}
BoxView$1.__name__ = "BoxView";
class Box$1 extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$2c = Box$1;
Box$1.__name__ = "Box";
_a$2c.mixins([LineVector$1, FillVector$1, HatchVector$1]);
var _a$2b;
class HBarView extends BoxView$1 {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl: e } = this.renderer.plot_view.canvas_view;
    if (e != null && e.regl_wrapper.has_webgl) {
      const { LRTBGL: r } = await Promise.resolve().then(() => lrtb);
      this.glglyph = new r(e.regl_wrapper, this);
    }
  }
  scenterxy(e) {
    const r = (this.sleft[e] + this.sright[e]) / 2, o = this.sy[e];
    return [r, o];
  }
  _lrtb(e) {
    const r = this._left[e], o = this._right[e], s = this._y[e], l = this.height.get(e) / 2, c = Math.min(r, o), u = Math.max(r, o), d = s + l, f = s - l;
    return [c, u, d, f];
  }
  _map_data() {
    this.sy = this.renderer.yscale.v_compute(this._y), this.sh = this.sdist(this.renderer.yscale, this._y, this.height, "center"), this.sleft = this.renderer.xscale.v_compute(this._left), this.sright = this.renderer.xscale.v_compute(this._right);
    const e = this.sy.length;
    this.stop = new ScreenArray(e), this.sbottom = new ScreenArray(e);
    for (let r = 0; r < e; r++)
      this.stop[r] = this.sy[r] - this.sh[r] / 2, this.sbottom[r] = this.sy[r] + this.sh[r] / 2;
    this._clamp_viewport();
  }
}
HBarView.__name__ = "HBarView";
class HBar extends Box$1 {
  constructor(e) {
    super(e);
  }
}
_a$2b = HBar;
HBar.__name__ = "HBar";
_a$2b.prototype.default_view = HBarView, _a$2b.define(({}) => ({
  left: [XCoordinateSpec, { value: 0 }],
  y: [YCoordinateSpec, { field: "y" }],
  height: [NumberSpec, { value: 1 }],
  right: [XCoordinateSpec, { field: "right" }]
}));
var _a$2a;
class HexTileView extends GlyphView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl: e } = this.renderer.plot_view.canvas_view;
    if (e != null && e.regl_wrapper.has_webgl) {
      const { HexTileGL: r } = await Promise.resolve().then(() => hex_tile);
      this.glglyph = new r(e.regl_wrapper, this);
    }
  }
  scenterxy(e) {
    const r = this.sx[e], o = this.sy[e];
    return [r, o];
  }
  _set_data() {
    const { orientation: e, size: r, aspect_scale: o } = this.model, { q: s, r: l } = this, c = this.q.length;
    this._x = new Float64Array(c), this._y = new Float64Array(c);
    const { _x: u, _y: d } = this, f = Math.sqrt(3);
    if (e == "pointytop")
      for (let T = 0; T < c; T++) {
        const Q = s.get(T), m = l.get(T) / 2;
        u[T] = r * f * (Q + m) / o, d[T] = -3 * r * m;
      }
    else
      for (let T = 0; T < c; T++) {
        const Q = s.get(T) / 2, m = l.get(T);
        u[T] = 3 * r * Q, d[T] = -r * f * (m + Q) * o;
      }
  }
  _project_data() {
    inplace.project_xy(this._x, this._y);
  }
  _index_data(e) {
    let r = this.model.size, o = Math.sqrt(3) * r / 2;
    this.model.orientation == "flattop" ? ([o, r] = [r, o], r *= this.model.aspect_scale) : o /= this.model.aspect_scale;
    const { data_size: s } = this;
    for (let l = 0; l < s; l++) {
      const c = this._x[l], u = this._y[l];
      e.add_rect(c - o, u - r, c + o, u + r);
    }
  }
  map_data() {
    var e;
    [this.sx, this.sy] = this.renderer.coordinates.map_to_screen(this._x, this._y), [this.svx, this.svy] = this._get_unscaled_vertices(), (e = this.glglyph) == null || e.set_data_changed();
  }
  _get_unscaled_vertices() {
    const e = this.model.size, r = this.model.aspect_scale;
    if (this.model.orientation == "pointytop") {
      const o = this.renderer.yscale, s = this.renderer.xscale, l = Math.abs(o.compute(0) - o.compute(e)), c = Math.sqrt(3) / 2 * Math.abs(s.compute(0) - s.compute(e)) / r, u = l / 2, d = [0, -c, -c, 0, c, c], f = [l, u, -u, -l, -u, u];
      return [d, f];
    } else {
      const o = this.renderer.xscale, s = this.renderer.yscale, l = Math.abs(o.compute(0) - o.compute(e)), c = Math.sqrt(3) / 2 * Math.abs(s.compute(0) - s.compute(e)) * r, u = l / 2, d = [l, u, -u, -l, -u, u], f = [0, -c, -c, 0, c, c];
      return [d, f];
    }
  }
  _render(e, r, o) {
    const { sx: s, sy: l, svx: c, svy: u, scale: d } = o != null ? o : this;
    for (const f of r) {
      const T = s[f], Q = l[f], m = d.get(f);
      if (!!isFinite(T + Q + m)) {
        e.translate(T, Q), e.beginPath();
        for (let g = 0; g < 6; g++)
          e.lineTo(c[g] * m, u[g] * m);
        e.closePath(), e.translate(-T, -Q), this.visuals.fill.apply(e, f), this.visuals.hatch.apply(e, f), this.visuals.line.apply(e, f);
      }
    }
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = this.renderer.xscale.invert(r), l = this.renderer.yscale.invert(o), c = this.index.indices({ x0: s, y0: l, x1: s, y1: l }), u = [];
    for (const d of c)
      point_in_poly(r - this.sx[d], o - this.sy[d], this.svx, this.svy) && u.push(d);
    return new Selection({ indices: u });
  }
  _hit_span(e) {
    const { sx: r, sy: o } = e;
    let s;
    if (e.direction == "v") {
      const l = this.renderer.yscale.invert(o), c = this.renderer.plot_view.frame.bbox.h_range, [u, d] = this.renderer.xscale.r_invert(c.start, c.end);
      s = [...this.index.indices({ x0: u, y0: l, x1: d, y1: l })];
    } else {
      const l = this.renderer.xscale.invert(r), c = this.renderer.plot_view.frame.bbox.v_range, [u, d] = this.renderer.yscale.r_invert(c.start, c.end);
      s = [...this.index.indices({ x0: l, y0: u, x1: l, y1: d })];
    }
    return new Selection({ indices: s });
  }
  _hit_rect(e) {
    const { sx0: r, sx1: o, sy0: s, sy1: l } = e, [c, u] = this.renderer.xscale.r_invert(r, o), [d, f] = this.renderer.yscale.r_invert(s, l), T = [...this.index.indices({ x0: c, x1: u, y0: d, y1: f })];
    return new Selection({ indices: T });
  }
  draw_legend_for_index(e, r, o) {
    generic_area_vector_legend(this.visuals, e, r, o);
  }
}
HexTileView.__name__ = "HexTileView";
class HexTile extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$2a = HexTile;
HexTile.__name__ = "HexTile";
_a$2a.prototype.default_view = HexTileView, _a$2a.mixins([LineVector$1, FillVector$1, HatchVector$1]), _a$2a.define(({ Number: t }) => ({
  r: [NumberSpec, { field: "r" }],
  q: [NumberSpec, { field: "q" }],
  scale: [NumberSpec, 1],
  size: [t, 1],
  aspect_scale: [t, 1],
  orientation: [HexTileOrientation, "pointytop"]
})), _a$2a.override({ line_color: null });
var _a$29;
class ImageBaseView extends XYGlyphView {
  connect_signals() {
    super.connect_signals(), this.connect(this.model.properties.global_alpha.change, () => this.renderer.request_render());
  }
  _render(e, r, o) {
    const { image_data: s, sx: l, sy: c, sw: u, sh: d, global_alpha: f } = o != null ? o : this, T = e.getImageSmoothingEnabled();
    e.setImageSmoothingEnabled(!1);
    const Q = f.is_Scalar();
    Q && (e.globalAlpha = f.value);
    for (const m of r) {
      const g = s[m], v = l[m], b = c[m], L = u[m], A = d[m], M = this.global_alpha.get(m);
      if (g == null || !isFinite(v + b + L + A + M))
        continue;
      Q || (e.globalAlpha = M);
      const S = b;
      e.translate(0, S), e.scale(1, -1), e.translate(0, -S), e.drawImage(g, v | 0, b | 0, L, A), e.translate(0, S), e.scale(1, -1), e.translate(0, -S);
    }
    e.setImageSmoothingEnabled(T);
  }
  _set_data(e) {
    this._set_width_heigh_data();
    for (let r = 0, o = this.image.length; r < o; r++) {
      if (e != null && e.indexOf(r) < 0)
        continue;
      const s = this.image.get(r);
      let l;
      is_NDArray(s) ? (assert(s.dimension == 2, "expected a 2D array"), l = s, this._height[r] = s.shape[0], this._width[r] = s.shape[1]) : (l = concat$1(s), this._height[r] = s.length, this._width[r] = s[0].length);
      const c = this._flat_img_to_buf8(l);
      this._set_image_data_from_buffer(r, c);
    }
  }
  _index_data(e) {
    const { data_size: r } = this;
    for (let o = 0; o < r; o++) {
      const [s, l, c, u] = this._lrtb(o);
      e.add_rect(s, u, l, c);
    }
  }
  _lrtb(e) {
    const r = this.dw.get(e), o = this.dh.get(e), s = this.renderer.xscale.source_range, l = this._x[e], c = s.is_reversed ? l - r : l + r, u = this.renderer.yscale.source_range, d = this._y[e], f = u.is_reversed ? d - o : d + o, [T, Q] = l < c ? [l, c] : [c, l], [m, g] = d < f ? [d, f] : [f, d];
    return [T, Q, g, m];
  }
  _set_width_heigh_data() {
    (this.image_data == null || this.image_data.length != this.image.length) && (this.image_data = new Array(this.image.length)), (this._width == null || this._width.length != this.image.length) && (this._width = new Uint32Array(this.image.length)), (this._height == null || this._height.length != this.image.length) && (this._height = new Uint32Array(this.image.length));
  }
  _get_or_create_canvas(e) {
    const r = this.image_data[e];
    if (r != null && r.width == this._width[e] && r.height == this._height[e])
      return r;
    {
      const o = document.createElement("canvas");
      return o.width = this._width[e], o.height = this._height[e], o;
    }
  }
  _set_image_data_from_buffer(e, r) {
    const o = this._get_or_create_canvas(e), s = o.getContext("2d"), l = s.getImageData(0, 0, this._width[e], this._height[e]);
    l.data.set(r), s.putImageData(l, 0, 0), this.image_data[e] = o;
  }
  _map_data() {
    this.model.properties.dw.units == "data" ? this.sw = this.sdist(this.renderer.xscale, this._x, this.dw, "edge", this.model.dilate) : this.sw = to_screen(this.dw), this.model.properties.dh.units == "data" ? this.sh = this.sdist(this.renderer.yscale, this._y, this.dh, "edge", this.model.dilate) : this.sh = to_screen(this.dh);
  }
  _image_index(e, r, o) {
    const [s, l, c, u] = this._lrtb(e), d = this._width[e], f = this._height[e], T = (l - s) / d, Q = (c - u) / f;
    let m = Math.floor((r - s) / T), g = Math.floor((o - u) / Q);
    return this.renderer.xscale.source_range.is_reversed && (m = d - m - 1), this.renderer.yscale.source_range.is_reversed && (g = f - g - 1), { index: e, dim1: m, dim2: g, flat_index: g * d + m };
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = this.renderer.xscale.invert(r), l = this.renderer.yscale.invert(o), c = this.index.indices({ x0: s, x1: s, y0: l, y1: l }), u = new Selection();
    for (const d of c)
      r != 1 / 0 && o != 1 / 0 && u.image_indices.push(this._image_index(d, s, l));
    return u;
  }
}
ImageBaseView.__name__ = "ImageBaseView";
class ImageBase extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$29 = ImageBase;
ImageBase.__name__ = "ImageBase";
_a$29.define(({ Boolean: t }) => ({
  image: [NDArraySpec, { field: "image" }],
  dw: [DistanceSpec, { field: "dw" }],
  dh: [DistanceSpec, { field: "dh" }],
  global_alpha: [NumberSpec, { value: 1 }],
  dilate: [t, !1]
}));
var _a$28;
class ImageView extends ImageBaseView {
  connect_signals() {
    super.connect_signals(), this.connect(this.model.color_mapper.change, () => this._update_image());
  }
  _update_image() {
    this.image_data != null && (this._set_data(null), this.renderer.request_render());
  }
  _flat_img_to_buf8(e) {
    return this.model.color_mapper.rgba_mapper.v_compute(e);
  }
}
ImageView.__name__ = "ImageView";
const Greys9 = () => ["#000000", "#252525", "#525252", "#737373", "#969696", "#bdbdbd", "#d9d9d9", "#f0f0f0", "#ffffff"];
class Image$1 extends ImageBase {
  constructor(e) {
    super(e);
  }
}
_a$28 = Image$1;
Image$1.__name__ = "Image";
_a$28.prototype.default_view = ImageView, _a$28.define(({ Ref: t }) => ({
  color_mapper: [t(ColorMapper), () => new LinearColorMapper({ palette: Greys9() })]
}));
var _a$27;
class ImageRGBAView extends ImageBaseView {
  _flat_img_to_buf8(e) {
    let r;
    return isArray(e) ? r = new Uint32Array(e) : r = e, new Uint8ClampedArray(r.buffer);
  }
}
ImageRGBAView.__name__ = "ImageRGBAView";
class ImageRGBA extends ImageBase {
  constructor(e) {
    super(e);
  }
}
_a$27 = ImageRGBA;
ImageRGBA.__name__ = "ImageRGBA";
_a$27.prototype.default_view = ImageRGBAView;
var _a$26;
class ImageURLView extends XYGlyphView {
  constructor() {
    super(...arguments), this._images_rendered = !1, this._set_data_iteration = 0;
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.properties.global_alpha.change, () => this.renderer.request_render());
  }
  _index_data(e) {
    const { data_size: r } = this;
    for (let o = 0; o < r; o++)
      e.add_empty();
  }
  _set_data() {
    this._set_data_iteration++;
    const e = this.url.length;
    this.image = new Array(e);
    const { retry_attempts: r, retry_timeout: o } = this.model, { _set_data_iteration: s } = this;
    for (let A = 0; A < e; A++) {
      const M = this.url.get(A);
      !M || new ImageLoader(M, {
        loaded: (S) => {
          this._set_data_iteration == s && (this.image[A] = S, this.renderer.request_render());
        },
        attempts: r + 1,
        timeout: o
      });
    }
    const l = this.model.properties.w.units == "data", c = this.model.properties.h.units == "data", u = this._x.length, d = new ScreenArray(l ? 2 * u : u), f = new ScreenArray(c ? 2 * u : u), { anchor: T } = this.model;
    function Q(A, M) {
      switch (T) {
        case "top_left":
        case "bottom_left":
        case "left":
        case "center_left":
          return [A, A + M];
        case "top":
        case "top_center":
        case "bottom":
        case "bottom_center":
        case "center":
        case "center_center":
          return [A - M / 2, A + M / 2];
        case "top_right":
        case "bottom_right":
        case "right":
        case "center_right":
          return [A - M, A];
      }
    }
    function m(A, M) {
      switch (T) {
        case "top_left":
        case "top":
        case "top_center":
        case "top_right":
          return [A, A - M];
        case "bottom_left":
        case "bottom":
        case "bottom_center":
        case "bottom_right":
          return [A + M, A];
        case "left":
        case "center_left":
        case "center":
        case "center_center":
        case "right":
        case "center_right":
          return [A + M / 2, A - M / 2];
      }
    }
    if (l)
      for (let A = 0; A < u; A++)
        [d[A], d[u + A]] = Q(this._x[A], this.w.get(A));
    else
      d.set(this._x, 0);
    if (c)
      for (let A = 0; A < u; A++)
        [f[A], f[u + A]] = m(this._y[A], this.h.get(A));
    else
      f.set(this._y, 0);
    const [g, v] = minmax(d), [b, L] = minmax(f);
    this._bounds_rect = { x0: g, x1: v, y0: b, y1: L };
  }
  has_finished() {
    return super.has_finished() && this._images_rendered == !0;
  }
  _map_data() {
    this.model.properties.w.units == "data" ? this.sw = this.sdist(this.renderer.xscale, this._x, this.w, "edge", this.model.dilate) : this.sw = to_screen(this.w), this.model.properties.h.units == "data" ? this.sh = this.sdist(this.renderer.yscale, this._y, this.h, "edge", this.model.dilate) : this.sh = to_screen(this.h);
  }
  _render(e, r, o) {
    const { image: s, sx: l, sy: c, sw: u, sh: d, angle: f, global_alpha: T } = o != null ? o : this, { frame: Q } = this.renderer.plot_view;
    e.beginPath(), e.rect(Q.bbox.left + 1, Q.bbox.top + 1, Q.bbox.width - 2, Q.bbox.height - 2), e.clip();
    let m = !0;
    for (const g of r) {
      if (!isFinite(l[g] + c[g] + f.get(g) + T.get(g)))
        continue;
      const v = s[g];
      if (v == null) {
        m = !1;
        continue;
      }
      this._render_image(e, g, v, l, c, u, d, f, T);
    }
    m && !this._images_rendered && (this._images_rendered = !0, this.notify_finished());
  }
  _final_sx_sy(e, r, o, s, l) {
    switch (e) {
      case "top_left":
        return [r, o];
      case "top":
      case "top_center":
        return [r - s / 2, o];
      case "top_right":
        return [r - s, o];
      case "right":
      case "center_right":
        return [r - s, o - l / 2];
      case "bottom_right":
        return [r - s, o - l];
      case "bottom":
      case "bottom_center":
        return [r - s / 2, o - l];
      case "bottom_left":
        return [r, o - l];
      case "left":
      case "center_left":
        return [r, o - l / 2];
      case "center":
      case "center_center":
        return [r - s / 2, o - l / 2];
    }
  }
  _render_image(e, r, o, s, l, c, u, d, f) {
    isFinite(c[r]) || (c[r] = o.width), isFinite(u[r]) || (u[r] = o.height);
    const T = c[r], Q = u[r], { anchor: m } = this.model, [g, v] = this._final_sx_sy(m, s[r], l[r], T, Q), b = d.get(r), L = f.get(r);
    e.save(), e.globalAlpha = L;
    const A = T / 2, M = Q / 2;
    b ? (e.translate(g, v), e.translate(A, M), e.rotate(b), e.translate(-A, -M), e.drawImage(o, 0, 0, T, Q), e.translate(A, M), e.rotate(-b), e.translate(-A, -M), e.translate(-g, -v)) : e.drawImage(o, g, v, T, Q), e.restore();
  }
  bounds() {
    return this._bounds_rect;
  }
}
ImageURLView.__name__ = "ImageURLView";
class ImageURL extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$26 = ImageURL;
ImageURL.__name__ = "ImageURL";
_a$26.prototype.default_view = ImageURLView, _a$26.define(({ Boolean: t, Int: e }) => ({
  url: [StringSpec, { field: "url" }],
  anchor: [Anchor, "top_left"],
  global_alpha: [NumberSpec, { value: 1 }],
  angle: [AngleSpec, 0],
  w: [NullDistanceSpec, null],
  h: [NullDistanceSpec, null],
  dilate: [t, !1],
  retry_attempts: [e, 0],
  retry_timeout: [e, 0]
}));
var _a$25;
class MultiLineView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._xs.array, this._ys.array);
  }
  _index_data(e) {
    const { data_size: r } = this;
    for (let o = 0; o < r; o++) {
      const s = this._xs.get(o), l = this._ys.get(o), [c, u, d, f] = minmax2(s, l);
      e.add_rect(c, d, u, f);
    }
  }
  _render(e, r, o) {
    const { sxs: s, sys: l } = o != null ? o : this;
    for (const c of r) {
      const u = s.get(c), d = l.get(c), f = Math.min(u.length, d.length);
      let T = !0;
      e.beginPath();
      for (let Q = 0; Q < f; Q++) {
        const m = u[Q], g = d[Q];
        isFinite(m + g) ? T ? (e.moveTo(m, g), T = !1) : e.lineTo(m, g) : T = !0;
      }
      this.visuals.line.set_vectorize(e, c), e.stroke();
    }
  }
  _hit_point(e) {
    const r = { x: e.sx, y: e.sy };
    let o = 9999;
    const s = /* @__PURE__ */ new Map();
    for (let l = 0, c = this.sxs.length; l < c; l++) {
      const u = Math.max(2, this.line_width.get(l) / 2), d = this.sxs.get(l), f = this.sys.get(l);
      let T = null;
      for (let Q = 0, m = d.length - 1; Q < m; Q++) {
        const g = { x: d[Q], y: f[Q] }, v = { x: d[Q + 1], y: f[Q + 1] }, b = dist_to_segment(r, g, v);
        b < u && b < o && (o = b, T = [Q]);
      }
      T != null && s.set(l, T);
    }
    return new Selection({
      indices: [...s.keys()],
      multiline_indices: to_object(s)
    });
  }
  _hit_span(e) {
    const { sx: r, sy: o } = e;
    let s, l;
    e.direction == "v" ? (s = this.renderer.yscale.invert(o), l = this._ys) : (s = this.renderer.xscale.invert(r), l = this._xs);
    const c = /* @__PURE__ */ new Map();
    for (let u = 0, d = l.length; u < d; u++) {
      const f = l.get(u), T = [];
      for (let Q = 0, m = f.length - 1; Q < m; Q++)
        f[Q] <= s && s <= f[Q + 1] && T.push(Q);
      T.length > 0 && c.set(u, T);
    }
    return new Selection({
      indices: [...c.keys()],
      multiline_indices: to_object(c)
    });
  }
  get_interpolation_hit(e, r, o) {
    const s = this._xs.get(e), l = this._ys.get(e), c = s[r], u = l[r], d = s[r + 1], f = l[r + 1];
    return line_interpolation(this.renderer, o, c, u, d, f);
  }
  draw_legend_for_index(e, r, o) {
    generic_line_vector_legend(this.visuals, e, r, o);
  }
  scenterxy() {
    throw new Error(`${this}.scenterxy() is not implemented`);
  }
}
MultiLineView.__name__ = "MultiLineView";
class MultiLine extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$25 = MultiLine;
MultiLine.__name__ = "MultiLine";
_a$25.prototype.default_view = MultiLineView, _a$25.define(({}) => ({
  xs: [XCoordinateSeqSpec, { field: "xs" }],
  ys: [YCoordinateSeqSpec, { field: "ys" }]
})), _a$25.mixins(LineVector$1);
var _a$24;
class MultiPolygonsView extends GlyphView {
  _project_data() {
  }
  _index_data(e) {
    const { min: r, max: o } = Math, { data_size: s } = this;
    for (let l = 0; l < s; l++) {
      const c = this._xs[l], u = this._ys[l];
      if (c.length == 0 || u.length == 0) {
        e.add_empty();
        continue;
      }
      let d = 1 / 0, f = -1 / 0, T = 1 / 0, Q = -1 / 0;
      for (let m = 0, g = c.length; m < g; m++) {
        const v = c[m][0], b = u[m][0];
        if (v.length != 0 && b.length != 0) {
          const [L, A] = minmax(v), [M, S] = minmax(b);
          d = r(d, L), f = o(f, A), T = r(T, M), Q = o(Q, S);
        }
      }
      e.add_rect(d, T, f, Q);
    }
    this._hole_index = this._index_hole_data();
  }
  _index_hole_data() {
    const { min: e, max: r } = Math, { data_size: o } = this, s = new SpatialIndex(o);
    for (let l = 0; l < o; l++) {
      const c = this._xs[l], u = this._ys[l];
      if (c.length == 0 || u.length == 0) {
        s.add_empty();
        continue;
      }
      let d = 1 / 0, f = -1 / 0, T = 1 / 0, Q = -1 / 0;
      for (let m = 0, g = c.length; m < g; m++) {
        const v = c[m], b = u[m];
        if (v.length > 1 && b.length > 1)
          for (let L = 1, A = v.length; L < A; L++) {
            const [M, S] = minmax(v[L]), [E, k] = minmax(b[L]);
            d = e(d, M), f = r(f, S), T = e(T, E), Q = r(Q, k);
          }
      }
      s.add_rect(d, T, f, Q);
    }
    return s.finish(), s;
  }
  _mask_data() {
    const { x_range: e, y_range: r } = this.renderer.plot_view.frame;
    return this.index.indices({
      x0: e.min,
      x1: e.max,
      y0: r.min,
      y1: r.max
    });
  }
  _render(e, r, o) {
    if (this.visuals.fill.doit || this.visuals.line.doit) {
      const { sxs: s, sys: l } = o != null ? o : this;
      for (const c of r) {
        e.beginPath();
        const u = s[c], d = l[c], f = Math.min(u.length, d.length);
        for (let T = 0; T < f; T++) {
          const Q = u[T], m = d[T], g = Math.min(Q.length, m.length);
          for (let v = 0; v < g; v++) {
            const b = Q[v], L = m[v], A = Math.min(b.length, L.length);
            for (let M = 0; M < A; M++) {
              const S = b[M], E = L[M];
              M == 0 ? e.moveTo(S, E) : e.lineTo(S, E);
            }
            e.closePath();
          }
        }
        this.visuals.fill.apply(e, c, "evenodd"), this.visuals.hatch.apply(e, c, "evenodd"), this.visuals.line.apply(e, c);
      }
    }
  }
  _hit_rect(e) {
    const { sx0: r, sx1: o, sy0: s, sy1: l } = e, c = [r, o, o, r], u = [s, s, l, l], [d, f] = this.renderer.xscale.r_invert(r, o), [T, Q] = this.renderer.yscale.r_invert(s, l), m = this.index.indices({ x0: d, x1: f, y0: T, y1: Q }), g = [];
    for (const v of m) {
      const b = this.sxs[v], L = this.sys[v];
      let A = !0;
      for (let M = 0, S = b.length; M < S; M++) {
        for (let E = 0, k = b[M][0].length; E < k; E++) {
          const w = b[M][0][E], O = L[M][0][E];
          if (!point_in_poly(w, O, c, u)) {
            A = !1;
            break;
          }
        }
        if (!A)
          break;
      }
      A && g.push(v);
    }
    return new Selection({ indices: g });
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = this.renderer.xscale.invert(r), l = this.renderer.yscale.invert(o), c = this.index.indices({ x0: s, y0: l, x1: s, y1: l }), u = this._hole_index.indices({ x0: s, y0: l, x1: s, y1: l }), d = [];
    for (const f of c) {
      const T = this.sxs[f], Q = this.sys[f];
      for (let m = 0, g = T.length; m < g; m++) {
        const v = T[m].length;
        if (point_in_poly(r, o, T[m][0], Q[m][0])) {
          if (v == 1)
            d.push(f);
          else if (!u.get(f))
            d.push(f);
          else if (v > 1) {
            let b = !1;
            for (let L = 1; L < v; L++) {
              const A = T[m][L], M = Q[m][L];
              if (point_in_poly(r, o, A, M)) {
                b = !0;
                break;
              } else
                continue;
            }
            b || d.push(f);
          }
        }
      }
    }
    return new Selection({ indices: d });
  }
  _get_snap_coord(e) {
    return sum$2(e) / e.length;
  }
  scenterxy(e, r, o) {
    if (this.sxs[e].length == 1) {
      const s = this._get_snap_coord(this.sxs[e][0][0]), l = this._get_snap_coord(this.sys[e][0][0]);
      return [s, l];
    } else {
      const s = this.sxs[e], l = this.sys[e];
      for (let c = 0, u = s.length; c < u; c++)
        if (point_in_poly(r, o, s[c][0], l[c][0])) {
          const d = this._get_snap_coord(s[c][0]), f = this._get_snap_coord(l[c][0]);
          return [d, f];
        }
    }
    unreachable();
  }
  map_data() {
    const e = this._xs.length;
    this.sxs = new Array(e), this.sys = new Array(e);
    for (let r = 0; r < e; r++) {
      const o = this._xs[r].length;
      this.sxs[r] = new Array(o), this.sys[r] = new Array(o);
      for (let s = 0; s < o; s++) {
        const l = this._xs[r][s].length;
        this.sxs[r][s] = new Array(l), this.sys[r][s] = new Array(l);
        for (let c = 0; c < l; c++) {
          const [u, d] = this.renderer.coordinates.map_to_screen(this._xs[r][s][c], this._ys[r][s][c]);
          this.sxs[r][s][c] = u, this.sys[r][s][c] = d;
        }
      }
    }
  }
  draw_legend_for_index(e, r, o) {
    generic_area_vector_legend(this.visuals, e, r, o);
  }
}
MultiPolygonsView.__name__ = "MultiPolygonsView";
class MultiPolygons extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$24 = MultiPolygons;
MultiPolygons.__name__ = "MultiPolygons";
_a$24.prototype.default_view = MultiPolygonsView, _a$24.define(({}) => ({
  xs: [XCoordinateSeqSeqSeqSpec, { field: "xs" }],
  ys: [YCoordinateSeqSeqSeqSpec, { field: "ys" }]
})), _a$24.mixins([LineVector$1, FillVector$1, HatchVector$1]);
var _a$23;
class OvalView extends EllipseOvalView {
  _map_data() {
    super._map_data(), mul(this.sw, 0.75);
  }
}
OvalView.__name__ = "OvalView";
class Oval extends EllipseOval {
  constructor(e) {
    super(e);
  }
}
_a$23 = Oval;
Oval.__name__ = "Oval";
_a$23.prototype.default_view = OvalView;
var _a$22;
class PatchesView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._xs.array, this._ys.array);
  }
  _index_data(e) {
    const { data_size: r } = this;
    for (let o = 0; o < r; o++) {
      const s = this._xs.get(o), l = this._ys.get(o), [c, u, d, f] = minmax2(s, l);
      e.add_rect(c, d, u, f);
    }
  }
  _mask_data() {
    const { x_range: e, y_range: r } = this.renderer.plot_view.frame;
    return this.index.indices({
      x0: e.min,
      x1: e.max,
      y0: r.min,
      y1: r.max
    });
  }
  _render(e, r, o) {
    const { sxs: s, sys: l } = o != null ? o : this;
    for (const c of r) {
      const u = s.get(c), d = l.get(c);
      let f = !0;
      e.beginPath();
      const T = Math.min(u.length, d.length);
      for (let Q = 0; Q < T; Q++) {
        const m = u[Q], g = d[Q];
        isFinite(m + g) ? f ? (e.moveTo(m, g), f = !1) : e.lineTo(m, g) : (e.closePath(), f = !0);
      }
      e.closePath(), this.visuals.fill.apply(e, c), this.visuals.hatch.apply(e, c), this.visuals.line.apply(e, c);
    }
  }
  _hit_rect(e) {
    const { sx0: r, sx1: o, sy0: s, sy1: l } = e, c = [r, o, o, r], u = [s, s, l, l], [d, f] = this.renderer.xscale.r_invert(r, o), [T, Q] = this.renderer.yscale.r_invert(s, l), m = this.index.indices({ x0: d, x1: f, y0: T, y1: Q }), g = [];
    for (const v of m) {
      const b = this.sxs.get(v), L = this.sys.get(v);
      let A = !0;
      for (let M = 0, S = b.length; M < S; M++) {
        const E = b[M], k = L[M];
        if (!point_in_poly(E, k, c, u)) {
          A = !1;
          break;
        }
      }
      A && g.push(v);
    }
    return new Selection({ indices: g });
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = this.renderer.xscale.invert(r), l = this.renderer.yscale.invert(o), c = this.index.indices({ x0: s, y0: l, x1: s, y1: l }), u = [];
    for (const d of c) {
      const f = this.sxs.get(d), T = this.sys.get(d), Q = f.length;
      for (let m = 0, g = 0; ; g++) {
        if (isNaN(f[g]) || g == Q) {
          const v = f.subarray(m, g), b = T.subarray(m, g);
          if (point_in_poly(r, o, v, b)) {
            u.push(d);
            break;
          }
          m = g + 1;
        }
        if (g == Q)
          break;
      }
    }
    return new Selection({ indices: u });
  }
  _get_snap_coord(e) {
    return sum$2(e) / e.length;
  }
  scenterxy(e, r, o) {
    const s = this.sxs.get(e), l = this.sys.get(e), c = s.length;
    let u = !1;
    for (let d = 0, f = 0; ; f++) {
      const T = isNaN(s[f]);
      if (u = u || T, f == c && !u) {
        const Q = this._get_snap_coord(s), m = this._get_snap_coord(l);
        return [Q, m];
      }
      if (T || f == c) {
        const Q = s.subarray(d, f), m = l.subarray(d, f);
        if (point_in_poly(r, o, Q, m)) {
          const g = this._get_snap_coord(Q), v = this._get_snap_coord(m);
          return [g, v];
        }
        d = f + 1;
      }
      if (f == c)
        break;
    }
    unreachable();
  }
  draw_legend_for_index(e, r, o) {
    generic_area_vector_legend(this.visuals, e, r, o);
  }
}
PatchesView.__name__ = "PatchesView";
class Patches extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$22 = Patches;
Patches.__name__ = "Patches";
_a$22.prototype.default_view = PatchesView, _a$22.define(({}) => ({
  xs: [XCoordinateSeqSpec, { field: "xs" }],
  ys: [YCoordinateSeqSpec, { field: "ys" }]
})), _a$22.mixins([LineVector$1, FillVector$1, HatchVector$1]);
var _a$21;
class QuadView extends BoxView$1 {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl: e } = this.renderer.plot_view.canvas_view;
    if (e != null && e.regl_wrapper.has_webgl) {
      const { LRTBGL: r } = await Promise.resolve().then(() => lrtb);
      this.glglyph = new r(e.regl_wrapper, this);
    }
  }
  scenterxy(e) {
    const r = this.sleft[e] / 2 + this.sright[e] / 2, o = this.stop[e] / 2 + this.sbottom[e] / 2;
    return [r, o];
  }
  _lrtb(e) {
    const r = this._left[e], o = this._right[e], s = this._top[e], l = this._bottom[e];
    return [r, o, s, l];
  }
}
QuadView.__name__ = "QuadView";
class Quad extends Box$1 {
  constructor(e) {
    super(e);
  }
}
_a$21 = Quad;
Quad.__name__ = "Quad";
_a$21.prototype.default_view = QuadView, _a$21.define(({}) => ({
  right: [XCoordinateSpec, { field: "right" }],
  bottom: [YCoordinateSpec, { field: "bottom" }],
  left: [XCoordinateSpec, { field: "left" }],
  top: [YCoordinateSpec, { field: "top" }]
}));
var _a$20;
function _qbb(t, e, r) {
  if (e == (t + r) / 2)
    return [t, r];
  {
    const o = (t - e) / (t - 2 * e + r), s = t * (1 - o) ** 2 + 2 * e * (1 - o) * o + r * o ** 2;
    return [Math.min(t, r, s), Math.max(t, r, s)];
  }
}
class QuadraticView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._x0, this._y0), inplace.project_xy(this._x1, this._y1);
  }
  _index_data(e) {
    const { _x0: r, _x1: o, _y0: s, _y1: l, _cx: c, _cy: u, data_size: d } = this;
    for (let f = 0; f < d; f++) {
      const T = r[f], Q = o[f], m = s[f], g = l[f], v = c[f], b = u[f];
      if (!isFinite(T + Q + m + g + v + b))
        e.add_empty();
      else {
        const [L, A] = _qbb(T, v, Q), [M, S] = _qbb(m, b, g);
        e.add_rect(L, M, A, S);
      }
    }
  }
  _render(e, r, o) {
    if (this.visuals.line.doit) {
      const { sx0: s, sy0: l, sx1: c, sy1: u, scx: d, scy: f } = o != null ? o : this;
      for (const T of r) {
        const Q = s[T], m = l[T], g = c[T], v = u[T], b = d[T], L = f[T];
        !isFinite(Q + m + g + v + b + L) || (e.beginPath(), e.moveTo(Q, m), e.quadraticCurveTo(b, L, g, v), this.visuals.line.set_vectorize(e, T), e.stroke());
      }
    }
  }
  draw_legend_for_index(e, r, o) {
    generic_line_vector_legend(this.visuals, e, r, o);
  }
  scenterxy() {
    throw new Error(`${this}.scenterxy() is not implemented`);
  }
}
QuadraticView.__name__ = "QuadraticView";
class Quadratic extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$20 = Quadratic;
Quadratic.__name__ = "Quadratic";
_a$20.prototype.default_view = QuadraticView, _a$20.define(({}) => ({
  x0: [XCoordinateSpec, { field: "x0" }],
  y0: [YCoordinateSpec, { field: "y0" }],
  x1: [XCoordinateSpec, { field: "x1" }],
  y1: [YCoordinateSpec, { field: "y1" }],
  cx: [XCoordinateSpec, { field: "cx" }],
  cy: [YCoordinateSpec, { field: "cy" }]
})), _a$20.mixins(LineVector$1);
var _a$1$;
class RayView extends XYGlyphView {
  _map_data() {
    this.model.properties.length.units == "data" ? this.slength = this.sdist(this.renderer.xscale, this._x, this.length) : this.slength = to_screen(this.length);
    const { width: e, height: r } = this.renderer.plot_view.frame.bbox, o = 2 * (e + r), { slength: s } = this;
    for (let l = 0, c = s.length; l < c; l++)
      s[l] == 0 && (s[l] = o);
  }
  _render(e, r, o) {
    const { sx: s, sy: l, slength: c, angle: u } = o != null ? o : this;
    if (this.visuals.line.doit)
      for (const d of r) {
        const f = s[d], T = l[d], Q = u.get(d), m = c[d];
        !isFinite(f + T + Q + m) || (e.translate(f, T), e.rotate(Q), e.beginPath(), e.moveTo(0, 0), e.lineTo(m, 0), this.visuals.line.set_vectorize(e, d), e.stroke(), e.rotate(-Q), e.translate(-f, -T));
      }
  }
  draw_legend_for_index(e, r, o) {
    generic_line_vector_legend(this.visuals, e, r, o);
  }
}
RayView.__name__ = "RayView";
class Ray extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$1$ = Ray;
Ray.__name__ = "Ray";
_a$1$.prototype.default_view = RayView, _a$1$.mixins(LineVector$1), _a$1$.define(({}) => ({
  length: [DistanceSpec, 0],
  angle: [AngleSpec, 0]
}));
var _a$1_;
class RectView extends CenterRotatableView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl: e } = this.renderer.plot_view.canvas_view;
    if (e != null && e.regl_wrapper.has_webgl) {
      const { RectGL: r } = await Promise.resolve().then(() => rect);
      this.glglyph = new r(e.regl_wrapper, this);
    }
  }
  _map_data() {
    if (this.model.properties.width.units == "data")
      [this.sw, this.sx0] = this._map_dist_corner_for_data_side_length(this._x, this.width, this.renderer.xscale);
    else {
      this.sw = to_screen(this.width);
      const r = this.sx.length;
      this.sx0 = new ScreenArray(r);
      for (let o = 0; o < r; o++)
        this.sx0[o] = this.sx[o] - this.sw[o] / 2;
    }
    if (this.model.properties.height.units == "data")
      [this.sh, this.sy1] = this._map_dist_corner_for_data_side_length(this._y, this.height, this.renderer.yscale);
    else {
      this.sh = to_screen(this.height);
      const r = this.sy.length;
      this.sy1 = new ScreenArray(r);
      for (let o = 0; o < r; o++)
        this.sy1[o] = this.sy[o] - this.sh[o] / 2;
    }
    const e = this.sw.length;
    this.ssemi_diag = new ScreenArray(e);
    for (let r = 0; r < e; r++)
      this.ssemi_diag[r] = Math.sqrt(this.sw[r] / 2 * this.sw[r] / 2 + this.sh[r] / 2 * this.sh[r] / 2);
  }
  _render(e, r, o) {
    const { sx: s, sy: l, sx0: c, sy1: u, sw: d, sh: f, angle: T } = o != null ? o : this;
    for (const Q of r) {
      const m = s[Q], g = l[Q], v = c[Q], b = u[Q], L = d[Q], A = f[Q], M = T.get(Q);
      !isFinite(m + g + v + b + L + A + M) || L == 0 || A == 0 || (e.beginPath(), M ? (e.translate(m, g), e.rotate(M), e.rect(-L / 2, -A / 2, L, A), e.rotate(-M), e.translate(-m, -g)) : e.rect(v, b, L, A), this.visuals.fill.apply(e, Q), this.visuals.hatch.apply(e, Q), this.visuals.line.apply(e, Q));
    }
  }
  _hit_rect(e) {
    return this._hit_rect_against_index(e);
  }
  _hit_point(e) {
    let { sx: r, sy: o } = e;
    const s = this.renderer.xscale.invert(r), l = this.renderer.yscale.invert(o), c = this.sx0.length, u = new ScreenArray(c);
    for (let M = 0; M < c; M++)
      u[M] = this.sx0[M] + this.sw[M] / 2;
    const d = new ScreenArray(c);
    for (let M = 0; M < c; M++)
      d[M] = this.sy1[M] + this.sh[M] / 2;
    const f = max$8(this._ddist(0, u, this.ssemi_diag)), T = max$8(this._ddist(1, d, this.ssemi_diag)), Q = s - f, m = s + f, g = l - T, v = l + T;
    let b, L;
    const A = [];
    for (const M of this.index.indices({ x0: Q, x1: m, y0: g, y1: v })) {
      const S = this.angle.get(M);
      if (S) {
        const E = Math.sin(-S), k = Math.cos(-S), w = k * (r - this.sx[M]) - E * (o - this.sy[M]) + this.sx[M], O = E * (r - this.sx[M]) + k * (o - this.sy[M]) + this.sy[M];
        r = w, o = O, b = Math.abs(this.sx[M] - r) <= this.sw[M] / 2, L = Math.abs(this.sy[M] - o) <= this.sh[M] / 2;
      } else {
        const E = r - this.sx0[M], k = o - this.sy1[M];
        b = 0 <= E && E <= this.sw[M], L = 0 <= k && k <= this.sh[M];
      }
      b && L && A.push(M);
    }
    return new Selection({ indices: A });
  }
  _map_dist_corner_for_data_side_length(e, r, o) {
    const s = e.length, l = new Float64Array(s), c = new Float64Array(s);
    for (let Q = 0; Q < s; Q++) {
      const m = e[Q], g = r.get(Q) / 2;
      l[Q] = m - g, c[Q] = m + g;
    }
    const u = o.v_compute(l), d = o.v_compute(c), f = this.sdist(o, l, r, "edge", this.model.dilate);
    let T = u;
    for (let Q = 0; Q < s; Q++) {
      const m = u[Q], g = d[Q];
      if (!isNaN(m + g) && m != g) {
        T = m < g ? u : d;
        break;
      }
    }
    return [f, T];
  }
  _ddist(e, r, o) {
    const s = infer_type(r, o), l = e == 0 ? this.renderer.xscale : this.renderer.yscale, c = r, u = c.length, d = new s(u);
    for (let g = 0; g < u; g++)
      d[g] = c[g] + o[g];
    const f = l.v_invert(c), T = l.v_invert(d), Q = f.length, m = new s(Q);
    for (let g = 0; g < Q; g++)
      m[g] = Math.abs(T[g] - f[g]);
    return m;
  }
  draw_legend_for_index(e, r, o) {
    generic_area_vector_legend(this.visuals, e, r, o);
  }
}
RectView.__name__ = "RectView";
class Rect extends CenterRotatable {
  constructor(e) {
    super(e);
  }
}
_a$1_ = Rect;
Rect.__name__ = "Rect";
_a$1_.prototype.default_view = RectView, _a$1_.define(({ Boolean: t }) => ({
  dilate: [t, !1]
}));
var _a$1Z;
class MarkerView extends XYGlyphView {
  _render(e, r, o) {
    const { sx: s, sy: l, size: c, angle: u } = o != null ? o : this;
    for (const d of r) {
      const f = s[d], T = l[d], Q = c.get(d), m = u.get(d);
      if (!isFinite(f + T + Q + m))
        continue;
      const g = Q / 2;
      e.beginPath(), e.translate(f, T), m && e.rotate(m), this._render_one(e, d, g, this.visuals), m && e.rotate(-m), e.translate(-f, -T);
    }
  }
  _mask_data() {
    const { x_target: e, y_target: r } = this.renderer.plot_view.frame, o = e.widen(this.max_size).map((l) => this.renderer.xscale.invert(l)), s = r.widen(this.max_size).map((l) => this.renderer.yscale.invert(l));
    return this.index.indices({
      x0: o.start,
      x1: o.end,
      y0: s.start,
      y1: s.end
    });
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, { max_size: s } = this, { hit_dilation: l } = this.model, c = r - s * l, u = r + s * l, [d, f] = this.renderer.xscale.r_invert(c, u), T = o - s * l, Q = o + s * l, [m, g] = this.renderer.yscale.r_invert(T, Q), v = this.index.indices({ x0: d, x1: f, y0: m, y1: g }), b = [];
    for (const L of v) {
      const A = this.size.get(L) / 2 * l;
      Math.abs(this.sx[L] - r) <= A && Math.abs(this.sy[L] - o) <= A && b.push(L);
    }
    return new Selection({ indices: b });
  }
  _hit_span(e) {
    const { sx: r, sy: o } = e, s = this.bounds(), l = this.max_size / 2;
    let c, u, d, f;
    if (e.direction == "h") {
      d = s.y0, f = s.y1;
      const Q = r - l, m = r + l;
      [c, u] = this.renderer.xscale.r_invert(Q, m);
    } else {
      c = s.x0, u = s.x1;
      const Q = o - l, m = o + l;
      [d, f] = this.renderer.yscale.r_invert(Q, m);
    }
    const T = [...this.index.indices({ x0: c, x1: u, y0: d, y1: f })];
    return new Selection({ indices: T });
  }
  _hit_rect(e) {
    const { sx0: r, sx1: o, sy0: s, sy1: l } = e, [c, u] = this.renderer.xscale.r_invert(r, o), [d, f] = this.renderer.yscale.r_invert(s, l), T = [...this.index.indices({ x0: c, x1: u, y0: d, y1: f })];
    return new Selection({ indices: T });
  }
  _hit_poly(e) {
    const { sx: r, sy: o } = e, s = range(0, this.sx.length), l = [];
    for (let c = 0, u = s.length; c < u; c++) {
      const d = s[c];
      point_in_poly(this.sx[c], this.sy[c], r, o) && l.push(d);
    }
    return new Selection({ indices: l });
  }
  _get_legend_args({ x0: e, x1: r, y0: o, y1: s }, l) {
    const c = l + 1, u = new Array(c), d = new Array(c);
    u[l] = (e + r) / 2, d[l] = (o + s) / 2;
    const f = Math.min(Math.abs(r - e), Math.abs(s - o)) * 0.4, T = new UniformScalar(f, c), Q = new UniformScalar(0, c);
    return { sx: u, sy: d, size: T, angle: Q };
  }
  draw_legend_for_index(e, { x0: r, x1: o, y0: s, y1: l }, c) {
    const u = this._get_legend_args({ x0: r, x1: o, y0: s, y1: l }, c);
    this._render(e, [c], u);
  }
}
MarkerView.__name__ = "MarkerView";
class Marker extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$1Z = Marker;
Marker.__name__ = "Marker";
_a$1Z.mixins([LineVector$1, FillVector$1, HatchVector$1]), _a$1Z.define(({ Number: t }) => ({
  size: [ScreenSizeSpec, { value: 4 }],
  angle: [AngleSpec, 0],
  hit_dilation: [t, 1]
}));
const SQ3 = Math.sqrt(3), SQ5 = Math.sqrt(5), c36 = (SQ5 + 1) / 4, s36 = Math.sqrt((5 - SQ5) / 8), c72 = (SQ5 - 1) / 4, s72 = Math.sqrt((5 + SQ5) / 8);
function _one_line(t, e) {
  t.moveTo(-e, 0), t.lineTo(e, 0);
}
function _one_x(t, e) {
  t.rotate(Math.PI / 4), _one_cross(t, e), t.rotate(-Math.PI / 4);
}
function _one_y(t, e) {
  const r = e * SQ3, o = r / 3;
  t.moveTo(-r / 2, -o), t.lineTo(0, 0), t.lineTo(r / 2, -o), t.lineTo(0, 0), t.lineTo(0, e);
}
function _one_cross(t, e) {
  t.moveTo(0, e), t.lineTo(0, -e), t.moveTo(-e, 0), t.lineTo(e, 0);
}
function _one_dot(t, e) {
  t.beginPath(), t.arc(0, 0, e / 4, 0, 2 * Math.PI, !1), t.closePath();
}
function _one_diamond(t, e) {
  t.moveTo(0, e), t.lineTo(e / 1.5, 0), t.lineTo(0, -e), t.lineTo(-e / 1.5, 0), t.closePath();
}
function _one_hex(t, e) {
  const r = e / 2, o = SQ3 * r;
  t.moveTo(e, 0), t.lineTo(r, -o), t.lineTo(-r, -o), t.lineTo(-e, 0), t.lineTo(-r, o), t.lineTo(r, o), t.closePath();
}
function _one_star(t, e) {
  const r = Math.sqrt(5 - 2 * SQ5) * e;
  t.moveTo(0, -e), t.lineTo(r * c72, -e + r * s72), t.lineTo(r * (1 + c72), -e + r * s72), t.lineTo(r * (1 + c72 - c36), -e + r * (s72 + s36)), t.lineTo(r * (1 + 2 * c72 - c36), -e + r * (2 * s72 + s36)), t.lineTo(0, -e + r * 2 * s72), t.lineTo(-r * (1 + 2 * c72 - c36), -e + r * (2 * s72 + s36)), t.lineTo(-r * (1 + c72 - c36), -e + r * (s72 + s36)), t.lineTo(-r * (1 + c72), -e + r * s72), t.lineTo(-r * c72, -e + r * s72), t.closePath();
}
function _one_tri(t, e) {
  const r = e * SQ3, o = r / 3;
  t.moveTo(-e, o), t.lineTo(e, o), t.lineTo(0, o - r), t.closePath();
}
function asterisk(t, e, r, o) {
  _one_cross(t, r), _one_x(t, r), o.line.apply(t, e);
}
function circle$1(t, e, r, o) {
  t.arc(0, 0, r, 0, 2 * Math.PI, !1), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function circle_cross(t, e, r, o) {
  t.arc(0, 0, r, 0, 2 * Math.PI, !1), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.doit && (o.line.set_vectorize(t, e), _one_cross(t, r), t.stroke());
}
function circle_dot(t, e, r, o) {
  circle$1(t, e, r, o), dot(t, e, r, o);
}
function circle_y(t, e, r, o) {
  t.arc(0, 0, r, 0, 2 * Math.PI, !1), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.doit && (o.line.set_vectorize(t, e), _one_y(t, r), t.stroke());
}
function circle_x(t, e, r, o) {
  t.arc(0, 0, r, 0, 2 * Math.PI, !1), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.doit && (o.line.set_vectorize(t, e), _one_x(t, r), t.stroke());
}
function cross(t, e, r, o) {
  _one_cross(t, r), o.line.apply(t, e);
}
function diamond(t, e, r, o) {
  _one_diamond(t, r), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function diamond_cross(t, e, r, o) {
  _one_diamond(t, r), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.doit && (o.line.set_vectorize(t, e), t.moveTo(0, r), t.lineTo(0, -r), t.moveTo(-r / 1.5, 0), t.lineTo(r / 1.5, 0), t.stroke());
}
function diamond_dot(t, e, r, o) {
  diamond(t, e, r, o), dot(t, e, r, o);
}
function dot(t, e, r, o) {
  _one_dot(t, r), o.line.set_vectorize(t, e), t.fillStyle = t.strokeStyle, t.fill();
}
function hex(t, e, r, o) {
  _one_hex(t, r), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function hex_dot(t, e, r, o) {
  hex(t, e, r, o), dot(t, e, r, o);
}
function inverted_triangle(t, e, r, o) {
  t.rotate(Math.PI), _one_tri(t, r), t.rotate(-Math.PI), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function plus(t, e, r, o) {
  const s = 3 * r / 8, l = r, c = [s, s, l, l, s, s, -s, -s, -l, -l, -s, -s], u = [l, s, s, -s, -s, -l, -l, -s, -s, s, s, l];
  t.beginPath();
  for (let d = 0; d < 12; d++)
    t.lineTo(c[d], u[d]);
  t.closePath(), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function square(t, e, r, o) {
  const s = 2 * r;
  t.rect(-r, -r, s, s), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function square_pin(t, e, r, o) {
  const s = 3 * r / 8;
  t.moveTo(-r, -r), t.quadraticCurveTo(0, -s, r, -r), t.quadraticCurveTo(s, 0, r, r), t.quadraticCurveTo(0, s, -r, r), t.quadraticCurveTo(-s, 0, -r, -r), t.closePath(), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function square_cross(t, e, r, o) {
  const s = 2 * r;
  t.rect(-r, -r, s, s), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.doit && (o.line.set_vectorize(t, e), _one_cross(t, r), t.stroke());
}
function square_dot(t, e, r, o) {
  square(t, e, r, o), dot(t, e, r, o);
}
function square_x(t, e, r, o) {
  const s = 2 * r;
  t.rect(-r, -r, s, s), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.doit && (o.line.set_vectorize(t, e), t.moveTo(-r, r), t.lineTo(r, -r), t.moveTo(-r, -r), t.lineTo(r, r), t.stroke());
}
function star(t, e, r, o) {
  _one_star(t, r), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function star_dot(t, e, r, o) {
  star(t, e, r, o), dot(t, e, r, o);
}
function triangle(t, e, r, o) {
  _one_tri(t, r), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function triangle_dot(t, e, r, o) {
  triangle(t, e, r, o), dot(t, e, r, o);
}
function triangle_pin(t, e, r, o) {
  const s = r * SQ3, l = s / 3, c = 3 * l / 8;
  t.moveTo(-r, l), t.quadraticCurveTo(0, c, r, l), t.quadraticCurveTo(SQ3 * c / 2, c / 2, 0, l - s), t.quadraticCurveTo(-SQ3 * c / 2, c / 2, -r, l), t.closePath(), o.fill.apply(t, e), o.hatch.apply(t, e), o.line.apply(t, e);
}
function dash(t, e, r, o) {
  _one_line(t, r), o.line.apply(t, e);
}
function x(t, e, r, o) {
  _one_x(t, r), o.line.apply(t, e);
}
function y(t, e, r, o) {
  _one_y(t, r), o.line.apply(t, e);
}
const marker_funcs = {
  asterisk,
  circle: circle$1,
  circle_cross,
  circle_dot,
  circle_y,
  circle_x,
  cross,
  diamond,
  diamond_dot,
  diamond_cross,
  dot,
  hex,
  hex_dot,
  inverted_triangle,
  plus,
  square,
  square_cross,
  square_dot,
  square_pin,
  square_x,
  star,
  star_dot,
  triangle,
  triangle_dot,
  triangle_pin,
  dash,
  x,
  y
};
var _a$1Y;
class ScatterView extends MarkerView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl: e } = this.renderer.plot_view.canvas_view;
    if (e != null && e.regl_wrapper.has_webgl) {
      const { MultiMarkerGL: r } = await Promise.resolve().then(() => multi_marker);
      this.glglyph = new r(e.regl_wrapper, this);
    }
  }
  _render(e, r, o) {
    const { sx: s, sy: l, size: c, angle: u, marker: d } = o != null ? o : this;
    for (const f of r) {
      const T = s[f], Q = l[f], m = c.get(f), g = u.get(f), v = d.get(f);
      if (!isFinite(T + Q + m + g) || v == null)
        continue;
      const b = m / 2;
      e.beginPath(), e.translate(T, Q), g && e.rotate(g), marker_funcs[v](e, f, b, this.visuals), g && e.rotate(-g), e.translate(-T, -Q);
    }
  }
  draw_legend_for_index(e, { x0: r, x1: o, y0: s, y1: l }, c) {
    const u = c + 1, d = this.marker.get(c), f = {
      ...this._get_legend_args({ x0: r, x1: o, y0: s, y1: l }, c),
      marker: new UniformScalar(d, u)
    };
    this._render(e, [c], f);
  }
}
ScatterView.__name__ = "ScatterView";
class Scatter extends Marker {
  constructor(e) {
    super(e);
  }
}
_a$1Y = Scatter;
Scatter.__name__ = "Scatter";
_a$1Y.prototype.default_view = ScatterView, _a$1Y.define(() => ({
  marker: [MarkerSpec, { value: "circle" }]
}));
var _a$1X;
class SegmentView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._x0, this._y0), inplace.project_xy(this._x1, this._y1);
  }
  _index_data(e) {
    const { min: r, max: o } = Math, { _x0: s, _x1: l, _y0: c, _y1: u, data_size: d } = this;
    for (let f = 0; f < d; f++) {
      const T = s[f], Q = l[f], m = c[f], g = u[f];
      e.add_rect(r(T, Q), r(m, g), o(T, Q), o(m, g));
    }
  }
  _render(e, r, o) {
    if (this.visuals.line.doit) {
      const { sx0: s, sy0: l, sx1: c, sy1: u } = o != null ? o : this;
      for (const d of r) {
        const f = s[d], T = l[d], Q = c[d], m = u[d];
        !isFinite(f + T + Q + m) || (e.beginPath(), e.moveTo(f, T), e.lineTo(Q, m), this.visuals.line.set_vectorize(e, d), e.stroke());
      }
    }
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = { x: r, y: o }, l = 2, [c, u] = this.renderer.xscale.r_invert(r - l, r + l), [d, f] = this.renderer.yscale.r_invert(o - l, o + l), T = this.index.indices({ x0: c, y0: d, x1: u, y1: f }), Q = [];
    for (const m of T) {
      const g = Math.max(2, this.line_width.get(m) / 2) ** 2, v = { x: this.sx0[m], y: this.sy0[m] }, b = { x: this.sx1[m], y: this.sy1[m] };
      dist_to_segment_squared(s, v, b) < g && Q.push(m);
    }
    return new Selection({ indices: Q });
  }
  _hit_span(e) {
    const [r, o] = this.renderer.plot_view.frame.bbox.ranges, { sx: s, sy: l } = e;
    let c, u, d;
    e.direction == "v" ? (d = this.renderer.yscale.invert(l), [c, u] = [this._y0, this._y1]) : (d = this.renderer.xscale.invert(s), [c, u] = [this._x0, this._x1]);
    const f = [], [T, Q] = this.renderer.xscale.r_invert(r.start, r.end), [m, g] = this.renderer.yscale.r_invert(o.start, o.end), v = this.index.indices({ x0: T, y0: m, x1: Q, y1: g });
    for (const b of v) {
      (c[b] <= d && d <= u[b] || u[b] <= d && d <= c[b]) && f.push(b);
      const L = 1.5 + this.line_width.get(b) / 2;
      c[b] == u[b] && (e.direction == "h" ? Math.abs(this.sx0[b] - s) <= L && f.push(b) : Math.abs(this.sy0[b] - l) <= L && f.push(b));
    }
    return new Selection({ indices: f });
  }
  scenterxy(e) {
    const r = this.sx0[e] / 2 + this.sx1[e] / 2, o = this.sy0[e] / 2 + this.sy1[e] / 2;
    return [r, o];
  }
  draw_legend_for_index(e, r, o) {
    generic_line_vector_legend(this.visuals, e, r, o);
  }
}
SegmentView.__name__ = "SegmentView";
class Segment extends Glyph {
  constructor(e) {
    super(e);
  }
}
_a$1X = Segment;
Segment.__name__ = "Segment";
_a$1X.prototype.default_view = SegmentView, _a$1X.define(({}) => ({
  x0: [XCoordinateSpec, { field: "x0" }],
  y0: [YCoordinateSpec, { field: "y0" }],
  x1: [XCoordinateSpec, { field: "x1" }],
  y1: [YCoordinateSpec, { field: "y1" }]
})), _a$1X.mixins(LineVector$1);
function catmullrom_spline(t, e, r = 10, o = 0.5, s = !1) {
  assert(t.length == e.length);
  const l = t.length, c = s ? l + 1 : l, u = infer_type(t, e), d = new u(c + 2), f = new u(c + 2);
  d.set(t, 1), f.set(e, 1), s ? (d[0] = t[l - 1], f[0] = e[l - 1], d[c] = t[0], f[c] = e[0], d[c + 1] = t[1], f[c + 1] = e[1]) : (d[0] = t[0], f[0] = e[0], d[c + 1] = t[l - 1], f[c + 1] = e[l - 1]);
  const T = new u(4 * (r + 1));
  for (let g = 0, v = 0; g <= r; g++) {
    const b = g / r, L = b ** 2, A = b * L;
    T[v++] = 2 * A - 3 * L + 1, T[v++] = -2 * A + 3 * L, T[v++] = A - 2 * L + b, T[v++] = A - L;
  }
  const Q = new u((c - 1) * (r + 1)), m = new u((c - 1) * (r + 1));
  for (let g = 1, v = 0; g < c; g++) {
    const b = (d[g + 1] - d[g - 1]) * o, L = (f[g + 1] - f[g - 1]) * o, A = (d[g + 2] - d[g]) * o, M = (f[g + 2] - f[g]) * o;
    for (let S = 0; S <= 4 * r; v++) {
      const E = T[S++], k = T[S++], w = T[S++], O = T[S++];
      Q[v] = E * d[g] + k * d[g + 1] + w * b + O * A, m[v] = E * f[g] + k * f[g + 1] + w * L + O * M;
    }
  }
  return [Q, m];
}
var _a$1W;
class SplineView extends XYGlyphView {
  _set_data() {
    const { tension: e, closed: r } = this.model;
    [this._xt, this._yt] = catmullrom_spline(this._x, this._y, 20, e, r);
  }
  _map_data() {
    const { x_scale: e, y_scale: r } = this.renderer.coordinates;
    this.sxt = e.v_compute(this._xt), this.syt = r.v_compute(this._yt);
  }
  _render(e, r, o) {
    const { sxt: s, syt: l } = o != null ? o : this;
    let c = !0;
    e.beginPath();
    const u = s.length;
    for (let d = 0; d < u; d++) {
      const f = s[d], T = l[d];
      isFinite(f + T) ? c ? (e.moveTo(f, T), c = !1) : e.lineTo(f, T) : c = !0;
    }
    this.visuals.line.set_value(e), e.stroke();
  }
}
SplineView.__name__ = "SplineView";
class Spline extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$1W = Spline;
Spline.__name__ = "Spline";
_a$1W.prototype.default_view = SplineView, _a$1W.mixins(LineScalar$1), _a$1W.define(({ Boolean: t, Number: e }) => ({
  tension: [e, 0.5],
  closed: [t, !1]
}));
var _a$1V;
class StepView extends XYGlyphView {
  _render(e, r, o) {
    const { sx: s, sy: l } = o != null ? o : this;
    let c = !1, u = null;
    this.visuals.line.set_value(e);
    const d = r.length;
    if (!(d < 2)) {
      e.beginPath(), e.moveTo(s[0], l[0]);
      for (const f of r) {
        let T, Q, m, g;
        switch (this.model.mode) {
          case "before": {
            [T, m] = [s[f - 1], l[f]], [Q, g] = [s[f], l[f]];
            break;
          }
          case "after": {
            [T, m] = [s[f], l[f - 1]], [Q, g] = [s[f], l[f]];
            break;
          }
          case "center": {
            const v = (s[f - 1] + s[f]) / 2;
            [T, m] = [v, l[f - 1]], [Q, g] = [v, l[f]];
            break;
          }
          default:
            unreachable();
        }
        if (c) {
          if (!isFinite(s[f] + l[f])) {
            e.stroke(), e.beginPath(), c = !1, u = f;
            continue;
          }
          u != null && f - u > 1 && (e.stroke(), c = !1);
        }
        c ? (e.lineTo(T, m), e.lineTo(Q, g)) : (e.beginPath(), e.moveTo(s[f], l[f]), c = !0), u = f;
      }
      e.lineTo(s[d - 1], l[d - 1]), e.stroke();
    }
  }
  draw_legend_for_index(e, r, o) {
    generic_line_scalar_legend(this.visuals, e, r);
  }
}
StepView.__name__ = "StepView";
class Step extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$1V = Step;
Step.__name__ = "Step";
_a$1V.prototype.default_view = StepView, _a$1V.mixins(LineScalar$1), _a$1V.define(() => ({
  mode: [StepMode, "before"]
}));
var _a$1U;
class TextView$1 extends XYGlyphView {
  _rotate_point(e, r, o, s, l) {
    const c = (e - o) * Math.cos(l) - (r - s) * Math.sin(l) + o, u = (e - o) * Math.sin(l) + (r - s) * Math.cos(l) + s;
    return [c, u];
  }
  _text_bounds(e, r, o, s) {
    const l = [e, e + o, e + o, e, e], c = [r, r, r - s, r - s, r];
    return [l, c];
  }
  _render(e, r, o) {
    const { sx: s, sy: l, x_offset: c, y_offset: u, angle: d, text: f } = o != null ? o : this;
    this._sys = [], this._sxs = [];
    for (const T of r) {
      const Q = this._sxs[T] = [], m = this._sys[T] = [], g = s[T], v = l[T], b = c.get(T), L = u.get(T), A = d.get(T), M = f.get(T);
      if (!(!isFinite(g + v + b + L + A) || M == null) && this.visuals.text.doit) {
        const S = `${M}`;
        e.save(), e.translate(g + b, v + L), e.rotate(A), this.visuals.text.set_vectorize(e, T);
        const E = this.visuals.text.font_value(T), { height: k } = font_metrics(E), w = this.text_line_height.get(T) * k;
        if (S.indexOf(`
`) == -1) {
          e.fillText(S, 0, 0);
          const O = g + b, D = v + L, R = e.measureText(S).width, [B, F] = this._text_bounds(O, D, R, w);
          Q.push(B), m.push(F);
        } else {
          const O = S.split(`
`), D = w * O.length, R = this.text_baseline.get(T);
          let B;
          switch (R) {
            case "top": {
              B = 0;
              break;
            }
            case "middle": {
              B = -D / 2 + w / 2;
              break;
            }
            case "bottom": {
              B = -D + w;
              break;
            }
            default:
              B = 0, console.warn(`'${R}' baseline not supported with multi line text`);
          }
          for (const F of O) {
            e.fillText(F, 0, B);
            const j = g + b, z = B + v + L, q = e.measureText(F).width, [I, U] = this._text_bounds(j, z, q, w);
            Q.push(I), m.push(U), B += w;
          }
        }
        e.restore();
      }
    }
  }
  _hit_point(e) {
    const { sx: r, sy: o } = e, s = [];
    for (let l = 0; l < this._sxs.length; l++) {
      const c = this._sxs[l], u = this._sys[l], d = c.length;
      for (let f = 0, T = d; f < T; f++) {
        const [Q, m] = this._rotate_point(r, o, c[d - 1][0], u[d - 1][0], -this.angle.get(l));
        point_in_poly(Q, m, c[f], u[f]) && s.push(l);
      }
    }
    return new Selection({ indices: s });
  }
  scenterxy(e) {
    const r = this._sxs[e], o = this._sys[e];
    assert(r.length != 0 && o.length != 0);
    const s = r[0][0], l = o[0][0], c = (r[0][2] + s) / 2, u = (o[0][2] + l) / 2, [d, f] = this._rotate_point(c, u, s, l, this.angle.get(e));
    return [d, f];
  }
}
TextView$1.__name__ = "TextView";
class Text$1 extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$1U = Text$1;
Text$1.__name__ = "Text";
_a$1U.prototype.default_view = TextView$1, _a$1U.mixins(TextVector$1), _a$1U.define(({}) => ({
  text: [NullStringSpec, { field: "text" }],
  angle: [AngleSpec, 0],
  x_offset: [NumberSpec, 0],
  y_offset: [NumberSpec, 0]
}));
var _a$1T;
class VBarView extends BoxView$1 {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl: e } = this.renderer.plot_view.canvas_view;
    if (e != null && e.regl_wrapper.has_webgl) {
      const { LRTBGL: r } = await Promise.resolve().then(() => lrtb);
      this.glglyph = new r(e.regl_wrapper, this);
    }
  }
  scenterxy(e) {
    const r = this.sx[e], o = (this.stop[e] + this.sbottom[e]) / 2;
    return [r, o];
  }
  _lrtb(e) {
    const r = this.width.get(e) / 2, o = this._x[e], s = this._top[e], l = this._bottom[e], c = o - r, u = o + r, d = Math.max(s, l), f = Math.min(s, l);
    return [c, u, d, f];
  }
  _map_data() {
    this.sx = this.renderer.xscale.v_compute(this._x), this.sw = this.sdist(this.renderer.xscale, this._x, this.width, "center"), this.stop = this.renderer.yscale.v_compute(this._top), this.sbottom = this.renderer.yscale.v_compute(this._bottom);
    const e = this.sx.length;
    this.sleft = new ScreenArray(e), this.sright = new ScreenArray(e);
    for (let r = 0; r < e; r++)
      this.sleft[r] = this.sx[r] - this.sw[r] / 2, this.sright[r] = this.sx[r] + this.sw[r] / 2;
    this._clamp_viewport();
  }
}
VBarView.__name__ = "VBarView";
class VBar extends Box$1 {
  constructor(e) {
    super(e);
  }
}
_a$1T = VBar;
VBar.__name__ = "VBar";
_a$1T.prototype.default_view = VBarView, _a$1T.define(({}) => ({
  x: [XCoordinateSpec, { field: "x" }],
  bottom: [YCoordinateSpec, { value: 0 }],
  width: [NumberSpec, { value: 1 }],
  top: [YCoordinateSpec, { field: "top" }]
}));
var _a$1S;
class WedgeView extends XYGlyphView {
  _map_data() {
    this.model.properties.radius.units == "data" ? this.sradius = this.sdist(this.renderer.xscale, this._x, this.radius) : this.sradius = to_screen(this.radius), this.max_sradius = max$8(this.sradius);
  }
  _render(e, r, o) {
    const { sx: s, sy: l, sradius: c, start_angle: u, end_angle: d } = o != null ? o : this, f = this.model.direction == "anticlock";
    for (const T of r) {
      const Q = s[T], m = l[T], g = c[T], v = u.get(T), b = d.get(T);
      !isFinite(Q + m + g + v + b) || (e.beginPath(), e.arc(Q, m, g, v, b, f), e.lineTo(Q, m), e.closePath(), this.visuals.fill.apply(e, T), this.visuals.hatch.apply(e, T), this.visuals.line.apply(e, T));
    }
  }
  _hit_point(e) {
    let r, o, s, l, c;
    const { sx: u, sy: d } = e, f = this.renderer.xscale.invert(u), T = this.renderer.yscale.invert(d);
    o = u - this.max_sradius, s = u + this.max_sradius;
    const [Q, m] = this.renderer.xscale.r_invert(o, s);
    l = d - this.max_sradius, c = d + this.max_sradius;
    const [g, v] = this.renderer.yscale.r_invert(l, c), b = [];
    for (const M of this.index.indices({ x0: Q, x1: m, y0: g, y1: v })) {
      const S = this.sradius[M] ** 2;
      [o, s] = this.renderer.xscale.r_compute(f, this._x[M]), [l, c] = this.renderer.yscale.r_compute(T, this._y[M]), r = (o - s) ** 2 + (l - c) ** 2, r <= S && b.push(M);
    }
    const L = this.model.direction == "anticlock", A = [];
    for (const M of b) {
      const S = Math.atan2(d - this.sy[M], u - this.sx[M]);
      angle_between(-S, -this.start_angle.get(M), -this.end_angle.get(M), L) && A.push(M);
    }
    return new Selection({ indices: A });
  }
  draw_legend_for_index(e, r, o) {
    generic_area_vector_legend(this.visuals, e, r, o);
  }
  scenterxy(e) {
    const r = this.sradius[e] / 2, o = (this.start_angle.get(e) + this.end_angle.get(e)) / 2, s = this.sx[e] + r * Math.cos(o), l = this.sy[e] + r * Math.sin(o);
    return [s, l];
  }
}
WedgeView.__name__ = "WedgeView";
class Wedge extends XYGlyph {
  constructor(e) {
    super(e);
  }
}
_a$1S = Wedge;
Wedge.__name__ = "Wedge";
_a$1S.prototype.default_view = WedgeView, _a$1S.mixins([LineVector$1, FillVector$1, HatchVector$1]), _a$1S.define(({}) => ({
  direction: [Direction$1, "anticlock"],
  radius: [DistanceSpec, { field: "radius" }],
  start_angle: [AngleSpec, { field: "start_angle" }],
  end_angle: [AngleSpec, { field: "end_angle" }]
}));
class GraphHitTestPolicy extends Model {
  constructor(e) {
    super(e);
  }
  _hit_test(e, r, o) {
    if (!r.model.visible)
      return null;
    const s = o.glyph.hit_test(e);
    return s == null ? null : o.model.view.convert_selection_from_subset(s);
  }
}
GraphHitTestPolicy.__name__ = "GraphHitTestPolicy";
class EdgesOnly extends GraphHitTestPolicy {
  constructor(e) {
    super(e);
  }
  hit_test(e, r) {
    return this._hit_test(e, r, r.edge_view);
  }
  do_selection(e, r, o, s) {
    if (e == null)
      return !1;
    const l = r.edge_renderer.data_source.selected;
    return l.update(e, o, s), r.edge_renderer.data_source._select.emit(), !l.is_empty();
  }
  do_inspection(e, r, o, s, l) {
    if (e == null)
      return !1;
    const { edge_renderer: c } = o.model, u = c.get_selection_manager().get_or_create_inspector(o.edge_view.model);
    return u.update(e, s, l), o.edge_view.model.data_source.setv({ inspected: u }, { silent: !0 }), o.edge_view.model.data_source.inspect.emit([o.edge_view.model, { geometry: r }]), !u.is_empty();
  }
}
EdgesOnly.__name__ = "EdgesOnly";
class NodesOnly extends GraphHitTestPolicy {
  constructor(e) {
    super(e);
  }
  hit_test(e, r) {
    return this._hit_test(e, r, r.node_view);
  }
  do_selection(e, r, o, s) {
    if (e == null)
      return !1;
    const l = r.node_renderer.data_source.selected;
    return l.update(e, o, s), r.node_renderer.data_source._select.emit(), !l.is_empty();
  }
  do_inspection(e, r, o, s, l) {
    if (e == null)
      return !1;
    const { node_renderer: c } = o.model, u = c.get_selection_manager().get_or_create_inspector(o.node_view.model);
    return u.update(e, s, l), o.node_view.model.data_source.setv({ inspected: u }, { silent: !0 }), o.node_view.model.data_source.inspect.emit([o.node_view.model, { geometry: r }]), !u.is_empty();
  }
}
NodesOnly.__name__ = "NodesOnly";
class NodesAndLinkedEdges extends GraphHitTestPolicy {
  constructor(e) {
    super(e);
  }
  hit_test(e, r) {
    return this._hit_test(e, r, r.node_view);
  }
  get_linked_edges(e, r, o) {
    let s = [];
    o == "selection" ? s = e.selected.indices.map((u) => e.data.index[u]) : o == "inspection" && (s = e.inspected.indices.map((u) => e.data.index[u]));
    const l = [];
    for (let u = 0; u < r.data.start.length; u++)
      (contains(s, r.data.start[u]) || contains(s, r.data.end[u])) && l.push(u);
    const c = new Selection();
    for (const u of l)
      c.multiline_indices[u] = [0];
    return c.indices = l, c;
  }
  do_selection(e, r, o, s) {
    if (e == null)
      return !1;
    const l = r.node_renderer.data_source.selected;
    l.update(e, o, s);
    const c = r.edge_renderer.data_source.selected, u = this.get_linked_edges(r.node_renderer.data_source, r.edge_renderer.data_source, "selection");
    return c.update(u, o, s), r.node_renderer.data_source._select.emit(), !l.is_empty();
  }
  do_inspection(e, r, o, s, l) {
    if (e == null)
      return !1;
    const c = o.node_view.model.data_source.selection_manager.get_or_create_inspector(o.node_view.model);
    c.update(e, s, l), o.node_view.model.data_source.setv({ inspected: c }, { silent: !0 });
    const u = o.edge_view.model.data_source.selection_manager.get_or_create_inspector(o.edge_view.model), d = this.get_linked_edges(o.node_view.model.data_source, o.edge_view.model.data_source, "inspection");
    return u.update(d, s, l), o.edge_view.model.data_source.setv({ inspected: u }, { silent: !0 }), o.node_view.model.data_source.inspect.emit([o.node_view.model, { geometry: r }]), !c.is_empty();
  }
}
NodesAndLinkedEdges.__name__ = "NodesAndLinkedEdges";
class EdgesAndLinkedNodes extends GraphHitTestPolicy {
  constructor(e) {
    super(e);
  }
  hit_test(e, r) {
    return this._hit_test(e, r, r.edge_view);
  }
  get_linked_nodes(e, r, o) {
    let s = [];
    o == "selection" ? s = r.selected.indices : o == "inspection" && (s = r.inspected.indices);
    const l = [];
    for (const u of s)
      l.push(r.data.start[u]), l.push(r.data.end[u]);
    const c = uniq(l).map((u) => indexOf(e.data.index, u));
    return new Selection({ indices: c });
  }
  do_selection(e, r, o, s) {
    if (e == null)
      return !1;
    const l = r.edge_renderer.data_source.selected;
    l.update(e, o, s);
    const c = r.node_renderer.data_source.selected, u = this.get_linked_nodes(r.node_renderer.data_source, r.edge_renderer.data_source, "selection");
    return c.update(u, o, s), r.edge_renderer.data_source._select.emit(), !l.is_empty();
  }
  do_inspection(e, r, o, s, l) {
    if (e == null)
      return !1;
    const c = o.edge_view.model.data_source.selection_manager.get_or_create_inspector(o.edge_view.model);
    c.update(e, s, l), o.edge_view.model.data_source.setv({ inspected: c }, { silent: !0 });
    const u = o.node_view.model.data_source.selection_manager.get_or_create_inspector(o.node_view.model), d = this.get_linked_nodes(o.node_view.model.data_source, o.edge_view.model.data_source, "inspection");
    return u.update(d, s, l), o.node_view.model.data_source.setv({ inspected: u }, { silent: !0 }), o.edge_view.model.data_source.inspect.emit([o.edge_view.model, { geometry: r }]), !c.is_empty();
  }
}
EdgesAndLinkedNodes.__name__ = "EdgesAndLinkedNodes";
var _a$1R;
class LayoutProvider extends Model {
  constructor(e) {
    super(e);
  }
  get node_coordinates() {
    return new NodeCoordinates({ layout: this });
  }
  get edge_coordinates() {
    return new EdgeCoordinates({ layout: this });
  }
}
LayoutProvider.__name__ = "LayoutProvider";
class GraphCoordinates extends CoordinateTransform {
  constructor(e) {
    super(e);
  }
}
_a$1R = GraphCoordinates;
GraphCoordinates.__name__ = "GraphCoordinates";
_a$1R.define(({ Ref: t }) => ({
  layout: [t(LayoutProvider)]
}));
class NodeCoordinates extends GraphCoordinates {
  constructor(e) {
    super(e);
  }
  _v_compute(e) {
    const [r, o] = this.layout.get_node_coordinates(e);
    return { x: r, y: o };
  }
}
NodeCoordinates.__name__ = "NodeCoordinates";
class EdgeCoordinates extends GraphCoordinates {
  constructor(e) {
    super(e);
  }
  _v_compute(e) {
    const [r, o] = this.layout.get_edge_coordinates(e);
    return { x: r, y: o };
  }
}
EdgeCoordinates.__name__ = "EdgeCoordinates";
var _a$1Q;
class StaticLayoutProvider extends LayoutProvider {
  constructor(e) {
    super(e);
  }
  get_node_coordinates(e) {
    var c;
    const r = (c = e.data.index) != null ? c : [], o = r.length, s = new Float64Array(o), l = new Float64Array(o);
    for (let u = 0; u < o; u++) {
      const d = this.graph_layout[r[u]], [f, T] = d != null ? d : [NaN, NaN];
      s[u] = f, l[u] = T;
    }
    return [s, l];
  }
  get_edge_coordinates(e) {
    var d, f;
    const r = (d = e.data.start) != null ? d : [], o = (f = e.data.end) != null ? f : [], s = Math.min(r.length, o.length), l = [], c = [], u = e.data.xs != null && e.data.ys != null;
    for (let T = 0; T < s; T++) {
      const Q = this.graph_layout[r[T]] != null && this.graph_layout[o[T]] != null;
      if (u && Q)
        l.push(e.data.xs[T]), c.push(e.data.ys[T]);
      else {
        let m, g;
        Q ? (m = this.graph_layout[r[T]], g = this.graph_layout[o[T]]) : (m = [NaN, NaN], g = [NaN, NaN]), l.push([m[0], g[0]]), c.push([m[1], g[1]]);
      }
    }
    return [l, c];
  }
}
_a$1Q = StaticLayoutProvider;
StaticLayoutProvider.__name__ = "StaticLayoutProvider";
_a$1Q.define(({ Number: t, Tuple: e, Dict: r }) => ({
  graph_layout: [r(e(t, t)), {}]
}));
var _a$1P;
class GridView extends GuideRendererView {
  _render() {
    const e = this.layer.ctx;
    e.save(), this._draw_regions(e), this._draw_minor_grids(e), this._draw_grids(e), e.restore();
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.change, () => this.request_render());
  }
  _draw_regions(e) {
    if (!this.visuals.band_fill.doit && !this.visuals.band_hatch.doit)
      return;
    const [r, o] = this.grid_coords("major", !1);
    for (let s = 0; s < r.length - 1; s++) {
      if (s % 2 != 1)
        continue;
      const [l, c] = this.coordinates.map_to_screen(r[s], o[s]), [u, d] = this.coordinates.map_to_screen(r[s + 1], o[s + 1]);
      e.beginPath(), e.rect(l[0], c[0], u[1] - l[0], d[1] - c[0]), this.visuals.band_fill.apply(e), this.visuals.band_hatch.apply(e);
    }
  }
  _draw_grids(e) {
    if (!this.visuals.grid_line.doit)
      return;
    const [r, o] = this.grid_coords("major");
    this._draw_grid_helper(e, this.visuals.grid_line, r, o);
  }
  _draw_minor_grids(e) {
    if (!this.visuals.minor_grid_line.doit)
      return;
    const [r, o] = this.grid_coords("minor");
    this._draw_grid_helper(e, this.visuals.minor_grid_line, r, o);
  }
  _draw_grid_helper(e, r, o, s) {
    r.set_value(e), e.beginPath();
    for (let l = 0; l < o.length; l++) {
      const [c, u] = this.coordinates.map_to_screen(o[l], s[l]);
      e.moveTo(Math.round(c[0]), Math.round(u[0]));
      for (let d = 1; d < c.length; d++)
        e.lineTo(Math.round(c[d]), Math.round(u[d]));
    }
    e.stroke();
  }
  ranges() {
    const e = this.model.dimension, r = (e + 1) % 2, { ranges: o } = this.coordinates;
    return [o[e], o[r]];
  }
  computed_bounds() {
    const [e] = this.ranges(), r = this.model.bounds, o = [e.min, e.max];
    let s, l;
    if (isArray(r))
      s = Math.min(r[0], r[1]), l = Math.max(r[0], r[1]), s < o[0] && (s = o[0]), l > o[1] && (l = o[1]);
    else {
      [s, l] = o;
      for (const c of this.plot_view.axis_views)
        c.dimension == this.model.dimension && c.model.x_range_name == this.model.x_range_name && c.model.y_range_name == this.model.y_range_name && ([s, l] = c.computed_bounds);
    }
    return [s, l];
  }
  grid_coords(e, r = !0) {
    const o = this.model.dimension, s = (o + 1) % 2, [l, c] = this.ranges();
    let [u, d] = this.computed_bounds();
    [u, d] = [Math.min(u, d), Math.max(u, d)];
    const f = [[], []], T = this.model.get_ticker();
    if (T == null)
      return f;
    const Q = T.get_ticks(u, d, l, c.min)[e], m = l.min, g = l.max, v = c.min, b = c.max;
    r || (Q[0] != m && Q.splice(0, 0, m), Q[Q.length - 1] != g && Q.push(g));
    for (let L = 0; L < Q.length; L++) {
      if ((Q[L] == m || Q[L] == g) && r)
        continue;
      const A = [], M = [], S = 2;
      for (let E = 0; E < S; E++) {
        const k = v + (b - v) / (S - 1) * E;
        A.push(Q[L]), M.push(k);
      }
      f[o].push(A), f[s].push(M);
    }
    return f;
  }
}
GridView.__name__ = "GridView";
class Grid extends GuideRenderer {
  constructor(e) {
    super(e);
  }
  get_ticker() {
    return this.ticker != null ? this.ticker : this.axis != null ? this.axis.ticker : null;
  }
}
_a$1P = Grid;
Grid.__name__ = "Grid";
_a$1P.prototype.default_view = GridView, _a$1P.mixins([
  ["grid_", Line$2],
  ["minor_grid_", Line$2],
  ["band_", Fill$1],
  ["band_", Hatch$1]
]), _a$1P.define(({ Number: t, Auto: e, Enum: r, Ref: o, Tuple: s, Or: l, Nullable: c }) => ({
  bounds: [l(s(t, t), e), "auto"],
  dimension: [r(0, 1), 0],
  axis: [c(o(Axis)), null],
  ticker: [c(o(Ticker)), null]
})), _a$1P.override({
  level: "underlay",
  band_fill_color: null,
  band_fill_alpha: 0,
  grid_line_color: "#e5e5e5",
  minor_grid_line_color: null
});
var _a$1O;
class LayoutDOMView extends DOMView {
  constructor() {
    super(...arguments), this._offset_parent = null, this._viewport = {};
  }
  get is_layout_root() {
    return this.is_root || !(this.parent instanceof LayoutDOMView);
  }
  get base_font_size() {
    const e = getComputedStyle(this.el).fontSize, r = parse_css_font_size(e);
    if (r != null) {
      const { value: o, unit: s } = r;
      if (s == "px")
        return o;
    }
    return null;
  }
  initialize() {
    super.initialize(), this.el.style.position = this.is_layout_root ? "relative" : "absolute", this._child_views = /* @__PURE__ */ new Map();
  }
  async lazy_initialize() {
    await super.lazy_initialize(), await this.build_child_views();
  }
  remove() {
    for (const e of this.child_views)
      e.remove();
    this._child_views.clear(), super.remove();
  }
  connect_signals() {
    super.connect_signals(), this.is_layout_root && (this._on_resize = () => this.resize_layout(), window.addEventListener("resize", this._on_resize), this._parent_observer = setInterval(() => {
      const r = this.el.offsetParent;
      this._offset_parent != r && (this._offset_parent = r, r != null && (this.compute_viewport(), this.invalidate_layout()));
    }, 250));
    const e = this.model.properties;
    this.on_change([
      e.width,
      e.height,
      e.min_width,
      e.min_height,
      e.max_width,
      e.max_height,
      e.margin,
      e.width_policy,
      e.height_policy,
      e.sizing_mode,
      e.aspect_ratio,
      e.visible
    ], () => this.invalidate_layout()), this.on_change([
      e.background,
      e.css_classes
    ], () => this.invalidate_render());
  }
  disconnect_signals() {
    this._parent_observer != null && clearTimeout(this._parent_observer), this._on_resize != null && window.removeEventListener("resize", this._on_resize), super.disconnect_signals();
  }
  css_classes() {
    return super.css_classes().concat(this.model.css_classes);
  }
  get child_views() {
    return this.child_models.map((e) => this._child_views.get(e));
  }
  async build_child_views() {
    await build_views(this._child_views, this.child_models, { parent: this });
  }
  render() {
    super.render(), empty$1(this.el);
    const { background: e } = this.model;
    this.el.style.backgroundColor = e != null ? color2css(e) : "", classes(this.el).clear().add(...this.css_classes());
    for (const r of this.child_views)
      this.el.appendChild(r.el), r.render();
  }
  update_layout() {
    for (const e of this.child_views)
      e.update_layout();
    this._update_layout();
  }
  update_position() {
    this.el.style.display = this.model.visible ? "block" : "none";
    const e = this.is_layout_root ? this.layout.sizing.margin : void 0;
    position(this.el, this.layout.bbox, e);
    for (const r of this.child_views)
      r.update_position();
  }
  after_layout() {
    for (const e of this.child_views)
      e.after_layout();
    this._has_finished = !0;
  }
  compute_viewport() {
    this._viewport = this._viewport_size();
  }
  renderTo(e) {
    e.appendChild(this.el), this._offset_parent = this.el.offsetParent, this.compute_viewport(), this.build(), this.notify_finished();
  }
  build() {
    if (!this.is_layout_root)
      throw new Error(`${this.toString()} is not a root layout`);
    return this.render(), this.update_layout(), this.compute_layout(), this;
  }
  async rebuild() {
    await this.build_child_views(), this.invalidate_render();
  }
  compute_layout() {
    const e = Date.now();
    this.layout.compute(this._viewport), this.update_position(), this.after_layout(), logger.debug(`layout computed in ${Date.now() - e} ms`);
  }
  resize_layout() {
    this.root.compute_viewport(), this.root.compute_layout();
  }
  invalidate_layout() {
    this.root.update_layout(), this.root.compute_layout();
  }
  invalidate_render() {
    this.render(), this.invalidate_layout();
  }
  has_finished() {
    if (!super.has_finished())
      return !1;
    for (const e of this.child_views)
      if (!e.has_finished())
        return !1;
    return !0;
  }
  _width_policy() {
    return this.model.width != null ? "fixed" : "fit";
  }
  _height_policy() {
    return this.model.height != null ? "fixed" : "fit";
  }
  box_sizing() {
    let { width_policy: e, height_policy: r, aspect_ratio: o } = this.model;
    e == "auto" && (e = this._width_policy()), r == "auto" && (r = this._height_policy());
    const { sizing_mode: s } = this.model;
    if (s != null)
      if (s == "fixed")
        e = r = "fixed";
      else if (s == "stretch_both")
        e = r = "max";
      else if (s == "stretch_width")
        e = "max";
      else if (s == "stretch_height")
        r = "max";
      else
        switch (o == null && (o = "auto"), s) {
          case "scale_width":
            e = "max", r = "min";
            break;
          case "scale_height":
            e = "min", r = "max";
            break;
          case "scale_both":
            e = "max", r = "max";
            break;
        }
    const l = { width_policy: e, height_policy: r }, { min_width: c, min_height: u } = this.model;
    c != null && (l.min_width = c), u != null && (l.min_height = u);
    const { width: d, height: f } = this.model;
    d != null && (l.width = d), f != null && (l.height = f);
    const { max_width: T, max_height: Q } = this.model;
    T != null && (l.max_width = T), Q != null && (l.max_height = Q), o == "auto" && d != null && f != null ? l.aspect = d / f : isNumber(o) && (l.aspect = o);
    const { margin: m } = this.model;
    if (m != null)
      if (isNumber(m))
        l.margin = { top: m, right: m, bottom: m, left: m };
      else if (m.length == 2) {
        const [v, b] = m;
        l.margin = { top: v, right: b, bottom: v, left: b };
      } else {
        const [v, b, L, A] = m;
        l.margin = { top: v, right: b, bottom: L, left: A };
      }
    l.visible = this.model.visible;
    const { align: g } = this.model;
    return isArray(g) ? [l.halign, l.valign] = g : l.halign = l.valign = g, l;
  }
  _viewport_size() {
    return undisplayed(this.el, () => {
      let e = this.el;
      for (; e = e.parentElement; ) {
        if (e.classList.contains(root$3))
          continue;
        if (e == document.body) {
          const { margin: { left: T, right: Q, top: m, bottom: g } } = extents(document.body), v = Math.ceil(document.documentElement.clientWidth - T - Q), b = Math.ceil(document.documentElement.clientHeight - m - g);
          return { width: v, height: b };
        }
        const { padding: { left: r, right: o, top: s, bottom: l } } = extents(e), { width: c, height: u } = e.getBoundingClientRect(), d = Math.ceil(c - r - o), f = Math.ceil(u - s - l);
        if (d > 0 || f > 0)
          return {
            width: d > 0 ? d : void 0,
            height: f > 0 ? f : void 0
          };
      }
      return {};
    });
  }
  export(e, r = !0) {
    const o = e == "png" ? "canvas" : "svg", s = new CanvasLayer(o, r), { width: l, height: c } = this.layout.bbox;
    s.resize(l, c);
    for (const u of this.child_views) {
      const d = u.export(e, r), { x: f, y: T } = u.layout.bbox;
      s.ctx.drawImage(d.canvas, f, T);
    }
    return s;
  }
  serializable_state() {
    return {
      ...super.serializable_state(),
      bbox: this.layout.bbox.box,
      children: this.child_views.map((e) => e.serializable_state())
    };
  }
}
LayoutDOMView.__name__ = "LayoutDOMView";
class LayoutDOM extends Model {
  constructor(e) {
    super(e);
  }
}
_a$1O = LayoutDOM;
LayoutDOM.__name__ = "LayoutDOM";
_a$1O.define((t) => {
  const { Boolean: e, Number: r, String: o, Auto: s, Color: l, Array: c, Tuple: u, Or: d, Null: f, Nullable: T } = t, Q = u(r, r), m = u(r, r, r, r);
  return {
    width: [T(r), null],
    height: [T(r), null],
    min_width: [T(r), null],
    min_height: [T(r), null],
    max_width: [T(r), null],
    max_height: [T(r), null],
    margin: [T(d(r, Q, m)), [0, 0, 0, 0]],
    width_policy: [d(SizingPolicy, s), "auto"],
    height_policy: [d(SizingPolicy, s), "auto"],
    aspect_ratio: [d(r, s, f), null],
    sizing_mode: [T(SizingMode), null],
    visible: [e, !0],
    disabled: [e, !1],
    align: [d(Align, u(Align, Align)), "start"],
    background: [T(l), null],
    css_classes: [c(o), []]
  };
});
var _a$1N;
class BoxView extends LayoutDOMView {
  connect_signals() {
    super.connect_signals(), this.connect(this.model.properties.children.change, () => this.rebuild());
  }
  get child_models() {
    return this.model.children;
  }
}
BoxView.__name__ = "BoxView";
class Box extends LayoutDOM {
  constructor(e) {
    super(e);
  }
}
_a$1N = Box;
Box.__name__ = "Box";
_a$1N.define(({ Number: t, Array: e, Ref: r }) => ({
  children: [e(r(LayoutDOM)), []],
  spacing: [t, 0]
}));
var _a$1M;
class ColumnView extends BoxView {
  _update_layout() {
    const e = this.child_views.map((r) => r.layout);
    this.layout = new Column$1(e), this.layout.rows = this.model.rows, this.layout.spacing = [this.model.spacing, 0], this.layout.set_sizing(this.box_sizing());
  }
}
ColumnView.__name__ = "ColumnView";
class Column extends Box {
  constructor(e) {
    super(e);
  }
}
_a$1M = Column;
Column.__name__ = "Column";
_a$1M.prototype.default_view = ColumnView, _a$1M.define(({ Any: t }) => ({
  rows: [t, "auto"]
}));
var _a$1L;
class GridBoxView extends LayoutDOMView {
  connect_signals() {
    super.connect_signals();
    const { children: e, rows: r, cols: o, spacing: s } = this.model.properties;
    this.on_change([e, r, o, s], () => this.rebuild());
  }
  get child_models() {
    return this.model.children.map(([e]) => e);
  }
  _update_layout() {
    this.layout = new Grid$1(), this.layout.rows = this.model.rows, this.layout.cols = this.model.cols, this.layout.spacing = this.model.spacing;
    for (const [e, r, o, s, l] of this.model.children) {
      const c = this._child_views.get(e);
      this.layout.items.push({ layout: c.layout, row: r, col: o, row_span: s, col_span: l });
    }
    this.layout.set_sizing(this.box_sizing());
  }
}
GridBoxView.__name__ = "GridBoxView";
class GridBox extends LayoutDOM {
  constructor(e) {
    super(e);
  }
}
_a$1L = GridBox;
GridBox.__name__ = "GridBox";
_a$1L.prototype.default_view = GridBoxView, _a$1L.define(({ Any: t, Int: e, Number: r, Tuple: o, Array: s, Ref: l, Or: c, Opt: u }) => ({
  children: [s(o(l(LayoutDOM), e, e, u(e), u(e))), []],
  rows: [t, "auto"],
  cols: [t, "auto"],
  spacing: [c(r, o(r, r)), 0]
}));
class HTMLBoxView extends LayoutDOMView {
  get child_models() {
    return [];
  }
  _update_layout() {
    this.layout = new ContentBox(this.el), this.layout.set_sizing(this.box_sizing());
  }
}
HTMLBoxView.__name__ = "HTMLBoxView";
class HTMLBox extends LayoutDOM {
  constructor(e) {
    super(e);
  }
}
HTMLBox.__name__ = "HTMLBox";
var _a$1K;
class Panel extends Model {
  constructor(e) {
    super(e);
  }
}
_a$1K = Panel;
Panel.__name__ = "Panel";
_a$1K.define(({ Boolean: t, String: e, Ref: r }) => ({
  title: [e, ""],
  child: [r(LayoutDOM)],
  closable: [t, !1],
  disabled: [t, !1]
}));
var _a$1J;
class RowView extends BoxView {
  _update_layout() {
    const e = this.child_views.map((r) => r.layout);
    this.layout = new Row$1(e), this.layout.cols = this.model.cols, this.layout.spacing = [0, this.model.spacing], this.layout.set_sizing(this.box_sizing());
  }
}
RowView.__name__ = "RowView";
class Row extends Box {
  constructor(e) {
    super(e);
  }
}
_a$1J = Row;
Row.__name__ = "Row";
_a$1J.prototype.default_view = RowView, _a$1J.define(({ Any: t }) => ({
  cols: [t, "auto"]
}));
var _a$1I;
class SpacerView extends LayoutDOMView {
  get child_models() {
    return [];
  }
  _update_layout() {
    this.layout = new LayoutItem(), this.layout.set_sizing(this.box_sizing());
  }
}
SpacerView.__name__ = "SpacerView";
class Spacer extends LayoutDOM {
  constructor(e) {
    super(e);
  }
}
_a$1I = Spacer;
Spacer.__name__ = "Spacer";
_a$1I.prototype.default_view = SpacerView;
const root$1 = "bk-root", tabs_header = "bk-tabs-header", btn_group$1 = "bk-btn-group", btn$1 = "bk-btn", headers_wrapper = "bk-headers-wrapper", above = "bk-above", right = "bk-right", below = "bk-below", left = "bk-left", headers = "bk-headers", tab = "bk-tab", active$1 = "bk-active", close = "bk-close", disabled = "bk-disabled", tabs_css = `.bk-root .bk-tabs-header{display:flex;flex-wrap:nowrap;align-items:center;overflow:hidden;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-tabs-header .bk-btn-group{height:auto;margin-right:5px;}.bk-root .bk-tabs-header .bk-btn-group > .bk-btn{flex-grow:0;height:auto;padding:4px 4px;}.bk-root .bk-tabs-header .bk-headers-wrapper{flex-grow:1;overflow:hidden;color:#666666;}.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper{border-bottom:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper{border-left:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper{border-top:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper{border-right:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-above,.bk-root .bk-tabs-header.bk-below{flex-direction:row;}.bk-root .bk-tabs-header.bk-above .bk-headers,.bk-root .bk-tabs-header.bk-below .bk-headers{flex-direction:row;}.bk-root .bk-tabs-header.bk-left,.bk-root .bk-tabs-header.bk-right{flex-direction:column;}.bk-root .bk-tabs-header.bk-left .bk-headers,.bk-root .bk-tabs-header.bk-right .bk-headers{flex-direction:column;}.bk-root .bk-tabs-header .bk-headers{position:relative;display:flex;flex-wrap:nowrap;align-items:center;}.bk-root .bk-tabs-header .bk-tab{padding:4px 8px;border:solid transparent;white-space:nowrap;cursor:pointer;}.bk-root .bk-tabs-header .bk-tab:hover{background-color:#f2f2f2;}.bk-root .bk-tabs-header .bk-tab.bk-active{color:#4d4d4d;background-color:white;border-color:#e6e6e6;}.bk-root .bk-tabs-header .bk-tab .bk-close{margin-left:10px;}.bk-root .bk-tabs-header .bk-tab.bk-disabled{cursor:not-allowed;pointer-events:none;opacity:0.65;}.bk-root .bk-tabs-header.bk-above .bk-tab{border-width:3px 1px 0px 1px;border-radius:4px 4px 0 0;}.bk-root .bk-tabs-header.bk-right .bk-tab{border-width:1px 3px 1px 0px;border-radius:0 4px 4px 0;}.bk-root .bk-tabs-header.bk-below .bk-tab{border-width:0px 1px 3px 1px;border-radius:0 0 4px 4px;}.bk-root .bk-tabs-header.bk-left .bk-tab{border-width:1px 0px 1px 3px;border-radius:4px 0 0 4px;}.bk-root .bk-close{display:inline-block;width:10px;height:10px;vertical-align:middle;background-image:url('data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>');}.bk-root .bk-close:hover{background-image:url('data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>');}`, tabs = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  root: root$1,
  tabs_header,
  btn_group: btn_group$1,
  btn: btn$1,
  headers_wrapper,
  above,
  right,
  below,
  left,
  headers,
  tab,
  active: active$1,
  close,
  disabled,
  default: tabs_css
}, Symbol.toStringTag, { value: "Module" })), root = "bk-root", btn = "bk-btn", active = "bk-active", btn_default = "bk-btn-default", btn_primary = "bk-btn-primary", btn_success = "bk-btn-success", btn_warning = "bk-btn-warning", btn_danger = "bk-btn-danger", btn_light = "bk-btn-light", btn_group = "bk-btn-group", vertical = "bk-vertical", horizontal = "bk-horizontal", dropdown_toggle = "bk-dropdown-toggle", buttons_css = ".bk-root .bk-btn{height:100%;display:inline-block;text-align:center;vertical-align:middle;white-space:nowrap;cursor:pointer;padding:6px 12px;font-size:12px;border:1px solid transparent;border-radius:4px;outline:0;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-btn:hover,.bk-root .bk-btn:focus{text-decoration:none;}.bk-root .bk-btn:active,.bk-root .bk-btn.bk-active{background-image:none;box-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);}.bk-root .bk-btn[disabled]{cursor:not-allowed;pointer-events:none;opacity:0.65;box-shadow:none;}.bk-root .bk-btn-default{color:#333;background-color:#fff;border-color:#ccc;}.bk-root .bk-btn-default:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-default.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-default[disabled],.bk-root .bk-btn-default[disabled]:hover,.bk-root .bk-btn-default[disabled]:focus,.bk-root .bk-btn-default[disabled]:active,.bk-root .bk-btn-default[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-primary{color:#fff;background-color:#428bca;border-color:#357ebd;}.bk-root .bk-btn-primary:hover{background-color:#3681c1;border-color:#2c699e;}.bk-root .bk-btn-primary.bk-active{background-color:#3276b1;border-color:#285e8e;}.bk-root .bk-btn-primary[disabled],.bk-root .bk-btn-primary[disabled]:hover,.bk-root .bk-btn-primary[disabled]:focus,.bk-root .bk-btn-primary[disabled]:active,.bk-root .bk-btn-primary[disabled].bk-active{background-color:#506f89;border-color:#357ebd;}.bk-root .bk-btn-success{color:#fff;background-color:#5cb85c;border-color:#4cae4c;}.bk-root .bk-btn-success:hover{background-color:#4eb24e;border-color:#409240;}.bk-root .bk-btn-success.bk-active{background-color:#47a447;border-color:#398439;}.bk-root .bk-btn-success[disabled],.bk-root .bk-btn-success[disabled]:hover,.bk-root .bk-btn-success[disabled]:focus,.bk-root .bk-btn-success[disabled]:active,.bk-root .bk-btn-success[disabled].bk-active{background-color:#667b66;border-color:#4cae4c;}.bk-root .bk-btn-warning{color:#fff;background-color:#f0ad4e;border-color:#eea236;}.bk-root .bk-btn-warning:hover{background-color:#eea43b;border-color:#e89014;}.bk-root .bk-btn-warning.bk-active{background-color:#ed9c28;border-color:#d58512;}.bk-root .bk-btn-warning[disabled],.bk-root .bk-btn-warning[disabled]:hover,.bk-root .bk-btn-warning[disabled]:focus,.bk-root .bk-btn-warning[disabled]:active,.bk-root .bk-btn-warning[disabled].bk-active{background-color:#c89143;border-color:#eea236;}.bk-root .bk-btn-danger{color:#fff;background-color:#d9534f;border-color:#d43f3a;}.bk-root .bk-btn-danger:hover{background-color:#d5433e;border-color:#bd2d29;}.bk-root .bk-btn-danger.bk-active{background-color:#d2322d;border-color:#ac2925;}.bk-root .bk-btn-danger[disabled],.bk-root .bk-btn-danger[disabled]:hover,.bk-root .bk-btn-danger[disabled]:focus,.bk-root .bk-btn-danger[disabled]:active,.bk-root .bk-btn-danger[disabled].bk-active{background-color:#a55350;border-color:#d43f3a;}.bk-root .bk-btn-light{color:#333;background-color:#fff;border-color:#ccc;border-color:transparent;}.bk-root .bk-btn-light:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-light.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-light[disabled],.bk-root .bk-btn-light[disabled]:hover,.bk-root .bk-btn-light[disabled]:focus,.bk-root .bk-btn-light[disabled]:active,.bk-root .bk-btn-light[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-group{height:100%;display:flex;flex-wrap:nowrap;align-items:center;}.bk-root .bk-btn-group:not(.bk-vertical),.bk-root .bk-btn-group.bk-horizontal{flex-direction:row;}.bk-root .bk-btn-group.bk-vertical{flex-direction:column;}.bk-root .bk-btn-group > .bk-btn{flex-grow:1;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn + .bk-btn{margin-left:-1px;}.bk-root .bk-btn-group.bk-vertical > .bk-btn + .bk-btn{margin-top:-1px;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn:first-child:not(:last-child){border-bottom-right-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn:first-child:not(:last-child){border-bottom-left-radius:0;border-bottom-right-radius:0;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn:not(:first-child):last-child{border-bottom-left-radius:0;border-top-left-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn:not(:first-child):last-child{border-top-left-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child){border-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn{width:100%;}.bk-root .bk-btn-group .bk-dropdown-toggle{flex:0 0 0;padding:6px 6px;}", buttons = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  root,
  btn,
  active,
  btn_default,
  btn_primary,
  btn_success,
  btn_warning,
  btn_danger,
  btn_light,
  btn_group,
  vertical,
  horizontal,
  dropdown_toggle,
  default: buttons_css
}, Symbol.toStringTag, { value: "Module" }));
var _a$1H;
class TabsView extends LayoutDOMView {
  constructor() {
    super(...arguments), this._scroll_index = 0;
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.properties.tabs.change, () => this.rebuild()), this.connect(this.model.properties.active.change, () => this.on_active_change());
  }
  styles() {
    return [...super.styles(), buttons_css, menus_css, tabs_css];
  }
  get child_models() {
    return this.model.tabs.map((e) => e.child);
  }
  _update_layout() {
    const e = this.model.tabs_location, r = e == "above" || e == "below", { scroll_el: o, headers_el: s } = this;
    this.header = new class extends ContentBox {
      _measure(f) {
        const Q = size(o), m = children(s).slice(0, 3).map((b) => size(b)), { width: g, height: v } = super._measure(f);
        if (r) {
          const b = Q.width + sum$2(m.map((L) => L.width));
          return { width: f.width != 1 / 0 ? f.width : b, height: v };
        } else {
          const b = Q.height + sum$2(m.map((L) => L.height));
          return { width: g, height: f.height != 1 / 0 ? f.height : b };
        }
      }
    }(this.header_el), r ? this.header.set_sizing({ width_policy: "fit", height_policy: "fixed" }) : this.header.set_sizing({ width_policy: "fixed", height_policy: "fit" });
    let l = 1, c = 1;
    switch (e) {
      case "above":
        l -= 1;
        break;
      case "below":
        l += 1;
        break;
      case "left":
        c -= 1;
        break;
      case "right":
        c += 1;
        break;
    }
    const u = { layout: this.header, row: l, col: c }, d = this.child_views.map((f) => ({ layout: f.layout, row: 1, col: 1 }));
    this.layout = new Grid$1([u, ...d]), this.layout.set_sizing(this.box_sizing());
  }
  update_position() {
    super.update_position(), this.header_el.style.position = "absolute", position(this.header_el, this.header.bbox);
    const e = this.model.tabs_location, r = e == "above" || e == "below", o = size(this.scroll_el), s = scroll_size(this.headers_el);
    if (r) {
      const { width: u } = this.header.bbox;
      s.width > u ? (this.wrapper_el.style.maxWidth = `${u - o.width}px`, display(this.scroll_el), this.do_scroll(this.model.active)) : (this.wrapper_el.style.maxWidth = "", undisplay(this.scroll_el));
    } else {
      const { height: u } = this.header.bbox;
      s.height > u ? (this.wrapper_el.style.maxHeight = `${u - o.height}px`, display(this.scroll_el), this.do_scroll(this.model.active)) : (this.wrapper_el.style.maxHeight = "", undisplay(this.scroll_el));
    }
    const { child_views: l } = this;
    for (const u of l)
      hide(u.el);
    const c = l[this.model.active];
    c != null && show(c.el);
  }
  render() {
    super.render();
    const { active: e } = this.model, r = this.model.tabs.map((s, l) => {
      const c = div({ class: [tab, l == e ? active$1 : null] }, s.title);
      if (c.addEventListener("click", (u) => {
        this.model.disabled || u.target == u.currentTarget && this.change_active(l);
      }), s.closable) {
        const u = div({ class: close });
        u.addEventListener("click", (d) => {
          if (d.target == d.currentTarget) {
            this.model.tabs = remove_at(this.model.tabs, l);
            const f = this.model.tabs.length;
            this.model.active > f - 1 && (this.model.active = f - 1);
          }
        }), c.appendChild(u);
      }
      return (this.model.disabled || s.disabled) && c.classList.add(disabled), c;
    });
    this.headers_el = div({ class: [headers] }, r), this.wrapper_el = div({ class: headers_wrapper }, this.headers_el), this.left_el = div({ class: [btn, btn_default], disabled: "" }, div({ class: [caret, left] })), this.right_el = div({ class: [btn, btn_default] }, div({ class: [caret, right] })), this.left_el.addEventListener("click", () => this.do_scroll("left")), this.right_el.addEventListener("click", () => this.do_scroll("right")), this.scroll_el = div({ class: btn_group }, this.left_el, this.right_el);
    const o = this.model.tabs_location;
    this.header_el = div({ class: [tabs_header, tabs[o]] }, this.scroll_el, this.wrapper_el), this.el.appendChild(this.header_el);
  }
  do_scroll(e) {
    const r = this.model.tabs.length;
    e == "left" ? this._scroll_index -= 1 : e == "right" ? this._scroll_index += 1 : this._scroll_index = e, this._scroll_index = clamp(this._scroll_index, 0, r - 1), this._scroll_index == 0 ? this.left_el.setAttribute("disabled", "") : this.left_el.removeAttribute("disabled"), this._scroll_index == r - 1 ? this.right_el.setAttribute("disabled", "") : this.right_el.removeAttribute("disabled");
    const o = children(this.headers_el).slice(0, this._scroll_index).map((c) => c.getBoundingClientRect()), s = this.model.tabs_location;
    if (s == "above" || s == "below") {
      const c = -sum$2(o.map((u) => u.width));
      this.headers_el.style.left = `${c}px`;
    } else {
      const c = -sum$2(o.map((u) => u.height));
      this.headers_el.style.top = `${c}px`;
    }
  }
  change_active(e) {
    e != this.model.active && (this.model.active = e);
  }
  on_active_change() {
    const e = this.model.active, r = children(this.headers_el);
    for (const s of r)
      s.classList.remove(active$1);
    r[e].classList.add(active$1);
    const { child_views: o } = this;
    for (const s of o)
      hide(s.el);
    show(o[e].el);
  }
}
TabsView.__name__ = "TabsView";
class Tabs extends LayoutDOM {
  constructor(e) {
    super(e);
  }
}
_a$1H = Tabs;
Tabs.__name__ = "Tabs";
_a$1H.prototype.default_view = TabsView, _a$1H.define(({ Int: t, Array: e, Ref: r }) => ({
  tabs: [e(r(Panel)), []],
  tabs_location: [Location, "above"],
  active: [t, 0]
}));
var _a$1G;
class WidgetBoxView extends ColumnView {
}
WidgetBoxView.__name__ = "WidgetBoxView";
class WidgetBox extends Column {
  constructor(e) {
    super(e);
  }
}
_a$1G = WidgetBox;
WidgetBox.__name__ = "WidgetBox";
_a$1G.prototype.default_view = WidgetBoxView;
var _a$1F;
class CustomJSTransform extends Transform {
  constructor(e) {
    super(e);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  _make_transform(e, r) {
    return new Function(...this.names, e, use_strict(r));
  }
  get scalar_transform() {
    return this._make_transform("x", this.func);
  }
  get vector_transform() {
    return this._make_transform("xs", this.v_func);
  }
  compute(e) {
    return this.scalar_transform(...this.values, e);
  }
  v_compute(e) {
    return this.vector_transform(...this.values, e);
  }
}
_a$1F = CustomJSTransform;
CustomJSTransform.__name__ = "CustomJSTransform";
_a$1F.define(({ Unknown: t, String: e, Dict: r }) => ({
  args: [r(t), {}],
  func: [e, ""],
  v_func: [e, ""]
}));
var _a$1E;
class RangeTransform extends Transform {
  constructor(e) {
    super(e);
  }
  v_compute(e) {
    let r;
    this.range instanceof FactorRange ? r = this.range.v_synthetic(e) : isArrayableOf(e, isNumber) ? r = e : unreachable();
    const o = new (infer_type(r))(r.length);
    for (let s = 0; s < r.length; s++) {
      const l = r[s];
      o[s] = this._compute(l);
    }
    return o;
  }
  compute(e) {
    if (this.range instanceof FactorRange)
      return this._compute(this.range.synthetic(e));
    if (isNumber(e))
      return this._compute(e);
    unreachable();
  }
}
_a$1E = RangeTransform;
RangeTransform.__name__ = "RangeTransform";
_a$1E.define(({ Ref: t, Nullable: e }) => ({
  range: [e(t(Range$1)), null]
}));
var _a$1D;
class Dodge extends RangeTransform {
  constructor(e) {
    super(e);
  }
  _compute(e) {
    return e + this.value;
  }
}
_a$1D = Dodge;
Dodge.__name__ = "Dodge";
_a$1D.define(({ Number: t }) => ({
  value: [t, 0]
}));
var _a$1C;
class Interpolator extends Transform {
  constructor(e) {
    super(e), this._sorted_dirty = !0;
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.change, () => this._sorted_dirty = !0);
  }
  v_compute(e) {
    const r = infer_type(e), o = new r(e.length);
    for (let s = 0; s < e.length; s++) {
      const l = e[s];
      o[s] = this.compute(l);
    }
    return o;
  }
  sort(e = !1) {
    if (!this._sorted_dirty)
      return;
    let r, o;
    if (isString(this.x) && isString(this.y) && this.data != null) {
      const u = this.data.columns();
      if (!includes(u, this.x))
        throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");
      if (!includes(u, this.y))
        throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");
      r = this.data.get_column(this.x), o = this.data.get_column(this.y);
    } else if (isArray(this.x) && isArray(this.y))
      r = this.x, o = this.y;
    else
      throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");
    if (r.length !== o.length)
      throw new Error("The length for x and y do not match");
    if (r.length < 2)
      throw new Error("x and y must have at least two elements to support interpolation");
    const s = r.length, l = new Uint32Array(s);
    for (let u = 0; u < s; u++)
      l[u] = u;
    const c = e ? -1 : 1;
    l.sort((u, d) => c * (r[u] - r[d])), this._x_sorted = new (infer_type(r))(s), this._y_sorted = new (infer_type(o))(s);
    for (let u = 0; u < s; u++)
      this._x_sorted[u] = r[l[u]], this._y_sorted[u] = o[l[u]];
    this._sorted_dirty = !1;
  }
}
_a$1C = Interpolator;
Interpolator.__name__ = "Interpolator";
_a$1C.define(({ Boolean: t, Number: e, String: r, Ref: o, Array: s, Or: l, Nullable: c }) => ({
  x: [l(r, s(e))],
  y: [l(r, s(e))],
  data: [c(o(ColumnarDataSource)), null],
  clip: [t, !0]
}));
var _a$1B;
class Jitter extends RangeTransform {
  constructor(e) {
    super(e);
  }
  v_compute(e) {
    var l;
    let r;
    this.range instanceof FactorRange ? r = this.range.v_synthetic(e) : isArrayableOf(e, isNumber) ? r = e : unreachable();
    const o = r.length;
    ((l = this.previous_offsets) == null ? void 0 : l.length) != o && (this.previous_offsets = new Array(o), this.previous_offsets = map(this.previous_offsets, () => this._compute()));
    const s = this.previous_offsets;
    return map(r, (c, u) => s[u] + c);
  }
  _compute() {
    switch (this.distribution) {
      case "uniform":
        return this.mean + (random$1() - 0.5) * this.width;
      case "normal":
        return rnorm(this.mean, this.width);
    }
  }
}
_a$1B = Jitter;
Jitter.__name__ = "Jitter";
_a$1B.define(({ Number: t }) => ({
  mean: [t, 0],
  width: [t, 1],
  distribution: [Distribution, "uniform"]
}));
class LinearInterpolator extends Interpolator {
  constructor(e) {
    super(e);
  }
  compute(e) {
    if (this.sort(!1), this.clip) {
      if (e < this._x_sorted[0] || e > this._x_sorted[this._x_sorted.length - 1])
        return NaN;
    } else {
      if (e < this._x_sorted[0])
        return this._y_sorted[0];
      if (e > this._x_sorted[this._x_sorted.length - 1])
        return this._y_sorted[this._y_sorted.length - 1];
    }
    if (e == this._x_sorted[0])
      return this._y_sorted[0];
    const r = find_last_index(this._x_sorted, (u) => u < e), o = this._x_sorted[r], s = this._x_sorted[r + 1], l = this._y_sorted[r], c = this._y_sorted[r + 1];
    return l + (e - o) / (s - o) * (c - l);
  }
}
LinearInterpolator.__name__ = "LinearInterpolator";
var _a$1A;
class StepInterpolator extends Interpolator {
  constructor(e) {
    super(e);
  }
  compute(e) {
    if (this.sort(!1), this.clip) {
      if (e < this._x_sorted[0] || e > this._x_sorted[this._x_sorted.length - 1])
        return NaN;
    } else {
      if (e < this._x_sorted[0])
        return this._y_sorted[0];
      if (e > this._x_sorted[this._x_sorted.length - 1])
        return this._y_sorted[this._y_sorted.length - 1];
    }
    let r;
    switch (this.mode) {
      case "after": {
        r = find_last_index(this._x_sorted, (o) => e >= o);
        break;
      }
      case "before": {
        r = find_index(this._x_sorted, (o) => e <= o);
        break;
      }
      case "center": {
        const o = map(this._x_sorted, (l) => Math.abs(l - e)), s = min$6(o);
        r = find_index(o, (l) => s === l);
        break;
      }
      default:
        throw new Error(`unknown mode: ${this.mode}`);
    }
    return r != -1 ? this._y_sorted[r] : NaN;
  }
}
_a$1A = StepInterpolator;
StepInterpolator.__name__ = "StepInterpolator";
_a$1A.define(() => ({
  mode: [StepMode, "after"]
}));
function throttle(t, e) {
  let r = null, o = 0, s = !1;
  return function() {
    return new Promise((l, c) => {
      const u = function() {
        o = Date.now(), r = null, s = !1;
        try {
          t(), l();
        } catch (T) {
          c(T);
        }
      }, d = Date.now(), f = e - (d - o);
      f <= 0 && !s ? (r != null && clearTimeout(r), s = !0, requestAnimationFrame(u)) : !r && !s ? r = setTimeout(() => requestAnimationFrame(u), f) : l();
    });
  };
}
class RangeManager {
  constructor(e) {
    this.parent = e, this.invalidate_dataranges = !0;
  }
  get frame() {
    return this.parent.frame;
  }
  update(e, r) {
    const { x_ranges: o, y_ranges: s } = this.frame;
    if (e == null) {
      for (const [, l] of o)
        l.reset();
      for (const [, l] of s)
        l.reset();
      this.update_dataranges();
    } else {
      const l = [];
      for (const [c, u] of o)
        l.push([u, e.xrs.get(c)]);
      for (const [c, u] of s)
        l.push([u, e.yrs.get(c)]);
      r != null && r.scrolling && this._update_ranges_together(l), this._update_ranges_individually(l, r);
    }
  }
  reset() {
    this.update(null);
  }
  _update_dataranges(e) {
    const r = /* @__PURE__ */ new Map(), o = /* @__PURE__ */ new Map();
    let s = !1;
    for (const [, T] of e.x_ranges)
      T instanceof DataRange1d && T.scale_hint == "log" && (s = !0);
    for (const [, T] of e.y_ranges)
      T instanceof DataRange1d && T.scale_hint == "log" && (s = !0);
    for (const T of this.parent.model.data_renderers) {
      const Q = this.parent.renderer_view(T);
      if (Q == null)
        continue;
      const m = Q.glyph_view.bounds();
      if (m != null && r.set(T, m), s) {
        const g = Q.glyph_view.log_bounds();
        g != null && o.set(T, g);
      }
    }
    let l = !1, c = !1;
    const u = e.x_target.span, d = e.y_target.span;
    let f;
    this.parent.model.match_aspect !== !1 && u != 0 && d != 0 && (f = 1 / this.parent.model.aspect_scale * (u / d));
    for (const [, T] of e.x_ranges) {
      if (T instanceof DataRange1d) {
        const Q = T.scale_hint == "log" ? o : r;
        T.update(Q, 0, this.parent.model, f), T.follow && (l = !0);
      }
      T.bounds != null && (c = !0);
    }
    for (const [, T] of e.y_ranges) {
      if (T instanceof DataRange1d) {
        const Q = T.scale_hint == "log" ? o : r;
        T.update(Q, 1, this.parent.model, f), T.follow && (l = !0);
      }
      T.bounds != null && (c = !0);
    }
    if (l && c) {
      logger.warn("Follow enabled so bounds are unset.");
      for (const [, T] of e.x_ranges)
        T.bounds = null;
      for (const [, T] of e.y_ranges)
        T.bounds = null;
    }
  }
  update_dataranges() {
    this._update_dataranges(this.frame);
    for (const e of this.parent.model.renderers) {
      const { coordinates: r } = e;
      r != null && this._update_dataranges(r);
    }
    this.compute_initial() != null && (this.invalidate_dataranges = !1);
  }
  compute_initial() {
    let e = !0;
    const { x_ranges: r, y_ranges: o } = this.frame, s = /* @__PURE__ */ new Map(), l = /* @__PURE__ */ new Map();
    for (const [c, u] of r) {
      const { start: d, end: f } = u;
      if (d == null || f == null || isNaN(d + f)) {
        e = !1;
        break;
      }
      s.set(c, { start: d, end: f });
    }
    if (e)
      for (const [c, u] of o) {
        const { start: d, end: f } = u;
        if (d == null || f == null || isNaN(d + f)) {
          e = !1;
          break;
        }
        l.set(c, { start: d, end: f });
      }
    return e ? { xrs: s, yrs: l } : (logger.warn("could not set initial ranges"), null);
  }
  _update_ranges_together(e) {
    let r = 1;
    for (const [o, s] of e)
      r = Math.min(r, this._get_weight_to_constrain_interval(o, s));
    if (r < 1)
      for (const [o, s] of e)
        s.start = r * s.start + (1 - r) * o.start, s.end = r * s.end + (1 - r) * o.end;
  }
  _update_ranges_individually(e, r) {
    const o = !!(r != null && r.panning), s = !!(r != null && r.scrolling);
    let l = !1;
    for (const [c, u] of e) {
      if (!s) {
        const d = this._get_weight_to_constrain_interval(c, u);
        d < 1 && (u.start = d * u.start + (1 - d) * c.start, u.end = d * u.end + (1 - d) * c.end);
      }
      if (c.bounds != null && c.bounds != "auto") {
        const [d, f] = c.bounds, T = Math.abs(u.end - u.start);
        c.is_reversed ? (d != null && d > u.end && (l = !0, u.end = d, (o || s) && (u.start = d + T)), f != null && f < u.start && (l = !0, u.start = f, (o || s) && (u.end = f - T))) : (d != null && d > u.start && (l = !0, u.start = d, (o || s) && (u.end = d + T)), f != null && f < u.end && (l = !0, u.end = f, (o || s) && (u.start = f - T)));
      }
    }
    if (!(s && l && (r == null ? void 0 : r.maintain_focus)))
      for (const [c, u] of e)
        c.have_updated_interactively = !0, (c.start != u.start || c.end != u.end) && c.setv(u);
  }
  _get_weight_to_constrain_interval(e, r) {
    const { min_interval: o } = e;
    let { max_interval: s } = e;
    if (e.bounds != null && e.bounds != "auto") {
      const [c, u] = e.bounds;
      if (c != null && u != null) {
        const d = Math.abs(u - c);
        s = s != null ? Math.min(s, d) : d;
      }
    }
    let l = 1;
    if (o != null || s != null) {
      const c = Math.abs(e.end - e.start), u = Math.abs(r.end - r.start);
      o != null && o > 0 && u < o && (l = (c - o) / (c - u)), s != null && s > 0 && u > s && (l = (s - c) / (u - c)), l = Math.max(0, Math.min(1, l));
    }
    return l;
  }
}
RangeManager.__name__ = "RangeManager";
class StateManager {
  constructor(e, r) {
    this.parent = e, this.initial_state = r, this.changed = new Signal0(this.parent, "state_changed"), this.history = [], this.index = -1;
  }
  _do_state_change(e) {
    const r = this.history[e] != null ? this.history[e].state : this.initial_state;
    return r.range != null && this.parent.update_range(r.range), r.selection != null && this.parent.update_selection(r.selection), r;
  }
  push(e, r) {
    const { history: o, index: s } = this, l = o[s] != null ? o[s].state : {}, c = { ...this.initial_state, ...l, ...r };
    this.history = this.history.slice(0, this.index + 1), this.history.push({ type: e, state: c }), this.index = this.history.length - 1, this.changed.emit();
  }
  clear() {
    this.history = [], this.index = -1, this.changed.emit();
  }
  undo() {
    if (this.can_undo) {
      this.index -= 1;
      const e = this._do_state_change(this.index);
      return this.changed.emit(), e;
    }
    return null;
  }
  redo() {
    if (this.can_redo) {
      this.index += 1;
      const e = this._do_state_change(this.index);
      return this.changed.emit(), e;
    }
    return null;
  }
  get can_undo() {
    return this.index >= 0;
  }
  get can_redo() {
    return this.index < this.history.length - 1;
  }
}
StateManager.__name__ = "StateManager";
class PlotView extends LayoutDOMView {
  constructor() {
    super(...arguments), this._outer_bbox = new BBox$2(), this._inner_bbox = new BBox$2(), this._needs_paint = !0, this._needs_layout = !1, this._invalidated_painters = /* @__PURE__ */ new Set(), this._invalidate_all = !0, this._needs_notify = !1;
  }
  get canvas() {
    return this.canvas_view;
  }
  get state() {
    return this._state_manager;
  }
  set invalidate_dataranges(e) {
    this._range_manager.invalidate_dataranges = e;
  }
  renderer_view(e) {
    const r = this.renderer_views.get(e);
    if (r == null)
      for (const [, o] of this.renderer_views) {
        const s = o.renderer_view(e);
        if (s != null)
          return s;
      }
    return r;
  }
  get is_paused() {
    return this._is_paused != null && this._is_paused !== 0;
  }
  get child_models() {
    return [];
  }
  pause() {
    this._is_paused == null ? this._is_paused = 1 : this._is_paused += 1;
  }
  unpause(e = !1) {
    if (this._is_paused == null)
      throw new Error("wasn't paused");
    this._is_paused -= 1, this._is_paused == 0 && !e && this.request_paint("everything");
  }
  notify_finished_after_paint() {
    this._needs_notify = !0;
  }
  request_render() {
    this.request_paint("everything");
  }
  request_paint(e) {
    this.invalidate_painters(e), this.schedule_paint();
  }
  invalidate_painters(e) {
    if (e == "everything")
      this._invalidate_all = !0;
    else if (isArray(e))
      for (const r of e)
        this._invalidated_painters.add(r);
    else
      this._invalidated_painters.add(e);
  }
  schedule_paint() {
    if (!this.is_paused) {
      const e = this.throttled_paint();
      this._ready = this._ready.then(() => e);
    }
  }
  request_layout() {
    this._needs_layout = !0, this.request_paint("everything");
  }
  reset() {
    this.model.reset_policy == "standard" && (this.state.clear(), this.reset_range(), this.reset_selection()), this.model.trigger_event(new Reset());
  }
  remove() {
    remove_views(this.renderer_views), remove_views(this.tool_views), this.canvas_view.remove(), super.remove();
  }
  render() {
    super.render(), this.el.appendChild(this.canvas_view.el), this.canvas_view.render();
  }
  initialize() {
    this.pause(), super.initialize(), this.lod_started = !1, this.visuals = new Visuals(this), this._initial_state = {
      selection: /* @__PURE__ */ new Map(),
      dimensions: { width: 0, height: 0 }
    }, this.visibility_callbacks = [], this.renderer_views = /* @__PURE__ */ new Map(), this.tool_views = /* @__PURE__ */ new Map(), this.frame = new CartesianFrame(this.model.x_scale, this.model.y_scale, this.model.x_range, this.model.y_range, this.model.extra_x_ranges, this.model.extra_y_ranges, this.model.extra_x_scales, this.model.extra_y_scales), this._range_manager = new RangeManager(this), this._state_manager = new StateManager(this, this._initial_state), this.throttled_paint = throttle(() => this.repaint(), 1e3 / 60);
    const { title_location: e, title: r } = this.model;
    e != null && r != null && (this._title = r instanceof Title ? r : new Title({ text: r }));
    const { toolbar_location: o, toolbar: s } = this.model;
    o != null && s != null && (this._toolbar = new ToolbarPanel({ toolbar: s }), s.toolbar_location = o);
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    const { hidpi: e, output_backend: r } = this.model, o = new Canvas({ hidpi: e, output_backend: r });
    this.canvas_view = await build_view(o, { parent: this }), this.canvas_view.plot_views = [this], await this.build_renderer_views(), await this.build_tool_views(), this._range_manager.update_dataranges(), this.unpause(!0), logger.debug("PlotView initialized");
  }
  _width_policy() {
    return this.model.frame_width == null ? super._width_policy() : "min";
  }
  _height_policy() {
    return this.model.frame_height == null ? super._height_policy() : "min";
  }
  _update_layout() {
    var E, k, w, O, D;
    this.layout = new BorderLayout(), this.layout.set_sizing(this.box_sizing());
    const e = copy(this.model.above), r = copy(this.model.below), o = copy(this.model.left), s = copy(this.model.right), l = (R) => {
      switch (R) {
        case "above":
          return e;
        case "below":
          return r;
        case "left":
          return o;
        case "right":
          return s;
      }
    }, { title_location: c, title: u } = this.model;
    c != null && u != null && l(c).push(this._title);
    const { toolbar_location: d, toolbar: f } = this.model;
    if (d != null && f != null) {
      const R = l(d);
      let B = !0;
      if (this.model.toolbar_sticky)
        for (let F = 0; F < R.length; F++) {
          const j = R[F];
          if (j instanceof Title) {
            d == "above" || d == "below" ? R[F] = [j, this._toolbar] : R[F] = [this._toolbar, j], B = !1;
            break;
          }
        }
      B && R.push(this._toolbar);
    }
    const T = (R, B) => {
      var j;
      const F = this.renderer_view(B);
      return F.panel = new Panel$1(R), (j = F.update_layout) == null || j.call(F), F.layout;
    }, Q = (R, B) => {
      const F = R == "above" || R == "below", j = [];
      for (const z of B)
        if (isArray(z)) {
          const q = z.map((U) => {
            const H = T(R, U);
            if (U instanceof ToolbarPanel) {
              const ce = F ? "width_policy" : "height_policy";
              H.set_sizing({ ...H.sizing, [ce]: "min" });
            }
            return H;
          });
          let I;
          F ? (I = new Row$1(q), I.set_sizing({ width_policy: "max", height_policy: "min" })) : (I = new Column$1(q), I.set_sizing({ width_policy: "min", height_policy: "max" })), I.absolute = !0, j.push(I);
        } else
          j.push(T(R, z));
      return j;
    }, m = (E = this.model.min_border) != null ? E : 0;
    this.layout.min_border = {
      left: (k = this.model.min_border_left) != null ? k : m,
      top: (w = this.model.min_border_top) != null ? w : m,
      right: (O = this.model.min_border_right) != null ? O : m,
      bottom: (D = this.model.min_border_bottom) != null ? D : m
    };
    const g = new NodeLayout(), v = new VStack(), b = new VStack(), L = new HStack(), A = new HStack();
    g.absolute = !0, v.absolute = !0, b.absolute = !0, L.absolute = !0, A.absolute = !0, g.children = this.model.center.filter((R) => R instanceof Annotation).map((R) => {
      var F;
      const B = this.renderer_view(R);
      return (F = B.update_layout) == null || F.call(B), B.layout;
    }).filter((R) => R != null);
    const { frame_width: M, frame_height: S } = this.model;
    g.set_sizing({
      ...M != null ? { width_policy: "fixed", width: M } : { width_policy: "fit" },
      ...S != null ? { height_policy: "fixed", height: S } : { height_policy: "fit" }
    }), g.on_resize((R) => this.frame.set_geometry(R)), v.children = reversed(Q("above", e)), b.children = Q("below", r), L.children = reversed(Q("left", o)), A.children = Q("right", s), v.set_sizing({ width_policy: "fit", height_policy: "min" }), b.set_sizing({ width_policy: "fit", height_policy: "min" }), L.set_sizing({ width_policy: "min", height_policy: "fit" }), A.set_sizing({ width_policy: "min", height_policy: "fit" }), this.layout.center_panel = g, this.layout.top_panel = v, this.layout.bottom_panel = b, this.layout.left_panel = L, this.layout.right_panel = A;
  }
  get axis_views() {
    const e = [];
    for (const [, r] of this.renderer_views)
      r instanceof AxisView && e.push(r);
    return e;
  }
  set_toolbar_visibility(e) {
    for (const r of this.visibility_callbacks)
      r(e);
  }
  update_range(e, r) {
    this.pause(), this._range_manager.update(e, r), this.unpause();
  }
  reset_range() {
    this.update_range(null), this.trigger_ranges_update_event();
  }
  trigger_ranges_update_event() {
    const { x_range: e, y_range: r } = this.model;
    this.model.trigger_event(new RangesUpdate(e.start, e.end, r.start, r.end));
  }
  get_selection() {
    const e = /* @__PURE__ */ new Map();
    for (const r of this.model.data_renderers) {
      const { selected: o } = r.selection_manager.source;
      e.set(r, o);
    }
    return e;
  }
  update_selection(e) {
    for (const r of this.model.data_renderers) {
      const o = r.selection_manager.source;
      if (e != null) {
        const s = e.get(r);
        s != null && o.selected.update(s, !0);
      } else
        o.selection_manager.clear();
    }
  }
  reset_selection() {
    this.update_selection(null);
  }
  _invalidate_layout() {
    (() => {
      var r;
      for (const o of this.model.side_panels) {
        const s = this.renderer_views.get(o);
        if ((r = s.layout) != null && r.has_size_changed())
          return this.invalidate_painters(s), !0;
      }
      return !1;
    })() && this.root.compute_layout();
  }
  get_renderer_views() {
    return this.computed_renderers.map((e) => this.renderer_views.get(e));
  }
  *_compute_renderers() {
    const { above: e, below: r, left: o, right: s, center: l, renderers: c } = this.model;
    yield* c, yield* e, yield* r, yield* o, yield* s, yield* l, this._title != null && (yield this._title), this._toolbar != null && (yield this._toolbar);
    for (const u of this.model.toolbar.tools)
      u.overlay != null && (yield u.overlay), yield* u.synthetic_renderers;
  }
  async build_renderer_views() {
    this.computed_renderers = [...this._compute_renderers()], await build_views(this.renderer_views, this.computed_renderers, { parent: this });
  }
  async build_tool_views() {
    const e = this.model.toolbar.tools;
    (await build_views(this.tool_views, e, { parent: this })).map((o) => this.canvas_view.ui_event_bus.register_tool(o));
  }
  connect_signals() {
    super.connect_signals();
    const { x_ranges: e, y_ranges: r } = this.frame;
    for (const [, f] of e)
      this.connect(f.change, () => {
        this._needs_layout = !0, this.request_paint("everything");
      });
    for (const [, f] of r)
      this.connect(f.change, () => {
        this._needs_layout = !0, this.request_paint("everything");
      });
    const { above: o, below: s, left: l, right: c, center: u, renderers: d } = this.model.properties;
    this.on_change([o, s, l, c, u, d], async () => await this.build_renderer_views()), this.connect(this.model.toolbar.properties.tools.change, async () => {
      await this.build_renderer_views(), await this.build_tool_views();
    }), this.connect(this.model.change, () => this.request_paint("everything")), this.connect(this.model.reset, () => this.reset());
  }
  has_finished() {
    if (!super.has_finished())
      return !1;
    if (this.model.visible) {
      for (const [, e] of this.renderer_views)
        if (!e.has_finished())
          return !1;
    }
    return !0;
  }
  after_layout() {
    var r;
    super.after_layout();
    for (const [, o] of this.renderer_views)
      o instanceof AnnotationView && ((r = o.after_layout) == null || r.call(o));
    if (this._needs_layout = !1, this.model.setv({
      inner_width: Math.round(this.frame.bbox.width),
      inner_height: Math.round(this.frame.bbox.height),
      outer_width: Math.round(this.layout.bbox.width),
      outer_height: Math.round(this.layout.bbox.height)
    }, { no_change: !0 }), this.model.match_aspect !== !1 && (this.pause(), this._range_manager.update_dataranges(), this.unpause(!0)), !this._outer_bbox.equals(this.layout.bbox)) {
      const { width: o, height: s } = this.layout.bbox;
      this.canvas_view.resize(o, s), this._outer_bbox = this.layout.bbox, this._invalidate_all = !0, this._needs_paint = !0;
    }
    const { inner_bbox: e } = this.layout;
    this._inner_bbox.equals(e) || (this._inner_bbox = e, this._needs_paint = !0), this._needs_paint && this.paint();
  }
  repaint() {
    this._needs_layout && this._invalidate_layout(), this.paint();
  }
  paint() {
    this.is_paused || (this.model.visible && (logger.trace(`${this.toString()}.paint()`), this._actual_paint()), this._needs_notify && (this._needs_notify = !1, this.notify_finished()));
  }
  _actual_paint() {
    var u;
    const { document: e } = this.model;
    if (e != null) {
      const d = e.interactive_duration();
      d >= 0 && d < this.model.lod_interval ? setTimeout(() => {
        e.interactive_duration() > this.model.lod_timeout && e.interactive_stop(), this.request_paint("everything");
      }, this.model.lod_timeout) : e.interactive_stop();
    }
    this._range_manager.invalidate_dataranges && (this._range_manager.update_dataranges(), this._invalidate_layout());
    let r = !1, o = !1;
    if (this._invalidate_all)
      r = !0, o = !0;
    else
      for (const d of this._invalidated_painters) {
        const { level: f } = d.model;
        if (f != "overlay" ? r = !0 : o = !0, r && o)
          break;
      }
    this._invalidated_painters.clear(), this._invalidate_all = !1;
    const s = [
      this.frame.bbox.left,
      this.frame.bbox.top,
      this.frame.bbox.width,
      this.frame.bbox.height
    ], { primary: l, overlays: c } = this.canvas_view;
    r && (l.prepare(), this.canvas_view.prepare_webgl(s), this._map_hook(l.ctx, s), this._paint_empty(l.ctx, s), this._paint_outline(l.ctx, s), this._paint_levels(l.ctx, "image", s, !0), this._paint_levels(l.ctx, "underlay", s, !0), this._paint_levels(l.ctx, "glyph", s, !0), this._paint_levels(l.ctx, "guide", s, !1), this._paint_levels(l.ctx, "annotation", s, !1), l.finish()), (o || settings.wireframe) && (c.prepare(), this._paint_levels(c.ctx, "overlay", s, !1), settings.wireframe && this._paint_layout(c.ctx, this.layout), c.finish()), this._initial_state.range == null && (this._initial_state.range = (u = this._range_manager.compute_initial()) != null ? u : void 0), this._needs_paint = !1;
  }
  _paint_levels(e, r, o, s) {
    for (const l of this.computed_renderers) {
      if (l.level != r)
        continue;
      const c = this.renderer_views.get(l);
      e.save(), (s || c.needs_clip) && (e.beginPath(), e.rect(...o), e.clip()), c.render(), e.restore(), c.has_webgl && c.needs_webgl_blit && this.canvas_view.blit_webgl(e);
    }
  }
  _paint_layout(e, r) {
    const { x: o, y: s, width: l, height: c } = r.bbox;
    e.strokeStyle = "blue", e.strokeRect(o, s, l, c);
    for (const u of r)
      e.save(), r.absolute || e.translate(o, s), this._paint_layout(e, u), e.restore();
  }
  _map_hook(e, r) {
  }
  _paint_empty(e, r) {
    const [o, s, l, c] = [0, 0, this.layout.bbox.width, this.layout.bbox.height], [u, d, f, T] = r;
    this.visuals.border_fill.doit && (this.visuals.border_fill.set_value(e), e.fillRect(o, s, l, c), e.clearRect(u, d, f, T)), this.visuals.background_fill.doit && (this.visuals.background_fill.set_value(e), e.fillRect(u, d, f, T));
  }
  _paint_outline(e, r) {
    if (this.visuals.outline_line.doit) {
      e.save(), this.visuals.outline_line.set_value(e);
      let [o, s, l, c] = r;
      o + l == this.layout.bbox.width && (l -= 1), s + c == this.layout.bbox.height && (c -= 1), e.strokeRect(o, s, l, c), e.restore();
    }
  }
  to_blob() {
    return this.canvas_view.to_blob();
  }
  export(e, r = !0) {
    const o = e == "png" ? "canvas" : "svg", s = new CanvasLayer(o, r), { width: l, height: c } = this.layout.bbox;
    s.resize(l, c);
    const { canvas: u } = this.canvas_view.compose();
    return s.ctx.drawImage(u, 0, 0), s;
  }
  serializable_state() {
    const { children: e, ...r } = super.serializable_state(), o = this.get_renderer_views().map((s) => s.serializable_state()).filter((s) => s.bbox != null);
    return { ...r, children: [...e != null ? e : [], ...o] };
  }
}
PlotView.__name__ = "PlotView";
var _a$1z;
class Plot extends LayoutDOM {
  constructor(e) {
    super(e), this.use_map = !1;
  }
  _doc_attached() {
    super._doc_attached(), this._push_changes([
      [this.properties.inner_height, null, this.inner_height],
      [this.properties.inner_width, null, this.inner_width]
    ]);
  }
  initialize() {
    super.initialize(), this.reset = new Signal0(this, "reset");
    for (const e of values(this.extra_x_ranges).concat(this.x_range)) {
      let r = e.plots;
      isArray(r) && (r = r.concat(this), e.setv({ plots: r }, { silent: !0 }));
    }
    for (const e of values(this.extra_y_ranges).concat(this.y_range)) {
      let r = e.plots;
      isArray(r) && (r = r.concat(this), e.setv({ plots: r }, { silent: !0 }));
    }
  }
  add_layout(e, r = "center") {
    const o = this.properties[r].get_value();
    this.setv({ [r]: [...o, e] });
  }
  remove_layout(e) {
    const r = (o) => {
      remove_by(o, (s) => s == e);
    };
    r(this.left), r(this.right), r(this.above), r(this.below), r(this.center);
  }
  get data_renderers() {
    return this.renderers.filter((e) => e instanceof DataRenderer);
  }
  add_renderers(...e) {
    this.renderers = this.renderers.concat(e);
  }
  add_glyph(e, r = new ColumnDataSource(), o = {}) {
    const s = new GlyphRenderer({ ...o, data_source: r, glyph: e });
    return this.add_renderers(s), s;
  }
  add_tools(...e) {
    this.toolbar.tools = this.toolbar.tools.concat(e);
  }
  get panels() {
    return [...this.side_panels, ...this.center];
  }
  get side_panels() {
    const { above: e, below: r, left: o, right: s } = this;
    return concat$1([e, r, o, s]);
  }
}
_a$1z = Plot;
Plot.__name__ = "Plot";
_a$1z.prototype.default_view = PlotView, _a$1z.mixins([
  ["outline_", Line$2],
  ["background_", Fill$1],
  ["border_", Fill$1]
]), _a$1z.define(({ Boolean: t, Number: e, String: r, Array: o, Dict: s, Or: l, Ref: c, Null: u, Nullable: d }) => ({
  toolbar: [c(Toolbar), () => new Toolbar()],
  toolbar_location: [d(Location), "right"],
  toolbar_sticky: [t, !0],
  plot_width: [Alias("width")],
  plot_height: [Alias("height")],
  frame_width: [d(e), null],
  frame_height: [d(e), null],
  title: [l(c(Title), r, u), "", {
    convert: (f) => isString(f) ? new Title({ text: f }) : f
  }],
  title_location: [d(Location), "above"],
  above: [o(l(c(Annotation), c(Axis))), []],
  below: [o(l(c(Annotation), c(Axis))), []],
  left: [o(l(c(Annotation), c(Axis))), []],
  right: [o(l(c(Annotation), c(Axis))), []],
  center: [o(l(c(Annotation), c(Grid))), []],
  renderers: [o(c(Renderer)), []],
  x_range: [c(Range$1), () => new DataRange1d()],
  y_range: [c(Range$1), () => new DataRange1d()],
  x_scale: [c(Scale), () => new LinearScale()],
  y_scale: [c(Scale), () => new LinearScale()],
  extra_x_ranges: [s(c(Range$1)), {}],
  extra_y_ranges: [s(c(Range$1)), {}],
  extra_x_scales: [s(c(Scale)), {}],
  extra_y_scales: [s(c(Scale)), {}],
  lod_factor: [e, 10],
  lod_interval: [e, 300],
  lod_threshold: [d(e), 2e3],
  lod_timeout: [e, 500],
  hidpi: [t, !0],
  output_backend: [OutputBackend, "canvas"],
  min_border: [d(e), 5],
  min_border_top: [d(e), null],
  min_border_left: [d(e), null],
  min_border_bottom: [d(e), null],
  min_border_right: [d(e), null],
  inner_width: [e, 0],
  inner_height: [e, 0],
  outer_width: [e, 0],
  outer_height: [e, 0],
  match_aspect: [t, !1],
  aspect_scale: [e, 1],
  reset_policy: [ResetPolicy, "standard"]
})), _a$1z.override({
  width: 600,
  height: 600,
  outline_line_color: "#e5e5e5",
  border_fill_color: "#ffffff",
  background_fill_color: "#ffffff"
});
const gmaps_ready = new Signal0({}, "gmaps_ready"), load_google_api = function(t, e) {
  window._bokeh_gmaps_callback = () => gmaps_ready.emit();
  const r = encodeURIComponent, o = document.createElement("script");
  o.type = "text/javascript", o.src = `https://maps.googleapis.com/maps/api/js?v=${r(e)}&key=${r(t)}&callback=_bokeh_gmaps_callback`, document.body.appendChild(o);
};
class GMapPlotView extends PlotView {
  initialize() {
    this.pause(), super.initialize(), this._tiles_loaded = !1, this.zoom_count = 0;
    const { zoom: e, lat: r, lng: o } = this.model.map_options;
    if (this.initial_zoom = e, this.initial_lat = r, this.initial_lng = o, !this.model.api_key) {
      const s = "https://developers.google.com/maps/documentation/javascript/get-api-key";
      logger.error(`api_key is required. See ${s} for more information on how to obtain your own.`);
    }
    if (typeof google > "u" || google.maps == null) {
      if (typeof window._bokeh_gmaps_callback > "u") {
        const { api_key: s, api_version: l } = this.model;
        load_google_api(s, l);
      }
      gmaps_ready.connect(() => this.request_paint("everything"));
    }
    this.unpause();
  }
  remove() {
    remove(this.map_el), super.remove();
  }
  update_range(e, r) {
    var o, s;
    if (e == null)
      this.map.setCenter({ lat: this.initial_lat, lng: this.initial_lng }), this.map.setOptions({ zoom: this.initial_zoom }), super.update_range(null, r);
    else if (e.sdx != null || e.sdy != null)
      this.map.panBy((o = e.sdx) != null ? o : 0, (s = e.sdy) != null ? s : 0), super.update_range(e, r);
    else if (e.factor != null) {
      if (this.zoom_count !== 10) {
        this.zoom_count += 1;
        return;
      }
      this.zoom_count = 0, this.pause(), super.update_range(e, r);
      const l = e.factor < 0 ? -1 : 1, c = this.map.getZoom();
      if (c != null) {
        const u = c + l;
        if (u >= 2) {
          this.map.setZoom(u);
          const [d, f] = this._get_projected_bounds();
          f - d < 0 && this.map.setZoom(c);
        }
      }
      this.unpause();
    }
    this._set_bokeh_ranges();
  }
  _build_map() {
    const { maps: e } = google;
    this.map_types = {
      satellite: e.MapTypeId.SATELLITE,
      terrain: e.MapTypeId.TERRAIN,
      roadmap: e.MapTypeId.ROADMAP,
      hybrid: e.MapTypeId.HYBRID
    };
    const r = this.model.map_options, o = {
      center: new e.LatLng(r.lat, r.lng),
      zoom: r.zoom,
      disableDefaultUI: !0,
      mapTypeId: this.map_types[r.map_type],
      scaleControl: r.scale_control,
      tilt: r.tilt
    };
    r.styles != null && (o.styles = JSON.parse(r.styles)), this.map_el = div({ style: { position: "absolute" } }), this.canvas_view.add_underlay(this.map_el), this.map = new e.Map(this.map_el, o), e.event.addListener(this.map, "idle", () => this._set_bokeh_ranges()), e.event.addListener(this.map, "bounds_changed", () => this._set_bokeh_ranges()), e.event.addListenerOnce(this.map, "tilesloaded", () => this._render_finished()), this.connect(this.model.properties.map_options.change, () => this._update_options()), this.connect(this.model.map_options.properties.styles.change, () => this._update_styles()), this.connect(this.model.map_options.properties.lat.change, () => this._update_center("lat")), this.connect(this.model.map_options.properties.lng.change, () => this._update_center("lng")), this.connect(this.model.map_options.properties.zoom.change, () => this._update_zoom()), this.connect(this.model.map_options.properties.map_type.change, () => this._update_map_type()), this.connect(this.model.map_options.properties.scale_control.change, () => this._update_scale_control()), this.connect(this.model.map_options.properties.tilt.change, () => this._update_tilt());
  }
  _render_finished() {
    this._tiles_loaded = !0, this.notify_finished();
  }
  has_finished() {
    return super.has_finished() && this._tiles_loaded === !0;
  }
  _get_latlon_bounds() {
    const e = this.map.getBounds(), r = e.getNorthEast(), o = e.getSouthWest(), s = o.lng(), l = r.lng(), c = o.lat(), u = r.lat();
    return [s, l, c, u];
  }
  _get_projected_bounds() {
    const [e, r, o, s] = this._get_latlon_bounds(), [l, c] = wgs84_mercator.compute(e, o), [u, d] = wgs84_mercator.compute(r, s);
    return [l, u, c, d];
  }
  _set_bokeh_ranges() {
    const [e, r, o, s] = this._get_projected_bounds();
    this.frame.x_range.setv({ start: e, end: r }), this.frame.y_range.setv({ start: o, end: s });
  }
  _update_center(e) {
    var o;
    const r = (o = this.map.getCenter()) == null ? void 0 : o.toJSON();
    r != null && (r[e] = this.model.map_options[e], this.map.setCenter(r), this._set_bokeh_ranges());
  }
  _update_map_type() {
    this.map.setOptions({ mapTypeId: this.map_types[this.model.map_options.map_type] });
  }
  _update_scale_control() {
    this.map.setOptions({ scaleControl: this.model.map_options.scale_control });
  }
  _update_tilt() {
    this.map.setOptions({ tilt: this.model.map_options.tilt });
  }
  _update_options() {
    this._update_styles(), this._update_center("lat"), this._update_center("lng"), this._update_zoom(), this._update_map_type();
  }
  _update_styles() {
    this.map.setOptions({ styles: JSON.parse(this.model.map_options.styles) });
  }
  _update_zoom() {
    this.map.setOptions({ zoom: this.model.map_options.zoom }), this._set_bokeh_ranges();
  }
  _map_hook(e, r) {
    if (this.map == null && typeof google < "u" && google.maps != null && this._build_map(), this.map_el != null) {
      const [o, s, l, c] = r;
      this.map_el.style.top = `${s}px`, this.map_el.style.left = `${o}px`, this.map_el.style.width = `${l}px`, this.map_el.style.height = `${c}px`;
    }
  }
  _paint_empty(e, r) {
    const o = this.layout.bbox.width, s = this.layout.bbox.height, [l, c, u, d] = r;
    e.clearRect(0, 0, o, s), e.beginPath(), e.moveTo(0, 0), e.lineTo(0, s), e.lineTo(o, s), e.lineTo(o, 0), e.lineTo(0, 0), e.moveTo(l, c), e.lineTo(l + u, c), e.lineTo(l + u, c + d), e.lineTo(l, c + d), e.lineTo(l, c), e.closePath(), this.model.border_fill_color != null && (e.fillStyle = color2css(this.model.border_fill_color), e.fill());
  }
}
GMapPlotView.__name__ = "GMapPlotView";
var _a$1y, _b$5, _c$3;
class MapOptions extends Model {
  constructor(e) {
    super(e);
  }
}
_a$1y = MapOptions;
MapOptions.__name__ = "MapOptions";
_a$1y.define(({ Int: t, Number: e }) => ({
  lat: [e],
  lng: [e],
  zoom: [t, 12]
}));
class GMapOptions extends MapOptions {
  constructor(e) {
    super(e);
  }
}
_b$5 = GMapOptions;
GMapOptions.__name__ = "GMapOptions";
_b$5.define(({ Boolean: t, Int: e, String: r }) => ({
  map_type: [r, "roadmap"],
  scale_control: [t, !1],
  styles: [r],
  tilt: [e, 45]
}));
class GMapPlot extends Plot {
  constructor(e) {
    super(e), this.use_map = !0;
  }
}
_c$3 = GMapPlot;
GMapPlot.__name__ = "GMapPlot";
_c$3.prototype.default_view = GMapPlotView, _c$3.define(({ String: t, Ref: e }) => ({
  map_options: [e(GMapOptions)],
  api_key: [t],
  api_version: [t, "weekly"]
})), _c$3.override({
  x_range: () => new Range1d(),
  y_range: () => new Range1d()
});
var _a$1x;
class GraphRendererView extends DataRendererView {
  get glyph_view() {
    return this.node_view.glyph;
  }
  async lazy_initialize() {
    await super.lazy_initialize(), this.apply_coordinates();
    const { parent: e } = this, { edge_renderer: r, node_renderer: o } = this.model;
    this.edge_view = await build_view(r, { parent: e }), this.node_view = await build_view(o, { parent: e });
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.layout_provider.change, () => {
      this.apply_coordinates(), this.edge_view.set_data(), this.node_view.set_data(), this.request_render();
    });
  }
  apply_coordinates() {
    const { edge_renderer: e, node_renderer: r } = this.model;
    if (!(e.glyph instanceof MultiLine || e.glyph instanceof Patches))
      throw new Error(`${this}.edge_renderer.glyph must be a MultiLine glyph`);
    if (!(r.glyph instanceof XYGlyph))
      throw new Error(`${this}.node_renderer.glyph must be a XYGlyph glyph`);
    const o = this.model.layout_provider.edge_coordinates, s = this.model.layout_provider.node_coordinates;
    e.glyph.properties.xs.internal = !0, e.glyph.properties.ys.internal = !0, r.glyph.properties.x.internal = !0, r.glyph.properties.y.internal = !0, e.glyph.xs = { expr: o.x }, e.glyph.ys = { expr: o.y }, r.glyph.x = { expr: s.x }, r.glyph.y = { expr: s.y };
  }
  remove() {
    this.edge_view.remove(), this.node_view.remove(), super.remove();
  }
  _render() {
    this.edge_view.render(), this.node_view.render();
  }
  renderer_view(e) {
    if (e instanceof GlyphRenderer) {
      if (e == this.edge_view.model)
        return this.edge_view;
      if (e == this.node_view.model)
        return this.node_view;
    }
    return super.renderer_view(e);
  }
}
GraphRendererView.__name__ = "GraphRendererView";
class GraphRenderer extends DataRenderer {
  constructor(e) {
    super(e);
  }
  get_selection_manager() {
    return this.node_renderer.data_source.selection_manager;
  }
}
_a$1x = GraphRenderer;
GraphRenderer.__name__ = "GraphRenderer";
_a$1x.prototype.default_view = GraphRendererView, _a$1x.define(({ Ref: t }) => ({
  layout_provider: [t(LayoutProvider)],
  node_renderer: [t(GlyphRenderer)],
  edge_renderer: [t(GlyphRenderer)],
  selection_policy: [t(GraphHitTestPolicy), () => new NodesOnly()],
  inspection_policy: [t(GraphHitTestPolicy), () => new NodesOnly()]
}));
var _a$1w;
class WebDataSource extends ColumnDataSource {
  constructor(e) {
    super(e);
  }
  get_column(e) {
    const r = this.data[e];
    return r != null ? r : [];
  }
  get_length() {
    var e;
    return (e = super.get_length()) != null ? e : 0;
  }
  initialize() {
    super.initialize(), this.setup();
  }
  load_data(e, r, o) {
    const { adapter: s } = this;
    let l;
    switch (s != null ? l = s.execute(this, { response: e }) : l = e, r) {
      case "replace": {
        this.data = l;
        break;
      }
      case "append": {
        const c = this.data;
        for (const u of this.columns()) {
          const d = Array.from(c[u]), f = Array.from(l[u]), T = d.concat(f);
          l[u] = o != null ? T.slice(-o) : T;
        }
        this.data = l;
        break;
      }
    }
  }
}
_a$1w = WebDataSource;
WebDataSource.__name__ = "WebDataSource";
_a$1w.define(({ Any: t, Int: e, String: r, Nullable: o }) => ({
  max_size: [o(e), null],
  mode: [UpdateMode, "replace"],
  adapter: [o(t), null],
  data_url: [r]
}));
class ServerSentDataSource extends WebDataSource {
  constructor(e) {
    super(e), this.initialized = !1;
  }
  setup() {
    if (!this.initialized) {
      this.initialized = !0;
      const e = new EventSource(this.data_url);
      e.onmessage = (r) => {
        var o;
        this.load_data(JSON.parse(r.data), this.mode, (o = this.max_size) != null ? o : void 0);
      };
    }
  }
}
ServerSentDataSource.__name__ = "ServerSentDataSource";
var _a$1v;
class AjaxDataSource extends WebDataSource {
  constructor(e) {
    super(e), this.interval = null, this.initialized = !1;
  }
  destroy() {
    this.interval != null && clearInterval(this.interval), super.destroy();
  }
  setup() {
    if (!this.initialized && (this.initialized = !0, this.get_data(this.mode), this.polling_interval != null)) {
      const e = () => this.get_data(this.mode, this.max_size, this.if_modified);
      this.interval = setInterval(e, this.polling_interval);
    }
  }
  get_data(e, r = null, o = !1) {
    const s = this.prepare_request();
    s.addEventListener("load", () => this.do_load(s, e, r != null ? r : void 0)), s.addEventListener("error", () => this.do_error(s)), s.send();
  }
  prepare_request() {
    const e = new XMLHttpRequest();
    e.open(this.method, this.data_url, !0), e.withCredentials = !1, e.setRequestHeader("Content-Type", this.content_type);
    const r = this.http_headers;
    for (const [o, s] of entries(r))
      e.setRequestHeader(o, s);
    return e;
  }
  do_load(e, r, o) {
    if (e.status === 200) {
      const s = JSON.parse(e.responseText);
      this.load_data(s, r, o);
    }
  }
  do_error(e) {
    logger.error(`Failed to fetch JSON from ${this.data_url} with code ${e.status}`);
  }
}
_a$1v = AjaxDataSource;
AjaxDataSource.__name__ = "AjaxDataSource";
_a$1v.define(({ Boolean: t, Int: e, String: r, Dict: o, Nullable: s }) => ({
  polling_interval: [s(e), null],
  content_type: [r, "application/json"],
  http_headers: [o(r), {}],
  method: [HTTPMethod, "POST"],
  if_modified: [t, !1]
}));
var _a$1u;
function orNaN(t) {
  return t != null ? t : NaN;
}
const { hasOwnProperty: hasOwnProperty$2 } = Object.prototype;
class GeoJSONDataSource extends ColumnarDataSource {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this._update_data();
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.properties.geojson.change, () => this._update_data());
  }
  _update_data() {
    this.data = this.geojson_to_column_data();
  }
  _get_new_list_array(e) {
    return range(0, e).map((r) => []);
  }
  _get_new_nan_array(e) {
    return range(0, e).map((r) => NaN);
  }
  _add_properties(e, r, o, s) {
    var c;
    const l = (c = e.properties) != null ? c : {};
    for (const [u, d] of entries(l))
      hasOwnProperty$2.call(r, u) || (r[u] = this._get_new_nan_array(s)), r[u][o] = orNaN(d);
  }
  _add_geometry(e, r, o) {
    function s(l, c) {
      return l.concat([[NaN, NaN, NaN]]).concat(c);
    }
    switch (e.type) {
      case "Point": {
        const [l, c, u] = e.coordinates;
        r.x[o] = l, r.y[o] = c, r.z[o] = orNaN(u);
        break;
      }
      case "LineString": {
        const { coordinates: l } = e;
        for (let c = 0; c < l.length; c++) {
          const [u, d, f] = l[c];
          r.xs[o][c] = u, r.ys[o][c] = d, r.zs[o][c] = orNaN(f);
        }
        break;
      }
      case "Polygon": {
        e.coordinates.length > 1 && logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");
        const l = e.coordinates[0];
        for (let c = 0; c < l.length; c++) {
          const [u, d, f] = l[c];
          r.xs[o][c] = u, r.ys[o][c] = d, r.zs[o][c] = orNaN(f);
        }
        break;
      }
      case "MultiPoint": {
        logger.warn("MultiPoint not supported in Bokeh");
        break;
      }
      case "MultiLineString": {
        const l = e.coordinates.reduce(s);
        for (let c = 0; c < l.length; c++) {
          const [u, d, f] = l[c];
          r.xs[o][c] = u, r.ys[o][c] = d, r.zs[o][c] = orNaN(f);
        }
        break;
      }
      case "MultiPolygon": {
        const l = [];
        for (const u of e.coordinates)
          u.length > 1 && logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."), l.push(u[0]);
        const c = l.reduce(s);
        for (let u = 0; u < c.length; u++) {
          const [d, f, T] = c[u];
          r.xs[o][u] = d, r.ys[o][u] = f, r.zs[o][u] = orNaN(T);
        }
        break;
      }
      default:
        throw new Error(`Invalid GeoJSON geometry type: ${e.type}`);
    }
  }
  geojson_to_column_data() {
    const e = JSON.parse(this.geojson);
    let r;
    switch (e.type) {
      case "GeometryCollection": {
        if (e.geometries == null)
          throw new Error("No geometries found in GeometryCollection");
        if (e.geometries.length === 0)
          throw new Error("geojson.geometries must have one or more items");
        r = e.geometries;
        break;
      }
      case "FeatureCollection": {
        if (e.features == null)
          throw new Error("No features found in FeaturesCollection");
        if (e.features.length == 0)
          throw new Error("geojson.features must have one or more items");
        r = e.features;
        break;
      }
      default:
        throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level");
    }
    let o = 0;
    for (const c of r) {
      const u = c.type === "Feature" ? c.geometry : c;
      u.type == "GeometryCollection" ? o += u.geometries.length : o += 1;
    }
    const s = {
      x: this._get_new_nan_array(o),
      y: this._get_new_nan_array(o),
      z: this._get_new_nan_array(o),
      xs: this._get_new_list_array(o),
      ys: this._get_new_list_array(o),
      zs: this._get_new_list_array(o)
    };
    let l = 0;
    for (const c of r) {
      const u = c.type == "Feature" ? c.geometry : c;
      if (u.type == "GeometryCollection")
        for (const d of u.geometries)
          this._add_geometry(d, s, l), c.type === "Feature" && this._add_properties(c, s, l, o), l += 1;
      else
        this._add_geometry(u, s, l), c.type === "Feature" && this._add_properties(c, s, l, o), l += 1;
    }
    return s;
  }
}
_a$1u = GeoJSONDataSource;
GeoJSONDataSource.__name__ = "GeoJSONDataSource";
_a$1u.define(({ String: t }) => ({
  geojson: [t]
})), _a$1u.internal(({ Dict: t, Arrayable: e }) => ({
  data: [t(e), {}]
}));
var _a$1t;
class TileSource extends Model {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this.tiles = /* @__PURE__ */ new Map(), this._normalize_case();
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.change, () => this._clear_cache());
  }
  string_lookup_replace(e, r) {
    let o = e;
    for (const [s, l] of entries(r))
      o = o.replace(`{${s}}`, l);
    return o;
  }
  _normalize_case() {
    const e = this.url.replace("{x}", "{X}").replace("{y}", "{Y}").replace("{z}", "{Z}").replace("{q}", "{Q}").replace("{xmin}", "{XMIN}").replace("{ymin}", "{YMIN}").replace("{xmax}", "{XMAX}").replace("{ymax}", "{YMAX}");
    this.url = e;
  }
  _clear_cache() {
    this.tiles = /* @__PURE__ */ new Map();
  }
  tile_xyz_to_key(e, r, o) {
    return `${e}:${r}:${o}`;
  }
  key_to_tile_xyz(e) {
    const [r, o, s] = e.split(":").map((l) => parseInt(l));
    return [r, o, s];
  }
  sort_tiles_from_center(e, r) {
    const [o, s, l, c] = r, u = (l - o) / 2 + o, d = (c - s) / 2 + s;
    e.sort(function(f, T) {
      const Q = Math.sqrt((u - f[0]) ** 2 + (d - f[1]) ** 2), m = Math.sqrt((u - T[0]) ** 2 + (d - T[1]) ** 2);
      return Q - m;
    });
  }
  get_image_url(e, r, o) {
    return this.string_lookup_replace(this.url, this.extra_url_vars).replace("{X}", e.toString()).replace("{Y}", r.toString()).replace("{Z}", o.toString());
  }
}
_a$1t = TileSource;
TileSource.__name__ = "TileSource";
_a$1t.define(({ Number: t, String: e, Dict: r, Nullable: o }) => ({
  url: [e, ""],
  tile_size: [t, 256],
  max_zoom: [t, 30],
  min_zoom: [t, 0],
  extra_url_vars: [r(e), {}],
  attribution: [e, ""],
  x_origin_offset: [t],
  y_origin_offset: [t],
  initial_resolution: [o(t), null]
}));
function meters_to_geographic(t, e) {
  return wgs84_mercator.invert(t, e);
}
function meters_extent_to_geographic(t) {
  const [e, r, o, s] = t, [l, c] = meters_to_geographic(e, r), [u, d] = meters_to_geographic(o, s);
  return [l, c, u, d];
}
var _a$1s;
class MercatorTileSource extends TileSource {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this._resolutions = range(this.min_zoom, this.max_zoom + 1).map((e) => this.get_resolution(e));
  }
  _computed_initial_resolution() {
    return this.initial_resolution != null ? this.initial_resolution : 2 * Math.PI * 6378137 / this.tile_size;
  }
  is_valid_tile(e, r, o) {
    return !(!this.wrap_around && (e < 0 || e >= 2 ** o) || r < 0 || r >= 2 ** o);
  }
  parent_by_tile_xyz(e, r, o) {
    const s = this.tile_xyz_to_quadkey(e, r, o), l = s.substring(0, s.length - 1);
    return this.quadkey_to_tile_xyz(l);
  }
  get_resolution(e) {
    return this._computed_initial_resolution() / 2 ** e;
  }
  get_resolution_by_extent(e, r, o) {
    const s = (e[2] - e[0]) / o, l = (e[3] - e[1]) / r;
    return [s, l];
  }
  get_level_by_extent(e, r, o) {
    const s = (e[2] - e[0]) / o, l = (e[3] - e[1]) / r, c = Math.max(s, l);
    let u = 0;
    for (const d of this._resolutions) {
      if (c > d) {
        if (u == 0)
          return 0;
        if (u > 0)
          return u - 1;
      }
      u += 1;
    }
    return u - 1;
  }
  get_closest_level_by_extent(e, r, o) {
    const s = (e[2] - e[0]) / o, l = (e[3] - e[1]) / r, c = Math.max(s, l), u = this._resolutions.reduce(function(d, f) {
      return Math.abs(f - c) < Math.abs(d - c) ? f : d;
    });
    return this._resolutions.indexOf(u);
  }
  snap_to_zoom_level(e, r, o, s) {
    const [l, c, u, d] = e, f = this._resolutions[s];
    let T = o * f, Q = r * f;
    if (!this.snap_to_zoom) {
      const v = (u - l) / T, b = (d - c) / Q;
      v > b ? (T = u - l, Q = Q * v) : (T = T * b, Q = d - c);
    }
    const m = (T - (u - l)) / 2, g = (Q - (d - c)) / 2;
    return [l - m, c - g, u + m, d + g];
  }
  tms_to_wmts(e, r, o) {
    return [e, 2 ** o - 1 - r, o];
  }
  wmts_to_tms(e, r, o) {
    return [e, 2 ** o - 1 - r, o];
  }
  pixels_to_meters(e, r, o) {
    const s = this.get_resolution(o), l = e * s - this.x_origin_offset, c = r * s - this.y_origin_offset;
    return [l, c];
  }
  meters_to_pixels(e, r, o) {
    const s = this.get_resolution(o), l = (e + this.x_origin_offset) / s, c = (r + this.y_origin_offset) / s;
    return [l, c];
  }
  pixels_to_tile(e, r) {
    let o = Math.ceil(e / this.tile_size);
    o = o === 0 ? o : o - 1;
    const s = Math.max(Math.ceil(r / this.tile_size) - 1, 0);
    return [o, s];
  }
  pixels_to_raster(e, r, o) {
    const s = this.tile_size << o;
    return [e, s - r];
  }
  meters_to_tile(e, r, o) {
    const [s, l] = this.meters_to_pixels(e, r, o);
    return this.pixels_to_tile(s, l);
  }
  get_tile_meter_bounds(e, r, o) {
    const [s, l] = this.pixels_to_meters(e * this.tile_size, r * this.tile_size, o), [c, u] = this.pixels_to_meters((e + 1) * this.tile_size, (r + 1) * this.tile_size, o);
    return [s, l, c, u];
  }
  get_tile_geographic_bounds(e, r, o) {
    const s = this.get_tile_meter_bounds(e, r, o), [l, c, u, d] = meters_extent_to_geographic(s);
    return [l, c, u, d];
  }
  get_tiles_by_extent(e, r, o = 1) {
    const [s, l, c, u] = e;
    let [d, f] = this.meters_to_tile(s, l, r), [T, Q] = this.meters_to_tile(c, u, r);
    d -= o, f -= o, T += o, Q += o;
    const m = [];
    for (let g = Q; g >= f; g--)
      for (let v = d; v <= T; v++)
        this.is_valid_tile(v, g, r) && m.push([v, g, r, this.get_tile_meter_bounds(v, g, r)]);
    return this.sort_tiles_from_center(m, [d, f, T, Q]), m;
  }
  quadkey_to_tile_xyz(e) {
    let r = 0, o = 0;
    const s = e.length;
    for (let l = s; l > 0; l--) {
      const c = e.charAt(s - l), u = 1 << l - 1;
      switch (c) {
        case "0":
          continue;
        case "1":
          r |= u;
          break;
        case "2":
          o |= u;
          break;
        case "3":
          r |= u, o |= u;
          break;
        default:
          throw new TypeError(`Invalid Quadkey: ${e}`);
      }
    }
    return [r, o, s];
  }
  tile_xyz_to_quadkey(e, r, o) {
    let s = "";
    for (let l = o; l > 0; l--) {
      const c = 1 << l - 1;
      let u = 0;
      (e & c) !== 0 && (u += 1), (r & c) !== 0 && (u += 2), s += u.toString();
    }
    return s;
  }
  children_by_tile_xyz(e, r, o) {
    const s = this.tile_xyz_to_quadkey(e, r, o), l = [];
    for (let c = 0; c <= 3; c++) {
      const [u, d, f] = this.quadkey_to_tile_xyz(s + c.toString()), T = this.get_tile_meter_bounds(u, d, f);
      l.push([u, d, f, T]);
    }
    return l;
  }
  get_closest_parent_by_tile_xyz(e, r, o) {
    const s = this.calculate_world_x_by_tile_xyz(e, r, o);
    [e, r, o] = this.normalize_xyz(e, r, o);
    let l = this.tile_xyz_to_quadkey(e, r, o);
    for (; l.length > 0; )
      if (l = l.substring(0, l.length - 1), [e, r, o] = this.quadkey_to_tile_xyz(l), [e, r, o] = this.denormalize_xyz(e, r, o, s), this.tiles.has(this.tile_xyz_to_key(e, r, o)))
        return [e, r, o];
    return [0, 0, 0];
  }
  normalize_xyz(e, r, o) {
    if (this.wrap_around) {
      const s = 2 ** o;
      return [(e % s + s) % s, r, o];
    } else
      return [e, r, o];
  }
  denormalize_xyz(e, r, o, s) {
    return [e + s * 2 ** o, r, o];
  }
  denormalize_meters(e, r, o, s) {
    return [e + s * 2 * Math.PI * 6378137, r];
  }
  calculate_world_x_by_tile_xyz(e, r, o) {
    return Math.floor(e / 2 ** o);
  }
}
_a$1s = MercatorTileSource;
MercatorTileSource.__name__ = "MercatorTileSource";
_a$1s.define(({ Boolean: t }) => ({
  snap_to_zoom: [t, !1],
  wrap_around: [t, !0]
})), _a$1s.override({
  x_origin_offset: 2003750834e-2,
  y_origin_offset: 2003750834e-2,
  initial_resolution: 156543.03392804097
});
var _a$1r;
class BBoxTileSource extends MercatorTileSource {
  constructor(e) {
    super(e);
  }
  get_image_url(e, r, o) {
    const s = this.string_lookup_replace(this.url, this.extra_url_vars);
    let l, c, u, d;
    return this.use_latlon ? [c, d, l, u] = this.get_tile_geographic_bounds(e, r, o) : [c, d, l, u] = this.get_tile_meter_bounds(e, r, o), s.replace("{XMIN}", c.toString()).replace("{YMIN}", d.toString()).replace("{XMAX}", l.toString()).replace("{YMAX}", u.toString());
  }
}
_a$1r = BBoxTileSource;
BBoxTileSource.__name__ = "BBoxTileSource";
_a$1r.define(({ Boolean: t }) => ({
  use_latlon: [t, !1]
}));
class QUADKEYTileSource extends MercatorTileSource {
  constructor(e) {
    super(e);
  }
  get_image_url(e, r, o) {
    const s = this.string_lookup_replace(this.url, this.extra_url_vars), [l, c, u] = this.tms_to_wmts(e, r, o), d = this.tile_xyz_to_quadkey(l, c, u);
    return s.replace("{Q}", d);
  }
}
QUADKEYTileSource.__name__ = "QUADKEYTileSource";
class WMTSTileSource extends MercatorTileSource {
  constructor(e) {
    super(e);
  }
  get_image_url(e, r, o) {
    const s = this.string_lookup_replace(this.url, this.extra_url_vars), [l, c, u] = this.tms_to_wmts(e, r, o);
    return s.replace("{X}", l.toString()).replace("{Y}", c.toString()).replace("{Z}", u.toString());
  }
}
WMTSTileSource.__name__ = "WMTSTileSource";
const tile_attribution = "bk-tile-attribution", tiles_css = ".bk-root .bk-tile-attribution a{color:black;}";
var _a$1q;
class TileRendererView extends RendererView {
  initialize() {
    this._tiles = [], super.initialize();
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.change, () => this.request_render()), this.connect(this.model.tile_source.change, () => this.request_render());
  }
  remove() {
    this.attribution_el != null && removeElement(this.attribution_el), super.remove();
  }
  styles() {
    return [...super.styles(), tiles_css];
  }
  get_extent() {
    return [this.x_range.start, this.y_range.start, this.x_range.end, this.y_range.end];
  }
  get map_plot() {
    return this.plot_model;
  }
  get map_canvas() {
    return this.layer.ctx;
  }
  get map_frame() {
    return this.plot_view.frame;
  }
  get x_range() {
    return this.map_plot.x_range;
  }
  get y_range() {
    return this.map_plot.y_range;
  }
  _set_data() {
    this.extent = this.get_extent(), this._last_height = void 0, this._last_width = void 0;
  }
  _update_attribution() {
    this.attribution_el != null && removeElement(this.attribution_el);
    const { attribution: e } = this.model.tile_source;
    if (isString(e) && e.length > 0) {
      const { layout: r, frame: o } = this.plot_view, s = r.bbox.width - o.bbox.right, l = r.bbox.height - o.bbox.bottom, c = o.bbox.width;
      this.attribution_el = div({
        class: tile_attribution,
        style: {
          position: "absolute",
          right: `${s}px`,
          bottom: `${l}px`,
          "max-width": `${c - 4}px`,
          padding: "2px",
          "background-color": "rgba(255,255,255,0.5)",
          "font-size": "9px",
          "line-height": "1.05",
          "white-space": "nowrap",
          overflow: "hidden",
          "text-overflow": "ellipsis"
        }
      }), this.plot_view.canvas_view.add_event(this.attribution_el), this.attribution_el.innerHTML = e, this.attribution_el.title = this.attribution_el.textContent.replace(/\s*\n\s*/g, " ");
    }
  }
  _map_data() {
    this.initial_extent = this.get_extent();
    const e = this.model.tile_source.get_level_by_extent(this.initial_extent, this.map_frame.bbox.height, this.map_frame.bbox.width), r = this.model.tile_source.snap_to_zoom_level(this.initial_extent, this.map_frame.bbox.height, this.map_frame.bbox.width, e);
    this.x_range.start = r[0], this.y_range.start = r[1], this.x_range.end = r[2], this.y_range.end = r[3], this.x_range instanceof Range1d && (this.x_range.reset_start = r[0], this.x_range.reset_end = r[2]), this.y_range instanceof Range1d && (this.y_range.reset_start = r[1], this.y_range.reset_end = r[3]), this._update_attribution();
  }
  _create_tile(e, r, o, s, l = !1) {
    const c = this.model.tile_source.tile_xyz_to_quadkey(e, r, o), u = this.model.tile_source.tile_xyz_to_key(e, r, o);
    if (this.model.tile_source.tiles.has(u))
      return;
    const [d, f, T] = this.model.tile_source.normalize_xyz(e, r, o), Q = this.model.tile_source.get_image_url(d, f, T), m = {
      img: void 0,
      tile_coords: [e, r, o],
      normalized_coords: [d, f, T],
      quadkey: c,
      cache_key: u,
      bounds: s,
      loaded: !1,
      finished: !1,
      x_coord: s[0],
      y_coord: s[3]
    };
    this.model.tile_source.tiles.set(u, m), this._tiles.push(m), new ImageLoader(Q, {
      loaded: (g) => {
        Object.assign(m, { img: g, loaded: !0 }), l ? (m.finished = !0, this.notify_finished()) : this.request_render();
      },
      failed() {
        m.finished = !0;
      }
    });
  }
  _enforce_aspect_ratio() {
    if (this._last_height !== this.map_frame.bbox.height || this._last_width !== this.map_frame.bbox.width) {
      const e = this.get_extent(), r = this.model.tile_source.get_level_by_extent(e, this.map_frame.bbox.height, this.map_frame.bbox.width), o = this.model.tile_source.snap_to_zoom_level(e, this.map_frame.bbox.height, this.map_frame.bbox.width, r);
      this.x_range.setv({ start: o[0], end: o[2] }), this.y_range.setv({ start: o[1], end: o[3] }), this.extent = o, this._last_height = this.map_frame.bbox.height, this._last_width = this.map_frame.bbox.width;
    }
  }
  has_finished() {
    if (!super.has_finished() || this._tiles.length == 0)
      return !1;
    for (const e of this._tiles)
      if (!e.finished)
        return !1;
    return !0;
  }
  _render() {
    this.map_initialized == null && (this._set_data(), this._map_data(), this.map_initialized = !0), this._enforce_aspect_ratio(), this._update(), this.prefetch_timer != null && clearTimeout(this.prefetch_timer), this.prefetch_timer = setTimeout(this._prefetch_tiles.bind(this), 500), this.has_finished() && this.notify_finished();
  }
  _draw_tile(e) {
    const r = this.model.tile_source.tiles.get(e);
    if (r != null && r.loaded) {
      const [[o], [s]] = this.coordinates.map_to_screen([r.bounds[0]], [r.bounds[3]]), [[l], [c]] = this.coordinates.map_to_screen([r.bounds[2]], [r.bounds[1]]), u = l - o, d = c - s, f = o, T = s, Q = this.map_canvas.getImageSmoothingEnabled();
      this.map_canvas.setImageSmoothingEnabled(this.model.smoothing), this.map_canvas.drawImage(r.img, f, T, u, d), this.map_canvas.setImageSmoothingEnabled(Q), r.finished = !0;
    }
  }
  _set_rect() {
    const e = this.plot_model.outline_line_width, r = this.map_frame.bbox.left + e / 2, o = this.map_frame.bbox.top + e / 2, s = this.map_frame.bbox.width - e, l = this.map_frame.bbox.height - e;
    this.map_canvas.rect(r, o, s, l), this.map_canvas.clip();
  }
  _render_tiles(e) {
    this.map_canvas.save(), this._set_rect(), this.map_canvas.globalAlpha = this.model.alpha;
    for (const r of e)
      this._draw_tile(r);
    this.map_canvas.restore();
  }
  _prefetch_tiles() {
    const { tile_source: e } = this.model, r = this.get_extent(), o = this.map_frame.bbox.height, s = this.map_frame.bbox.width, l = this.model.tile_source.get_level_by_extent(r, o, s), c = this.model.tile_source.get_tiles_by_extent(r, l);
    for (let u = 0, d = Math.min(10, c.length); u < d; u++) {
      const [f, T, Q] = c[u], m = this.model.tile_source.children_by_tile_xyz(f, T, Q);
      for (const g of m) {
        const [v, b, L, A] = g;
        e.tiles.has(e.tile_xyz_to_key(v, b, L)) || this._create_tile(v, b, L, A, !0);
      }
    }
  }
  _fetch_tiles(e) {
    for (const r of e) {
      const [o, s, l, c] = r;
      this._create_tile(o, s, l, c);
    }
  }
  _update() {
    const { tile_source: e } = this.model, { min_zoom: r } = e, { max_zoom: o } = e;
    let s = this.get_extent();
    const l = this.extent[2] - this.extent[0] < s[2] - s[0], c = this.map_frame.bbox.height, u = this.map_frame.bbox.width;
    let d = e.get_level_by_extent(s, c, u), f = !1;
    d < r ? (s = this.extent, d = r, f = !0) : d > o && (s = this.extent, d = o, f = !0), f && (this.x_range.setv({ start: s[0], end: s[2] }), this.y_range.setv({ start: s[1], end: s[3] })), this.extent = s;
    const T = e.get_tiles_by_extent(s, d), Q = [], m = [], g = [], v = [];
    for (const b of T) {
      const [L, A, M] = b, S = e.tile_xyz_to_key(L, A, M), E = e.tiles.get(S);
      if (E != null && E.loaded)
        m.push(S);
      else if (this.model.render_parents) {
        const [k, w, O] = e.get_closest_parent_by_tile_xyz(L, A, M), D = e.tile_xyz_to_key(k, w, O), R = e.tiles.get(D);
        if (R != null && R.loaded && !includes(g, D) && g.push(D), l) {
          const B = e.children_by_tile_xyz(L, A, M);
          for (const [F, j, z] of B) {
            const q = e.tile_xyz_to_key(F, j, z);
            e.tiles.has(q) && v.push(q);
          }
        }
      }
      E == null && Q.push(b);
    }
    this._render_tiles(g), this._render_tiles(v), this._render_tiles(m), this.render_timer != null && clearTimeout(this.render_timer), this.render_timer = setTimeout(() => this._fetch_tiles(Q), 65);
  }
}
TileRendererView.__name__ = "TileRendererView";
class TileRenderer extends Renderer {
  constructor(e) {
    super(e);
  }
}
_a$1q = TileRenderer;
TileRenderer.__name__ = "TileRenderer";
_a$1q.prototype.default_view = TileRendererView, _a$1q.define(({ Boolean: t, Number: e, Ref: r }) => ({
  alpha: [e, 1],
  smoothing: [t, !0],
  tile_source: [r(TileSource), () => new WMTSTileSource()],
  render_parents: [t, !0]
})), _a$1q.override({
  level: "image"
});
class TMSTileSource extends MercatorTileSource {
  constructor(e) {
    super(e);
  }
  get_image_url(e, r, o) {
    return this.string_lookup_replace(this.url, this.extra_url_vars).replace("{X}", e.toString()).replace("{Y}", r.toString()).replace("{Z}", o.toString());
  }
}
TMSTileSource.__name__ = "TMSTileSource";
var _a$1p;
class Texture extends Model {
  constructor(e) {
    super(e);
  }
}
_a$1p = Texture;
Texture.__name__ = "Texture";
_a$1p.define(() => ({
  repetition: [TextureRepetition, "repeat"]
}));
var _a$1o;
class CanvasTexture extends Texture {
  constructor(e) {
    super(e);
  }
  get func() {
    const e = use_strict(this.code);
    return new Function("ctx", "color", "scale", "weight", e);
  }
  get_pattern(e, r, o) {
    const s = document.createElement("canvas");
    s.width = r, s.height = r;
    const l = s.getContext("2d");
    return this.func.call(this, l, e, r, o), s;
  }
}
_a$1o = CanvasTexture;
CanvasTexture.__name__ = "CanvasTexture";
_a$1o.define(({ String: t }) => ({
  code: [t]
}));
var _a$1n;
class ImageURLTexture extends Texture {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this._loader = new ImageLoader(this.url);
  }
  get_pattern(e, r, o) {
    const { _loader: s } = this;
    return this._loader.finished ? s.image : s.promise;
  }
}
_a$1n = ImageURLTexture;
ImageURLTexture.__name__ = "ImageURLTexture";
_a$1n.define(({ String: t }) => ({
  url: [t]
}));
var _a$1m;
class CustomActionButtonView extends ActionToolButtonView {
  css_classes() {
    return super.css_classes().concat("bk-toolbar-button-custom-action");
  }
}
CustomActionButtonView.__name__ = "CustomActionButtonView";
class CustomActionView extends ActionToolView {
  doit() {
    var e;
    (e = this.model.callback) == null || e.execute(this.model);
  }
}
CustomActionView.__name__ = "CustomActionView";
class CustomAction extends ActionTool {
  constructor(e) {
    super(e), this.tool_name = "Custom Action", this.button_view = CustomActionButtonView;
  }
}
_a$1m = CustomAction;
CustomAction.__name__ = "CustomAction";
_a$1m.prototype.default_view = CustomActionView, _a$1m.define(({ Any: t, String: e, Nullable: r }) => ({
  callback: [r(t)],
  icon: [e]
})), _a$1m.override({
  description: "Perform a Custom Action"
});
var _a$1l;
class RedoToolView extends ActionToolView {
  connect_signals() {
    super.connect_signals(), this.connect(this.plot_view.state.changed, () => this.model.disabled = !this.plot_view.state.can_redo);
  }
  doit() {
    const e = this.plot_view.state.redo();
    (e == null ? void 0 : e.range) != null && this.plot_view.trigger_ranges_update_event();
  }
}
RedoToolView.__name__ = "RedoToolView";
class RedoTool extends ActionTool {
  constructor(e) {
    super(e), this.tool_name = "Redo", this.icon = tool_icon_redo;
  }
}
_a$1l = RedoTool;
RedoTool.__name__ = "RedoTool";
_a$1l.prototype.default_view = RedoToolView, _a$1l.override({
  disabled: !0
}), _a$1l.register_alias("redo", () => new RedoTool());
var _a$1k;
class ResetToolView extends ActionToolView {
  doit() {
    this.plot_view.reset();
  }
}
ResetToolView.__name__ = "ResetToolView";
class ResetTool extends ActionTool {
  constructor(e) {
    super(e), this.tool_name = "Reset", this.icon = tool_icon_reset;
  }
}
_a$1k = ResetTool;
ResetTool.__name__ = "ResetTool";
_a$1k.prototype.default_view = ResetToolView, _a$1k.register_alias("reset", () => new ResetTool());
var _a$1j;
class SaveToolView extends ActionToolView {
  async copy() {
    const e = await this.plot_view.to_blob(), r = new ClipboardItem({ [e.type]: Promise.resolve(e) });
    await navigator.clipboard.write([r]);
  }
  async save(e) {
    const r = await this.plot_view.to_blob(), o = document.createElement("a");
    o.href = URL.createObjectURL(r), o.download = e, o.target = "_blank", o.dispatchEvent(new MouseEvent("click"));
  }
  doit(e = "save") {
    switch (e) {
      case "save":
        this.save("bokeh_plot");
        break;
      case "copy":
        this.copy();
        break;
    }
  }
}
SaveToolView.__name__ = "SaveToolView";
class SaveTool extends ActionTool {
  constructor(e) {
    super(e), this.tool_name = "Save", this.icon = tool_icon_save;
  }
  get menu() {
    return [
      {
        icon: "bk-tool-icon-copy-to-clipboard",
        tooltip: "Copy image to clipboard",
        if: () => typeof ClipboardItem < "u",
        handler: () => {
          this.do.emit("copy");
        }
      }
    ];
  }
}
_a$1j = SaveTool;
SaveTool.__name__ = "SaveTool";
_a$1j.prototype.default_view = SaveToolView, _a$1j.register_alias("save", () => new SaveTool());
var _a$1i;
class UndoToolView extends ActionToolView {
  connect_signals() {
    super.connect_signals(), this.connect(this.plot_view.state.changed, () => this.model.disabled = !this.plot_view.state.can_undo);
  }
  doit() {
    const e = this.plot_view.state.undo();
    (e == null ? void 0 : e.range) != null && this.plot_view.trigger_ranges_update_event();
  }
}
UndoToolView.__name__ = "UndoToolView";
class UndoTool extends ActionTool {
  constructor(e) {
    super(e), this.tool_name = "Undo", this.icon = tool_icon_undo;
  }
}
_a$1i = UndoTool;
UndoTool.__name__ = "UndoTool";
_a$1i.prototype.default_view = UndoToolView, _a$1i.override({
  disabled: !0
}), _a$1i.register_alias("undo", () => new UndoTool());
function scale_highlow(t, e, r) {
  const [o, s] = [t.start, t.end], l = r != null ? r : (s + o) / 2, c = o - (o - l) * e, u = s - (s - l) * e;
  return [c, u];
}
function get_info(t, [e, r]) {
  const o = /* @__PURE__ */ new Map();
  for (const [s, l] of t) {
    const [c, u] = l.r_invert(e, r);
    o.set(s, { start: c, end: u });
  }
  return o;
}
function scale_range(t, e, r = !0, o = !0, s) {
  e = clamp(e, -0.9, 0.9);
  const l = r ? e : 0, [c, u] = scale_highlow(t.bbox.h_range, l, s != null ? s.x : void 0), d = get_info(t.x_scales, [c, u]), f = o ? e : 0, [T, Q] = scale_highlow(t.bbox.v_range, f, s != null ? s.y : void 0), m = get_info(t.y_scales, [T, Q]);
  return { xrs: d, yrs: m, factor: e };
}
var _a$1h;
class ZoomBaseToolView extends ActionToolView {
  doit() {
    var c;
    const e = this.plot_view.frame, r = this.model.dimensions, o = r == "width" || r == "both", s = r == "height" || r == "both", l = scale_range(e, this.model.sign * this.model.factor, o, s);
    this.plot_view.state.push("zoom_out", { range: l }), this.plot_view.update_range(l, { scrolling: !0, maintain_focus: this.model.maintain_focus }), (c = this.model.document) == null || c.interactive_start(this.plot_model), this.plot_view.trigger_ranges_update_event();
  }
}
ZoomBaseToolView.__name__ = "ZoomBaseToolView";
class ZoomBaseTool extends ActionTool {
  constructor(e) {
    super(e), this.maintain_focus = !0;
  }
  get tooltip() {
    return this._get_dim_tooltip(this.dimensions);
  }
}
_a$1h = ZoomBaseTool;
ZoomBaseTool.__name__ = "ZoomBaseTool";
_a$1h.define(({ Percent: t }) => ({
  factor: [t, 0.1],
  dimensions: [Dimensions, "both"]
}));
var _a$1g;
class ZoomInToolView extends ZoomBaseToolView {
}
ZoomInToolView.__name__ = "ZoomInToolView";
class ZoomInTool extends ZoomBaseTool {
  constructor(e) {
    super(e), this.sign = 1, this.tool_name = "Zoom In", this.icon = tool_icon_zoom_in;
  }
}
_a$1g = ZoomInTool;
ZoomInTool.__name__ = "ZoomInTool";
_a$1g.prototype.default_view = ZoomInToolView, _a$1g.register_alias("zoom_in", () => new ZoomInTool({ dimensions: "both" })), _a$1g.register_alias("xzoom_in", () => new ZoomInTool({ dimensions: "width" })), _a$1g.register_alias("yzoom_in", () => new ZoomInTool({ dimensions: "height" }));
var _a$1f;
class ZoomOutToolView extends ZoomBaseToolView {
}
ZoomOutToolView.__name__ = "ZoomOutToolView";
class ZoomOutTool extends ZoomBaseTool {
  constructor(e) {
    super(e), this.sign = -1, this.tool_name = "Zoom Out", this.icon = tool_icon_zoom_out;
  }
}
_a$1f = ZoomOutTool;
ZoomOutTool.__name__ = "ZoomOutTool";
_a$1f.prototype.default_view = ZoomOutToolView, _a$1f.define(({ Boolean: t }) => ({
  maintain_focus: [t, !0]
})), _a$1f.register_alias("zoom_out", () => new ZoomOutTool({ dimensions: "both" })), _a$1f.register_alias("xzoom_out", () => new ZoomOutTool({ dimensions: "width" })), _a$1f.register_alias("yzoom_out", () => new ZoomOutTool({ dimensions: "height" }));
var _a$1e;
class EditToolView extends GestureToolView {
  constructor() {
    super(...arguments), this._mouse_in_frame = !0;
  }
  _select_mode(e) {
    const { shiftKey: r, ctrlKey: o } = e;
    if (!r && !o)
      return "replace";
    if (r && !o)
      return "append";
    if (!r && o)
      return "intersect";
    if (r && o)
      return "subtract";
    unreachable();
  }
  _move_enter(e) {
    this._mouse_in_frame = !0;
  }
  _move_exit(e) {
    this._mouse_in_frame = !1;
  }
  _map_drag(e, r, o) {
    if (!this.plot_view.frame.bbox.contains(e, r))
      return null;
    const l = this.plot_view.renderer_view(o);
    if (l == null)
      return null;
    const c = l.coordinates.x_scale.invert(e), u = l.coordinates.y_scale.invert(r);
    return [c, u];
  }
  _delete_selected(e) {
    const r = e.data_source, o = r.selected.indices;
    o.sort();
    for (const s of r.columns()) {
      const l = r.get_array(s);
      for (let c = 0; c < o.length; c++) {
        const u = o[c];
        l.splice(u - c, 1);
      }
    }
    this._emit_cds_changes(r);
  }
  _pop_glyphs(e, r) {
    const o = e.columns();
    if (!(!r || !o.length))
      for (const s of o) {
        let l = e.get_array(s);
        const c = l.length - r + 1;
        c < 1 || (isArray(l) || (l = Array.from(l), e.data[s] = l), l.splice(0, c));
      }
  }
  _emit_cds_changes(e, r = !0, o = !0, s = !0) {
    o && e.selection_manager.clear(), r && e.change.emit(), s && (e.data = e.data, e.properties.data.change.emit());
  }
  _drag_points(e, r, o = "both") {
    if (this._basepoint == null)
      return;
    const [s, l] = this._basepoint;
    for (const c of r) {
      const u = this._map_drag(s, l, c), d = this._map_drag(e.sx, e.sy, c);
      if (d == null || u == null)
        continue;
      const [f, T] = d, [Q, m] = u, [g, v] = [f - Q, T - m], b = c.glyph, L = c.data_source, [A, M] = [b.x.field, b.y.field];
      for (const S of L.selected.indices)
        A && (o == "width" || o == "both") && (L.data[A][S] += g), M && (o == "height" || o == "both") && (L.data[M][S] += v);
      L.change.emit();
    }
    this._basepoint = [e.sx, e.sy];
  }
  _pad_empty_columns(e, r) {
    for (const o of e.columns())
      includes(r, o) || e.get_array(o).push(this.model.empty_value);
  }
  _select_event(e, r, o) {
    const s = this.plot_view.frame, { sx: l, sy: c } = e;
    if (!s.bbox.contains(l, c))
      return [];
    const u = { type: "point", sx: l, sy: c }, d = [];
    for (const f of o) {
      const T = f.get_selection_manager(), Q = f.data_source, m = this.plot_view.renderer_view(f);
      m != null && (T.select([m], u, !0, r) && d.push(f), Q.properties.selected.change.emit());
    }
    return d;
  }
}
EditToolView.__name__ = "EditToolView";
class EditTool extends GestureTool {
  constructor(e) {
    super(e);
  }
  get computed_icon() {
    var e;
    return (e = this.custom_icon) != null ? e : this.icon;
  }
}
_a$1e = EditTool;
EditTool.__name__ = "EditTool";
_a$1e.define(({ Unknown: t, String: e, Array: r, Ref: o, Nullable: s }) => ({
  custom_icon: [s(e), null],
  empty_value: [t],
  renderers: [r(o(GlyphRenderer)), []]
}));
var _a$1d;
class BoxEditToolView extends EditToolView {
  _tap(e) {
    this._draw_basepoint != null || this._basepoint != null || this._select_event(e, this._select_mode(e), this.model.renderers);
  }
  _keyup(e) {
    if (!(!this.model.active || !this._mouse_in_frame))
      for (const r of this.model.renderers)
        e.keyCode === Keys.Backspace ? this._delete_selected(r) : e.keyCode == Keys.Esc && r.data_source.selection_manager.clear();
  }
  _set_extent([e, r], [o, s], l, c = !1) {
    const u = this.model.renderers[0], d = this.plot_view.renderer_view(u);
    if (d == null)
      return;
    const f = u.glyph, T = u.data_source, [Q, m] = d.coordinates.x_scale.r_invert(e, r), [g, v] = d.coordinates.y_scale.r_invert(o, s), [b, L] = [(Q + m) / 2, (g + v) / 2], [A, M] = [m - Q, v - g], [S, E] = [f.x.field, f.y.field], [k, w] = [f.width.field, f.height.field];
    if (l)
      this._pop_glyphs(T, this.model.num_objects), S && T.get_array(S).push(b), E && T.get_array(E).push(L), k && T.get_array(k).push(A), w && T.get_array(w).push(M), this._pad_empty_columns(T, [S, E, k, w]);
    else {
      const O = T.data[S].length - 1;
      S && (T.data[S][O] = b), E && (T.data[E][O] = L), k && (T.data[k][O] = A), w && (T.data[w][O] = M);
    }
    this._emit_cds_changes(T, !0, !1, c);
  }
  _update_box(e, r = !1, o = !1) {
    if (this._draw_basepoint == null)
      return;
    const s = [e.sx, e.sy], l = this.plot_view.frame, c = this.model.dimensions, u = this.model._get_dim_limits(this._draw_basepoint, s, l, c);
    if (u != null) {
      const [d, f] = u;
      this._set_extent(d, f, r, o);
    }
  }
  _doubletap(e) {
    !this.model.active || (this._draw_basepoint != null ? (this._update_box(e, !1, !0), this._draw_basepoint = null) : (this._draw_basepoint = [e.sx, e.sy], this._select_event(e, "append", this.model.renderers), this._update_box(e, !0, !1)));
  }
  _move(e) {
    this._update_box(e, !1, !1);
  }
  _pan_start(e) {
    if (e.shiftKey) {
      if (this._draw_basepoint != null)
        return;
      this._draw_basepoint = [e.sx, e.sy], this._update_box(e, !0, !1);
    } else {
      if (this._basepoint != null)
        return;
      this._select_event(e, "append", this.model.renderers), this._basepoint = [e.sx, e.sy];
    }
  }
  _pan(e, r = !1, o = !1) {
    if (e.shiftKey) {
      if (this._draw_basepoint == null)
        return;
      this._update_box(e, r, o);
    } else {
      if (this._basepoint == null)
        return;
      this._drag_points(e, this.model.renderers);
    }
  }
  _pan_end(e) {
    if (this._pan(e, !1, !0), e.shiftKey)
      this._draw_basepoint = null;
    else {
      this._basepoint = null;
      for (const r of this.model.renderers)
        this._emit_cds_changes(r.data_source, !1, !0, !0);
    }
  }
}
BoxEditToolView.__name__ = "BoxEditToolView";
class BoxEditTool extends EditTool {
  constructor(e) {
    super(e), this.tool_name = "Box Edit Tool", this.icon = tool_icon_box_edit, this.event_type = ["tap", "pan", "move"], this.default_order = 1;
  }
}
_a$1d = BoxEditTool;
BoxEditTool.__name__ = "BoxEditTool";
_a$1d.prototype.default_view = BoxEditToolView, _a$1d.define(({ Int: t }) => ({
  dimensions: [Dimensions, "both"],
  num_objects: [t, 0]
}));
var _a$1c;
class FreehandDrawToolView extends EditToolView {
  _draw(e, r, o = !1) {
    if (!this.model.active)
      return;
    const s = this.model.renderers[0], l = this._map_drag(e.sx, e.sy, s);
    if (l == null)
      return;
    const [c, u] = l, d = s.data_source, f = s.glyph, [T, Q] = [f.xs.field, f.ys.field];
    if (r == "new")
      this._pop_glyphs(d, this.model.num_objects), T && d.get_array(T).push([c]), Q && d.get_array(Q).push([u]), this._pad_empty_columns(d, [T, Q]);
    else if (r == "add") {
      if (T) {
        const m = d.data[T].length - 1;
        let g = d.get_array(T)[m];
        isArray(g) || (g = Array.from(g), d.data[T][m] = g), g.push(c);
      }
      if (Q) {
        const m = d.data[Q].length - 1;
        let g = d.get_array(Q)[m];
        isArray(g) || (g = Array.from(g), d.data[Q][m] = g), g.push(u);
      }
    }
    this._emit_cds_changes(d, !0, !0, o);
  }
  _pan_start(e) {
    this._draw(e, "new");
  }
  _pan(e) {
    this._draw(e, "add");
  }
  _pan_end(e) {
    this._draw(e, "add", !0);
  }
  _tap(e) {
    this._select_event(e, this._select_mode(e), this.model.renderers);
  }
  _keyup(e) {
    if (!(!this.model.active || !this._mouse_in_frame))
      for (const r of this.model.renderers)
        e.keyCode === Keys.Esc ? r.data_source.selection_manager.clear() : e.keyCode === Keys.Backspace && this._delete_selected(r);
  }
}
FreehandDrawToolView.__name__ = "FreehandDrawToolView";
class FreehandDrawTool extends EditTool {
  constructor(e) {
    super(e), this.tool_name = "Freehand Draw Tool", this.icon = tool_icon_freehand_draw, this.event_type = ["pan", "tap"], this.default_order = 3;
  }
}
_a$1c = FreehandDrawTool;
FreehandDrawTool.__name__ = "FreehandDrawTool";
_a$1c.prototype.default_view = FreehandDrawToolView, _a$1c.define(({ Int: t }) => ({
  num_objects: [t, 0]
})), _a$1c.register_alias("freehand_draw", () => new FreehandDrawTool());
var _a$1b;
class PointDrawToolView extends EditToolView {
  _tap(e) {
    if (this._select_event(e, this._select_mode(e), this.model.renderers).length || !this.model.add)
      return;
    const o = this.model.renderers[0], s = this._map_drag(e.sx, e.sy, o);
    if (s == null)
      return;
    const l = o.glyph, c = o.data_source, [u, d] = [l.x.field, l.y.field], [f, T] = s;
    this._pop_glyphs(c, this.model.num_objects), u && c.get_array(u).push(f), d && c.get_array(d).push(T), this._pad_empty_columns(c, [u, d]), c.change.emit(), c.data = c.data, c.properties.data.change.emit();
  }
  _keyup(e) {
    if (!(!this.model.active || !this._mouse_in_frame))
      for (const r of this.model.renderers)
        e.keyCode === Keys.Backspace ? this._delete_selected(r) : e.keyCode == Keys.Esc && r.data_source.selection_manager.clear();
  }
  _pan_start(e) {
    !this.model.drag || (this._select_event(e, "append", this.model.renderers), this._basepoint = [e.sx, e.sy]);
  }
  _pan(e) {
    !this.model.drag || this._basepoint == null || this._drag_points(e, this.model.renderers);
  }
  _pan_end(e) {
    if (!!this.model.drag) {
      this._pan(e);
      for (const r of this.model.renderers)
        this._emit_cds_changes(r.data_source, !1, !0, !0);
      this._basepoint = null;
    }
  }
}
PointDrawToolView.__name__ = "PointDrawToolView";
class PointDrawTool extends EditTool {
  constructor(e) {
    super(e), this.tool_name = "Point Draw Tool", this.icon = tool_icon_point_draw, this.event_type = ["tap", "pan", "move"], this.default_order = 2;
  }
}
_a$1b = PointDrawTool;
PointDrawTool.__name__ = "PointDrawTool";
_a$1b.prototype.default_view = PointDrawToolView, _a$1b.define(({ Boolean: t, Int: e }) => ({
  add: [t, !0],
  drag: [t, !0],
  num_objects: [e, 0]
}));
var _a$1a;
class PolyToolView extends EditToolView {
  _set_vertices(e, r) {
    const o = this.model.vertex_renderer.glyph, s = this.model.vertex_renderer.data_source, [l, c] = [o.x.field, o.y.field];
    l && (isArray(e) ? s.data[l] = e : o.x = { value: e }), c && (isArray(r) ? s.data[c] = r : o.y = { value: r }), this._emit_cds_changes(s, !0, !0, !1);
  }
  _hide_vertices() {
    this._set_vertices([], []);
  }
  _snap_to_vertex(e, r, o) {
    if (this.model.vertex_renderer) {
      const s = this._select_event(e, "replace", [this.model.vertex_renderer]), l = this.model.vertex_renderer.data_source, c = this.model.vertex_renderer.glyph, [u, d] = [c.x.field, c.y.field];
      if (s.length) {
        const f = l.selected.indices[0];
        u && (r = l.data[u][f]), d && (o = l.data[d][f]), l.selection_manager.clear();
      }
    }
    return [r, o];
  }
}
PolyToolView.__name__ = "PolyToolView";
class PolyTool extends EditTool {
  constructor(e) {
    super(e);
  }
}
_a$1a = PolyTool;
PolyTool.__name__ = "PolyTool";
_a$1a.define(({ AnyRef: t }) => ({
  vertex_renderer: [t()]
}));
var _a$19;
class PolyDrawToolView extends PolyToolView {
  constructor() {
    super(...arguments), this._drawing = !1, this._initialized = !1;
  }
  _tap(e) {
    this._drawing ? this._draw(e, "add", !0) : this._select_event(e, this._select_mode(e), this.model.renderers);
  }
  _draw(e, r, o = !1) {
    const s = this.model.renderers[0], l = this._map_drag(e.sx, e.sy, s);
    if (this._initialized || this.activate(), l == null)
      return;
    const [c, u] = this._snap_to_vertex(e, ...l), d = s.data_source, f = s.glyph, [T, Q] = [f.xs.field, f.ys.field];
    if (r == "new")
      this._pop_glyphs(d, this.model.num_objects), T && d.get_array(T).push([c, c]), Q && d.get_array(Q).push([u, u]), this._pad_empty_columns(d, [T, Q]);
    else if (r == "edit") {
      if (T) {
        const m = d.data[T][d.data[T].length - 1];
        m[m.length - 1] = c;
      }
      if (Q) {
        const m = d.data[Q][d.data[Q].length - 1];
        m[m.length - 1] = u;
      }
    } else if (r == "add") {
      if (T) {
        const m = d.data[T].length - 1;
        let g = d.get_array(T)[m];
        const v = g[g.length - 1];
        g[g.length - 1] = c, isArray(g) || (g = Array.from(g), d.data[T][m] = g), g.push(v);
      }
      if (Q) {
        const m = d.data[Q].length - 1;
        let g = d.get_array(Q)[m];
        const v = g[g.length - 1];
        g[g.length - 1] = u, isArray(g) || (g = Array.from(g), d.data[Q][m] = g), g.push(v);
      }
    }
    this._emit_cds_changes(d, !0, !1, o);
  }
  _show_vertices() {
    if (!this.model.active)
      return;
    const e = [], r = [];
    for (let o = 0; o < this.model.renderers.length; o++) {
      const s = this.model.renderers[o], l = s.data_source, c = s.glyph, [u, d] = [c.xs.field, c.ys.field];
      if (u)
        for (const f of l.get_array(u))
          e.push(...f);
      if (d)
        for (const f of l.get_array(d))
          r.push(...f);
      this._drawing && o == this.model.renderers.length - 1 && (e.splice(e.length - 1, 1), r.splice(r.length - 1, 1));
    }
    this._set_vertices(e, r);
  }
  _doubletap(e) {
    !this.model.active || (this._drawing ? (this._drawing = !1, this._draw(e, "edit", !0)) : (this._drawing = !0, this._draw(e, "new", !0)));
  }
  _move(e) {
    this._drawing && this._draw(e, "edit");
  }
  _remove() {
    const e = this.model.renderers[0], r = e.data_source, o = e.glyph, [s, l] = [o.xs.field, o.ys.field];
    if (s) {
      const c = r.data[s].length - 1, u = r.get_array(s)[c];
      u.splice(u.length - 1, 1);
    }
    if (l) {
      const c = r.data[l].length - 1, u = r.get_array(l)[c];
      u.splice(u.length - 1, 1);
    }
    this._emit_cds_changes(r);
  }
  _keyup(e) {
    if (!(!this.model.active || !this._mouse_in_frame))
      for (const r of this.model.renderers)
        e.keyCode === Keys.Backspace ? this._delete_selected(r) : e.keyCode == Keys.Esc && (this._drawing && (this._remove(), this._drawing = !1), r.data_source.selection_manager.clear());
  }
  _pan_start(e) {
    !this.model.drag || (this._select_event(e, "append", this.model.renderers), this._basepoint = [e.sx, e.sy]);
  }
  _pan(e) {
    if (this._basepoint == null || !this.model.drag)
      return;
    const [r, o] = this._basepoint;
    for (const s of this.model.renderers) {
      const l = this._map_drag(r, o, s), c = this._map_drag(e.sx, e.sy, s);
      if (c == null || l == null)
        continue;
      const u = s.data_source, d = s.glyph, [f, T] = [d.xs.field, d.ys.field];
      if (!f && !T)
        continue;
      const [Q, m] = c, [g, v] = l, [b, L] = [Q - g, m - v];
      for (const A of u.selected.indices) {
        let M, S, E;
        f && (S = u.data[f][A]), T ? (E = u.data[T][A], M = E.length) : M = S.length;
        for (let k = 0; k < M; k++)
          S && (S[k] += b), E && (E[k] += L);
      }
      u.change.emit();
    }
    this._basepoint = [e.sx, e.sy];
  }
  _pan_end(e) {
    if (!!this.model.drag) {
      this._pan(e);
      for (const r of this.model.renderers)
        this._emit_cds_changes(r.data_source);
      this._basepoint = null;
    }
  }
  activate() {
    if (!(!this.model.vertex_renderer || !this.model.active)) {
      if (this._show_vertices(), !this._initialized)
        for (const e of this.model.renderers) {
          const r = e.data_source;
          r.connect(r.properties.data.change, () => this._show_vertices());
        }
      this._initialized = !0;
    }
  }
  deactivate() {
    this._drawing && (this._remove(), this._drawing = !1), this.model.vertex_renderer && this._hide_vertices();
  }
}
PolyDrawToolView.__name__ = "PolyDrawToolView";
class PolyDrawTool extends PolyTool {
  constructor(e) {
    super(e), this.tool_name = "Polygon Draw Tool", this.icon = tool_icon_poly_draw, this.event_type = ["pan", "tap", "move"], this.default_order = 3;
  }
}
_a$19 = PolyDrawTool;
PolyDrawTool.__name__ = "PolyDrawTool";
_a$19.prototype.default_view = PolyDrawToolView, _a$19.define(({ Boolean: t, Int: e }) => ({
  drag: [t, !0],
  num_objects: [e, 0]
}));
var _a$18;
class PolyEditToolView extends PolyToolView {
  constructor() {
    super(...arguments), this._drawing = !1, this._cur_index = null;
  }
  _doubletap(e) {
    if (!this.model.active)
      return;
    const r = this._map_drag(e.sx, e.sy, this.model.vertex_renderer);
    if (r == null)
      return;
    const [o, s] = r, l = this._select_event(e, "replace", [this.model.vertex_renderer]), c = this.model.vertex_renderer.data_source, u = this.model.vertex_renderer.glyph, [d, f] = [u.x.field, u.y.field];
    if (l.length && this._selected_renderer != null) {
      const T = c.selected.indices[0];
      this._drawing ? (this._drawing = !1, c.selection_manager.clear()) : (c.selected.indices = [T + 1], d && c.get_array(d).splice(T + 1, 0, o), f && c.get_array(f).splice(T + 1, 0, s), this._drawing = !0), c.change.emit(), this._emit_cds_changes(this._selected_renderer.data_source);
    } else
      this._show_vertices(e);
  }
  _show_vertices(e) {
    if (!this.model.active)
      return;
    const r = this.model.renderers[0], o = () => this._update_vertices(r), s = r == null ? void 0 : r.data_source, l = this._select_event(e, "replace", this.model.renderers);
    if (!l.length) {
      this._set_vertices([], []), this._selected_renderer = null, this._drawing = !1, this._cur_index = null, s != null && s.disconnect(s.properties.data.change, o);
      return;
    }
    s != null && s.connect(s.properties.data.change, o), this._cur_index = l[0].data_source.selected.indices[0], this._update_vertices(l[0]);
  }
  _update_vertices(e) {
    const r = e.glyph, o = e.data_source, s = this._cur_index, [l, c] = [r.xs.field, r.ys.field];
    if (this._drawing || s == null && (l || c))
      return;
    let u, d;
    l && s != null ? (u = o.data[l][s], isArray(u) || (o.data[l][s] = u = Array.from(u))) : u = r.xs.value, c && s != null ? (d = o.data[c][s], isArray(d) || (o.data[c][s] = d = Array.from(d))) : d = r.ys.value, this._selected_renderer = e, this._set_vertices(u, d);
  }
  _move(e) {
    if (this._drawing && this._selected_renderer != null) {
      const r = this.model.vertex_renderer, o = r.data_source, s = r.glyph, l = this._map_drag(e.sx, e.sy, r);
      if (l == null)
        return;
      let [c, u] = l;
      const d = o.selected.indices;
      [c, u] = this._snap_to_vertex(e, c, u), o.selected.indices = d;
      const [f, T] = [s.x.field, s.y.field], Q = d[0];
      f && (o.data[f][Q] = c), T && (o.data[T][Q] = u), o.change.emit(), this._selected_renderer.data_source.change.emit();
    }
  }
  _tap(e) {
    const r = this.model.vertex_renderer, o = this._map_drag(e.sx, e.sy, r);
    if (o == null)
      return;
    if (this._drawing && this._selected_renderer) {
      let [l, c] = o;
      const u = r.data_source, d = r.glyph, [f, T] = [d.x.field, d.y.field], Q = u.selected.indices;
      [l, c] = this._snap_to_vertex(e, l, c);
      const m = Q[0];
      if (u.selected.indices = [m + 1], f) {
        const g = u.get_array(f), v = g[m];
        g[m] = l, g.splice(m + 1, 0, v);
      }
      if (T) {
        const g = u.get_array(T), v = g[m];
        g[m] = c, g.splice(m + 1, 0, v);
      }
      u.change.emit(), this._emit_cds_changes(this._selected_renderer.data_source, !0, !1, !0);
      return;
    }
    const s = this._select_mode(e);
    this._select_event(e, s, [r]), this._select_event(e, s, this.model.renderers);
  }
  _remove_vertex() {
    if (!this._drawing || !this._selected_renderer)
      return;
    const e = this.model.vertex_renderer, r = e.data_source, o = e.glyph, s = r.selected.indices[0], [l, c] = [o.x.field, o.y.field];
    l && r.get_array(l).splice(s, 1), c && r.get_array(c).splice(s, 1), r.change.emit(), this._emit_cds_changes(this._selected_renderer.data_source);
  }
  _pan_start(e) {
    this._select_event(e, "append", [this.model.vertex_renderer]), this._basepoint = [e.sx, e.sy];
  }
  _pan(e) {
    this._basepoint != null && (this._drag_points(e, [this.model.vertex_renderer]), this._selected_renderer && this._selected_renderer.data_source.change.emit());
  }
  _pan_end(e) {
    this._basepoint != null && (this._drag_points(e, [this.model.vertex_renderer]), this._emit_cds_changes(this.model.vertex_renderer.data_source, !1, !0, !0), this._selected_renderer && this._emit_cds_changes(this._selected_renderer.data_source), this._basepoint = null);
  }
  _keyup(e) {
    if (!this.model.active || !this._mouse_in_frame)
      return;
    let r;
    this._selected_renderer ? r = [this.model.vertex_renderer] : r = this.model.renderers;
    for (const o of r)
      e.keyCode === Keys.Backspace ? (this._delete_selected(o), this._selected_renderer && this._emit_cds_changes(this._selected_renderer.data_source)) : e.keyCode == Keys.Esc && (this._drawing ? (this._remove_vertex(), this._drawing = !1) : this._selected_renderer && this._hide_vertices(), o.data_source.selection_manager.clear());
  }
  deactivate() {
    if (this._selected_renderer)
      this._drawing && (this._remove_vertex(), this._drawing = !1);
    else
      return;
    this._hide_vertices();
  }
}
PolyEditToolView.__name__ = "PolyEditToolView";
class PolyEditTool extends PolyTool {
  constructor(e) {
    super(e), this.tool_name = "Poly Edit Tool", this.icon = tool_icon_poly_edit, this.event_type = ["tap", "pan", "move"], this.default_order = 4;
  }
}
_a$18 = PolyEditTool;
PolyEditTool.__name__ = "PolyEditTool";
_a$18.prototype.default_view = PolyEditToolView;
var _a$17;
class SelectToolView extends GestureToolView {
  connect_signals() {
    super.connect_signals(), this.model.clear.connect(() => this._clear());
  }
  get computed_renderers() {
    const { renderers: e, names: r } = this.model, o = this.plot_model.data_renderers;
    return compute_renderers(e, o, r);
  }
  _computed_renderers_by_data_source() {
    var r;
    const e = /* @__PURE__ */ new Map();
    for (const o of this.computed_renderers) {
      let s;
      if (o instanceof GlyphRenderer)
        s = o.data_source;
      else if (o instanceof GraphRenderer)
        s = o.node_renderer.data_source;
      else
        continue;
      const l = (r = e.get(s)) != null ? r : [];
      e.set(s, [...l, o]);
    }
    return e;
  }
  _select_mode(e) {
    const { shiftKey: r, ctrlKey: o } = e;
    if (!r && !o)
      return this.model.mode;
    if (r && !o)
      return "append";
    if (!r && o)
      return "intersect";
    if (r && o)
      return "subtract";
    unreachable();
  }
  _keyup(e) {
    e.keyCode == Keys.Esc && this._clear();
  }
  _clear() {
    for (const r of this.computed_renderers)
      r.get_selection_manager().clear();
    const e = this.computed_renderers.map((r) => this.plot_view.renderer_view(r));
    this.plot_view.request_paint(e);
  }
  _select(e, r, o) {
    const s = this._computed_renderers_by_data_source();
    for (const [, l] of s) {
      const c = l[0].get_selection_manager(), u = [];
      for (const d of l) {
        const f = this.plot_view.renderer_view(d);
        f != null && u.push(f);
      }
      c.select(u, e, r, o);
    }
    this.model.callback != null && this._emit_callback(e), this._emit_selection_event(e, r);
  }
  _emit_selection_event(e, r = !0) {
    const { x_scale: o, y_scale: s } = this.plot_view.frame;
    let l;
    switch (e.type) {
      case "point": {
        const { sx: c, sy: u } = e, d = o.invert(c), f = s.invert(u);
        l = { ...e, x: d, y: f };
        break;
      }
      case "span": {
        const { sx: c, sy: u } = e, d = o.invert(c), f = s.invert(u);
        l = { ...e, x: d, y: f };
        break;
      }
      case "rect": {
        const { sx0: c, sx1: u, sy0: d, sy1: f } = e, [T, Q] = o.r_invert(c, u), [m, g] = s.r_invert(d, f);
        l = { ...e, x0: T, y0: m, x1: Q, y1: g };
        break;
      }
      case "poly": {
        const { sx: c, sy: u } = e, d = o.v_invert(c), f = s.v_invert(u);
        l = { ...e, x: d, y: f };
        break;
      }
    }
    this.plot_model.trigger_event(new SelectionGeometry(l, r));
  }
}
SelectToolView.__name__ = "SelectToolView";
class SelectTool extends GestureTool {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this.clear = new Signal0(this, "clear");
  }
  get menu() {
    return [
      {
        icon: "bk-tool-icon-replace-mode",
        tooltip: "Replace the current selection",
        active: () => this.mode == "replace",
        handler: () => {
          this.mode = "replace", this.active = !0;
        }
      },
      {
        icon: "bk-tool-icon-append-mode",
        tooltip: "Append to the current selection (Shift)",
        active: () => this.mode == "append",
        handler: () => {
          this.mode = "append", this.active = !0;
        }
      },
      {
        icon: "bk-tool-icon-intersect-mode",
        tooltip: "Intersect with the current selection (Ctrl)",
        active: () => this.mode == "intersect",
        handler: () => {
          this.mode = "intersect", this.active = !0;
        }
      },
      {
        icon: "bk-tool-icon-subtract-mode",
        tooltip: "Subtract from the current selection (Shift+Ctrl)",
        active: () => this.mode == "subtract",
        handler: () => {
          this.mode = "subtract", this.active = !0;
        }
      },
      null,
      {
        icon: "bk-tool-icon-clear-selection",
        tooltip: "Clear the current selection (Esc)",
        handler: () => {
          this.clear.emit();
        }
      }
    ];
  }
}
_a$17 = SelectTool;
SelectTool.__name__ = "SelectTool";
_a$17.define(({ String: t, Array: e, Ref: r, Or: o, Auto: s }) => ({
  renderers: [o(e(r(DataRenderer)), s), "auto"],
  names: [e(t), []],
  mode: [SelectionMode, "replace"]
}));
var _a$16;
class BoxSelectToolView extends SelectToolView {
  _compute_limits(e) {
    const r = this.plot_view.frame, o = this.model.dimensions;
    let s = this._base_point;
    if (this.model.origin == "center") {
      const [l, c] = s, [u, d] = e;
      s = [l - (u - l), c - (d - c)];
    }
    return this.model._get_dim_limits(s, e, r, o);
  }
  _pan_start(e) {
    const { sx: r, sy: o } = e;
    this._base_point = [r, o];
  }
  _pan(e) {
    const { sx: r, sy: o } = e, s = [r, o], [l, c] = this._compute_limits(s);
    this.model.overlay.update({ left: l[0], right: l[1], top: c[0], bottom: c[1] }), this.model.select_every_mousemove && this._do_select(l, c, !1, this._select_mode(e));
  }
  _pan_end(e) {
    const { sx: r, sy: o } = e, s = [r, o], [l, c] = this._compute_limits(s);
    this._do_select(l, c, !0, this._select_mode(e)), this.model.overlay.update({ left: null, right: null, top: null, bottom: null }), this._base_point = null, this.plot_view.state.push("box_select", { selection: this.plot_view.get_selection() });
  }
  _do_select([e, r], [o, s], l, c = "replace") {
    const u = { type: "rect", sx0: e, sx1: r, sy0: o, sy1: s };
    this._select(u, l, c);
  }
}
BoxSelectToolView.__name__ = "BoxSelectToolView";
const DEFAULT_BOX_OVERLAY$1 = () => new BoxAnnotation({
  level: "overlay",
  top_units: "screen",
  left_units: "screen",
  bottom_units: "screen",
  right_units: "screen",
  fill_color: "lightgrey",
  fill_alpha: 0.5,
  line_color: "black",
  line_alpha: 1,
  line_width: 2,
  line_dash: [4, 4]
});
class BoxSelectTool extends SelectTool {
  constructor(e) {
    super(e), this.tool_name = "Box Select", this.icon = tool_icon_box_select, this.event_type = "pan", this.default_order = 30;
  }
  get tooltip() {
    return this._get_dim_tooltip(this.dimensions);
  }
}
_a$16 = BoxSelectTool;
BoxSelectTool.__name__ = "BoxSelectTool";
_a$16.prototype.default_view = BoxSelectToolView, _a$16.define(({ Boolean: t, Ref: e }) => ({
  dimensions: [Dimensions, "both"],
  select_every_mousemove: [t, !1],
  overlay: [e(BoxAnnotation), DEFAULT_BOX_OVERLAY$1],
  origin: [BoxOrigin, "corner"]
})), _a$16.register_alias("box_select", () => new BoxSelectTool()), _a$16.register_alias("xbox_select", () => new BoxSelectTool({ dimensions: "width" })), _a$16.register_alias("ybox_select", () => new BoxSelectTool({ dimensions: "height" }));
var _a$15;
class BoxZoomToolView extends GestureToolView {
  _match_aspect(e, r, o) {
    const s = o.bbox.aspect, l = o.bbox.h_range.end, c = o.bbox.h_range.start, u = o.bbox.v_range.end, d = o.bbox.v_range.start;
    let f = Math.abs(e[0] - r[0]), T = Math.abs(e[1] - r[1]);
    const Q = T == 0 ? 0 : f / T, [m] = Q >= s ? [1, Q / s] : [s / Q, 1];
    let g, v;
    e[0] <= r[0] ? (g = e[0], v = e[0] + f * m, v > l && (v = l)) : (v = e[0], g = e[0] - f * m, g < c && (g = c)), f = Math.abs(v - g);
    let b, L;
    return e[1] <= r[1] ? (L = e[1], b = e[1] + f / s, b > u && (b = u)) : (b = e[1], L = e[1] - f / s, L < d && (L = d)), T = Math.abs(b - L), e[0] <= r[0] ? v = e[0] + s * T : g = e[0] - s * T, [[g, v], [L, b]];
  }
  _compute_limits(e) {
    const r = this.plot_view.frame, o = this.model.dimensions;
    let s = this._base_point;
    if (this.model.origin == "center") {
      const [u, d] = s, [f, T] = e;
      s = [u - (f - u), d - (T - d)];
    }
    let l, c;
    return this.model.match_aspect && o == "both" ? [l, c] = this._match_aspect(s, e, r) : [l, c] = this.model._get_dim_limits(s, e, r, o), [l, c];
  }
  _pan_start(e) {
    this._base_point = [e.sx, e.sy];
  }
  _pan(e) {
    const r = [e.sx, e.sy], [o, s] = this._compute_limits(r);
    this.model.overlay.update({ left: o[0], right: o[1], top: s[0], bottom: s[1] });
  }
  _pan_end(e) {
    const r = [e.sx, e.sy], [o, s] = this._compute_limits(r);
    this._update(o, s), this.model.overlay.update({ left: null, right: null, top: null, bottom: null }), this._base_point = null, this.plot_view.trigger_ranges_update_event();
  }
  _update([e, r], [o, s]) {
    if (Math.abs(r - e) <= 5 || Math.abs(s - o) <= 5)
      return;
    const { x_scales: l, y_scales: c } = this.plot_view.frame, u = /* @__PURE__ */ new Map();
    for (const [T, Q] of l) {
      const [m, g] = Q.r_invert(e, r);
      u.set(T, { start: m, end: g });
    }
    const d = /* @__PURE__ */ new Map();
    for (const [T, Q] of c) {
      const [m, g] = Q.r_invert(o, s);
      d.set(T, { start: m, end: g });
    }
    const f = { xrs: u, yrs: d };
    this.plot_view.state.push("box_zoom", { range: f }), this.plot_view.update_range(f);
  }
}
BoxZoomToolView.__name__ = "BoxZoomToolView";
const DEFAULT_BOX_OVERLAY = () => new BoxAnnotation({
  level: "overlay",
  top_units: "screen",
  left_units: "screen",
  bottom_units: "screen",
  right_units: "screen",
  fill_color: "lightgrey",
  fill_alpha: 0.5,
  line_color: "black",
  line_alpha: 1,
  line_width: 2,
  line_dash: [4, 4]
});
class BoxZoomTool extends GestureTool {
  constructor(e) {
    super(e), this.tool_name = "Box Zoom", this.icon = tool_icon_box_zoom, this.event_type = "pan", this.default_order = 20;
  }
  get tooltip() {
    return this._get_dim_tooltip(this.dimensions);
  }
}
_a$15 = BoxZoomTool;
BoxZoomTool.__name__ = "BoxZoomTool";
_a$15.prototype.default_view = BoxZoomToolView, _a$15.define(({ Boolean: t, Ref: e }) => ({
  dimensions: [Dimensions, "both"],
  overlay: [e(BoxAnnotation), DEFAULT_BOX_OVERLAY],
  match_aspect: [t, !1],
  origin: [BoxOrigin, "corner"]
})), _a$15.register_alias("box_zoom", () => new BoxZoomTool({ dimensions: "both" })), _a$15.register_alias("xbox_zoom", () => new BoxZoomTool({ dimensions: "width" })), _a$15.register_alias("ybox_zoom", () => new BoxZoomTool({ dimensions: "height" }));
var _a$14;
class PolySelectToolView extends SelectToolView {
  initialize() {
    super.initialize(), this.data = { sx: [], sy: [] };
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.properties.active.change, () => this._active_change());
  }
  _active_change() {
    this.model.active || this._clear_data();
  }
  _keyup(e) {
    e.keyCode == Keys.Enter && this._clear_data();
  }
  _doubletap(e) {
    this._do_select(this.data.sx, this.data.sy, !0, this._select_mode(e)), this.plot_view.state.push("poly_select", { selection: this.plot_view.get_selection() }), this._clear_data();
  }
  _clear_data() {
    this.data = { sx: [], sy: [] }, this.model.overlay.update({ xs: [], ys: [] });
  }
  _tap(e) {
    const { sx: r, sy: o } = e;
    !this.plot_view.frame.bbox.contains(r, o) || (this.data.sx.push(r), this.data.sy.push(o), this.model.overlay.update({ xs: copy(this.data.sx), ys: copy(this.data.sy) }));
  }
  _do_select(e, r, o, s) {
    const l = { type: "poly", sx: e, sy: r };
    this._select(l, o, s);
  }
}
PolySelectToolView.__name__ = "PolySelectToolView";
const DEFAULT_POLY_OVERLAY = () => new PolyAnnotation({
  level: "overlay",
  xs_units: "screen",
  ys_units: "screen",
  fill_color: "lightgrey",
  fill_alpha: 0.5,
  line_color: "black",
  line_alpha: 1,
  line_width: 2,
  line_dash: [4, 4]
});
class PolySelectTool extends SelectTool {
  constructor(e) {
    super(e), this.tool_name = "Poly Select", this.icon = tool_icon_polygon_select, this.event_type = "tap", this.default_order = 11;
  }
}
_a$14 = PolySelectTool;
PolySelectTool.__name__ = "PolySelectTool";
_a$14.prototype.default_view = PolySelectToolView, _a$14.define(({ Ref: t }) => ({
  overlay: [t(PolyAnnotation), DEFAULT_POLY_OVERLAY]
})), _a$14.register_alias("poly_select", () => new PolySelectTool());
var _a$13;
class LassoSelectToolView extends SelectToolView {
  constructor() {
    super(...arguments), this.sxs = [], this.sys = [];
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.model.properties.active.change, () => this._active_change());
  }
  _active_change() {
    this.model.active || this._clear_overlay();
  }
  _keyup(e) {
    e.keyCode == Keys.Enter && this._clear_overlay();
  }
  _pan_start(e) {
    this.sxs = [], this.sys = [];
    const { sx: r, sy: o } = e;
    this._append_overlay(r, o);
  }
  _pan(e) {
    const [r, o] = this.plot_view.frame.bbox.clip(e.sx, e.sy);
    this._append_overlay(r, o), this.model.select_every_mousemove && this._do_select(this.sxs, this.sys, !1, this._select_mode(e));
  }
  _pan_end(e) {
    const { sxs: r, sys: o } = this;
    this._clear_overlay(), this._do_select(r, o, !0, this._select_mode(e)), this.plot_view.state.push("lasso_select", { selection: this.plot_view.get_selection() });
  }
  _append_overlay(e, r) {
    const { sxs: o, sys: s } = this;
    o.push(e), s.push(r), this.model.overlay.update({ xs: o, ys: s });
  }
  _clear_overlay() {
    this.sxs = [], this.sys = [], this.model.overlay.update({ xs: this.sxs, ys: this.sys });
  }
  _do_select(e, r, o, s) {
    const l = { type: "poly", sx: e, sy: r };
    this._select(l, o, s);
  }
}
LassoSelectToolView.__name__ = "LassoSelectToolView";
class LassoSelectTool extends SelectTool {
  constructor(e) {
    super(e), this.tool_name = "Lasso Select", this.icon = tool_icon_lasso_select, this.event_type = "pan", this.default_order = 12;
  }
}
_a$13 = LassoSelectTool;
LassoSelectTool.__name__ = "LassoSelectTool";
_a$13.prototype.default_view = LassoSelectToolView, _a$13.define(({ Boolean: t, Ref: e }) => ({
  select_every_mousemove: [t, !0],
  overlay: [e(PolyAnnotation), DEFAULT_POLY_OVERLAY]
})), _a$13.register_alias("lasso_select", () => new LassoSelectTool());
var _a$12;
class LineToolView extends EditToolView {
  _set_intersection(e, r) {
    const o = this.model.intersection_renderer.glyph, s = this.model.intersection_renderer.data_source, [l, c] = [o.x.field, o.y.field];
    l && (isArray(e) ? s.data[l] = e : o.x = { value: e }), c && (isArray(r) ? s.data[c] = r : o.y = { value: r }), this._emit_cds_changes(s, !0, !0, !1);
  }
  _hide_intersections() {
    this._set_intersection([], []);
  }
}
LineToolView.__name__ = "LineToolView";
class LineTool extends EditTool {
  constructor(e) {
    super(e);
  }
}
_a$12 = LineTool;
LineTool.__name__ = "LineTool";
_a$12.define(({ AnyRef: t }) => ({
  intersection_renderer: [t()]
}));
var _a$11;
class LineEditToolView extends LineToolView {
  constructor() {
    super(...arguments), this._drawing = !1;
  }
  _doubletap(e) {
    if (!this.model.active)
      return;
    const r = this.model.renderers;
    for (const o of r)
      this._select_event(e, "replace", [o]).length == 1 && (this._selected_renderer = o);
    this._show_intersections(), this._update_line_cds();
  }
  _show_intersections() {
    if (!this.model.active || this._selected_renderer == null)
      return;
    if (!this.model.renderers.length) {
      this._set_intersection([], []), this._selected_renderer = null, this._drawing = !1;
      return;
    }
    const r = this._selected_renderer.data_source, o = this._selected_renderer.glyph, [s, l] = [o.x.field, o.y.field], c = r.get_array(s), u = r.get_array(l);
    this._set_intersection(c, u);
  }
  _tap(e) {
    const r = this.model.intersection_renderer;
    if (this._map_drag(e.sx, e.sy, r) == null)
      return;
    if (this._drawing && this._selected_renderer) {
      const l = this._select_mode(e);
      if (this._select_event(e, l, [r]).length == 0)
        return;
    }
    const s = this._select_mode(e);
    this._select_event(e, s, [r]), this._select_event(e, s, this.model.renderers);
  }
  _update_line_cds() {
    if (this._selected_renderer == null)
      return;
    const e = this.model.intersection_renderer.glyph, r = this.model.intersection_renderer.data_source, [o, s] = [e.x.field, e.y.field];
    if (o && s) {
      const l = r.data[o], c = r.data[s];
      this._selected_renderer.data_source.data[o] = l, this._selected_renderer.data_source.data[s] = c;
    }
    this._emit_cds_changes(this._selected_renderer.data_source, !0, !0, !1);
  }
  _pan_start(e) {
    this._select_event(e, "append", [this.model.intersection_renderer]), this._basepoint = [e.sx, e.sy];
  }
  _pan(e) {
    this._basepoint != null && (this._drag_points(e, [this.model.intersection_renderer], this.model.dimensions), this._selected_renderer && this._selected_renderer.data_source.change.emit());
  }
  _pan_end(e) {
    this._basepoint != null && (this._drag_points(e, [this.model.intersection_renderer]), this._emit_cds_changes(this.model.intersection_renderer.data_source, !1, !0, !0), this._selected_renderer && this._emit_cds_changes(this._selected_renderer.data_source), this._basepoint = null);
  }
  activate() {
    this._drawing = !0;
  }
  deactivate() {
    if (this._selected_renderer)
      this._drawing && (this._drawing = !1);
    else
      return;
    this._hide_intersections();
  }
}
LineEditToolView.__name__ = "LineEditToolView";
class LineEditTool extends LineTool {
  constructor(e) {
    super(e), this.tool_name = "Line Edit Tool", this.icon = tool_icon_line_edit, this.event_type = ["tap", "pan", "move"], this.default_order = 4;
  }
  get tooltip() {
    return this._get_dim_tooltip(this.dimensions);
  }
}
_a$11 = LineEditTool;
LineEditTool.__name__ = "LineEditTool";
_a$11.prototype.default_view = LineEditToolView, _a$11.define(() => ({
  dimensions: [Dimensions, "both"]
}));
var _a$10;
function update_ranges(t, e, r) {
  const o = /* @__PURE__ */ new Map();
  for (const [s, l] of t) {
    const [c, u] = l.r_invert(e, r);
    o.set(s, { start: c, end: u });
  }
  return o;
}
class PanToolView extends GestureToolView {
  _pan_start(e) {
    var l;
    this.last_dx = 0, this.last_dy = 0;
    const { sx: r, sy: o } = e, s = this.plot_view.frame.bbox;
    if (!s.contains(r, o)) {
      const c = s.h_range, u = s.v_range;
      (r < c.start || r > c.end) && (this.v_axis_only = !0), (o < u.start || o > u.end) && (this.h_axis_only = !0);
    }
    (l = this.model.document) == null || l.interactive_start(this.plot_model);
  }
  _pan(e) {
    var r;
    this._update(e.deltaX, e.deltaY), (r = this.model.document) == null || r.interactive_start(this.plot_model);
  }
  _pan_end(e) {
    this.h_axis_only = !1, this.v_axis_only = !1, this.pan_info != null && this.plot_view.state.push("pan", { range: this.pan_info }), this.plot_view.trigger_ranges_update_event();
  }
  _update(e, r) {
    const o = this.plot_view.frame, s = e - this.last_dx, l = r - this.last_dy, c = o.bbox.h_range, u = c.start - s, d = c.end - s, f = o.bbox.v_range, T = f.start - l, Q = f.end - l, m = this.model.dimensions;
    let g, v, b;
    (m == "width" || m == "both") && !this.v_axis_only ? (g = u, v = d, b = -s) : (g = c.start, v = c.end, b = 0);
    let L, A, M;
    (m == "height" || m == "both") && !this.h_axis_only ? (L = T, A = Q, M = -l) : (L = f.start, A = f.end, M = 0), this.last_dx = e, this.last_dy = r;
    const { x_scales: S, y_scales: E } = o, k = update_ranges(S, g, v), w = update_ranges(E, L, A);
    this.pan_info = { xrs: k, yrs: w, sdx: b, sdy: M }, this.plot_view.update_range(this.pan_info, { panning: !0 });
  }
}
PanToolView.__name__ = "PanToolView";
class PanTool extends GestureTool {
  constructor(e) {
    super(e), this.tool_name = "Pan", this.event_type = "pan", this.default_order = 10;
  }
  get tooltip() {
    return this._get_dim_tooltip(this.dimensions);
  }
}
_a$10 = PanTool;
PanTool.__name__ = "PanTool";
_a$10.prototype.default_view = PanToolView, _a$10.define(() => ({
  dimensions: [Dimensions, "both", {
    on_update(t, e) {
      switch (t) {
        case "both":
          e.icon = tool_icon_pan;
          break;
        case "width":
          e.icon = tool_icon_xpan;
          break;
        case "height":
          e.icon = tool_icon_ypan;
          break;
      }
    }
  }]
})), _a$10.register_alias("pan", () => new PanTool({ dimensions: "both" })), _a$10.register_alias("xpan", () => new PanTool({ dimensions: "width" })), _a$10.register_alias("ypan", () => new PanTool({ dimensions: "height" }));
var _a$$;
function flip_side(t) {
  switch (t) {
    case 1:
      return 2;
    case 2:
      return 1;
    case 4:
      return 5;
    case 5:
      return 4;
    default:
      return t;
  }
}
function is_near(t, e, r, o) {
  if (e == null)
    return !1;
  const s = r.compute(e);
  return Math.abs(t - s) < o;
}
function is_inside(t, e, r, o, s) {
  let l = !0;
  if (s.left != null && s.right != null) {
    const c = r.invert(t);
    (c < s.left || c > s.right) && (l = !1);
  }
  if (s.bottom != null && s.top != null) {
    const c = o.invert(e);
    (c < s.bottom || c > s.top) && (l = !1);
  }
  return l;
}
function sides_inside(t, e, r) {
  let o = 0;
  return t >= r.start && t <= r.end && (o += 1), e >= r.start && e <= r.end && (o += 1), o;
}
function compute_value(t, e, r, o) {
  const s = e.compute(t), l = e.invert(s + r);
  return l >= o.start && l <= o.end ? l : t;
}
function update_range_end_side(t, e, r) {
  return t > e.start ? (e.end = t, r) : (e.end = e.start, e.start = t, flip_side(r));
}
function update_range_start_side(t, e, r) {
  return t < e.end ? (e.start = t, r) : (e.start = e.end, e.end = t, flip_side(r));
}
function update_range(t, e, r, o) {
  const [s, l] = e.r_compute(t.start, t.end), [c, u] = e.r_invert(s + r, l + r), d = sides_inside(t.start, t.end, o);
  sides_inside(c, u, o) >= d && (t.start = c, t.end = u);
}
class RangeToolView extends GestureToolView {
  initialize() {
    super.initialize(), this.side = 0, this.model.update_overlay_from_ranges();
  }
  connect_signals() {
    super.connect_signals(), this.model.x_range != null && this.connect(this.model.x_range.change, () => this.model.update_overlay_from_ranges()), this.model.y_range != null && this.connect(this.model.y_range.change, () => this.model.update_overlay_from_ranges());
  }
  _pan_start(e) {
    this.last_dx = 0, this.last_dy = 0;
    const r = this.model.x_range, o = this.model.y_range, { frame: s } = this.plot_view, l = s.x_scale, c = s.y_scale, u = this.model.overlay, { left: d, right: f, top: T, bottom: Q } = u, m = this.model.overlay.line_width + EDGE_TOLERANCE;
    r != null && this.model.x_interaction && (is_near(e.sx, d, l, m) ? this.side = 1 : is_near(e.sx, f, l, m) ? this.side = 2 : is_inside(e.sx, e.sy, l, c, u) && (this.side = 3)), o != null && this.model.y_interaction && (this.side == 0 && is_near(e.sy, Q, c, m) && (this.side = 4), this.side == 0 && is_near(e.sy, T, c, m) ? this.side = 5 : is_inside(e.sx, e.sy, l, c, this.model.overlay) && (this.side == 3 ? this.side = 7 : this.side = 6));
  }
  _pan(e) {
    const r = this.plot_view.frame, o = e.deltaX - this.last_dx, s = e.deltaY - this.last_dy, l = this.model.x_range, c = this.model.y_range, u = r.x_scale, d = r.y_scale;
    if (l != null) {
      if (this.side == 3 || this.side == 7)
        update_range(l, u, o, r.x_range);
      else if (this.side == 1) {
        const f = compute_value(l.start, u, o, r.x_range);
        this.side = update_range_start_side(f, l, this.side);
      } else if (this.side == 2) {
        const f = compute_value(l.end, u, o, r.x_range);
        this.side = update_range_end_side(f, l, this.side);
      }
    }
    if (c != null) {
      if (this.side == 6 || this.side == 7)
        update_range(c, d, s, r.y_range);
      else if (this.side == 4) {
        const f = compute_value(c.start, d, s, r.y_range);
        this.side = update_range_start_side(f, c, this.side);
      } else if (this.side == 5) {
        const f = compute_value(c.end, d, s, r.y_range);
        this.side = update_range_end_side(f, c, this.side);
      }
    }
    this.last_dx = e.deltaX, this.last_dy = e.deltaY;
  }
  _pan_end(e) {
    this.side = 0, this.plot_view.trigger_ranges_update_event();
  }
}
RangeToolView.__name__ = "RangeToolView";
const DEFAULT_RANGE_OVERLAY = () => new BoxAnnotation({
  level: "overlay",
  fill_color: "lightgrey",
  fill_alpha: 0.5,
  line_color: "black",
  line_alpha: 1,
  line_width: 0.5,
  line_dash: [2, 2]
});
class RangeTool extends GestureTool {
  constructor(e) {
    super(e), this.tool_name = "Range Tool", this.icon = tool_icon_range, this.event_type = "pan", this.default_order = 1;
  }
  initialize() {
    super.initialize(), this.overlay.in_cursor = "grab", this.overlay.ew_cursor = this.x_range != null && this.x_interaction ? "ew-resize" : null, this.overlay.ns_cursor = this.y_range != null && this.y_interaction ? "ns-resize" : null;
  }
  update_overlay_from_ranges() {
    this.x_range == null && this.y_range == null && (this.overlay.left = null, this.overlay.right = null, this.overlay.bottom = null, this.overlay.top = null, logger.warn("RangeTool not configured with any Ranges.")), this.x_range == null ? (this.overlay.left = null, this.overlay.right = null) : (this.overlay.left = this.x_range.start, this.overlay.right = this.x_range.end), this.y_range == null ? (this.overlay.bottom = null, this.overlay.top = null) : (this.overlay.bottom = this.y_range.start, this.overlay.top = this.y_range.end);
  }
}
_a$$ = RangeTool;
RangeTool.__name__ = "RangeTool";
_a$$.prototype.default_view = RangeToolView, _a$$.define(({ Boolean: t, Ref: e, Nullable: r }) => ({
  x_range: [r(e(Range1d)), null],
  x_interaction: [t, !0],
  y_range: [r(e(Range1d)), null],
  y_interaction: [t, !0],
  overlay: [e(BoxAnnotation), DEFAULT_RANGE_OVERLAY]
}));
var _a$_;
class TapToolView extends SelectToolView {
  _tap(e) {
    this.model.gesture == "tap" && this._handle_tap(e);
  }
  _doubletap(e) {
    this.model.gesture == "doubletap" && this._handle_tap(e);
  }
  _handle_tap(e) {
    const { sx: r, sy: o } = e, s = { type: "point", sx: r, sy: o };
    this._select(s, !0, this._select_mode(e));
  }
  _select(e, r, o) {
    const { callback: s } = this.model;
    if (this.model.behavior == "select") {
      const l = this._computed_renderers_by_data_source();
      for (const [, c] of l) {
        const u = c[0].get_selection_manager(), d = c.map((T) => this.plot_view.renderer_view(T)).filter((T) => T != null);
        if (u.select(d, e, r, o) && s != null) {
          const T = d[0].coordinates.x_scale.invert(e.sx), Q = d[0].coordinates.y_scale.invert(e.sy), m = { geometries: { ...e, x: T, y: Q }, source: u.source };
          s.execute(this.model, m);
        }
      }
      this._emit_selection_event(e), this.plot_view.state.push("tap", { selection: this.plot_view.get_selection() });
    } else
      for (const l of this.computed_renderers) {
        const c = this.plot_view.renderer_view(l);
        if (c == null)
          continue;
        const u = l.get_selection_manager();
        if (u.inspect(c, e) && s != null) {
          const f = c.coordinates.x_scale.invert(e.sx), T = c.coordinates.y_scale.invert(e.sy), Q = { geometries: { ...e, x: f, y: T }, source: u.source };
          s.execute(this.model, Q);
        }
      }
  }
}
TapToolView.__name__ = "TapToolView";
class TapTool extends SelectTool {
  constructor(e) {
    super(e), this.tool_name = "Tap", this.icon = tool_icon_tap_select, this.event_type = "tap", this.default_order = 10;
  }
}
_a$_ = TapTool;
TapTool.__name__ = "TapTool";
_a$_.prototype.default_view = TapToolView, _a$_.define(({ Any: t, Enum: e, Nullable: r }) => ({
  behavior: [TapBehavior, "select"],
  gesture: [e("tap", "doubletap"), "tap"],
  callback: [r(t)]
})), _a$_.register_alias("click", () => new TapTool({ behavior: "inspect" })), _a$_.register_alias("tap", () => new TapTool()), _a$_.register_alias("doubletap", () => new TapTool({ gesture: "doubletap" }));
var _a$Z;
class WheelPanToolView extends GestureToolView {
  _scroll(e) {
    let r = this.model.speed * e.delta;
    r > 0.9 ? r = 0.9 : r < -0.9 && (r = -0.9), this._update_ranges(r);
  }
  _update_ranges(e) {
    var M;
    const { frame: r } = this.plot_view, o = r.bbox.h_range, s = r.bbox.v_range, [l, c] = [o.start, o.end], [u, d] = [s.start, s.end];
    let f, T, Q, m;
    switch (this.model.dimension) {
      case "height": {
        const S = Math.abs(d - u);
        f = l, T = c, Q = u - S * e, m = d - S * e;
        break;
      }
      case "width": {
        const S = Math.abs(c - l);
        f = l - S * e, T = c - S * e, Q = u, m = d;
        break;
      }
    }
    const { x_scales: g, y_scales: v } = r, b = update_ranges(g, f, T), L = update_ranges(v, Q, m), A = { xrs: b, yrs: L, factor: e };
    this.plot_view.state.push("wheel_pan", { range: A }), this.plot_view.update_range(A, { scrolling: !0 }), (M = this.model.document) == null || M.interactive_start(this.plot_model, () => this.plot_view.trigger_ranges_update_event());
  }
}
WheelPanToolView.__name__ = "WheelPanToolView";
class WheelPanTool extends GestureTool {
  constructor(e) {
    super(e), this.tool_name = "Wheel Pan", this.icon = tool_icon_wheel_pan, this.event_type = "scroll", this.default_order = 12;
  }
  get tooltip() {
    return this._get_dim_tooltip(this.dimension);
  }
}
_a$Z = WheelPanTool;
WheelPanTool.__name__ = "WheelPanTool";
_a$Z.prototype.default_view = WheelPanToolView, _a$Z.define(() => ({
  dimension: [Dimension, "width"]
})), _a$Z.internal(({ Number: t }) => ({
  speed: [t, 1 / 1e3]
})), _a$Z.register_alias("xwheel_pan", () => new WheelPanTool({ dimension: "width" })), _a$Z.register_alias("ywheel_pan", () => new WheelPanTool({ dimension: "height" }));
var _a$Y;
class WheelZoomToolView extends GestureToolView {
  _pinch(e) {
    const { sx: r, sy: o, scale: s, ctrlKey: l, shiftKey: c } = e;
    let u;
    s >= 1 ? u = (s - 1) * 20 : u = -20 / s, this._scroll({ type: "wheel", sx: r, sy: o, delta: u, ctrlKey: l, shiftKey: c });
  }
  _scroll(e) {
    var g;
    const { frame: r } = this.plot_view, o = r.bbox.h_range, s = r.bbox.v_range, { sx: l, sy: c } = e, u = this.model.dimensions, d = (u == "width" || u == "both") && o.start < l && l < o.end, f = (u == "height" || u == "both") && s.start < c && c < s.end;
    if ((!d || !f) && !this.model.zoom_on_axis)
      return;
    const T = this.model.speed * e.delta, Q = scale_range(r, T, d, f, { x: l, y: c });
    this.plot_view.state.push("wheel_zoom", { range: Q });
    const { maintain_focus: m } = this.model;
    this.plot_view.update_range(Q, { scrolling: !0, maintain_focus: m }), (g = this.model.document) == null || g.interactive_start(this.plot_model, () => this.plot_view.trigger_ranges_update_event());
  }
}
WheelZoomToolView.__name__ = "WheelZoomToolView";
class WheelZoomTool extends GestureTool {
  constructor(e) {
    super(e), this.tool_name = "Wheel Zoom", this.icon = tool_icon_wheel_zoom, this.event_type = is_mobile ? "pinch" : "scroll", this.default_order = 10;
  }
  get tooltip() {
    return this._get_dim_tooltip(this.dimensions);
  }
}
_a$Y = WheelZoomTool;
WheelZoomTool.__name__ = "WheelZoomTool";
_a$Y.prototype.default_view = WheelZoomToolView, _a$Y.define(({ Boolean: t, Number: e }) => ({
  dimensions: [Dimensions, "both"],
  maintain_focus: [t, !0],
  zoom_on_axis: [t, !0],
  speed: [e, 1 / 600]
})), _a$Y.register_alias("wheel_zoom", () => new WheelZoomTool({ dimensions: "both" })), _a$Y.register_alias("xwheel_zoom", () => new WheelZoomTool({ dimensions: "width" })), _a$Y.register_alias("ywheel_zoom", () => new WheelZoomTool({ dimensions: "height" }));
var _a$X;
class CrosshairToolView extends InspectToolView {
  _move(e) {
    if (!this.model.active)
      return;
    const { sx: r, sy: o } = e;
    this.plot_view.frame.bbox.contains(r, o) ? this._update_spans(r, o) : this._update_spans(null, null);
  }
  _move_exit(e) {
    this._update_spans(null, null);
  }
  _update_spans(e, r) {
    const o = this.model.dimensions;
    (o == "width" || o == "both") && (this.model.spans.width.location = r), (o == "height" || o == "both") && (this.model.spans.height.location = e);
  }
}
CrosshairToolView.__name__ = "CrosshairToolView";
class CrosshairTool extends InspectTool {
  constructor(e) {
    super(e), this.tool_name = "Crosshair", this.icon = tool_icon_crosshair;
  }
  get tooltip() {
    return this._get_dim_tooltip(this.dimensions);
  }
  get synthetic_renderers() {
    return values(this.spans);
  }
}
_a$X = CrosshairTool;
CrosshairTool.__name__ = "CrosshairTool";
(() => {
  _a$X.prototype.default_view = CrosshairToolView, _a$X.define(({ Alpha: e, Number: r, Color: o }) => ({
    dimensions: [Dimensions, "both"],
    line_color: [o, "black"],
    line_width: [r, 1],
    line_alpha: [e, 1]
  }));
  function t(e, r) {
    return new Span$1({
      for_hover: !0,
      dimension: r,
      location_units: "screen",
      level: "overlay",
      line_color: e.line_color,
      line_width: e.line_width,
      line_alpha: e.line_alpha
    });
  }
  _a$X.internal(({ Struct: e, Ref: r }) => ({
    spans: [
      e({ width: r(Span$1), height: r(Span$1) }),
      (o) => ({
        width: t(o, "width"),
        height: t(o, "height")
      })
    ]
  })), _a$X.register_alias("crosshair", () => new CrosshairTool());
})();
var _a$W;
class CustomJSHover extends Model {
  constructor(e) {
    super(e);
  }
  get values() {
    return values(this.args);
  }
  _make_code(e, r, o, s) {
    return new Function(...keys(this.args), e, r, o, use_strict(s));
  }
  format(e, r, o) {
    return this._make_code("value", "format", "special_vars", this.code)(...this.values, e, r, o);
  }
}
_a$W = CustomJSHover;
CustomJSHover.__name__ = "CustomJSHover";
_a$W.define(({ Unknown: t, String: e, Dict: r }) => ({
  args: [r(t), {}],
  code: [e, ""]
}));
var _a$V;
class Styles$2 extends Model {
  constructor(e) {
    super(e);
  }
}
_a$V = Styles$2;
Styles$2.__name__ = "Styles";
Styles$2.__module__ = "bokeh.models.css";
_a$V.define(({ String: t, Nullable: e }) => ({
  align_content: [e(t), null],
  align_items: [e(t), null],
  align_self: [e(t), null],
  alignment_baseline: [e(t), null],
  all: [e(t), null],
  animation: [e(t), null],
  animation_delay: [e(t), null],
  animation_direction: [e(t), null],
  animation_duration: [e(t), null],
  animation_fill_mode: [e(t), null],
  animation_iteration_count: [e(t), null],
  animation_name: [e(t), null],
  animation_play_state: [e(t), null],
  animation_timing_function: [e(t), null],
  backface_visibility: [e(t), null],
  background: [e(t), null],
  background_attachment: [e(t), null],
  background_clip: [e(t), null],
  background_color: [e(t), null],
  background_image: [e(t), null],
  background_origin: [e(t), null],
  background_position: [e(t), null],
  background_position_x: [e(t), null],
  background_position_y: [e(t), null],
  background_repeat: [e(t), null],
  background_size: [e(t), null],
  baseline_shift: [e(t), null],
  block_size: [e(t), null],
  border: [e(t), null],
  border_block_end: [e(t), null],
  border_block_end_color: [e(t), null],
  border_block_end_style: [e(t), null],
  border_block_end_width: [e(t), null],
  border_block_start: [e(t), null],
  border_block_start_color: [e(t), null],
  border_block_start_style: [e(t), null],
  border_block_start_width: [e(t), null],
  border_bottom: [e(t), null],
  border_bottom_color: [e(t), null],
  border_bottom_left_radius: [e(t), null],
  border_bottom_right_radius: [e(t), null],
  border_bottom_style: [e(t), null],
  border_bottom_width: [e(t), null],
  border_collapse: [e(t), null],
  border_color: [e(t), null],
  border_image: [e(t), null],
  border_image_outset: [e(t), null],
  border_image_repeat: [e(t), null],
  border_image_slice: [e(t), null],
  border_image_source: [e(t), null],
  border_image_width: [e(t), null],
  border_inline_end: [e(t), null],
  border_inline_end_color: [e(t), null],
  border_inline_end_style: [e(t), null],
  border_inline_end_width: [e(t), null],
  border_inline_start: [e(t), null],
  border_inline_start_color: [e(t), null],
  border_inline_start_style: [e(t), null],
  border_inline_start_width: [e(t), null],
  border_left: [e(t), null],
  border_left_color: [e(t), null],
  border_left_style: [e(t), null],
  border_left_width: [e(t), null],
  border_radius: [e(t), null],
  border_right: [e(t), null],
  border_right_color: [e(t), null],
  border_right_style: [e(t), null],
  border_right_width: [e(t), null],
  border_spacing: [e(t), null],
  border_style: [e(t), null],
  border_top: [e(t), null],
  border_top_color: [e(t), null],
  border_top_left_radius: [e(t), null],
  border_top_right_radius: [e(t), null],
  border_top_style: [e(t), null],
  border_top_width: [e(t), null],
  border_width: [e(t), null],
  bottom: [e(t), null],
  box_shadow: [e(t), null],
  box_sizing: [e(t), null],
  break_after: [e(t), null],
  break_before: [e(t), null],
  break_inside: [e(t), null],
  caption_side: [e(t), null],
  caret_color: [e(t), null],
  clear: [e(t), null],
  clip: [e(t), null],
  clip_path: [e(t), null],
  clip_rule: [e(t), null],
  color: [e(t), null],
  color_interpolation: [e(t), null],
  color_interpolation_filters: [e(t), null],
  column_count: [e(t), null],
  column_fill: [e(t), null],
  column_gap: [e(t), null],
  column_rule: [e(t), null],
  column_rule_color: [e(t), null],
  column_rule_style: [e(t), null],
  column_rule_width: [e(t), null],
  column_span: [e(t), null],
  column_width: [e(t), null],
  columns: [e(t), null],
  content: [e(t), null],
  counter_increment: [e(t), null],
  counter_reset: [e(t), null],
  css_float: [e(t), null],
  css_text: [e(t), null],
  cursor: [e(t), null],
  direction: [e(t), null],
  display: [e(t), null],
  dominant_baseline: [e(t), null],
  empty_cells: [e(t), null],
  fill: [e(t), null],
  fill_opacity: [e(t), null],
  fill_rule: [e(t), null],
  filter: [e(t), null],
  flex: [e(t), null],
  flex_basis: [e(t), null],
  flex_direction: [e(t), null],
  flex_flow: [e(t), null],
  flex_grow: [e(t), null],
  flex_shrink: [e(t), null],
  flex_wrap: [e(t), null],
  float: [e(t), null],
  flood_color: [e(t), null],
  flood_opacity: [e(t), null],
  font: [e(t), null],
  font_family: [e(t), null],
  font_feature_settings: [e(t), null],
  font_kerning: [e(t), null],
  font_size: [e(t), null],
  font_size_adjust: [e(t), null],
  font_stretch: [e(t), null],
  font_style: [e(t), null],
  font_synthesis: [e(t), null],
  font_variant: [e(t), null],
  font_variant_caps: [e(t), null],
  font_variant_east_asian: [e(t), null],
  font_variant_ligatures: [e(t), null],
  font_variant_numeric: [e(t), null],
  font_variant_position: [e(t), null],
  font_weight: [e(t), null],
  gap: [e(t), null],
  glyph_orientation_vertical: [e(t), null],
  grid: [e(t), null],
  grid_area: [e(t), null],
  grid_auto_columns: [e(t), null],
  grid_auto_flow: [e(t), null],
  grid_auto_rows: [e(t), null],
  grid_column: [e(t), null],
  grid_column_end: [e(t), null],
  grid_column_gap: [e(t), null],
  grid_column_start: [e(t), null],
  grid_gap: [e(t), null],
  grid_row: [e(t), null],
  grid_row_end: [e(t), null],
  grid_row_gap: [e(t), null],
  grid_row_start: [e(t), null],
  grid_template: [e(t), null],
  grid_template_areas: [e(t), null],
  grid_template_columns: [e(t), null],
  grid_template_rows: [e(t), null],
  height: [e(t), null],
  hyphens: [e(t), null],
  image_orientation: [e(t), null],
  image_rendering: [e(t), null],
  inline_size: [e(t), null],
  justify_content: [e(t), null],
  justify_items: [e(t), null],
  justify_self: [e(t), null],
  left: [e(t), null],
  letter_spacing: [e(t), null],
  lighting_color: [e(t), null],
  line_break: [e(t), null],
  line_height: [e(t), null],
  list_style: [e(t), null],
  list_style_image: [e(t), null],
  list_style_position: [e(t), null],
  list_style_type: [e(t), null],
  margin: [e(t), null],
  margin_block_end: [e(t), null],
  margin_block_start: [e(t), null],
  margin_bottom: [e(t), null],
  margin_inline_end: [e(t), null],
  margin_inline_start: [e(t), null],
  margin_left: [e(t), null],
  margin_right: [e(t), null],
  margin_top: [e(t), null],
  marker: [e(t), null],
  marker_end: [e(t), null],
  marker_mid: [e(t), null],
  marker_start: [e(t), null],
  mask: [e(t), null],
  mask_composite: [e(t), null],
  mask_image: [e(t), null],
  mask_position: [e(t), null],
  mask_repeat: [e(t), null],
  mask_size: [e(t), null],
  mask_type: [e(t), null],
  max_block_size: [e(t), null],
  max_height: [e(t), null],
  max_inline_size: [e(t), null],
  max_width: [e(t), null],
  min_block_size: [e(t), null],
  min_height: [e(t), null],
  min_inline_size: [e(t), null],
  min_width: [e(t), null],
  object_fit: [e(t), null],
  object_position: [e(t), null],
  opacity: [e(t), null],
  order: [e(t), null],
  orphans: [e(t), null],
  outline: [e(t), null],
  outline_color: [e(t), null],
  outline_offset: [e(t), null],
  outline_style: [e(t), null],
  outline_width: [e(t), null],
  overflow: [e(t), null],
  overflow_anchor: [e(t), null],
  overflow_wrap: [e(t), null],
  overflow_x: [e(t), null],
  overflow_y: [e(t), null],
  overscroll_behavior: [e(t), null],
  overscroll_behavior_block: [e(t), null],
  overscroll_behavior_inline: [e(t), null],
  overscroll_behavior_x: [e(t), null],
  overscroll_behavior_y: [e(t), null],
  padding: [e(t), null],
  padding_block_end: [e(t), null],
  padding_block_start: [e(t), null],
  padding_bottom: [e(t), null],
  padding_inline_end: [e(t), null],
  padding_inline_start: [e(t), null],
  padding_left: [e(t), null],
  padding_right: [e(t), null],
  padding_top: [e(t), null],
  page_break_after: [e(t), null],
  page_break_before: [e(t), null],
  page_break_inside: [e(t), null],
  paint_order: [e(t), null],
  perspective: [e(t), null],
  perspective_origin: [e(t), null],
  place_content: [e(t), null],
  place_items: [e(t), null],
  place_self: [e(t), null],
  pointer_events: [e(t), null],
  position: [e(t), null],
  quotes: [e(t), null],
  resize: [e(t), null],
  right: [e(t), null],
  rotate: [e(t), null],
  row_gap: [e(t), null],
  ruby_align: [e(t), null],
  ruby_position: [e(t), null],
  scale: [e(t), null],
  scroll_behavior: [e(t), null],
  shape_rendering: [e(t), null],
  stop_color: [e(t), null],
  stop_opacity: [e(t), null],
  stroke: [e(t), null],
  stroke_dasharray: [e(t), null],
  stroke_dashoffset: [e(t), null],
  stroke_linecap: [e(t), null],
  stroke_linejoin: [e(t), null],
  stroke_miterlimit: [e(t), null],
  stroke_opacity: [e(t), null],
  stroke_width: [e(t), null],
  tab_size: [e(t), null],
  table_layout: [e(t), null],
  text_align: [e(t), null],
  text_align_last: [e(t), null],
  text_anchor: [e(t), null],
  text_combine_upright: [e(t), null],
  text_decoration: [e(t), null],
  text_decoration_color: [e(t), null],
  text_decoration_line: [e(t), null],
  text_decoration_style: [e(t), null],
  text_emphasis: [e(t), null],
  text_emphasis_color: [e(t), null],
  text_emphasis_position: [e(t), null],
  text_emphasis_style: [e(t), null],
  text_indent: [e(t), null],
  text_justify: [e(t), null],
  text_orientation: [e(t), null],
  text_overflow: [e(t), null],
  text_rendering: [e(t), null],
  text_shadow: [e(t), null],
  text_transform: [e(t), null],
  text_underline_position: [e(t), null],
  top: [e(t), null],
  touch_action: [e(t), null],
  transform: [e(t), null],
  transform_box: [e(t), null],
  transform_origin: [e(t), null],
  transform_style: [e(t), null],
  transition: [e(t), null],
  transition_delay: [e(t), null],
  transition_duration: [e(t), null],
  transition_property: [e(t), null],
  transition_timing_function: [e(t), null],
  translate: [e(t), null],
  unicode_bidi: [e(t), null],
  user_select: [e(t), null],
  vertical_align: [e(t), null],
  visibility: [e(t), null],
  white_space: [e(t), null],
  widows: [e(t), null],
  width: [e(t), null],
  will_change: [e(t), null],
  word_break: [e(t), null],
  word_spacing: [e(t), null],
  word_wrap: [e(t), null],
  writing_mode: [e(t), null],
  z_index: [e(t), null]
}));
var _a$U, _b$4, _c$2, _d$2, _e$2, _f$2, _g$1, _h$1, _j$1, _k, _l, _m, _o;
class DOMNodeView extends DOMView {
}
DOMNodeView.__name__ = "DOMNodeView";
class DOMNode extends Model {
  constructor(e) {
    super(e);
  }
}
DOMNode.__name__ = "DOMNode";
DOMNode.__module__ = "bokeh.models.dom";
class TextView extends DOMNodeView {
  render() {
    super.render(), this.el.textContent = this.model.content;
  }
  _createElement() {
    return document.createTextNode("");
  }
}
TextView.__name__ = "TextView";
class Text extends DOMNode {
  constructor(e) {
    super(e);
  }
}
_a$U = Text;
Text.__name__ = "Text";
_a$U.prototype.default_view = TextView, _a$U.define(({ String: t }) => ({
  content: [t, ""]
}));
class PlaceholderView extends DOMNodeView {
}
PlaceholderView.__name__ = "PlaceholderView";
PlaceholderView.tag_name = "span";
class Placeholder extends DOMNode {
  constructor(e) {
    super(e);
  }
}
_b$4 = Placeholder;
Placeholder.__name__ = "Placeholder";
_b$4.define(({}) => ({}));
class IndexView extends PlaceholderView {
  update(e, r, o) {
    this.el.textContent = r.toString();
  }
}
IndexView.__name__ = "IndexView";
class Index extends Placeholder {
  constructor(e) {
    super(e);
  }
}
_c$2 = Index;
Index.__name__ = "Index";
_c$2.prototype.default_view = IndexView, _c$2.define(({}) => ({}));
class ValueRefView extends PlaceholderView {
  update(e, r, o) {
    const s = _get_column_value(this.model.field, e, r), l = s == null ? "???" : `${s}`;
    this.el.textContent = l;
  }
}
ValueRefView.__name__ = "ValueRefView";
class ValueRef extends Placeholder {
  constructor(e) {
    super(e);
  }
}
_d$2 = ValueRef;
ValueRef.__name__ = "ValueRef";
_d$2.prototype.default_view = ValueRefView, _d$2.define(({ String: t }) => ({
  field: [t]
}));
class ColorRefView extends ValueRefView {
  render() {
    super.render(), this.value_el = span(), this.swatch_el = span({ class: tooltip_color_block }, " "), this.el.appendChild(this.value_el), this.el.appendChild(this.swatch_el);
  }
  update(e, r, o) {
    const s = _get_column_value(this.model.field, e, r), l = s == null ? "???" : `${s}`;
    this.el.textContent = l;
  }
}
ColorRefView.__name__ = "ColorRefView";
class ColorRef extends ValueRef {
  constructor(e) {
    super(e);
  }
}
_e$2 = ColorRef;
ColorRef.__name__ = "ColorRef";
_e$2.prototype.default_view = ColorRefView, _e$2.define(({ Boolean: t }) => ({
  hex: [t, !0],
  swatch: [t, !0]
}));
class DOMElementView extends DOMNodeView {
  constructor() {
    super(...arguments), this.child_views = /* @__PURE__ */ new Map();
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    const e = this.model.children.filter((r) => r instanceof Model);
    await build_views(this.child_views, e, { parent: this });
  }
  render() {
    super.render();
    const { style: e } = this.model;
    if (e != null)
      if (e instanceof Styles$2)
        for (const r of e) {
          const o = r.get_value();
          if (isString(o)) {
            const s = r.attr.replace(/_/g, "-");
            this.el.style.hasOwnProperty(s) && this.el.style.setProperty(s, o);
          }
        }
      else
        for (const [r, o] of entries(e)) {
          const s = r.replace(/_/g, "-");
          this.el.style.hasOwnProperty(s) && this.el.style.setProperty(s, o);
        }
    for (const r of this.model.children)
      if (isString(r)) {
        const o = document.createTextNode(r);
        this.el.appendChild(o);
      } else
        this.child_views.get(r).renderTo(this.el);
  }
}
DOMElementView.__name__ = "DOMElementView";
class DOMElement extends DOMNode {
  constructor(e) {
    super(e);
  }
}
_f$2 = DOMElement;
DOMElement.__name__ = "DOMElement";
_f$2.define(({ String: t, Array: e, Dict: r, Or: o, Nullable: s, Ref: l }) => ({
  style: [s(o(l(Styles$2), r(t))), null],
  children: [e(o(t, l(DOMNode), l(LayoutDOM))), []]
}));
class ActionView extends View {
}
ActionView.__name__ = "ActionView";
class Action extends Model {
  constructor(e) {
    super(e);
  }
}
_g$1 = Action;
Action.__name__ = "Action";
Action.__module__ = "bokeh.models.dom";
_g$1.define(({}) => ({}));
class TemplateView extends DOMElementView {
  constructor() {
    super(...arguments), this.action_views = /* @__PURE__ */ new Map();
  }
  async lazy_initialize() {
    await super.lazy_initialize(), await build_views(this.action_views, this.model.actions, { parent: this });
  }
  remove() {
    remove_views(this.action_views), super.remove();
  }
  update(e, r, o = {}) {
    function s(l) {
      for (const c of l.child_views.values())
        c instanceof PlaceholderView ? c.update(e, r, o) : c instanceof DOMElementView && s(c);
    }
    s(this);
    for (const l of this.action_views.values())
      l.update(e, r, o);
  }
}
TemplateView.__name__ = "TemplateView";
TemplateView.tag_name = "div";
class Template$1 extends DOMElement {
}
_h$1 = Template$1;
Template$1.__name__ = "Template";
_h$1.prototype.default_view = TemplateView, _h$1.define(({ Array: t, Ref: e }) => ({
  actions: [t(e(Action)), []]
}));
class SpanView extends DOMElementView {
}
SpanView.__name__ = "SpanView";
SpanView.tag_name = "span";
class Span extends DOMElement {
}
_j$1 = Span;
Span.__name__ = "Span";
_j$1.prototype.default_view = SpanView;
class DivView$1 extends DOMElementView {
}
DivView$1.__name__ = "DivView";
DivView$1.tag_name = "div";
class Div$1 extends DOMElement {
}
_k = Div$1;
Div$1.__name__ = "Div";
_k.prototype.default_view = DivView$1;
class TableView extends DOMElementView {
}
TableView.__name__ = "TableView";
TableView.tag_name = "table";
class Table extends DOMElement {
}
_l = Table;
Table.__name__ = "Table";
_l.prototype.default_view = TableView;
class TableRowView extends DOMElementView {
}
TableRowView.__name__ = "TableRowView";
TableRowView.tag_name = "tr";
class TableRow extends DOMElement {
}
_m = TableRow;
TableRow.__name__ = "TableRow";
_m.prototype.default_view = TableRowView;
class ToggleGroupView extends ActionView {
  update(e, r, o) {
    for (const [s, l] of enumerate(this.model.groups))
      s.visible = r == l;
  }
}
ToggleGroupView.__name__ = "ToggleGroupView";
class ToggleGroup extends Action {
  constructor(e) {
    super(e);
  }
}
_o = ToggleGroup;
ToggleGroup.__name__ = "ToggleGroup";
_o.prototype.default_view = ToggleGroupView, _o.define(({ Array: t, Ref: e }) => ({
  groups: [t(e(RendererGroup)), []]
}));
const DOMModels = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Styles: Styles$2,
  DOMNodeView,
  DOMNode,
  TextView,
  Text,
  PlaceholderView,
  Placeholder,
  IndexView,
  Index,
  ValueRefView,
  ValueRef,
  ColorRefView,
  ColorRef,
  DOMElementView,
  DOMElement,
  ActionView,
  Action,
  TemplateView,
  Template: Template$1,
  SpanView,
  Span,
  DivView: DivView$1,
  Div: Div$1,
  TableView,
  Table,
  TableRowView,
  TableRow,
  ToggleGroupView,
  ToggleGroup
}, Symbol.toStringTag, { value: "Module" }));
var _a$T;
function _nearest_line_hit(t, e, r, o, s, l) {
  const c = { x: s[t], y: l[t] }, u = { x: s[t + 1], y: l[t + 1] };
  let d, f;
  if (e.type == "span")
    e.direction == "h" ? (d = Math.abs(c.x - r), f = Math.abs(u.x - r)) : (d = Math.abs(c.y - o), f = Math.abs(u.y - o));
  else {
    const T = { x: r, y: o };
    d = dist_2_pts(c, T), f = dist_2_pts(u, T);
  }
  return d < f ? [[c.x, c.y], t] : [[u.x, u.y], t + 1];
}
function _line_hit(t, e, r) {
  return [[t[r], e[r]], r];
}
class HoverToolView extends InspectToolView {
  initialize() {
    super.initialize(), this._ttmodels = /* @__PURE__ */ new Map(), this._ttviews = /* @__PURE__ */ new Map();
  }
  async lazy_initialize() {
    await super.lazy_initialize(), await this._update_ttmodels();
    const { tooltips: e } = this.model;
    e instanceof Template$1 && (this._template_view = await build_view(e, { parent: this }), this._template_view.render());
  }
  remove() {
    var e;
    (e = this._template_view) == null || e.remove(), remove_views(this._ttviews), super.remove();
  }
  connect_signals() {
    super.connect_signals();
    const e = this.plot_model.properties.renderers, { renderers: r, tooltips: o } = this.model.properties;
    this.on_change(o, () => delete this._template_el), this.on_change([e, r, o], async () => await this._update_ttmodels());
  }
  async _update_ttmodels() {
    const { _ttmodels: e, computed_renderers: r } = this;
    e.clear();
    const { tooltips: o } = this.model;
    if (o != null)
      for (const u of this.computed_renderers) {
        const d = new Tooltip({
          custom: isString(o) || isFunction(o),
          attachment: this.model.attachment,
          show_arrow: this.model.show_arrow
        });
        u instanceof GlyphRenderer ? e.set(u, d) : u instanceof GraphRenderer && (e.set(u.node_renderer, d), e.set(u.edge_renderer, d));
      }
    const s = await build_views(this._ttviews, [...e.values()], { parent: this.plot_view });
    for (const u of s)
      u.render();
    const l = [...function* () {
      for (const u of r)
        u instanceof GlyphRenderer ? yield u : u instanceof GraphRenderer && (yield u.node_renderer, yield u.edge_renderer);
    }()], c = this._slots.get(this._update);
    if (c != null) {
      const u = new Set(l.map((d) => d.data_source));
      Signal.disconnect_receiver(this, c, u);
    }
    for (const u of l)
      this.connect(u.data_source.inspect, this._update);
  }
  get computed_renderers() {
    const { renderers: e, names: r } = this.model, o = this.plot_model.data_renderers;
    return compute_renderers(e, o, r);
  }
  get ttmodels() {
    return this._ttmodels;
  }
  _clear() {
    this._inspect(1 / 0, 1 / 0);
    for (const [, e] of this.ttmodels)
      e.clear();
  }
  _move(e) {
    if (!this.model.active)
      return;
    const { sx: r, sy: o } = e;
    this.plot_view.frame.bbox.contains(r, o) ? this._inspect(r, o) : this._clear();
  }
  _move_exit() {
    this._clear();
  }
  _inspect(e, r) {
    let o;
    this.model.mode == "mouse" ? o = { type: "point", sx: e, sy: r } : o = { type: "span", direction: this.model.mode == "vline" ? "h" : "v", sx: e, sy: r };
    for (const s of this.computed_renderers) {
      const l = s.get_selection_manager(), c = this.plot_view.renderer_view(s);
      c != null && l.inspect(c, o);
    }
    this._emit_callback(o);
  }
  _update([e, { geometry: r }]) {
    var A, M;
    if (!this.model.active || !(r.type == "point" || r.type == "span") || !(e instanceof GlyphRenderer) || this.model.muted_policy == "ignore" && e.muted)
      return;
    const o = this.ttmodels.get(e);
    if (o == null)
      return;
    const s = e.get_selection_manager(), l = s.inspectors.get(e), c = e.view.convert_selection_to_subset(l);
    if (l.is_empty() && l.view == null) {
      o.clear();
      return;
    }
    const u = s.source, d = this.plot_view.renderer_view(e);
    if (d == null)
      return;
    const { sx: f, sy: T } = r, Q = d.coordinates.x_scale, m = d.coordinates.y_scale, g = Q.invert(f), v = m.invert(T), { glyph: b } = d, L = [];
    if (b instanceof PatchView) {
      const [S, E] = [f, T], k = {
        x: g,
        y: v,
        sx: f,
        sy: T,
        rx: S,
        ry: E,
        name: e.name
      };
      L.push([S, E, this._render_tooltips(u, -1, k)]);
    }
    if (b instanceof HAreaView)
      for (const S of c.line_indices) {
        const E = b._x1, k = b._x2, w = b._y, [O, D] = [f, T], R = {
          index: S,
          x: g,
          y: v,
          sx: f,
          sy: T,
          data_x1: E,
          data_x2: k,
          data_y: w,
          rx: O,
          ry: D,
          indices: c.line_indices,
          name: e.name
        };
        L.push([O, D, this._render_tooltips(u, S, R)]);
      }
    if (b instanceof VAreaView)
      for (const S of c.line_indices) {
        const E = b._x, k = b._y1, w = b._y2, [O, D] = [f, T], R = {
          index: S,
          x: g,
          y: v,
          sx: f,
          sy: T,
          data_x: E,
          data_y1: k,
          data_y2: w,
          rx: O,
          ry: D,
          indices: c.line_indices,
          name: e.name
        };
        L.push([O, D, this._render_tooltips(u, S, R)]);
      }
    if (b instanceof LineView)
      for (const S of c.line_indices) {
        let E = b._x[S + 1], k = b._y[S + 1], w = S, O, D;
        switch (this.model.line_policy) {
          case "interp": {
            [E, k] = b.get_interpolation_hit(S, r), O = Q.compute(E), D = m.compute(k);
            break;
          }
          case "prev": {
            [[O, D], w] = _line_hit(b.sx, b.sy, S);
            break;
          }
          case "next": {
            [[O, D], w] = _line_hit(b.sx, b.sy, S + 1);
            break;
          }
          case "nearest": {
            [[O, D], w] = _nearest_line_hit(S, r, f, T, b.sx, b.sy), E = b._x[w], k = b._y[w];
            break;
          }
          default:
            [O, D] = [f, T];
        }
        const R = {
          index: w,
          x: g,
          y: v,
          sx: f,
          sy: T,
          data_x: E,
          data_y: k,
          rx: O,
          ry: D,
          indices: c.line_indices,
          name: e.name
        };
        L.push([O, D, this._render_tooltips(u, w, R)]);
      }
    for (const S of l.image_indices) {
      const E = {
        index: S.index,
        x: g,
        y: v,
        sx: f,
        sy: T,
        name: e.name
      }, k = this._render_tooltips(u, S, E);
      L.push([f, T, k]);
    }
    for (const S of c.indices)
      if (b instanceof MultiLineView && !isEmpty(c.multiline_indices))
        for (const E of c.multiline_indices[S.toString()]) {
          let k = b._xs.get(S)[E], w = b._ys.get(S)[E], O = E, D, R;
          switch (this.model.line_policy) {
            case "interp": {
              [k, w] = b.get_interpolation_hit(S, E, r), D = Q.compute(k), R = m.compute(w);
              break;
            }
            case "prev": {
              [[D, R], O] = _line_hit(b.sxs.get(S), b.sys.get(S), E);
              break;
            }
            case "next": {
              [[D, R], O] = _line_hit(b.sxs.get(S), b.sys.get(S), E + 1);
              break;
            }
            case "nearest": {
              [[D, R], O] = _nearest_line_hit(E, r, f, T, b.sxs.get(S), b.sys.get(S)), k = b._xs.get(S)[O], w = b._ys.get(S)[O];
              break;
            }
            default:
              throw new Error("shouldn't have happened");
          }
          let B;
          e instanceof GlyphRenderer ? B = e.view.convert_indices_from_subset([S])[0] : B = S;
          const F = {
            index: B,
            x: g,
            y: v,
            sx: f,
            sy: T,
            data_x: k,
            data_y: w,
            segment_index: O,
            indices: c.multiline_indices,
            name: e.name
          };
          L.push([D, R, this._render_tooltips(u, B, F)]);
        }
      else {
        const E = (A = b._x) == null ? void 0 : A[S], k = (M = b._y) == null ? void 0 : M[S];
        let w, O;
        if (this.model.point_policy == "snap_to_data") {
          let B = b.get_anchor_point(this.model.anchor, S, [f, T]);
          if (B == null && (B = b.get_anchor_point("center", S, [f, T]), B == null))
            continue;
          w = B.x, O = B.y;
        } else
          [w, O] = [f, T];
        let D;
        e instanceof GlyphRenderer ? D = e.view.convert_indices_from_subset([S])[0] : D = S;
        const R = {
          index: D,
          x: g,
          y: v,
          sx: f,
          sy: T,
          data_x: E,
          data_y: k,
          indices: c.indices,
          name: e.name
        };
        L.push([w, O, this._render_tooltips(u, D, R)]);
      }
    if (L.length == 0)
      o.clear();
    else {
      const { content: S } = o;
      empty$1(o.content);
      for (const [, , w] of L)
        w != null && S.appendChild(w);
      const [E, k] = L[L.length - 1];
      o.setv({ position: [E, k] }, { check_eq: !1 });
    }
  }
  _emit_callback(e) {
    const { callback: r } = this.model;
    if (r != null)
      for (const o of this.computed_renderers) {
        if (!(o instanceof GlyphRenderer))
          continue;
        const s = this.plot_view.renderer_view(o);
        if (s == null)
          continue;
        const { x_scale: l, y_scale: c } = s.coordinates, u = l.invert(e.sx), d = c.invert(e.sy), f = o.data_source.inspected;
        r.execute(this.model, {
          geometry: { x: u, y: d, ...e },
          renderer: o,
          index: f
        });
      }
  }
  _create_template(e) {
    const r = div({ style: { display: "table", borderSpacing: "2px" } });
    for (const [o] of e) {
      const s = div({ style: { display: "table-row" } });
      r.appendChild(s);
      const l = div({ style: { display: "table-cell" }, class: tooltip_row_label }, o.length != 0 ? `${o}: ` : "");
      s.appendChild(l);
      const c = span();
      c.dataset.value = "";
      const u = span({ class: tooltip_color_block }, " ");
      u.dataset.swatch = "", undisplay(u);
      const d = div({ style: { display: "table-cell" }, class: tooltip_row_value }, c, u);
      s.appendChild(d);
    }
    return r;
  }
  _render_template(e, r, o, s, l) {
    const c = e.cloneNode(!0), u = c.querySelectorAll("[data-value]"), d = c.querySelectorAll("[data-swatch]"), f = /\$color(\[.*\])?:(\w*)/, T = /\$swatch:(\w*)/;
    for (const [[, Q], m] of enumerate(r)) {
      const g = Q.match(T), v = Q.match(f);
      if (g != null || v != null) {
        if (g != null) {
          const [, b] = g, L = o.get_column(b);
          if (L == null)
            u[m].textContent = `${b} unknown`;
          else {
            const A = isNumber(s) ? L[s] : null;
            A != null && (d[m].style.backgroundColor = color2css(A), display(d[m]));
          }
        }
        if (v != null) {
          const [, b = "", L] = v, A = o.get_column(L);
          if (A == null) {
            u[m].textContent = `${L} unknown`;
            continue;
          }
          const M = b.indexOf("hex") >= 0, S = b.indexOf("swatch") >= 0, E = isNumber(s) ? A[s] : null;
          if (E == null) {
            u[m].textContent = "(null)";
            continue;
          }
          u[m].textContent = M ? color2hex(E) : color2css(E), S && (d[m].style.backgroundColor = color2css(E), display(d[m]));
        }
      } else {
        const b = replace_placeholders(Q.replace("$~", "$data_"), o, s, this.model.formatters, l);
        if (isString(b))
          u[m].textContent = b;
        else
          for (const L of b)
            u[m].appendChild(L);
      }
    }
    return c;
  }
  _render_tooltips(e, r, o) {
    var l;
    const { tooltips: s } = this.model;
    if (isString(s)) {
      const c = replace_placeholders({ html: s }, e, r, this.model.formatters, o);
      return div(c);
    } else {
      if (isFunction(s))
        return s(e, o);
      if (s instanceof Template$1)
        return this._template_view.update(e, r, o), this._template_view.el;
      if (s != null) {
        const c = (l = this._template_el) != null ? l : this._template_el = this._create_template(s);
        return this._render_template(c, s, e, r, o);
      } else
        return null;
    }
  }
}
HoverToolView.__name__ = "HoverToolView";
class HoverTool extends InspectTool {
  constructor(e) {
    super(e), this.tool_name = "Hover", this.icon = tool_icon_hover;
  }
}
_a$T = HoverTool;
HoverTool.__name__ = "HoverTool";
_a$T.prototype.default_view = HoverToolView, _a$T.define(({ Any: t, Boolean: e, String: r, Array: o, Tuple: s, Dict: l, Or: c, Ref: u, Function: d, Auto: f, Nullable: T }) => ({
  tooltips: [T(c(u(Template$1), r, o(s(r, r)), d())), [
    ["index", "$index"],
    ["data (x, y)", "($x, $y)"],
    ["screen (x, y)", "($sx, $sy)"]
  ]],
  formatters: [l(c(u(CustomJSHover), FormatterType)), {}],
  renderers: [c(o(u(DataRenderer)), f), "auto"],
  names: [o(r), []],
  mode: [HoverMode, "mouse"],
  muted_policy: [MutedPolicy, "show"],
  point_policy: [PointPolicy, "snap_to_data"],
  line_policy: [LinePolicy, "nearest"],
  show_arrow: [e, !0],
  anchor: [Anchor, "center"],
  attachment: [TooltipAttachment, "horizontal"],
  callback: [T(t)]
})), _a$T.register_alias("hover", () => new HoverTool());
var _a$S;
class ToolProxy extends Model {
  constructor(e) {
    super(e);
  }
  get button_view() {
    return this.tools[0].button_view;
  }
  get event_type() {
    return this.tools[0].event_type;
  }
  get tooltip() {
    return this.tools[0].tooltip;
  }
  get tool_name() {
    return this.tools[0].tool_name;
  }
  get icon() {
    return this.tools[0].computed_icon;
  }
  get computed_icon() {
    return this.icon;
  }
  get toggleable() {
    const e = this.tools[0];
    return e instanceof InspectTool && e.toggleable;
  }
  initialize() {
    super.initialize(), this.do = new Signal0(this, "do");
  }
  connect_signals() {
    super.connect_signals(), this.connect(this.do, () => this.doit()), this.connect(this.properties.active.change, () => this.set_active());
    for (const e of this.tools)
      this.connect(e.properties.active.change, () => {
        this.active = e.active;
      });
  }
  doit() {
    for (const e of this.tools)
      e.do.emit();
  }
  set_active() {
    for (const e of this.tools)
      e.active = this.active;
  }
  get menu() {
    const { menu: e } = this.tools[0];
    if (e == null)
      return null;
    const r = [];
    for (const [o, s] of enumerate(e))
      if (o == null)
        r.push(null);
      else {
        const l = () => {
          var c, u, d;
          for (const f of this.tools)
            (d = (u = (c = f.menu) == null ? void 0 : c[s]) == null ? void 0 : u.handler) == null || d.call(u);
        };
        r.push({ ...o, handler: l });
      }
    return r;
  }
}
_a$S = ToolProxy;
ToolProxy.__name__ = "ToolProxy";
_a$S.define(({ Boolean: t, Array: e, Ref: r }) => ({
  tools: [e(r(ButtonTool)), []],
  active: [t, !1],
  disabled: [t, !1]
}));
var _a$R, _b$3;
class ProxyToolbar extends ToolbarBase {
  constructor(e) {
    super(e);
  }
  initialize() {
    super.initialize(), this._merge_tools();
  }
  _merge_tools() {
    this._proxied_tools = [];
    const e = {}, r = {}, o = {}, s = [], l = [];
    for (const u of this.help)
      includes(l, u.redirect) || (s.push(u), l.push(u.redirect));
    this._proxied_tools.push(...s), this.help = s;
    for (const [u, d] of entries(this.gestures)) {
      u in o || (o[u] = {});
      for (const f of d.tools)
        f.type in o[u] || (o[u][f.type] = []), o[u][f.type].push(f);
    }
    for (const u of this.inspectors)
      u.type in e || (e[u.type] = []), e[u.type].push(u);
    for (const u of this.actions)
      u.type in r || (r[u.type] = []), r[u.type].push(u);
    const c = (u, d = !1) => {
      const f = new ToolProxy({ tools: u, active: d });
      return this._proxied_tools.push(f), f;
    };
    for (const u of keys(o)) {
      const d = this.gestures[u];
      d.tools = [];
      for (const f of keys(o[u])) {
        const T = o[u][f];
        if (T.length > 0)
          if (u == "multi")
            for (const Q of T) {
              const m = c([Q]);
              d.tools.push(m), this.connect(m.properties.active.change, () => this._active_change(m));
            }
          else {
            const Q = c(T);
            d.tools.push(Q), this.connect(Q.properties.active.change, () => this._active_change(Q));
          }
      }
    }
    this.actions = [];
    for (const [u, d] of entries(r))
      if (u == "CustomAction")
        for (const f of d)
          this.actions.push(c([f]));
      else
        d.length > 0 && this.actions.push(c(d));
    this.inspectors = [];
    for (const u of values(e))
      u.length > 0 && this.inspectors.push(c(u, !0));
    for (const [u, d] of entries(this.gestures))
      d.tools.length != 0 && (d.tools = sort_by(d.tools, (f) => f.default_order), u == "pinch" || u == "scroll" || u == "multi" || (d.tools[0].active = !0));
  }
}
_a$R = ProxyToolbar;
ProxyToolbar.__name__ = "ProxyToolbar";
_a$R.define(({ Array: t, Ref: e }) => ({
  toolbars: [t(e(Toolbar)), []]
}));
class ToolbarBoxView extends LayoutDOMView {
  initialize() {
    this.model.toolbar.toolbar_location = this.model.toolbar_location, super.initialize();
  }
  get child_models() {
    return [this.model.toolbar];
  }
  _update_layout() {
    this.layout = new ContentBox(this.child_views[0].el);
    const { toolbar: e } = this.model;
    e.horizontal ? this.layout.set_sizing({
      width_policy: "fit",
      min_width: 100,
      height_policy: "fixed"
    }) : this.layout.set_sizing({
      width_policy: "fixed",
      height_policy: "fit",
      min_height: 100
    });
  }
  after_layout() {
    super.after_layout();
    const e = this.child_views[0];
    e.layout.bbox = this.layout.bbox, e.render();
  }
}
ToolbarBoxView.__name__ = "ToolbarBoxView";
class ToolbarBox extends LayoutDOM {
  constructor(e) {
    super(e);
  }
}
_b$3 = ToolbarBox;
ToolbarBox.__name__ = "ToolbarBox";
_b$3.prototype.default_view = ToolbarBoxView, _b$3.define(({ Ref: t }) => ({
  toolbar: [t(ToolbarBase)],
  toolbar_location: [Location, "right"]
}));
const AllModels = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Annotation,
  Arrow,
  ArrowHead,
  OpenHead,
  NormalHead,
  TeeHead,
  VeeHead,
  Band,
  BoxAnnotation,
  ColorBar,
  Label,
  LabelSet,
  Legend,
  LegendItem,
  PolyAnnotation,
  Slope,
  Span: Span$1,
  TextAnnotation,
  Title,
  ToolbarPanel,
  Tooltip,
  Whisker,
  Axis,
  CategoricalAxis,
  ContinuousAxis,
  DatetimeAxis,
  LinearAxis,
  LogAxis,
  MercatorAxis,
  CustomJS,
  OpenURL,
  Canvas,
  CartesianFrame,
  CoordinateMapping,
  Expression,
  CustomJSExpr,
  Stack: Stack$2,
  CumSum,
  ScalarExpression,
  Minimum,
  Maximum,
  XComponent,
  YComponent,
  PolarTransform,
  BooleanFilter,
  CustomJSFilter,
  Filter,
  GroupFilter,
  IndexFilter,
  BasicTickFormatter,
  CategoricalTickFormatter,
  DatetimeTickFormatter,
  FuncTickFormatter,
  LogTickFormatter,
  MercatorTickFormatter,
  NumeralTickFormatter,
  PrintfTickFormatter,
  TickFormatter,
  AnnularWedge,
  Annulus,
  Arc,
  Bezier,
  Circle,
  Ellipse,
  EllipseOval,
  Glyph,
  HArea,
  HBar,
  HexTile,
  Image: Image$1,
  ImageRGBA,
  ImageURL,
  Line,
  MultiLine,
  MultiPolygons,
  Oval,
  Patch,
  Patches,
  Quad,
  Quadratic,
  Ray,
  Rect,
  Scatter,
  Segment,
  Spline,
  Step,
  Text: Text$1,
  VArea,
  VBar,
  Wedge,
  GraphHitTestPolicy,
  EdgesOnly,
  NodesOnly,
  NodesAndLinkedEdges,
  EdgesAndLinkedNodes,
  LayoutProvider,
  GraphCoordinates,
  NodeCoordinates,
  EdgeCoordinates,
  StaticLayoutProvider,
  Grid,
  Box,
  Column,
  GridBox,
  HTMLBox,
  LayoutDOM,
  Panel,
  Row,
  Spacer,
  Tabs,
  WidgetBox,
  CategoricalColorMapper,
  CategoricalMarkerMapper,
  CategoricalPatternMapper,
  ContinuousColorMapper,
  ColorMapper,
  LinearColorMapper,
  LogColorMapper,
  ScanningColorMapper,
  EqHistColorMapper,
  MathText,
  Ascii,
  MathML: MathML$1,
  TeX: TeX$1,
  PlainText,
  CustomJSTransform,
  Dodge,
  Interpolator,
  Jitter,
  LinearInterpolator,
  StepInterpolator,
  Transform,
  MapOptions,
  GMapOptions,
  GMapPlot,
  Plot,
  LabelingPolicy,
  AllLabels,
  NoOverlap,
  CustomLabelingPolicy,
  DataRange,
  DataRange1d,
  FactorRange,
  Range: Range$1,
  Range1d,
  GlyphRenderer,
  GraphRenderer,
  GuideRenderer,
  Renderer,
  RendererGroup,
  CategoricalScale,
  ContinuousScale,
  LinearScale,
  LinearInterpolationScale,
  LogScale,
  Scale,
  Selection,
  SelectionPolicy,
  IntersectRenderers,
  UnionRenderers,
  ServerSentDataSource,
  AjaxDataSource,
  ColumnDataSource,
  ColumnarDataSource,
  CDSView,
  DataSource,
  GeoJSONDataSource,
  WebDataSource,
  AdaptiveTicker,
  BasicTicker,
  CategoricalTicker,
  CompositeTicker,
  ContinuousTicker,
  DatetimeTicker,
  DaysTicker,
  FixedTicker,
  LogTicker,
  MercatorTicker,
  MonthsTicker,
  SingleIntervalTicker,
  Ticker,
  YearsTicker,
  BinnedTicker,
  BBoxTileSource,
  MercatorTileSource,
  QUADKEYTileSource,
  TileRenderer,
  TileSource,
  TMSTileSource,
  WMTSTileSource,
  CanvasTexture,
  ImageURLTexture,
  Texture,
  ActionTool,
  CustomAction,
  HelpTool,
  RedoTool,
  ResetTool,
  SaveTool,
  UndoTool,
  ZoomInTool,
  ZoomOutTool,
  ButtonTool,
  EditTool,
  BoxEditTool,
  FreehandDrawTool,
  PointDrawTool,
  PolyDrawTool,
  PolyTool,
  PolyEditTool,
  BoxSelectTool,
  BoxZoomTool,
  GestureTool,
  LassoSelectTool,
  LineEditTool,
  PanTool,
  PolySelectTool,
  RangeTool,
  SelectTool,
  TapTool,
  WheelPanTool,
  WheelZoomTool,
  CrosshairTool,
  CustomJSHover,
  HoverTool,
  InspectTool,
  Tool,
  ToolProxy,
  Toolbar,
  ToolbarBase,
  ProxyToolbar,
  ToolbarBox
}, Symbol.toStringTag, { value: "Module" })), overrides = {}, _all_models = /* @__PURE__ */ new Map(), Models = (t) => {
  const e = Models.get(t);
  if (e != null)
    return e;
  throw new Error(`Model '${t}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`);
};
Models.get = (t) => {
  var e;
  return (e = overrides[t]) != null ? e : _all_models.get(t);
};
Models.register = (t, e) => {
  overrides[t] = e;
};
Models.unregister = (t) => {
  delete overrides[t];
};
function is_HasProps(t) {
  return isObject(t) && t.prototype instanceof HasProps;
}
Models.register_models = (t, e = !1, r) => {
  if (t != null) {
    for (const o of isArray(t) ? t : values(t))
      if (is_HasProps(o)) {
        const s = o.__qualified__;
        e || !_all_models.has(s) ? _all_models.set(s, o) : r != null ? r(s) : console.warn(`Model '${s}' was already registered`);
      }
  }
};
const register_models = Models.register_models;
Models.registered_names = () => [..._all_models.keys()];
class ModelResolver {
  constructor() {
    this._known_models = /* @__PURE__ */ new Map();
  }
  get(e, r) {
    var s;
    const o = (s = Models.get(e)) != null ? s : this._known_models.get(e);
    if (o != null)
      return o;
    if (r !== void 0)
      return r;
    throw new Error(`Model '${e}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`);
  }
  register(e) {
    const r = e.__qualified__;
    this.get(r, null) == null ? this._known_models.set(r, e) : console.warn(`Model '${r}' was already registered with this resolver`);
  }
}
ModelResolver.__name__ = "ModelResolver";
register_models(AllModels);
register_models(DOMModels);
function resolve_defs(t, e) {
  var l, c, u;
  var r;
  function o(d) {
    return d.module != null ? `${d.module}.${d.name}` : d.name;
  }
  function s(d) {
    if (isString(d))
      switch (d) {
        case "Any":
          return Any$1;
        case "Unknown":
          return Unknown;
        case "Boolean":
          return Boolean$2;
        case "Number":
          return Number$2;
        case "Int":
          return Int$1;
        case "String":
          return String$2;
        case "Null":
          return Null;
      }
    else
      switch (d[0]) {
        case "Nullable": {
          const [, f] = d;
          return Nullable(s(f));
        }
        case "Or": {
          const [, ...f] = d;
          return Or(...f.map(s));
        }
        case "Tuple": {
          const [, f, ...T] = d;
          return Tuple(s(f), ...T.map(s));
        }
        case "Array": {
          const [, f] = d;
          return Array$2(s(f));
        }
        case "Struct": {
          const [, ...f] = d, T = f.map(([Q, m]) => [Q, s(m)]);
          return Struct(to_object(T));
        }
        case "Dict": {
          const [, f] = d;
          return Dict(s(f));
        }
        case "Map": {
          const [, f, T] = d;
          return Map$2(s(f), s(T));
        }
        case "Enum": {
          const [, ...f] = d;
          return Enum(...f);
        }
        case "Ref": {
          const [, f] = d, T = e.get(o(f));
          if (T != null)
            return Ref(T);
          throw new Error(`${o(f)} wasn't defined before referencing it`);
        }
        case "AnyRef":
          return AnyRef();
      }
  }
  for (const d of t) {
    const f = (() => {
      if (d.extends == null)
        return Model;
      {
        const Q = e.get(o(d.extends));
        if (Q != null)
          return Q;
        throw new Error(`base model ${o(d.extends)} of ${o(d)} is not defined`);
      }
    })(), T = (r = class extends f {
    }, r.__name__ = d.name, r.__module__ = d.module, r);
    for (const Q of (l = d.properties) != null ? l : []) {
      const m = s((c = Q.kind) != null ? c : "Unknown");
      T.define({ [Q.name]: [m, Q.default] });
    }
    for (const Q of (u = d.overrides) != null ? u : [])
      T.override({ [Q.name]: Q.default });
    e.register(T);
  }
}
class EventManager {
  constructor(e) {
    this.document = e, this.session = null, this.subscribed_models = /* @__PURE__ */ new Set();
  }
  send_event(e) {
    const r = new MessageSentEvent(this.document, "bokeh_event", e.to_json());
    this.document._trigger_on_change(r);
  }
  trigger(e) {
    for (const r of this.subscribed_models)
      e.origin != null && e.origin != r || r._process_event(e);
  }
}
EventManager.__name__ = "EventManager";
const documents = [], DEFAULT_TITLE = "Bokeh Application";
class Document {
  constructor(e) {
    var r;
    documents.push(this), this._init_timestamp = Date.now(), this._resolver = (r = e == null ? void 0 : e.resolver) != null ? r : new ModelResolver(), this._title = DEFAULT_TITLE, this._roots = [], this._all_models = /* @__PURE__ */ new Map(), this._all_models_freeze_count = 0, this._callbacks = /* @__PURE__ */ new Map(), this._message_callbacks = /* @__PURE__ */ new Map(), this.event_manager = new EventManager(this), this.idle = new Signal0(this, "idle"), this._idle_roots = /* @__PURE__ */ new WeakMap(), this._interactive_timestamp = null, this._interactive_plot = null;
  }
  get layoutables() {
    return this._roots.filter((e) => e instanceof LayoutDOM);
  }
  get is_idle() {
    for (const e of this.layoutables)
      if (!this._idle_roots.has(e))
        return !1;
    return !0;
  }
  notify_idle(e) {
    this._idle_roots.set(e, !0), this.is_idle && (logger.info(`document idle at ${Date.now() - this._init_timestamp} ms`), this.event_manager.send_event(new DocumentReady()), this.idle.emit());
  }
  clear() {
    this._push_all_models_freeze();
    try {
      for (; this._roots.length > 0; )
        this.remove_root(this._roots[0]);
    } finally {
      this._pop_all_models_freeze();
    }
  }
  interactive_start(e, r = null) {
    this._interactive_plot == null && (this._interactive_plot = e, this._interactive_plot.trigger_event(new LODStart())), this._interactive_finalize = r, this._interactive_timestamp = Date.now();
  }
  interactive_stop() {
    this._interactive_plot != null && (this._interactive_plot.trigger_event(new LODEnd()), this._interactive_finalize != null && this._interactive_finalize()), this._interactive_plot = null, this._interactive_timestamp = null, this._interactive_finalize = null;
  }
  interactive_duration() {
    return this._interactive_timestamp == null ? -1 : Date.now() - this._interactive_timestamp;
  }
  destructively_move(e) {
    if (e === this)
      throw new Error("Attempted to overwrite a document with itself");
    e.clear();
    const r = copy(this._roots);
    this.clear();
    for (const o of r)
      if (o.document != null)
        throw new Error(`Somehow we didn't detach ${o}`);
    if (this._all_models.size != 0)
      throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);
    for (const o of r)
      e.add_root(o);
    e.set_title(this._title);
  }
  _push_all_models_freeze() {
    this._all_models_freeze_count += 1;
  }
  _pop_all_models_freeze() {
    this._all_models_freeze_count -= 1, this._all_models_freeze_count === 0 && this._recompute_all_models();
  }
  _invalidate_all_models() {
    logger.debug("invalidating document models"), this._all_models_freeze_count === 0 && this._recompute_all_models();
  }
  _recompute_all_models() {
    let e = /* @__PURE__ */ new Set();
    for (const c of this._roots)
      e = union(e, c.references());
    const r = new Set(this._all_models.values()), o = difference(r, e), s = difference(e, r), l = /* @__PURE__ */ new Map();
    for (const c of e)
      l.set(c.id, c);
    for (const c of o)
      c.detach_document();
    for (const c of s)
      c.attach_document(this);
    this._all_models = l;
  }
  roots() {
    return this._roots;
  }
  add_root(e, r) {
    if (logger.debug(`Adding root: ${e}`), !includes(this._roots, e)) {
      this._push_all_models_freeze();
      try {
        this._roots.push(e);
      } finally {
        this._pop_all_models_freeze();
      }
      this._trigger_on_change(new RootAddedEvent(this, e, r));
    }
  }
  remove_root(e, r) {
    const o = this._roots.indexOf(e);
    if (!(o < 0)) {
      this._push_all_models_freeze();
      try {
        this._roots.splice(o, 1);
      } finally {
        this._pop_all_models_freeze();
      }
      this._trigger_on_change(new RootRemovedEvent(this, e, r));
    }
  }
  title() {
    return this._title;
  }
  set_title(e, r) {
    e !== this._title && (this._title = e, this._trigger_on_change(new TitleChangedEvent(this, e, r)));
  }
  get_model_by_id(e) {
    var r;
    return (r = this._all_models.get(e)) != null ? r : null;
  }
  get_model_by_name(e) {
    const r = [];
    for (const o of this._all_models.values())
      o instanceof Model && o.name == e && r.push(o);
    switch (r.length) {
      case 0:
        return null;
      case 1:
        return r[0];
      default:
        throw new Error(`Multiple models are named '${e}'`);
    }
  }
  on_message(e, r) {
    const o = this._message_callbacks.get(e);
    o == null ? this._message_callbacks.set(e, /* @__PURE__ */ new Set([r])) : o.add(r);
  }
  remove_on_message(e, r) {
    var o;
    (o = this._message_callbacks.get(e)) == null || o.delete(r);
  }
  _trigger_on_message(e, r) {
    const o = this._message_callbacks.get(e);
    if (o != null)
      for (const s of o)
        s(r);
  }
  on_change(e, r = !1) {
    this._callbacks.has(e) || this._callbacks.set(e, r);
  }
  remove_on_change(e) {
    this._callbacks.delete(e);
  }
  _trigger_on_change(e) {
    for (const [r, o] of this._callbacks)
      if (!o && e instanceof DocumentEventBatch)
        for (const s of e.events)
          r(s);
      else
        r(e);
  }
  _notify_change(e, r, o, s, l) {
    this._trigger_on_change(new ModelChangedEvent(this, e, r, o, s, l == null ? void 0 : l.setter_id, l == null ? void 0 : l.hint));
  }
  static _instantiate_object(e, r, o, s) {
    const l = { ...o, id: e, __deferred__: !0 }, c = s.get(r);
    return new c(l);
  }
  static _instantiate_references_json(e, r, o) {
    var l;
    const s = /* @__PURE__ */ new Map();
    for (const c of e) {
      const u = c.id, d = c.type, f = (l = c.attributes) != null ? l : {};
      let T = r.get(u);
      T == null && (T = Document._instantiate_object(u, d, f, o), c.subtype != null && T.set_subtype(c.subtype)), s.set(T.id, T);
    }
    return s;
  }
  static _resolve_refs(e, r, o, s) {
    function l(d) {
      var f;
      if (is_ref(d)) {
        const T = (f = r.get(d.id)) != null ? f : o.get(d.id);
        if (T != null)
          return T;
        throw new Error(`reference ${JSON.stringify(d)} isn't known (not in Document?)`);
      } else if (is_NDArray_ref(d)) {
        const { buffer: T, dtype: Q, shape: m } = decode_NDArray(d, s);
        return ndarray(T, { dtype: Q, shape: m });
      } else
        return isArray(d) ? c(d) : isPlainObject(d) ? u(d) : d;
    }
    function c(d) {
      const f = [];
      for (const T of d)
        f.push(l(T));
      return f;
    }
    function u(d) {
      const f = {};
      for (const [T, Q] of entries(d))
        f[T] = l(Q);
      return f;
    }
    return l(e);
  }
  static _initialize_references_json(e, r, o, s) {
    const l = /* @__PURE__ */ new Map();
    for (const { id: f, attributes: T } of e) {
      const Q = !r.has(f), m = Q ? o.get(f) : r.get(f), g = Document._resolve_refs(T, r, o, s);
      m.setv(g, { silent: !0 }), l.set(f, { instance: m, is_new: Q });
    }
    const c = [], u = /* @__PURE__ */ new Set();
    function d(f) {
      if (f instanceof HasProps) {
        if (l.has(f.id) && !u.has(f.id)) {
          u.add(f.id);
          const { instance: T, is_new: Q } = l.get(f.id), { attributes: m } = T;
          for (const g of values(m))
            d(g);
          Q && (T.finalize(), c.push(T));
        }
      } else if (isArray(f))
        for (const T of f)
          d(T);
      else if (isPlainObject(f))
        for (const T of values(f))
          d(T);
    }
    for (const f of l.values())
      d(f.instance);
    for (const f of c)
      f.connect_signals();
  }
  static _event_for_attribute_change(e, r, o, s, l) {
    if (s.get_model_by_id(e.id).property(r).syncable) {
      const u = {
        kind: "ModelChanged",
        model: { id: e.id },
        attr: r,
        new: o
      };
      return HasProps._json_record_references(s, o, l, { recursive: !0 }), u;
    } else
      return null;
  }
  static _events_to_sync_objects(e, r, o, s) {
    const l = Object.keys(e.attributes), c = Object.keys(r.attributes), u = difference$1(l, c), d = difference$1(c, l), f = intersection(l, c), T = [];
    for (const Q of u)
      logger.warn(`Server sent key ${Q} but we don't seem to have it in our JSON`);
    for (const Q of d) {
      const m = r.attributes[Q];
      T.push(Document._event_for_attribute_change(e, Q, m, o, s));
    }
    for (const Q of f) {
      const m = e.attributes[Q], g = r.attributes[Q];
      m == null && g == null || (m == null || g == null || Q != "data" && !is_equal(m, g)) && T.push(Document._event_for_attribute_change(e, Q, g, o, s));
    }
    return T.filter((Q) => Q != null);
  }
  static _compute_patch_since_json(e, r) {
    const o = r.to_json(!1);
    function s(v) {
      const b = /* @__PURE__ */ new Map();
      for (const L of v.roots.references)
        b.set(L.id, L);
      return b;
    }
    const l = s(e), c = /* @__PURE__ */ new Map(), u = [];
    for (const v of e.roots.root_ids)
      c.set(v, l.get(v)), u.push(v);
    const d = s(o), f = /* @__PURE__ */ new Map(), T = [];
    for (const v of o.roots.root_ids)
      f.set(v, d.get(v)), T.push(v);
    if (u.sort(), T.sort(), difference$1(u, T).length > 0 || difference$1(T, u).length > 0)
      throw new Error("Not implemented: computing add/remove of document roots");
    const Q = /* @__PURE__ */ new Set();
    let m = [];
    for (const v of r._all_models.keys())
      if (l.has(v)) {
        const b = Document._events_to_sync_objects(l.get(v), d.get(v), r, Q);
        m = m.concat(b);
      }
    const g = new Serializer({ include_defaults: !1 });
    return g.to_serializable([...Q]), {
      references: [...g.definitions],
      events: m
    };
  }
  to_json_string(e = !0) {
    return JSON.stringify(this.to_json(e));
  }
  to_json(e = !0) {
    const r = new Serializer({ include_defaults: e }), o = r.to_serializable(this._roots);
    return {
      version: version$1,
      title: this._title,
      roots: {
        root_ids: o.map((s) => s.id),
        references: [...r.definitions]
      }
    };
  }
  static from_json_string(e) {
    const r = JSON.parse(e);
    return Document.from_json(r);
  }
  static from_json(e) {
    logger.debug("Creating Document from JSON");
    function r(m) {
      return m.replace(/-(dev|rc)\./, "$1");
    }
    const o = e.version, s = o.indexOf("+") !== -1 || o.indexOf("-") !== -1, l = `Library versions: JS (${version$1}) / Python (${o})`;
    !s && r(version$1) != o ? (logger.warn("JS/Python version mismatch"), logger.warn(l)) : logger.debug(l);
    const c = new ModelResolver();
    e.defs != null && resolve_defs(e.defs, c);
    const u = e.roots, d = u.root_ids, f = u.references, T = Document._instantiate_references_json(f, /* @__PURE__ */ new Map(), c);
    Document._initialize_references_json(f, /* @__PURE__ */ new Map(), T, /* @__PURE__ */ new Map());
    const Q = new Document({ resolver: c });
    Q._push_all_models_freeze();
    for (const m of d) {
      const g = T.get(m);
      g != null && Q.add_root(g);
    }
    return Q._pop_all_models_freeze(), Q.set_title(e.title), Q;
  }
  replace_with_json(e) {
    Document.from_json(e).destructively_move(this);
  }
  create_json_patch_string(e) {
    return JSON.stringify(this.create_json_patch(e));
  }
  create_json_patch(e) {
    for (const s of e)
      if (s.document != this)
        throw new Error("Cannot create a patch using events from a different document");
    const r = new Serializer(), o = r.to_serializable(e);
    for (const s of this._all_models.values())
      r.remove_def(s);
    return {
      events: o,
      references: [...r.definitions]
    };
  }
  apply_json_patch(e, r = /* @__PURE__ */ new Map(), o) {
    const s = e.references, l = e.events, c = Document._instantiate_references_json(s, this._all_models, this._resolver);
    r instanceof Map || (r = new Map(r));
    for (const f of l)
      switch (f.kind) {
        case "RootAdded":
        case "RootRemoved":
        case "ModelChanged": {
          const T = f.model.id, Q = this._all_models.get(T);
          if (Q != null)
            c.set(T, Q);
          else if (!c.has(T))
            throw logger.warn(`Got an event for unknown model ${f.model}"`), new Error("event model wasn't known");
          break;
        }
      }
    const u = new Map(this._all_models), d = /* @__PURE__ */ new Map();
    for (const [f, T] of c)
      u.has(f) || d.set(f, T);
    Document._initialize_references_json(s, u, d, r);
    for (const f of l)
      switch (f.kind) {
        case "MessageSent": {
          const { msg_type: T, msg_data: Q } = f;
          let m;
          if (Q === void 0)
            if (r.size == 1) {
              const [[, g]] = r;
              m = g;
            } else
              throw new Error("expected exactly one buffer");
          else
            m = Document._resolve_refs(Q, u, d, r);
          this._trigger_on_message(T, m);
          break;
        }
        case "ModelChanged": {
          const T = f.model.id, Q = this._all_models.get(T);
          if (Q == null)
            throw new Error(`Cannot apply patch to ${T} which is not in the document`);
          const m = f.attr, g = Document._resolve_refs(f.new, u, d, r);
          Q.setv({ [m]: g }, { setter_id: o });
          break;
        }
        case "ColumnDataChanged": {
          const T = f.column_source.id, Q = this._all_models.get(T);
          if (Q == null)
            throw new Error(`Cannot stream to ${T} which is not in the document`);
          const m = Document._resolve_refs(f.new, /* @__PURE__ */ new Map(), /* @__PURE__ */ new Map(), r);
          if (f.cols != null)
            for (const g in Q.data)
              g in m || (m[g] = Q.data[g]);
          Q.setv({ data: m }, { setter_id: o, check_eq: !1 });
          break;
        }
        case "ColumnsStreamed": {
          const T = f.column_source.id, Q = this._all_models.get(T);
          if (Q == null)
            throw new Error(`Cannot stream to ${T} which is not in the document`);
          if (!(Q instanceof ColumnDataSource))
            throw new Error("Cannot stream to non-ColumnDataSource");
          const m = f.data, g = f.rollover;
          Q.stream(m, g, o);
          break;
        }
        case "ColumnsPatched": {
          const T = f.column_source.id, Q = this._all_models.get(T);
          if (Q == null)
            throw new Error(`Cannot patch ${T} which is not in the document`);
          if (!(Q instanceof ColumnDataSource))
            throw new Error("Cannot patch non-ColumnDataSource");
          const m = f.patches;
          Q.patch(m, o);
          break;
        }
        case "RootAdded": {
          const T = f.model.id, Q = c.get(T);
          this.add_root(Q, o);
          break;
        }
        case "RootRemoved": {
          const T = f.model.id, Q = c.get(T);
          this.remove_root(Q, o);
          break;
        }
        case "TitleChanged": {
          this.set_title(f.title, o);
          break;
        }
        default:
          throw new Error(`Unknown patch event ${JSON.stringify(f)}`);
      }
  }
}
Document.__name__ = "Document";
const BOKEH_ROOT = root$3;
function _get_element(t) {
  let e = document.getElementById(t);
  if (e == null)
    throw new Error(`Error rendering Bokeh model: could not find #${t} HTML tag`);
  if (!document.body.contains(e))
    throw new Error(`Error rendering Bokeh model: element #${t} must be under <body>`);
  if (e.tagName == "SCRIPT") {
    const r = div({ class: BOKEH_ROOT });
    replaceWith(e, r), e = r;
  }
  return e;
}
function _resolve_element(t) {
  const { elementid: e } = t;
  return e != null ? _get_element(e) : document.body;
}
function _resolve_root_elements(t) {
  const e = [];
  if (t.root_ids != null && t.roots != null)
    for (const r of t.root_ids)
      e.push(_get_element(t.roots[r]));
  return e;
}
const index$1 = {};
async function add_document_standalone(t, e, r = [], o = !1) {
  const s = /* @__PURE__ */ new Map();
  async function l(u) {
    let d;
    const T = t.roots().indexOf(u), Q = r[T];
    Q != null ? d = Q : e.classList.contains(BOKEH_ROOT) ? d = e : (d = div({ class: BOKEH_ROOT }), e.appendChild(d));
    const m = await build_view(u, { parent: null });
    return m instanceof DOMView && m.renderTo(d), s.set(u, m), index$1[u.id] = m, m;
  }
  function c(u) {
    const d = s.get(u);
    d != null && (d.remove(), s.delete(u), delete index$1[u.id]);
  }
  for (const u of t.roots())
    await l(u);
  return o && (window.document.title = t.title()), t.on_change((u) => {
    u instanceof RootAddedEvent ? l(u.model) : u instanceof RootRemovedEvent ? c(u.model) : o && u instanceof TitleChangedEvent && (window.document.title = u.title);
  }), [...s.values()];
}
class Message {
  constructor(e, r, o) {
    this.header = e, this.metadata = r, this.content = o, this.buffers = /* @__PURE__ */ new Map();
  }
  static assemble(e, r, o) {
    const s = JSON.parse(e), l = JSON.parse(r), c = JSON.parse(o);
    return new Message(s, l, c);
  }
  assemble_buffer(e, r) {
    const o = this.header.num_buffers != null ? this.header.num_buffers : 0;
    if (o <= this.buffers.size)
      throw new Error(`too many buffers received, expecting ${o}`);
    const { id: s } = JSON.parse(e);
    this.buffers.set(s, r);
  }
  static create(e, r, o = {}) {
    const s = Message.create_header(e);
    return new Message(s, r, o);
  }
  static create_header(e) {
    return {
      msgid: uniqueId(),
      msgtype: e
    };
  }
  complete() {
    return this.header != null && this.metadata != null && this.content != null ? this.header.num_buffers != null ? this.buffers.size == this.header.num_buffers : !0 : !1;
  }
  send(e) {
    if ((this.header.num_buffers != null ? this.header.num_buffers : 0) > 0)
      throw new Error("BokehJS only supports receiving buffers, not sending");
    const o = JSON.stringify(this.header), s = JSON.stringify(this.metadata), l = JSON.stringify(this.content);
    e.send(o), e.send(s), e.send(l);
  }
  msgid() {
    return this.header.msgid;
  }
  msgtype() {
    return this.header.msgtype;
  }
  reqid() {
    return this.header.reqid;
  }
  problem() {
    return "msgid" in this.header ? "msgtype" in this.header ? null : "No msgtype in header" : "No msgid in header";
  }
}
Message.__name__ = "Message";
class Receiver {
  constructor() {
    this.message = null, this._partial = null, this._fragments = [], this._buf_header = null, this._current_consumer = this._HEADER;
  }
  consume(e) {
    this._current_consumer(e);
  }
  _HEADER(e) {
    this._assume_text(e), this.message = null, this._partial = null, this._fragments = [e], this._buf_header = null, this._current_consumer = this._METADATA;
  }
  _METADATA(e) {
    this._assume_text(e), this._fragments.push(e), this._current_consumer = this._CONTENT;
  }
  _CONTENT(e) {
    this._assume_text(e), this._fragments.push(e);
    const [r, o, s] = this._fragments.slice(0, 3);
    this._partial = Message.assemble(r, o, s), this._check_complete();
  }
  _BUFFER_HEADER(e) {
    this._assume_text(e), this._buf_header = e, this._current_consumer = this._BUFFER_PAYLOAD;
  }
  _BUFFER_PAYLOAD(e) {
    this._assume_binary(e), this._partial.assemble_buffer(this._buf_header, e), this._check_complete();
  }
  _assume_text(e) {
    if (!isString(e))
      throw new Error("Expected text fragment but received binary fragment");
  }
  _assume_binary(e) {
    if (!(e instanceof ArrayBuffer))
      throw new Error("Expected binary fragment but received text fragment");
  }
  _check_complete() {
    this._partial.complete() ? (this.message = this._partial, this._current_consumer = this._HEADER) : this._current_consumer = this._BUFFER_HEADER;
  }
}
Receiver.__name__ = "Receiver";
class ClientSession {
  constructor(e, r, o) {
    this._connection = e, this.document = r, this.id = o, this._document_listener = (s) => {
      this._document_changed(s);
    }, this.document.on_change(this._document_listener, !0);
  }
  handle(e) {
    const r = e.msgtype();
    r === "PATCH-DOC" ? this._handle_patch(e) : r === "OK" ? this._handle_ok(e) : r === "ERROR" ? this._handle_error(e) : logger.debug(`Doing nothing with message ${e.msgtype()}`);
  }
  close() {
    this._connection.close();
  }
  _connection_closed() {
    this.document.remove_on_change(this._document_listener);
  }
  async request_server_info() {
    const e = Message.create("SERVER-INFO-REQ", {});
    return (await this._connection.send_with_reply(e)).content;
  }
  async force_roundtrip() {
    await this.request_server_info();
  }
  _document_changed(e) {
    if (e.setter_id === this.id)
      return;
    const r = e instanceof DocumentEventBatch ? e.events : [e], o = this.document.create_json_patch(r), s = Message.create("PATCH-DOC", {}, o);
    this._connection.send(s);
  }
  _handle_patch(e) {
    this.document.apply_json_patch(e.content, e.buffers, this.id);
  }
  _handle_ok(e) {
    logger.trace(`Unhandled OK reply to ${e.reqid()}`);
  }
  _handle_error(e) {
    logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`);
  }
}
ClientSession.__name__ = "ClientSession";
const DEFAULT_SERVER_WEBSOCKET_URL = "ws://localhost:5006/ws", DEFAULT_TOKEN = "eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";
let _connection_count = 0;
function parse_token(t) {
  let e = t.split(".")[0];
  const r = e.length % 4;
  return r != 0 && (e = e + "=".repeat(4 - r)), JSON.parse(atob(e.replace(/_/g, "/").replace(/-/g, "+")));
}
class ClientConnection {
  constructor(e = DEFAULT_SERVER_WEBSOCKET_URL, r = DEFAULT_TOKEN, o = null) {
    this.url = e, this.token = r, this.args_string = o, this._number = _connection_count++, this.socket = null, this.session = null, this.closed_permanently = !1, this._current_handler = null, this._pending_replies = /* @__PURE__ */ new Map(), this._pending_messages = [], this._receiver = new Receiver(), this.id = parse_token(r).session_id.split(".")[0], logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`);
  }
  async connect() {
    if (this.closed_permanently)
      throw new Error("Cannot connect() a closed ClientConnection");
    if (this.socket != null)
      throw new Error("Already connected");
    this._current_handler = null, this._pending_replies.clear(), this._pending_messages = [];
    try {
      let e = `${this.url}`;
      return this.args_string != null && this.args_string.length > 0 && (e += `?${this.args_string}`), this.socket = new WebSocket(e, ["bokeh", this.token]), new Promise((r, o) => {
        this.socket.binaryType = "arraybuffer", this.socket.onopen = () => this._on_open(r, o), this.socket.onmessage = (s) => this._on_message(s), this.socket.onclose = (s) => this._on_close(s, o), this.socket.onerror = () => this._on_error(o);
      });
    } catch (e) {
      throw logger.error(`websocket creation failed to url: ${this.url}`), logger.error(` - ${e}`), e;
    }
  }
  close() {
    this.closed_permanently || (logger.debug(`Permanently closing websocket connection ${this._number}`), this.closed_permanently = !0, this.socket != null && this.socket.close(1e3, `close method called on ClientConnection ${this._number}`), this.session._connection_closed());
  }
  _schedule_reconnect(e) {
    setTimeout(() => {
      this.closed_permanently || logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`);
    }, e);
  }
  send(e) {
    if (this.socket == null)
      throw new Error(`not connected so cannot send ${e}`);
    e.send(this.socket);
  }
  async send_with_reply(e) {
    const r = await new Promise((o, s) => {
      this._pending_replies.set(e.msgid(), { resolve: o, reject: s }), this.send(e);
    });
    if (r.msgtype() === "ERROR")
      throw new Error(`Error reply ${r.content.text}`);
    return r;
  }
  async _pull_doc_json() {
    const e = Message.create("PULL-DOC-REQ", {}), r = await this.send_with_reply(e);
    if (!("doc" in r.content))
      throw new Error("No 'doc' field in PULL-DOC-REPLY");
    return r.content.doc;
  }
  async _repull_session_doc(e, r) {
    var o;
    logger.debug(this.session ? "Repulling session" : "Pulling session for first time");
    try {
      const s = await this._pull_doc_json();
      if (this.session == null)
        if (this.closed_permanently)
          logger.debug("Got new document after connection was already closed"), r(new Error("The connection has been closed"));
        else {
          const l = Document.from_json(s), c = Document._compute_patch_since_json(s, l);
          if (c.events.length > 0) {
            logger.debug(`Sending ${c.events.length} changes from model construction back to server`);
            const u = Message.create("PATCH-DOC", {}, c);
            this.send(u);
          }
          this.session = new ClientSession(this, l, this.id);
          for (const u of this._pending_messages)
            this.session.handle(u);
          this._pending_messages = [], logger.debug("Created a new session from new pulled doc"), e(this.session);
        }
      else
        this.session.document.replace_with_json(s), logger.debug("Updated existing session with new pulled doc");
    } catch (s) {
      (o = console.trace) == null || o.call(console, s), logger.error(`Failed to repull session ${s}`), r(s instanceof Error ? s : `${s}`);
    }
  }
  _on_open(e, r) {
    logger.info(`Websocket connection ${this._number} is now open`), this._current_handler = (o) => {
      this._awaiting_ack_handler(o, e, r);
    };
  }
  _on_message(e) {
    this._current_handler == null && logger.error("Got a message with no current handler set");
    try {
      this._receiver.consume(e.data);
    } catch (o) {
      this._close_bad_protocol(`${o}`);
    }
    const r = this._receiver.message;
    if (r != null) {
      const o = r.problem();
      o != null && this._close_bad_protocol(o), this._current_handler(r);
    }
  }
  _on_close(e, r) {
    logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`), this.socket = null, this._pending_replies.forEach((o) => o.reject("Disconnected")), this._pending_replies.clear(), this.closed_permanently || this._schedule_reconnect(2e3), r(new Error(`Lost websocket connection, ${e.code} (${e.reason})`));
  }
  _on_error(e) {
    logger.debug(`Websocket error on socket ${this._number}`);
    const r = "Could not open websocket";
    logger.error(`Failed to connect to Bokeh server: ${r}`), e(new Error(r));
  }
  _close_bad_protocol(e) {
    logger.error(`Closing connection: ${e}`), this.socket != null && this.socket.close(1002, e);
  }
  _awaiting_ack_handler(e, r, o) {
    e.msgtype() === "ACK" ? (this._current_handler = (s) => this._steady_state_handler(s), this._repull_session_doc(r, o)) : this._close_bad_protocol("First message was not an ACK");
  }
  _steady_state_handler(e) {
    const r = e.reqid(), o = this._pending_replies.get(r);
    o ? (this._pending_replies.delete(r), o.resolve(e)) : this.session ? this.session.handle(e) : e.msgtype() != "PATCH-DOC" && this._pending_messages.push(e);
  }
}
ClientConnection.__name__ = "ClientConnection";
function pull_session(t, e, r) {
  return new ClientConnection(t, e, r).connect();
}
function _get_ws_url(t, e) {
  let r = "ws:";
  window.location.protocol == "https:" && (r = "wss:");
  let o;
  return e != null ? (o = document.createElement("a"), o.href = e) : o = window.location, t != null ? t == "/" && (t = "") : t = o.pathname.replace(/\/+$/, ""), `${r}//${o.host}${t}/ws`;
}
const _sessions = {};
function _get_session(t, e, r) {
  const o = parse_token(e).session_id;
  t in _sessions || (_sessions[t] = {});
  const s = _sessions[t];
  return o in s || (s[o] = pull_session(t, e, r)), s[o];
}
async function add_document_from_session(t, e, r, o = [], s = !1) {
  const l = window.location.search.substr(1);
  let c;
  try {
    c = await _get_session(t, e, l);
  } catch (u) {
    const d = parse_token(e).session_id;
    throw logger.error(`Failed to load Bokeh session ${d}: ${u}`), u;
  }
  return add_document_standalone(c.document, r, o, s);
}
const notebook_css = ".rendered_html .bk-root .bk-tooltip table,.rendered_html .bk-root .bk-tooltip tr,.rendered_html .bk-root .bk-tooltip th,.rendered_html .bk-root .bk-tooltip td{border:none;padding:1px;}";
stylesheet.append(root_css);
stylesheet.append(logo_css);
stylesheet.append(notebook_css);
async function embed_item(t, e) {
  const r = {}, o = uuid4();
  r[o] = t.doc, e == null && (e = t.target_id);
  const s = document.getElementById(e);
  s != null && s.classList.add(BOKEH_ROOT);
  const c = { roots: { [t.root_id]: e }, root_ids: [t.root_id], docid: o };
  await defer();
  const [u] = await _embed_items(r, [c]);
  return u;
}
async function _embed_items(t, e, r, o) {
  isString(t) && (t = JSON.parse(unescape(t)));
  const s = {};
  for (const [c, u] of entries(t))
    s[c] = Document.from_json(u);
  const l = [];
  for (const c of e) {
    const u = _resolve_element(c), d = _resolve_root_elements(c);
    if (c.docid != null)
      l.push(await add_document_standalone(s[c.docid], u, d, c.use_for_title));
    else if (c.token != null) {
      const f = _get_ws_url(r, o);
      logger.debug(`embed: computed ws url: ${f}`);
      try {
        l.push(await add_document_from_session(f, c.token, u, d, c.use_for_title)), console.log("Bokeh items were rendered successfully");
      } catch (T) {
        console.log("Error rendering Bokeh items:", T);
      }
    } else
      throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");
  }
  return l;
}
var regl = { exports: {} };
(function(t, e) {
  (function(r, o) {
    t.exports = o();
  })(commonjsGlobal, function() {
    var r = function(G) {
      return G instanceof Uint8Array || G instanceof Uint16Array || G instanceof Uint32Array || G instanceof Int8Array || G instanceof Int16Array || G instanceof Int32Array || G instanceof Float32Array || G instanceof Float64Array || G instanceof Uint8ClampedArray;
    }, o = function(G, re) {
      for (var Qe = Object.keys(re), qe = 0; qe < Qe.length; ++qe)
        G[Qe[qe]] = re[Qe[qe]];
      return G;
    }, s = `
`;
    function l(G) {
      return typeof atob < "u" ? atob(G) : "base64:" + G;
    }
    function c(G) {
      var re = new Error("(regl) " + G);
      throw console.error(re), re;
    }
    function u(G, re) {
      G || c(re);
    }
    function d(G) {
      return G ? ": " + G : "";
    }
    function f(G, re, Qe) {
      G in re || c("unknown parameter (" + G + ")" + d(Qe) + ". possible values: " + Object.keys(re).join());
    }
    function T(G, re) {
      r(G) || c(
        "invalid parameter type" + d(re) + ". must be a typed array"
      );
    }
    function Q(G, re) {
      switch (re) {
        case "number":
          return typeof G == "number";
        case "object":
          return typeof G == "object";
        case "string":
          return typeof G == "string";
        case "boolean":
          return typeof G == "boolean";
        case "function":
          return typeof G == "function";
        case "undefined":
          return typeof G > "u";
        case "symbol":
          return typeof G == "symbol";
      }
    }
    function m(G, re, Qe) {
      Q(G, re) || c(
        "invalid parameter type" + d(Qe) + ". expected " + re + ", got " + typeof G
      );
    }
    function g(G, re) {
      G >= 0 && (G | 0) === G || c("invalid parameter type, (" + G + ")" + d(re) + ". must be a nonnegative integer");
    }
    function v(G, re, Qe) {
      re.indexOf(G) < 0 && c("invalid value" + d(Qe) + ". must be one of: " + re);
    }
    var b = [
      "gl",
      "canvas",
      "container",
      "attributes",
      "pixelRatio",
      "extensions",
      "optionalExtensions",
      "profile",
      "onDone"
    ];
    function L(G) {
      Object.keys(G).forEach(function(re) {
        b.indexOf(re) < 0 && c('invalid regl constructor argument "' + re + '". must be one of ' + b);
      });
    }
    function A(G, re) {
      for (G = G + ""; G.length < re; )
        G = " " + G;
      return G;
    }
    function M() {
      this.name = "unknown", this.lines = [], this.index = {}, this.hasErrors = !1;
    }
    function S(G, re) {
      this.number = G, this.line = re, this.errors = [];
    }
    function E(G, re, Qe) {
      this.file = G, this.line = re, this.message = Qe;
    }
    function k() {
      var G = new Error(), re = (G.stack || G).toString(), Qe = /compileProcedure.*\n\s*at.*\((.*)\)/.exec(re);
      if (Qe)
        return Qe[1];
      var qe = /compileProcedure.*\n\s*at\s+(.*)(\n|$)/.exec(re);
      return qe ? qe[1] : "unknown";
    }
    function w() {
      var G = new Error(), re = (G.stack || G).toString(), Qe = /at REGLCommand.*\n\s+at.*\((.*)\)/.exec(re);
      if (Qe)
        return Qe[1];
      var qe = /at REGLCommand.*\n\s+at\s+(.*)\n/.exec(re);
      return qe ? qe[1] : "unknown";
    }
    function O(G, re) {
      var Qe = G.split(`
`), qe = 1, st = 0, Ue = {
        unknown: new M(),
        0: new M()
      };
      Ue.unknown.name = Ue[0].name = re || k(), Ue.unknown.lines.push(new S(0, ""));
      for (var Je = 0; Je < Qe.length; ++Je) {
        var xt = Qe[Je], yt = /^\s*#\s*(\w+)\s+(.+)\s*$/.exec(xt);
        if (yt)
          switch (yt[1]) {
            case "line":
              var Ct = /(\d+)(\s+\d+)?/.exec(yt[2]);
              Ct && (qe = Ct[1] | 0, Ct[2] && (st = Ct[2] | 0, st in Ue || (Ue[st] = new M())));
              break;
            case "define":
              var kt = /SHADER_NAME(_B64)?\s+(.*)$/.exec(yt[2]);
              kt && (Ue[st].name = kt[1] ? l(kt[2]) : kt[2]);
              break;
          }
        Ue[st].lines.push(new S(qe++, xt));
      }
      return Object.keys(Ue).forEach(function(St) {
        var It = Ue[St];
        It.lines.forEach(function(At) {
          It.index[At.number] = At;
        });
      }), Ue;
    }
    function D(G) {
      var re = [];
      return G.split(`
`).forEach(function(Qe) {
        if (!(Qe.length < 5)) {
          var qe = /^ERROR:\s+(\d+):(\d+):\s*(.*)$/.exec(Qe);
          qe ? re.push(new E(
            qe[1] | 0,
            qe[2] | 0,
            qe[3].trim()
          )) : Qe.length > 0 && re.push(new E("unknown", 0, Qe));
        }
      }), re;
    }
    function R(G, re) {
      re.forEach(function(Qe) {
        var qe = G[Qe.file];
        if (qe) {
          var st = qe.index[Qe.line];
          if (st) {
            st.errors.push(Qe), qe.hasErrors = !0;
            return;
          }
        }
        G.unknown.hasErrors = !0, G.unknown.lines[0].errors.push(Qe);
      });
    }
    function B(G, re, Qe, qe, st) {
      if (!G.getShaderParameter(re, G.COMPILE_STATUS)) {
        var Ue = G.getShaderInfoLog(re), Je = qe === G.FRAGMENT_SHADER ? "fragment" : "vertex";
        H(Qe, "string", Je + " shader source must be a string", st);
        var xt = O(Qe, st), yt = D(Ue);
        R(xt, yt), Object.keys(xt).forEach(function(Ct) {
          var kt = xt[Ct];
          if (!kt.hasErrors)
            return;
          var St = [""], It = [""];
          function At(Mt, De) {
            St.push(Mt), It.push(De || "");
          }
          At("file number " + Ct + ": " + kt.name + `
`, "color:red;text-decoration:underline;font-weight:bold"), kt.lines.forEach(function(Mt) {
            if (Mt.errors.length > 0) {
              At(A(Mt.number, 4) + "|  ", "background-color:yellow; font-weight:bold"), At(Mt.line + s, "color:red; background-color:yellow; font-weight:bold");
              var De = 0;
              Mt.errors.forEach(function(Xe) {
                var wt = Xe.message, Xt = /^\s*'(.*)'\s*:\s*(.*)$/.exec(wt);
                if (Xt) {
                  var Tt = Xt[1];
                  switch (wt = Xt[2], Tt) {
                    case "assign":
                      Tt = "=";
                      break;
                  }
                  De = Math.max(Mt.line.indexOf(Tt, De), 0);
                } else
                  De = 0;
                At(A("| ", 6)), At(A("^^^", De + 3) + s, "font-weight:bold"), At(A("| ", 6)), At(wt + s, "font-weight:bold");
              }), At(A("| ", 6) + s);
            } else
              At(A(Mt.number, 4) + "|  "), At(Mt.line + s, "color:red");
          }), typeof document < "u" && !window.chrome ? (It[0] = St.join("%c"), console.log.apply(console, It)) : console.log(St.join(""));
        }), u.raise("Error compiling " + Je + " shader, " + xt[0].name);
      }
    }
    function F(G, re, Qe, qe, st) {
      if (!G.getProgramParameter(re, G.LINK_STATUS)) {
        var Ue = G.getProgramInfoLog(re), Je = O(Qe, st), xt = O(qe, st), yt = 'Error linking program with vertex shader, "' + xt[0].name + '", and fragment shader "' + Je[0].name + '"';
        typeof document < "u" ? console.log(
          "%c" + yt + s + "%c" + Ue,
          "color:red;text-decoration:underline;font-weight:bold",
          "color:red"
        ) : console.log(yt + s + Ue), u.raise(yt);
      }
    }
    function j(G) {
      G._commandRef = k();
    }
    function z(G, re, Qe, qe) {
      j(G);
      function st(yt) {
        return yt ? qe.id(yt) : 0;
      }
      G._fragId = st(G.static.frag), G._vertId = st(G.static.vert);
      function Ue(yt, Ct) {
        Object.keys(Ct).forEach(function(kt) {
          yt[qe.id(kt)] = !0;
        });
      }
      var Je = G._uniformSet = {};
      Ue(Je, re.static), Ue(Je, re.dynamic);
      var xt = G._attributeSet = {};
      Ue(xt, Qe.static), Ue(xt, Qe.dynamic), G._hasCount = "count" in G.static || "count" in G.dynamic || "elements" in G.static || "elements" in G.dynamic;
    }
    function q(G, re) {
      var Qe = w();
      c(G + " in command " + (re || k()) + (Qe === "unknown" ? "" : " called from " + Qe));
    }
    function I(G, re, Qe) {
      G || q(re, Qe || k());
    }
    function U(G, re, Qe, qe) {
      G in re || q(
        "unknown parameter (" + G + ")" + d(Qe) + ". possible values: " + Object.keys(re).join(),
        qe || k()
      );
    }
    function H(G, re, Qe, qe) {
      Q(G, re) || q(
        "invalid parameter type" + d(Qe) + ". expected " + re + ", got " + typeof G,
        qe || k()
      );
    }
    function ce(G) {
      G();
    }
    function Ae(G, re, Qe) {
      G.texture ? v(
        G.texture._texture.internalformat,
        re,
        "unsupported texture format for attachment"
      ) : v(
        G.renderbuffer._renderbuffer.format,
        Qe,
        "unsupported renderbuffer format for attachment"
      );
    }
    var ae = 33071, pe = 9728, Ze = 9984, ze = 9985, et = 9986, lt = 9987, bt = 5120, He = 5121, $e = 5122, Ye = 5123, tt = 5124, dt = 5125, Wt = 5126, pt = 32819, Rt = 32820, Yt = 33635, Et = 34042, d1 = 36193, b1 = {};
    b1[bt] = b1[He] = 1, b1[$e] = b1[Ye] = b1[d1] = b1[Yt] = b1[pt] = b1[Rt] = 2, b1[tt] = b1[dt] = b1[Wt] = b1[Et] = 4;
    function Y1(G, re) {
      return G === Rt || G === pt || G === Yt ? 2 : G === Et ? 4 : b1[G] * re;
    }
    function nr(G) {
      return !(G & G - 1) && !!G;
    }
    function F1(G, re, Qe) {
      var qe, st = re.width, Ue = re.height, Je = re.channels;
      u(
        st > 0 && st <= Qe.maxTextureSize && Ue > 0 && Ue <= Qe.maxTextureSize,
        "invalid texture shape"
      ), (G.wrapS !== ae || G.wrapT !== ae) && u(
        nr(st) && nr(Ue),
        "incompatible wrap mode for texture, both width and height must be power of 2"
      ), re.mipmask === 1 ? st !== 1 && Ue !== 1 && u(
        G.minFilter !== Ze && G.minFilter !== et && G.minFilter !== ze && G.minFilter !== lt,
        "min filter requires mipmap"
      ) : (u(
        nr(st) && nr(Ue),
        "texture must be a square power of 2 to support mipmapping"
      ), u(
        re.mipmask === (st << 1) - 1,
        "missing or incomplete mipmap data"
      )), re.type === Wt && (Qe.extensions.indexOf("oes_texture_float_linear") < 0 && u(
        G.minFilter === pe && G.magFilter === pe,
        "filter not supported, must enable oes_texture_float_linear"
      ), u(
        !G.genMipmaps,
        "mipmap generation not supported with float textures"
      ));
      var xt = re.images;
      for (qe = 0; qe < 16; ++qe)
        if (xt[qe]) {
          var yt = st >> qe, Ct = Ue >> qe;
          u(re.mipmask & 1 << qe, "missing mipmap data");
          var kt = xt[qe];
          if (u(
            kt.width === yt && kt.height === Ct,
            "invalid shape for mip images"
          ), u(
            kt.format === re.format && kt.internalformat === re.internalformat && kt.type === re.type,
            "incompatible type for mip image"
          ), !kt.compressed)
            if (kt.data) {
              var St = Math.ceil(Y1(kt.type, Je) * yt / kt.unpackAlignment) * kt.unpackAlignment;
              u(
                kt.data.byteLength === St * Ct,
                "invalid data for image, buffer size is inconsistent with image format"
              );
            } else
              kt.element || kt.copy;
        } else
          G.genMipmaps || u((re.mipmask & 1 << qe) === 0, "extra mipmap data");
      re.compressed && u(
        !G.genMipmaps,
        "mipmap generation for compressed images not supported"
      );
    }
    function qr(G, re, Qe, qe) {
      var st = G.width, Ue = G.height, Je = G.channels;
      u(
        st > 0 && st <= qe.maxTextureSize && Ue > 0 && Ue <= qe.maxTextureSize,
        "invalid texture shape"
      ), u(
        st === Ue,
        "cube map must be square"
      ), u(
        re.wrapS === ae && re.wrapT === ae,
        "wrap mode not supported by cube map"
      );
      for (var xt = 0; xt < Qe.length; ++xt) {
        var yt = Qe[xt];
        u(
          yt.width === st && yt.height === Ue,
          "inconsistent cube map face shape"
        ), re.genMipmaps && (u(
          !yt.compressed,
          "can not generate mipmap for compressed textures"
        ), u(
          yt.mipmask === 1,
          "can not specify mipmaps and generate mipmaps"
        ));
        for (var Ct = yt.images, kt = 0; kt < 16; ++kt) {
          var St = Ct[kt];
          if (St) {
            var It = st >> kt, At = Ue >> kt;
            u(yt.mipmask & 1 << kt, "missing mipmap data"), u(
              St.width === It && St.height === At,
              "invalid shape for mip images"
            ), u(
              St.format === G.format && St.internalformat === G.internalformat && St.type === G.type,
              "incompatible type for mip image"
            ), St.compressed || (St.data ? u(
              St.data.byteLength === It * At * Math.max(Y1(St.type, Je), St.unpackAlignment),
              "invalid data for image, buffer size is inconsistent with image format"
            ) : St.element || St.copy);
          }
        }
      }
    }
    var te = o(u, {
      optional: ce,
      raise: c,
      commandRaise: q,
      command: I,
      parameter: f,
      commandParameter: U,
      constructor: L,
      type: m,
      commandType: H,
      isTypedArray: T,
      nni: g,
      oneOf: v,
      shaderError: B,
      linkError: F,
      callSite: w,
      saveCommandRef: j,
      saveDrawInfo: z,
      framebufferFormat: Ae,
      guessCommand: k,
      texture2D: F1,
      textureCube: qr
    }), vr = 0, Ir = 0, Hr = 5, ge = 6;
    function Y(G, re) {
      this.id = vr++, this.type = G, this.data = re;
    }
    function Ot(G) {
      return G.replace(/\\/g, "\\\\").replace(/"/g, '\\"');
    }
    function r1(G) {
      if (G.length === 0)
        return [];
      var re = G.charAt(0), Qe = G.charAt(G.length - 1);
      if (G.length > 1 && re === Qe && (re === '"' || re === "'"))
        return ['"' + Ot(G.substr(1, G.length - 2)) + '"'];
      var qe = /\[(false|true|null|\d+|'[^']*'|"[^"]*")\]/.exec(G);
      if (qe)
        return r1(G.substr(0, qe.index)).concat(r1(qe[1])).concat(r1(G.substr(qe.index + qe[0].length)));
      var st = G.split(".");
      if (st.length === 1)
        return ['"' + Ot(G) + '"'];
      for (var Ue = [], Je = 0; Je < st.length; ++Je)
        Ue = Ue.concat(r1(st[Je]));
      return Ue;
    }
    function o1(G) {
      return "[" + r1(G).join("][") + "]";
    }
    function S1(G, re) {
      return new Y(G, o1(re + ""));
    }
    function O1(G) {
      return typeof G == "function" && !G._reglType || G instanceof Y;
    }
    function sr(G, re) {
      if (typeof G == "function")
        return new Y(Ir, G);
      if (typeof G == "number" || typeof G == "boolean")
        return new Y(Hr, G);
      if (Array.isArray(G))
        return new Y(ge, G.map(function(Qe, qe) {
          return sr(Qe, re + "[" + qe + "]");
        }));
      if (G instanceof Y)
        return G;
      te(!1, "invalid option type in uniform " + re);
    }
    var m1 = {
      DynamicVariable: Y,
      define: S1,
      isDynamic: O1,
      unbox: sr,
      accessor: o1
    }, W1 = {
      next: typeof requestAnimationFrame == "function" ? function(G) {
        return requestAnimationFrame(G);
      } : function(G) {
        return setTimeout(G, 16);
      },
      cancel: typeof cancelAnimationFrame == "function" ? function(G) {
        return cancelAnimationFrame(G);
      } : clearTimeout
    }, er = typeof performance < "u" && performance.now ? function() {
      return performance.now();
    } : function() {
      return +new Date();
    };
    function tr() {
      var G = { "": 0 }, re = [""];
      return {
        id: function(Qe) {
          var qe = G[Qe];
          return qe || (qe = G[Qe] = re.length, re.push(Qe), qe);
        },
        str: function(Qe) {
          return re[Qe];
        }
      };
    }
    function B1(G, re, Qe) {
      var qe = document.createElement("canvas");
      o(qe.style, {
        border: 0,
        margin: 0,
        padding: 0,
        top: 0,
        left: 0,
        width: "100%",
        height: "100%"
      }), G.appendChild(qe), G === document.body && (qe.style.position = "absolute", o(G.style, {
        margin: 0,
        padding: 0
      }));
      function st() {
        var xt = window.innerWidth, yt = window.innerHeight;
        if (G !== document.body) {
          var Ct = qe.getBoundingClientRect();
          xt = Ct.right - Ct.left, yt = Ct.bottom - Ct.top;
        }
        qe.width = Qe * xt, qe.height = Qe * yt;
      }
      var Ue;
      G !== document.body && typeof ResizeObserver == "function" ? (Ue = new ResizeObserver(function() {
        setTimeout(st);
      }), Ue.observe(G)) : window.addEventListener("resize", st, !1);
      function Je() {
        Ue ? Ue.disconnect() : window.removeEventListener("resize", st), G.removeChild(qe);
      }
      return st(), {
        canvas: qe,
        onDestroy: Je
      };
    }
    function br(G, re) {
      function Qe(qe) {
        try {
          return G.getContext(qe, re);
        } catch {
          return null;
        }
      }
      return Qe("webgl") || Qe("experimental-webgl") || Qe("webgl-experimental");
    }
    function cr(G) {
      return typeof G.nodeName == "string" && typeof G.appendChild == "function" && typeof G.getBoundingClientRect == "function";
    }
    function _r(G) {
      return typeof G.drawArrays == "function" || typeof G.drawElements == "function";
    }
    function Er(G) {
      return typeof G == "string" ? G.split() : (te(Array.isArray(G), "invalid extension array"), G);
    }
    function Jr(G) {
      return typeof G == "string" ? (te(typeof document < "u", "not supported outside of DOM"), document.querySelector(G)) : G;
    }
    function _n(G) {
      var re = G || {}, Qe, qe, st, Ue, Je = {}, xt = [], yt = [], Ct = typeof window > "u" ? 1 : window.devicePixelRatio, kt = !1, St = function(Mt) {
        Mt && te.raise(Mt);
      }, It = function() {
      };
      if (typeof re == "string" ? (te(
        typeof document < "u",
        "selector queries only supported in DOM enviroments"
      ), Qe = document.querySelector(re), te(Qe, "invalid query string for element")) : typeof re == "object" ? cr(re) ? Qe = re : _r(re) ? (Ue = re, st = Ue.canvas) : (te.constructor(re), "gl" in re ? Ue = re.gl : "canvas" in re ? st = Jr(re.canvas) : "container" in re && (qe = Jr(re.container)), "attributes" in re && (Je = re.attributes, te.type(Je, "object", "invalid context attributes")), "extensions" in re && (xt = Er(re.extensions)), "optionalExtensions" in re && (yt = Er(re.optionalExtensions)), "onDone" in re && (te.type(
        re.onDone,
        "function",
        "invalid or missing onDone callback"
      ), St = re.onDone), "profile" in re && (kt = !!re.profile), "pixelRatio" in re && (Ct = +re.pixelRatio, te(Ct > 0, "invalid pixel ratio"))) : te.raise("invalid arguments to regl"), Qe && (Qe.nodeName.toLowerCase() === "canvas" ? st = Qe : qe = Qe), !Ue) {
        if (!st) {
          te(
            typeof document < "u",
            "must manually specify webgl context outside of DOM environments"
          );
          var At = B1(qe || document.body, St, Ct);
          if (!At)
            return null;
          st = At.canvas, It = At.onDestroy;
        }
        Je.premultipliedAlpha === void 0 && (Je.premultipliedAlpha = !0), Ue = br(st, Je);
      }
      return Ue ? {
        gl: Ue,
        canvas: st,
        container: qe,
        extensions: xt,
        optionalExtensions: yt,
        pixelRatio: Ct,
        profile: kt,
        onDone: St,
        onDestroy: It
      } : (It(), St("webgl not supported, try upgrading your browser or graphics drivers http://get.webgl.org"), null);
    }
    function Tn(G, re) {
      var Qe = {};
      function qe(Je) {
        te.type(Je, "string", "extension name must be string");
        var xt = Je.toLowerCase(), yt;
        try {
          yt = Qe[xt] = G.getExtension(xt);
        } catch {
        }
        return !!yt;
      }
      for (var st = 0; st < re.extensions.length; ++st) {
        var Ue = re.extensions[st];
        if (!qe(Ue))
          return re.onDestroy(), re.onDone('"' + Ue + '" extension is not supported by the current WebGL context, try upgrading your system or a different browser'), null;
      }
      return re.optionalExtensions.forEach(qe), {
        extensions: Qe,
        restore: function() {
          Object.keys(Qe).forEach(function(Je) {
            if (Qe[Je] && !qe(Je))
              throw new Error("(regl): error restoring extension " + Je);
          });
        }
      };
    }
    function hr(G, re) {
      for (var Qe = Array(G), qe = 0; qe < G; ++qe)
        Qe[qe] = re(qe);
      return Qe;
    }
    var Dn = 5120, en = 5121, An = 5122, pn = 5123, qn = 5124, Rn = 5125, gn = 5126;
    function Ln(G) {
      for (var re = 16; re <= 1 << 28; re *= 16)
        if (G <= re)
          return re;
      return 0;
    }
    function Vr(G) {
      var re, Qe;
      return re = (G > 65535) << 4, G >>>= re, Qe = (G > 255) << 3, G >>>= Qe, re |= Qe, Qe = (G > 15) << 2, G >>>= Qe, re |= Qe, Qe = (G > 3) << 1, G >>>= Qe, re |= Qe, re | G >> 1;
    }
    function vn() {
      var G = hr(8, function() {
        return [];
      });
      function re(Ue) {
        var Je = Ln(Ue), xt = G[Vr(Je) >> 2];
        return xt.length > 0 ? xt.pop() : new ArrayBuffer(Je);
      }
      function Qe(Ue) {
        G[Vr(Ue.byteLength) >> 2].push(Ue);
      }
      function qe(Ue, Je) {
        var xt = null;
        switch (Ue) {
          case Dn:
            xt = new Int8Array(re(Je), 0, Je);
            break;
          case en:
            xt = new Uint8Array(re(Je), 0, Je);
            break;
          case An:
            xt = new Int16Array(re(2 * Je), 0, Je);
            break;
          case pn:
            xt = new Uint16Array(re(2 * Je), 0, Je);
            break;
          case qn:
            xt = new Int32Array(re(4 * Je), 0, Je);
            break;
          case Rn:
            xt = new Uint32Array(re(4 * Je), 0, Je);
            break;
          case gn:
            xt = new Float32Array(re(4 * Je), 0, Je);
            break;
          default:
            return null;
        }
        return xt.length !== Je ? xt.subarray(0, Je) : xt;
      }
      function st(Ue) {
        Qe(Ue.buffer);
      }
      return {
        alloc: re,
        free: Qe,
        allocType: qe,
        freeType: st
      };
    }
    var ir = vn();
    ir.zero = vn();
    var Hn = 3408, yn = 3410, Cn = 3411, In = 3412, wn = 3413, an = 3414, Z1 = 3415, tn = 33901, Dr = 33902, Sn = 3379, xn = 3386, $n = 34921, wr = 36347, Br = 36348, sn = 35661, ie = 35660, ue = 34930, Ce = 36349, rt = 34076, Vt = 34024, jt = 7936, l1 = 7937, _1 = 7938, c1 = 35724, p1 = 34047, H1 = 36063, D1 = 34852, mr = 3553, rn = 34067, ln = 34069, rr = 33984, ve = 6408, we = 5126, Oe = 5121, mt = 36160, $t = 36053, h1 = 36064, X = 16384, ee = function(G, re) {
      var Qe = 1;
      re.ext_texture_filter_anisotropic && (Qe = G.getParameter(p1));
      var qe = 1, st = 1;
      re.webgl_draw_buffers && (qe = G.getParameter(D1), st = G.getParameter(H1));
      var Ue = !!re.oes_texture_float;
      if (Ue) {
        var Je = G.createTexture();
        G.bindTexture(mr, Je), G.texImage2D(mr, 0, ve, 1, 1, 0, ve, we, null);
        var xt = G.createFramebuffer();
        if (G.bindFramebuffer(mt, xt), G.framebufferTexture2D(mt, h1, mr, Je, 0), G.bindTexture(mr, null), G.checkFramebufferStatus(mt) !== $t)
          Ue = !1;
        else {
          G.viewport(0, 0, 1, 1), G.clearColor(1, 0, 0, 1), G.clear(X);
          var yt = ir.allocType(we, 4);
          G.readPixels(0, 0, 1, 1, ve, we, yt), G.getError() ? Ue = !1 : (G.deleteFramebuffer(xt), G.deleteTexture(Je), Ue = yt[0] === 1), ir.freeType(yt);
        }
      }
      var Ct = typeof navigator < "u" && (/MSIE/.test(navigator.userAgent) || /Trident\//.test(navigator.appVersion) || /Edge/.test(navigator.userAgent)), kt = !0;
      if (!Ct) {
        var St = G.createTexture(), It = ir.allocType(Oe, 36);
        G.activeTexture(rr), G.bindTexture(rn, St), G.texImage2D(ln, 0, ve, 3, 3, 0, ve, Oe, It), ir.freeType(It), G.bindTexture(rn, null), G.deleteTexture(St), kt = !G.getError();
      }
      return {
        colorBits: [
          G.getParameter(yn),
          G.getParameter(Cn),
          G.getParameter(In),
          G.getParameter(wn)
        ],
        depthBits: G.getParameter(an),
        stencilBits: G.getParameter(Z1),
        subpixelBits: G.getParameter(Hn),
        extensions: Object.keys(re).filter(function(At) {
          return !!re[At];
        }),
        maxAnisotropic: Qe,
        maxDrawbuffers: qe,
        maxColorAttachments: st,
        pointSizeDims: G.getParameter(tn),
        lineWidthDims: G.getParameter(Dr),
        maxViewportDims: G.getParameter(xn),
        maxCombinedTextureUnits: G.getParameter(sn),
        maxCubeMapSize: G.getParameter(rt),
        maxRenderbufferSize: G.getParameter(Vt),
        maxTextureUnits: G.getParameter(ue),
        maxTextureSize: G.getParameter(Sn),
        maxAttributes: G.getParameter($n),
        maxVertexUniforms: G.getParameter(wr),
        maxVertexTextureUnits: G.getParameter(ie),
        maxVaryingVectors: G.getParameter(Br),
        maxFragmentUniforms: G.getParameter(Ce),
        glsl: G.getParameter(c1),
        renderer: G.getParameter(l1),
        vendor: G.getParameter(jt),
        version: G.getParameter(_1),
        readFloat: Ue,
        npotTextureCube: kt
      };
    };
    function fe(G) {
      return !!G && typeof G == "object" && Array.isArray(G.shape) && Array.isArray(G.stride) && typeof G.offset == "number" && G.shape.length === G.stride.length && (Array.isArray(G.data) || r(G.data));
    }
    var Pe = function(G) {
      return Object.keys(G).map(function(re) {
        return G[re];
      });
    }, vt = {
      shape: Ut,
      flatten: _t
    };
    function a1(G, re, Qe) {
      for (var qe = 0; qe < re; ++qe)
        Qe[qe] = G[qe];
    }
    function Te(G, re, Qe, qe) {
      for (var st = 0, Ue = 0; Ue < re; ++Ue)
        for (var Je = G[Ue], xt = 0; xt < Qe; ++xt)
          qe[st++] = Je[xt];
    }
    function Ee(G, re, Qe, qe, st, Ue) {
      for (var Je = Ue, xt = 0; xt < re; ++xt)
        for (var yt = G[xt], Ct = 0; Ct < Qe; ++Ct)
          for (var kt = yt[Ct], St = 0; St < qe; ++St)
            st[Je++] = kt[St];
    }
    function Ge(G, re, Qe, qe, st) {
      for (var Ue = 1, Je = Qe + 1; Je < re.length; ++Je)
        Ue *= re[Je];
      var xt = re[Qe];
      if (re.length - Qe === 4) {
        var yt = re[Qe + 1], Ct = re[Qe + 2], kt = re[Qe + 3];
        for (Je = 0; Je < xt; ++Je)
          Ee(G[Je], yt, Ct, kt, qe, st), st += Ue;
      } else
        for (Je = 0; Je < xt; ++Je)
          Ge(G[Je], re, Qe + 1, qe, st), st += Ue;
    }
    function _t(G, re, Qe, qe) {
      var st = 1;
      if (re.length)
        for (var Ue = 0; Ue < re.length; ++Ue)
          st *= re[Ue];
      else
        st = 0;
      var Je = qe || ir.allocType(Qe, st);
      switch (re.length) {
        case 0:
          break;
        case 1:
          a1(G, re[0], Je);
          break;
        case 2:
          Te(G, re[0], re[1], Je);
          break;
        case 3:
          Ee(G, re[0], re[1], re[2], Je, 0);
          break;
        default:
          Ge(G, re, 0, Je, 0);
      }
      return Je;
    }
    function Ut(G) {
      for (var re = [], Qe = G; Qe.length; Qe = Qe[0])
        re.push(Qe.length);
      return re;
    }
    var Jt = {
      "[object Int8Array]": 5120,
      "[object Int16Array]": 5122,
      "[object Int32Array]": 5124,
      "[object Uint8Array]": 5121,
      "[object Uint8ClampedArray]": 5121,
      "[object Uint16Array]": 5123,
      "[object Uint32Array]": 5125,
      "[object Float32Array]": 5126,
      "[object Float64Array]": 5121,
      "[object ArrayBuffer]": 5121
    }, P1 = 5120, Q1 = 5122, gr = 5124, fr = 5121, Ar = 5123, Lr = 5125, ur = 5126, Cr = 5126, yr = {
      int8: P1,
      int16: Q1,
      int32: gr,
      uint8: fr,
      uint16: Ar,
      uint32: Lr,
      float: ur,
      float32: Cr
    }, $r = 35048, jr = 35040, Wn = {
      dynamic: $r,
      stream: jr,
      static: 35044
    }, Jn = vt.flatten, e2 = vt.shape, w2 = 35044, M2 = 35040, h2 = 5121, Bn = 5126, Zn = [];
    Zn[5120] = 1, Zn[5122] = 2, Zn[5124] = 4, Zn[5121] = 1, Zn[5123] = 2, Zn[5125] = 4, Zn[5126] = 4;
    function f2(G) {
      return Jt[Object.prototype.toString.call(G)] | 0;
    }
    function Ci(G, re) {
      for (var Qe = 0; Qe < re.length; ++Qe)
        G[Qe] = re[Qe];
    }
    function Si(G, re, Qe, qe, st, Ue, Je) {
      for (var xt = 0, yt = 0; yt < Qe; ++yt)
        for (var Ct = 0; Ct < qe; ++Ct)
          G[xt++] = re[st * yt + Ue * Ct + Je];
    }
    function no(G, re, Qe, qe) {
      var st = 0, Ue = {};
      function Je(De) {
        this.id = st++, this.buffer = G.createBuffer(), this.type = De, this.usage = w2, this.byteLength = 0, this.dimension = 1, this.dtype = h2, this.persistentData = null, Qe.profile && (this.stats = { size: 0 });
      }
      Je.prototype.bind = function() {
        G.bindBuffer(this.type, this.buffer);
      }, Je.prototype.destroy = function() {
        It(this);
      };
      var xt = [];
      function yt(De, Xe) {
        var wt = xt.pop();
        return wt || (wt = new Je(De)), wt.bind(), St(wt, Xe, M2, 0, 1, !1), wt;
      }
      function Ct(De) {
        xt.push(De);
      }
      function kt(De, Xe, wt) {
        De.byteLength = Xe.byteLength, G.bufferData(De.type, Xe, wt);
      }
      function St(De, Xe, wt, Xt, Tt, qt) {
        var Gt;
        if (De.usage = wt, Array.isArray(Xe)) {
          if (De.dtype = Xt || Bn, Xe.length > 0) {
            var T1;
            if (Array.isArray(Xe[0])) {
              Gt = e2(Xe);
              for (var ct = 1, at = 1; at < Gt.length; ++at)
                ct *= Gt[at];
              De.dimension = ct, T1 = Jn(Xe, Gt, De.dtype), kt(De, T1, wt), qt ? De.persistentData = T1 : ir.freeType(T1);
            } else if (typeof Xe[0] == "number") {
              De.dimension = Tt;
              var i1 = ir.allocType(De.dtype, Xe.length);
              Ci(i1, Xe), kt(De, i1, wt), qt ? De.persistentData = i1 : ir.freeType(i1);
            } else
              r(Xe[0]) ? (De.dimension = Xe[0].length, De.dtype = Xt || f2(Xe[0]) || Bn, T1 = Jn(
                Xe,
                [Xe.length, Xe[0].length],
                De.dtype
              ), kt(De, T1, wt), qt ? De.persistentData = T1 : ir.freeType(T1)) : te.raise("invalid buffer data");
          }
        } else if (r(Xe))
          De.dtype = Xt || f2(Xe), De.dimension = Tt, kt(De, Xe, wt), qt && (De.persistentData = new Uint8Array(new Uint8Array(Xe.buffer)));
        else if (fe(Xe)) {
          Gt = Xe.shape;
          var Bt = Xe.stride, Lt = Xe.offset, Nt = 0, Ft = 0, E1 = 0, M1 = 0;
          Gt.length === 1 ? (Nt = Gt[0], Ft = 1, E1 = Bt[0], M1 = 0) : Gt.length === 2 ? (Nt = Gt[0], Ft = Gt[1], E1 = Bt[0], M1 = Bt[1]) : te.raise("invalid shape"), De.dtype = Xt || f2(Xe.data) || Bn, De.dimension = Ft;
          var zt = ir.allocType(De.dtype, Nt * Ft);
          Si(
            zt,
            Xe.data,
            Nt,
            Ft,
            E1,
            M1,
            Lt
          ), kt(De, zt, wt), qt ? De.persistentData = zt : ir.freeType(zt);
        } else
          Xe instanceof ArrayBuffer ? (De.dtype = h2, De.dimension = Tt, kt(De, Xe, wt), qt && (De.persistentData = new Uint8Array(new Uint8Array(Xe)))) : te.raise("invalid buffer data");
      }
      function It(De) {
        re.bufferCount--, qe(De);
        var Xe = De.buffer;
        te(Xe, "buffer must not be deleted already"), G.deleteBuffer(Xe), De.buffer = null, delete Ue[De.id];
      }
      function At(De, Xe, wt, Xt) {
        re.bufferCount++;
        var Tt = new Je(Xe);
        Ue[Tt.id] = Tt;
        function qt(ct) {
          var at = w2, i1 = null, Bt = 0, Lt = 0, Nt = 1;
          return Array.isArray(ct) || r(ct) || fe(ct) || ct instanceof ArrayBuffer ? i1 = ct : typeof ct == "number" ? Bt = ct | 0 : ct && (te.type(
            ct,
            "object",
            "buffer arguments must be an object, a number or an array"
          ), "data" in ct && (te(
            i1 === null || Array.isArray(i1) || r(i1) || fe(i1),
            "invalid data for buffer"
          ), i1 = ct.data), "usage" in ct && (te.parameter(ct.usage, Wn, "invalid buffer usage"), at = Wn[ct.usage]), "type" in ct && (te.parameter(ct.type, yr, "invalid buffer type"), Lt = yr[ct.type]), "dimension" in ct && (te.type(ct.dimension, "number", "invalid dimension"), Nt = ct.dimension | 0), "length" in ct && (te.nni(Bt, "buffer length must be a nonnegative integer"), Bt = ct.length | 0)), Tt.bind(), i1 ? St(Tt, i1, at, Lt, Nt, Xt) : (Bt && G.bufferData(Tt.type, Bt, at), Tt.dtype = Lt || h2, Tt.usage = at, Tt.dimension = Nt, Tt.byteLength = Bt), Qe.profile && (Tt.stats.size = Tt.byteLength * Zn[Tt.dtype]), qt;
        }
        function Gt(ct, at) {
          te(
            at + ct.byteLength <= Tt.byteLength,
            "invalid buffer subdata call, buffer is too small.  Can't write data of size " + ct.byteLength + " starting from offset " + at + " to a buffer of size " + Tt.byteLength
          ), G.bufferSubData(Tt.type, at, ct);
        }
        function T1(ct, at) {
          var i1 = (at || 0) | 0, Bt;
          if (Tt.bind(), r(ct) || ct instanceof ArrayBuffer)
            Gt(ct, i1);
          else if (Array.isArray(ct)) {
            if (ct.length > 0)
              if (typeof ct[0] == "number") {
                var Lt = ir.allocType(Tt.dtype, ct.length);
                Ci(Lt, ct), Gt(Lt, i1), ir.freeType(Lt);
              } else if (Array.isArray(ct[0]) || r(ct[0])) {
                Bt = e2(ct);
                var Nt = Jn(ct, Bt, Tt.dtype);
                Gt(Nt, i1), ir.freeType(Nt);
              } else
                te.raise("invalid buffer data");
          } else if (fe(ct)) {
            Bt = ct.shape;
            var Ft = ct.stride, E1 = 0, M1 = 0, zt = 0, Zt = 0;
            Bt.length === 1 ? (E1 = Bt[0], M1 = 1, zt = Ft[0], Zt = 0) : Bt.length === 2 ? (E1 = Bt[0], M1 = Bt[1], zt = Ft[0], Zt = Ft[1]) : te.raise("invalid shape");
            var y1 = Array.isArray(ct.data) ? Tt.dtype : f2(ct.data), k1 = ir.allocType(y1, E1 * M1);
            Si(
              k1,
              ct.data,
              E1,
              M1,
              zt,
              Zt,
              ct.offset
            ), Gt(k1, i1), ir.freeType(k1);
          } else
            te.raise("invalid data for buffer subdata");
          return qt;
        }
        return wt || qt(De), qt._reglType = "buffer", qt._buffer = Tt, qt.subdata = T1, Qe.profile && (qt.stats = Tt.stats), qt.destroy = function() {
          It(Tt);
        }, qt;
      }
      function Mt() {
        Pe(Ue).forEach(function(De) {
          De.buffer = G.createBuffer(), G.bindBuffer(De.type, De.buffer), G.bufferData(
            De.type,
            De.persistentData || De.byteLength,
            De.usage
          );
        });
      }
      return Qe.profile && (re.getTotalBufferSize = function() {
        var De = 0;
        return Object.keys(Ue).forEach(function(Xe) {
          De += Ue[Xe].stats.size;
        }), De;
      }), {
        create: At,
        createStream: yt,
        destroyStream: Ct,
        clear: function() {
          Pe(Ue).forEach(It), xt.forEach(It);
        },
        getBuffer: function(De) {
          return De && De._buffer instanceof Je ? De._buffer : null;
        },
        restore: Mt,
        _initBuffer: St
      };
    }
    var C = 0, V = 0, P = 1, N = 1, W = 4, Z = 4, K = {
      points: C,
      point: V,
      lines: P,
      line: N,
      triangles: W,
      triangle: Z,
      "line loop": 2,
      "line strip": 3,
      "triangle strip": 5,
      "triangle fan": 6
    }, Me = 0, ye = 1, Ie = 4, it = 5120, Ht = 5121, Ke = 5122, ht = 5123, A1 = 5124, j1 = 5125, v1 = 34963, Wr = 35040, Nr = 35044;
    function Mn(G, re, Qe, qe) {
      var st = {}, Ue = 0, Je = {
        uint8: Ht,
        uint16: ht
      };
      re.oes_element_index_uint && (Je.uint32 = j1);
      function xt(Mt) {
        this.id = Ue++, st[this.id] = this, this.buffer = Mt, this.primType = Ie, this.vertCount = 0, this.type = 0;
      }
      xt.prototype.bind = function() {
        this.buffer.bind();
      };
      var yt = [];
      function Ct(Mt) {
        var De = yt.pop();
        return De || (De = new xt(Qe.create(
          null,
          v1,
          !0,
          !1
        )._buffer)), St(De, Mt, Wr, -1, -1, 0, 0), De;
      }
      function kt(Mt) {
        yt.push(Mt);
      }
      function St(Mt, De, Xe, wt, Xt, Tt, qt) {
        Mt.buffer.bind();
        var Gt;
        if (De) {
          var T1 = qt;
          !qt && (!r(De) || fe(De) && !r(De.data)) && (T1 = re.oes_element_index_uint ? j1 : ht), Qe._initBuffer(
            Mt.buffer,
            De,
            Xe,
            T1,
            3
          );
        } else
          G.bufferData(v1, Tt, Xe), Mt.buffer.dtype = Gt || Ht, Mt.buffer.usage = Xe, Mt.buffer.dimension = 3, Mt.buffer.byteLength = Tt;
        if (Gt = qt, !qt) {
          switch (Mt.buffer.dtype) {
            case Ht:
            case it:
              Gt = Ht;
              break;
            case ht:
            case Ke:
              Gt = ht;
              break;
            case j1:
            case A1:
              Gt = j1;
              break;
            default:
              te.raise("unsupported type for element array");
          }
          Mt.buffer.dtype = Gt;
        }
        Mt.type = Gt, te(
          Gt !== j1 || !!re.oes_element_index_uint,
          "32 bit element buffers not supported, enable oes_element_index_uint first"
        );
        var ct = Xt;
        ct < 0 && (ct = Mt.buffer.byteLength, Gt === ht ? ct >>= 1 : Gt === j1 && (ct >>= 2)), Mt.vertCount = ct;
        var at = wt;
        if (wt < 0) {
          at = Ie;
          var i1 = Mt.buffer.dimension;
          i1 === 1 && (at = Me), i1 === 2 && (at = ye), i1 === 3 && (at = Ie);
        }
        Mt.primType = at;
      }
      function It(Mt) {
        qe.elementsCount--, te(Mt.buffer !== null, "must not double destroy elements"), delete st[Mt.id], Mt.buffer.destroy(), Mt.buffer = null;
      }
      function At(Mt, De) {
        var Xe = Qe.create(null, v1, !0), wt = new xt(Xe._buffer);
        qe.elementsCount++;
        function Xt(Tt) {
          if (!Tt)
            Xe(), wt.primType = Ie, wt.vertCount = 0, wt.type = Ht;
          else if (typeof Tt == "number")
            Xe(Tt), wt.primType = Ie, wt.vertCount = Tt | 0, wt.type = Ht;
          else {
            var qt = null, Gt = Nr, T1 = -1, ct = -1, at = 0, i1 = 0;
            Array.isArray(Tt) || r(Tt) || fe(Tt) ? qt = Tt : (te.type(Tt, "object", "invalid arguments for elements"), "data" in Tt && (qt = Tt.data, te(
              Array.isArray(qt) || r(qt) || fe(qt),
              "invalid data for element buffer"
            )), "usage" in Tt && (te.parameter(
              Tt.usage,
              Wn,
              "invalid element buffer usage"
            ), Gt = Wn[Tt.usage]), "primitive" in Tt && (te.parameter(
              Tt.primitive,
              K,
              "invalid element buffer primitive"
            ), T1 = K[Tt.primitive]), "count" in Tt && (te(
              typeof Tt.count == "number" && Tt.count >= 0,
              "invalid vertex count for elements"
            ), ct = Tt.count | 0), "type" in Tt && (te.parameter(
              Tt.type,
              Je,
              "invalid buffer type"
            ), i1 = Je[Tt.type]), "length" in Tt ? at = Tt.length | 0 : (at = ct, i1 === ht || i1 === Ke ? at *= 2 : (i1 === j1 || i1 === A1) && (at *= 4))), St(
              wt,
              qt,
              Gt,
              T1,
              ct,
              at,
              i1
            );
          }
          return Xt;
        }
        return Xt(Mt), Xt._reglType = "elements", Xt._elements = wt, Xt.subdata = function(Tt, qt) {
          return Xe.subdata(Tt, qt), Xt;
        }, Xt.destroy = function() {
          It(wt);
        }, Xt;
      }
      return {
        create: At,
        createStream: Ct,
        destroyStream: kt,
        getElements: function(Mt) {
          return typeof Mt == "function" && Mt._elements instanceof xt ? Mt._elements : null;
        },
        clear: function() {
          Pe(st).forEach(It);
        }
      };
    }
    var Tr = new Float32Array(1), N1 = new Uint32Array(Tr.buffer), bn = 5123;
    function or(G) {
      for (var re = ir.allocType(bn, G.length), Qe = 0; Qe < G.length; ++Qe)
        if (isNaN(G[Qe]))
          re[Qe] = 65535;
        else if (G[Qe] === 1 / 0)
          re[Qe] = 31744;
        else if (G[Qe] === -1 / 0)
          re[Qe] = 64512;
        else {
          Tr[0] = G[Qe];
          var qe = N1[0], st = qe >>> 31 << 15, Ue = (qe << 1 >>> 24) - 127, Je = qe >> 13 & (1 << 10) - 1;
          if (Ue < -24)
            re[Qe] = st;
          else if (Ue < -14) {
            var xt = -14 - Ue;
            re[Qe] = st + (Je + (1 << 10) >> xt);
          } else
            Ue > 15 ? re[Qe] = st + 31744 : re[Qe] = st + (Ue + 15 << 10) + Je;
        }
      return re;
    }
    function R1(G) {
      return Array.isArray(G) || r(G);
    }
    var T2 = function(G) {
      return !(G & G - 1) && !!G;
    }, F2 = 34467, kr = 3553, Xn = 34067, Nn = 34069, Fr = 6408, Fn = 6406, Qn = 6407, En = 6409, H2 = 6410, t2 = 32854, C2 = 32855, dr = 36194, a2 = 32819, Ei = 32820, ii = 33635, io = 34042, Q2 = 6402, G2 = 34041, z2 = 35904, oi = 35906, _2 = 36193, ai = 33776, p2 = 33777, si = 33778, li = 33779, ki = 35986, m2 = 35987, Vi = 34798, U2 = 35840, Gn = 35841, zn = 35842, ci = 35843, ui = 36196, s2 = 5121, di = 5123, Qr = 5125, r2 = 5126, On = 10242, jn = 10243, hi = 10497, q2 = 33071, oo = 33648, ao = 10240, Di = 10241, Yn = 9728, fi = 9729, W2 = 9984, S2 = 9985, E2 = 9986, k2 = 9987, so = 33170, l2 = 4352, Ti = 4353, Qi = 4354, lo = 34046, ne = 3317, xe = 37440, ke = 37441, Qt = 37443, Ne = 37444, gt = 33984, Dt = [
      W2,
      E2,
      S2,
      k2
    ], e1 = [
      0,
      En,
      H2,
      Qn,
      Fr
    ], Kt = {};
    Kt[En] = Kt[Fn] = Kt[Q2] = 1, Kt[G2] = Kt[H2] = 2, Kt[Qn] = Kt[z2] = 3, Kt[Fr] = Kt[oi] = 4;
    function w1(G) {
      return "[object " + G + "]";
    }
    var C1 = w1("HTMLCanvasElement"), $1 = w1("OffscreenCanvas"), K1 = w1("CanvasRenderingContext2D"), pr = w1("ImageBitmap"), V1 = w1("HTMLImageElement"), Gr = w1("HTMLVideoElement"), un = Object.keys(Jt).concat([
      C1,
      $1,
      K1,
      pr,
      V1,
      Gr
    ]), nn = [];
    nn[s2] = 1, nn[r2] = 4, nn[_2] = 2, nn[di] = 2, nn[Qr] = 4;
    var X1 = [];
    X1[t2] = 2, X1[C2] = 2, X1[dr] = 2, X1[G2] = 4, X1[ai] = 0.5, X1[p2] = 0.5, X1[si] = 1, X1[li] = 1, X1[ki] = 0.5, X1[m2] = 1, X1[Vi] = 1, X1[U2] = 0.5, X1[Gn] = 0.25, X1[zn] = 0.5, X1[ci] = 0.25, X1[ui] = 0.5;
    function g2(G) {
      return Array.isArray(G) && (G.length === 0 || typeof G[0] == "number");
    }
    function v2(G) {
      if (!Array.isArray(G))
        return !1;
      var re = G.length;
      return !(re === 0 || !R1(G[0]));
    }
    function Zr(G) {
      return Object.prototype.toString.call(G);
    }
    function Ro(G) {
      return Zr(G) === C1;
    }
    function Io(G) {
      return Zr(G) === $1;
    }
    function Z3(G) {
      return Zr(G) === K1;
    }
    function X3(G) {
      return Zr(G) === pr;
    }
    function Y3(G) {
      return Zr(G) === V1;
    }
    function K3(G) {
      return Zr(G) === Gr;
    }
    function co(G) {
      if (!G)
        return !1;
      var re = Zr(G);
      return un.indexOf(re) >= 0 ? !0 : g2(G) || v2(G) || fe(G);
    }
    function Bo(G) {
      return Jt[Object.prototype.toString.call(G)] | 0;
    }
    function J3(G, re) {
      var Qe = re.length;
      switch (G.type) {
        case s2:
        case di:
        case Qr:
        case r2:
          var qe = ir.allocType(G.type, Qe);
          qe.set(re), G.data = qe;
          break;
        case _2:
          G.data = or(re);
          break;
        default:
          te.raise("unsupported texture type, must specify a typed array");
      }
    }
    function No(G, re) {
      return ir.allocType(
        G.type === _2 ? r2 : G.type,
        re
      );
    }
    function Fo(G, re) {
      G.type === _2 ? (G.data = or(re), ir.freeType(re)) : G.data = re;
    }
    function ea(G, re, Qe, qe, st, Ue) {
      for (var Je = G.width, xt = G.height, yt = G.channels, Ct = Je * xt * yt, kt = No(G, Ct), St = 0, It = 0; It < xt; ++It)
        for (var At = 0; At < Je; ++At)
          for (var Mt = 0; Mt < yt; ++Mt)
            kt[St++] = re[Qe * At + qe * It + st * Mt + Ue];
      Fo(G, kt);
    }
    function $i(G, re, Qe, qe, st, Ue) {
      var Je;
      if (typeof X1[G] < "u" ? Je = X1[G] : Je = Kt[G] * nn[re], Ue && (Je *= 6), st) {
        for (var xt = 0, yt = Qe; yt >= 1; )
          xt += Je * yt * yt, yt /= 2;
        return xt;
      } else
        return Je * Qe * qe;
    }
    function ta(G, re, Qe, qe, st, Ue, Je) {
      var xt = {
        "don't care": l2,
        "dont care": l2,
        nice: Qi,
        fast: Ti
      }, yt = {
        repeat: hi,
        clamp: q2,
        mirror: oo
      }, Ct = {
        nearest: Yn,
        linear: fi
      }, kt = o({
        mipmap: k2,
        "nearest mipmap nearest": W2,
        "linear mipmap nearest": S2,
        "nearest mipmap linear": E2,
        "linear mipmap linear": k2
      }, Ct), St = {
        none: 0,
        browser: Ne
      }, It = {
        uint8: s2,
        rgba4: a2,
        rgb565: ii,
        "rgb5 a1": Ei
      }, At = {
        alpha: Fn,
        luminance: En,
        "luminance alpha": H2,
        rgb: Qn,
        rgba: Fr,
        rgba4: t2,
        "rgb5 a1": C2,
        rgb565: dr
      }, Mt = {};
      re.ext_srgb && (At.srgb = z2, At.srgba = oi), re.oes_texture_float && (It.float32 = It.float = r2), re.oes_texture_half_float && (It.float16 = It["half float"] = _2), re.webgl_depth_texture && (o(At, {
        depth: Q2,
        "depth stencil": G2
      }), o(It, {
        uint16: di,
        uint32: Qr,
        "depth stencil": io
      })), re.webgl_compressed_texture_s3tc && o(Mt, {
        "rgb s3tc dxt1": ai,
        "rgba s3tc dxt1": p2,
        "rgba s3tc dxt3": si,
        "rgba s3tc dxt5": li
      }), re.webgl_compressed_texture_atc && o(Mt, {
        "rgb atc": ki,
        "rgba atc explicit alpha": m2,
        "rgba atc interpolated alpha": Vi
      }), re.webgl_compressed_texture_pvrtc && o(Mt, {
        "rgb pvrtc 4bppv1": U2,
        "rgb pvrtc 2bppv1": Gn,
        "rgba pvrtc 4bppv1": zn,
        "rgba pvrtc 2bppv1": ci
      }), re.webgl_compressed_texture_etc1 && (Mt["rgb etc1"] = ui);
      var De = Array.prototype.slice.call(
        G.getParameter(F2)
      );
      Object.keys(Mt).forEach(function(de) {
        var We = Mt[de];
        De.indexOf(We) >= 0 && (At[de] = We);
      });
      var Xe = Object.keys(At);
      Qe.textureFormats = Xe;
      var wt = [];
      Object.keys(At).forEach(function(de) {
        var We = At[de];
        wt[We] = de;
      });
      var Xt = [];
      Object.keys(It).forEach(function(de) {
        var We = It[de];
        Xt[We] = de;
      });
      var Tt = [];
      Object.keys(Ct).forEach(function(de) {
        var We = Ct[de];
        Tt[We] = de;
      });
      var qt = [];
      Object.keys(kt).forEach(function(de) {
        var We = kt[de];
        qt[We] = de;
      });
      var Gt = [];
      Object.keys(yt).forEach(function(de) {
        var We = yt[de];
        Gt[We] = de;
      });
      var T1 = Xe.reduce(function(de, We) {
        var Fe = At[We];
        return Fe === En || Fe === Fn || Fe === En || Fe === H2 || Fe === Q2 || Fe === G2 || re.ext_srgb && (Fe === z2 || Fe === oi) ? de[Fe] = Fe : Fe === C2 || We.indexOf("rgba") >= 0 ? de[Fe] = Fr : de[Fe] = Qn, de;
      }, {});
      function ct() {
        this.internalformat = Fr, this.format = Fr, this.type = s2, this.compressed = !1, this.premultiplyAlpha = !1, this.flipY = !1, this.unpackAlignment = 1, this.colorSpace = Ne, this.width = 0, this.height = 0, this.channels = 0;
      }
      function at(de, We) {
        de.internalformat = We.internalformat, de.format = We.format, de.type = We.type, de.compressed = We.compressed, de.premultiplyAlpha = We.premultiplyAlpha, de.flipY = We.flipY, de.unpackAlignment = We.unpackAlignment, de.colorSpace = We.colorSpace, de.width = We.width, de.height = We.height, de.channels = We.channels;
      }
      function i1(de, We) {
        if (!(typeof We != "object" || !We)) {
          if ("premultiplyAlpha" in We && (te.type(
            We.premultiplyAlpha,
            "boolean",
            "invalid premultiplyAlpha"
          ), de.premultiplyAlpha = We.premultiplyAlpha), "flipY" in We && (te.type(
            We.flipY,
            "boolean",
            "invalid texture flip"
          ), de.flipY = We.flipY), "alignment" in We && (te.oneOf(
            We.alignment,
            [1, 2, 4, 8],
            "invalid texture unpack alignment"
          ), de.unpackAlignment = We.alignment), "colorSpace" in We && (te.parameter(
            We.colorSpace,
            St,
            "invalid colorSpace"
          ), de.colorSpace = St[We.colorSpace]), "type" in We) {
            var Fe = We.type;
            te(
              re.oes_texture_float || !(Fe === "float" || Fe === "float32"),
              "you must enable the OES_texture_float extension in order to use floating point textures."
            ), te(
              re.oes_texture_half_float || !(Fe === "half float" || Fe === "float16"),
              "you must enable the OES_texture_half_float extension in order to use 16-bit floating point textures."
            ), te(
              re.webgl_depth_texture || !(Fe === "uint16" || Fe === "uint32" || Fe === "depth stencil"),
              "you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures."
            ), te.parameter(
              Fe,
              It,
              "invalid texture type"
            ), de.type = It[Fe];
          }
          var n1 = de.width, G1 = de.height, oe = de.channels, J = !1;
          "shape" in We ? (te(
            Array.isArray(We.shape) && We.shape.length >= 2,
            "shape must be an array"
          ), n1 = We.shape[0], G1 = We.shape[1], We.shape.length === 3 && (oe = We.shape[2], te(oe > 0 && oe <= 4, "invalid number of channels"), J = !0), te(n1 >= 0 && n1 <= Qe.maxTextureSize, "invalid width"), te(G1 >= 0 && G1 <= Qe.maxTextureSize, "invalid height")) : ("radius" in We && (n1 = G1 = We.radius, te(n1 >= 0 && n1 <= Qe.maxTextureSize, "invalid radius")), "width" in We && (n1 = We.width, te(n1 >= 0 && n1 <= Qe.maxTextureSize, "invalid width")), "height" in We && (G1 = We.height, te(G1 >= 0 && G1 <= Qe.maxTextureSize, "invalid height")), "channels" in We && (oe = We.channels, te(oe > 0 && oe <= 4, "invalid number of channels"), J = !0)), de.width = n1 | 0, de.height = G1 | 0, de.channels = oe | 0;
          var me = !1;
          if ("format" in We) {
            var Ve = We.format;
            te(
              re.webgl_depth_texture || !(Ve === "depth" || Ve === "depth stencil"),
              "you must enable the WEBGL_depth_texture extensi