"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionInvokeAction = exports.StateMachineInput = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const action_1 = require("../action");
/**
 * Represents the input for the StateMachine.
 */
class StateMachineInput {
    constructor(input, inputArtifact, inputType) {
        this.input = input;
        this.inputArtifact = inputArtifact;
        this.inputType = inputType;
    }
    /**
     * When the input type is FilePath, input artifact and
     * filepath must be specified.
     */
    static filePath(inputFile) {
        return new StateMachineInput(inputFile.location, inputFile.artifact, 'FilePath');
    }
    /**
     * When the input type is Literal, input value is passed
     * directly to the state machine input.
     */
    static literal(object) {
        return new StateMachineInput(JSON.stringify(object), undefined, 'Literal');
    }
}
exports.StateMachineInput = StateMachineInput;
_a = JSII_RTTI_SYMBOL_1;
StateMachineInput[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.StateMachineInput", version: "1.156.1" };
/**
 * StepFunctionInvokeAction that is provided by an AWS CodePipeline.
 */
class StepFunctionInvokeAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            resource: props.stateMachine,
            category: codepipeline.ActionCategory.INVOKE,
            provider: 'StepFunctions',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 1,
            },
            inputs: (props.stateMachineInput && props.stateMachineInput.inputArtifact) ? [props.stateMachineInput.inputArtifact] : [],
            outputs: (props.output) ? [props.output] : [],
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_StepFunctionsInvokeActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.props = props;
    }
    bound(_scope, _stage, options) {
        var _c, _d, _e, _f, _g;
        // allow pipeline to invoke this step function
        options.role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['states:StartExecution', 'states:DescribeStateMachine'],
            resources: [this.props.stateMachine.stateMachineArn],
        }));
        // allow state machine executions to be inspected
        options.role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['states:DescribeExecution'],
            resources: [cdk.Stack.of(this.props.stateMachine).formatArn({
                    service: 'states',
                    resource: 'execution',
                    resourceName: `${cdk.Stack.of(this.props.stateMachine).splitArn(this.props.stateMachine.stateMachineArn, cdk.ArnFormat.COLON_RESOURCE_NAME).resourceName}:${(_c = this.props.executionNamePrefix) !== null && _c !== void 0 ? _c : ''}*`,
                    arnFormat: cdk.ArnFormat.COLON_RESOURCE_NAME,
                })],
        }));
        // allow the Role access to the Bucket, if there are any inputs/outputs
        if (((_d = this.actionProperties.inputs) !== null && _d !== void 0 ? _d : []).length > 0) {
            options.bucket.grantRead(options.role);
        }
        if (((_e = this.actionProperties.outputs) !== null && _e !== void 0 ? _e : []).length > 0) {
            options.bucket.grantWrite(options.role);
        }
        return {
            configuration: {
                StateMachineArn: this.props.stateMachine.stateMachineArn,
                Input: (_f = this.props.stateMachineInput) === null || _f === void 0 ? void 0 : _f.input,
                InputType: (_g = this.props.stateMachineInput) === null || _g === void 0 ? void 0 : _g.inputType,
                ExecutionNamePrefix: this.props.executionNamePrefix,
            },
        };
    }
}
exports.StepFunctionInvokeAction = StepFunctionInvokeAction;
_b = JSII_RTTI_SYMBOL_1;
StepFunctionInvokeAction[_b] = { fqn: "@aws-cdk/aws-codepipeline-actions.StepFunctionInvokeAction", version: "1.156.1" };
//# sourceMappingURL=data:application/json;base64,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