import sys

from pydantic import BaseModel, ConfigDict, model_validator

if sys.version_info[1] >= 11:
    from typing import Self
else:
    from typing_extensions import Self  # pragma: no cover

NON_DELETE_PROPERTIES = ["id", "delete"]


class BaseCZMLObject(BaseModel):
    model_config = ConfigDict(extra="forbid")

    @model_validator(mode="after")
    def check_delete(self) -> Self:
        if hasattr(self, "delete") and self.delete:
            for k in self.model_fields:
                if k not in NON_DELETE_PROPERTIES and getattr(self, k) is not None:
                    setattr(self, k, None)
        return self

    def __str__(self) -> str:
        return self.to_json()

    def dumps(self) -> str:
        return self.model_dump_json(exclude_none=True)

    def to_json(self, *, indent: int = 4) -> str:
        return self.model_dump_json(exclude_none=True, indent=indent)
