import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IPublicKey } from './public-key';
/**
 * Represents a Key Group.
 *
 * @stability stable
 */
export interface IKeyGroup extends IResource {
    /**
     * The ID of the key group.
     *
     * @stability stable
     * @attribute true
     */
    readonly keyGroupId: string;
}
/**
 * Properties for creating a Public Key.
 *
 * @stability stable
 */
export interface KeyGroupProps {
    /**
     * A name to identify the key group.
     *
     * @default - generated from the `id`
     * @stability stable
     */
    readonly keyGroupName?: string;
    /**
     * A comment to describe the key group.
     *
     * @default - no comment
     * @stability stable
     */
    readonly comment?: string;
    /**
     * A list of public keys to add to the key group.
     *
     * @stability stable
     */
    readonly items: IPublicKey[];
}
/**
 * A Key Group configuration.
 *
 * @stability stable
 * @resource AWS::CloudFront::KeyGroup
 */
export declare class KeyGroup extends Resource implements IKeyGroup {
    /**
     * Imports a Key Group from its id.
     *
     * @stability stable
     */
    static fromKeyGroupId(scope: Construct, id: string, keyGroupId: string): IKeyGroup;
    /**
     * The ID of the key group.
     *
     * @stability stable
     */
    readonly keyGroupId: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: KeyGroupProps);
    private generateName;
}
