"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.resourcePropertiesCountIs = void 0;
const assertions_1 = require("aws-cdk-lib/assertions");
// CDKv2's assertion module doesn't have a Template.resourcePropertiesCountIs that would count
// the number of resources with the given properties. We add that here.
function resourcePropertiesCountIs(stack, type, props, count) {
    const resources = assertions_1.Template.fromStack(stack).findResources(type, assertions_1.Match.objectLike({ Properties: props }));
    expect(Object.keys(resources)).toHaveLength(count);
}
exports.resourcePropertiesCountIs = resourcePropertiesCountIs;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC1oZWxwZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LWhlbHBlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztHQUdHOzs7QUFLSCx1REFHZ0M7QUFHaEMsOEZBQThGO0FBQzlGLHVFQUF1RTtBQUN2RSxTQUFnQix5QkFBeUIsQ0FBQyxLQUFZLEVBQUUsSUFBWSxFQUFFLEtBQVUsRUFBRSxLQUFhO0lBQzdGLE1BQU0sU0FBUyxHQUFHLHFCQUFRLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsa0JBQUssQ0FBQyxVQUFVLENBQUMsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ3pHLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQ3JELENBQUM7QUFIRCw4REFHQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7XG4gIFN0YWNrLFxufSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQge1xuICBNYXRjaCxcbiAgVGVtcGxhdGUsXG59IGZyb20gJ2F3cy1jZGstbGliL2Fzc2VydGlvbnMnO1xuXG5cbi8vIENES3YyJ3MgYXNzZXJ0aW9uIG1vZHVsZSBkb2Vzbid0IGhhdmUgYSBUZW1wbGF0ZS5yZXNvdXJjZVByb3BlcnRpZXNDb3VudElzIHRoYXQgd291bGQgY291bnRcbi8vIHRoZSBudW1iZXIgb2YgcmVzb3VyY2VzIHdpdGggdGhlIGdpdmVuIHByb3BlcnRpZXMuIFdlIGFkZCB0aGF0IGhlcmUuXG5leHBvcnQgZnVuY3Rpb24gcmVzb3VyY2VQcm9wZXJ0aWVzQ291bnRJcyhzdGFjazogU3RhY2ssIHR5cGU6IHN0cmluZywgcHJvcHM6IGFueSwgY291bnQ6IG51bWJlcik6IHZvaWQge1xuICBjb25zdCByZXNvdXJjZXMgPSBUZW1wbGF0ZS5mcm9tU3RhY2soc3RhY2spLmZpbmRSZXNvdXJjZXModHlwZSwgTWF0Y2gub2JqZWN0TGlrZSh7IFByb3BlcnRpZXM6IHByb3BzIH0pKTtcbiAgZXhwZWN0KE9iamVjdC5rZXlzKHJlc291cmNlcykpLnRvSGF2ZUxlbmd0aChjb3VudCk7XG59Il19