"""
    CryptoAPIs

    Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: developers@cryptoapis.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cryptoapis.api_client import ApiClient, Endpoint as _Endpoint
from cryptoapis.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cryptoapis.model.could_not_calculate_rate_for_pair import CouldNotCalculateRateForPair
from cryptoapis.model.feature_mainnets_not_allowed_for_plan import FeatureMainnetsNotAllowedForPlan
from cryptoapis.model.get_exchange_rate_by_asset_symbols_r import GetExchangeRateByAssetSymbolsR
from cryptoapis.model.get_exchange_rate_by_assets_ids_r import GetExchangeRateByAssetsIDsR
from cryptoapis.model.insufficient_credits import InsufficientCredits
from cryptoapis.model.invalid_api_key import InvalidApiKey
from cryptoapis.model.invalid_data import InvalidData
from cryptoapis.model.invalid_pagination import InvalidPagination
from cryptoapis.model.request_limit_reached import RequestLimitReached
from cryptoapis.model.unexpected_server_error import UnexpectedServerError
from cryptoapis.model.unsupported_media_type import UnsupportedMediaType


class ExchangeRatesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_exchange_rate_by_asset_symbols(
            self,
            from_asset_symbol,
            to_asset_symbol,
            **kwargs
        ):
            """Get Exchange Rate By Asset Symbols  # noqa: E501

            Through this endpoint customers can obtain exchange rates by asset symbols. The process represents the exchange rate value of a single unit of one asset versus another one. Data is provided per unique asset symbol.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_exchange_rate_by_asset_symbols(from_asset_symbol, to_asset_symbol, async_req=True)
            >>> result = thread.get()

            Args:
                from_asset_symbol (str): Defines the base asset symbol to get a rate for.
                to_asset_symbol (str): Defines the relation asset symbol in which the base asset rate will be displayed.

            Keyword Args:
                context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
                calculation_timestamp (int): Defines the time of the market data used to calculate the exchange rate in UNIX Timestamp.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetExchangeRateByAssetSymbolsR
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['from_asset_symbol'] = \
                from_asset_symbol
            kwargs['to_asset_symbol'] = \
                to_asset_symbol
            return self.call_with_http_info(**kwargs)

        self.get_exchange_rate_by_asset_symbols = _Endpoint(
            settings={
                'response_type': (GetExchangeRateByAssetSymbolsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/market-data/exchange-rates/by-symbols/{fromAssetSymbol}/{toAssetSymbol}',
                'operation_id': 'get_exchange_rate_by_asset_symbols',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'from_asset_symbol',
                    'to_asset_symbol',
                    'context',
                    'calculation_timestamp',
                ],
                'required': [
                    'from_asset_symbol',
                    'to_asset_symbol',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'from_asset_symbol':
                        (str,),
                    'to_asset_symbol':
                        (str,),
                    'context':
                        (str,),
                    'calculation_timestamp':
                        (int,),
                },
                'attribute_map': {
                    'from_asset_symbol': 'fromAssetSymbol',
                    'to_asset_symbol': 'toAssetSymbol',
                    'context': 'context',
                    'calculation_timestamp': 'calculationTimestamp',
                },
                'location_map': {
                    'from_asset_symbol': 'path',
                    'to_asset_symbol': 'path',
                    'context': 'query',
                    'calculation_timestamp': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_exchange_rate_by_asset_symbols
        )

        def __get_exchange_rate_by_assets_ids(
            self,
            from_asset_id,
            to_asset_id,
            **kwargs
        ):
            """Get Exchange Rate By Assets IDs  # noqa: E501

            Through this endpoint customers can obtain exchange rates by asset IDs. The process represents the exchange rate value of a single unit of one asset versus another one. Data is provided per unique asset Reference ID.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_exchange_rate_by_assets_ids(from_asset_id, to_asset_id, async_req=True)
            >>> result = thread.get()

            Args:
                from_asset_id (str): Defines the base asset Reference ID to get a rate for.
                to_asset_id (str): Defines the relation asset Reference ID in which the base asset rate will be displayed.

            Keyword Args:
                context (str): In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user.. [optional]
                calculation_timestamp (int): Defines the time of the market data used to calculate the exchange rate in UNIX Timestamp.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetExchangeRateByAssetsIDsR
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['from_asset_id'] = \
                from_asset_id
            kwargs['to_asset_id'] = \
                to_asset_id
            return self.call_with_http_info(**kwargs)

        self.get_exchange_rate_by_assets_ids = _Endpoint(
            settings={
                'response_type': (GetExchangeRateByAssetsIDsR,),
                'auth': [
                    'ApiKey'
                ],
                'endpoint_path': '/market-data/exchange-rates/by-asset-ids/{fromAssetId}/{toAssetId}',
                'operation_id': 'get_exchange_rate_by_assets_ids',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'from_asset_id',
                    'to_asset_id',
                    'context',
                    'calculation_timestamp',
                ],
                'required': [
                    'from_asset_id',
                    'to_asset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'from_asset_id':
                        (str,),
                    'to_asset_id':
                        (str,),
                    'context':
                        (str,),
                    'calculation_timestamp':
                        (int,),
                },
                'attribute_map': {
                    'from_asset_id': 'fromAssetId',
                    'to_asset_id': 'toAssetId',
                    'context': 'context',
                    'calculation_timestamp': 'calculationTimestamp',
                },
                'location_map': {
                    'from_asset_id': 'path',
                    'to_asset_id': 'path',
                    'context': 'query',
                    'calculation_timestamp': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_exchange_rate_by_assets_ids
        )
