/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.IOException;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.Utilities;

public class ToolGlobalSettings {
    private static boolean inited = false;
    private static String npmPath;
    private static String rubyPath;
    private static String testsPath;
    private static String comparePath;
    private static String tempPath;
    private static String testIgsPath;

    public static String getNpmPath() {
        ToolGlobalSettings.init();
        return npmPath;
    }

    public static String getRubyPath() {
        ToolGlobalSettings.init();
        return rubyPath;
    }

    public static String getTestsPath() {
        ToolGlobalSettings.init();
        return testsPath;
    }

    public static boolean hasNpmPath() {
        ToolGlobalSettings.init();
        return npmPath != null;
    }

    public static boolean hasRubyPath() {
        ToolGlobalSettings.init();
        return rubyPath != null;
    }

    public static boolean hasTestsPath() {
        ToolGlobalSettings.init();
        return testsPath != null;
    }

    public static String getComparePath() {
        ToolGlobalSettings.init();
        return comparePath;
    }

    public static boolean hasComparePath() {
        ToolGlobalSettings.init();
        return comparePath != null;
    }

    public static String getTempPath() {
        ToolGlobalSettings.init();
        return tempPath;
    }

    public static boolean hasTempPath() {
        ToolGlobalSettings.init();
        return tempPath != null;
    }

    public static String getTestIgsPath() {
        ToolGlobalSettings.init();
        return testIgsPath;
    }

    public static boolean hasTestIgsPath() {
        ToolGlobalSettings.init();
        return testIgsPath != null;
    }

    private static void init() {
        if (!inited) {
            inited = true;
            try {
                IniFile ini = new IniFile(Utilities.path(Utilities.path(System.getProperty("user.home"), ".fhir", "fhir-tool-settings.conf")));
                if (ini.hasSection("paths")) {
                    npmPath = ini.getStringProperty("paths", "npm");
                    rubyPath = ini.getStringProperty("paths", "ruby");
                    testsPath = ini.getStringProperty("paths", "tests");
                    comparePath = ini.getStringProperty("paths", "compare");
                    tempPath = ini.getStringProperty("paths", "temp");
                    testIgsPath = ini.getStringProperty("paths", "test-igs");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

