/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ReportResultCodes {
    PASS,
    FAIL,
    PENDING,
    NULL;


    public static ReportResultCodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("pass".equals(codeString)) {
            return PASS;
        }
        if ("fail".equals(codeString)) {
            return FAIL;
        }
        if ("pending".equals(codeString)) {
            return PENDING;
        }
        throw new FHIRException("Unknown ReportResultCodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PASS: {
                return "pass";
            }
            case FAIL: {
                return "fail";
            }
            case PENDING: {
                return "pending";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/report-result-codes";
    }

    public String getDefinition() {
        switch (this) {
            case PASS: {
                return "All test operations successfully passed all asserts.";
            }
            case FAIL: {
                return "One or more test operations failed one or more asserts.";
            }
            case PENDING: {
                return "One or more test operations is pending execution completion.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PASS: {
                return "Pass";
            }
            case FAIL: {
                return "Fail";
            }
            case PENDING: {
                return "Pending";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

