/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RelatedClaimRelationship {
    PRIOR,
    ASSOCIATED,
    NULL;


    public static RelatedClaimRelationship fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("prior".equals(codeString)) {
            return PRIOR;
        }
        if ("associated".equals(codeString)) {
            return ASSOCIATED;
        }
        throw new FHIRException("Unknown RelatedClaimRelationship code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRIOR: {
                return "prior";
            }
            case ASSOCIATED: {
                return "associated";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/ex-relatedclaimrelationship";
    }

    public String getDefinition() {
        switch (this) {
            case PRIOR: {
                return "A prior claim instance for the same intended suite of services.";
            }
            case ASSOCIATED: {
                return "A claim for a different suite of services which is related the suite claimed here.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRIOR: {
                return "Prior Claim";
            }
            case ASSOCIATED: {
                return "Associated Claim";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

