/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DefinitionResourceTypes {
    ACTIVITYDEFINITION,
    EVENTDEFINITION,
    MEASURE,
    OPERATIONDEFINITION,
    PLANDEFINITION,
    QUESTIONNAIRE,
    NULL;


    public static DefinitionResourceTypes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ActivityDefinition".equals(codeString)) {
            return ACTIVITYDEFINITION;
        }
        if ("EventDefinition".equals(codeString)) {
            return EVENTDEFINITION;
        }
        if ("Measure".equals(codeString)) {
            return MEASURE;
        }
        if ("OperationDefinition".equals(codeString)) {
            return OPERATIONDEFINITION;
        }
        if ("PlanDefinition".equals(codeString)) {
            return PLANDEFINITION;
        }
        if ("Questionnaire".equals(codeString)) {
            return QUESTIONNAIRE;
        }
        throw new FHIRException("Unknown DefinitionResourceTypes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVITYDEFINITION: {
                return "ActivityDefinition";
            }
            case EVENTDEFINITION: {
                return "EventDefinition";
            }
            case MEASURE: {
                return "Measure";
            }
            case OPERATIONDEFINITION: {
                return "OperationDefinition";
            }
            case PLANDEFINITION: {
                return "PlanDefinition";
            }
            case QUESTIONNAIRE: {
                return "Questionnaire";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/definition-resource-types";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVITYDEFINITION: {
                return "This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.";
            }
            case EVENTDEFINITION: {
                return "The EventDefinition resource provides a reusable description of when a particular event can occur.";
            }
            case MEASURE: {
                return "The Measure resource provides the definition of a quality measure.";
            }
            case OPERATIONDEFINITION: {
                return "A formal computable definition of an operation (on the RESTful interface) or a named query (using the search interaction).";
            }
            case PLANDEFINITION: {
                return "This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. The resource is general enough to support the description of a broad range of clinical artifacts such as clinical decision support rules, order sets and protocols.";
            }
            case QUESTIONNAIRE: {
                return "A structured set of questions intended to guide the collection of answers from end-users. Questionnaires provide detailed control over order, presentation, phraseology and grouping to allow coherent, consistent data collection.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVITYDEFINITION: {
                return "ActivityDefinition";
            }
            case EVENTDEFINITION: {
                return "EventDefinition";
            }
            case MEASURE: {
                return "Measure";
            }
            case OPERATIONDEFINITION: {
                return "OperationDefinition";
            }
            case PLANDEFINITION: {
                return "PlanDefinition";
            }
            case QUESTIONNAIRE: {
                return "Questionnaire";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

