/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.util.CoverageIgnore;
import org.apache.commons.lang3.Validate;

public class BearerTokenAuthInterceptor
implements IClientInterceptor {
    private String myToken;

    @CoverageIgnore
    public BearerTokenAuthInterceptor() {
    }

    public BearerTokenAuthInterceptor(String theToken) {
        Validate.notNull(theToken, "theToken must not be null", new Object[0]);
        this.myToken = theToken;
    }

    public String getToken() {
        return this.myToken;
    }

    @Override
    public void interceptRequest(IHttpRequest theRequest) {
        theRequest.addHeader("Authorization", "Bearer " + this.myToken);
    }

    @Override
    public void interceptResponse(IHttpResponse theResponse) {
    }

    public void setToken(String theToken) {
        Validate.notNull(theToken, "theToken must not be null", new Object[0]);
        this.myToken = theToken;
    }
}

