/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.library;

import java.util.List;
import javax.annotation.Nullable;

public final class PathlingContextConfiguration {
    @Nullable
    private final String fhirVersion;
    @Nullable
    private final Integer maxNestingLevel;
    @Nullable
    private final Boolean extensionsEnabled;
    @Nullable
    private final List<String> openTypesEnabled;
    @Nullable
    private final String terminologyServerUrl;
    @Nullable
    private final String tokenEndpoint;
    @Nullable
    private final String clientId;
    @Nullable
    private final String clientSecret;
    @Nullable
    private final String scope;
    @Nullable
    private final Integer tokenExpiryTolerance;

    PathlingContextConfiguration(@Nullable String fhirVersion, @Nullable Integer maxNestingLevel, @Nullable Boolean extensionsEnabled, @Nullable List<String> openTypesEnabled, @Nullable String terminologyServerUrl, @Nullable String tokenEndpoint, @Nullable String clientId, @Nullable String clientSecret, @Nullable String scope, @Nullable Integer tokenExpiryTolerance) {
        this.fhirVersion = fhirVersion;
        this.maxNestingLevel = maxNestingLevel;
        this.extensionsEnabled = extensionsEnabled;
        this.openTypesEnabled = openTypesEnabled;
        this.terminologyServerUrl = terminologyServerUrl;
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.tokenExpiryTolerance = tokenExpiryTolerance;
    }

    public static PathlingContextConfigurationBuilder builder() {
        return new PathlingContextConfigurationBuilder();
    }

    @Nullable
    public String getFhirVersion() {
        return this.fhirVersion;
    }

    @Nullable
    public Integer getMaxNestingLevel() {
        return this.maxNestingLevel;
    }

    @Nullable
    public Boolean getExtensionsEnabled() {
        return this.extensionsEnabled;
    }

    @Nullable
    public List<String> getOpenTypesEnabled() {
        return this.openTypesEnabled;
    }

    @Nullable
    public String getTerminologyServerUrl() {
        return this.terminologyServerUrl;
    }

    @Nullable
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public Integer getTokenExpiryTolerance() {
        return this.tokenExpiryTolerance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathlingContextConfiguration)) {
            return false;
        }
        PathlingContextConfiguration other = (PathlingContextConfiguration)o;
        Integer this$maxNestingLevel = this.getMaxNestingLevel();
        Integer other$maxNestingLevel = other.getMaxNestingLevel();
        if (this$maxNestingLevel == null ? other$maxNestingLevel != null : !((Object)this$maxNestingLevel).equals(other$maxNestingLevel)) {
            return false;
        }
        Boolean this$extensionsEnabled = this.getExtensionsEnabled();
        Boolean other$extensionsEnabled = other.getExtensionsEnabled();
        if (this$extensionsEnabled == null ? other$extensionsEnabled != null : !((Object)this$extensionsEnabled).equals(other$extensionsEnabled)) {
            return false;
        }
        Integer this$tokenExpiryTolerance = this.getTokenExpiryTolerance();
        Integer other$tokenExpiryTolerance = other.getTokenExpiryTolerance();
        if (this$tokenExpiryTolerance == null ? other$tokenExpiryTolerance != null : !((Object)this$tokenExpiryTolerance).equals(other$tokenExpiryTolerance)) {
            return false;
        }
        String this$fhirVersion = this.getFhirVersion();
        String other$fhirVersion = other.getFhirVersion();
        if (this$fhirVersion == null ? other$fhirVersion != null : !this$fhirVersion.equals(other$fhirVersion)) {
            return false;
        }
        List<String> this$openTypesEnabled = this.getOpenTypesEnabled();
        List<String> other$openTypesEnabled = other.getOpenTypesEnabled();
        if (this$openTypesEnabled == null ? other$openTypesEnabled != null : !((Object)this$openTypesEnabled).equals(other$openTypesEnabled)) {
            return false;
        }
        String this$terminologyServerUrl = this.getTerminologyServerUrl();
        String other$terminologyServerUrl = other.getTerminologyServerUrl();
        if (this$terminologyServerUrl == null ? other$terminologyServerUrl != null : !this$terminologyServerUrl.equals(other$terminologyServerUrl)) {
            return false;
        }
        String this$tokenEndpoint = this.getTokenEndpoint();
        String other$tokenEndpoint = other.getTokenEndpoint();
        if (this$tokenEndpoint == null ? other$tokenEndpoint != null : !this$tokenEndpoint.equals(other$tokenEndpoint)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxNestingLevel = this.getMaxNestingLevel();
        result = result * 59 + ($maxNestingLevel == null ? 43 : ((Object)$maxNestingLevel).hashCode());
        Boolean $extensionsEnabled = this.getExtensionsEnabled();
        result = result * 59 + ($extensionsEnabled == null ? 43 : ((Object)$extensionsEnabled).hashCode());
        Integer $tokenExpiryTolerance = this.getTokenExpiryTolerance();
        result = result * 59 + ($tokenExpiryTolerance == null ? 43 : ((Object)$tokenExpiryTolerance).hashCode());
        String $fhirVersion = this.getFhirVersion();
        result = result * 59 + ($fhirVersion == null ? 43 : $fhirVersion.hashCode());
        List<String> $openTypesEnabled = this.getOpenTypesEnabled();
        result = result * 59 + ($openTypesEnabled == null ? 43 : ((Object)$openTypesEnabled).hashCode());
        String $terminologyServerUrl = this.getTerminologyServerUrl();
        result = result * 59 + ($terminologyServerUrl == null ? 43 : $terminologyServerUrl.hashCode());
        String $tokenEndpoint = this.getTokenEndpoint();
        result = result * 59 + ($tokenEndpoint == null ? 43 : $tokenEndpoint.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    public String toString() {
        return "PathlingContextConfiguration(fhirVersion=" + this.getFhirVersion() + ", maxNestingLevel=" + this.getMaxNestingLevel() + ", extensionsEnabled=" + this.getExtensionsEnabled() + ", openTypesEnabled=" + this.getOpenTypesEnabled() + ", terminologyServerUrl=" + this.getTerminologyServerUrl() + ", tokenEndpoint=" + this.getTokenEndpoint() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", scope=" + this.getScope() + ", tokenExpiryTolerance=" + this.getTokenExpiryTolerance() + ")";
    }

    public static class PathlingContextConfigurationBuilder {
        private String fhirVersion;
        private Integer maxNestingLevel;
        private Boolean extensionsEnabled;
        private List<String> openTypesEnabled;
        private String terminologyServerUrl;
        private String tokenEndpoint;
        private String clientId;
        private String clientSecret;
        private String scope;
        private Integer tokenExpiryTolerance;

        PathlingContextConfigurationBuilder() {
        }

        public PathlingContextConfigurationBuilder fhirVersion(@Nullable String fhirVersion) {
            this.fhirVersion = fhirVersion;
            return this;
        }

        public PathlingContextConfigurationBuilder maxNestingLevel(@Nullable Integer maxNestingLevel) {
            this.maxNestingLevel = maxNestingLevel;
            return this;
        }

        public PathlingContextConfigurationBuilder extensionsEnabled(@Nullable Boolean extensionsEnabled) {
            this.extensionsEnabled = extensionsEnabled;
            return this;
        }

        public PathlingContextConfigurationBuilder openTypesEnabled(@Nullable List<String> openTypesEnabled) {
            this.openTypesEnabled = openTypesEnabled;
            return this;
        }

        public PathlingContextConfigurationBuilder terminologyServerUrl(@Nullable String terminologyServerUrl) {
            this.terminologyServerUrl = terminologyServerUrl;
            return this;
        }

        public PathlingContextConfigurationBuilder tokenEndpoint(@Nullable String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public PathlingContextConfigurationBuilder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        public PathlingContextConfigurationBuilder clientSecret(@Nullable String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public PathlingContextConfigurationBuilder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        public PathlingContextConfigurationBuilder tokenExpiryTolerance(@Nullable Integer tokenExpiryTolerance) {
            this.tokenExpiryTolerance = tokenExpiryTolerance;
            return this;
        }

        public PathlingContextConfiguration build() {
            return new PathlingContextConfiguration(this.fhirVersion, this.maxNestingLevel, this.extensionsEnabled, this.openTypesEnabled, this.terminologyServerUrl, this.tokenEndpoint, this.clientId, this.clientSecret, this.scope, this.tokenExpiryTolerance);
        }

        public String toString() {
            return "PathlingContextConfiguration.PathlingContextConfigurationBuilder(fhirVersion=" + this.fhirVersion + ", maxNestingLevel=" + this.maxNestingLevel + ", extensionsEnabled=" + this.extensionsEnabled + ", openTypesEnabled=" + this.openTypesEnabled + ", terminologyServerUrl=" + this.terminologyServerUrl + ", tokenEndpoint=" + this.tokenEndpoint + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scope=" + this.scope + ", tokenExpiryTolerance=" + this.tokenExpiryTolerance + ")";
        }
    }
}

