# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudmersive_convert_api_client.api_client import ApiClient


class EditPdfApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def edit_pdf_add_annotations(self, request, **kwargs):  # noqa: E501
        """Add one or more PDF annotations, comments in the PDF document  # noqa: E501

        Adds one or more annotations, comments to a PDF document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_add_annotations(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddPdfAnnotationRequest request: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_add_annotations_with_http_info(request, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_add_annotations_with_http_info(request, **kwargs)  # noqa: E501
            return data

    def edit_pdf_add_annotations_with_http_info(self, request, **kwargs):  # noqa: E501
        """Add one or more PDF annotations, comments in the PDF document  # noqa: E501

        Adds one or more annotations, comments to a PDF document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_add_annotations_with_http_info(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddPdfAnnotationRequest request: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_add_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `edit_pdf_add_annotations`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/annotations/add-item', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_convert_to_pdf_a(self, input_file, **kwargs):  # noqa: E501
        """Convert a PDF file to PDF/A  # noqa: E501

        Converts the input PDF file to a PDF/A-1b or PDF/A-2b standardized PDF.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_convert_to_pdf_a(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str conformance_level: Optional: Select the conformance level for PDF/A - specify '1b' for PDF/A-1b or specify '2b' for PDF/A-2b; default is PDF/A-1b
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_convert_to_pdf_a_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_convert_to_pdf_a_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_convert_to_pdf_a_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Convert a PDF file to PDF/A  # noqa: E501

        Converts the input PDF file to a PDF/A-1b or PDF/A-2b standardized PDF.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_convert_to_pdf_a_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str conformance_level: Optional: Select the conformance level for PDF/A - specify '1b' for PDF/A-1b or specify '2b' for PDF/A-2b; default is PDF/A-1b
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'conformance_level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_convert_to_pdf_a" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_convert_to_pdf_a`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'conformance_level' in params:
            header_params['conformanceLevel'] = params['conformance_level']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/optimize/pdf-a', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_decrypt(self, password, input_file, **kwargs):  # noqa: E501
        """Decrypt and password-protect a PDF  # noqa: E501

        Decrypt a PDF document with a password.  Decrypted PDF will no longer require a password to open.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_decrypt(password, input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str password: Valid password for the PDF file (required)
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_decrypt_with_http_info(password, input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_decrypt_with_http_info(password, input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_decrypt_with_http_info(self, password, input_file, **kwargs):  # noqa: E501
        """Decrypt and password-protect a PDF  # noqa: E501

        Decrypt a PDF document with a password.  Decrypted PDF will no longer require a password to open.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_decrypt_with_http_info(password, input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str password: Valid password for the PDF file (required)
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['password', 'input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_decrypt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `edit_pdf_decrypt`")  # noqa: E501
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_decrypt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'password' in params:
            header_params['password'] = params['password']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/decrypt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_delete_pages(self, input_file, page_start, page_end, **kwargs):  # noqa: E501
        """Remove, delete pages from a PDF document  # noqa: E501

        Remove one or more pages from a PDF document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_delete_pages(input_file, page_start, page_end, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param int page_start: Page number (1 based) to start deleting pages from (inclusive). (required)
        :param int page_end: Page number (1 based) to stop deleting pages from (inclusive). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_delete_pages_with_http_info(input_file, page_start, page_end, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_delete_pages_with_http_info(input_file, page_start, page_end, **kwargs)  # noqa: E501
            return data

    def edit_pdf_delete_pages_with_http_info(self, input_file, page_start, page_end, **kwargs):  # noqa: E501
        """Remove, delete pages from a PDF document  # noqa: E501

        Remove one or more pages from a PDF document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_delete_pages_with_http_info(input_file, page_start, page_end, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param int page_start: Page number (1 based) to start deleting pages from (inclusive). (required)
        :param int page_end: Page number (1 based) to stop deleting pages from (inclusive). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'page_start', 'page_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_delete_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_delete_pages`")  # noqa: E501
        # verify the required parameter 'page_start' is set
        if ('page_start' not in params or
                params['page_start'] is None):
            raise ValueError("Missing the required parameter `page_start` when calling `edit_pdf_delete_pages`")  # noqa: E501
        # verify the required parameter 'page_end' is set
        if ('page_end' not in params or
                params['page_end'] is None):
            raise ValueError("Missing the required parameter `page_end` when calling `edit_pdf_delete_pages`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'page_start' in params:
            header_params['pageStart'] = params['page_start']  # noqa: E501
        if 'page_end' in params:
            header_params['pageEnd'] = params['page_end']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/pages/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_encrypt(self, input_file, **kwargs):  # noqa: E501
        """Encrypt and password-protect a PDF  # noqa: E501

        Encrypt a PDF document with a password.  Set an owner password to control owner (editor/creator) permissions, and set a user (reader) password to control the viewer of the PDF.  Set the password fields null to omit the given password.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_encrypt(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str user_password: Password of a user (reader) of the PDF file
        :param str owner_password: Password of a owner (creator/editor) of the PDF file
        :param str encryption_key_length: Possible values are \"128\" (128-bit RC4 encryption) and \"256\" (256-bit AES encryption).  Default is 256.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_encrypt_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_encrypt_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_encrypt_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Encrypt and password-protect a PDF  # noqa: E501

        Encrypt a PDF document with a password.  Set an owner password to control owner (editor/creator) permissions, and set a user (reader) password to control the viewer of the PDF.  Set the password fields null to omit the given password.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_encrypt_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str user_password: Password of a user (reader) of the PDF file
        :param str owner_password: Password of a owner (creator/editor) of the PDF file
        :param str encryption_key_length: Possible values are \"128\" (128-bit RC4 encryption) and \"256\" (256-bit AES encryption).  Default is 256.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'user_password', 'owner_password', 'encryption_key_length']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_encrypt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_encrypt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'user_password' in params:
            header_params['userPassword'] = params['user_password']  # noqa: E501
        if 'owner_password' in params:
            header_params['ownerPassword'] = params['owner_password']  # noqa: E501
        if 'encryption_key_length' in params:
            header_params['encryptionKeyLength'] = params['encryption_key_length']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/encrypt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_get_annotations(self, input_file, **kwargs):  # noqa: E501
        """Get PDF annotations, including comments in the document  # noqa: E501

        Enumerates the annotations, including comments and notes, in a PDF document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_get_annotations(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetPdfAnnotationsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_get_annotations_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_get_annotations_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_get_annotations_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Get PDF annotations, including comments in the document  # noqa: E501

        Enumerates the annotations, including comments and notes, in a PDF document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_get_annotations_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetPdfAnnotationsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_get_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_get_annotations`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/annotations/list', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetPdfAnnotationsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_get_form_fields(self, input_file, **kwargs):  # noqa: E501
        """Gets PDF Form fields and values  # noqa: E501

        Encrypt a PDF document with a password.  Set an owner password to control owner (editor/creator) permissions, and set a user (reader) password to control the viewer of the PDF.  Set the password fields null to omit the given password.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_get_form_fields(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: PdfFormFields
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_get_form_fields_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_get_form_fields_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_get_form_fields_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Gets PDF Form fields and values  # noqa: E501

        Encrypt a PDF document with a password.  Set an owner password to control owner (editor/creator) permissions, and set a user (reader) password to control the viewer of the PDF.  Set the password fields null to omit the given password.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_get_form_fields_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: PdfFormFields
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_get_form_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_get_form_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/form/get-fields', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PdfFormFields',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_get_metadata(self, input_file, **kwargs):  # noqa: E501
        """Get PDF document metadata  # noqa: E501

        Returns the metadata from the PDF document, including Title, Author, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_get_metadata(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: PdfMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_get_metadata_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_get_metadata_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_get_metadata_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Get PDF document metadata  # noqa: E501

        Returns the metadata from the PDF document, including Title, Author, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_get_metadata_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: PdfMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_get_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_get_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/get-metadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PdfMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_get_pdf_text_by_pages(self, input_file, **kwargs):  # noqa: E501
        """Get text in a PDF document by page  # noqa: E501

        Gets the text in a PDF by page  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_get_pdf_text_by_pages(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str text_formatting_mode: Optional; specify how whitespace should be handled when converting the document to text.  Possible values are 'preserveWhitespace' which will attempt to preserve whitespace in the document and relative positioning of text within the document, and 'minimizeWhitespace' which will not insert additional spaces into the document in most cases.  Default is 'preserveWhitespace'.
        :return: PdfTextByPageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_get_pdf_text_by_pages_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_get_pdf_text_by_pages_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_get_pdf_text_by_pages_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Get text in a PDF document by page  # noqa: E501

        Gets the text in a PDF by page  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_get_pdf_text_by_pages_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str text_formatting_mode: Optional; specify how whitespace should be handled when converting the document to text.  Possible values are 'preserveWhitespace' which will attempt to preserve whitespace in the document and relative positioning of text within the document, and 'minimizeWhitespace' which will not insert additional spaces into the document in most cases.  Default is 'preserveWhitespace'.
        :return: PdfTextByPageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'text_formatting_mode']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_get_pdf_text_by_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_get_pdf_text_by_pages`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'text_formatting_mode' in params:
            header_params['textFormattingMode'] = params['text_formatting_mode']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/pages/get-text', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PdfTextByPageResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_insert_pages(self, source_file, destination_file, page_start_source, page_end_source, page_insert_before_desitnation, **kwargs):  # noqa: E501
        """Insert, copy pages from one PDF document into another  # noqa: E501

        Copy one or more pages from one PDF document (source document) and insert them into a second PDF document (destination document).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_insert_pages(source_file, destination_file, page_start_source, page_end_source, page_insert_before_desitnation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file source_file: Source PDF file to copy pages from. (required)
        :param file destination_file: Destination PDF file to copy pages into. (required)
        :param int page_start_source: Page number (1 based) to start copying pages from (inclusive) in the Source file. (required)
        :param int page_end_source: Page number (1 based) to stop copying pages pages from (inclusive) in the Source file. (required)
        :param int page_insert_before_desitnation: Page number (1 based) to insert the pages before in the Destination file. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_insert_pages_with_http_info(source_file, destination_file, page_start_source, page_end_source, page_insert_before_desitnation, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_insert_pages_with_http_info(source_file, destination_file, page_start_source, page_end_source, page_insert_before_desitnation, **kwargs)  # noqa: E501
            return data

    def edit_pdf_insert_pages_with_http_info(self, source_file, destination_file, page_start_source, page_end_source, page_insert_before_desitnation, **kwargs):  # noqa: E501
        """Insert, copy pages from one PDF document into another  # noqa: E501

        Copy one or more pages from one PDF document (source document) and insert them into a second PDF document (destination document).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_insert_pages_with_http_info(source_file, destination_file, page_start_source, page_end_source, page_insert_before_desitnation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file source_file: Source PDF file to copy pages from. (required)
        :param file destination_file: Destination PDF file to copy pages into. (required)
        :param int page_start_source: Page number (1 based) to start copying pages from (inclusive) in the Source file. (required)
        :param int page_end_source: Page number (1 based) to stop copying pages pages from (inclusive) in the Source file. (required)
        :param int page_insert_before_desitnation: Page number (1 based) to insert the pages before in the Destination file. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['source_file', 'destination_file', 'page_start_source', 'page_end_source', 'page_insert_before_desitnation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_insert_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'source_file' is set
        if ('source_file' not in params or
                params['source_file'] is None):
            raise ValueError("Missing the required parameter `source_file` when calling `edit_pdf_insert_pages`")  # noqa: E501
        # verify the required parameter 'destination_file' is set
        if ('destination_file' not in params or
                params['destination_file'] is None):
            raise ValueError("Missing the required parameter `destination_file` when calling `edit_pdf_insert_pages`")  # noqa: E501
        # verify the required parameter 'page_start_source' is set
        if ('page_start_source' not in params or
                params['page_start_source'] is None):
            raise ValueError("Missing the required parameter `page_start_source` when calling `edit_pdf_insert_pages`")  # noqa: E501
        # verify the required parameter 'page_end_source' is set
        if ('page_end_source' not in params or
                params['page_end_source'] is None):
            raise ValueError("Missing the required parameter `page_end_source` when calling `edit_pdf_insert_pages`")  # noqa: E501
        # verify the required parameter 'page_insert_before_desitnation' is set
        if ('page_insert_before_desitnation' not in params or
                params['page_insert_before_desitnation'] is None):
            raise ValueError("Missing the required parameter `page_insert_before_desitnation` when calling `edit_pdf_insert_pages`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'page_start_source' in params:
            header_params['pageStartSource'] = params['page_start_source']  # noqa: E501
        if 'page_end_source' in params:
            header_params['pageEndSource'] = params['page_end_source']  # noqa: E501
        if 'page_insert_before_desitnation' in params:
            header_params['pageInsertBeforeDesitnation'] = params['page_insert_before_desitnation']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'source_file' in params:
            local_var_files['sourceFile'] = params['source_file']  # noqa: E501
        if 'destination_file' in params:
            local_var_files['destinationFile'] = params['destination_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/pages/insert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_linearize(self, input_file, **kwargs):  # noqa: E501
        """Linearize and optimize a PDF for streaming download  # noqa: E501

        Linearizes the content of a PDF to optimize it for streaming download, particularly over web streaming.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_linearize(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_linearize_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_linearize_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_linearize_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Linearize and optimize a PDF for streaming download  # noqa: E501

        Linearizes the content of a PDF to optimize it for streaming download, particularly over web streaming.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_linearize_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_linearize" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_linearize`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/optimize/linearize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_rasterize(self, input_file, **kwargs):  # noqa: E501
        """Rasterize a PDF to an image-based PDF  # noqa: E501

        Rasterize a PDF into an image-based PDF.  The output is a PDF where each page is comprised of a high-resolution image, with all text, figures and other components removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_rasterize(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_rasterize_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_rasterize_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_rasterize_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Rasterize a PDF to an image-based PDF  # noqa: E501

        Rasterize a PDF into an image-based PDF.  The output is a PDF where each page is comprised of a high-resolution image, with all text, figures and other components removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_rasterize_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_rasterize" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_rasterize`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/rasterize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_reduce_file_size(self, input_file, **kwargs):  # noqa: E501
        """Reduce the file size and optimize a PDF  # noqa: E501

        Reduces the file size and optimizes the content of a PDF to minimize its file size.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_reduce_file_size(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param float quality: Quality level for the images in the PDF, ranging from 0.0 (low quality) to 1.0 (high quality); default is 0.3
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_reduce_file_size_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_reduce_file_size_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_reduce_file_size_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Reduce the file size and optimize a PDF  # noqa: E501

        Reduces the file size and optimizes the content of a PDF to minimize its file size.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_reduce_file_size_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param float quality: Quality level for the images in the PDF, ranging from 0.0 (low quality) to 1.0 (high quality); default is 0.3
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'quality']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_reduce_file_size" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_reduce_file_size`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'quality' in params:
            header_params['quality'] = params['quality']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/optimize/reduce-file-size', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_remove_all_annotations(self, input_file, **kwargs):  # noqa: E501
        """Remove all PDF annotations, including comments in the document  # noqa: E501

        Removes all of the annotations, including comments and notes, in a PDF document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_remove_all_annotations(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_remove_all_annotations_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_remove_all_annotations_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_remove_all_annotations_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Remove all PDF annotations, including comments in the document  # noqa: E501

        Removes all of the annotations, including comments and notes, in a PDF document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_remove_all_annotations_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_remove_all_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_remove_all_annotations`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/annotations/remove-all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_remove_annotation_item(self, input_file, annotation_index, **kwargs):  # noqa: E501
        """Remove a specific PDF annotation, comment in the document  # noqa: E501

        Removes a specific annotation in a PDF document, using the AnnotationIndex.  To enumerate AnnotationIndex for all of the annotations in the PDF document, use the /edit/pdf/annotations/list API.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_remove_annotation_item(input_file, annotation_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param int annotation_index: The 0-based index of the annotation in the document (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_remove_annotation_item_with_http_info(input_file, annotation_index, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_remove_annotation_item_with_http_info(input_file, annotation_index, **kwargs)  # noqa: E501
            return data

    def edit_pdf_remove_annotation_item_with_http_info(self, input_file, annotation_index, **kwargs):  # noqa: E501
        """Remove a specific PDF annotation, comment in the document  # noqa: E501

        Removes a specific annotation in a PDF document, using the AnnotationIndex.  To enumerate AnnotationIndex for all of the annotations in the PDF document, use the /edit/pdf/annotations/list API.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_remove_annotation_item_with_http_info(input_file, annotation_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param int annotation_index: The 0-based index of the annotation in the document (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'annotation_index']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_remove_annotation_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_remove_annotation_item`")  # noqa: E501
        # verify the required parameter 'annotation_index' is set
        if ('annotation_index' not in params or
                params['annotation_index'] is None):
            raise ValueError("Missing the required parameter `annotation_index` when calling `edit_pdf_remove_annotation_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'annotation_index' in params:
            header_params['annotationIndex'] = params['annotation_index']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/annotations/remove-item', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_resize(self, input_file, paper_size, **kwargs):  # noqa: E501
        """Change PDF Document's Paper Size  # noqa: E501

        Resizes a PDF document's paper size.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_resize(input_file, paper_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str paper_size: The desired paper size for the resized PDF document. Size ranges from A7 (smallest) to A0 (largest). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_resize_with_http_info(input_file, paper_size, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_resize_with_http_info(input_file, paper_size, **kwargs)  # noqa: E501
            return data

    def edit_pdf_resize_with_http_info(self, input_file, paper_size, **kwargs):  # noqa: E501
        """Change PDF Document's Paper Size  # noqa: E501

        Resizes a PDF document's paper size.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_resize_with_http_info(input_file, paper_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str paper_size: The desired paper size for the resized PDF document. Size ranges from A7 (smallest) to A0 (largest). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'paper_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_resize" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_resize`")  # noqa: E501
        # verify the required parameter 'paper_size' is set
        if ('paper_size' not in params or
                params['paper_size'] is None):
            raise ValueError("Missing the required parameter `paper_size` when calling `edit_pdf_resize`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'paper_size' in params:
            header_params['paperSize'] = params['paper_size']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/resize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_rotate_all_pages(self, input_file, rotation_angle, **kwargs):  # noqa: E501
        """Rotate all pages in a PDF document  # noqa: E501

        Rotate all of the pages in a PDF document by a multiple of 90 degrees  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_rotate_all_pages(input_file, rotation_angle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param int rotation_angle: The angle to rotate the page in degrees, must be a multiple of 90 degrees, e.g. 90, 180, 270, or -90, -180, -270, etc. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_rotate_all_pages_with_http_info(input_file, rotation_angle, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_rotate_all_pages_with_http_info(input_file, rotation_angle, **kwargs)  # noqa: E501
            return data

    def edit_pdf_rotate_all_pages_with_http_info(self, input_file, rotation_angle, **kwargs):  # noqa: E501
        """Rotate all pages in a PDF document  # noqa: E501

        Rotate all of the pages in a PDF document by a multiple of 90 degrees  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_rotate_all_pages_with_http_info(input_file, rotation_angle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param int rotation_angle: The angle to rotate the page in degrees, must be a multiple of 90 degrees, e.g. 90, 180, 270, or -90, -180, -270, etc. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'rotation_angle']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_rotate_all_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_rotate_all_pages`")  # noqa: E501
        # verify the required parameter 'rotation_angle' is set
        if ('rotation_angle' not in params or
                params['rotation_angle'] is None):
            raise ValueError("Missing the required parameter `rotation_angle` when calling `edit_pdf_rotate_all_pages`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'rotation_angle' in params:
            header_params['rotationAngle'] = params['rotation_angle']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/pages/rotate/all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_rotate_page_range(self, input_file, rotation_angle, page_start, page_end, **kwargs):  # noqa: E501
        """Rotate a range, subset of pages in a PDF document  # noqa: E501

        Rotate a range of specific pages in a PDF document by a multiple of 90 degrees  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_rotate_page_range(input_file, rotation_angle, page_start, page_end, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param int rotation_angle: The angle to rotate the page in degrees, must be a multiple of 90 degrees, e.g. 90, 180, 270, or -90, -180, -270, etc. (required)
        :param int page_start: Page number (1 based) to start rotating pages from (inclusive). (required)
        :param int page_end: Page number (1 based) to stop rotating pages from (inclusive). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_rotate_page_range_with_http_info(input_file, rotation_angle, page_start, page_end, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_rotate_page_range_with_http_info(input_file, rotation_angle, page_start, page_end, **kwargs)  # noqa: E501
            return data

    def edit_pdf_rotate_page_range_with_http_info(self, input_file, rotation_angle, page_start, page_end, **kwargs):  # noqa: E501
        """Rotate a range, subset of pages in a PDF document  # noqa: E501

        Rotate a range of specific pages in a PDF document by a multiple of 90 degrees  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_rotate_page_range_with_http_info(input_file, rotation_angle, page_start, page_end, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param int rotation_angle: The angle to rotate the page in degrees, must be a multiple of 90 degrees, e.g. 90, 180, 270, or -90, -180, -270, etc. (required)
        :param int page_start: Page number (1 based) to start rotating pages from (inclusive). (required)
        :param int page_end: Page number (1 based) to stop rotating pages from (inclusive). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'rotation_angle', 'page_start', 'page_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_rotate_page_range" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_rotate_page_range`")  # noqa: E501
        # verify the required parameter 'rotation_angle' is set
        if ('rotation_angle' not in params or
                params['rotation_angle'] is None):
            raise ValueError("Missing the required parameter `rotation_angle` when calling `edit_pdf_rotate_page_range`")  # noqa: E501
        # verify the required parameter 'page_start' is set
        if ('page_start' not in params or
                params['page_start'] is None):
            raise ValueError("Missing the required parameter `page_start` when calling `edit_pdf_rotate_page_range`")  # noqa: E501
        # verify the required parameter 'page_end' is set
        if ('page_end' not in params or
                params['page_end'] is None):
            raise ValueError("Missing the required parameter `page_end` when calling `edit_pdf_rotate_page_range`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'rotation_angle' in params:
            header_params['rotationAngle'] = params['rotation_angle']  # noqa: E501
        if 'page_start' in params:
            header_params['pageStart'] = params['page_start']  # noqa: E501
        if 'page_end' in params:
            header_params['pageEnd'] = params['page_end']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/pages/rotate/page-range', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_set_form_fields(self, field_values, **kwargs):  # noqa: E501
        """Sets ands fills PDF Form field values  # noqa: E501

        Fill in the form fields in a PDF form with specific values.  Use form/get-fields to enumerate the available fields and their data types in an input form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_set_form_fields(field_values, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetPdfFormFieldsRequest field_values: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_set_form_fields_with_http_info(field_values, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_set_form_fields_with_http_info(field_values, **kwargs)  # noqa: E501
            return data

    def edit_pdf_set_form_fields_with_http_info(self, field_values, **kwargs):  # noqa: E501
        """Sets ands fills PDF Form field values  # noqa: E501

        Fill in the form fields in a PDF form with specific values.  Use form/get-fields to enumerate the available fields and their data types in an input form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_set_form_fields_with_http_info(field_values, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetPdfFormFieldsRequest field_values: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['field_values']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_set_form_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'field_values' is set
        if ('field_values' not in params or
                params['field_values'] is None):
            raise ValueError("Missing the required parameter `field_values` when calling `edit_pdf_set_form_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'field_values' in params:
            body_params = params['field_values']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/form/set-fields', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_set_metadata(self, request, **kwargs):  # noqa: E501
        """Sets PDF document metadata  # noqa: E501

        Sets (writes) metadata into the input PDF document, including Title, Author, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_set_metadata(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetPdfMetadataRequest request: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_set_metadata_with_http_info(request, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_set_metadata_with_http_info(request, **kwargs)  # noqa: E501
            return data

    def edit_pdf_set_metadata_with_http_info(self, request, **kwargs):  # noqa: E501
        """Sets PDF document metadata  # noqa: E501

        Sets (writes) metadata into the input PDF document, including Title, Author, etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_set_metadata_with_http_info(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetPdfMetadataRequest request: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_set_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `edit_pdf_set_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/set-metadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_set_permissions(self, owner_password, user_password, input_file, **kwargs):  # noqa: E501
        """Encrypt, password-protect and set restricted permissions on a PDF  # noqa: E501

        Encrypt a PDF document with a password, and set permissions on the PDF.  Set an owner password to control owner (editor/creator) permissions [required], and set a user (reader) password to control the viewer of the PDF [optional].  Set the reader password to null to omit the password.  Restrict or allow printing, copying content, document assembly, editing (read-only), form filling, modification of annotations, and degraded printing through document Digital Rights Management (DRM).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_set_permissions(owner_password, user_password, input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner_password: Password of a owner (creator/editor) of the PDF file (required) (required)
        :param str user_password: Password of a user (reader) of the PDF file (optional) (required)
        :param file input_file: Input file to perform the operation on. (required)
        :param str encryption_key_length: Possible values are \"128\" (128-bit RC4 encryption) and \"256\" (256-bit AES encryption).  Default is 256.
        :param bool allow_printing: Set to false to disable printing through DRM.  Default is true.
        :param bool allow_document_assembly: Set to false to disable document assembly through DRM.  Default is true.
        :param bool allow_content_extraction: Set to false to disable copying/extracting content out of the PDF through DRM.  Default is true.
        :param bool allow_form_filling: Set to false to disable filling out form fields in the PDF through DRM.  Default is true.
        :param bool allow_editing: Set to false to disable editing in the PDF through DRM (making the PDF read-only).  Default is true.
        :param bool allow_annotations: Set to false to disable annotations and editing of annotations in the PDF through DRM.  Default is true.
        :param bool allow_degraded_printing: Set to false to disable degraded printing of the PDF through DRM.  Default is true.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_set_permissions_with_http_info(owner_password, user_password, input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_set_permissions_with_http_info(owner_password, user_password, input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_set_permissions_with_http_info(self, owner_password, user_password, input_file, **kwargs):  # noqa: E501
        """Encrypt, password-protect and set restricted permissions on a PDF  # noqa: E501

        Encrypt a PDF document with a password, and set permissions on the PDF.  Set an owner password to control owner (editor/creator) permissions [required], and set a user (reader) password to control the viewer of the PDF [optional].  Set the reader password to null to omit the password.  Restrict or allow printing, copying content, document assembly, editing (read-only), form filling, modification of annotations, and degraded printing through document Digital Rights Management (DRM).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_set_permissions_with_http_info(owner_password, user_password, input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner_password: Password of a owner (creator/editor) of the PDF file (required) (required)
        :param str user_password: Password of a user (reader) of the PDF file (optional) (required)
        :param file input_file: Input file to perform the operation on. (required)
        :param str encryption_key_length: Possible values are \"128\" (128-bit RC4 encryption) and \"256\" (256-bit AES encryption).  Default is 256.
        :param bool allow_printing: Set to false to disable printing through DRM.  Default is true.
        :param bool allow_document_assembly: Set to false to disable document assembly through DRM.  Default is true.
        :param bool allow_content_extraction: Set to false to disable copying/extracting content out of the PDF through DRM.  Default is true.
        :param bool allow_form_filling: Set to false to disable filling out form fields in the PDF through DRM.  Default is true.
        :param bool allow_editing: Set to false to disable editing in the PDF through DRM (making the PDF read-only).  Default is true.
        :param bool allow_annotations: Set to false to disable annotations and editing of annotations in the PDF through DRM.  Default is true.
        :param bool allow_degraded_printing: Set to false to disable degraded printing of the PDF through DRM.  Default is true.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner_password', 'user_password', 'input_file', 'encryption_key_length', 'allow_printing', 'allow_document_assembly', 'allow_content_extraction', 'allow_form_filling', 'allow_editing', 'allow_annotations', 'allow_degraded_printing']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_set_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner_password' is set
        if ('owner_password' not in params or
                params['owner_password'] is None):
            raise ValueError("Missing the required parameter `owner_password` when calling `edit_pdf_set_permissions`")  # noqa: E501
        # verify the required parameter 'user_password' is set
        if ('user_password' not in params or
                params['user_password'] is None):
            raise ValueError("Missing the required parameter `user_password` when calling `edit_pdf_set_permissions`")  # noqa: E501
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_set_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'owner_password' in params:
            header_params['ownerPassword'] = params['owner_password']  # noqa: E501
        if 'user_password' in params:
            header_params['userPassword'] = params['user_password']  # noqa: E501
        if 'encryption_key_length' in params:
            header_params['encryptionKeyLength'] = params['encryption_key_length']  # noqa: E501
        if 'allow_printing' in params:
            header_params['allowPrinting'] = params['allow_printing']  # noqa: E501
        if 'allow_document_assembly' in params:
            header_params['allowDocumentAssembly'] = params['allow_document_assembly']  # noqa: E501
        if 'allow_content_extraction' in params:
            header_params['allowContentExtraction'] = params['allow_content_extraction']  # noqa: E501
        if 'allow_form_filling' in params:
            header_params['allowFormFilling'] = params['allow_form_filling']  # noqa: E501
        if 'allow_editing' in params:
            header_params['allowEditing'] = params['allow_editing']  # noqa: E501
        if 'allow_annotations' in params:
            header_params['allowAnnotations'] = params['allow_annotations']  # noqa: E501
        if 'allow_degraded_printing' in params:
            header_params['allowDegradedPrinting'] = params['allow_degraded_printing']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/encrypt/set-permissions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_pdf_watermark_text(self, watermark_text, input_file, **kwargs):  # noqa: E501
        """Add a text watermark to a PDF  # noqa: E501

        Adds a text watermark to a PDF  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_watermark_text(watermark_text, input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str watermark_text: Watermark text to add to the PDF (required) (required)
        :param file input_file: Input file to perform the operation on. (required)
        :param str font_name: Font Family Name for the watermark text; default is Times New Roman
        :param float font_size: Font Size in points of the text; default is 150
        :param str font_color: Font color in hexadecimal or HTML color name; default is Red
        :param float font_transparency: Font transparency between 0.0 (completely transparent) to 1.0 (fully opaque); default is 0.5
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_pdf_watermark_text_with_http_info(watermark_text, input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_pdf_watermark_text_with_http_info(watermark_text, input_file, **kwargs)  # noqa: E501
            return data

    def edit_pdf_watermark_text_with_http_info(self, watermark_text, input_file, **kwargs):  # noqa: E501
        """Add a text watermark to a PDF  # noqa: E501

        Adds a text watermark to a PDF  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_pdf_watermark_text_with_http_info(watermark_text, input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str watermark_text: Watermark text to add to the PDF (required) (required)
        :param file input_file: Input file to perform the operation on. (required)
        :param str font_name: Font Family Name for the watermark text; default is Times New Roman
        :param float font_size: Font Size in points of the text; default is 150
        :param str font_color: Font color in hexadecimal or HTML color name; default is Red
        :param float font_transparency: Font transparency between 0.0 (completely transparent) to 1.0 (fully opaque); default is 0.5
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['watermark_text', 'input_file', 'font_name', 'font_size', 'font_color', 'font_transparency']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_pdf_watermark_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'watermark_text' is set
        if ('watermark_text' not in params or
                params['watermark_text'] is None):
            raise ValueError("Missing the required parameter `watermark_text` when calling `edit_pdf_watermark_text`")  # noqa: E501
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_pdf_watermark_text`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'watermark_text' in params:
            header_params['watermarkText'] = params['watermark_text']  # noqa: E501
        if 'font_name' in params:
            header_params['fontName'] = params['font_name']  # noqa: E501
        if 'font_size' in params:
            header_params['fontSize'] = params['font_size']  # noqa: E501
        if 'font_color' in params:
            header_params['fontColor'] = params['font_color']  # noqa: E501
        if 'font_transparency' in params:
            header_params['fontTransparency'] = params['font_transparency']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pdf/watermark/text', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
