# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudmersive_convert_api_client.api_client import ApiClient


class EditDocumentApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def edit_document_begin_editing(self, input_file, **kwargs):  # noqa: E501
        """Begin editing a document  # noqa: E501

        Uploads a document to Cloudmersive to begin a series of one or more editing operations.  To edit a document, first call Begin Editing on the document.  Then perform operations on the document using the secure URL returned from BeginEditing, such as Word DOCX Delete Pages and Insert Table.  Finally, perform finish editing on the URL to return the resulting edited document.  The editing URL is temporary and only stored in-memory cache, and will automatically expire from the cache after 30 minutes, and cannot be directly accessed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_begin_editing(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_begin_editing_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_begin_editing_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_document_begin_editing_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Begin editing a document  # noqa: E501

        Uploads a document to Cloudmersive to begin a series of one or more editing operations.  To edit a document, first call Begin Editing on the document.  Then perform operations on the document using the secure URL returned from BeginEditing, such as Word DOCX Delete Pages and Insert Table.  Finally, perform finish editing on the URL to return the resulting edited document.  The editing URL is temporary and only stored in-memory cache, and will automatically expire from the cache after 30 minutes, and cannot be directly accessed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_begin_editing_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_begin_editing" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_document_begin_editing`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/begin-editing', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_accept_all_track_changes(self, input_file, **kwargs):  # noqa: E501
        """Accept all tracked changes, revisions in a Word DOCX document  # noqa: E501

        Accepts all tracked changes and revisions in a Word DOCX document.  This will accept all pending changes in the document when tracked changes is turned on.  Track changes will remain on (if it is on) after this oepration is completed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_accept_all_track_changes(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_accept_all_track_changes_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_accept_all_track_changes_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_accept_all_track_changes_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Accept all tracked changes, revisions in a Word DOCX document  # noqa: E501

        Accepts all tracked changes and revisions in a Word DOCX document.  This will accept all pending changes in the document when tracked changes is turned on.  Track changes will remain on (if it is on) after this oepration is completed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_accept_all_track_changes_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_accept_all_track_changes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_document_docx_accept_all_track_changes`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/track-changes/accept-all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_body(self, req_config, **kwargs):  # noqa: E501
        """Get body from a Word DOCX document  # noqa: E501

        Returns the body defined in the Word Document (DOCX) format file; this is the main content part of a DOCX document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_body(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxBodyRequest req_config: Document input request (required)
        :return: GetDocxBodyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_body_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_body_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_body_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get body from a Word DOCX document  # noqa: E501

        Returns the body defined in the Word Document (DOCX) format file; this is the main content part of a DOCX document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_body_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxBodyRequest req_config: Document input request (required)
        :return: GetDocxBodyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_body" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_body`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-body', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxBodyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_create_blank_document(self, input, **kwargs):  # noqa: E501
        """Create a blank Word DOCX document  # noqa: E501

        Returns a blank Word DOCX Document format file.  The file is blank, with no contents.  Use additional editing commands such as Insert Paragraph or Insert Table or Insert Image to populate the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_create_blank_document(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateBlankDocxRequest input: Document input request (required)
        :return: CreateBlankDocxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_create_blank_document_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_create_blank_document_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_create_blank_document_with_http_info(self, input, **kwargs):  # noqa: E501
        """Create a blank Word DOCX document  # noqa: E501

        Returns a blank Word DOCX Document format file.  The file is blank, with no contents.  Use additional editing commands such as Insert Paragraph or Insert Table or Insert Image to populate the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_create_blank_document_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateBlankDocxRequest input: Document input request (required)
        :return: CreateBlankDocxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_create_blank_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_docx_create_blank_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/create/blank', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateBlankDocxResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_delete_pages(self, req_config, **kwargs):  # noqa: E501
        """Delete, remove pages from a Word DOCX document  # noqa: E501

        Returns the edited Word Document in the Word Document (DOCX) format file with the specified pages removed  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_delete_pages(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoveDocxPagesRequest req_config: Document input request (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_delete_pages_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_delete_pages_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_delete_pages_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Delete, remove pages from a Word DOCX document  # noqa: E501

        Returns the edited Word Document in the Word Document (DOCX) format file with the specified pages removed  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_delete_pages_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoveDocxPagesRequest req_config: Document input request (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_delete_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_delete_pages`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/delete-pages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_delete_table_row(self, req_config, **kwargs):  # noqa: E501
        """Deletes a table row in an existing table in a Word DOCX document  # noqa: E501

        Deletes an existing table row in a Word DOCX Document and returns the result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_delete_table_row(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteDocxTableRowRequest req_config: Document input request (required)
        :return: DeleteDocxTableRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_delete_table_row_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_delete_table_row_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_delete_table_row_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Deletes a table row in an existing table in a Word DOCX document  # noqa: E501

        Deletes an existing table row in a Word DOCX Document and returns the result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_delete_table_row_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteDocxTableRowRequest req_config: Document input request (required)
        :return: DeleteDocxTableRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_delete_table_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_delete_table_row`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/delete-table-row', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteDocxTableRowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_delete_table_row_range(self, req_config, **kwargs):  # noqa: E501
        """Deletes a range of multiple table rows in an existing table in a Word DOCX document  # noqa: E501

        Deletes a range of 1 or more existing table rows in a Word DOCX Document and returns the result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_delete_table_row_range(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteDocxTableRowRangeRequest req_config: Document input request (required)
        :return: DeleteDocxTableRowRangeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_delete_table_row_range_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_delete_table_row_range_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_delete_table_row_range_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Deletes a range of multiple table rows in an existing table in a Word DOCX document  # noqa: E501

        Deletes a range of 1 or more existing table rows in a Word DOCX Document and returns the result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_delete_table_row_range_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteDocxTableRowRangeRequest req_config: Document input request (required)
        :return: DeleteDocxTableRowRangeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_delete_table_row_range" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_delete_table_row_range`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/delete-table-row/range', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteDocxTableRowRangeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_disable_track_changes(self, input_file, **kwargs):  # noqa: E501
        """Disable track changes, revisions in a Word DOCX document  # noqa: E501

        Diables tracking of changes and revisions in a Word DOCX document, and accepts any pending changes.  Users editing the document will no longer see changes tracked automatically.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_disable_track_changes(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_disable_track_changes_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_disable_track_changes_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_disable_track_changes_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Disable track changes, revisions in a Word DOCX document  # noqa: E501

        Diables tracking of changes and revisions in a Word DOCX document, and accepts any pending changes.  Users editing the document will no longer see changes tracked automatically.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_disable_track_changes_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_disable_track_changes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_document_docx_disable_track_changes`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/track-changes/disable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_enable_track_changes(self, input_file, **kwargs):  # noqa: E501
        """Enable track changes, revisions in a Word DOCX document  # noqa: E501

        Enables tracking of changes and revisions in a Word DOCX document.  Users editing the document will see changes tracked automatically, with edits highlighted, and the ability to accept or reject changes made to the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_enable_track_changes(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_enable_track_changes_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_enable_track_changes_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_enable_track_changes_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Enable track changes, revisions in a Word DOCX document  # noqa: E501

        Enables tracking of changes and revisions in a Word DOCX document.  Users editing the document will see changes tracked automatically, with edits highlighted, and the ability to accept or reject changes made to the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_enable_track_changes_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_enable_track_changes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_document_docx_enable_track_changes`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/track-changes/enable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_find_paragraph(self, req_config, **kwargs):  # noqa: E501
        """Find matching paragraphs in a Word DOCX document  # noqa: E501

        Returns the paragraphs defined in the Word Document (DOCX) format file that match the input criteria  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_find_paragraph(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FindDocxParagraphRequest req_config: Document input request (required)
        :return: FindDocxParagraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_find_paragraph_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_find_paragraph_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_find_paragraph_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Find matching paragraphs in a Word DOCX document  # noqa: E501

        Returns the paragraphs defined in the Word Document (DOCX) format file that match the input criteria  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_find_paragraph_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FindDocxParagraphRequest req_config: Document input request (required)
        :return: FindDocxParagraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_find_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_find_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/find/paragraph', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FindDocxParagraphResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_comments(self, req_config, **kwargs):  # noqa: E501
        """Get comments from a Word DOCX document as a flat list  # noqa: E501

        Returns the comments and review annotations stored in the Word Document (DOCX) format file as a flattened list (not as a hierarchy of comments and replies).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_comments(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxGetCommentsRequest req_config: Document input request (required)
        :return: GetDocxCommentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_comments_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_comments_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_comments_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get comments from a Word DOCX document as a flat list  # noqa: E501

        Returns the comments and review annotations stored in the Word Document (DOCX) format file as a flattened list (not as a hierarchy of comments and replies).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_comments_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxGetCommentsRequest req_config: Document input request (required)
        :return: GetDocxCommentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_get_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-comments/flat-list', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxCommentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_comments_hierarchical(self, req_config, **kwargs):  # noqa: E501
        """Get comments from a Word DOCX document hierarchically  # noqa: E501

        Returns the comments and review annotations stored in the Word Document (DOCX) format file hierarchically, where reply comments are nested as children under top-level comments in the results returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_comments_hierarchical(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxGetCommentsHierarchicalRequest req_config: Document input request (required)
        :return: GetDocxCommentsHierarchicalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_comments_hierarchical_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_comments_hierarchical_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_comments_hierarchical_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get comments from a Word DOCX document hierarchically  # noqa: E501

        Returns the comments and review annotations stored in the Word Document (DOCX) format file hierarchically, where reply comments are nested as children under top-level comments in the results returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_comments_hierarchical_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxGetCommentsHierarchicalRequest req_config: Document input request (required)
        :return: GetDocxCommentsHierarchicalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_comments_hierarchical" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_get_comments_hierarchical`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-comments/hierarchical', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxCommentsHierarchicalResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_headers_and_footers(self, req_config, **kwargs):  # noqa: E501
        """Get content of a footer from a Word DOCX document  # noqa: E501

        Returns the footer content from a Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_headers_and_footers(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxHeadersAndFootersRequest req_config: Document input request (required)
        :return: GetDocxHeadersAndFootersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_headers_and_footers_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_headers_and_footers_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_headers_and_footers_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get content of a footer from a Word DOCX document  # noqa: E501

        Returns the footer content from a Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_headers_and_footers_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxHeadersAndFootersRequest req_config: Document input request (required)
        :return: GetDocxHeadersAndFootersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_headers_and_footers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_get_headers_and_footers`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-headers-and-footers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxHeadersAndFootersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_images(self, req_config, **kwargs):  # noqa: E501
        """Get images from a Word DOCX document  # noqa: E501

        Returns the images defined in the Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_images(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxImagesRequest req_config: Document input request (required)
        :return: GetDocxImagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_images_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_images_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_images_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get images from a Word DOCX document  # noqa: E501

        Returns the images defined in the Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_images_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxImagesRequest req_config: Document input request (required)
        :return: GetDocxImagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_images" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_get_images`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-images', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxImagesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_macro_information(self, input_file, **kwargs):  # noqa: E501
        """Get macro information from a Word DOCX/DOCM document  # noqa: E501

        Returns information about the Macros (e.g. VBA) defined in the Word Document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_macro_information(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetMacrosResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_macro_information_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_macro_information_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_macro_information_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Get macro information from a Word DOCX/DOCM document  # noqa: E501

        Returns information about the Macros (e.g. VBA) defined in the Word Document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_macro_information_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetMacrosResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_macro_information" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_document_docx_get_macro_information`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-macros', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetMacrosResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_metadata_properties(self, input_file, **kwargs):  # noqa: E501
        """Get all metadata properties in Word DOCX document  # noqa: E501

        Returns all the metadata properties in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_metadata_properties(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetDocxMetadataPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_metadata_properties_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_metadata_properties_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_metadata_properties_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Get all metadata properties in Word DOCX document  # noqa: E501

        Returns all the metadata properties in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_metadata_properties_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetDocxMetadataPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_metadata_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_document_docx_get_metadata_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-metadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxMetadataPropertiesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_sections(self, req_config, **kwargs):  # noqa: E501
        """Get sections from a Word DOCX document  # noqa: E501

        Returns the sections defined in the Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_sections(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxSectionsRequest req_config: Document input request (required)
        :return: GetDocxSectionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_sections_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_sections_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_sections_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get sections from a Word DOCX document  # noqa: E501

        Returns the sections defined in the Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_sections_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxSectionsRequest req_config: Document input request (required)
        :return: GetDocxSectionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_get_sections`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-sections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxSectionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_styles(self, req_config, **kwargs):  # noqa: E501
        """Get styles from a Word DOCX document  # noqa: E501

        Returns the styles defined in the Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_styles(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxStylesRequest req_config: Document input request (required)
        :return: GetDocxStylesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_styles_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_styles_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_styles_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get styles from a Word DOCX document  # noqa: E501

        Returns the styles defined in the Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_styles_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxStylesRequest req_config: Document input request (required)
        :return: GetDocxStylesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_styles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_get_styles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-styles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxStylesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_table_by_index(self, req_config, **kwargs):  # noqa: E501
        """Get a specific table by index in a Word DOCX document  # noqa: E501

        Returns the specific table object by its 0-based index in an Office Word Document (DOCX)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_table_by_index(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxTableByIndexRequest req_config: Document input request (required)
        :return: GetDocxTableByIndexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_table_by_index_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_table_by_index_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_table_by_index_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get a specific table by index in a Word DOCX document  # noqa: E501

        Returns the specific table object by its 0-based index in an Office Word Document (DOCX)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_table_by_index_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxTableByIndexRequest req_config: Document input request (required)
        :return: GetDocxTableByIndexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_table_by_index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_get_table_by_index`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-table/by-index', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxTableByIndexResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_table_row(self, req_config, **kwargs):  # noqa: E501
        """Gets the contents of an existing table row in an existing table in a Word DOCX document  # noqa: E501

        Gets the contents of an existing table row in a Word DOCX Document and returns the result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_table_row(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxTableRowRequest req_config: Document input request (required)
        :return: GetDocxTableRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_table_row_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_table_row_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_table_row_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Gets the contents of an existing table row in an existing table in a Word DOCX document  # noqa: E501

        Gets the contents of an existing table row in a Word DOCX Document and returns the result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_table_row_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxTableRowRequest req_config: Document input request (required)
        :return: GetDocxTableRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_table_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_get_table_row`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-table-row', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxTableRowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_get_tables(self, req_config, **kwargs):  # noqa: E501
        """Get all tables in Word DOCX document  # noqa: E501

        Returns all the table objects in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_tables(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxTablesRequest req_config: Document input request (required)
        :return: GetDocxTablesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_get_tables_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_get_tables_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_get_tables_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get all tables in Word DOCX document  # noqa: E501

        Returns all the table objects in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_get_tables_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxTablesRequest req_config: Document input request (required)
        :return: GetDocxTablesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_get_tables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_get_tables`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-tables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxTablesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_insert_comment_on_paragraph(self, req_config, **kwargs):  # noqa: E501
        """Insert a new comment into a Word DOCX document attached to a paragraph  # noqa: E501

        Adds a new comment into a Word DOCX document attached to a paragraph and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_comment_on_paragraph(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxInsertCommentOnParagraphRequest req_config: Document input request (required)
        :return: InsertDocxCommentOnParagraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_insert_comment_on_paragraph_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_insert_comment_on_paragraph_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_insert_comment_on_paragraph_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Insert a new comment into a Word DOCX document attached to a paragraph  # noqa: E501

        Adds a new comment into a Word DOCX document attached to a paragraph and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_comment_on_paragraph_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxInsertCommentOnParagraphRequest req_config: Document input request (required)
        :return: InsertDocxCommentOnParagraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_insert_comment_on_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_insert_comment_on_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/insert-comment/on/paragraph', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InsertDocxCommentOnParagraphResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_insert_image(self, req_config, **kwargs):  # noqa: E501
        """Insert image into a Word DOCX document  # noqa: E501

        Set the footer in a Word Document (DOCX).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_image(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxInsertImageRequest req_config: Document input request (required)
        :return: DocxInsertImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_insert_image_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_insert_image_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_insert_image_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Insert image into a Word DOCX document  # noqa: E501

        Set the footer in a Word Document (DOCX).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_image_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxInsertImageRequest req_config: Document input request (required)
        :return: DocxInsertImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_insert_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_insert_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/insert-image', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocxInsertImageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_insert_paragraph(self, req_config, **kwargs):  # noqa: E501
        """Insert a new paragraph into a Word DOCX document  # noqa: E501

        Adds a new paragraph into a DOCX and returns the result.  You can insert at the beginning/end of a document, or before/after an existing object using its Path (location within the document).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_paragraph(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InsertDocxInsertParagraphRequest req_config: Document input request (required)
        :return: InsertDocxInsertParagraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_insert_paragraph_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_insert_paragraph_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_insert_paragraph_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Insert a new paragraph into a Word DOCX document  # noqa: E501

        Adds a new paragraph into a DOCX and returns the result.  You can insert at the beginning/end of a document, or before/after an existing object using its Path (location within the document).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_paragraph_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InsertDocxInsertParagraphRequest req_config: Document input request (required)
        :return: InsertDocxInsertParagraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_insert_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_insert_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/insert-paragraph', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InsertDocxInsertParagraphResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_insert_table(self, req_config, **kwargs):  # noqa: E501
        """Insert a new table into a Word DOCX document  # noqa: E501

        Adds a new table into a DOCX and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_table(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InsertDocxTablesRequest req_config: Document input request (required)
        :return: InsertDocxTablesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_insert_table_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_insert_table_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_insert_table_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Insert a new table into a Word DOCX document  # noqa: E501

        Adds a new table into a DOCX and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_table_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InsertDocxTablesRequest req_config: Document input request (required)
        :return: InsertDocxTablesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_insert_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_insert_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/insert-table', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InsertDocxTablesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_insert_table_row(self, req_config, **kwargs):  # noqa: E501
        """Insert a new row into an existing table in a Word DOCX document  # noqa: E501

        Adds a new table row into a DOCX Document and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_table_row(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InsertDocxTableRowRequest req_config: Document input request (required)
        :return: InsertDocxTableRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_insert_table_row_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_insert_table_row_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_insert_table_row_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Insert a new row into an existing table in a Word DOCX document  # noqa: E501

        Adds a new table row into a DOCX Document and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_insert_table_row_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InsertDocxTableRowRequest req_config: Document input request (required)
        :return: InsertDocxTableRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_insert_table_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_insert_table_row`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/insert-table-row', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InsertDocxTableRowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_pages(self, req_config, **kwargs):  # noqa: E501
        """Get pages and content from a Word DOCX document  # noqa: E501

        Returns the pages and contents of each page defined in the Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_pages(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxPagesRequest req_config: Document input request (required)
        :return: GetDocxPagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_pages_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_pages_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_pages_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Get pages and content from a Word DOCX document  # noqa: E501

        Returns the pages and contents of each page defined in the Word Document (DOCX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_pages_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetDocxPagesRequest req_config: Document input request (required)
        :return: GetDocxPagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_pages`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/get-pages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocxPagesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_remove_all_comments(self, input_file, **kwargs):  # noqa: E501
        """Remove all comments from a Word DOCX document  # noqa: E501

        Removes all of the comments from a Word Document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_remove_all_comments(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_remove_all_comments_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_remove_all_comments_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_remove_all_comments_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Remove all comments from a Word DOCX document  # noqa: E501

        Removes all of the comments from a Word Document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_remove_all_comments_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_remove_all_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_document_docx_remove_all_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/comments/remove-all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_remove_headers_and_footers(self, req_config, **kwargs):  # noqa: E501
        """Remove headers and footers from Word DOCX document  # noqa: E501

        Remove all headers, or footers, or both from a Word Document (DOCX).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_remove_headers_and_footers(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoveDocxHeadersAndFootersRequest req_config: Document input request (required)
        :return: RemoveDocxHeadersAndFootersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_remove_headers_and_footers_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_remove_headers_and_footers_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_remove_headers_and_footers_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Remove headers and footers from Word DOCX document  # noqa: E501

        Remove all headers, or footers, or both from a Word Document (DOCX).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_remove_headers_and_footers_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoveDocxHeadersAndFootersRequest req_config: Document input request (required)
        :return: RemoveDocxHeadersAndFootersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_remove_headers_and_footers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_remove_headers_and_footers`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/remove-headers-and-footers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RemoveDocxHeadersAndFootersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_remove_object(self, req_config, **kwargs):  # noqa: E501
        """Delete any object in a Word DOCX document  # noqa: E501

        Delete any object, such as a paragraph, table, image, etc. from a Word Document (DOCX).  Pass in the Path of the object you would like to delete.  You can call other functions such as Get-Tables, Get-Images, Get-Body, etc. to get the paths of the objects in the document.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_remove_object(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxRemoveObjectRequest req_config: Document input request (required)
        :return: DocxRemoveObjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_remove_object_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_remove_object_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_remove_object_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Delete any object in a Word DOCX document  # noqa: E501

        Delete any object, such as a paragraph, table, image, etc. from a Word Document (DOCX).  Pass in the Path of the object you would like to delete.  You can call other functions such as Get-Tables, Get-Images, Get-Body, etc. to get the paths of the objects in the document.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_remove_object_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxRemoveObjectRequest req_config: Document input request (required)
        :return: DocxRemoveObjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_remove_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_remove_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/remove-object', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocxRemoveObjectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_replace(self, req_config, **kwargs):  # noqa: E501
        """Replace string in Word DOCX document  # noqa: E501

        Replace all instances of a string in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_replace(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplaceStringRequest req_config: Document string replacement configuration input (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_replace_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_replace_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_replace_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Replace string in Word DOCX document  # noqa: E501

        Replace all instances of a string in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_replace_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplaceStringRequest req_config: Document string replacement configuration input (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_replace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_replace`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/replace-all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_replace_multi(self, req_config, **kwargs):  # noqa: E501
        """Replace multiple strings in Word DOCX document  # noqa: E501

        Replace all instances of multiple strings in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_replace_multi(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MultiReplaceStringRequest req_config: Document string replacement configuration input (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_replace_multi_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_replace_multi_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_replace_multi_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Replace multiple strings in Word DOCX document  # noqa: E501

        Replace all instances of multiple strings in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_replace_multi_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MultiReplaceStringRequest req_config: Document string replacement configuration input (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_replace_multi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_replace_multi`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/replace-all/multi', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_replace_paragraph(self, req_config, **kwargs):  # noqa: E501
        """Replace matching paragraphs in a Word DOCX document  # noqa: E501

        Returns the edited Word Document (DOCX) format file with the matching paragraphs replaced as requested.  Replace a paragraph with another object such as an image.  Useful for performing templating operations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_replace_paragraph(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplaceDocxParagraphRequest req_config: Document input request (required)
        :return: ReplaceDocxParagraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_replace_paragraph_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_replace_paragraph_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_replace_paragraph_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Replace matching paragraphs in a Word DOCX document  # noqa: E501

        Returns the edited Word Document (DOCX) format file with the matching paragraphs replaced as requested.  Replace a paragraph with another object such as an image.  Useful for performing templating operations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_replace_paragraph_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplaceDocxParagraphRequest req_config: Document input request (required)
        :return: ReplaceDocxParagraphResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_replace_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_replace_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/replace/paragraph', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReplaceDocxParagraphResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_set_custom_metadata_properties(self, input, **kwargs):  # noqa: E501
        """Set custom property metadata properties in Word DOCX document  # noqa: E501

        Sets the custom property metadata for the metadata properties in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_set_custom_metadata_properties(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxSetCustomMetadataPropertiesRequest input: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_set_custom_metadata_properties_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_set_custom_metadata_properties_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_set_custom_metadata_properties_with_http_info(self, input, **kwargs):  # noqa: E501
        """Set custom property metadata properties in Word DOCX document  # noqa: E501

        Sets the custom property metadata for the metadata properties in an Office Word Document (docx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_set_custom_metadata_properties_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxSetCustomMetadataPropertiesRequest input: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_set_custom_metadata_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_docx_set_custom_metadata_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/set-metadata/custom-property', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_set_footer(self, req_config, **kwargs):  # noqa: E501
        """Set the footer in a Word DOCX document  # noqa: E501

        Set the footer in a Word Document (DOCX).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_set_footer(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxSetFooterRequest req_config: Document input request (required)
        :return: DocxSetFooterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_set_footer_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_set_footer_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_set_footer_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Set the footer in a Word DOCX document  # noqa: E501

        Set the footer in a Word Document (DOCX).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_set_footer_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxSetFooterRequest req_config: Document input request (required)
        :return: DocxSetFooterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_set_footer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_set_footer`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/set-footer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocxSetFooterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_set_footer_add_page_number(self, req_config, **kwargs):  # noqa: E501
        """Add page number to footer in a Word DOCX document  # noqa: E501

        Set the footer in a Word Document (DOCX) to contain a page number.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_set_footer_add_page_number(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxSetFooterAddPageNumberRequest req_config: Document input request (required)
        :return: DocxSetFooterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_set_footer_add_page_number_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_set_footer_add_page_number_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_set_footer_add_page_number_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Add page number to footer in a Word DOCX document  # noqa: E501

        Set the footer in a Word Document (DOCX) to contain a page number.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_set_footer_add_page_number_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxSetFooterAddPageNumberRequest req_config: Document input request (required)
        :return: DocxSetFooterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_set_footer_add_page_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_set_footer_add_page_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/set-footer/add-page-number', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocxSetFooterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_set_header(self, req_config, **kwargs):  # noqa: E501
        """Set the header in a Word DOCX document  # noqa: E501

        Set the header in a Word Document (DOCX).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_set_header(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxSetHeaderRequest req_config: Document input request (required)
        :return: DocxSetHeaderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_set_header_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_set_header_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_set_header_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Set the header in a Word DOCX document  # noqa: E501

        Set the header in a Word Document (DOCX).  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_set_header_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocxSetHeaderRequest req_config: Document input request (required)
        :return: DocxSetHeaderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_set_header" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_set_header`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/set-header', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocxSetHeaderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_update_table_cell(self, req_config, **kwargs):  # noqa: E501
        """Update, set contents of a table cell in an existing table in a Word DOCX document  # noqa: E501

        Sets the contents of a table cell into a DOCX Document and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_update_table_cell(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDocxTableCellRequest req_config: Document input request (required)
        :return: UpdateDocxTableCellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_update_table_cell_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_update_table_cell_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_update_table_cell_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Update, set contents of a table cell in an existing table in a Word DOCX document  # noqa: E501

        Sets the contents of a table cell into a DOCX Document and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_update_table_cell_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDocxTableCellRequest req_config: Document input request (required)
        :return: UpdateDocxTableCellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_update_table_cell" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_update_table_cell`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/update-table-cell', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateDocxTableCellResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_docx_update_table_row(self, req_config, **kwargs):  # noqa: E501
        """Update, set contents of a table row in an existing table in a Word DOCX document  # noqa: E501

        Sets the contents of a table row into a DOCX Document and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_update_table_row(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDocxTableRowRequest req_config: Document input request (required)
        :return: UpdateDocxTableRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_docx_update_table_row_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_docx_update_table_row_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_docx_update_table_row_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Update, set contents of a table row in an existing table in a Word DOCX document  # noqa: E501

        Sets the contents of a table row into a DOCX Document and returns the result.  Call Finish Editing on the output URL to complete the operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_docx_update_table_row_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDocxTableRowRequest req_config: Document input request (required)
        :return: UpdateDocxTableRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_docx_update_table_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_docx_update_table_row`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/docx/update-table-row', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateDocxTableRowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_finish_editing(self, req_config, **kwargs):  # noqa: E501
        """Finish editing document, and download result from document editing  # noqa: E501

        Once done editing a document, download the result.  Begin editing a document by calling begin-editing, then perform operations, then call finish-editing to get the result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_finish_editing(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FinishEditingRequest req_config: Cloudmersive Document URL to complete editing on (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_finish_editing_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_finish_editing_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_finish_editing_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Finish editing document, and download result from document editing  # noqa: E501

        Once done editing a document, download the result.  Begin editing a document by calling begin-editing, then perform operations, then call finish-editing to get the result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_finish_editing_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FinishEditingRequest req_config: Cloudmersive Document URL to complete editing on (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_finish_editing" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_finish_editing`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/finish-editing', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_pptx_delete_slides(self, req_config, **kwargs):  # noqa: E501
        """Delete, remove slides from a PowerPoint PPTX presentation document  # noqa: E501

        Edits the input PowerPoint PPTX presentation document to remove the specified slides  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_pptx_delete_slides(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemovePptxSlidesRequest req_config: Presentation input request (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_pptx_delete_slides_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_pptx_delete_slides_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_pptx_delete_slides_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Delete, remove slides from a PowerPoint PPTX presentation document  # noqa: E501

        Edits the input PowerPoint PPTX presentation document to remove the specified slides  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_pptx_delete_slides_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemovePptxSlidesRequest req_config: Presentation input request (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_pptx_delete_slides" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_pptx_delete_slides`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pptx/delete-slides', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_pptx_get_macro_information(self, input_file, **kwargs):  # noqa: E501
        """Get macro information from a PowerPoint PPTX/PPTM presentation document  # noqa: E501

        Returns information about the Macros (e.g. VBA) defined in the PowerPoint Document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_pptx_get_macro_information(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetMacrosResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_pptx_get_macro_information_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_pptx_get_macro_information_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_document_pptx_get_macro_information_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Get macro information from a PowerPoint PPTX/PPTM presentation document  # noqa: E501

        Returns information about the Macros (e.g. VBA) defined in the PowerPoint Document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_pptx_get_macro_information_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetMacrosResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_pptx_get_macro_information" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_document_pptx_get_macro_information`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pptx/get-macros', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetMacrosResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_pptx_replace(self, req_config, **kwargs):  # noqa: E501
        """Replace string in PowerPoint PPTX presentation  # noqa: E501

        Replace all instances of a string in an Office PowerPoint Document (pptx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_pptx_replace(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplaceStringRequest req_config: Replacement document configuration input (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_pptx_replace_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_pptx_replace_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_pptx_replace_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Replace string in PowerPoint PPTX presentation  # noqa: E501

        Replace all instances of a string in an Office PowerPoint Document (pptx)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_pptx_replace_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplaceStringRequest req_config: Replacement document configuration input (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_pptx_replace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_pptx_replace`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/pptx/replace-all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_append_row(self, input, **kwargs):  # noqa: E501
        """Append row to a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Appends a row to the end of an Excel Spreadsheet worksheet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_append_row(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AppendXlsxRowRequest input: Document input request (required)
        :return: AppendXlsxRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_append_row_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_append_row_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_append_row_with_http_info(self, input, **kwargs):  # noqa: E501
        """Append row to a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Appends a row to the end of an Excel Spreadsheet worksheet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_append_row_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AppendXlsxRowRequest input: Document input request (required)
        :return: AppendXlsxRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_append_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_append_row`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/append-row', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AppendXlsxRowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_clear_cell_by_index(self, input, **kwargs):  # noqa: E501
        """Clear cell contents in an Excel XLSX spreadsheet, worksheet by index  # noqa: E501

        Clears, sets to blank, the contents of a specific cell in an Excel XLSX spreadsheet, worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_clear_cell_by_index(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClearXlsxCellRequest input: Document input request (required)
        :return: ClearXlsxCellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_clear_cell_by_index_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_clear_cell_by_index_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_clear_cell_by_index_with_http_info(self, input, **kwargs):  # noqa: E501
        """Clear cell contents in an Excel XLSX spreadsheet, worksheet by index  # noqa: E501

        Clears, sets to blank, the contents of a specific cell in an Excel XLSX spreadsheet, worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_clear_cell_by_index_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClearXlsxCellRequest input: Document input request (required)
        :return: ClearXlsxCellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_clear_cell_by_index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_clear_cell_by_index`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/clear-cell/by-index', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClearXlsxCellResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_clear_row(self, input, **kwargs):  # noqa: E501
        """Clear row from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Clears data from a specific row in the Excel Spreadsheet worksheet, leaving a blank row. Use the Get Rows And Cells API to enumerate available rows in a spreadsheet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_clear_row(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClearXlsxRowRequest input: Document input request (required)
        :return: ClearXlsxRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_clear_row_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_clear_row_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_clear_row_with_http_info(self, input, **kwargs):  # noqa: E501
        """Clear row from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Clears data from a specific row in the Excel Spreadsheet worksheet, leaving a blank row. Use the Get Rows And Cells API to enumerate available rows in a spreadsheet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_clear_row_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClearXlsxRowRequest input: Document input request (required)
        :return: ClearXlsxRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_clear_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_clear_row`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/clear-row', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClearXlsxRowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_create_blank_spreadsheet(self, input, **kwargs):  # noqa: E501
        """Create a blank Excel XLSX spreadsheet  # noqa: E501

        Returns a blank Excel XLSX Spreadsheet (XLSX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_create_blank_spreadsheet(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateBlankSpreadsheetRequest input: Document input request (required)
        :return: CreateBlankSpreadsheetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_create_blank_spreadsheet_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_create_blank_spreadsheet_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_create_blank_spreadsheet_with_http_info(self, input, **kwargs):  # noqa: E501
        """Create a blank Excel XLSX spreadsheet  # noqa: E501

        Returns a blank Excel XLSX Spreadsheet (XLSX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_create_blank_spreadsheet_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateBlankSpreadsheetRequest input: Document input request (required)
        :return: CreateBlankSpreadsheetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_create_blank_spreadsheet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_create_blank_spreadsheet`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/create/blank', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateBlankSpreadsheetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_create_spreadsheet_from_data(self, input, **kwargs):  # noqa: E501
        """Create a new Excel XLSX spreadsheet from column and row data  # noqa: E501

        Returns a new Excel XLSX Spreadsheet (XLSX) format file populated with column and row data specified as input  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_create_spreadsheet_from_data(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSpreadsheetFromDataRequest input: Document input request (required)
        :return: CreateSpreadsheetFromDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_create_spreadsheet_from_data_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_create_spreadsheet_from_data_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_create_spreadsheet_from_data_with_http_info(self, input, **kwargs):  # noqa: E501
        """Create a new Excel XLSX spreadsheet from column and row data  # noqa: E501

        Returns a new Excel XLSX Spreadsheet (XLSX) format file populated with column and row data specified as input  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_create_spreadsheet_from_data_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSpreadsheetFromDataRequest input: Document input request (required)
        :return: CreateSpreadsheetFromDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_create_spreadsheet_from_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_create_spreadsheet_from_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/create/from/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSpreadsheetFromDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_delete_worksheet(self, req_config, **kwargs):  # noqa: E501
        """Delete, remove worksheet from an Excel XLSX spreadsheet document  # noqa: E501

        Edits the input Excel XLSX spreadsheet document to remove the specified worksheet (tab).  Use the Get Worksheets API to enumerate available worksheets in a spreadsheet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_delete_worksheet(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoveXlsxWorksheetRequest req_config: Spreadsheet input request (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_delete_worksheet_with_http_info(req_config, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_delete_worksheet_with_http_info(req_config, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_delete_worksheet_with_http_info(self, req_config, **kwargs):  # noqa: E501
        """Delete, remove worksheet from an Excel XLSX spreadsheet document  # noqa: E501

        Edits the input Excel XLSX spreadsheet document to remove the specified worksheet (tab).  Use the Get Worksheets API to enumerate available worksheets in a spreadsheet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_delete_worksheet_with_http_info(req_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoveXlsxWorksheetRequest req_config: Spreadsheet input request (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_delete_worksheet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req_config' is set
        if ('req_config' not in params or
                params['req_config'] is None):
            raise ValueError("Missing the required parameter `req_config` when calling `edit_document_xlsx_delete_worksheet`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req_config' in params:
            body_params = params['req_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/delete-worksheet', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_disable_shared_workbook(self, input, **kwargs):  # noqa: E501
        """Disable Shared Workbook (legacy) in Excel XLSX spreadsheet  # noqa: E501

        Disable the Shared Workbook (legacy) mode in an Excel XLSX spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_disable_shared_workbook(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DisableSharedWorkbookRequest input: Document input request (required)
        :return: DisableSharedWorkbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_disable_shared_workbook_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_disable_shared_workbook_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_disable_shared_workbook_with_http_info(self, input, **kwargs):  # noqa: E501
        """Disable Shared Workbook (legacy) in Excel XLSX spreadsheet  # noqa: E501

        Disable the Shared Workbook (legacy) mode in an Excel XLSX spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_disable_shared_workbook_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DisableSharedWorkbookRequest input: Document input request (required)
        :return: DisableSharedWorkbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_disable_shared_workbook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_disable_shared_workbook`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/configuration/disable-shared-workbook', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DisableSharedWorkbookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_enable_shared_workbook(self, input, **kwargs):  # noqa: E501
        """Enable Shared Workbook (legacy) in Excel XLSX spreadsheet  # noqa: E501

        Enables the Shared Workbook (legacy) mode in an Excel XLSX spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_enable_shared_workbook(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EnableSharedWorkbookRequest input: Document input request (required)
        :return: EnableSharedWorkbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_enable_shared_workbook_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_enable_shared_workbook_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_enable_shared_workbook_with_http_info(self, input, **kwargs):  # noqa: E501
        """Enable Shared Workbook (legacy) in Excel XLSX spreadsheet  # noqa: E501

        Enables the Shared Workbook (legacy) mode in an Excel XLSX spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_enable_shared_workbook_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EnableSharedWorkbookRequest input: Document input request (required)
        :return: EnableSharedWorkbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_enable_shared_workbook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_enable_shared_workbook`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/configuration/enable-shared-workbook', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnableSharedWorkbookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_get_cell_by_identifier(self, input, **kwargs):  # noqa: E501
        """Get cell from an Excel XLSX spreadsheet, worksheet by cell identifier  # noqa: E501

        Returns the value of a specific cell based on its identifier (e.g. A1, B22, C33, etc.) in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_cell_by_identifier(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxCellByIdentifierRequest input: Document input request (required)
        :return: GetXlsxCellByIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_get_cell_by_identifier_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_get_cell_by_identifier_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_get_cell_by_identifier_with_http_info(self, input, **kwargs):  # noqa: E501
        """Get cell from an Excel XLSX spreadsheet, worksheet by cell identifier  # noqa: E501

        Returns the value of a specific cell based on its identifier (e.g. A1, B22, C33, etc.) in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_cell_by_identifier_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxCellByIdentifierRequest input: Document input request (required)
        :return: GetXlsxCellByIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_get_cell_by_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_get_cell_by_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/get-cell/by-identifier', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetXlsxCellByIdentifierResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_get_cell_by_index(self, input, **kwargs):  # noqa: E501
        """Get cell from an Excel XLSX spreadsheet, worksheet by index  # noqa: E501

        Returns the value and definition of a specific cell in a specific row in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_cell_by_index(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxCellRequest input: Document input request (required)
        :return: GetXlsxCellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_get_cell_by_index_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_get_cell_by_index_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_get_cell_by_index_with_http_info(self, input, **kwargs):  # noqa: E501
        """Get cell from an Excel XLSX spreadsheet, worksheet by index  # noqa: E501

        Returns the value and definition of a specific cell in a specific row in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_cell_by_index_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxCellRequest input: Document input request (required)
        :return: GetXlsxCellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_get_cell_by_index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_get_cell_by_index`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/get-cell/by-index', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetXlsxCellResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_get_columns(self, input, **kwargs):  # noqa: E501
        """Get columns from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Returns the columns defined in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_columns(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxColumnsRequest input: Document input request (required)
        :return: GetXlsxColumnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_get_columns_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_get_columns_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_get_columns_with_http_info(self, input, **kwargs):  # noqa: E501
        """Get columns from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Returns the columns defined in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_columns_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxColumnsRequest input: Document input request (required)
        :return: GetXlsxColumnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_get_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_get_columns`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/get-columns', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetXlsxColumnsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_get_images(self, input, **kwargs):  # noqa: E501
        """Get images from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Returns the images defined in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_images(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxImagesRequest input: Document input request (required)
        :return: GetXlsxImagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_get_images_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_get_images_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_get_images_with_http_info(self, input, **kwargs):  # noqa: E501
        """Get images from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Returns the images defined in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_images_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxImagesRequest input: Document input request (required)
        :return: GetXlsxImagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_get_images" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_get_images`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/get-images', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetXlsxImagesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_get_macro_information(self, input_file, **kwargs):  # noqa: E501
        """Get macro information from a Excel XLSX/XLSM spreadsheet, worksheet  # noqa: E501

        Returns information about the Macros (e.g. VBA) defined in the Excel Spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_macro_information(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetMacrosResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_get_macro_information_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_get_macro_information_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_get_macro_information_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Get macro information from a Excel XLSX/XLSM spreadsheet, worksheet  # noqa: E501

        Returns information about the Macros (e.g. VBA) defined in the Excel Spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_macro_information_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :return: GetMacrosResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_get_macro_information" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `edit_document_xlsx_get_macro_information`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/get-macros', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetMacrosResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_get_rows_and_cells(self, input, **kwargs):  # noqa: E501
        """Get rows and cells from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Returns the rows and cells defined in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_rows_and_cells(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxRowsAndCellsRequest input: Document input request (required)
        :return: GetXlsxRowsAndCellsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_get_rows_and_cells_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_get_rows_and_cells_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_get_rows_and_cells_with_http_info(self, input, **kwargs):  # noqa: E501
        """Get rows and cells from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Returns the rows and cells defined in the Excel Spreadsheet worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_rows_and_cells_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxRowsAndCellsRequest input: Document input request (required)
        :return: GetXlsxRowsAndCellsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_get_rows_and_cells" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_get_rows_and_cells`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/get-rows-and-cells', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetXlsxRowsAndCellsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_get_specific_row(self, input, **kwargs):  # noqa: E501
        """Get a specific row from a Excel XLSX spreadsheet, worksheet by path  # noqa: E501

        Returns the specific row and its cells defined in the Excel Spreadsheet worksheet based on the specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_specific_row(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxSpecificRowRequest input: Document input request (required)
        :return: GetXlsxSpecificRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_get_specific_row_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_get_specific_row_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_get_specific_row_with_http_info(self, input, **kwargs):  # noqa: E501
        """Get a specific row from a Excel XLSX spreadsheet, worksheet by path  # noqa: E501

        Returns the specific row and its cells defined in the Excel Spreadsheet worksheet based on the specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_specific_row_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxSpecificRowRequest input: Document input request (required)
        :return: GetXlsxSpecificRowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_get_specific_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_get_specific_row`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/get-specific-row', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetXlsxSpecificRowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_get_styles(self, input, **kwargs):  # noqa: E501
        """Get styles from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Returns the style defined in the Excel Spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_styles(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxStylesRequest input: Document input request (required)
        :return: GetXlsxStylesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_get_styles_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_get_styles_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_get_styles_with_http_info(self, input, **kwargs):  # noqa: E501
        """Get styles from a Excel XLSX spreadsheet, worksheet  # noqa: E501

        Returns the style defined in the Excel Spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_styles_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxStylesRequest input: Document input request (required)
        :return: GetXlsxStylesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_get_styles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_get_styles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/get-styles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetXlsxStylesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_get_worksheets(self, input, **kwargs):  # noqa: E501
        """Get worksheets from a Excel XLSX spreadsheet  # noqa: E501

        Returns the worksheets (tabs) defined in the Excel Spreadsheet (XLSX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_worksheets(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxWorksheetsRequest input: Document input request (required)
        :return: GetXlsxWorksheetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_get_worksheets_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_get_worksheets_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_get_worksheets_with_http_info(self, input, **kwargs):  # noqa: E501
        """Get worksheets from a Excel XLSX spreadsheet  # noqa: E501

        Returns the worksheets (tabs) defined in the Excel Spreadsheet (XLSX) format file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_get_worksheets_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetXlsxWorksheetsRequest input: Document input request (required)
        :return: GetXlsxWorksheetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_get_worksheets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_get_worksheets`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/get-worksheets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetXlsxWorksheetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_insert_worksheet(self, input, **kwargs):  # noqa: E501
        """Insert a new worksheet into an Excel XLSX spreadsheet  # noqa: E501

        Inserts a new worksheet into an Excel Spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_insert_worksheet(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InsertXlsxWorksheetRequest input: Document input request (required)
        :return: InsertXlsxWorksheetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_insert_worksheet_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_insert_worksheet_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_insert_worksheet_with_http_info(self, input, **kwargs):  # noqa: E501
        """Insert a new worksheet into an Excel XLSX spreadsheet  # noqa: E501

        Inserts a new worksheet into an Excel Spreadsheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_insert_worksheet_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InsertXlsxWorksheetRequest input: Document input request (required)
        :return: InsertXlsxWorksheetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_insert_worksheet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_insert_worksheet`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/insert-worksheet', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InsertXlsxWorksheetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_rename_worksheet(self, input, **kwargs):  # noqa: E501
        """Rename a specific worksheet in a Excel XLSX spreadsheet  # noqa: E501

        Edits the input Excel XLSX spreadsheet document to rename a specified worksheet (tab).  Use the Get Worksheets API to enumerate available worksheets in a spreadsheet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_rename_worksheet(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RenameXlsxWorksheetRequest input: Document input request (required)
        :return: RenameXlsxWorksheetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_rename_worksheet_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_rename_worksheet_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_rename_worksheet_with_http_info(self, input, **kwargs):  # noqa: E501
        """Rename a specific worksheet in a Excel XLSX spreadsheet  # noqa: E501

        Edits the input Excel XLSX spreadsheet document to rename a specified worksheet (tab).  Use the Get Worksheets API to enumerate available worksheets in a spreadsheet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_rename_worksheet_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RenameXlsxWorksheetRequest input: Document input request (required)
        :return: RenameXlsxWorksheetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_rename_worksheet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_rename_worksheet`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/rename-worksheet', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RenameXlsxWorksheetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_set_cell_by_identifier(self, input, **kwargs):  # noqa: E501
        """Set, update cell contents in an Excel XLSX spreadsheet, worksheet by cell identifier  # noqa: E501

        Sets, updates the contents of a specific cell in an Excel XLSX spreadsheet, worksheet using its cell identifier (e.g. A1, B22, C33) in the worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_set_cell_by_identifier(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetXlsxCellByIdentifierRequest input: Document input request (required)
        :return: SetXlsxCellByIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_set_cell_by_identifier_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_set_cell_by_identifier_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_set_cell_by_identifier_with_http_info(self, input, **kwargs):  # noqa: E501
        """Set, update cell contents in an Excel XLSX spreadsheet, worksheet by cell identifier  # noqa: E501

        Sets, updates the contents of a specific cell in an Excel XLSX spreadsheet, worksheet using its cell identifier (e.g. A1, B22, C33) in the worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_set_cell_by_identifier_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetXlsxCellByIdentifierRequest input: Document input request (required)
        :return: SetXlsxCellByIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_set_cell_by_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_set_cell_by_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/set-cell/by-identifier', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SetXlsxCellByIdentifierResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_document_xlsx_set_cell_by_index(self, input, **kwargs):  # noqa: E501
        """Set, update cell contents in an Excel XLSX spreadsheet, worksheet by index  # noqa: E501

        Sets, updates the contents of a specific cell in an Excel XLSX spreadsheet, worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_set_cell_by_index(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetXlsxCellRequest input: Document input request (required)
        :return: SetXlsxCellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_document_xlsx_set_cell_by_index_with_http_info(input, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_document_xlsx_set_cell_by_index_with_http_info(input, **kwargs)  # noqa: E501
            return data

    def edit_document_xlsx_set_cell_by_index_with_http_info(self, input, **kwargs):  # noqa: E501
        """Set, update cell contents in an Excel XLSX spreadsheet, worksheet by index  # noqa: E501

        Sets, updates the contents of a specific cell in an Excel XLSX spreadsheet, worksheet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_document_xlsx_set_cell_by_index_with_http_info(input, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetXlsxCellRequest input: Document input request (required)
        :return: SetXlsxCellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_document_xlsx_set_cell_by_index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input' is set
        if ('input' not in params or
                params['input'] is None):
            raise ValueError("Missing the required parameter `input` when calling `edit_document_xlsx_set_cell_by_index`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'input' in params:
            body_params = params['input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/xlsx/set-cell/by-index', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SetXlsxCellResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
