# -*- coding: utf-8 -*-
import base64
import os
import unittest

import intelmq.lib.test as test
from intelmq.bots.parsers.malwaredomains.parser import MalwareDomainsParserBot

with open(os.path.join(os.path.dirname(__file__), 'domains.txt'), 'rb') as fh:
    RAW = base64.b64encode(fh.read()).decode()

OUTPUT1 = {'__type': 'Event',
           'classification.type': 'phishing',
           'event_description.text': 'phishing',
           'classification.identifier': 'phishing',
           'raw': 'CQlleGFtcGxlLmNvbQlwaGlzaGluZwlvcGVucGhpc2guY29tCTIwMTYwNTI3CTIwMTYwMTA4',
           'source.fqdn': 'example.com',
           'time.source': '2016-05-27T00:00:00+00:00'}
OUTPUT2 = {'__type': 'Event',
           'classification.type': 'phishing',
           'event_description.text': 'phishing',
           'classification.identifier': 'phishing',
           'raw': 'CQlleGFtcGxlLmludmFsaWQJcGhpc2hpbmcJb3BlbnBoaXNoLmNvbQkyMDE2MDUyNwkyMDE2MDEwOA==',
           'source.fqdn': 'example.invalid',
           'time.source': '2016-05-27T00:00:00+00:00'}
OUTPUT3 = {'__type': 'Event',
           'classification.type': 'c2server',
            'event_description.text': 'C&C',
            'classification.identifier': 'C&C',
           'raw': 'CQlleGFtcGxlLm5ldAlDJkMJc291cmNlLmV4YW1wbGUuY29tCTIwMTcxMjAxCTIwMTYwNzE5CTIwMTYwMzEw',
           'source.fqdn': 'example.net',
           'time.source': '2017-12-01T00:00:00+00:00'}


class TestMalwareDomainsParserBot(test.BotTestCase, unittest.TestCase):
    """
    A TestCase for MalwareDomainsParserBot.
    """

    @classmethod
    def set_bot(cls):
        cls.bot_reference = MalwareDomainsParserBot
        cls.default_input_message = {'__type': 'Report', 'raw': RAW}

    def test_event(self):
        self.run_bot()
        self.assertMessageEqual(0, OUTPUT1)
        self.assertMessageEqual(1, OUTPUT2)
        self.assertMessageEqual(2, OUTPUT3)

if __name__ == '__main__':  # pragma: no cover
    unittest.main()
