Malware Name Mapping
====================

This script fetches the current mapping file from the [Malware Name Mapping repository](https://github.com/certtools/malware_name_mapping/raw/master/mapping.csv) and converts it to the syntax needed by the modify expert.

For more information about this project have a look at its [webpage/repository](https://github.com/certtools/malware_name_mapping).

The script expects a comma-separated file and uses the first column as regular expression and the second one as family name. Other URLs can be given as parameter.
The resulting configuration sets the field `classification.identifier` to the malware family name corresponding to the given `malware.name`.

By default, the result is printed to stdout, a filename can be given as parameter.

For more information about the mapping project, have a look at the [Malware Name Mapping repository](https://github.com/certtools/malware_name_mapping).

See also the built-in help of the script by calling it with `-h`.

Additional optional rules
----------------

### Malpedia rules

The rules imported from Malpedia can be used optionally with the flag `--include-malpedia`. Note, that this data is CC BY-NC-SA 3.0 and not CC0, so any comercial usage, including usage in commercial organizations, is not allowed.

### MISP galaxy rules

MISP galaxies (currently only threat actors, also shown in the malpedia webinterface as actors) can be used optionally with the flag `--include-misp`. The license is CC0, slike the actual malware name mapping data.
The rules contain the actor's names and synonmous, including some variations on word boundaries to also optionally catch dashes and underscores.
The resulting identifier is of the form "${actor}-generic".

### Default rule

A default rule can optionally be added the the end of the rules with the `-d` flag.
With this rule, the field `classification.identifier` is set to `malware.name` if the first is empty and the latter is not.
As this is the last rule, it is kind of "last resort" to fill the identifier field.

### Local rules

Additional arbitrary mappings can be added with parameters to the download tool using the `-e` (expression) and `-i` (identifier) flags:
```
-e "^some-expression$" -i "some-identifier"
```
and multiple ones:
```
-e "^some-expression$" -i "some-identifier" -e "^other-expression$" -i "other-identifier"
```

Modify Bot
----------

Use the Modify bot to apply the ruleset by using the generated file as configuration. Also, deactivate the case sensitivity of the bot by setting the parameter `case_sensitive` to `false` (default).

Automation
----------

You can use a crontab-entry like this:
```
0  1  *      *   *   /path/to/contrib/malware_name_mapping/download_mapping.py /opt/intelmq/var/lib/bots/modify/malware-family-names.conf && intelmqctl reload malware-family-name-expert
```
You can check the validity of the resulting rule file with `intelmqctl check`.

Applying the mapping to existing data
-------------------------------------

See [`../contrib/eventdb/apply_mapping_eventdb.py](Contrib/EventDB).
