from setuptools import setup, find_packages

setup(
    name = 'pywapor',
    version = '2.6.0',
    url = 'https://www.fao.org/aquastat/py-wapor/',
    author = "FAO",
    author_email = "bert.coerver@fao.org",
    license = "Apache",
    packages = find_packages(include = ['pywapor', 'pywapor.*']),
    include_package_data=True,
    python_requires='>=3.7',
    install_requires = [
        'gdal',
        'xarray>=0.20',
        'numpy',
        'pydap',
        'pandas',
        'requests',
        'matplotlib',
        'netcdf4<1.6.0', # otherwise opendap gives problem in colab -> https://github.com/Unidata/netcdf4-python/issues/1179
        'pyproj',
        'scipy',
        'pycurl',
        'pyshp',
        'joblib',
        'bs4',
        'rasterio',
        'bottleneck>=1.3.1',
        'geojson',
        'tqdm',
        'dask',
        'rioxarray',
        'python_log_indenter',
        'cryptography',
        'pyvis',
        'cachetools',
        'cdsapi',
        'sentinelsat',
        'shapely',
        'lxml',
        'geopy',
    ],
    classifiers=[
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
    ],
)