from __future__ import annotations

from typing import Any, Optional

class Evaluator:
    states: Any = ...
    metrics: Any = ...
    helper: Any = ...
    def __init__(self, name: Any, **kwargs: Any) -> None: ...
    def reset(self, executor: Any, reset_program: Optional[Any] = ...) -> None: ...
    def eval(self, executor: Any, eval_program: Optional[Any] = ...) -> None: ...

class ChunkEvaluator(Evaluator):
    num_infer_chunks: Any = ...
    num_label_chunks: Any = ...
    num_correct_chunks: Any = ...
    def __init__(
        self, input: Any, label: Any, chunk_scheme: Any, num_chunk_types: Any, excluded_chunk_types: Optional[Any] = ...
    ) -> None: ...
    def eval(self, executor: Any, eval_program: Optional[Any] = ...): ...

class EditDistance(Evaluator):
    total_distance: Any = ...
    seq_num: Any = ...
    instance_error: Any = ...
    def __init__(self, input: Any, label: Any, ignored_tokens: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def eval(self, executor: Any, eval_program: Optional[Any] = ...): ...

class DetectionMAP(Evaluator):
    has_state: Any = ...
    cur_map: Any = ...
    accum_map: Any = ...
    def __init__(
        self,
        input: Any,
        gt_label: Any,
        gt_box: Any,
        gt_difficult: Optional[Any] = ...,
        class_num: Optional[Any] = ...,
        background_label: int = ...,
        overlap_threshold: float = ...,
        evaluate_difficult: bool = ...,
        ap_version: str = ...,
    ) -> None: ...
    def get_map_var(self): ...
    def reset(self, executor: Any, reset_program: Optional[Any] = ...) -> None: ...
