| Element | Description |
| --- | --- |
| [`<caption>`](/en-US/docs/Web/HTML/Element/caption "The HTML <caption> Element (or HTML Table Caption Element) represents the title of a table. Though it is always the first descendant of a <table>, its styling, using CSS, may place it elsewhere, relative to the table.") | The **HTML `<caption>` Element** (or _HTML Table Caption Element_) represents the title of a table. Though it is always the first descendant of a [`<table>`](/en-US/docs/Web/HTML/Element/table "The HTML Table Element (<table>) represents data in two dimensions or more."), its styling, using CSS, may place it elsewhere, relative to the table. |
| [`<col>`](/en-US/docs/Web/HTML/Element/col "The HTML Table Column Element (<col>) defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a <colgroup> element.") | The _HTML Table Column Element_ (**<col>**) defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a [`<colgroup>`](/en-US/docs/Web/HTML/Element/colgroup "The HTML Table Column Group Element (<colgroup>) defines a group of columns within a table.") element. |
| [`<colgroup>`](/en-US/docs/Web/HTML/Element/colgroup "The HTML Table Column Group Element (<colgroup>) defines a group of columns within a table.") | The _HTML Table Column Group Element_ (**<colgroup>**) defines a group of columns within a table. |
| [`<table>`](/en-US/docs/Web/HTML/Element/table "The HTML Table Element (<table>) represents tabular data - i.e., information expressed via a two dimensional data table.") | The **HTML Table Element** (`<table>`) represents tabular data - i.e., information expressed via a two dimensional data table. |
| [`<tbody>`](/en-US/docs/Web/HTML/Element/tbody "The HTML Table Body Element (<tbody>) defines one or more <tr> element data-rows to be the body of its parent <table> element (as long as no <tr> elements are immediate children of that table element.)  In conjunction with a preceding <thead> and/or <tfoot> element, <tbody> provides additional semantic information for devices such as printers and displays. Of the parent table's child elements, <tbody> represents the content which, when longer than a page, will most likely differ for each page printed; while the content of <thead> and <tfoot> will be the same or similar for each page printed. For displays, <tbody> will enable separate scrolling of the <thead>, <tfoot>, and <caption> elements of the same parent <table> element.  Note that unlike the <thead>, <tfoot>, and <caption> elements however, multiple <tbody> elements are permitted (if consecutive), allowing the data-rows in long tables to be divided into different sections, each separately formatted as needed.") | The HTML **Table Body Element (<tbody>)** defines one or more [`<tr>`](/en-US/docs/Web/HTML/Element/tr "The HTML element table row <tr> defines a row of cells in a table. Those can be a mix of <td> and <th> elements.") element data-rows to be the body of its parent [`<table>`](/en-US/docs/Web/HTML/Element/table "The HTML Table Element (<table>) represents data in two dimensions or more.") element (as long as no <tr> elements are immediate children of that table element.)  In conjunction with a preceding [`<thead>`](/en-US/docs/Web/HTML/Element/thead "The HTML Table Head Element (<thead>) defines a set of rows defining the head of the columns of the table.") and/or [`<tfoot>`](/en-US/docs/Web/HTML/Element/tfoot "The HTML Table Foot Element (<tfoot>) defines a set of rows summarizing the columns of the table.") element, <tbody> provides additional semantic information for devices such as printers and displays. Of the parent table's child elements, <tbody> represents the content which, when longer than a page, will most likely differ for each page printed; while the content of [`<thead>`](/en-US/docs/Web/HTML/Element/thead "The HTML Table Head Element (<thead>) defines a set of rows defining the head of the columns of the table.") and [`<tfoot>`](/en-US/docs/Web/HTML/Element/tfoot "The HTML Table Foot Element (<tfoot>) defines a set of rows summarizing the columns of the table.") will be the same or similar for each page printed. For displays, <tbody> will enable separate scrolling of the [`<thead>`](/en-US/docs/Web/HTML/Element/thead "The HTML Table Head Element (<thead>) defines a set of rows defining the head of the columns of the table."),[`<tfoot>`](/en-US/docs/Web/HTML/Element/tfoot "The HTML Table Foot Element (<tfoot>) defines a set of rows summarizing the columns of the table."), and [`<caption>`](/en-US/docs/Web/HTML/Element/caption "The HTML <caption> Element (or HTML Table Caption Element) represents the title of a table. Though it is always the first descendant of a <table>, its styling, using CSS, may place it elsewhere, relative to the table.") elements of the same parent [`<table>`](/en-US/docs/Web/HTML/Element/table "The HTML Table Element (<table>) represents data in two dimensions or more.") element. Note that unlike the <thead>, <tfoot>, and <caption> elements however, multiple <tbody> elements are permitted (if consecutive), allowing the data-rows in long tables to be divided into different sections, each separately formatted as needed. |
| [`<td>`](/en-US/docs/Web/HTML/Element/td "The Table cell HTML element (<td>) defines a cell of a table that contains data. It participates in the table model.") | The _Table cell_ [HTML](/en-US/docs/Web/HTML) element (**`<td>`**) defines a cell of a table that contains data. It participates in the _table model_. |
| [`<tfoot>`](/en-US/docs/Web/HTML/Element/tfoot "The HTML Table Foot Element (<tfoot>) defines a set of rows summarizing the columns of the table.") | The _HTML Table Foot Element_ (`<tfoot>`) defines a set of rows summarizing the columns of the table. |
| [`<th>`](/en-US/docs/Web/HTML/Element/th "The HTML element table header cell <th> defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes.") | The HTML element _table header cell_ `<th>` defines a cell as header of a group of table cells. The exact nature of this group is defined by the `<a href="/en-US/docs/Web/HTML/Element/th#attr-scope">scope</a>` and `<a href="/en-US/docs/Web/HTML/Element/th#attr-headers">headers</a>` attributes. |
| [`<thead>`](/en-US/docs/Web/HTML/Element/thead "The HTML Table Head Element (<thead>) defines a set of rows defining the head of the columns of the table.") | The _HTML Table Head Element_ (`<thead>`) defines a set of rows defining the head of the columns of the table. |
| [`<tr>`](/en-US/docs/Web/HTML/Element/tr "The HTML element table row <tr> defines a row of cells in a table. Those can be a mix of <td> and <th> elements.") | The HTML element _table row_ `<tr>` defines a row of cells in a table. Those can be a mix of [`<td>`](/en-US/docs/Web/HTML/Element/td "The Table cell HTML element (<td>) defines a cell of a table that contains data. It participates in the table model.") and [`<th>`](/en-US/docs/Web/HTML/Element/th "The HTML element table header cell <th> defines a cell that is a header for a group of cells of a table. The group of cells that the header refers to is defined by the scope and headers attribute.") elements. |
