# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitConnectorArgs', 'GitConnector']

@pulumi.input_type
class GitConnectorArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 url_type: pulumi.Input[str],
                 branch: Optional[pulumi.Input[str]] = None,
                 commit_details: Optional[pulumi.Input['GitConnectorCommitDetailsArgs']] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 generate_webhook_url: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 ssh_setting_id: Optional[pulumi.Input[str]] = None,
                 usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['GitConnectorUsageScopeArgs']]]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GitConnector resource.
        :param pulumi.Input[str] url: The url of the git repository or account/organization
        :param pulumi.Input[str] url_type: The type of git url being used. Options are `ACCOUNT`, and `REPO.`
        :param pulumi.Input[str] branch: The branch of the git connector to use
        :param pulumi.Input['GitConnectorCommitDetailsArgs'] commit_details: Custom details to use when making commits using this git connector
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Delegate selectors to apply to this git connector.
        :param pulumi.Input[bool] generate_webhook_url: Boolean indicating whether or not to generate a webhook url.
        :param pulumi.Input[str] name: Name of the git connector.
        :param pulumi.Input[str] password_secret_id: The id of the secret for connecting to the git repository.
        :param pulumi.Input[str] ssh_setting_id: The id of the SSH secret to use
        :param pulumi.Input[Sequence[pulumi.Input['GitConnectorUsageScopeArgs']]] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
        :param pulumi.Input[str] username: The name of the user used to connect to the git repository
        """
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "url_type", url_type)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit_details is not None:
            pulumi.set(__self__, "commit_details", commit_details)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if generate_webhook_url is not None:
            pulumi.set(__self__, "generate_webhook_url", generate_webhook_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_secret_id is not None:
            pulumi.set(__self__, "password_secret_id", password_secret_id)
        if ssh_setting_id is not None:
            pulumi.set(__self__, "ssh_setting_id", ssh_setting_id)
        if usage_scopes is not None:
            pulumi.set(__self__, "usage_scopes", usage_scopes)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The url of the git repository or account/organization
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="urlType")
    def url_type(self) -> pulumi.Input[str]:
        """
        The type of git url being used. Options are `ACCOUNT`, and `REPO.`
        """
        return pulumi.get(self, "url_type")

    @url_type.setter
    def url_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "url_type", value)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The branch of the git connector to use
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="commitDetails")
    def commit_details(self) -> Optional[pulumi.Input['GitConnectorCommitDetailsArgs']]:
        """
        Custom details to use when making commits using this git connector
        """
        return pulumi.get(self, "commit_details")

    @commit_details.setter
    def commit_details(self, value: Optional[pulumi.Input['GitConnectorCommitDetailsArgs']]):
        pulumi.set(self, "commit_details", value)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Delegate selectors to apply to this git connector.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter(name="generateWebhookUrl")
    def generate_webhook_url(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether or not to generate a webhook url.
        """
        return pulumi.get(self, "generate_webhook_url")

    @generate_webhook_url.setter
    def generate_webhook_url(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_webhook_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the git connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the secret for connecting to the git repository.
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_id", value)

    @property
    @pulumi.getter(name="sshSettingId")
    def ssh_setting_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the SSH secret to use
        """
        return pulumi.get(self, "ssh_setting_id")

    @ssh_setting_id.setter
    def ssh_setting_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_setting_id", value)

    @property
    @pulumi.getter(name="usageScopes")
    def usage_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitConnectorUsageScopeArgs']]]]:
        """
        This block is used for scoping the resource to a specific set of applications or environments.
        """
        return pulumi.get(self, "usage_scopes")

    @usage_scopes.setter
    def usage_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitConnectorUsageScopeArgs']]]]):
        pulumi.set(self, "usage_scopes", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user used to connect to the git repository
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _GitConnectorState:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 commit_details: Optional[pulumi.Input['GitConnectorCommitDetailsArgs']] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 generate_webhook_url: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 ssh_setting_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 url_type: Optional[pulumi.Input[str]] = None,
                 usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['GitConnectorUsageScopeArgs']]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 webhook_url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GitConnector resources.
        :param pulumi.Input[str] branch: The branch of the git connector to use
        :param pulumi.Input['GitConnectorCommitDetailsArgs'] commit_details: Custom details to use when making commits using this git connector
        :param pulumi.Input[str] created_at: The time the git connector was created
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Delegate selectors to apply to this git connector.
        :param pulumi.Input[bool] generate_webhook_url: Boolean indicating whether or not to generate a webhook url.
        :param pulumi.Input[str] name: Name of the git connector.
        :param pulumi.Input[str] password_secret_id: The id of the secret for connecting to the git repository.
        :param pulumi.Input[str] ssh_setting_id: The id of the SSH secret to use
        :param pulumi.Input[str] url: The url of the git repository or account/organization
        :param pulumi.Input[str] url_type: The type of git url being used. Options are `ACCOUNT`, and `REPO.`
        :param pulumi.Input[Sequence[pulumi.Input['GitConnectorUsageScopeArgs']]] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
        :param pulumi.Input[str] username: The name of the user used to connect to the git repository
        :param pulumi.Input[str] webhook_url: The generated webhook url
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit_details is not None:
            pulumi.set(__self__, "commit_details", commit_details)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if generate_webhook_url is not None:
            pulumi.set(__self__, "generate_webhook_url", generate_webhook_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_secret_id is not None:
            pulumi.set(__self__, "password_secret_id", password_secret_id)
        if ssh_setting_id is not None:
            pulumi.set(__self__, "ssh_setting_id", ssh_setting_id)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if url_type is not None:
            pulumi.set(__self__, "url_type", url_type)
        if usage_scopes is not None:
            pulumi.set(__self__, "usage_scopes", usage_scopes)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if webhook_url is not None:
            pulumi.set(__self__, "webhook_url", webhook_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The branch of the git connector to use
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="commitDetails")
    def commit_details(self) -> Optional[pulumi.Input['GitConnectorCommitDetailsArgs']]:
        """
        Custom details to use when making commits using this git connector
        """
        return pulumi.get(self, "commit_details")

    @commit_details.setter
    def commit_details(self, value: Optional[pulumi.Input['GitConnectorCommitDetailsArgs']]):
        pulumi.set(self, "commit_details", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The time the git connector was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Delegate selectors to apply to this git connector.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter(name="generateWebhookUrl")
    def generate_webhook_url(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether or not to generate a webhook url.
        """
        return pulumi.get(self, "generate_webhook_url")

    @generate_webhook_url.setter
    def generate_webhook_url(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_webhook_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the git connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the secret for connecting to the git repository.
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_id", value)

    @property
    @pulumi.getter(name="sshSettingId")
    def ssh_setting_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the SSH secret to use
        """
        return pulumi.get(self, "ssh_setting_id")

    @ssh_setting_id.setter
    def ssh_setting_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_setting_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The url of the git repository or account/organization
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="urlType")
    def url_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of git url being used. Options are `ACCOUNT`, and `REPO.`
        """
        return pulumi.get(self, "url_type")

    @url_type.setter
    def url_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_type", value)

    @property
    @pulumi.getter(name="usageScopes")
    def usage_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitConnectorUsageScopeArgs']]]]:
        """
        This block is used for scoping the resource to a specific set of applications or environments.
        """
        return pulumi.get(self, "usage_scopes")

    @usage_scopes.setter
    def usage_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitConnectorUsageScopeArgs']]]]):
        pulumi.set(self, "usage_scopes", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user used to connect to the git repository
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> Optional[pulumi.Input[str]]:
        """
        The generated webhook url
        """
        return pulumi.get(self, "webhook_url")

    @webhook_url.setter
    def webhook_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook_url", value)


class GitConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[str]] = None,
                 commit_details: Optional[pulumi.Input[pulumi.InputType['GitConnectorCommitDetailsArgs']]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 generate_webhook_url: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 ssh_setting_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 url_type: Optional[pulumi.Input[str]] = None,
                 usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitConnectorUsageScopeArgs']]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for creating a git connector

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness
        import pulumi_harness as harness

        default = harness.get_secret_manager(default=True)
        example_encrypted_text = harness.EncryptedText("exampleEncryptedText",
            value="foo",
            secret_manager_id=default.id)
        example_git_connector = harness.GitConnector("exampleGitConnector",
            url="https://github.com/harness/terraform-provider-harness",
            branch="master",
            generate_webhook_url=True,
            password_secret_id=example_encrypted_text.id,
            url_type="REPO",
            username="someuser")
        ```

        ## Import

        # Import using the Harness git connector id

        ```sh
         $ pulumi import harness:index/gitConnector:GitConnector example <connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: The branch of the git connector to use
        :param pulumi.Input[pulumi.InputType['GitConnectorCommitDetailsArgs']] commit_details: Custom details to use when making commits using this git connector
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Delegate selectors to apply to this git connector.
        :param pulumi.Input[bool] generate_webhook_url: Boolean indicating whether or not to generate a webhook url.
        :param pulumi.Input[str] name: Name of the git connector.
        :param pulumi.Input[str] password_secret_id: The id of the secret for connecting to the git repository.
        :param pulumi.Input[str] ssh_setting_id: The id of the SSH secret to use
        :param pulumi.Input[str] url: The url of the git repository or account/organization
        :param pulumi.Input[str] url_type: The type of git url being used. Options are `ACCOUNT`, and `REPO.`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitConnectorUsageScopeArgs']]]] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
        :param pulumi.Input[str] username: The name of the user used to connect to the git repository
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a git connector

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_harness as harness
        import pulumi_harness as harness

        default = harness.get_secret_manager(default=True)
        example_encrypted_text = harness.EncryptedText("exampleEncryptedText",
            value="foo",
            secret_manager_id=default.id)
        example_git_connector = harness.GitConnector("exampleGitConnector",
            url="https://github.com/harness/terraform-provider-harness",
            branch="master",
            generate_webhook_url=True,
            password_secret_id=example_encrypted_text.id,
            url_type="REPO",
            username="someuser")
        ```

        ## Import

        # Import using the Harness git connector id

        ```sh
         $ pulumi import harness:index/gitConnector:GitConnector example <connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param GitConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[str]] = None,
                 commit_details: Optional[pulumi.Input[pulumi.InputType['GitConnectorCommitDetailsArgs']]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 generate_webhook_url: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 ssh_setting_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 url_type: Optional[pulumi.Input[str]] = None,
                 usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitConnectorUsageScopeArgs']]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitConnectorArgs.__new__(GitConnectorArgs)

            __props__.__dict__["branch"] = branch
            __props__.__dict__["commit_details"] = commit_details
            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["generate_webhook_url"] = generate_webhook_url
            __props__.__dict__["name"] = name
            __props__.__dict__["password_secret_id"] = password_secret_id
            __props__.__dict__["ssh_setting_id"] = ssh_setting_id
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            if url_type is None and not opts.urn:
                raise TypeError("Missing required property 'url_type'")
            __props__.__dict__["url_type"] = url_type
            __props__.__dict__["usage_scopes"] = usage_scopes
            __props__.__dict__["username"] = username
            __props__.__dict__["created_at"] = None
            __props__.__dict__["webhook_url"] = None
        super(GitConnector, __self__).__init__(
            'harness:index/gitConnector:GitConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch: Optional[pulumi.Input[str]] = None,
            commit_details: Optional[pulumi.Input[pulumi.InputType['GitConnectorCommitDetailsArgs']]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            generate_webhook_url: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password_secret_id: Optional[pulumi.Input[str]] = None,
            ssh_setting_id: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            url_type: Optional[pulumi.Input[str]] = None,
            usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitConnectorUsageScopeArgs']]]]] = None,
            username: Optional[pulumi.Input[str]] = None,
            webhook_url: Optional[pulumi.Input[str]] = None) -> 'GitConnector':
        """
        Get an existing GitConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: The branch of the git connector to use
        :param pulumi.Input[pulumi.InputType['GitConnectorCommitDetailsArgs']] commit_details: Custom details to use when making commits using this git connector
        :param pulumi.Input[str] created_at: The time the git connector was created
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Delegate selectors to apply to this git connector.
        :param pulumi.Input[bool] generate_webhook_url: Boolean indicating whether or not to generate a webhook url.
        :param pulumi.Input[str] name: Name of the git connector.
        :param pulumi.Input[str] password_secret_id: The id of the secret for connecting to the git repository.
        :param pulumi.Input[str] ssh_setting_id: The id of the SSH secret to use
        :param pulumi.Input[str] url: The url of the git repository or account/organization
        :param pulumi.Input[str] url_type: The type of git url being used. Options are `ACCOUNT`, and `REPO.`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitConnectorUsageScopeArgs']]]] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
        :param pulumi.Input[str] username: The name of the user used to connect to the git repository
        :param pulumi.Input[str] webhook_url: The generated webhook url
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitConnectorState.__new__(_GitConnectorState)

        __props__.__dict__["branch"] = branch
        __props__.__dict__["commit_details"] = commit_details
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["generate_webhook_url"] = generate_webhook_url
        __props__.__dict__["name"] = name
        __props__.__dict__["password_secret_id"] = password_secret_id
        __props__.__dict__["ssh_setting_id"] = ssh_setting_id
        __props__.__dict__["url"] = url
        __props__.__dict__["url_type"] = url_type
        __props__.__dict__["usage_scopes"] = usage_scopes
        __props__.__dict__["username"] = username
        __props__.__dict__["webhook_url"] = webhook_url
        return GitConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def branch(self) -> pulumi.Output[Optional[str]]:
        """
        The branch of the git connector to use
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="commitDetails")
    def commit_details(self) -> pulumi.Output[Optional['outputs.GitConnectorCommitDetails']]:
        """
        Custom details to use when making commits using this git connector
        """
        return pulumi.get(self, "commit_details")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The time the git connector was created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Delegate selectors to apply to this git connector.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter(name="generateWebhookUrl")
    def generate_webhook_url(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean indicating whether or not to generate a webhook url.
        """
        return pulumi.get(self, "generate_webhook_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the git connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the secret for connecting to the git repository.
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="sshSettingId")
    def ssh_setting_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the SSH secret to use
        """
        return pulumi.get(self, "ssh_setting_id")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The url of the git repository or account/organization
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="urlType")
    def url_type(self) -> pulumi.Output[str]:
        """
        The type of git url being used. Options are `ACCOUNT`, and `REPO.`
        """
        return pulumi.get(self, "url_type")

    @property
    @pulumi.getter(name="usageScopes")
    def usage_scopes(self) -> pulumi.Output[Optional[Sequence['outputs.GitConnectorUsageScope']]]:
        """
        This block is used for scoping the resource to a specific set of applications or environments.
        """
        return pulumi.get(self, "usage_scopes")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the user used to connect to the git repository
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> pulumi.Output[str]:
        """
        The generated webhook url
        """
        return pulumi.get(self, "webhook_url")

