from app.internal.config import settings
from app.utils.constants.settings import App
from jaanca_chronometer import Chronometer
from logyca_azure_storage_blob import (
        AzureStorageAccountBlobManagement,
        SetCredentialsConnectionString,
    )
import os

asabm=AzureStorageAccountBlobManagement(SetCredentialsConnectionString(connection_string=settings.connection_string))
print("\n.")

chronometer=Chronometer()

file='upload.txt'
folder_local_full_path=os.path.abspath(os.path.join(os.path.dirname(__file__),'files'))
file_new_name='upload_renamed_with_properties.txt'

chronometer.start()
status=asabm.container_blob_upload_data_transfer_options(
        folder_local_full_path,
        file,
        App.AzureStorageAccount.Containers.NAME_WITH_DATA,
        add_file_properties_to_metadata=True,
        max_concurrency=2,
        verify_file_integrity=True,
        file_new_name=file_new_name,
    )
chronometer.stop()
print("Container:[{}]".format(App.AzureStorageAccount.Containers.NAME_WITH_DATA))
if status is True:
    print("blob:[{}] uploaded with timestamp file properties...".format(os.path.join(folder_local_full_path,file)))
    print(f"Elapsed time: {chronometer.get_elapsed_time()}")
else:
    print(f"Error = {status}")
