/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.version.LicenseType;
import net.sourceforge.plantuml.version.PLSSignature;
import net.sourceforge.plantuml.version.PSystemVersion;

public class LicenseInfo {
    private static final Preferences prefs = Preferences.userNodeForPackage(LicenseInfo.class);
    public static final LicenseInfo NONE = new LicenseInfo(LicenseType.NONE, 0L, 0L, null, null, null);
    private final LicenseType type;
    private final long generationDate;
    private final long expirationDate;
    private final String owner;
    private final String context;
    private final byte[] sha;
    private static LicenseInfo cache;

    public LicenseInfo(LicenseType type, long generationDate, long expirationDate, String owner, String context, byte[] sha) {
        this.type = type;
        this.generationDate = generationDate;
        this.expirationDate = expirationDate;
        this.owner = owner;
        this.context = context;
        this.sha = sha;
    }

    public static void persistMe(String key) throws BackingStoreException {
        prefs.sync();
        prefs.put("license", key);
    }

    public static synchronized LicenseInfo retrieveQuick() {
        if (cache == null) {
            cache = LicenseInfo.retrieveDistributor();
        }
        if (cache == null) {
            cache = LicenseInfo.retrieveNamedSlow();
        }
        return cache;
    }

    public static boolean retrieveNamedOrDistributorQuickIsValid() {
        return LicenseInfo.retrieveQuick().isValid();
    }

    public static synchronized LicenseInfo retrieveNamedSlow() {
        cache = NONE;
        if (!OptionFlags.ALLOW_INCLUDE) {
            return cache;
        }
        String key = prefs.get("license", "");
        if (key.length() > 0 && (cache = LicenseInfo.setIfValid(LicenseInfo.retrieveNamed(key), cache)).isValid()) {
            return cache;
        }
        for (SFile f : LicenseInfo.fileCandidates()) {
            try {
                if (!f.exists() || !f.canRead()) continue;
                LicenseInfo result = LicenseInfo.retrieve(f);
                if (result == null) {
                    return null;
                }
                if (!(cache = LicenseInfo.setIfValid(result, cache)).isValid()) continue;
                return cache;
            }
            catch (IOException e) {
                Log.info("Error " + e);
            }
        }
        return cache;
    }

    public static LicenseInfo retrieveNamed(String key) {
        if (key.length() > 99 && key.matches("^[0-9a-z]+$")) {
            try {
                String sig = SignatureUtils.toHexString(PLSSignature.signature());
                return PLSSignature.retrieveNamed(sig, key, true);
            }
            catch (Exception e) {
                Log.info("Error retrieving license info" + e);
            }
        }
        return NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage retrieveDistributorImage(LicenseInfo licenseInfo) {
        BufferedImage bufferedImage;
        if (licenseInfo.getLicenseType() != LicenseType.DISTRIBUTOR) {
            return null;
        }
        byte[] s1 = PLSSignature.retrieveDistributorImageSignature();
        if (!SignatureUtils.toHexString(s1).equals(SignatureUtils.toHexString(licenseInfo.sha))) {
            return null;
        }
        InputStream dis = PSystemVersion.class.getResourceAsStream("/distributor.png");
        if (dis == null) {
            return null;
        }
        try {
            BufferedImage result;
            bufferedImage = result = SImageIO.read(dis);
        }
        catch (Throwable throwable) {
            try {
                dis.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        dis.close();
        return bufferedImage;
    }

    public static LicenseInfo retrieveDistributor() {
        InputStream dis = PSystemVersion.class.getResourceAsStream("/distributor.txt");
        if (dis == null) {
            return null;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            String licenseString = br.readLine();
            br.close();
            LicenseInfo result = PLSSignature.retrieveDistributor(licenseString);
            Throwable creationPoint = new Throwable();
            creationPoint.fillInStackTrace();
            for (StackTraceElement ste : creationPoint.getStackTrace()) {
                if (!ste.toString().contains(result.context)) continue;
                return result;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Collection<SFile> fileCandidates() {
        String[] classpathEntries;
        TreeSet<SFile> result = new TreeSet<SFile>();
        String classpath = System.getProperty("java.class.path");
        for (String s : classpathEntries = classpath.split(SFile.pathSeparator)) {
            if (s == null) continue;
            SFile dir = new SFile(s);
            if (dir.isFile()) {
                dir = dir.getParentFile();
            }
            if (dir == null || !dir.isDirectory()) continue;
            result.add(dir.file("license.txt"));
        }
        return result;
    }

    private static LicenseInfo setIfValid(LicenseInfo value, LicenseInfo def) {
        if (value.isValid() || def.isNone()) {
            return value;
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LicenseInfo retrieve(SFile f) throws IOException {
        BufferedReader br = f.openBufferedReader();
        if (br == null) {
            return null;
        }
        try {
            String s = br.readLine();
            LicenseInfo result = LicenseInfo.retrieveNamed(s);
            if (result != null) {
                Log.info("Reading license from " + f.getAbsolutePath());
            }
            LicenseInfo licenseInfo = result;
            return licenseInfo;
        }
        finally {
            br.close();
        }
    }

    public static void main(String[] args) {
        LicenseInfo info = LicenseInfo.retrieveNamedSlow();
        System.err.println("valid=" + info.isValid());
        System.err.println("info=" + info.owner);
    }

    public final Date getGenerationDate() {
        return new Date(this.generationDate);
    }

    public final Date getExpirationDate() {
        return new Date(this.expirationDate);
    }

    public final String getOwner() {
        return this.owner;
    }

    public boolean isNone() {
        return this.owner == null;
    }

    public boolean isValid() {
        return this.owner != null && System.currentTimeMillis() <= this.expirationDate;
    }

    public boolean hasExpired() {
        return this.owner != null && System.currentTimeMillis() > this.expirationDate;
    }

    public final LicenseType getLicenseType() {
        return this.type;
    }

    public final String getContext() {
        return this.context;
    }
}

