PyDitz -- a distributed issue tracker
=====================================

[![builds.sr.ht status](https://builds.sr.ht/~zondo/pyditz.svg)](https://builds.sr.ht/~zondo/pyditz?)

Introduction
------------

This package is intended to be a drop-in replacement for the
[Ditz](http://rubygems.org/gems/ditz) distributed issue tracker.  It
provides a `pyditz` command-line program, which acts (mostly) the same way
as `ditz`, and it adds several other nice things too:

- Whereas `ditz`, when typed on its own, runs the `todo` command, `pyditz`
  drops you into a command shell where you can run Ditz commands and get
  completion on command names, issue names and release names according to
  context.

- With PyDitz, you don't have to run it from the same directory where the
  issue database is; it will look in parent directories for it.

- It keeps an intelligent cache of issues, so parsing of all the YAML files
  isn't necessary for each command.  This greatly improves speed when you
  have lots of issues.

- You can extend PyDitz using plugins that you write: either simple
  standalone files (similar to the `ditz` 'hook' feature), or packages that
  use [setuptools](http://pythonhosted.org/setuptools) entrypoints.

- You can use the database engine of PyDitz in Python programs to migrate
  bug databases to and from Ditz format, or create summary reports in your
  own favourite format.

Requirements
------------

To install and run it:

* [PyYAML](https://pypi.python.org/pypi/PyYAML)
* [Jinja2](http://jinja.pocoo.org)
* [Cerberus](https://pypi.python.org/pypi/cerberus)
* [six](https://pypi.python.org/pypi/six)

To have nice terminal highlighting output:

* [Pygments](https://pypi.python.org/pypi/Pygments)
* [colorama](https://pypi.python.org/pypi/colorama) if you're on Windows

To mark up description and comment text in HTML output:

* [Markups](https://pypi.python.org/pypi/Markups) (and the modules it needs
  to function)

To run the test suite:

* [PyTest](https://pypi.python.org/pypi/pytest)
* [Mock](https://pypi.python.org/pypi/pytest-mock)

To build the documentation:

* [Sphinx](http://sphinx.pocoo.org)
* The [alabaster](https://pypi.python.org/pypi/alabaster) theme

Installation
------------

The usual incantation will install things:

    pip install pyditz

This will install the `ditz` module and a console command called `pyditz`
to invoke in a similar manner to the original `ditz`.  As a convenience to
reduce typing, a short-form version of the command is also installed: `pd`.

Documentation
-------------

The current documentation can be found online
[here](https://pythonhosted.org/pyditz).  You can also look at an example
of the [HTML output](https://pythonhosted.org/pyditz/_static/index.html).

License
-------

PyDitz is distributed under the [GNU Lesser General Public License,
v2](http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html) or later.

Links
-----

If you like this, here's a few more things you might want to check out:

- [Pitz](https://github.com/mw44118/pitz) is another Ditz-alike issue
  tracker, also written in Python.  Its bug database is not compatible with
  Ditz, and I didn't have much luck getting it to work, but it might work
  for you.

- There's another Python project of the same name called
  [akaihola-pyditz](https://github.com/akaihola/pyditz).  (I only found it
  after publishing mine, or I might have chosen another name.)  Not updated
  since 2009, but it has some ideas for logging work that might be useful.

- There's also [ditz plus plus](http://sourceforge.net/projects/ditz),
  another reimplemenation written in C++, although that hasn't been
  updated since mid-2013.

- If you're a fan of [GNU Emacs](https://www.gnu.org/software/emacs),
  there's a [ditz-mode](https://hg.sr.ht/~zondo/ditz-mode) written for it
  that I maintain.  It works with the original Ditz, or PyDitz.

Changes
-------

### Version 0.11 (2020-05-29)

* bugfix: Fix up a few I/O problems
* bugfix: Problem with --no-search option
* bugfix: IPython doesn't work as a plugin
* bugfix: Session generation doesn't work with Py3
* Add a standard short alias command
* Refactor the write_yaml() function
* Improve startup time
* Sort exported releases by version

### Version 0.10.3 (2019-01-11)

* bugfix: Fix highlighting customization

### Version 0.10.2 (2018-08-31)

* bugfix: Resolve problems with cerberus update
* bugfix: Resolve problems with markups update

### Version 0.10.1 (2017-07-31)

* bugfix: Crash when trying to create db

### Version 0.10 (2016-11-27)

* Improve startup operations
* Allow abbreviation of issue names
* Sort issues by last-modified time
* Implement issue-claiming commands
* Use cerberus for data validation

### Version 0.9.1 (2016-03-24)

* bugfix: Line wrapping problem in terminal
* bugfix: Fix problems with version detection
* Minor package improvements

### Version 0.9 (2015-09-27)

* bugfix: Bytes output if pygments is not installed
* bugfix: Initialization command doesn't work
* Implement the 'edit' command
* Implement command plugins
* Add support for markup in HTML output
* Allow per-project config file
* New command to list all issues
* Add project file to version control
* Add validation schemas
* Search more fields with grep

### Version 0.8.1 (2015-08-18)

* bugfix: Fix non-ASCII text in issue data
* bugfix: HTML plugin load failure

### Version 0.8 (2014-12-05)

* bugfix: Grep arguments not handled correctly
* Allow customization of HTML output
* Allow issues to be specified by ID
* Add progress time indicator to 'show' and HTML
* Implement exporting directly to archive
* Add section arg to config command
* Add exporter plugin system
* Add python 3 support
* Improve the default HTML style
* Move ~/.ditzrc to ~/.ditz/ditz.cfg
* Relicense under LGPL

### Version 0.7 (2014-09-28)

* bugfix: Handle YAML comment char in strings
* Add VCS support
* Add unicode support
* Add issue type column to HTML output
* Add command to display configuration
* Implement the 'validate' command
* Add output highlighting
* Add support for command aliases
* Add pager support
* Improve the documentation
* Wire up the remaining program options
* Improve configuration settings
* Improve logging command output

### Version 0.6.2 (2014-08-10)

* bugfix: Name substitution not done in issue description

### Version 0.6.1 (2014-08-09)

* bugfix: Print message on successful unassignment
* bugfix: Ignore unreleased releases when assigning issues

### Version 0.6 (2014-03-28)

* bugfix: Handle non-ASCII characters when writing output
* Install as 'ditz' if required by user
* Add HTML component column if multiple components in use
* Don't show HTML release column for unassigned issues
* Print message on successful issue assignment

### Version 0.5.2 (2013-12-20)

* bugfix: Blank lines shouldn't end a comment

### Version 0.5.1 (2013-12-18)

* bugfix: Prompt for component when creating issues
* bugfix: Show issue status even if not closed

### Version 0.5 (2013-12-12)

* bugfix: Issue names not replaced in comment text
* bugfix: Reconfigure clobbers existing file
* Add sortable tables to HTML output
* Write some user documentation
* Add a user config file

### Version 0.4 (2013-12-09)

* Implement the 'html' command

### Version 0.3 (2013-11-23)

* bugfix: Multiple 'issuedir' keywords in init

### Version 0.2 (2013-11-23)

* bugfix: Fix up problems with blank comments

### Version 0.1 (2013-11-23)

* bugfix: Fix round-tripping of issue files
* Implement all the ditz commands
