# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_process.ipynb (unless otherwise specified).

__all__ = ['multi_thread']

# Cell
import mmcv
def multi_thread(fn, array_inputs, max_workers=None, desc="Multi-thread Pipeline", unit="Samples", verbose=True):
    from concurrent.futures import ThreadPoolExecutor
    from functools import partial
    from glob import glob
    from multiprocessing import Pool
    from tqdm import tqdm

    def _wraper(x):
        i, input = x
        return {i: fn(input)}

    array_inputs = [(i, _) for i, _ in enumerate(array_inputs)]
    if verbose:
        progress_bar = mmcv.utils.ProgressBar(len(array_inputs))
    outputs = {}
    with ThreadPoolExecutor(max_workers=max_workers) as executor:
        for result in executor.map(_wraper, array_inputs):
            outputs.update(result)
            if verbose:
                progress_bar.update()
    if verbose:
        print('Finished')
    outputs = list(outputs.values())
    return outputs
