from __future__ import annotations
from ._pure import *
from ..structure import TypeInterp
from typing import Iterable, Self

class Symbol:
    def name(self) -> str: ...
    def __str__(self) -> str: ...
class CustomSymbol(Symbol):
    def vocab(self) -> "Vocabulary": ...
class BuiltinBool(Symbol): ...
class BuiltinInt(Symbol): ...
class BuiltinReal(Symbol): ...
class IntType(CustomSymbol): ...
class RealType(CustomSymbol): ...
class StrType(CustomSymbol): ...
class Pfunc(CustomSymbol): ...

class TypeIter:
    def __iter__(self) -> Self: ...
    def __next__(self) -> CustomType: ...
    def vocab(self) -> "Vocabulary": ...

class PfuncIter:
    def __iter__(self) -> Self: ...
    def __next__(self) -> Pfunc: ...
    def vocab(self) -> "Vocabulary": ...

class Real:
    def __init__(self, value: int | float | str): ...
    def __add__(self, other: Self) -> Self: ...
    def __sub__(self, other: Self) -> Self: ...
    def __mul__(self, other: Self) -> Self: ...
    def __div__(self, other: Self) -> Self: ...
    def __mod__(self, other: Self) -> Self: ...
    def __float__(self) -> float: ...


class Vocabulary:
    def __init__(self, name: str): ...
    def name(self) -> str: ...
    def parse(self, decls: str) -> Self: ...
    def add_type(self, name: str, super_set: ExtType | None = None) -> None: ...
    def add_voc_type_interp(self, type: ExtCustomType, interp: TypeInterp) -> None: ...
    def parse_type(self, value: str) -> Type: ...
    def parse_pfunc(self, value: str) -> Pfunc: ...
    def parse_symbol(self, value: str) -> Symbol: ...
    def add_pfunc(
        self, name: str | Iterable[str], domain: Iterable[ExtType], codomain: ExtType
    ) -> None: ...
    def iter_pfuncs(self) -> PfuncIter: ...
    def iter_types(self) -> TypeIter: ...
    def __str__(self) -> str: ...
