from ._pure import *
from ..vocabulary import Real, Pfunc, Vocabulary, ExtType, ExtPfunc
from typing import Iterable, Self, TypeVar, Generic

T = TypeVar("T", bound=TypeElement)

class PfuncInterpIter(Generic[T]):
    "" # workaround for pdoc priority of stub docs picking up docs for Generic[T]
    def __iter__(self) -> Self: ...
    def __next__(self) -> tuple[tuple[TypeElement, ...], T]: ...
    def _py_codomain(self) -> type[T]: ...

class PfuncInterp(Generic[T]):
    ""
    def get(self, *args: ExtTypeElement) -> T | None: ...
    def set(self, args: tuple[ExtTypeElement, ...], value: T | None) -> None: ...
    def set_if_unknown(self, args: tuple[ExtTypeElement, ...], value: T) -> bool: ...
    def set_all_unknown_to_value(self, value: T) -> None: ...
    def any_known(self) -> bool: ...
    def amount_known(self) -> int: ...
    def amount_unknown(self) -> int: ...
    def is_complete(self) -> bool: ...
    def __call__(self, *args: ExtTypeElement) -> T | None: ...
    def decl(self) -> Pfunc: ...
    def vocab(self) -> Vocabulary: ...
    def structure(self) -> "Structure": ...
    def name(self) -> str: ...
    def _py_codomain(self) -> type[T]: ...
    def __str__(self) -> str: ...
    def __iter__(self) -> PfuncInterpIter[T]: ...

class GlobModelPfuncInterpIter(Generic[T]):
    ""
    def __iter__(self) -> Self: ...
    def __next__(self) -> tuple[tuple[TypeElement, ...], T]: ...
    def _py_codomain(self) -> type[T]: ...

class GlobModelPfuncInterp(Generic[T]):
    ""
    def get(self, *args: ExtTypeElement) -> T | None: ...
    def any_known(self) -> bool: ...
    def amount_known(self) -> int: ...
    def amount_unknown(self) -> int: ...
    def is_complete(self) -> bool: ...
    def __call__(self, *args: ExtTypeElement) -> T | None: ...
    def decl(self) -> Pfunc: ...
    def vocab(self) -> Vocabulary: ...
    def glob_model(self) -> "GlobModel": ...
    def name(self) -> str: ...
    def _py_codomain(self) -> type[T]: ...
    def __str__(self) -> str: ...
    def __iter__(self) -> GlobModelPfuncInterpIter[T]: ...

class ModelPfuncInterpIter(Generic[T]):
    ""
    def __iter__(self) -> Self: ...
    def __next__(self) -> tuple[tuple[TypeElement, ...], T]: ...
    def _py_codomain(self) -> type[T]: ...

class ModelPfuncInterp(Generic[T]):
    ""
    def get(self, *args: ExtTypeElement) -> T: ...
    def __call__(self, *args: ExtTypeElement) -> T: ...
    def decl(self) -> Pfunc: ...
    def vocab(self) -> Vocabulary: ...
    def model(self) -> "Model": ...
    def name(self) -> str: ...
    def _py_codomain(self) -> type[T]: ...
    def __str__(self) -> str: ...
    def __iter__(self) -> ModelPfuncInterpIter[T]: ...

class IntInterpIter:
    def __iter__(self) -> Self: ...
    def __next__(self) -> int: ...

class IntInterp:
    def __init__(self, values: Iterable[int] | None=None): ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> IntInterpIter: ...

class RealInterpIter:
    def __iter__(self) -> Self: ...
    def __next__(self) -> Real: ...

class RealInterp:
    def __init__(self, values: Iterable[ExtReal] | None=None): ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> RealInterpIter: ...

class StrInterpIter:
    def __iter__(self) -> Self: ...
    def __next__(self) -> str: ...

class StrInterp:
    def __init__(self, values: Iterable[str] | None=None): ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> StrInterpIter: ...

class Structure:
    def __init__(self, vocabulary: Vocabulary): ...
    def __getitem__(self, name: ExtPfunc) -> PfuncInterp[TypeElement]: ...
    def get_type_interp(self, type: ExtType) -> TypeInterp | None: ...
    def set_type_interp(self, type: ExtType, type_interp: TypeInterp) -> None: ...
    def completed_domain(self) -> bool: ...
    def is_complete(self) -> bool: ...
    def parse(self, decls: str) -> "Structure": ...
    def vocab(self) -> Vocabulary: ...
    def iter_complete(self) -> "CompleteStructureIter": ...
    def __str__(self) -> str: ...

class CompleteStructureIter:
    def enable_skip_infinite(self) -> None: ...
    def disable_skip_infinite(self) -> None: ...
    def skip_infinite(self, skip: bool) -> None: ...
    def __iter__(self) -> Self: ...
    def __next__(self) -> Structure: ...

class GlobModel:
    def __getitem__(self, pfunc: ExtPfunc) -> GlobModelPfuncInterp[TypeElement]: ...
    def vocab(self) -> Vocabulary: ...
    def __str__(self) -> str: ...
    def iter_models(self) -> "CompleteModelIter": ...
    def into_structure(self) -> Structure: ...

class CompleteModelIter:
    def enable_skip_infinite(self) -> None: ...
    def disable_skip_infinite(self) -> None: ...
    def skip_infinite(self, skip: bool) -> None: ...
    def __iter__(self) -> Self: ...
    def __next__(self) -> "Model": ...

class Model:
    def __getitem__(self, pfunc: ExtPfunc) -> ModelPfuncInterp[TypeElement]: ...
    def vocab(self) -> Vocabulary: ...
    def __str__(self) -> str: ...
    def into_structure(self) -> Structure: ...
