# flake8: noqa

WEIGHTS_DICT = {
    "mobilenet_v2": {
        "imagenet": "https://download.pytorch.org/models/mobilenet_v2-b0353104.pth"
    },
    "mnasnet0_5": {
        "imagenet": "https://download.pytorch.org/models/mnasnet0.5_top1_67.823-3ffadce67e.pth",
    },
    "mnasnet0_75": {
        "imagenet": None,
    },
    "mnasnet1_0": {
        "imagenet": "https://download.pytorch.org/models/mnasnet1.0_top1_73.512-f206786ef8.pth",
    },
    "mnasnet1_3": {
        "imagenet": None,
    },
    "vgg11": {
        "imagenet": "https://download.pytorch.org/models/vgg11-bbd30ac9.pth",
    },
    "vgg13": {
        "imagenet": "https://download.pytorch.org/models/vgg13-c768596a.pth",
    },
    "vgg16": {
        "imagenet": "https://download.pytorch.org/models/vgg16-397923af.pth",
    },
    "vgg19": {
        "imagenet": "https://download.pytorch.org/models/vgg19-dcbb9e9d.pth",
    },
    "resnet18": {
        "imagenet": "https://download.pytorch.org/models/resnet18-5c106cde.pth",
        "ssl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_supervised_resnet18-d92f0530.pth",
        "swsl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_weakly_supervised_resnet18-118f1556.pth",
    },
    "resnet34": {
        "imagenet": "https://download.pytorch.org/models/resnet34-333f7ec4.pth",
    },
    "resnet50": {
        "imagenet": "https://download.pytorch.org/models/resnet50-19c8e357.pth",
        "ssl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_supervised_resnet50-08389792.pth",
        "swsl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_weakly_supervised_resnet50-16a12f1b.pth",
        "svaw-800": "https://dl.fbaipublicfiles.com/deepcluster/swav_800ep_pretrain.pth.tar",
        "deepcluster-v2-800": "https://dl.fbaipublicfiles.com/deepcluster/deepclusterv2_800ep_pretrain.pth.tar",
        "sela-v2-400": "https://dl.fbaipublicfiles.com/deepcluster/selav2_400ep_pretrain.pth.tar",
    },
    "resnet101": {
        "imagenet": "https://download.pytorch.org/models/resnet101-5d3b4d8f.pth",
    },
    "resnet152": {
        "imagenet": "https://download.pytorch.org/models/resnet152-b121ed2d.pth",
    },
    "resnext50_32x4d": {
        "imagenet": "https://download.pytorch.org/models/resnext50_32x4d-7cdf4587.pth",
        "ssl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_supervised_resnext50_32x4-ddb3e555.pth",
        "swsl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_weakly_supervised_resnext50_32x4-72679e44.pth",
    },
    "resnext101_32x4d": {
        "imagenet": "https://download.pytorch.org/models/resnext50_32x4d-7cdf4587.pth",
        "ssl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_supervised_resnext101_32x4-dc43570a.pth",
        "swsl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_weakly_supervised_resnext101_32x4-3f87e46b.pth",
    },
    "resnext101_32x8d": {
        "imagenet": "https://download.pytorch.org/models/resnext101_32x8d-8ba56ff5.pth",
        "instagram": "https://download.pytorch.org/models/ig_resnext101_32x8-c38310e5.pth",
        "ssl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_supervised_resnext101_32x8-2cfe2f8b.pth",
        "swsl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_weakly_supervised_resnext101_32x8-b4712904.pth",
    },
    "resnext101_32x16d": {
        "instagram": "https://download.pytorch.org/models/ig_resnext101_32x16-c6f796b0.pth",
        "ssl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_supervised_resnext101_32x16-15fffa57.pth",
        "swsl": "https://dl.fbaipublicfiles.com/semiweaksupervision/model_files/semi_weakly_supervised_resnext101_32x16-f3559a9c.pth",
    },
    "resnext101_32x32d": {
        "instagram": "https://download.pytorch.org/models/ig_resnext101_32x32-e4b90b00.pth",
    },
    "resnext101_32x48d": {
        "instagram": "https://download.pytorch.org/models/ig_resnext101_32x48-3e41cc8a.pth",
    },
    "wide_resnet50_2": {
        "imagenet": "https://download.pytorch.org/models/wide_resnet50_2-95faca4d.pth",
    },
    "wide_resnet101_2": {
        "imagenet": "https://download.pytorch.org/models/wide_resnet101_2-32ee1156.pth",
    },
}
