[![ko-fi](https://www.ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/G2G81MT0G)


# How to setup the board using only a usb cable

# Beware! If you use this, you just need to have a usb cable plugged in.

Install jumpers and connectors as indicated in the figure below. Jumpers necessary are the white and the green ones. 

![](https://raw.githubusercontent.com/kelu124/echomods/master/include/community/Abdulrhman/unnamed.jpg)


# Installation 

## Preparing Python

Let's install what is required

`pip3 install un0usb`

If you face issues, you can still download the rest of the main modules.

`pip3 install pyftdi matplotlib numpy scipy `

## Installing iceprog to flash the fpga

iceprog is the software used to put the fpga on the flash storage on the board, which will be read by the fpga on boot. The easiest way is to :

`sudo apt install fpga-icestorm`

If this doesn’t work, then this may work:

```
sudo apt-get install libftdi-dev git gcc 
git clone https://github.com/cliffordwolf/icestorm.git
cd iceprog
make 
sudo make install
```

This will create and install the iceprog utility, used to flash the fpga program (bitstream).

## FTDI rules.

*Notes for Linux*: Create a file /etc/udev/rules.d/53-lattice-ftdi.rules with the following line in it to allow uploading bit-streams as unprivileged user:

`ATTRS{idVendor}=="0403", ATTRS{idProduct}=="6014", MODE="0660", GROUP="plugdev", TAG+="uaccess"`

This should solve usb access rules.

## Board specific install files

Download the [install pack](https://github.com/kelu124/un0rick/blob/master/usb/install_pack.zip) or by 

`wget https://github.com/kelu124/un0rick/raw/master/usb/install_pack.zip`


## Connect the usb cable

Check that the FTDI device is well created by typing:

`dmesg`

# Programming it

Unzip it, inside, there's the bin to program the fpga :
 
`iceprog usb.bin`

# Running python

## Test

There is a test bench for the python lib matching the usb firmware, from the `pip` package. Installation is as follows.

```
wget https://github.com/kelu124/python-usb-un0rick/raw/master/usb.bin
iceprog usb.bin 
```

which will flash the board.

## Using the python lib

### Imports

To import the lib:

`import un0usb as USB`

I encourage the reader to go inside [this libs source](https://github.com/kelu124/python-usb-un0rick/tree/master/un0usb), which is already documented.

### Create the device

then connect to the FPGA

```python
# Check the version
USB.__version__
# init FTDI device
fpga = USB.FpgaControl('ftdi://ftdi:2232:/', spi_freq=8E6)
# reload configuration (optional step - just to fill BRAM (DACGAIN registers) with initial values)
fpga.reload()
# reset fpga
fpga.reset()
```
### Run acqs

To play with custom gain and pulse parameters:

```python
fpga.set_pulseform(initDelay=5, POn=16, PInter=16, Poff=5000)
gain = [int(100 + ((1000-100)*x*x*x/32/32/32)) for x in range(32)]
acq_res = fpga.do_acquisition(acq_lines=2, gain=gain, double_rate=True) 
plt.plot(acq_res[0])
```

### Save acqs

```python
# Let's save the previous acquisition
fpga.save("Test") 
# And display it in more details
plot = USB.FView() 
plot.readfile('Test.npz')
```

### Pulser control

To control the waveform, one would set the `fpga.csr.ponw`, `fpga.csr.interw` and `fpga.csr.poffw`, that are respectively integers for setting the width (timing) of the pulse, width of a relaxation period before damping, and then duration of damping. Unit are (1/128us).

The `fpga.csr.initdel` register is the delay between the beginning of the acquisiton and the pulse. 

```
fpga.csr.initdel = InitDel
fpga.csr.ponw = PONWidth
fpga.csr.interw = INTERWidth
fpga.csr.poffw = PDAMP
```

Below is plotted amplitude of an echo as a function of the `fpga.csr.ponw` for a 4MHz transducer. One sees that a setting at `16` provides most

![](https://raw.githubusercontent.com/kelu124/echomods/master/matty/20201031a/amplitude.png)

(See [full experiment here](https://github.com/kelu124/echomods/tree/master/matty/20201031a)).

### Gain and acquisitions

And do acquisitions with `acq_res = fpga.do_acquisition(acq_lines=32, gain=gain, double_rate=True)` which will return an array of `acq_lines` acquisitions, of length 256us at 64Msps.
`double_rate=True` provides a half clock offset to odd lines, so that one can interleave two subsequent acquisition to have, in a fixed setting, a 128Msps acquisition.

The `gain` setting is an array of integers, of length 32, that can range from 0 to 1023, controlling gain for each of the 32 8us-segment of acquisition within the 256us line. 


### Other registers

* `fpga.csr.led3 = 0` sets LED3 off. led1, led2, led3 are possible, can be set to 0 or 1.
* `fpga.csr.topturnX` reads input 1 to 3 on the input header.
* `fpga.csr.jumperX` reads jumper 1 to 3 close to the programming jumper.
* `fpga.csr.outXice` writes/reads output 1 to 3.
* `fpga.csr.nblines = acq_lines - 1` is the register controlling the number of lines acquired.
* `fpga.csr.dacout` reads the DAC/TGC/VGA level outside of acquisitions.
* `fpga.csr.acqstart = 1` to start the acquisition
* `fpga.csr.drmode = int(double_rate)` triggers the interleaving mode.
* `fpga.csr.acqstart = 1` to start the acquisition
* `fpga.csr.acqdone` is equal to 0 during acquisitions.
* `fpga.csr.author` reads the ID of the author of the binary.
* `fpga.csr.version` reads the ID of the author's binary.

# Example of acquisitons

## Raw signal, with DAC

The signal is in blue, the gain levels are in green. Here there are 32 visible steps, of 8us each.
![](https://raw.githubusercontent.com/kelu124/echomods/master/matty/20201103a/Acq%200.png)

## Detail of an echo

![](https://raw.githubusercontent.com/kelu124/echomods/master/matty/20201026a/fpga_ctrl/img/4.png)

## Interleaved acquisiton mode = ON

Doublign acquisition speed (yellow and red dots below)

![](https://raw.githubusercontent.com/kelu124/echomods/master/matty/20201026a/fpga_ctrl/img/6.png)

# License

This work is based on two previous TAPR projects, [the echOmods project](https://github.com/kelu124/echomods/), and the [un0rick project](https://github.com/kelu124/un0rick) - its boards are open hardware and software, developped with open-source elements as much as possible.

Copyright Kelu124 (kelu124@gmail.com) 2020.

* The hardware is licensed under TAPR Open Hardware License (www.tapr.org/OHL)
* The software components are free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
* The documentation is licensed under a [Creative Commons Attribution-ShareAlike 3.0 Unported License](http://creativecommons.org/licenses/by-sa/3.0/).

## Disclaimer

This project is distributed WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING OF MERCHANTABILITY, SATISFACTORY QUALITY AND FITNESS FOR A PARTICULAR PURPOSE. 


# Changelog


* 0.2.7: Solving: Savefile naming issue