[![Build Status](https://travis-ci.org/aiidateam/aiida-metakpg.svg?branch=master)](https://travis-ci.org/aiidateam/aiida-metapkg)
[![PyPI version](https://badge.fury.io/py/aiida.svg)](https://badge.fury.io/py/aiida)

<img src="logos/AiiDA_transparent_logo.png" alt="AiiDA" height="75"/>

**Automated Interactive Infrastructure and Database for Computational
Science**

AiiDA is a sophisticated framework designed from scratch to be a
flexible and scalable infrastructure for computational science. Being
able to store the full data provenance of each simulation, and based on
a tailored database solution built for efficient data mining
implementations, AiiDA gives the user the ability to interact seamlessly
with any number of HPC machines and codes thanks to its flexible plugin
interface, together with a powerful workflow engine for the automation
of simulations.

For instructions on how to install AiiDA, see the [documentation](http://aiida-core.readthedocs.io).

## Metapackage

This repository contains the official **metapackage** of AiiDA, which
serves as a shortcut to install both the core framework alongside a few
useful plugins:

- [aiida-core](https://github.com/aiidateam/aiida_core)
- [aiida-quantumespresso](https://github.com/aiidateam/aiida-quantumespresso)
- [aiida-nwchem](https://github.com/aiidateam/aiida-nwchem)
- [aiida-ase](https://github.com/aiidateam/aiida-ase)
- [aiida-codtools](https://github.com/aiidateam/aiida-codtools)


## How to cite AiiDA

If you use AiiDA in your research, please consider citing the following
work:

> Giovanni Pizzi, Andrea Cepellotti, Riccardo Sabatini, Nicola Marzari,
> and Boris Kozinsky, *AiiDA: automated interactive infrastructure and
> database for computational science*, Comp. Mat. Sci 111, 218-230
> (2016); <https://doi.org/10.1016/j.commatsci.2015.09.013>;
> <http://www.aiida.net>.

## License

The terms of the AiiDA license can be found in the LICENSE.txt file.

## Acknowledgements

This work is supported by the [MARVEL National Centre for Competency in
Research](<http://nccr-marvel.ch>) funded by the [Swiss National
Science Foundation](<http://www.snf.ch/en>), as well as by the [MaX
European Centre of Excellence](<http://www.max-centre.eu/>) funded by
the Horizon 2020 EINFRA-5 program, Grant No. 676598.

<img src="logos/MARVEL.png" alt="MARVEL" height="50"/><img src="logos/MaX.png" alt="MaX" height="50"/>
