"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'my-codepipeline-badge-notification-stack', { env });
        const pipeline = this.createCodePipeline(stack);
        const codePipelineStatus = new index_1.CodePipelineBadgeNotification(stack, 'CodePipelineBadgeNotification', {
            pipelineArn: pipeline.pipelineArn,
            gitHubTokenFromSecretsManager: {
                secretsManagerArn: `arn:aws:secretsmanager:ap-northeast-1:${cdk.Aws.ACCOUNT_ID}:secret:codepipeline/lambda/github-token-YnCnne`,
                secretKey: 'codepipeline/lambda/github-token',
            },
            notification: {
                stageName: 'production',
                // ssmSlackWebHookUrl: 'ssm_slack_webhook',
                ssmGoogleChatWebHookUrl: '/chat/google/webhook',
                ssmTelegramWebHookUrl: '/chat/telegram/webhook',
            },
        });
        new cdk.CfnOutput(stack, 'BadgeUrl', {
            value: codePipelineStatus.badgeUrl,
        });
        new cdk.CfnOutput(stack, 'CodePipelineLink', {
            value: codePipelineStatus.codePipelineLink,
        });
        app.synth();
        this.stack = [stack];
    }
    createCodePipeline(stack) {
        const pipeline = new aws_cdk_lib_1.aws_codepipeline.Pipeline(stack, 'TestPipeline', {
            pipelineName: 'integTestCodePipeline',
            crossAccountKeys: false,
        });
        const sourceOutput = new aws_cdk_lib_1.aws_codepipeline.Artifact();
        pipeline.addStage({
            stageName: 'Source',
            actions: [
                new aws_cdk_lib_1.aws_codepipeline_actions.CodeStarConnectionsSourceAction({
                    actionName: 'GitHub_Source',
                    owner: 'kimisme9386',
                    repo: 'cdk-codepipeline-badge-notification',
                    output: sourceOutput,
                    connectionArn: `arn:aws:codestar-connections:ap-northeast-1:${cdk.Aws.ACCOUNT_ID}:connection/e97c0228-6aee-46df-a0a5-8ddbd3c94679`,
                    variablesNamespace: 'GitHubSourceVariables',
                    branch: 'feature/google-chat-notification',
                    codeBuildCloneOutput: true,
                }),
            ],
        });
        const project = this.createCodeBuildProjectWithinCodePipeline(stack);
        const afterBuildArtifact = new aws_cdk_lib_1.aws_codepipeline.Artifact();
        pipeline.addStage({
            stageName: 'Build',
            actions: [
                new aws_cdk_lib_1.aws_codepipeline_actions.CodeBuildAction({
                    actionName: 'AWS_CodeBuild',
                    input: sourceOutput,
                    project: project,
                    type: aws_cdk_lib_1.aws_codepipeline_actions.CodeBuildActionType.BUILD,
                    outputs: [afterBuildArtifact],
                }),
            ],
        });
        return pipeline;
    }
    createCodeBuildProjectWithinCodePipeline(stack) {
        const project = new aws_cdk_lib_1.aws_codebuild.PipelineProject(stack, 'CodeBuildWithinCodePipeline', {
            buildSpec: aws_cdk_lib_1.aws_codebuild.BuildSpec.fromObject({
                version: '0.2',
                env: {
                    shell: 'bash',
                },
                phases: {
                    build: {
                        'on-failure': 'ABORT',
                        'commands': [
                            'echo "test build"',
                        ],
                    },
                },
                artifacts: {
                    files: 'imagedefinitions.json',
                },
            }),
            environment: {
                buildImage: aws_cdk_lib_1.aws_codebuild.LinuxBuildImage.STANDARD_4_0,
                computeType: aws_cdk_lib_1.aws_codebuild.ComputeType.SMALL,
                privileged: true,
            },
            cache: aws_cdk_lib_1.aws_codebuild.Cache.local(aws_cdk_lib_1.aws_codebuild.LocalCacheMode.DOCKER_LAYER),
        });
        return project;
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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