import { S3OriginConfig } from '@aws-cdk/aws-cloudfront';
import { Construct, RemovalPolicy } from '@aws-cdk/core';
export interface WebsiteBucketProps {
    /**
     * Name of the bucket
     *
     * @default - Assigned by CloudFormation (recommended).
     */
    readonly bucketName?: string;
    /**
     * Policy to apply when the bucket is removed from this stack.
     *
     * @default - The bucket will be orphaned.
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * The source from which to deploy the website
     *
     * @default - Dummy placeholder
     */
    readonly source?: string;
    /**
     * Disable website deployment
     *
     * @default - false
     */
    readonly disableUpload?: boolean;
    /**
     * The index page for the site like 'index.html'
     *
     * @default - index.html
     */
    readonly websiteIndexDocument?: string;
    /**
     *  The error page for the site like 'error.html'
     *
     *  @default - error.html
     */
    readonly websiteErrorDocument?: string;
}
export declare class WebsiteBucket extends Construct {
    readonly s3OriginConfig: S3OriginConfig;
    constructor(scope: Construct, id: string, props?: WebsiteBucketProps);
}
