import { IAliasRecordTarget } from '@aws-cdk/aws-route53';
import { Construct } from '@aws-cdk/core';
export interface WebsiteAliasRecordProps {
    /** The domain name for the site like 'example.com' */
    readonly domainName: string;
    /** Names for the records. */
    readonly recordNames: string[];
    /** Target for the alias record */
    readonly target: IAliasRecordTarget;
    /** We support IPv6 and add an AAAA record by default, but you can turn it off */
    readonly disableIPv6?: boolean;
}
export declare class WebsiteAliasRecord extends Construct {
    constructor(scope: Construct, id: string, props: WebsiteAliasRecordProps);
}
