# coding: utf-8

"""
    farm API

    farm API documentation  # noqa: E501

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from plotrisk_python_client.api_client import ApiClient


class PlotRiskResourceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def download_image_using_get(self, ca_id, _date, image_name, **kwargs):  # noqa: E501
        """downloadImage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_image_using_get(ca_id, _date, image_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ca_id: Unique identifier for plot/CA , e.g. id= 1234 (required)
        :param str _date: Indicates captured satellite date in yyyy-MM-dd format, e.g. date=2022-03-15 (required)
        :param str image_name: Plot image name, e.g imageName = NDRE . (required)
        :param str image_type: Plot image type, e.g imageType = TIFF
        :return: PlotImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_image_using_get_with_http_info(ca_id, _date, image_name, **kwargs)  # noqa: E501
        else:
            (data) = self.download_image_using_get_with_http_info(ca_id, _date, image_name, **kwargs)  # noqa: E501
            return data

    def download_image_using_get_with_http_info(self, ca_id, _date, image_name, **kwargs):  # noqa: E501
        """downloadImage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_image_using_get_with_http_info(ca_id, _date, image_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ca_id: Unique identifier for plot/CA , e.g. id= 1234 (required)
        :param str _date: Indicates captured satellite date in yyyy-MM-dd format, e.g. date=2022-03-15 (required)
        :param str image_name: Plot image name, e.g imageName = NDRE . (required)
        :param str image_type: Plot image type, e.g imageType = TIFF
        :return: PlotImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ca_id', '_date', 'image_name', 'image_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_image_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ca_id' is set
        if ('ca_id' not in params or
                params['ca_id'] is None):
            raise ValueError("Missing the required parameter `ca_id` when calling `download_image_using_get`")  # noqa: E501
        # verify the required parameter '_date' is set
        if ('_date' not in params or
                params['_date'] is None):
            raise ValueError("Missing the required parameter `_date` when calling `download_image_using_get`")  # noqa: E501
        # verify the required parameter 'image_name' is set
        if ('image_name' not in params or
                params['image_name'] is None):
            raise ValueError("Missing the required parameter `image_name` when calling `download_image_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ca_id' in params:
            query_params.append(('caId', params['ca_id']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'image_name' in params:
            query_params.append(('imageName', params['image_name']))  # noqa: E501
        if 'image_type' in params:
            query_params.append(('imageType', params['image_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/plot-risk/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_plots_using_get(self, **kwargs):  # noqa: E501
        """getPlots  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plots_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number of the requested page
        :param Ref size: Size represents the number of records that are displayed when a page loads. Default size is 50.
        :param list[str] sort: Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :return: list[CroppableAreaDtoPlotRisk]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = False
        if kwargs.get('async_req'):
            return self.get_plots_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_plots_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_plots_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getPlots  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plots_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number of the requested page
        :param Ref size: Size represents the number of records that are displayed when a page loads. Default size is 50.
        :param list[str] sort: Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :return: list[CroppableAreaDtoPlotRisk]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'size', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plots_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/plot-risk/plots', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CroppableAreaDtoPlotRisk]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_satellite_using_get(self, **kwargs):  # noqa: E501
        """GetSatellite  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_satellite_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Ref ca_ids: Unique identifiers for plot/CA, e.g. ids=1234,5678
        :param str captured_date_time: Indicates timestamp when satellite insights processed, e.g. date = 2021-12-23T00:00:00Z
        :param str category: Cloud mask parameter.
        :param str max_cloud_coverage: Cloud coverage refers the fraction of sky covered with clouds, filters record where cloudCoverge <= maxCloudCoverage
        :param str min_cloud_coverage: Cloud coverage refers the fraction of sky covered with clouds, filters record where cloudCoverge >= minCloudCoverage
        :param str order_by: Order the result in ascending or descending format. Default order is 'ASC'
        :param Ref page: Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number.
        :param Ref select: Select specific field or fields to return as part of result, e.g select = fieldName 
        :param Ref size: Size represents the number of records that are displayed when a page loads,it can be between 10 to 300. Default size is 50.
        :param list[str] sort: Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :param str sort_by: Sort the result based on given field/fields in natural sorting order (ASC). Maximum 2 fields are allowed.
        :return: SatelliteMetricsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_satellite_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_satellite_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_satellite_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """GetSatellite  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_satellite_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Ref ca_ids: Unique identifiers for plot/CA, e.g. ids=1234,5678
        :param str captured_date_time: Indicates timestamp when satellite insights processed, e.g. date = 2021-12-23T00:00:00Z
        :param str category: Cloud mask parameter.
        :param str max_cloud_coverage: Cloud coverage refers the fraction of sky covered with clouds, filters record where cloudCoverge <= maxCloudCoverage
        :param str min_cloud_coverage: Cloud coverage refers the fraction of sky covered with clouds, filters record where cloudCoverge >= minCloudCoverage
        :param str order_by: Order the result in ascending or descending format. Default order is 'ASC'
        :param Ref page: Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number.
        :param Ref select: Select specific field or fields to return as part of result, e.g select = fieldName 
        :param Ref size: Size represents the number of records that are displayed when a page loads,it can be between 10 to 300. Default size is 50.
        :param list[str] sort: Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :param str sort_by: Sort the result based on given field/fields in natural sorting order (ASC). Maximum 2 fields are allowed.
        :return: SatelliteMetricsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ca_ids', 'captured_date_time', 'category', 'max_cloud_coverage', 'min_cloud_coverage', 'order_by', 'page', 'select', 'size', 'sort', 'sort_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_satellite_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ca_ids' in params:
            query_params.append(('caIds', params['ca_ids']))  # noqa: E501
        if 'captured_date_time' in params:
            query_params.append(('capturedDateTime', params['captured_date_time']))  # noqa: E501
        if 'category' in params:
            query_params.append(('category', params['category']))  # noqa: E501
        if 'max_cloud_coverage' in params:
            query_params.append(('maxCloudCoverage', params['max_cloud_coverage']))  # noqa: E501
        if 'min_cloud_coverage' in params:
            query_params.append(('minCloudCoverage', params['min_cloud_coverage']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'select' in params:
            query_params.append(('select', params['select']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sortBy', params['sort_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/plot-risk/satellite', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_weather_using_get(self, **kwargs):  # noqa: E501
        """getWeather  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_weather_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ca_id: Unique identifier for plot/CA , e.g. id= 1234
        :param str _date: Indicates timestamp when satellite insights processed, e.g. date = 2021-12-23T00:00:00Z
        :param str date_from: Filter records for specific date range e.g. dateFrom = 2021-12-23T00:00:00Z
        :param str date_to: Filter records for specific date range e.g. dateTo = 2021-12-23T00:00:00Z
        :param str order_by: Order the result in ascending or descending format. Default order is 'ASC'
        :param Ref page: Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number.
        :param Ref size: Size represents the number of records that are displayed when a page loads,it can be between 10 to 300. Default size is 50.
        :param list[str] sort: Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :param str sort_by: Sort the result based on given field/fields in natural sorting order (ASC). Maximum 2 fields are allowed.
        :return: WeatherDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_weather_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_weather_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_weather_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getWeather  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_weather_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ca_id: Unique identifier for plot/CA , e.g. id= 1234
        :param str _date: Indicates timestamp when satellite insights processed, e.g. date = 2021-12-23T00:00:00Z
        :param str date_from: Filter records for specific date range e.g. dateFrom = 2021-12-23T00:00:00Z
        :param str date_to: Filter records for specific date range e.g. dateTo = 2021-12-23T00:00:00Z
        :param str order_by: Order the result in ascending or descending format. Default order is 'ASC'
        :param Ref page: Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number.
        :param Ref size: Size represents the number of records that are displayed when a page loads,it can be between 10 to 300. Default size is 50.
        :param list[str] sort: Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :param str sort_by: Sort the result based on given field/fields in natural sorting order (ASC). Maximum 2 fields are allowed.
        :return: WeatherDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ca_id', '_date', 'date_from', 'date_to', 'order_by', 'page', 'size', 'sort', 'sort_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_weather_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ca_id' in params:
            query_params.append(('caId', params['ca_id']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'date_from' in params:
            query_params.append(('dateFrom', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('dateTo', params['date_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sortBy', params['sort_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/plot-risk/weather', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_yield_using_get(self, **kwargs):  # noqa: E501
        """getYield  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_yield_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ca_id: Unique identifier for plot/CA , e.g. id= 1234
        :param str order_by: Order the result in ascending or descending format. Default order is 'ASC'
        :param Ref page: Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number.
        :param Ref size: Size represents the number of records that are displayed when a page loads,it can be between 10 to 300. Default size is 50.
        :param list[str] sort: Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :param str sort_by: Sort the result based on given field/fields in natural sorting order (ASC). Maximum 2 fields are allowed.
        :return: YieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_yield_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_yield_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_yield_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getYield  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_yield_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ca_id: Unique identifier for plot/CA , e.g. id= 1234
        :param str order_by: Order the result in ascending or descending format. Default order is 'ASC'
        :param Ref page: Page represents page no. in a paginated response.Page starts from 0, valid page can be zero or a positive number.
        :param Ref size: Size represents the number of records that are displayed when a page loads,it can be between 10 to 300. Default size is 50.
        :param list[str] sort: Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :param str sort_by: Sort the result based on given field/fields in natural sorting order (ASC). Maximum 2 fields are allowed.
        :return: YieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ca_id', 'order_by', 'page', 'size', 'sort', 'sort_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_yield_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ca_id' in params:
            query_params.append(('caId', params['ca_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sortBy', params['sort_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/plot-risk/yield', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
