def test_parameter_interpolation():
    """
    Test that a parameter with two values can be interpolated.
    """
    from openfisca_core.parameters import ParameterNode

    # Create the parameter

    root = ParameterNode(
        data={
            "a": {
                "description": "Example parameter",
                "values": {
                    "2015-01-01": 1,
                    "2016-01-01": 2,
                },
                "metadata": {"interpolation": {"interval": "month"}},
            }
        }
    )

    from openfisca_tools.parameters import interpolate_parameters

    interpolated = interpolate_parameters(root)

    # Interpolate halfway

    assert interpolated.a("2015-07-01") == 1.5


def test_parameter_uprating():
    from openfisca_core.parameters import ParameterNode

    # Create the parameter

    root = ParameterNode(
        data={
            "to_be_uprated": {
                "description": "Example parameter",
                "values": {
                    "2015-01-01": 1,
                    "2016-01-01": 2,
                },
                "metadata": {
                    "uprating": {
                        "parameter": "uprater",
                    },
                },
            },
            "uprater": {
                "description": "Uprater",
                "values": {
                    "2015-01-01": 1,
                    "2017-01-01": 2,
                    "2018-01-01": 3,
                },
            },
        }
    )

    from openfisca_tools.parameters import uprate_parameters

    interpolated = uprate_parameters(root)

    # Interpolate halfway

    assert interpolated.to_be_uprated("2018-01-01") == 2 * 3
