"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5517
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.storage_net_app_aggregate_event_relationship import StorageNetAppAggregateEventRelationship
    from intersight.model.storage_net_app_node_relationship import StorageNetAppNodeRelationship
    from intersight.model.storage_net_app_performance_metrics_average import StorageNetAppPerformanceMetricsAverage
    globals()['StorageNetAppAggregateEventRelationship'] = StorageNetAppAggregateEventRelationship
    globals()['StorageNetAppNodeRelationship'] = StorageNetAppNodeRelationship
    globals()['StorageNetAppPerformanceMetricsAverage'] = StorageNetAppPerformanceMetricsAverage


class StorageNetAppAggregateAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'STORAGE.NETAPPAGGREGATE': "storage.NetAppAggregate",
        },
        ('object_type',): {
            'STORAGE.NETAPPAGGREGATE': "storage.NetAppAggregate",
        },
        ('aggregate_type',): {
            'HDD': "HDD",
            'HYBRID': "Hybrid",
            'HYBRID_(FLASH_POOL)': "Hybrid (Flash Pool)",
            'SSD': "SSD",
            'SSD_(FABRICPOOL)': "SSD (FabricPool)",
            'VMDISK_(SDS)': "VMDisk (SDS)",
            'VMDISK_(FABRICPOOL)': "VMDisk (FabricPool)",
            'LUN_(FLEXARRAY)': "LUN (FlexArray)",
            'NOT_MAPPED': "Not Mapped",
        },
        ('raid_type',): {
            'UNKNOWN': "Unknown",
            'RAID0': "RAID0",
            'RAID1': "RAID1",
            'RAID4': "RAID4",
            'RAID5': "RAID5",
            'RAID6': "RAID6",
            'RAID10': "RAID10",
            'RAIDDP': "RAIDDP",
            'RAIDTEC': "RAIDTEC",
        },
        ('state',): {
            'UNKNOWN': "Unknown",
            'ONLINE': "Online",
            'ONLINING': "Onlining",
            'OFFLINE': "Offline",
            'OFFLINING': "Offlining",
            'RELOCATING': "Relocating",
            'RESTRICTED': "Restricted",
            'FAILED': "Failed",
            'INCONSISTENT': "Inconsistent",
            'UNMOUNTED': "Unmounted",
        },
    }

    validations = {
        ('uuid',): {
            'regex': {
                'pattern': r'^$|^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$',  # noqa: E501
            },
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'aggregate_type': (str,),  # noqa: E501
            'avg_performance_metrics': (StorageNetAppPerformanceMetricsAverage,),  # noqa: E501
            'key': (str,),  # noqa: E501
            'raid_size': (int,),  # noqa: E501
            'raid_type': (str,),  # noqa: E501
            'state': (str,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
            'array_controller': (StorageNetAppNodeRelationship,),  # noqa: E501
            'events': ([StorageNetAppAggregateEventRelationship], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'aggregate_type': 'AggregateType',  # noqa: E501
        'avg_performance_metrics': 'AvgPerformanceMetrics',  # noqa: E501
        'key': 'Key',  # noqa: E501
        'raid_size': 'RaidSize',  # noqa: E501
        'raid_type': 'RaidType',  # noqa: E501
        'state': 'State',  # noqa: E501
        'uuid': 'Uuid',  # noqa: E501
        'array_controller': 'ArrayController',  # noqa: E501
        'events': 'Events',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """StorageNetAppAggregateAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "storage.NetAppAggregate", must be one of ["storage.NetAppAggregate", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "storage.NetAppAggregate", must be one of ["storage.NetAppAggregate", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            aggregate_type (str): Storage disk type for NetApp aggregate. * `HDD` - Hard Disk Drive disk type. * `Hybrid` - Solid State Hard Disk Drive. * `Hybrid (Flash Pool)` - SSHD in a flash pool disk type. * `SSD` - Solid State Disk disk type. * `SSD (FabricPool)` - SSD in a flash pool disk type. * `VMDisk (SDS)` - Storage disk with Hard disk drive. * `VMDisk (FabricPool)` - Storage disk with Non-volatile random-access memory drives. * `LUN (FlexArray)` - LUN (FlexArray) disk type. * `Not Mapped` - Storage disk is not mapped.. [optional] if omitted the server will use the default value of "HDD"  # noqa: E501
            avg_performance_metrics (StorageNetAppPerformanceMetricsAverage): [optional]  # noqa: E501
            key (str): Unique identifier of NetApp Aggregate across data center.. [optional]  # noqa: E501
            raid_size (int): Size of the RAID group represented by number of disks in the group.. [optional]  # noqa: E501
            raid_type (str): The RAID configuration type. * `Unknown` - Default unknown RAID type. * `RAID0` - RAID0 splits (\"stripes\") data evenly across two or more disks, without parity information. * `RAID1` - RAID1 requires a minimum of two disks to work, and provides data redundancy and failover. * `RAID4` - RAID4 stripes block level data and dedicates a disk to parity. * `RAID5` - RAID5  distributes striping and parity at a block level. * `RAID6` - RAID6 level operates like RAID5 with distributed parity and striping. * `RAID10` - RAID10 requires a minimum of four disks in the array. It stripes across disks for higher performance, and mirrors for redundancy. * `RAIDDP` - RAIDDP uses up to two spare disks to replace and reconstruct the data from up to two simultaneously failed disks within the RAID group. * `RAIDTEC` - With RAIDTEC protection, use up to three spare disks to replace and reconstruct the data from up to three simultaneously failed disks within the RAID group.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            state (str): Current state of the NetApp aggregate. * `Unknown` - Specifies that the aggregate is discovered, but the aggregate information is not yet retrieved by the Unified Manager server. * `Online` - Aggregate is ready and available. * `Onlining` - The state is transitioning online. * `Offline` - Aggregate is unavailable. * `Offlining` - The state is transitioning offline. * `Relocating` - The aggregate is being relocated. * `Restricted` - Limited operations (e.g., parity reconstruction) are allowed, but data access is not allowed. * `Failed` - The aggregate cannot be brought online. * `Inconsistent` - The aggregate has been marked corrupted; contact technical support. * `Unmounted` - The aggregate is not mounted.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            uuid (str): Uuid of  NetApp Aggregate.. [optional]  # noqa: E501
            array_controller (StorageNetAppNodeRelationship): [optional]  # noqa: E501
            events ([StorageNetAppAggregateEventRelationship], none_type): An array of relationships to storageNetAppAggregateEvent resources.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "storage.NetAppAggregate")
        object_type = kwargs.get('object_type', "storage.NetAppAggregate")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
