"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5517
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.hyperflex_cluster_profile_relationship import HyperflexClusterProfileRelationship
    from intersight.model.organization_organization_relationship import OrganizationOrganizationRelationship
    globals()['HyperflexClusterProfileRelationship'] = HyperflexClusterProfileRelationship
    globals()['OrganizationOrganizationRelationship'] = OrganizationOrganizationRelationship


class HyperflexSysConfigPolicyAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'HYPERFLEX.SYSCONFIGPOLICY': "hyperflex.SysConfigPolicy",
        },
        ('object_type',): {
            'HYPERFLEX.SYSCONFIGPOLICY': "hyperflex.SysConfigPolicy",
        },
        ('timezone',): {
            'PACIFIC/NIUE': "Pacific/Niue",
            'PACIFIC/PAGO_PAGO': "Pacific/Pago_Pago",
            'PACIFIC/HONOLULU': "Pacific/Honolulu",
            'PACIFIC/RAROTONGA': "Pacific/Rarotonga",
            'PACIFIC/TAHITI': "Pacific/Tahiti",
            'PACIFIC/MARQUESAS': "Pacific/Marquesas",
            'AMERICA/ANCHORAGE': "America/Anchorage",
            'PACIFIC/GAMBIER': "Pacific/Gambier",
            'AMERICA/LOS_ANGELES': "America/Los_Angeles",
            'AMERICA/TIJUANA': "America/Tijuana",
            'AMERICA/VANCOUVER': "America/Vancouver",
            'AMERICA/WHITEHORSE': "America/Whitehorse",
            'PACIFIC/PITCAIRN': "Pacific/Pitcairn",
            'AMERICA/DAWSON_CREEK': "America/Dawson_Creek",
            'AMERICA/DENVER': "America/Denver",
            'AMERICA/EDMONTON': "America/Edmonton",
            'AMERICA/HERMOSILLO': "America/Hermosillo",
            'AMERICA/MAZATLAN': "America/Mazatlan",
            'AMERICA/PHOENIX': "America/Phoenix",
            'AMERICA/YELLOWKNIFE': "America/Yellowknife",
            'AMERICA/BELIZE': "America/Belize",
            'AMERICA/CHICAGO': "America/Chicago",
            'AMERICA/COSTA_RICA': "America/Costa_Rica",
            'AMERICA/EL_SALVADOR': "America/El_Salvador",
            'AMERICA/GUATEMALA': "America/Guatemala",
            'AMERICA/MANAGUA': "America/Managua",
            'AMERICA/MEXICO_CITY': "America/Mexico_City",
            'AMERICA/REGINA': "America/Regina",
            'AMERICA/TEGUCIGALPA': "America/Tegucigalpa",
            'AMERICA/WINNIPEG': "America/Winnipeg",
            'PACIFIC/GALAPAGOS': "Pacific/Galapagos",
            'AMERICA/BOGOTA': "America/Bogota",
            'AMERICA/CANCUN': "America/Cancun",
            'AMERICA/CAYMAN': "America/Cayman",
            'AMERICA/GUAYAQUIL': "America/Guayaquil",
            'AMERICA/HAVANA': "America/Havana",
            'AMERICA/IQALUIT': "America/Iqaluit",
            'AMERICA/JAMAICA': "America/Jamaica",
            'AMERICA/LIMA': "America/Lima",
            'AMERICA/NASSAU': "America/Nassau",
            'AMERICA/NEW_YORK': "America/New_York",
            'AMERICA/PANAMA': "America/Panama",
            'AMERICA/PORT-AU-PRINCE': "America/Port-au-Prince",
            'AMERICA/RIO_BRANCO': "America/Rio_Branco",
            'AMERICA/TORONTO': "America/Toronto",
            'PACIFIC/EASTER': "Pacific/Easter",
            'AMERICA/CARACAS': "America/Caracas",
            'AMERICA/ASUNCION': "America/Asuncion",
            'AMERICA/BARBADOS': "America/Barbados",
            'AMERICA/BOA_VISTA': "America/Boa_Vista",
            'AMERICA/CAMPO_GRANDE': "America/Campo_Grande",
            'AMERICA/CUIABA': "America/Cuiaba",
            'AMERICA/CURACAO': "America/Curacao",
            'AMERICA/GRAND_TURK': "America/Grand_Turk",
            'AMERICA/GUYANA': "America/Guyana",
            'AMERICA/HALIFAX': "America/Halifax",
            'AMERICA/LA_PAZ': "America/La_Paz",
            'AMERICA/MANAUS': "America/Manaus",
            'AMERICA/MARTINIQUE': "America/Martinique",
            'AMERICA/PORT_OF_SPAIN': "America/Port_of_Spain",
            'AMERICA/PORTO_VELHO': "America/Porto_Velho",
            'AMERICA/PUERTO_RICO': "America/Puerto_Rico",
            'AMERICA/SANTO_DOMINGO': "America/Santo_Domingo",
            'AMERICA/THULE': "America/Thule",
            'ATLANTIC/BERMUDA': "Atlantic/Bermuda",
            'AMERICA/ST_JOHNS': "America/St_Johns",
            'AMERICA/ARAGUAINA': "America/Araguaina",
            'AMERICA/ARGENTINA/BUENOS_AIRES': "America/Argentina/Buenos_Aires",
            'AMERICA/BAHIA': "America/Bahia",
            'AMERICA/BELEM': "America/Belem",
            'AMERICA/CAYENNE': "America/Cayenne",
            'AMERICA/FORTALEZA': "America/Fortaleza",
            'AMERICA/GODTHAB': "America/Godthab",
            'AMERICA/MACEIO': "America/Maceio",
            'AMERICA/MIQUELON': "America/Miquelon",
            'AMERICA/MONTEVIDEO': "America/Montevideo",
            'AMERICA/PARAMARIBO': "America/Paramaribo",
            'AMERICA/RECIFE': "America/Recife",
            'AMERICA/SANTIAGO': "America/Santiago",
            'AMERICA/SAO_PAULO': "America/Sao_Paulo",
            'ANTARCTICA/PALMER': "Antarctica/Palmer",
            'ANTARCTICA/ROTHERA': "Antarctica/Rothera",
            'ATLANTIC/STANLEY': "Atlantic/Stanley",
            'AMERICA/NORONHA': "America/Noronha",
            'ATLANTIC/SOUTH_GEORGIA': "Atlantic/South_Georgia",
            'AMERICA/SCORESBYSUND': "America/Scoresbysund",
            'ATLANTIC/AZORES': "Atlantic/Azores",
            'ATLANTIC/CAPE_VERDE': "Atlantic/Cape_Verde",
            'AFRICA/ABIDJAN': "Africa/Abidjan",
            'AFRICA/ACCRA': "Africa/Accra",
            'AFRICA/BISSAU': "Africa/Bissau",
            'AFRICA/CASABLANCA': "Africa/Casablanca",
            'AFRICA/EL_AAIUN': "Africa/El_Aaiun",
            'AFRICA/MONROVIA': "Africa/Monrovia",
            'AMERICA/DANMARKSHAVN': "America/Danmarkshavn",
            'ATLANTIC/CANARY': "Atlantic/Canary",
            'ATLANTIC/FAROE': "Atlantic/Faroe",
            'ATLANTIC/REYKJAVIK': "Atlantic/Reykjavik",
            'ETC/GMT': "Etc/GMT",
            'EUROPE/DUBLIN': "Europe/Dublin",
            'EUROPE/LISBON': "Europe/Lisbon",
            'EUROPE/LONDON': "Europe/London",
            'AFRICA/ALGIERS': "Africa/Algiers",
            'AFRICA/CEUTA': "Africa/Ceuta",
            'AFRICA/LAGOS': "Africa/Lagos",
            'AFRICA/NDJAMENA': "Africa/Ndjamena",
            'AFRICA/TUNIS': "Africa/Tunis",
            'AFRICA/WINDHOEK': "Africa/Windhoek",
            'EUROPE/AMSTERDAM': "Europe/Amsterdam",
            'EUROPE/ANDORRA': "Europe/Andorra",
            'EUROPE/BELGRADE': "Europe/Belgrade",
            'EUROPE/BERLIN': "Europe/Berlin",
            'EUROPE/BRUSSELS': "Europe/Brussels",
            'EUROPE/BUDAPEST': "Europe/Budapest",
            'EUROPE/COPENHAGEN': "Europe/Copenhagen",
            'EUROPE/GIBRALTAR': "Europe/Gibraltar",
            'EUROPE/LUXEMBOURG': "Europe/Luxembourg",
            'EUROPE/MADRID': "Europe/Madrid",
            'EUROPE/MALTA': "Europe/Malta",
            'EUROPE/MONACO': "Europe/Monaco",
            'EUROPE/OSLO': "Europe/Oslo",
            'EUROPE/PARIS': "Europe/Paris",
            'EUROPE/PRAGUE': "Europe/Prague",
            'EUROPE/ROME': "Europe/Rome",
            'EUROPE/STOCKHOLM': "Europe/Stockholm",
            'EUROPE/TIRANE': "Europe/Tirane",
            'EUROPE/VIENNA': "Europe/Vienna",
            'EUROPE/WARSAW': "Europe/Warsaw",
            'EUROPE/ZURICH': "Europe/Zurich",
            'AFRICA/CAIRO': "Africa/Cairo",
            'AFRICA/JOHANNESBURG': "Africa/Johannesburg",
            'AFRICA/MAPUTO': "Africa/Maputo",
            'AFRICA/TRIPOLI': "Africa/Tripoli",
            'ASIA/AMMAN': "Asia/Amman",
            'ASIA/BEIRUT': "Asia/Beirut",
            'ASIA/DAMASCUS': "Asia/Damascus",
            'ASIA/GAZA': "Asia/Gaza",
            'ASIA/JERUSALEM': "Asia/Jerusalem",
            'ASIA/NICOSIA': "Asia/Nicosia",
            'EUROPE/ATHENS': "Europe/Athens",
            'EUROPE/BUCHAREST': "Europe/Bucharest",
            'EUROPE/CHISINAU': "Europe/Chisinau",
            'EUROPE/HELSINKI': "Europe/Helsinki",
            'EUROPE/ISTANBUL': "Europe/Istanbul",
            'EUROPE/KALININGRAD': "Europe/Kaliningrad",
            'EUROPE/KIEV': "Europe/Kiev",
            'EUROPE/RIGA': "Europe/Riga",
            'EUROPE/SOFIA': "Europe/Sofia",
            'EUROPE/TALLINN': "Europe/Tallinn",
            'EUROPE/VILNIUS': "Europe/Vilnius",
            'AFRICA/KHARTOUM': "Africa/Khartoum",
            'AFRICA/NAIROBI': "Africa/Nairobi",
            'ANTARCTICA/SYOWA': "Antarctica/Syowa",
            'ASIA/BAGHDAD': "Asia/Baghdad",
            'ASIA/QATAR': "Asia/Qatar",
            'ASIA/RIYADH': "Asia/Riyadh",
            'EUROPE/MINSK': "Europe/Minsk",
            'EUROPE/MOSCOW': "Europe/Moscow",
            'ASIA/TEHRAN': "Asia/Tehran",
            'ASIA/BAKU': "Asia/Baku",
            'ASIA/DUBAI': "Asia/Dubai",
            'ASIA/TBILISI': "Asia/Tbilisi",
            'ASIA/YEREVAN': "Asia/Yerevan",
            'EUROPE/SAMARA': "Europe/Samara",
            'INDIAN/MAHE': "Indian/Mahe",
            'INDIAN/MAURITIUS': "Indian/Mauritius",
            'INDIAN/REUNION': "Indian/Reunion",
            'ASIA/KABUL': "Asia/Kabul",
            'ANTARCTICA/MAWSON': "Antarctica/Mawson",
            'ASIA/AQTAU': "Asia/Aqtau",
            'ASIA/AQTOBE': "Asia/Aqtobe",
            'ASIA/ASHGABAT': "Asia/Ashgabat",
            'ASIA/DUSHANBE': "Asia/Dushanbe",
            'ASIA/KARACHI': "Asia/Karachi",
            'ASIA/TASHKENT': "Asia/Tashkent",
            'ASIA/YEKATERINBURG': "Asia/Yekaterinburg",
            'INDIAN/KERGUELEN': "Indian/Kerguelen",
            'INDIAN/MALDIVES': "Indian/Maldives",
            'ASIA/CALCUTTA': "Asia/Calcutta",
            'ASIA/KOLKATA': "Asia/Kolkata",
            'ASIA/COLOMBO': "Asia/Colombo",
            'ASIA/KATMANDU': "Asia/Katmandu",
            'ANTARCTICA/VOSTOK': "Antarctica/Vostok",
            'ASIA/ALMATY': "Asia/Almaty",
            'ASIA/BISHKEK': "Asia/Bishkek",
            'ASIA/DHAKA': "Asia/Dhaka",
            'ASIA/OMSK': "Asia/Omsk",
            'ASIA/THIMPHU': "Asia/Thimphu",
            'INDIAN/CHAGOS': "Indian/Chagos",
            'ASIA/RANGOON': "Asia/Rangoon",
            'INDIAN/COCOS': "Indian/Cocos",
            'ANTARCTICA/DAVIS': "Antarctica/Davis",
            'ASIA/BANGKOK': "Asia/Bangkok",
            'ASIA/HOVD': "Asia/Hovd",
            'ASIA/JAKARTA': "Asia/Jakarta",
            'ASIA/KRASNOYARSK': "Asia/Krasnoyarsk",
            'ASIA/SAIGON': "Asia/Saigon",
            'INDIAN/CHRISTMAS': "Indian/Christmas",
            'ANTARCTICA/CASEY': "Antarctica/Casey",
            'ASIA/BRUNEI': "Asia/Brunei",
            'ASIA/CHOIBALSAN': "Asia/Choibalsan",
            'ASIA/HONG_KONG': "Asia/Hong_Kong",
            'ASIA/IRKUTSK': "Asia/Irkutsk",
            'ASIA/KUALA_LUMPUR': "Asia/Kuala_Lumpur",
            'ASIA/MACAU': "Asia/Macau",
            'ASIA/MAKASSAR': "Asia/Makassar",
            'ASIA/MANILA': "Asia/Manila",
            'ASIA/SHANGHAI': "Asia/Shanghai",
            'ASIA/SINGAPORE': "Asia/Singapore",
            'ASIA/TAIPEI': "Asia/Taipei",
            'ASIA/ULAANBAATAR': "Asia/Ulaanbaatar",
            'AUSTRALIA/PERTH': "Australia/Perth",
            'ASIA/PYONGYANG': "Asia/Pyongyang",
            'ASIA/DILI': "Asia/Dili",
            'ASIA/JAYAPURA': "Asia/Jayapura",
            'ASIA/SEOUL': "Asia/Seoul",
            'ASIA/TOKYO': "Asia/Tokyo",
            'ASIA/YAKUTSK': "Asia/Yakutsk",
            'PACIFIC/PALAU': "Pacific/Palau",
            'AUSTRALIA/ADELAIDE': "Australia/Adelaide",
            'AUSTRALIA/DARWIN': "Australia/Darwin",
            'ANTARCTICA/DUMONTDURVILLE': "Antarctica/DumontDUrville",
            'ASIA/MAGADAN': "Asia/Magadan",
            'ASIA/VLADIVOSTOK': "Asia/Vladivostok",
            'AUSTRALIA/BRISBANE': "Australia/Brisbane",
            'AUSTRALIA/HOBART': "Australia/Hobart",
            'AUSTRALIA/SYDNEY': "Australia/Sydney",
            'PACIFIC/CHUUK': "Pacific/Chuuk",
            'PACIFIC/GUAM': "Pacific/Guam",
            'PACIFIC/PORT_MORESBY': "Pacific/Port_Moresby",
            'PACIFIC/EFATE': "Pacific/Efate",
            'PACIFIC/GUADALCANAL': "Pacific/Guadalcanal",
            'PACIFIC/KOSRAE': "Pacific/Kosrae",
            'PACIFIC/NORFOLK': "Pacific/Norfolk",
            'PACIFIC/NOUMEA': "Pacific/Noumea",
            'PACIFIC/POHNPEI': "Pacific/Pohnpei",
            'ASIA/KAMCHATKA': "Asia/Kamchatka",
            'PACIFIC/AUCKLAND': "Pacific/Auckland",
            'PACIFIC/FIJI': "Pacific/Fiji",
            'PACIFIC/FUNAFUTI': "Pacific/Funafuti",
            'PACIFIC/KWAJALEIN': "Pacific/Kwajalein",
            'PACIFIC/MAJURO': "Pacific/Majuro",
            'PACIFIC/NAURU': "Pacific/Nauru",
            'PACIFIC/TARAWA': "Pacific/Tarawa",
            'PACIFIC/WAKE': "Pacific/Wake",
            'PACIFIC/WALLIS': "Pacific/Wallis",
            'PACIFIC/APIA': "Pacific/Apia",
            'PACIFIC/ENDERBURY': "Pacific/Enderbury",
            'PACIFIC/FAKAOFO': "Pacific/Fakaofo",
            'PACIFIC/TONGATAPU': "Pacific/Tongatapu",
            'PACIFIC/KIRITIMATI': "Pacific/Kiritimati",
        },
    }

    validations = {
        ('dns_domain_name',): {
            'max_length': 253,
            'min_length': 0,
            'regex': {
                'pattern': r'^$|^([a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\.)*[a-zA-Z]{2,63}$',  # noqa: E501
            },
        },
        ('dns_servers',): {
            'max_items': 3,
            'min_items': 1,
        },
        ('ntp_servers',): {
            'max_items': 3,
            'min_items': 1,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'dns_domain_name': (str,),  # noqa: E501
            'dns_servers': ([str], none_type,),  # noqa: E501
            'ntp_servers': ([str], none_type,),  # noqa: E501
            'timezone': (str,),  # noqa: E501
            'cluster_profiles': ([HyperflexClusterProfileRelationship], none_type,),  # noqa: E501
            'organization': (OrganizationOrganizationRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'dns_domain_name': 'DnsDomainName',  # noqa: E501
        'dns_servers': 'DnsServers',  # noqa: E501
        'ntp_servers': 'NtpServers',  # noqa: E501
        'timezone': 'Timezone',  # noqa: E501
        'cluster_profiles': 'ClusterProfiles',  # noqa: E501
        'organization': 'Organization',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """HyperflexSysConfigPolicyAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "hyperflex.SysConfigPolicy", must be one of ["hyperflex.SysConfigPolicy", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "hyperflex.SysConfigPolicy", must be one of ["hyperflex.SysConfigPolicy", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            dns_domain_name (str): The DNS Search Domain Name. This setting applies to HyperFlex Data Platform 3.0 or later only.. [optional]  # noqa: E501
            dns_servers ([str], none_type): [optional]  # noqa: E501
            ntp_servers ([str], none_type): [optional]  # noqa: E501
            timezone (str): The timezone of the HyperFlex cluster's system clock. * `Pacific/Niue` -  * `Pacific/Pago_Pago` -  * `Pacific/Honolulu` -  * `Pacific/Rarotonga` -  * `Pacific/Tahiti` -  * `Pacific/Marquesas` -  * `America/Anchorage` -  * `Pacific/Gambier` -  * `America/Los_Angeles` -  * `America/Tijuana` -  * `America/Vancouver` -  * `America/Whitehorse` -  * `Pacific/Pitcairn` -  * `America/Dawson_Creek` -  * `America/Denver` -  * `America/Edmonton` -  * `America/Hermosillo` -  * `America/Mazatlan` -  * `America/Phoenix` -  * `America/Yellowknife` -  * `America/Belize` -  * `America/Chicago` -  * `America/Costa_Rica` -  * `America/El_Salvador` -  * `America/Guatemala` -  * `America/Managua` -  * `America/Mexico_City` -  * `America/Regina` -  * `America/Tegucigalpa` -  * `America/Winnipeg` -  * `Pacific/Galapagos` -  * `America/Bogota` -  * `America/Cancun` -  * `America/Cayman` -  * `America/Guayaquil` -  * `America/Havana` -  * `America/Iqaluit` -  * `America/Jamaica` -  * `America/Lima` -  * `America/Nassau` -  * `America/New_York` -  * `America/Panama` -  * `America/Port-au-Prince` -  * `America/Rio_Branco` -  * `America/Toronto` -  * `Pacific/Easter` -  * `America/Caracas` -  * `America/Asuncion` -  * `America/Barbados` -  * `America/Boa_Vista` -  * `America/Campo_Grande` -  * `America/Cuiaba` -  * `America/Curacao` -  * `America/Grand_Turk` -  * `America/Guyana` -  * `America/Halifax` -  * `America/La_Paz` -  * `America/Manaus` -  * `America/Martinique` -  * `America/Port_of_Spain` -  * `America/Porto_Velho` -  * `America/Puerto_Rico` -  * `America/Santo_Domingo` -  * `America/Thule` -  * `Atlantic/Bermuda` -  * `America/St_Johns` -  * `America/Araguaina` -  * `America/Argentina/Buenos_Aires` -  * `America/Bahia` -  * `America/Belem` -  * `America/Cayenne` -  * `America/Fortaleza` -  * `America/Godthab` -  * `America/Maceio` -  * `America/Miquelon` -  * `America/Montevideo` -  * `America/Paramaribo` -  * `America/Recife` -  * `America/Santiago` -  * `America/Sao_Paulo` -  * `Antarctica/Palmer` -  * `Antarctica/Rothera` -  * `Atlantic/Stanley` -  * `America/Noronha` -  * `Atlantic/South_Georgia` -  * `America/Scoresbysund` -  * `Atlantic/Azores` -  * `Atlantic/Cape_Verde` -  * `Africa/Abidjan` -  * `Africa/Accra` -  * `Africa/Bissau` -  * `Africa/Casablanca` -  * `Africa/El_Aaiun` -  * `Africa/Monrovia` -  * `America/Danmarkshavn` -  * `Atlantic/Canary` -  * `Atlantic/Faroe` -  * `Atlantic/Reykjavik` -  * `Etc/GMT` -  * `Europe/Dublin` -  * `Europe/Lisbon` -  * `Europe/London` -  * `Africa/Algiers` -  * `Africa/Ceuta` -  * `Africa/Lagos` -  * `Africa/Ndjamena` -  * `Africa/Tunis` -  * `Africa/Windhoek` -  * `Europe/Amsterdam` -  * `Europe/Andorra` -  * `Europe/Belgrade` -  * `Europe/Berlin` -  * `Europe/Brussels` -  * `Europe/Budapest` -  * `Europe/Copenhagen` -  * `Europe/Gibraltar` -  * `Europe/Luxembourg` -  * `Europe/Madrid` -  * `Europe/Malta` -  * `Europe/Monaco` -  * `Europe/Oslo` -  * `Europe/Paris` -  * `Europe/Prague` -  * `Europe/Rome` -  * `Europe/Stockholm` -  * `Europe/Tirane` -  * `Europe/Vienna` -  * `Europe/Warsaw` -  * `Europe/Zurich` -  * `Africa/Cairo` -  * `Africa/Johannesburg` -  * `Africa/Maputo` -  * `Africa/Tripoli` -  * `Asia/Amman` -  * `Asia/Beirut` -  * `Asia/Damascus` -  * `Asia/Gaza` -  * `Asia/Jerusalem` -  * `Asia/Nicosia` -  * `Europe/Athens` -  * `Europe/Bucharest` -  * `Europe/Chisinau` -  * `Europe/Helsinki` -  * `Europe/Istanbul` -  * `Europe/Kaliningrad` -  * `Europe/Kiev` -  * `Europe/Riga` -  * `Europe/Sofia` -  * `Europe/Tallinn` -  * `Europe/Vilnius` -  * `Africa/Khartoum` -  * `Africa/Nairobi` -  * `Antarctica/Syowa` -  * `Asia/Baghdad` -  * `Asia/Qatar` -  * `Asia/Riyadh` -  * `Europe/Minsk` -  * `Europe/Moscow` -  * `Asia/Tehran` -  * `Asia/Baku` -  * `Asia/Dubai` -  * `Asia/Tbilisi` -  * `Asia/Yerevan` -  * `Europe/Samara` -  * `Indian/Mahe` -  * `Indian/Mauritius` -  * `Indian/Reunion` -  * `Asia/Kabul` -  * `Antarctica/Mawson` -  * `Asia/Aqtau` -  * `Asia/Aqtobe` -  * `Asia/Ashgabat` -  * `Asia/Dushanbe` -  * `Asia/Karachi` -  * `Asia/Tashkent` -  * `Asia/Yekaterinburg` -  * `Indian/Kerguelen` -  * `Indian/Maldives` -  * `Asia/Calcutta` -  * `Asia/Kolkata` -  * `Asia/Colombo` -  * `Asia/Katmandu` -  * `Antarctica/Vostok` -  * `Asia/Almaty` -  * `Asia/Bishkek` -  * `Asia/Dhaka` -  * `Asia/Omsk` -  * `Asia/Thimphu` -  * `Indian/Chagos` -  * `Asia/Rangoon` -  * `Indian/Cocos` -  * `Antarctica/Davis` -  * `Asia/Bangkok` -  * `Asia/Hovd` -  * `Asia/Jakarta` -  * `Asia/Krasnoyarsk` -  * `Asia/Saigon` -  * `Indian/Christmas` -  * `Antarctica/Casey` -  * `Asia/Brunei` -  * `Asia/Choibalsan` -  * `Asia/Hong_Kong` -  * `Asia/Irkutsk` -  * `Asia/Kuala_Lumpur` -  * `Asia/Macau` -  * `Asia/Makassar` -  * `Asia/Manila` -  * `Asia/Shanghai` -  * `Asia/Singapore` -  * `Asia/Taipei` -  * `Asia/Ulaanbaatar` -  * `Australia/Perth` -  * `Asia/Pyongyang` -  * `Asia/Dili` -  * `Asia/Jayapura` -  * `Asia/Seoul` -  * `Asia/Tokyo` -  * `Asia/Yakutsk` -  * `Pacific/Palau` -  * `Australia/Adelaide` -  * `Australia/Darwin` -  * `Antarctica/DumontDUrville` -  * `Asia/Magadan` -  * `Asia/Vladivostok` -  * `Australia/Brisbane` -  * `Australia/Hobart` -  * `Australia/Sydney` -  * `Pacific/Chuuk` -  * `Pacific/Guam` -  * `Pacific/Port_Moresby` -  * `Pacific/Efate` -  * `Pacific/Guadalcanal` -  * `Pacific/Kosrae` -  * `Pacific/Norfolk` -  * `Pacific/Noumea` -  * `Pacific/Pohnpei` -  * `Asia/Kamchatka` -  * `Pacific/Auckland` -  * `Pacific/Fiji` -  * `Pacific/Funafuti` -  * `Pacific/Kwajalein` -  * `Pacific/Majuro` -  * `Pacific/Nauru` -  * `Pacific/Tarawa` -  * `Pacific/Wake` -  * `Pacific/Wallis` -  * `Pacific/Apia` -  * `Pacific/Enderbury` -  * `Pacific/Fakaofo` -  * `Pacific/Tongatapu` -  * `Pacific/Kiritimati` -. [optional] if omitted the server will use the default value of "Pacific/Niue"  # noqa: E501
            cluster_profiles ([HyperflexClusterProfileRelationship], none_type): An array of relationships to hyperflexClusterProfile resources.. [optional]  # noqa: E501
            organization (OrganizationOrganizationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "hyperflex.SysConfigPolicy")
        object_type = kwargs.get('object_type', "hyperflex.SysConfigPolicy")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
