"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5517
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.hyperflex_st_platform_cluster_healing_info import HyperflexStPlatformClusterHealingInfo
    from intersight.model.hyperflex_st_platform_cluster_resiliency_info import HyperflexStPlatformClusterResiliencyInfo
    from intersight.model.hyperflex_summary_all_of import HyperflexSummaryAllOf
    from intersight.model.mo_base_complex_type import MoBaseComplexType
    globals()['HyperflexStPlatformClusterHealingInfo'] = HyperflexStPlatformClusterHealingInfo
    globals()['HyperflexStPlatformClusterResiliencyInfo'] = HyperflexStPlatformClusterResiliencyInfo
    globals()['HyperflexSummaryAllOf'] = HyperflexSummaryAllOf
    globals()['MoBaseComplexType'] = MoBaseComplexType


class HyperflexSummary(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'HYPERFLEX.SUMMARY': "hyperflex.Summary",
        },
        ('object_type',): {
            'HYPERFLEX.SUMMARY': "hyperflex.Summary",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = True

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'active_nodes': (str,),  # noqa: E501
            'address': (str,),  # noqa: E501
            'boottime': (int,),  # noqa: E501
            'cluster_access_policy': (str,),  # noqa: E501
            'compression_savings': (float,),  # noqa: E501
            'data_replication_compliance': (str,),  # noqa: E501
            'data_replication_factor': (str,),  # noqa: E501
            'deduplication_savings': (float,),  # noqa: E501
            'downtime': (str,),  # noqa: E501
            'free_capacity': (int,),  # noqa: E501
            'healing_info': (HyperflexStPlatformClusterHealingInfo,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'resiliency_details': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'resiliency_details_size': (int,),  # noqa: E501
            'resiliency_info': (HyperflexStPlatformClusterResiliencyInfo,),  # noqa: E501
            'space_status': (str,),  # noqa: E501
            'state': (str,),  # noqa: E501
            'total_capacity': (int,),  # noqa: E501
            'total_savings': (float,),  # noqa: E501
            'uptime': (str,),  # noqa: E501
            'used_capacity': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'active_nodes': 'ActiveNodes',  # noqa: E501
        'address': 'Address',  # noqa: E501
        'boottime': 'Boottime',  # noqa: E501
        'cluster_access_policy': 'ClusterAccessPolicy',  # noqa: E501
        'compression_savings': 'CompressionSavings',  # noqa: E501
        'data_replication_compliance': 'DataReplicationCompliance',  # noqa: E501
        'data_replication_factor': 'DataReplicationFactor',  # noqa: E501
        'deduplication_savings': 'DeduplicationSavings',  # noqa: E501
        'downtime': 'Downtime',  # noqa: E501
        'free_capacity': 'FreeCapacity',  # noqa: E501
        'healing_info': 'HealingInfo',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'resiliency_details': 'ResiliencyDetails',  # noqa: E501
        'resiliency_details_size': 'ResiliencyDetailsSize',  # noqa: E501
        'resiliency_info': 'ResiliencyInfo',  # noqa: E501
        'space_status': 'SpaceStatus',  # noqa: E501
        'state': 'State',  # noqa: E501
        'total_capacity': 'TotalCapacity',  # noqa: E501
        'total_savings': 'TotalSavings',  # noqa: E501
        'uptime': 'Uptime',  # noqa: E501
        'used_capacity': 'UsedCapacity',  # noqa: E501
    }

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """HyperflexSummary - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "hyperflex.Summary", must be one of ["hyperflex.Summary", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "hyperflex.Summary", must be one of ["hyperflex.Summary", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            active_nodes (str): The number of nodes currently participating in the storage cluster.. [optional]  # noqa: E501
            address (str): The data IP address of the HyperFlex cluster.. [optional]  # noqa: E501
            boottime (int): The time taken during last cluster startup in seconds.. [optional]  # noqa: E501
            cluster_access_policy (str): The cluster access policy for the HyperFlex cluster. An access policy of 'STRICT' means that the cluster becomes readonly once any fragment of data is reduced to one copy. 'LENIENT' means that the cluster stays in read-write mode even if any fragment of data is reduced to one copy.. [optional]  # noqa: E501
            compression_savings (float): The percentage of storage space saved using data compression.. [optional]  # noqa: E501
            data_replication_compliance (str): The compliance with the data replication factor set for the HyperFlex cluster.. [optional]  # noqa: E501
            data_replication_factor (str): The number of data copies retained by the HyperFlex cluster.. [optional]  # noqa: E501
            deduplication_savings (float): The percentage of storage space saved using data deduplication.. [optional]  # noqa: E501
            downtime (str): The amount of time the HyperFlex cluster has been offline.. [optional]  # noqa: E501
            free_capacity (int): The amount of storage capacity currently not in use, represented in bytes.. [optional]  # noqa: E501
            healing_info (HyperflexStPlatformClusterHealingInfo): [optional]  # noqa: E501
            name (str): The name of the HyperFlex cluster.. [optional]  # noqa: E501
            resiliency_details (bool, date, datetime, dict, float, int, list, str, none_type): The details about the resiliency health of the cluster. Includes information about the cluster healing status and the storage cluster health.. [optional]  # noqa: E501
            resiliency_details_size (int): The number of elements in the resiliency details property.. [optional]  # noqa: E501
            resiliency_info (HyperflexStPlatformClusterResiliencyInfo): [optional]  # noqa: E501
            space_status (str): The space utilization status of the HyperFlex cluster.. [optional]  # noqa: E501
            state (str): The operational state of the HyperFlex cluster.. [optional]  # noqa: E501
            total_capacity (int): The total amount of storage capacity available for the HyperFlex cluster, represented in bytes.. [optional]  # noqa: E501
            total_savings (float): The percentage of storage space saved in total.. [optional]  # noqa: E501
            uptime (str): The amount of time the HyperFlex cluster has been running since last startup.. [optional]  # noqa: E501
            used_capacity (int): The amount of storage capacity in use, represented in bytes.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "hyperflex.Summary")
        object_type = kwargs.get('object_type', "hyperflex.Summary")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        model_args = {}
        model_args.update(required_args)
        model_args.update(kwargs)
        composed_info = validate_get_composed_info(
            constant_args, model_args, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        unused_args = composed_info[3]

        for var_name, var_value in required_args.items():
            setattr(self, var_name, var_value)
        for var_name, var_value in kwargs.items():
            if var_name in unused_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        not self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              HyperflexSummaryAllOf,
              MoBaseComplexType,
          ],
          'oneOf': [
          ],
        }
