"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5517
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.api_client import ApiClient, Endpoint as _Endpoint
from intersight.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from intersight.model.error import Error
from intersight.model.niaapi_apic_cco_post import NiaapiApicCcoPost
from intersight.model.niaapi_apic_cco_post_response import NiaapiApicCcoPostResponse
from intersight.model.niaapi_apic_field_notice import NiaapiApicFieldNotice
from intersight.model.niaapi_apic_field_notice_response import NiaapiApicFieldNoticeResponse
from intersight.model.niaapi_apic_hweol import NiaapiApicHweol
from intersight.model.niaapi_apic_hweol_response import NiaapiApicHweolResponse
from intersight.model.niaapi_apic_latest_maintained_release import NiaapiApicLatestMaintainedRelease
from intersight.model.niaapi_apic_latest_maintained_release_response import NiaapiApicLatestMaintainedReleaseResponse
from intersight.model.niaapi_apic_release_recommend import NiaapiApicReleaseRecommend
from intersight.model.niaapi_apic_release_recommend_response import NiaapiApicReleaseRecommendResponse
from intersight.model.niaapi_apic_sweol import NiaapiApicSweol
from intersight.model.niaapi_apic_sweol_response import NiaapiApicSweolResponse
from intersight.model.niaapi_dcnm_cco_post import NiaapiDcnmCcoPost
from intersight.model.niaapi_dcnm_cco_post_response import NiaapiDcnmCcoPostResponse
from intersight.model.niaapi_dcnm_field_notice import NiaapiDcnmFieldNotice
from intersight.model.niaapi_dcnm_field_notice_response import NiaapiDcnmFieldNoticeResponse
from intersight.model.niaapi_dcnm_hweol import NiaapiDcnmHweol
from intersight.model.niaapi_dcnm_hweol_response import NiaapiDcnmHweolResponse
from intersight.model.niaapi_dcnm_latest_maintained_release import NiaapiDcnmLatestMaintainedRelease
from intersight.model.niaapi_dcnm_latest_maintained_release_response import NiaapiDcnmLatestMaintainedReleaseResponse
from intersight.model.niaapi_dcnm_release_recommend import NiaapiDcnmReleaseRecommend
from intersight.model.niaapi_dcnm_release_recommend_response import NiaapiDcnmReleaseRecommendResponse
from intersight.model.niaapi_dcnm_sweol import NiaapiDcnmSweol
from intersight.model.niaapi_dcnm_sweol_response import NiaapiDcnmSweolResponse
from intersight.model.niaapi_file_downloader import NiaapiFileDownloader
from intersight.model.niaapi_file_downloader_response import NiaapiFileDownloaderResponse
from intersight.model.niaapi_nia_metadata import NiaapiNiaMetadata
from intersight.model.niaapi_nia_metadata_response import NiaapiNiaMetadataResponse
from intersight.model.niaapi_nib_file_downloader import NiaapiNibFileDownloader
from intersight.model.niaapi_nib_file_downloader_response import NiaapiNibFileDownloaderResponse
from intersight.model.niaapi_nib_metadata import NiaapiNibMetadata
from intersight.model.niaapi_nib_metadata_response import NiaapiNibMetadataResponse
from intersight.model.niaapi_version_regex import NiaapiVersionRegex
from intersight.model.niaapi_version_regex_response import NiaapiVersionRegexResponse


class NiaapiApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_niaapi_apic_cco_post_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.ApicCcoPost' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_cco_post_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicCcoPost
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_cco_post_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiApicCcoPost,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicCcoPosts/{Moid}',
                'operation_id': 'get_niaapi_apic_cco_post_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_cco_post_by_moid
        )

        def __get_niaapi_apic_cco_post_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.ApicCcoPost' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_cco_post_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicCcoPostResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_cco_post_list = _Endpoint(
            settings={
                'response_type': (NiaapiApicCcoPostResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicCcoPosts',
                'operation_id': 'get_niaapi_apic_cco_post_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_cco_post_list
        )

        def __get_niaapi_apic_field_notice_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.ApicFieldNotice' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_field_notice_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicFieldNotice
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_field_notice_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiApicFieldNotice,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicFieldNotices/{Moid}',
                'operation_id': 'get_niaapi_apic_field_notice_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_field_notice_by_moid
        )

        def __get_niaapi_apic_field_notice_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.ApicFieldNotice' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_field_notice_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicFieldNoticeResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_field_notice_list = _Endpoint(
            settings={
                'response_type': (NiaapiApicFieldNoticeResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicFieldNotices',
                'operation_id': 'get_niaapi_apic_field_notice_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_field_notice_list
        )

        def __get_niaapi_apic_hweol_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.ApicHweol' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_hweol_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicHweol
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_hweol_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiApicHweol,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicHweols/{Moid}',
                'operation_id': 'get_niaapi_apic_hweol_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_hweol_by_moid
        )

        def __get_niaapi_apic_hweol_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.ApicHweol' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_hweol_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicHweolResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_hweol_list = _Endpoint(
            settings={
                'response_type': (NiaapiApicHweolResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicHweols',
                'operation_id': 'get_niaapi_apic_hweol_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_hweol_list
        )

        def __get_niaapi_apic_latest_maintained_release_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.ApicLatestMaintainedRelease' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_latest_maintained_release_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicLatestMaintainedRelease
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_latest_maintained_release_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiApicLatestMaintainedRelease,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicLatestMaintainedReleases/{Moid}',
                'operation_id': 'get_niaapi_apic_latest_maintained_release_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_latest_maintained_release_by_moid
        )

        def __get_niaapi_apic_latest_maintained_release_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.ApicLatestMaintainedRelease' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_latest_maintained_release_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicLatestMaintainedReleaseResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_latest_maintained_release_list = _Endpoint(
            settings={
                'response_type': (NiaapiApicLatestMaintainedReleaseResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicLatestMaintainedReleases',
                'operation_id': 'get_niaapi_apic_latest_maintained_release_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_latest_maintained_release_list
        )

        def __get_niaapi_apic_release_recommend_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.ApicReleaseRecommend' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_release_recommend_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicReleaseRecommend
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_release_recommend_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiApicReleaseRecommend,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicReleaseRecommends/{Moid}',
                'operation_id': 'get_niaapi_apic_release_recommend_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_release_recommend_by_moid
        )

        def __get_niaapi_apic_release_recommend_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.ApicReleaseRecommend' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_release_recommend_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicReleaseRecommendResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_release_recommend_list = _Endpoint(
            settings={
                'response_type': (NiaapiApicReleaseRecommendResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicReleaseRecommends',
                'operation_id': 'get_niaapi_apic_release_recommend_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_release_recommend_list
        )

        def __get_niaapi_apic_sweol_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.ApicSweol' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_sweol_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicSweol
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_sweol_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiApicSweol,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicSweols/{Moid}',
                'operation_id': 'get_niaapi_apic_sweol_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_sweol_by_moid
        )

        def __get_niaapi_apic_sweol_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.ApicSweol' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_apic_sweol_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiApicSweolResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_apic_sweol_list = _Endpoint(
            settings={
                'response_type': (NiaapiApicSweolResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/ApicSweols',
                'operation_id': 'get_niaapi_apic_sweol_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_apic_sweol_list
        )

        def __get_niaapi_dcnm_cco_post_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.DcnmCcoPost' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_cco_post_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmCcoPost
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_cco_post_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmCcoPost,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmCcoPosts/{Moid}',
                'operation_id': 'get_niaapi_dcnm_cco_post_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_cco_post_by_moid
        )

        def __get_niaapi_dcnm_cco_post_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.DcnmCcoPost' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_cco_post_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmCcoPostResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_cco_post_list = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmCcoPostResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmCcoPosts',
                'operation_id': 'get_niaapi_dcnm_cco_post_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_cco_post_list
        )

        def __get_niaapi_dcnm_field_notice_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.DcnmFieldNotice' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_field_notice_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmFieldNotice
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_field_notice_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmFieldNotice,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmFieldNotices/{Moid}',
                'operation_id': 'get_niaapi_dcnm_field_notice_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_field_notice_by_moid
        )

        def __get_niaapi_dcnm_field_notice_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.DcnmFieldNotice' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_field_notice_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmFieldNoticeResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_field_notice_list = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmFieldNoticeResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmFieldNotices',
                'operation_id': 'get_niaapi_dcnm_field_notice_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_field_notice_list
        )

        def __get_niaapi_dcnm_hweol_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.DcnmHweol' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_hweol_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmHweol
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_hweol_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmHweol,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmHweols/{Moid}',
                'operation_id': 'get_niaapi_dcnm_hweol_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_hweol_by_moid
        )

        def __get_niaapi_dcnm_hweol_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.DcnmHweol' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_hweol_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmHweolResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_hweol_list = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmHweolResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmHweols',
                'operation_id': 'get_niaapi_dcnm_hweol_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_hweol_list
        )

        def __get_niaapi_dcnm_latest_maintained_release_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.DcnmLatestMaintainedRelease' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_latest_maintained_release_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmLatestMaintainedRelease
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_latest_maintained_release_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmLatestMaintainedRelease,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmLatestMaintainedReleases/{Moid}',
                'operation_id': 'get_niaapi_dcnm_latest_maintained_release_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_latest_maintained_release_by_moid
        )

        def __get_niaapi_dcnm_latest_maintained_release_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.DcnmLatestMaintainedRelease' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_latest_maintained_release_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmLatestMaintainedReleaseResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_latest_maintained_release_list = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmLatestMaintainedReleaseResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmLatestMaintainedReleases',
                'operation_id': 'get_niaapi_dcnm_latest_maintained_release_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_latest_maintained_release_list
        )

        def __get_niaapi_dcnm_release_recommend_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.DcnmReleaseRecommend' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_release_recommend_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmReleaseRecommend
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_release_recommend_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmReleaseRecommend,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmReleaseRecommends/{Moid}',
                'operation_id': 'get_niaapi_dcnm_release_recommend_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_release_recommend_by_moid
        )

        def __get_niaapi_dcnm_release_recommend_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.DcnmReleaseRecommend' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_release_recommend_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmReleaseRecommendResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_release_recommend_list = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmReleaseRecommendResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmReleaseRecommends',
                'operation_id': 'get_niaapi_dcnm_release_recommend_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_release_recommend_list
        )

        def __get_niaapi_dcnm_sweol_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.DcnmSweol' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_sweol_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmSweol
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_sweol_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmSweol,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmSweols/{Moid}',
                'operation_id': 'get_niaapi_dcnm_sweol_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_sweol_by_moid
        )

        def __get_niaapi_dcnm_sweol_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.DcnmSweol' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_dcnm_sweol_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiDcnmSweolResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_dcnm_sweol_list = _Endpoint(
            settings={
                'response_type': (NiaapiDcnmSweolResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/DcnmSweols',
                'operation_id': 'get_niaapi_dcnm_sweol_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_dcnm_sweol_list
        )

        def __get_niaapi_file_downloader_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.FileDownloader' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_file_downloader_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiFileDownloader
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_file_downloader_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiFileDownloader,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/FileDownloaders/{Moid}',
                'operation_id': 'get_niaapi_file_downloader_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_file_downloader_by_moid
        )

        def __get_niaapi_file_downloader_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.FileDownloader' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_file_downloader_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiFileDownloaderResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_file_downloader_list = _Endpoint(
            settings={
                'response_type': (NiaapiFileDownloaderResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/FileDownloaders',
                'operation_id': 'get_niaapi_file_downloader_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_file_downloader_list
        )

        def __get_niaapi_nia_metadata_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.NiaMetadata' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_nia_metadata_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiNiaMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_nia_metadata_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiNiaMetadata,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/NiaMetadata/{Moid}',
                'operation_id': 'get_niaapi_nia_metadata_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_nia_metadata_by_moid
        )

        def __get_niaapi_nia_metadata_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.NiaMetadata' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_nia_metadata_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiNiaMetadataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_nia_metadata_list = _Endpoint(
            settings={
                'response_type': (NiaapiNiaMetadataResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/NiaMetadata',
                'operation_id': 'get_niaapi_nia_metadata_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_nia_metadata_list
        )

        def __get_niaapi_nib_file_downloader_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.NibFileDownloader' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_nib_file_downloader_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiNibFileDownloader
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_nib_file_downloader_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiNibFileDownloader,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/NibFileDownloaders/{Moid}',
                'operation_id': 'get_niaapi_nib_file_downloader_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_nib_file_downloader_by_moid
        )

        def __get_niaapi_nib_file_downloader_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.NibFileDownloader' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_nib_file_downloader_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiNibFileDownloaderResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_nib_file_downloader_list = _Endpoint(
            settings={
                'response_type': (NiaapiNibFileDownloaderResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/NibFileDownloaders',
                'operation_id': 'get_niaapi_nib_file_downloader_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_nib_file_downloader_list
        )

        def __get_niaapi_nib_metadata_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.NibMetadata' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_nib_metadata_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiNibMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_nib_metadata_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiNibMetadata,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/NibMetadata/{Moid}',
                'operation_id': 'get_niaapi_nib_metadata_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_nib_metadata_by_moid
        )

        def __get_niaapi_nib_metadata_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.NibMetadata' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_nib_metadata_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiNibMetadataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_nib_metadata_list = _Endpoint(
            settings={
                'response_type': (NiaapiNibMetadataResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/NibMetadata',
                'operation_id': 'get_niaapi_nib_metadata_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_nib_metadata_list
        )

        def __get_niaapi_version_regex_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'niaapi.VersionRegex' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_version_regex_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiVersionRegex
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_version_regex_by_moid = _Endpoint(
            settings={
                'response_type': (NiaapiVersionRegex,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/VersionRegexes/{Moid}',
                'operation_id': 'get_niaapi_version_regex_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_version_regex_by_moid
        )

        def __get_niaapi_version_regex_list(
            self,
            **kwargs
        ):
            """Read a 'niaapi.VersionRegex' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_niaapi_version_regex_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NiaapiVersionRegexResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_niaapi_version_regex_list = _Endpoint(
            settings={
                'response_type': (NiaapiVersionRegexResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/niaapi/VersionRegexes',
                'operation_id': 'get_niaapi_version_regex_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_niaapi_version_regex_list
        )
